/*
 * Decompiled with CFR 0.152.
 */
package net.minidev.ovh.api;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import net.minidev.ovh.api.docker.OvhSlave;
import net.minidev.ovh.api.docker.OvhStack;
import net.minidev.ovh.api.docker.framework.OvhPassword;
import net.minidev.ovh.api.docker.slave.OvhFlavor;
import net.minidev.ovh.api.docker.stack.OvhCustomSsl;
import net.minidev.ovh.api.docker.stack.OvhCustomSslMessage;
import net.minidev.ovh.api.docker.stack.OvhInputCustomSsl;
import net.minidev.ovh.api.docker.stack.OvhRegistryCredentials;
import net.minidev.ovh.api.services.OvhService;
import net.minidev.ovh.api.stack.OvhFramework;
import net.minidev.ovh.api.stack.framework.OvhApplication;
import net.minidev.ovh.core.ApiOvhBase;
import net.minidev.ovh.core.ApiOvhCore;

public class ApiOvhCaascontainers
extends ApiOvhBase {
    private static TypeReference<ArrayList<String>> t1 = new TypeReference<ArrayList<String>>(){};
    private static TypeReference<ArrayList<Long>> t2 = new TypeReference<ArrayList<Long>>(){};

    public ApiOvhCaascontainers(ApiOvhCore core) {
        super(core);
    }

    public OvhService serviceName_serviceInfos_GET(String serviceName) throws IOException {
        String qPath = "/caas/containers/{serviceName}/serviceInfos";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName});
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (OvhService)this.convertTo(resp, OvhService.class);
    }

    public void serviceName_serviceInfos_PUT(String serviceName, OvhService body) throws IOException {
        String qPath = "/caas/containers/{serviceName}/serviceInfos";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName});
        this.exec(qPath, "PUT", sb.toString(), body);
    }

    public OvhStack serviceName_GET(String serviceName) throws IOException {
        String qPath = "/caas/containers/{serviceName}";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName});
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (OvhStack)this.convertTo(resp, OvhStack.class);
    }

    public OvhCustomSslMessage serviceName_ssl_PUT(String serviceName, OvhInputCustomSsl body) throws IOException {
        String qPath = "/caas/containers/{serviceName}/ssl";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName});
        String resp = this.exec(qPath, "PUT", sb.toString(), body);
        return (OvhCustomSslMessage)this.convertTo(resp, OvhCustomSslMessage.class);
    }

    public OvhCustomSslMessage serviceName_ssl_DELETE(String serviceName) throws IOException {
        String qPath = "/caas/containers/{serviceName}/ssl";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName});
        String resp = this.exec(qPath, "DELETE", sb.toString(), null);
        return (OvhCustomSslMessage)this.convertTo(resp, OvhCustomSslMessage.class);
    }

    public OvhCustomSsl serviceName_ssl_GET(String serviceName) throws IOException {
        String qPath = "/caas/containers/{serviceName}/ssl";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName});
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (OvhCustomSsl)this.convertTo(resp, OvhCustomSsl.class);
    }

    public ArrayList<String> serviceName_slaves_GET(String serviceName) throws IOException {
        String qPath = "/caas/containers/{serviceName}/slaves";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName});
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (ArrayList)this.convertTo(resp, t1);
    }

    public OvhSlave serviceName_slaves_slaveId_GET(String serviceName, String slaveId) throws IOException {
        String qPath = "/caas/containers/{serviceName}/slaves/{slaveId}";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName, slaveId});
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (OvhSlave)this.convertTo(resp, OvhSlave.class);
    }

    public OvhRegistryCredentials serviceName_registry_credentials_POST(String serviceName, OvhInputCustomSsl body) throws IOException {
        String qPath = "/caas/containers/{serviceName}/registry/credentials";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName});
        String resp = this.exec(qPath, "POST", sb.toString(), body);
        return (OvhRegistryCredentials)this.convertTo(resp, OvhRegistryCredentials.class);
    }

    public ArrayList<String> serviceName_registry_credentials_GET(String serviceName) throws IOException {
        String qPath = "/caas/containers/{serviceName}/registry/credentials";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName});
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (ArrayList)this.convertTo(resp, t1);
    }

    public OvhRegistryCredentials serviceName_registry_credentials_credentialsId_PUT(String serviceName, String credentialsId, OvhInputCustomSsl body) throws IOException {
        String qPath = "/caas/containers/{serviceName}/registry/credentials/{credentialsId}";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName, credentialsId});
        String resp = this.exec(qPath, "PUT", sb.toString(), body);
        return (OvhRegistryCredentials)this.convertTo(resp, OvhRegistryCredentials.class);
    }

    public OvhRegistryCredentials serviceName_registry_credentials_credentialsId_GET(String serviceName, String credentialsId) throws IOException {
        String qPath = "/caas/containers/{serviceName}/registry/credentials/{credentialsId}";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName, credentialsId});
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (OvhRegistryCredentials)this.convertTo(resp, OvhRegistryCredentials.class);
    }

    public void serviceName_registry_credentials_credentialsId_DELETE(String serviceName, String credentialsId) throws IOException {
        String qPath = "/caas/containers/{serviceName}/registry/credentials/{credentialsId}";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName, credentialsId});
        this.exec(qPath, "DELETE", sb.toString(), null);
    }

    public ArrayList<String> serviceName_frameworks_GET(String serviceName) throws IOException {
        String qPath = "/caas/containers/{serviceName}/frameworks";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName});
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (ArrayList)this.convertTo(resp, t1);
    }

    public OvhFramework serviceName_frameworks_frameworkId_GET(String serviceName, String frameworkId) throws IOException {
        String qPath = "/caas/containers/{serviceName}/frameworks/{frameworkId}";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName, frameworkId});
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (OvhFramework)this.convertTo(resp, OvhFramework.class);
    }

    public void serviceName_frameworks_frameworkId_password_PUT(String serviceName, String frameworkId, OvhPassword body) throws IOException {
        String qPath = "/caas/containers/{serviceName}/frameworks/{frameworkId}/password";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName, frameworkId});
        this.exec(qPath, "PUT", sb.toString(), body);
    }

    public OvhApplication serviceName_frameworks_frameworkId_apps_GET(String serviceName, String frameworkId) throws IOException {
        String qPath = "/caas/containers/{serviceName}/frameworks/{frameworkId}/apps";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName, frameworkId});
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (OvhApplication)this.convertTo(resp, OvhApplication.class);
    }

    public ArrayList<Long> serviceName_changeContact_POST(String serviceName, String contactAdmin, String contactTech, String contactBilling) throws IOException {
        String qPath = "/caas/containers/{serviceName}/changeContact";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName});
        HashMap o = new HashMap();
        this.addBody(o, "contactAdmin", contactAdmin);
        this.addBody(o, "contactTech", contactTech);
        this.addBody(o, "contactBilling", contactBilling);
        String resp = this.exec(qPath, "POST", sb.toString(), o);
        return (ArrayList)this.convertTo(resp, t2);
    }

    public ArrayList<String> serviceName_availableFrameworks_GET(String serviceName) throws IOException {
        String qPath = "/caas/containers/{serviceName}/availableFrameworks";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName});
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (ArrayList)this.convertTo(resp, t1);
    }

    public ArrayList<String> GET() throws IOException {
        String qPath = "/caas/containers";
        StringBuilder sb = this.path(qPath, new Object[0]);
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (ArrayList)this.convertTo(resp, t1);
    }

    public ArrayList<String> slaves_flavors_GET() throws IOException {
        String qPath = "/caas/containers/slaves/flavors";
        StringBuilder sb = this.path(qPath, new Object[0]);
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (ArrayList)this.convertTo(resp, t1);
    }

    public OvhFlavor slaves_flavors_flavorId_GET(String flavorId) throws IOException {
        String qPath = "/caas/containers/slaves/flavors/{flavorId}";
        StringBuilder sb = this.path(qPath, new Object[]{flavorId});
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (OvhFlavor)this.convertTo(resp, OvhFlavor.class);
    }
}

