/*
 * Decompiled with CFR 0.152.
 */
package net.leadware.persistence.tools.api.validator.jsr303ext;

import java.util.regex.Pattern;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import net.leadware.persistence.tools.api.validator.jsr303ext.annotations.Email;

public class EmailRule
implements ConstraintValidator<Email, String> {
    private static String ATOM = "[^\\x00-\\x1F^\\(^\\)^\\<^\\>^\\@^\\,^\\;^\\:^\\\\^\\\"^\\.^\\[^\\]^\\s]";
    private static String DOMAIN = "(" + ATOM + "+(\\." + ATOM + "+)*";
    private static String IP_DOMAIN = "\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\]";
    private boolean matchOnEmpty = true;
    private Pattern pattern = null;

    public void initialize(Email email) {
        this.matchOnEmpty = email.matchOnEmpty();
        this.pattern = Pattern.compile("^" + ATOM + "+(\\." + ATOM + "+)*@" + DOMAIN + "|" + IP_DOMAIN + ")$", 2);
    }

    public boolean isValid(String value, ConstraintValidatorContext constraintContext) {
        if (value == null) {
            return this.matchOnEmpty;
        }
        if (!(value instanceof String)) {
            return false;
        }
        String stringValue = value;
        if (stringValue == null || stringValue.length() == 0) {
            return this.matchOnEmpty;
        }
        return this.pattern.matcher(stringValue).matches();
    }
}

