/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.args4j.spi;

import java.util.ArrayList;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Parameters;
import org.kohsuke.args4j.spi.Setter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringArrayOptionHandler
extends OptionHandler<String[]> {
    public StringArrayOptionHandler(CmdLineParser parser2, OptionDef option, Setter<? super String[]> setter) {
        super(parser2, option, setter);
    }

    @Override
    public String getDefaultMetaVariable() {
        return "STRING[]";
    }

    @Override
    public int parseArguments(Parameters params) throws CmdLineException {
        int counter = 0;
        ArrayList<String> values = new ArrayList<String>();
        while (true) {
            String param;
            try {
                param = params.getParameter(counter);
            }
            catch (CmdLineException ex) {
                break;
            }
            if (param.startsWith("-")) break;
            for (String str : param.split(" ")) {
                values.add(str);
            }
            ++counter;
        }
        Setter s = this.setter;
        s.addValue(values.toArray(new String[values.size()]));
        return counter;
    }
}

