/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.cli;

import net.jangaroo.jooc.cli.AbstractCommandLineParser;
import net.jangaroo.jooc.cli.CommandLineParseException;
import net.jangaroo.jooc.config.JoocConfiguration;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;

public class JoocCommandLineParser
extends AbstractCommandLineParser {
    private void printVersion() {
        String pkgName = "net.jangaroo.jooc";
        Package pkg = Package.getPackage(pkgName);
        String specTitle = pkg.getSpecificationTitle();
        if (specTitle == null) {
            System.out.println("cannot retrieve package version information for " + pkgName);
            return;
        }
        String specVendor = pkg.getSpecificationVendor();
        String specVersion = pkg.getSpecificationVersion();
        String implTitle = pkg.getImplementationTitle();
        String implVersion = pkg.getImplementationVersion();
        System.out.println(specTitle + " version " + specVersion);
        System.out.println(implTitle + " (build " + implVersion + ")");
        System.out.println(specVendor);
    }

    @Override
    public String getShellScriptName() {
        return "jooc";
    }

    public JoocConfiguration parseConfig(CmdLineParser parser2, JoocConfiguration config) {
        if (config.isHelp()) {
            System.out.println(this.extendedUsage(parser2, null));
            return null;
        }
        if (config.isVersion()) {
            this.printVersion();
            return null;
        }
        if (config.getOutputDirectory() == null) {
            System.out.println(this.extendedUsage(parser2, null));
            return null;
        }
        if (!config.getOutputDirectory().exists()) {
            throw new IllegalArgumentException("destination directory does not exist: " + config.getOutputDirectory().getAbsolutePath());
        }
        if (config.getApiOutputDirectory() != null && !config.getApiOutputDirectory().exists()) {
            throw new IllegalArgumentException("destination directory for API stubs does not exist: " + config.getApiOutputDirectory().getAbsolutePath());
        }
        if (config.isVerbose()) {
            System.out.println("-genarateapi: " + config.isGenerateApi());
            System.out.println("-g option values:");
            System.out.println("debugMode=" + (Object)((Object)config.getDebugMode()));
        }
        return config;
    }

    public JoocConfiguration parse(String[] args) throws CommandLineParseException {
        JoocConfiguration config = new JoocConfiguration();
        CmdLineParser parser2 = new CmdLineParser(config);
        try {
            parser2.parseArgument(args);
        }
        catch (CmdLineException e) {
            StringBuilder msg = this.extendedUsage(parser2, e);
            throw new CommandLineParseException(msg.toString(), -1);
        }
        return this.parseConfig(parser2, config);
    }
}

