/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.ast;

import java.io.IOException;
import java.util.List;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.AstVisitor;
import net.jangaroo.jooc.ast.Expr;
import net.jangaroo.jooc.ast.KeywordStatement;
import net.jangaroo.jooc.ast.Statement;

public class IfStatement
extends KeywordStatement {
    private Expr cond;
    private Statement ifTrue;
    private JooSymbol symElse;
    private Statement ifFalse;

    public IfStatement(JooSymbol symIf, Expr cond, Statement ifTrue) {
        this(symIf, cond, ifTrue, null, null);
    }

    public IfStatement(JooSymbol symIf, Expr cond, Statement ifTrue, JooSymbol symElse, Statement ifFalse) {
        super(symIf);
        this.cond = cond;
        this.ifTrue = ifTrue;
        this.symElse = symElse;
        this.ifFalse = ifFalse;
    }

    @Override
    public List<? extends AstNode> getChildren() {
        return this.makeChildren(super.getChildren(), this.cond, this.ifTrue, this.ifFalse);
    }

    @Override
    public void visit(AstVisitor visitor) throws IOException {
        visitor.visitIfStatement(this);
    }

    @Override
    public void scope(Scope scope) {
        this.getCond().scope(scope);
        this.getIfTrue().scope(scope);
        if (this.getIfFalse() != null) {
            this.getIfFalse().scope(scope);
        }
    }

    @Override
    public void analyze(AstNode parentNode) {
        super.analyze(parentNode);
        this.getCond().analyze(this);
        this.getIfTrue().analyze(this);
        if (this.getIfFalse() != null) {
            this.getIfFalse().analyze(this);
        }
    }

    public Expr getCond() {
        return this.cond;
    }

    public Statement getIfTrue() {
        return this.ifTrue;
    }

    public JooSymbol getSymElse() {
        return this.symElse;
    }

    public Statement getIfFalse() {
        return this.ifFalse;
    }
}

