/*
 * Decompiled with CFR 0.152.
 */
package net.itransformers.expect4java.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import net.itransformers.expect4java.Closure;
import net.itransformers.expect4java.Expect4j;
import net.itransformers.expect4java.TimeoutException;
import net.itransformers.expect4java.cliconnection.CLIConnection;
import net.itransformers.expect4java.impl.Expect4jException;
import net.itransformers.expect4java.impl.ExpectContextImpl;
import net.itransformers.expect4java.matches.EofMatch;
import net.itransformers.expect4java.matches.Match;
import net.itransformers.expect4java.matches.RegExpMatch;
import net.itransformers.expect4java.matches.TimeoutMatch;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Perl5Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Expect4jImpl
implements Expect4j,
Runnable {
    public static final long DEFAULT_TIMEOUT = 1000L;
    private final Reader reader;
    private final Writer writer;
    private TimeoutMatch defaultTimeoutMatch = new TimeoutMatch(1000L);
    StringBuffer buffer = new StringBuffer(256);
    boolean eofFound = false;
    boolean finished = false;
    Logger logger = LoggerFactory.getLogger(Expect4jImpl.class);

    public Expect4jImpl(CLIConnection cliConnection) throws Expect4jException {
        InputStream is = cliConnection.inputStream();
        OutputStream os = cliConnection.outputStream();
        if (is == null) {
            throw new Expect4jException("The input stream in the connection is null");
        }
        if (os == null) {
            throw new Expect4jException("The output stream in the connection is null");
        }
        this.reader = new InputStreamReader(is);
        this.writer = new OutputStreamWriter(os);
        this.init();
    }

    public Expect4jImpl(Reader reader, Writer writer) {
        this.reader = reader;
        this.writer = writer;
        this.init();
    }

    private void init() {
        Thread consumerThread = new Thread(this);
        consumerThread.start();
    }

    @Override
    public void send(String str) throws IOException {
        this.writer.write(str);
        this.writer.flush();
    }

    @Override
    public int expect(Match match) {
        return this.expect(new Match[]{match});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int expect(Match[] matches) throws TimeoutException {
        if (matches == null) throw new IllegalArgumentException("Input argument cannot be null or zero length.");
        if (matches.length == 0) {
            throw new IllegalArgumentException("Input argument cannot be null or zero length.");
        }
        StopWatch stopWatch = new StopWatch();
        this.logger.debug("Watch started...");
        stopWatch.start();
        Perl5Matcher matcher = new Perl5Matcher();
        while (true) {
            block14: {
                Expect4jImpl expect4jImpl = this;
                synchronized (expect4jImpl) {
                    int i;
                    boolean hasMatch = false;
                    ExpectContextImpl expectContext = null;
                    for (i = 0; i < matches.length; ++i) {
                        if (matches[i] instanceof RegExpMatch) {
                            RegExpMatch regExpMatch = (RegExpMatch)matches[i];
                            this.logger.debug("Checking match No: " + i + ", " + regExpMatch.toString().replace("\r", "[\\r]").replace("\n", "\\n"));
                            String input = this.buffer.toString();
                            this.logger.debug("Input: " + input.replace("\r", "[\\r]").replace("\n", "\\n"));
                            if (!matcher.contains(input, regExpMatch.getPattern())) continue;
                            MatchResult result = matcher.getMatch();
                            this.buffer = new StringBuffer();
                            this.buffer.append(input.substring(result.beginOffset(0) + result.end(0)));
                            this.logger.debug("Matched! Invoking match closure...");
                            expectContext = this.invokeClosure(regExpMatch, input, result);
                            hasMatch = true;
                            break;
                        }
                        if (!(matches[i] instanceof EofMatch)) continue;
                        this.logger.debug("Checking match No: " + i + ", EofMatch");
                        if (!this.eofFound) continue;
                        this.logger.debug("EOF found! Invoking match closure...");
                        EofMatch eofMatch = (EofMatch)matches[i];
                        expectContext = this.invokeClosure(eofMatch, this.buffer.toString(), null);
                        hasMatch = true;
                        break;
                    }
                    if (!hasMatch) {
                        TimeoutMatch timeoutMatch = this.findTimeoutMatch(matches);
                        long deltaTime = timeoutMatch.getTimeout() - stopWatch.getTime();
                        this.logger.debug("First pass no match found. Delta time=" + deltaTime);
                        if (deltaTime <= 0L) {
                            if (timeoutMatch.getClosure() == null) {
                                throw new TimeoutException("Expect timeouted, while expecting: " + this.matchesToDump(matches) + " input buffer:" + this.buffer.toString());
                            }
                            this.logger.debug("Timeout exceeded. Invoking timeout closure");
                            expectContext = this.invokeClosure(timeoutMatch, this.buffer.toString(), null);
                            this.logger.debug("exp_continue: " + expectContext.isExpContinue() + ", reset_timer: " + expectContext.isResetTimer());
                            if (expectContext.isExpContinue() && expectContext.isResetTimer()) {
                                this.logger.debug("Resetting stopWatch");
                                stopWatch.reset();
                                break block14;
                            } else {
                                this.logger.debug("Exit expect method due to timeout");
                                return i;
                            }
                        }
                        this.logger.debug("wait for input for " + deltaTime + " ms");
                        this.waitForInput(deltaTime);
                    } else {
                        this.logger.debug("First pass no match found. ");
                        this.logger.debug("exp_continue: " + expectContext.isExpContinue() + ", reset_timer: " + expectContext.isResetTimer());
                        if (!expectContext.isExpContinue()) {
                            this.logger.debug("Exit expect method due to exp_continue=false");
                            return i;
                        }
                        if (expectContext.isResetTimer()) {
                            this.logger.debug("Resetting stopWatch");
                            stopWatch.reset();
                        }
                        this.logger.debug("continue expect method due to exp_continue=true");
                    }
                }
            }
        }
    }

    private synchronized void waitForInput(Long timeout) {
        try {
            this.wait(timeout);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private TimeoutMatch findTimeoutMatch(Match[] matches) {
        for (Match match : matches) {
            if (!(match instanceof TimeoutMatch)) continue;
            return (TimeoutMatch)match;
        }
        return this.defaultTimeoutMatch;
    }

    private ExpectContextImpl invokeClosure(Match match, String input, MatchResult result) {
        ExpectContextImpl expectContext;
        try {
            expectContext = new ExpectContextImpl(result, input);
            Closure closure = match.getClosure();
            if (closure != null) {
                closure.run(expectContext);
            } else {
                this.logger.debug("No closure defined for this match. Skipping call it");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return expectContext;
    }

    @Override
    public void setTimeout(TimeoutMatch timeoutMatch) {
        if (timeoutMatch == null) {
            throw new IllegalArgumentException("Default timeout cannot be null.");
        }
        this.defaultTimeoutMatch = timeoutMatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (!this.finished) {
                char[] cs = new char[256];
                int size = this.reader.read(cs);
                Expect4jImpl expect4jImpl = this;
                synchronized (expect4jImpl) {
                    if (size == -1) {
                        this.eofFound = true;
                        return;
                    }
                    this.buffer.append(cs, 0, size);
                    this.notifyAll();
                }
            }
            return;
        }
        catch (IOException e) {
            this.logger.debug("IO Error in run method", (Throwable)e);
        }
    }

    @Override
    public void close() {
        this.finished = true;
    }

    private String matchesToDump(Match[] matches) {
        StringBuilder sb = new StringBuilder();
        for (Match match : matches) {
            sb.append(match.toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public Reader getReader() {
        return this.reader;
    }

    @Override
    public Writer getWriter() {
        return this.writer;
    }
}

