/*
 * Decompiled with CFR 0.152.
 */
package net.itransformers.expect4java.cliconnection.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import net.itransformers.expect4java.cliconnection.CLIConnection;
import org.apache.commons.net.telnet.TelnetClient;

public class TelnetCLIConnection
implements CLIConnection {
    protected TelnetClient telnet = new TelnetClient();

    @Override
    public void connect(Map<String, Object> params) throws IOException {
        try {
            if (!params.containsKey("port")) {
                throw new IllegalArgumentException("no port parameter is specified");
            }
            Integer port = null;
            Object portObj = params.get("port");
            if (portObj instanceof String) {
                port = Integer.parseInt((String)portObj);
            } else if (portObj instanceof Integer) {
                port = (Integer)portObj;
            } else {
                throw new IllegalArgumentException("Port parameter should be Integer or String: " + portObj);
            }
            this.telnet.connect((String)params.get("address"), port.intValue());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.telnet.setDefaultTimeout(2000);
    }

    @Override
    public void disconnect() throws IOException {
        this.telnet.disconnect();
    }

    @Override
    public InputStream inputStream() {
        return this.telnet.getInputStream();
    }

    @Override
    public OutputStream outputStream() {
        return this.telnet.getOutputStream();
    }
}

