/*
 * Decompiled with CFR 0.152.
 */
package org.tio.websocket.common;

import java.nio.ByteBuffer;
import org.tio.utils.buffer.ByteBufferUtil;
import org.tio.websocket.common.WsResponse;

public class WsServerEncoder {
    private WsServerEncoder() {
    }

    public static ByteBuffer encode(WsResponse wsResponse) {
        ByteBuffer buf;
        byte[] wsBody = wsResponse.getBody();
        byte[][] wsBodies = wsResponse.getBodys();
        int wsBodyLength = 0;
        if (wsBody != null) {
            wsBodyLength += wsBody.length;
        } else if (wsBodies != null) {
            for (byte[] bs : wsBodies) {
                wsBodyLength += bs.length;
            }
        }
        byte header0 = (byte)(0x8F & (wsResponse.getWsOpcode().getCode() | 0xF0));
        if (wsBodyLength < 126) {
            buf = ByteBuffer.allocate(2 + wsBodyLength);
            buf.put(header0);
            buf.put((byte)wsBodyLength);
        } else if (wsBodyLength < 65535) {
            buf = ByteBuffer.allocate(4 + wsBodyLength);
            buf.put(header0);
            buf.put((byte)126);
            ByteBufferUtil.writeShortBE((ByteBuffer)buf, (int)wsBodyLength);
        } else {
            buf = ByteBuffer.allocate(10 + wsBodyLength);
            buf.put(header0);
            buf.put((byte)127);
            buf.position(buf.position() + 4);
            ByteBufferUtil.writeIntBE((ByteBuffer)buf, (long)wsBodyLength);
        }
        if (wsBody != null && wsBody.length > 0) {
            buf.put(wsBody);
        } else if (wsBodies != null) {
            for (byte[] bs : wsBodies) {
                buf.put(bs);
            }
        }
        return buf;
    }
}

