/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.model;

import com.google.common.reflect.TypeToken;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.test.AssertionsKt;
import net.corda.serialization.internal.model.TypeIdentifier;
import org.jetbrains.annotations.NotNull;
import org.junit.Test;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\u0018\u00002\u00020\u0001:\u0002\u0013\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0019\u0010\u0003\u001a\u00020\u0004\"\u0006\b\u0000\u0010\t\u0018\u00012\u0006\u0010\u0007\u001a\u00020\bH\u0082\bJ\u0011\u0010\n\u001a\u00020\u0004\"\u0006\b\u0000\u0010\t\u0018\u0001H\u0082\bJ\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\b\u0010\f\u001a\u00020\u0004H\u0007J\b\u0010\r\u001a\u00020\u0004H\u0007J\b\u0010\u000e\u001a\u00020\u0004H\u0007J\b\u0010\u000f\u001a\u00020\u0004H\u0007J\b\u0010\u0010\u001a\u00020\u0004H\u0007J\u0019\u0010\u0011\u001a\n \u0012*\u0004\u0018\u00010\u00060\u0006\"\u0006\b\u0000\u0010\t\u0018\u0001H\u0082\b\u00a8\u0006\u0015"}, d2={"Lnet/corda/serialization/internal/model/TypeIdentifierTests;", "", "()V", "assertIdentified", "", "type", "Ljava/lang/reflect/Type;", "expected", "", "T", "assertRoundtrips", "original", "erased and unerased", "nested parameterised", "primitive types and arrays", "resolved against an owning type", "roundtrip", "typeOf", "kotlin.jvm.PlatformType", "HasArray", "HasStringArray", "serialization"})
public final class TypeIdentifierTests {
    @Test(timeout=300000L)
    public final void primitive types and arrays() {
        Type type2;
        TypeIdentifierTests this_$iv;
        Class<Integer> clazz = Integer.TYPE;
        if (clazz == null) {
            Intrinsics.throwNpe();
        }
        this.assertIdentified(clazz, "int");
        TypeIdentifierTests typeIdentifierTests = this;
        String expected$iv = "Integer";
        void var3_3 = this_$iv;
        TypeIdentifier.Companion companion = TypeIdentifier.Companion;
        String string = expected$iv;
        Type type3 = type2 = new TypeToken<Integer>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"typeOf<T>()");
        AssertionsKt.assertEquals$default((Object)string, (Object)TypeIdentifier.prettyPrint$default((TypeIdentifier)TypeIdentifier.Companion.forGenericType$default((TypeIdentifier.Companion)companion, (Type)type3, null, (int)2, null), (boolean)false, (int)1, null), null, (int)4, null);
        this_$iv = this;
        expected$iv = "int[]";
        TypeIdentifierTests this_$iv$iv = this_$iv;
        companion = TypeIdentifier.Companion;
        string = expected$iv;
        Type type4 = type2 = new TypeToken<int[]>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type4, (String)"typeOf<T>()");
        AssertionsKt.assertEquals$default((Object)string, (Object)TypeIdentifier.prettyPrint$default((TypeIdentifier)TypeIdentifier.Companion.forGenericType$default((TypeIdentifier.Companion)companion, (Type)type4, null, (int)2, null), (boolean)false, (int)1, null), null, (int)4, null);
        this_$iv = this;
        expected$iv = "Integer[]";
        this_$iv$iv = this_$iv;
        companion = TypeIdentifier.Companion;
        string = expected$iv;
        Type type5 = type2 = new TypeToken<Integer[]>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type5, (String)"typeOf<T>()");
        AssertionsKt.assertEquals$default((Object)string, (Object)TypeIdentifier.prettyPrint$default((TypeIdentifier)TypeIdentifier.Companion.forGenericType$default((TypeIdentifier.Companion)companion, (Type)type5, null, (int)2, null), (boolean)false, (int)1, null), null, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void erased and unerased() {
        Type type2;
        void this_$iv;
        this.assertIdentified((Type)((Object)List.class), "List (erased)");
        TypeIdentifierTests typeIdentifierTests = this;
        String expected$iv = "List<Integer>";
        void var3_3 = this_$iv;
        TypeIdentifier.Companion companion = TypeIdentifier.Companion;
        String string = expected$iv;
        Type type3 = type2 = new TypeToken<List<? extends Integer>>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"typeOf<T>()");
        AssertionsKt.assertEquals$default((Object)string, (Object)TypeIdentifier.prettyPrint$default((TypeIdentifier)TypeIdentifier.Companion.forGenericType$default((TypeIdentifier.Companion)companion, (Type)type3, null, (int)2, null), (boolean)false, (int)1, null), null, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void nested parameterised() {
        Type type2;
        void this_$iv;
        TypeIdentifierTests typeIdentifierTests = this;
        String expected$iv = "List<List<Integer>>";
        void var3_3 = this_$iv;
        TypeIdentifier.Companion companion = TypeIdentifier.Companion;
        String string = expected$iv;
        Type type3 = type2 = new TypeToken<List<? extends List<? extends Integer>>>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"typeOf<T>()");
        AssertionsKt.assertEquals$default((Object)string, (Object)TypeIdentifier.prettyPrint$default((TypeIdentifier)TypeIdentifier.Companion.forGenericType$default((TypeIdentifier.Companion)companion, (Type)type3, null, (int)2, null), (boolean)false, (int)1, null), null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void resolved against an owning type() {
        Type fieldType;
        Method method = HasArray.class.getDeclaredMethod("getArray", new Class[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)method, (String)"HasArray::class.java.getDeclaredMethod(\"getArray\")");
        Type type2 = fieldType = method.getGenericReturnType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"fieldType");
        this.assertIdentified(type2, "List<*>[]");
        AssertionsKt.assertEquals$default((Object)"List<String>[]", (Object)TypeIdentifier.prettyPrint$default((TypeIdentifier)TypeIdentifier.Companion.forGenericType(fieldType, (Type)((Object)HasStringArray.class)), (boolean)false, (int)1, null), null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void roundtrip() {
        Type type2;
        TypeIdentifierTests this_$iv;
        Class<Integer> clazz = Integer.TYPE;
        if (clazz == null) {
            Intrinsics.throwNpe();
        }
        this.assertRoundtrips(clazz);
        TypeIdentifierTests this_$iv$iv = this_$iv = this;
        TypeIdentifierTests typeIdentifierTests = this_$iv;
        Type type3 = type2 = new TypeToken<Integer>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"typeOf<T>()");
        typeIdentifierTests.assertRoundtrips(type3);
        this_$iv$iv = this_$iv = this;
        typeIdentifierTests = this_$iv;
        Type type4 = type2 = new TypeToken<int[]>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type4, (String)"typeOf<T>()");
        typeIdentifierTests.assertRoundtrips(type4);
        this.assertRoundtrips((Type)((Object)List.class));
        this_$iv$iv = this_$iv = this;
        typeIdentifierTests = this_$iv;
        Type type5 = type2 = new TypeToken<List<? extends String>>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type5, (String)"typeOf<T>()");
        typeIdentifierTests.assertRoundtrips(type5);
        this_$iv$iv = this_$iv = this;
        typeIdentifierTests = this_$iv;
        Type type6 = type2 = new TypeToken<List<? extends String>[]>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type6, (String)"typeOf<T>()");
        typeIdentifierTests.assertRoundtrips(type6);
        this_$iv$iv = this_$iv = this;
        typeIdentifierTests = this_$iv;
        Type type7 = type2 = new TypeToken<HasStringArray>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type7, (String)"typeOf<T>()");
        typeIdentifierTests.assertRoundtrips(type7);
        this.assertRoundtrips((Type)((Object)HasArray.class));
        this_$iv$iv = this_$iv = this;
        typeIdentifierTests = this_$iv;
        Type type8 = type2 = new TypeToken<HasArray<String>>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type8, (String)"typeOf<T>()");
        typeIdentifierTests.assertRoundtrips(type8);
    }

    private final void assertIdentified(Type type2, String expected) {
        AssertionsKt.assertEquals$default((Object)expected, (Object)TypeIdentifier.prettyPrint$default((TypeIdentifier)TypeIdentifier.Companion.forGenericType$default((TypeIdentifier.Companion)TypeIdentifier.Companion, (Type)type2, null, (int)2, null), (boolean)false, (int)1, null), null, (int)4, null);
    }

    private final <T> void assertIdentified(String expected) {
        Type type2;
        TypeIdentifierTests typeIdentifierTests = this;
        TypeIdentifier.Companion companion = TypeIdentifier.Companion;
        String string = expected;
        Intrinsics.needClassReification();
        Type type3 = type2 = new TypeToken<T>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"typeOf<T>()");
        AssertionsKt.assertEquals$default((Object)string, (Object)TypeIdentifier.prettyPrint$default((TypeIdentifier)TypeIdentifier.Companion.forGenericType$default((TypeIdentifier.Companion)companion, (Type)type3, null, (int)2, null), (boolean)false, (int)1, null), null, (int)4, null);
    }

    private final <T> Type typeOf() {
        Intrinsics.needClassReification();
        return new TypeToken<T>(){}.getType();
    }

    private final <T> void assertRoundtrips() {
        Type type2;
        TypeIdentifierTests typeIdentifierTests = this;
        TypeIdentifierTests typeIdentifierTests2 = this;
        Intrinsics.needClassReification();
        Type type3 = type2 = new TypeToken<T>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"typeOf<T>()");
        typeIdentifierTests2.assertRoundtrips(type3);
    }

    private final void assertRoundtrips(Type original) {
        TypeIdentifier identifier = TypeIdentifier.Companion.forGenericType$default((TypeIdentifier.Companion)TypeIdentifier.Companion, (Type)original, null, (int)2, null);
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        Intrinsics.checkExpressionValueIsNotNull((Object)classLoader, (String)"ClassLoader.getSystemClassLoader()");
        Type localType = identifier.getLocalType(classLoader);
        this.assertIdentified(localType, TypeIdentifier.prettyPrint$default((TypeIdentifier)identifier, (boolean)false, (int)1, null));
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010 \n\u0002\b\u0003\bf\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002R \u0010\u0003\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lnet/corda/serialization/internal/model/TypeIdentifierTests$HasArray;", "T", "", "array", "", "", "getArray", "()[Ljava/util/List;", "serialization"})
    public static interface HasArray<T> {
        @NotNull
        public List<T>[] getArray();
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010 \n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\u0014\u0010\u0003\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006R$\u0010\u0003\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u00020\u00050\u0004X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\n"}, d2={"Lnet/corda/serialization/internal/model/TypeIdentifierTests$HasStringArray;", "Lnet/corda/serialization/internal/model/TypeIdentifierTests$HasArray;", "", "array", "", "", "([Ljava/util/List;)V", "getArray", "()[Ljava/util/List;", "[Ljava/util/List;", "serialization"})
    public static final class HasStringArray
    implements HasArray<String> {
        @NotNull
        private final List<String>[] array;

        @Override
        @NotNull
        public List<String>[] getArray() {
            return this.array;
        }

        public HasStringArray(@NotNull List<String>[] array) {
            Intrinsics.checkParameterIsNotNull(array, (String)"array");
            this.array = array;
        }
    }
}

