/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.model;

import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.corda.core.serialization.ClassWhitelist;
import net.corda.core.serialization.SerializableCalculatedProperty;
import net.corda.serialization.internal.AllWhitelist;
import net.corda.serialization.internal.amqp.AMQPSerializer;
import net.corda.serialization.internal.amqp.CachingCustomSerializerRegistry;
import net.corda.serialization.internal.amqp.CorDappCustomSerializer;
import net.corda.serialization.internal.amqp.CustomSerializer;
import net.corda.serialization.internal.amqp.CustomSerializerRegistry;
import net.corda.serialization.internal.amqp.DefaultDescriptorBasedSerializerRegistry;
import net.corda.serialization.internal.amqp.DescriptorBasedSerializerRegistry;
import net.corda.serialization.internal.amqp.WhitelistBasedTypeModelConfiguration;
import net.corda.serialization.internal.model.ConfigurableLocalTypeModel;
import net.corda.serialization.internal.model.LocalTypeInformation;
import net.corda.serialization.internal.model.LocalTypeModelConfiguration;
import net.corda.serialization.internal.model.LocalTypeModelTests;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;
import org.junit.Test;
import org.junit.jupiter.api.AssertionsKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000?\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0012*\u0001\b\u0018\u00002\u00020\u0001:\u0011\u001d\u001e\u001f !\"#$%&'()*+,-B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\u000eH\u0007J\u0019\u0010\u000f\u001a\u00020\u000e\"\u0006\b\u0000\u0010\u0010\u0018\u00012\u0006\u0010\u0011\u001a\u00020\u0012H\u0082\bJ\b\u0010\u0013\u001a\u00020\u000eH\u0007J\b\u0010\u0014\u001a\u00020\u000eH\u0007J\b\u0010\u0015\u001a\u00020\u000eH\u0007J\b\u0010\u0016\u001a\u00020\u000eH\u0007J\b\u0010\u0017\u001a\u00020\u000eH\u0007J\u0011\u0010\u0018\u001a\u00020\u000e\"\u0006\b\u0000\u0010\u0010\u0018\u0001H\u0082\bJ\b\u0010\u0019\u001a\u00020\u000eH\u0007J\b\u0010\u001a\u001a\u00020\u000eH\u0007J\u0011\u0010\u001b\u001a\u00020\u001c\"\u0006\b\u0000\u0010\u0010\u0018\u0001H\u0082\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lnet/corda/serialization/internal/model/LocalTypeModelTests;", "", "()V", "customSerializerRegistry", "Lnet/corda/serialization/internal/amqp/CustomSerializerRegistry;", "descriptorBasedSerializerRegistry", "Lnet/corda/serialization/internal/amqp/DefaultDescriptorBasedSerializerRegistry;", "emptyCustomSerializerRegistry", "net/corda/serialization/internal/model/LocalTypeModelTests$emptyCustomSerializerRegistry$1", "Lnet/corda/serialization/internal/model/LocalTypeModelTests$emptyCustomSerializerRegistry$1;", "model", "Lnet/corda/serialization/internal/model/ConfigurableLocalTypeModel;", "modelWithoutOpacity", "Primitives and collections", "", "assertInformation", "T", "expected", "", "calculated properties aliased by fields in implementing classes", "getter setter and calculated properties", "interfaces and superclasses", "missing constructor parameters creates non-composable type", "no unique deserialization constructor creates non-composable type", "printInformation", "test type information for customised enum", "transitive types are non-composable creates non-composable type", "typeOf", "Ljava/lang/reflect/Type;", "Abstract", "AliasingOldStylePojoImpl", "AnotherTransitivelyNonComposable", "CollectionHolder", "Concrete", "CustomEnum", "MissingConstructorParameter", "Nested", "NonComposableNested", "OldStylePojo", "OldStylePojoImpl", "OneMoreTransitivelyNonComposable", "StringCollectionHolder", "StringKeyedCollectionHolder", "Super", "SuperSuper", "TransitivelyNonComposable", "serialization"})
public final class LocalTypeModelTests {
    private final DefaultDescriptorBasedSerializerRegistry descriptorBasedSerializerRegistry = new DefaultDescriptorBasedSerializerRegistry();
    private final CustomSerializerRegistry customSerializerRegistry = (CustomSerializerRegistry)new CachingCustomSerializerRegistry((DescriptorBasedSerializerRegistry)this.descriptorBasedSerializerRegistry);
    private final ConfigurableLocalTypeModel model = new ConfigurableLocalTypeModel((LocalTypeModelConfiguration)new WhitelistBasedTypeModelConfiguration((ClassWhitelist)AllWhitelist.INSTANCE, this.customSerializerRegistry));
    private final emptyCustomSerializerRegistry.1 emptyCustomSerializerRegistry = new CustomSerializerRegistry(){
        @NotNull
        private final List<String> customSerializerNames;

        @NotNull
        public List<String> getCustomSerializerNames() {
            return this.customSerializerNames;
        }

        public void register(@NotNull CustomSerializer<? extends Object> customSerializer) {
            Intrinsics.checkParameterIsNotNull(customSerializer, (String)"customSerializer");
        }

        public void registerExternal(@NotNull CorDappCustomSerializer customSerializer) {
            Intrinsics.checkParameterIsNotNull((Object)customSerializer, (String)"customSerializer");
        }

        @Nullable
        public AMQPSerializer<Object> findCustomSerializer(@NotNull Class<?> clazz, @NotNull Type declaredType) {
            Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
            Intrinsics.checkParameterIsNotNull((Object)declaredType, (String)"declaredType");
            return null;
        }
        {
            this.customSerializerNames = CollectionsKt.emptyList();
        }
    };
    private final ConfigurableLocalTypeModel modelWithoutOpacity = new ConfigurableLocalTypeModel((LocalTypeModelConfiguration)new WhitelistBasedTypeModelConfiguration((ClassWhitelist)AllWhitelist.INSTANCE, (CustomSerializerRegistry)this.emptyCustomSerializerRegistry));

    @Test(timeout=300000L)
    public final void Primitives and collections() {
        LocalTypeModelTests this_$iv;
        LocalTypeModelTests localTypeModelTests = this;
        String expected$iv = "CollectionHolder<UUID, String>";
        void var3_3 = this_$iv;
        ConfigurableLocalTypeModel configurableLocalTypeModel = this_$iv.model;
        String string = StringsKt.trimIndent((String)expected$iv);
        Type type2 = new TypeToken<CollectionHolder<UUID, String>>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"object : TypeToken<T>() {}.type");
        Type type3 = type2;
        Assert.assertEquals((Object)string, (Object)LocalTypeInformation.prettyPrint$default((LocalTypeInformation)configurableLocalTypeModel.inspect(type3), (boolean)false, (int)1, null));
        this_$iv = this;
        expected$iv = "\n            StringKeyedCollectionHolder<Integer>(list: List<Integer>, map: Map<String, Integer>, array: List<Integer>[]): CollectionHolder<String, Integer>\n              array: List<Integer>[]\n              list: List<Integer>\n              map: Map<String, Integer>\n         ";
        LocalTypeModelTests this_$iv$iv = this_$iv;
        configurableLocalTypeModel = this_$iv.model;
        string = StringsKt.trimIndent((String)expected$iv);
        Type type4 = new TypeToken<StringKeyedCollectionHolder<Integer>>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type4, (String)"object : TypeToken<T>() {}.type");
        type3 = type4;
        Assert.assertEquals((Object)string, (Object)LocalTypeInformation.prettyPrint$default((LocalTypeInformation)configurableLocalTypeModel.inspect(type3), (boolean)false, (int)1, null));
        this_$iv = this;
        expected$iv = "\n            StringCollectionHolder(list: List<String>, map: Map<String, String>, array: List<String>[]): StringKeyedCollectionHolder<String>, CollectionHolder<String, String>\n              array: List<String>[]\n              list: List<String>\n              map: Map<String, String>\n        ";
        this_$iv$iv = this_$iv;
        configurableLocalTypeModel = this_$iv.model;
        string = StringsKt.trimIndent((String)expected$iv);
        Type type5 = new TypeToken<StringCollectionHolder>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type5, (String)"object : TypeToken<T>() {}.type");
        type3 = type5;
        Assert.assertEquals((Object)string, (Object)LocalTypeInformation.prettyPrint$default((LocalTypeInformation)configurableLocalTypeModel.inspect(type3), (boolean)false, (int)1, null));
        this_$iv = this;
        expected$iv = "\n            Nested(collectionHolder: StringKeyedCollectionHolder<Integer>?, intArray: int[], optionalParam: Short?)\n              collectionHolder (optional): StringKeyedCollectionHolder<Integer>(list: List<Integer>, map: Map<String, Integer>, array: List<Integer>[]): CollectionHolder<String, Integer>\n                array: List<Integer>[]\n                list: List<Integer>\n                map: Map<String, Integer>\n              intArray: int[]\n        ";
        this_$iv$iv = this_$iv;
        configurableLocalTypeModel = this_$iv.model;
        string = StringsKt.trimIndent((String)expected$iv);
        Type type6 = new TypeToken<Nested>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type6, (String)"object : TypeToken<T>() {}.type");
        type3 = type6;
        Assert.assertEquals((Object)string, (Object)LocalTypeInformation.prettyPrint$default((LocalTypeInformation)configurableLocalTypeModel.inspect(type3), (boolean)false, (int)1, null));
        this_$iv = this;
        expected$iv = "NonComposableNested";
        this_$iv$iv = this_$iv;
        configurableLocalTypeModel = this_$iv.model;
        string = StringsKt.trimIndent((String)expected$iv);
        Type type7 = new TypeToken<NonComposableNested>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type7, (String)"object : TypeToken<T>() {}.type");
        type3 = type7;
        Assert.assertEquals((Object)string, (Object)LocalTypeInformation.prettyPrint$default((LocalTypeInformation)configurableLocalTypeModel.inspect(type3), (boolean)false, (int)1, null));
    }

    @Test(timeout=300000L)
    public final void interfaces and superclasses() {
        LocalTypeModelTests this_$iv;
        LocalTypeModelTests localTypeModelTests = this;
        String expected$iv = "SuperSuper<Integer, Integer>";
        void var3_3 = this_$iv;
        ConfigurableLocalTypeModel configurableLocalTypeModel = this_$iv.model;
        String string = StringsKt.trimIndent((String)expected$iv);
        Type type2 = new TypeToken<SuperSuper<Integer, Integer>>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"object : TypeToken<T>() {}.type");
        Type type3 = type2;
        Assert.assertEquals((Object)string, (Object)LocalTypeInformation.prettyPrint$default((LocalTypeInformation)configurableLocalTypeModel.inspect(type3), (boolean)false, (int)1, null));
        this_$iv = this;
        expected$iv = "Super<UUID>: SuperSuper<UUID, Double>";
        LocalTypeModelTests this_$iv$iv = this_$iv;
        configurableLocalTypeModel = this_$iv.model;
        string = StringsKt.trimIndent((String)expected$iv);
        Type type4 = new TypeToken<Super<UUID>>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type4, (String)"object : TypeToken<T>() {}.type");
        type3 = type4;
        Assert.assertEquals((Object)string, (Object)LocalTypeInformation.prettyPrint$default((LocalTypeInformation)configurableLocalTypeModel.inspect(type3), (boolean)false, (int)1, null));
        this_$iv = this;
        expected$iv = "\n            Abstract<String>: Super<String[]>, SuperSuper<String[], Double>\n              a: String[]\n              b: Double\n        ";
        this_$iv$iv = this_$iv;
        configurableLocalTypeModel = this_$iv.model;
        string = StringsKt.trimIndent((String)expected$iv);
        Type type5 = new TypeToken<Abstract<String>>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type5, (String)"object : TypeToken<T>() {}.type");
        type3 = type5;
        Assert.assertEquals((Object)string, (Object)LocalTypeInformation.prettyPrint$default((LocalTypeInformation)configurableLocalTypeModel.inspect(type3), (boolean)false, (int)1, null));
        this_$iv = this;
        expected$iv = "\n            Concrete(a: Integer[], b: double, c: List<Integer[]>, d: int): Abstract<Integer>, Super<Integer[]>, SuperSuper<Integer[], Double>\n              a: Integer[]\n              b: Double\n              c: List<Integer[]>\n              d: int\n        ";
        this_$iv$iv = this_$iv;
        configurableLocalTypeModel = this_$iv.model;
        string = StringsKt.trimIndent((String)expected$iv);
        Type type6 = new TypeToken<Concrete>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type6, (String)"object : TypeToken<T>() {}.type");
        type3 = type6;
        Assert.assertEquals((Object)string, (Object)LocalTypeInformation.prettyPrint$default((LocalTypeInformation)configurableLocalTypeModel.inspect(type3), (boolean)false, (int)1, null));
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void getter setter and calculated properties() {
        void this_$iv;
        LocalTypeModelTests localTypeModelTests = this;
        String expected$iv = "\n           OldStylePojoImpl(): OldStylePojo<int[]>\n             a (optional): int[]\n             b: String\n             c (calculated): String\n        ";
        void var3_3 = this_$iv;
        ConfigurableLocalTypeModel configurableLocalTypeModel = ((LocalTypeModelTests)this_$iv).model;
        String string = StringsKt.trimIndent((String)expected$iv);
        Type type2 = new TypeToken<OldStylePojoImpl>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"object : TypeToken<T>() {}.type");
        Type type3 = type2;
        Assert.assertEquals((Object)string, (Object)LocalTypeInformation.prettyPrint$default((LocalTypeInformation)configurableLocalTypeModel.inspect(type3), (boolean)false, (int)1, null));
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void calculated properties aliased by fields in implementing classes() {
        void this_$iv;
        LocalTypeModelTests localTypeModelTests = this;
        String expected$iv = "\n           AliasingOldStylePojoImpl(a: String?, b: String, c: String): OldStylePojo<String>\n             a (optional): String\n             b: String\n             c: String\n        ";
        void var3_3 = this_$iv;
        ConfigurableLocalTypeModel configurableLocalTypeModel = ((LocalTypeModelTests)this_$iv).model;
        String string = StringsKt.trimIndent((String)expected$iv);
        Type type2 = new TypeToken<AliasingOldStylePojoImpl>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"object : TypeToken<T>() {}.type");
        Type type3 = type2;
        Assert.assertEquals((Object)string, (Object)LocalTypeInformation.prettyPrint$default((LocalTypeInformation)configurableLocalTypeModel.inspect(type3), (boolean)false, (int)1, null));
    }

    @Test(timeout=300000L)
    public final void no unique deserialization constructor creates non-composable type() {
        LocalTypeModelTests localTypeModelTests = this;
        ConfigurableLocalTypeModel configurableLocalTypeModel = this.modelWithoutOpacity;
        Type type2 = new TypeToken<Exception>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"object : TypeToken<T>() {}.type");
        Type type3 = type2;
        LocalTypeModelTests typeInformation = localTypeModelTests = configurableLocalTypeModel.inspect(type3);
        Assert.assertTrue((boolean)(typeInformation instanceof LocalTypeInformation.NonComposable));
        LocalTypeModelTests localTypeModelTests2 = typeInformation;
        if (localTypeModelTests2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.corda.serialization.internal.model.LocalTypeInformation.NonComposable");
        }
        LocalTypeInformation.NonComposable cfr_ignored_0 = (LocalTypeInformation.NonComposable)localTypeModelTests2;
        Assert.assertEquals((Object)"No unique deserialization constructor can be identified", (Object)((LocalTypeInformation.NonComposable)typeInformation).getReason());
        Assert.assertEquals((Object)"Either annotate a constructor for this type with @ConstructorForDeserialization, or provide a custom serializer for it", (Object)((LocalTypeInformation.NonComposable)typeInformation).getRemedy());
    }

    @Test(timeout=300000L)
    public final void missing constructor parameters creates non-composable type() {
        LocalTypeModelTests localTypeModelTests = this;
        ConfigurableLocalTypeModel configurableLocalTypeModel = this.modelWithoutOpacity;
        Type type2 = new TypeToken<MissingConstructorParameter>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"object : TypeToken<T>() {}.type");
        Type type3 = type2;
        LocalTypeModelTests typeInformation = localTypeModelTests = configurableLocalTypeModel.inspect(type3);
        Assert.assertTrue((boolean)(typeInformation instanceof LocalTypeInformation.NonComposable));
        LocalTypeModelTests localTypeModelTests2 = typeInformation;
        if (localTypeModelTests2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.corda.serialization.internal.model.LocalTypeInformation.NonComposable");
        }
        LocalTypeInformation.NonComposable cfr_ignored_0 = (LocalTypeInformation.NonComposable)localTypeModelTests2;
        Assert.assertEquals((Object)"Mandatory constructor parameters [b] are missing from the readable properties [a]", (Object)((LocalTypeInformation.NonComposable)typeInformation).getReason());
        Assert.assertEquals((Object)"Either provide getters or readable fields for [b], or provide a custom serializer for this type", (Object)((LocalTypeInformation.NonComposable)typeInformation).getRemedy());
    }

    @Test(timeout=300000L)
    public final void transitive types are non-composable creates non-composable type() {
        LocalTypeModelTests localTypeModelTests = this;
        ConfigurableLocalTypeModel configurableLocalTypeModel = this.modelWithoutOpacity;
        Type type2 = new TypeToken<TransitivelyNonComposable>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"object : TypeToken<T>() {}.type");
        Type type3 = type2;
        LocalTypeModelTests typeInformation = localTypeModelTests = configurableLocalTypeModel.inspect(type3);
        Assert.assertTrue((boolean)(typeInformation instanceof LocalTypeInformation.NonComposable));
        LocalTypeModelTests localTypeModelTests2 = typeInformation;
        if (localTypeModelTests2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.corda.serialization.internal.model.LocalTypeInformation.NonComposable");
        }
        LocalTypeInformation.NonComposable cfr_ignored_0 = (LocalTypeInformation.NonComposable)localTypeModelTests2;
        Assert.assertEquals((Object)StringsKt.trimIndent((String)("\n                Has properties [b, c, d] of types that are not serializable:\n                b [" + Exception.class + "]: No unique deserialization constructor can be identified\n                c [" + MissingConstructorParameter.class + "]: Mandatory constructor parameters [b] are missing from the readable properties [a]\n                d [" + AnotherTransitivelyNonComposable.class + "]: Has properties [f, g] of types that are not serializable:\n                    f [" + Exception.class + "]: No unique deserialization constructor can be identified\n                    g [" + OneMoreTransitivelyNonComposable.class + "]: Has properties [i] of types that are not serializable:\n                        i [" + Exception.class + "]: No unique deserialization constructor can be identified\n                ")), (Object)((LocalTypeInformation.NonComposable)typeInformation).getReason());
        Assert.assertEquals((Object)"Either ensure that the properties [b, c, d] are serializable, or provide a custom serializer for this type", (Object)((LocalTypeInformation.NonComposable)typeInformation).getRemedy());
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void test type information for customised enum() {
        Collection<String> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        LocalTypeModelTests localTypeModelTests = this;
        ConfigurableLocalTypeModel configurableLocalTypeModel = this.modelWithoutOpacity;
        Type type2 = new TypeToken<CustomEnum>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"object : TypeToken<T>() {}.type");
        Type type3 = type2;
        localTypeModelTests = configurableLocalTypeModel.inspect(type3);
        LocalTypeModelTests typeInformation = localTypeModelTests;
        LocalTypeModelTests localTypeModelTests2 = typeInformation;
        if (!(localTypeModelTests2 instanceof LocalTypeInformation.AnEnum)) {
            localTypeModelTests2 = null;
        }
        LocalTypeInformation.AnEnum anEnum = (LocalTypeInformation.AnEnum)localTypeModelTests2;
        if (anEnum == null) {
            Void void_ = AssertionsKt.fail$default((String)"Not AnEnum!", null, (int)2, null);
            throw null;
        }
        LocalTypeInformation.AnEnum anEnum2 = anEnum;
        ListAssert listAssert = Assertions.assertThat((List)anEnum2.getMembers());
        T[] TArray = CustomEnum.class.getEnumConstants();
        Intrinsics.checkExpressionValueIsNotNull(TArray, (String)"CustomEnum::class.java.enumConstants");
        T[] TArray2 = TArray;
        ListAssert listAssert2 = listAssert;
        void var6_8 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(((void)$receiver$iv).length);
        int n = ((void)$receiver$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            void receiver;
            void item$iv$iv;
            void var11_13 = item$iv$iv = $receiver$iv$iv[j];
            collection = destination$iv$iv;
            String string = ((CustomEnum)receiver).name();
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        ListAssert cfr_ignored_0 = (ListAssert)listAssert2.containsExactlyElementsOf((Iterable)collection);
    }

    private final <T> void assertInformation(String expected) {
        LocalTypeModelTests localTypeModelTests = this;
        ConfigurableLocalTypeModel configurableLocalTypeModel = this.model;
        String string = StringsKt.trimIndent((String)expected);
        Intrinsics.needClassReification();
        Type type2 = new TypeToken<T>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"object : TypeToken<T>() {}.type");
        Type type3 = type2;
        Assert.assertEquals((Object)string, (Object)LocalTypeInformation.prettyPrint$default((LocalTypeInformation)configurableLocalTypeModel.inspect(type3), (boolean)false, (int)1, null));
    }

    private final <T> void printInformation() {
        Object object = this;
        ConfigurableLocalTypeModel configurableLocalTypeModel = this.model;
        Intrinsics.needClassReification();
        Type type2 = new TypeToken<T>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"object : TypeToken<T>() {}.type");
        Type type3 = type2;
        object = LocalTypeInformation.prettyPrint$default((LocalTypeInformation)configurableLocalTypeModel.inspect(type3), (boolean)false, (int)1, null);
        System.out.println(object);
    }

    private final <T> Type typeOf() {
        Intrinsics.needClassReification();
        Type type2 = new TypeToken<T>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"object : TypeToken<T>() {}.type");
        return type2;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u0003\bf\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003R\u001e\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00060\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lnet/corda/serialization/internal/model/LocalTypeModelTests$CollectionHolder;", "K", "V", "", "array", "", "", "getArray", "()[Ljava/util/List;", "list", "getList", "()Ljava/util/List;", "map", "", "getMap", "()Ljava/util/Map;", "serialization"})
    public static interface CollectionHolder<K, V> {
        @NotNull
        public List<V> getList();

        @NotNull
        public Map<K, V> getMap();

        @NotNull
        public List<V>[] getArray();
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0011\n\u0002\b\t\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002H\u00010\u0002B;\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\t\u00a2\u0006\u0002\u0010\nR\"\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\tX\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR \u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00028\u00000\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lnet/corda/serialization/internal/model/LocalTypeModelTests$StringKeyedCollectionHolder;", "T", "Lnet/corda/serialization/internal/model/LocalTypeModelTests$CollectionHolder;", "", "list", "", "map", "", "array", "", "(Ljava/util/List;Ljava/util/Map;[Ljava/util/List;)V", "getArray", "()[Ljava/util/List;", "[Ljava/util/List;", "getList", "()Ljava/util/List;", "getMap", "()Ljava/util/Map;", "serialization"})
    public static class StringKeyedCollectionHolder<T>
    implements CollectionHolder<String, T> {
        @NotNull
        private final List<T> list;
        @NotNull
        private final Map<String, T> map;
        @NotNull
        private final List<T>[] array;

        @Override
        @NotNull
        public List<T> getList() {
            return this.list;
        }

        @Override
        @NotNull
        public Map<String, T> getMap() {
            return this.map;
        }

        @Override
        @NotNull
        public List<T>[] getArray() {
            return this.array;
        }

        public StringKeyedCollectionHolder(@NotNull List<? extends T> list, @NotNull Map<String, ? extends T> map, @NotNull List<T>[] array) {
            Intrinsics.checkParameterIsNotNull(list, (String)"list");
            Intrinsics.checkParameterIsNotNull(map, (String)"map");
            Intrinsics.checkParameterIsNotNull(array, (String)"array");
            this.list = list;
            this.map = map;
            this.array = array;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B;\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00040\b\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lnet/corda/serialization/internal/model/LocalTypeModelTests$StringCollectionHolder;", "Lnet/corda/serialization/internal/model/LocalTypeModelTests$StringKeyedCollectionHolder;", "", "list", "", "map", "", "array", "", "(Ljava/util/List;Ljava/util/Map;[Ljava/util/List;)V", "serialization"})
    public static final class StringCollectionHolder
    extends StringKeyedCollectionHolder<String> {
        public StringCollectionHolder(@NotNull List<String> list, @NotNull Map<String, String> map, @NotNull List<String>[] array) {
            Intrinsics.checkParameterIsNotNull(list, (String)"list");
            Intrinsics.checkParameterIsNotNull(map, (String)"map");
            Intrinsics.checkParameterIsNotNull(array, (String)"array");
            super(list, map, array);
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\n\n\u0002\b\u0004\u0018\u00002\u00020\u0001B)\u0012\u0010\u0010\u0002\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tR\u001b\u0010\u0002\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lnet/corda/serialization/internal/model/LocalTypeModelTests$Nested;", "", "collectionHolder", "Lnet/corda/serialization/internal/model/LocalTypeModelTests$StringKeyedCollectionHolder;", "", "intArray", "", "optionalParam", "", "(Lnet/corda/serialization/internal/model/LocalTypeModelTests$StringKeyedCollectionHolder;[ILjava/lang/Short;)V", "getCollectionHolder", "()Lnet/corda/serialization/internal/model/LocalTypeModelTests$StringKeyedCollectionHolder;", "serialization"})
    public static final class Nested {
        @Nullable
        private final StringKeyedCollectionHolder<? extends Integer> collectionHolder;
        private final int[] intArray;

        @Nullable
        public final StringKeyedCollectionHolder<? extends Integer> getCollectionHolder() {
            return this.collectionHolder;
        }

        public Nested(@Nullable StringKeyedCollectionHolder<? extends Integer> collectionHolder, @NotNull int[] intArray, @Nullable Short optionalParam) {
            Intrinsics.checkParameterIsNotNull((Object)intArray, (String)"intArray");
            this.collectionHolder = collectionHolder;
            this.intArray = intArray;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0010\u0010\u0002\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u001b\u0010\u0002\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lnet/corda/serialization/internal/model/LocalTypeModelTests$NonComposableNested;", "", "collectionHolder", "Lnet/corda/serialization/internal/model/LocalTypeModelTests$StringKeyedCollectionHolder;", "", "intArray", "", "(Lnet/corda/serialization/internal/model/LocalTypeModelTests$StringKeyedCollectionHolder;[I)V", "getCollectionHolder", "()Lnet/corda/serialization/internal/model/LocalTypeModelTests$StringKeyedCollectionHolder;", "serialization"})
    public static final class NonComposableNested {
        @Nullable
        private final StringKeyedCollectionHolder<? extends Integer> collectionHolder;

        @Nullable
        public final StringKeyedCollectionHolder<? extends Integer> getCollectionHolder() {
            return this.collectionHolder;
        }

        public NonComposableNested(@Nullable StringKeyedCollectionHolder<? extends Integer> collectionHolder, @NotNull int[] intArray) {
            Intrinsics.checkParameterIsNotNull((Object)intArray, (String)"intArray");
            this.collectionHolder = collectionHolder;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\bf\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003R\u0012\u0010\u0004\u001a\u00028\u0000X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00028\u0001X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lnet/corda/serialization/internal/model/LocalTypeModelTests$SuperSuper;", "A", "B", "", "a", "getA", "()Ljava/lang/Object;", "b", "getB", "serialization"})
    public static interface SuperSuper<A, B> {
        public A getA();

        public B getB();
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\bf\u0018\u0000*\u0004\b\u0000\u0010\u00012\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00030\u0002R\u0018\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lnet/corda/serialization/internal/model/LocalTypeModelTests$Super;", "C", "Lnet/corda/serialization/internal/model/LocalTypeModelTests$SuperSuper;", "", "c", "", "getC", "()Ljava/util/List;", "serialization"})
    public static interface Super<C>
    extends SuperSuper<C, Double> {
        @NotNull
        public List<C> getC();
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0007\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u0002B\u001b\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lnet/corda/serialization/internal/model/LocalTypeModelTests$Abstract;", "T", "Lnet/corda/serialization/internal/model/LocalTypeModelTests$Super;", "", "a", "b", "", "([Ljava/lang/Object;D)V", "getA", "()[Ljava/lang/Object;", "[Ljava/lang/Object;", "getB", "()Ljava/lang/Double;", "serialization"})
    public static abstract class Abstract<T>
    implements Super<T[]> {
        @NotNull
        private final T[] a;
        private final double b;

        @Override
        @NotNull
        public T[] getA() {
            return this.a;
        }

        @Override
        @NotNull
        public Double getB() {
            return this.b;
        }

        public Abstract(@NotNull T[] a, double b) {
            Intrinsics.checkParameterIsNotNull(a, (String)"a");
            this.a = a;
            this.b = b;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B7\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00040\b\u0012\u0006\u0010\t\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\nR \u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00040\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\t\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lnet/corda/serialization/internal/model/LocalTypeModelTests$Concrete;", "Lnet/corda/serialization/internal/model/LocalTypeModelTests$Abstract;", "", "a", "", "b", "", "c", "", "d", "([Ljava/lang/Integer;DLjava/util/List;I)V", "getC", "()Ljava/util/List;", "getD", "()I", "serialization"})
    public static final class Concrete
    extends Abstract<Integer> {
        @NotNull
        private final List<Integer[]> c;
        private final int d;

        @Override
        @NotNull
        public List<Integer[]> getC() {
            return this.c;
        }

        public final int getD() {
            return this.d;
        }

        public Concrete(@NotNull Integer[] a, double b, @NotNull List<Integer[]> c, int d) {
            Intrinsics.checkParameterIsNotNull((Object)a, (String)"a");
            Intrinsics.checkParameterIsNotNull(c, (String)"c");
            super(a, b);
            this.c = c;
            this.d = d;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0007\bf\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002R\u001a\u0010\u0003\u001a\u0004\u0018\u00018\u0000X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\u00020\tX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\t8'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lnet/corda/serialization/internal/model/LocalTypeModelTests$OldStylePojo;", "A", "", "a", "getA", "()Ljava/lang/Object;", "setA", "(Ljava/lang/Object;)V", "b", "", "getB", "()Ljava/lang/String;", "setB", "(Ljava/lang/String;)V", "c", "getC", "serialization"})
    public static interface OldStylePojo<A> {
        @Nullable
        public A getA();

        public void setA(@Nullable A var1);

        @NotNull
        public String getB();

        public void setB(@NotNull String var1);

        @SerializableCalculatedProperty
        @NotNull
        public String getC();
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0015\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0002X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\f\u00a8\u0006\u0011"}, d2={"Lnet/corda/serialization/internal/model/LocalTypeModelTests$OldStylePojoImpl;", "Lnet/corda/serialization/internal/model/LocalTypeModelTests$OldStylePojo;", "", "()V", "a", "getA", "()[I", "setA", "([I)V", "b", "", "getB", "()Ljava/lang/String;", "setB", "(Ljava/lang/String;)V", "c", "getC", "serialization"})
    public static final class OldStylePojoImpl
    implements OldStylePojo<int[]> {
        @Nullable
        private int[] a;
        @NotNull
        private String b = "";
        @NotNull
        private final String c = String.valueOf(this.getA()) + this.getB();

        @Override
        @Nullable
        public int[] getA() {
            return this.a;
        }

        @Override
        public void setA(@Nullable int[] nArray) {
            this.a = nArray;
        }

        @Override
        @NotNull
        public String getB() {
            return this.b;
        }

        @Override
        public void setB(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
            this.b = string;
        }

        @Override
        @NotNull
        public String getC() {
            return this.c;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\f\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0002X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0002X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\b\u00a8\u0006\u000e"}, d2={"Lnet/corda/serialization/internal/model/LocalTypeModelTests$AliasingOldStylePojoImpl;", "Lnet/corda/serialization/internal/model/LocalTypeModelTests$OldStylePojo;", "", "a", "b", "c", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getA", "()Ljava/lang/String;", "setA", "(Ljava/lang/String;)V", "getB", "setB", "getC", "serialization"})
    public static final class AliasingOldStylePojoImpl
    implements OldStylePojo<String> {
        @Nullable
        private String a;
        @NotNull
        private String b;
        @NotNull
        private final String c;

        @Override
        @Nullable
        public String getA() {
            return this.a;
        }

        @Override
        public void setA(@Nullable String string) {
            this.a = string;
        }

        @Override
        @NotNull
        public String getB() {
            return this.b;
        }

        @Override
        public void setB(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
            this.b = string;
        }

        @Override
        @NotNull
        public String getC() {
            return this.c;
        }

        public AliasingOldStylePojoImpl(@Nullable String a, @NotNull String b, @NotNull String c) {
            Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
            Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
            this.a = a;
            this.b = b;
            this.c = c;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0015\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lnet/corda/serialization/internal/model/LocalTypeModelTests$TransitivelyNonComposable;", "", "a", "", "b", "Ljava/lang/Exception;", "Lkotlin/Exception;", "c", "Lnet/corda/serialization/internal/model/LocalTypeModelTests$MissingConstructorParameter;", "d", "Lnet/corda/serialization/internal/model/LocalTypeModelTests$AnotherTransitivelyNonComposable;", "(Ljava/lang/String;Ljava/lang/Exception;Lnet/corda/serialization/internal/model/LocalTypeModelTests$MissingConstructorParameter;Lnet/corda/serialization/internal/model/LocalTypeModelTests$AnotherTransitivelyNonComposable;)V", "getA", "()Ljava/lang/String;", "getB", "()Ljava/lang/Exception;", "getC", "()Lnet/corda/serialization/internal/model/LocalTypeModelTests$MissingConstructorParameter;", "getD", "()Lnet/corda/serialization/internal/model/LocalTypeModelTests$AnotherTransitivelyNonComposable;", "serialization"})
    public static final class TransitivelyNonComposable {
        @NotNull
        private final String a;
        @NotNull
        private final Exception b;
        @NotNull
        private final MissingConstructorParameter c;
        @NotNull
        private final AnotherTransitivelyNonComposable d;

        @NotNull
        public final String getA() {
            return this.a;
        }

        @NotNull
        public final Exception getB() {
            return this.b;
        }

        @NotNull
        public final MissingConstructorParameter getC() {
            return this.c;
        }

        @NotNull
        public final AnotherTransitivelyNonComposable getD() {
            return this.d;
        }

        public TransitivelyNonComposable(@NotNull String a, @NotNull Exception b, @NotNull MissingConstructorParameter c, @NotNull AnotherTransitivelyNonComposable d) {
            Intrinsics.checkParameterIsNotNull((Object)a, (String)"a");
            Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
            Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
            Intrinsics.checkParameterIsNotNull((Object)d, (String)"d");
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0015\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lnet/corda/serialization/internal/model/LocalTypeModelTests$AnotherTransitivelyNonComposable;", "", "e", "", "f", "Ljava/lang/Exception;", "Lkotlin/Exception;", "g", "Lnet/corda/serialization/internal/model/LocalTypeModelTests$OneMoreTransitivelyNonComposable;", "(Ljava/lang/String;Ljava/lang/Exception;Lnet/corda/serialization/internal/model/LocalTypeModelTests$OneMoreTransitivelyNonComposable;)V", "getE", "()Ljava/lang/String;", "getF", "()Ljava/lang/Exception;", "getG", "()Lnet/corda/serialization/internal/model/LocalTypeModelTests$OneMoreTransitivelyNonComposable;", "serialization"})
    public static final class AnotherTransitivelyNonComposable {
        @NotNull
        private final String e;
        @NotNull
        private final Exception f;
        @NotNull
        private final OneMoreTransitivelyNonComposable g;

        @NotNull
        public final String getE() {
            return this.e;
        }

        @NotNull
        public final Exception getF() {
            return this.f;
        }

        @NotNull
        public final OneMoreTransitivelyNonComposable getG() {
            return this.g;
        }

        public AnotherTransitivelyNonComposable(@NotNull String e2, @NotNull Exception f, @NotNull OneMoreTransitivelyNonComposable g) {
            Intrinsics.checkParameterIsNotNull((Object)e2, (String)"e");
            Intrinsics.checkParameterIsNotNull((Object)f, (String)"f");
            Intrinsics.checkParameterIsNotNull((Object)g, (String)"g");
            this.e = e2;
            this.f = f;
            this.g = g;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0015\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lnet/corda/serialization/internal/model/LocalTypeModelTests$OneMoreTransitivelyNonComposable;", "", "h", "", "i", "Ljava/lang/Exception;", "Lkotlin/Exception;", "(Ljava/lang/String;Ljava/lang/Exception;)V", "getH", "()Ljava/lang/String;", "getI", "()Ljava/lang/Exception;", "serialization"})
    public static final class OneMoreTransitivelyNonComposable {
        @NotNull
        private final String h;
        @NotNull
        private final Exception i;

        @NotNull
        public final String getH() {
            return this.h;
        }

        @NotNull
        public final Exception getI() {
            return this.i;
        }

        public OneMoreTransitivelyNonComposable(@NotNull String h, @NotNull Exception i2) {
            Intrinsics.checkParameterIsNotNull((Object)h, (String)"h");
            Intrinsics.checkParameterIsNotNull((Object)i2, (String)"i");
            this.h = h;
            this.i = i2;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lnet/corda/serialization/internal/model/LocalTypeModelTests$MissingConstructorParameter;", "", "a", "", "b", "Ljava/lang/Exception;", "Lkotlin/Exception;", "(Ljava/lang/String;Ljava/lang/Exception;)V", "getA", "()Ljava/lang/String;", "serialization"})
    public static final class MissingConstructorParameter {
        @NotNull
        private final String a;

        @NotNull
        public final String getA() {
            return this.a;
        }

        public MissingConstructorParameter(@NotNull String a, @NotNull Exception b) {
            Intrinsics.checkParameterIsNotNull((Object)a, (String)"a");
            Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
            this.a = a;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lnet/corda/serialization/internal/model/LocalTypeModelTests$CustomEnum;", "", "(Ljava/lang/String;I)V", "toString", "", "ONE", "TWO", "serialization"})
    public static final class CustomEnum
    extends Enum<CustomEnum> {
        public static final /* enum */ CustomEnum ONE;
        public static final /* enum */ CustomEnum TWO;
        private static final /* synthetic */ CustomEnum[] $VALUES;

        static {
            CustomEnum[] customEnumArray = new CustomEnum[2];
            CustomEnum[] customEnumArray2 = customEnumArray;
            customEnumArray[0] = ONE = new CustomEnum();
            customEnumArray[1] = TWO = new CustomEnum();
            $VALUES = customEnumArray;
        }

        @NotNull
        public String toString() {
            String string = this.name();
            StringBuilder stringBuilder = new StringBuilder().append('[');
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
            String string4 = string3;
            return stringBuilder.append(string4).append(']').toString();
        }

        public static CustomEnum[] values() {
            return (CustomEnum[])$VALUES.clone();
        }

        public static CustomEnum valueOf(String string) {
            return Enum.valueOf(CustomEnum.class, string);
        }
    }
}

