/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.carpenter;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.test.AssertionsKt;
import net.corda.core.serialization.ClassWhitelist;
import net.corda.serialization.internal.AllWhitelist;
import net.corda.serialization.internal.carpenter.AmqpCarpenterBase;
import net.corda.serialization.internal.carpenter.ClassCarpenterImpl;
import net.corda.serialization.internal.carpenter.ClassSchema;
import net.corda.serialization.internal.carpenter.EnumField;
import net.corda.serialization.internal.carpenter.EnumSchema;
import net.corda.serialization.internal.carpenter.NonNullableField;
import net.corda.serialization.internal.carpenter.Schema;
import org.junit.Test;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007J\b\u0010\u0006\u001a\u00020\u0004H\u0007J\b\u0010\u0007\u001a\u00020\u0004H\u0007J\b\u0010\b\u001a\u00020\u0004H\u0007J\b\u0010\t\u001a\u00020\u0004H\u0007\u00a8\u0006\n"}, d2={"Lnet/corda/serialization/internal/carpenter/EnumClassTests;", "Lnet/corda/serialization/internal/carpenter/AmqpCarpenterBase;", "()V", "assignAndTest", "", "assignment", "manyValues", "oneValue", "oneValueInstantiate", "twoValuesInstantiate", "serialization"})
public final class EnumClassTests
extends AmqpCarpenterBase {
    @Test(timeout=300000L)
    public final void oneValue() {
        Map enumConstants = MapsKt.mapOf((Pair)TuplesKt.to((Object)"A", (Object)new EnumField()));
        EnumSchema schema = new EnumSchema("gen.enum", enumConstants);
        AssertionsKt.assertTrue$default((boolean)this.getCc().build((Schema)schema).isEnum(), null, (int)2, null);
    }

    @Test(timeout=300000L)
    public final void oneValueInstantiate() {
        Map enumConstants = MapsKt.mapOf((Pair)TuplesKt.to((Object)"A", (Object)new EnumField()));
        EnumSchema schema = new EnumSchema("gen.enum", enumConstants);
        Class clazz = this.getCc().build((Schema)schema);
        AssertionsKt.assertTrue$default((boolean)clazz.isEnum(), null, (int)2, null);
        AssertionsKt.assertEquals$default((Object)enumConstants.size(), (Object)clazz.getEnumConstants().length, null, (int)4, null);
        Object[] objectArray = clazz.getEnumConstants();
        Intrinsics.checkExpressionValueIsNotNull(objectArray, (String)"clazz.enumConstants");
        AssertionsKt.assertEquals$default((Object)"A", (Object)ArraysKt.first((Object[])objectArray).toString(), null, (int)4, null);
        Integer n = 0;
        Object[] objectArray2 = clazz.getEnumConstants();
        Intrinsics.checkExpressionValueIsNotNull(objectArray2, (String)"clazz.enumConstants");
        Object object = ArraysKt.first((Object[])objectArray2);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Enum<*>");
        }
        AssertionsKt.assertEquals$default((Object)n, (Object)((Enum)object).ordinal(), null, (int)4, null);
        Object[] objectArray3 = clazz.getEnumConstants();
        Intrinsics.checkExpressionValueIsNotNull(objectArray3, (String)"clazz.enumConstants");
        Object object2 = ArraysKt.first((Object[])objectArray3);
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Enum<*>");
        }
        AssertionsKt.assertEquals$default((Object)"A", (Object)((Enum)object2).name(), null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void twoValuesInstantiate() {
        Map enumConstants = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"left", (Object)new EnumField()), TuplesKt.to((Object)"right", (Object)new EnumField())});
        EnumSchema schema = new EnumSchema("gen.enum", enumConstants);
        Class clazz = this.getCc().build((Schema)schema);
        AssertionsKt.assertTrue$default((boolean)clazz.isEnum(), null, (int)2, null);
        AssertionsKt.assertEquals$default((Object)enumConstants.size(), (Object)clazz.getEnumConstants().length, null, (int)4, null);
        Object t = clazz.getEnumConstants()[0];
        if (t == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Enum<*>");
        }
        Enum left = (Enum)t;
        Object t2 = clazz.getEnumConstants()[1];
        if (t2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Enum<*>");
        }
        Enum right = (Enum)t2;
        AssertionsKt.assertEquals$default((Object)0, (Object)left.ordinal(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)"left", (Object)left.name(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)1, (Object)right.ordinal(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)"right", (Object)right.name(), null, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void manyValues() {
        void $receiver$iv$iv;
        Iterable $receiver$iv = CollectionsKt.listOf((Object[])new String[]{"AAA", "BBB", "CCC", "DDD", "EEE", "FFF", "GGG", "HHH", "III", "JJJ"});
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
        Iterable iterable = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            String it;
            String string = (String)element$iv$iv;
            Map map = destination$iv$iv;
            void var15_12 = it;
            it = (String)element$iv$iv;
            EnumField enumField = new EnumField();
            map.put(var15_12, enumField);
        }
        Map enumConstants = destination$iv$iv;
        EnumSchema schema = new EnumSchema("gen.enum", enumConstants);
        Class clazz = this.getCc().build((Schema)schema);
        AssertionsKt.assertTrue$default((boolean)clazz.isEnum(), null, (int)2, null);
        AssertionsKt.assertEquals$default((Object)enumConstants.size(), (Object)clazz.getEnumConstants().length, null, (int)4, null);
        int idx = 0;
        Map $receiver$iv2 = enumConstants;
        Map map = $receiver$iv2;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator.next();
            Object t = clazz.getEnumConstants()[idx];
            if (t == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Enum<*>");
            }
            Enum constant = (Enum)t;
            int n = idx;
            idx = n + 1;
            AssertionsKt.assertEquals$default((Object)n, (Object)constant.ordinal(), null, (int)4, null);
            AssertionsKt.assertEquals$default(it.getKey(), (Object)constant.name(), null, (int)4, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void assignment() {
        void $receiver$iv$iv;
        Iterable $receiver$iv = CollectionsKt.listOf((Object[])new String[]{"AAA", "BBB", "CCC", "DDD", "EEE", "FFF"});
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
        Iterable iterable = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            String it;
            String string = (String)element$iv$iv;
            Map map = destination$iv$iv;
            void var13_10 = it;
            it = (String)element$iv$iv;
            EnumField enumField = new EnumField();
            map.put(var13_10, enumField);
        }
        Map enumConstants = destination$iv$iv;
        EnumSchema schema = new EnumSchema("gen.enum", enumConstants);
        Class clazz = this.getCc().build((Schema)schema);
        AssertionsKt.assertEquals$default((Object)"CCC", (Object)clazz.getMethod("valueOf", String.class).invoke(null, "CCC").toString(), null, (int)4, null);
        Object object = clazz.getMethod("valueOf", String.class).invoke(null, "CCC");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Enum<*>");
        }
        AssertionsKt.assertEquals$default((Object)"CCC", (Object)((Enum)object).name(), null, (int)4, null);
        Object object2 = clazz.getMethod("valueOf", String.class).invoke(null, "DDD");
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Enum<*>");
        }
        Enum ddd = (Enum)object2;
        AssertionsKt.assertTrue$default((boolean)ddd.getClass().isEnum(), null, (int)2, null);
        AssertionsKt.assertEquals$default((Object)"DDD", (Object)ddd.name(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)3, (Object)ddd.ordinal(), null, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void assignAndTest() {
        Map map;
        void $receiver$iv$iv;
        void $receiver$iv;
        EnumSchema enumSchema;
        ClassCarpenterImpl cc2 = new ClassCarpenterImpl((ClassWhitelist)AllWhitelist.INSTANCE, null, false, 6, null);
        Iterable iterable = CollectionsKt.listOf((Object[])new String[]{"AAA", "BBB", "CCC", "DDD", "EEE", "FFF"});
        String string = "gen.enum";
        EnumSchema enumSchema2 = enumSchema;
        EnumSchema enumSchema3 = enumSchema;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
        void var5_8 = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            String it;
            String string2 = (String)element$iv$iv;
            map = destination$iv$iv;
            void var17_14 = it;
            it = (String)element$iv$iv;
            EnumField enumField = new EnumField();
            map.put(var17_14, enumField);
        }
        map = destination$iv$iv;
        enumSchema2(string, map);
        EnumSchema schema1 = enumSchema3;
        Class enumClazz = cc2.build((Schema)schema1);
        ClassSchema schema2 = new ClassSchema("gen.class", MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"a", (Object)new NonNullableField(Integer.TYPE)), TuplesKt.to((Object)"b", (Object)new NonNullableField(enumClazz))}), null, null, 12, null);
        Class classClazz = cc2.build((Schema)schema2);
        classClazz.getConstructors()[0].newInstance(1, enumClazz.getMethod("valueOf", String.class).invoke(null, "BBB"));
    }

    public EnumClassTests() {
        super((ClassWhitelist)AllWhitelist.INSTANCE);
    }
}

