/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.carpenter;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.test.AssertionsKt;
import net.corda.core.internal.InternalUtils;
import net.corda.core.serialization.ClassWhitelist;
import net.corda.serialization.internal.AllWhitelist;
import net.corda.serialization.internal.carpenter.ClassCarpenterImpl;
import net.corda.serialization.internal.carpenter.ClassSchema;
import net.corda.serialization.internal.carpenter.DuplicateNameException;
import net.corda.serialization.internal.carpenter.InterfaceMismatchException;
import net.corda.serialization.internal.carpenter.InterfaceSchema;
import net.corda.serialization.internal.carpenter.NonNullableField;
import net.corda.serialization.internal.carpenter.NullableField;
import net.corda.serialization.internal.carpenter.NullablePrimitiveException;
import net.corda.serialization.internal.carpenter.Schema;
import net.corda.serialization.internal.carpenter.SimpleFieldAccess;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableAssert;
import org.jetbrains.annotations.NotNull;
import org.junit.Test;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u001a\u0018\u00002\u00020\u0001:\u0001-B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0007J\b\u0010\u0010\u001a\u00020\u000fH\u0007J\b\u0010\u0011\u001a\u00020\u000fH\u0007J\b\u0010\u0012\u001a\u00020\u000fH\u0007J\u0018\u0010\u0013\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\u0004\u0012\u00020\u00010\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u000fH\u0007J\b\u0010\u0016\u001a\u00020\u000fH\u0007J\b\u0010\u0017\u001a\u00020\u000fH\u0007J\b\u0010\u0018\u001a\u00020\u000fH\u0007J\b\u0010\u0019\u001a\u00020\u000fH\u0007J\b\u0010\u001a\u001a\u00020\u000fH\u0007J\b\u0010\u001b\u001a\u00020\u000fH\u0007J\b\u0010\u001c\u001a\u00020\u000fH\u0007J\b\u0010\u001d\u001a\u00020\u000fH\u0007J\b\u0010\u001e\u001a\u00020\u000fH\u0007J\b\u0010\u001f\u001a\u00020\u000fH\u0007J\b\u0010 \u001a\u00020\u000fH\u0007J\b\u0010!\u001a\u00020\u000fH\u0007J\b\u0010\"\u001a\u00020\u000fH\u0007J\b\u0010#\u001a\u00020\u000fH\u0007J\b\u0010$\u001a\u00020\u000fH\u0007J\b\u0010%\u001a\u00020\u000fH\u0007J\b\u0010&\u001a\u00020\u000fH\u0007J\b\u0010'\u001a\u00020\u000fH\u0007J\b\u0010(\u001a\u00020\u000fH\u0007J\b\u0010)\u001a\u00020\u000fH\u0007J\b\u0010*\u001a\u00020\u000fH\u0007J\b\u0010+\u001a\u00020\u000fH\u0007J\b\u0010,\u001a\u00020\u000fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006*\u0006\u0012\u0002\b\u00030\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\"\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0006*\u0006\u0012\u0002\b\u00030\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\n\u00a8\u0006."}, d2={"Lnet/corda/serialization/internal/carpenter/ClassCarpenterTest;", "", "()V", "cc", "Lnet/corda/serialization/internal/carpenter/ClassCarpenterImpl;", "nonSyntheticFields", "", "Ljava/lang/reflect/Field;", "Ljava/lang/Class;", "getNonSyntheticFields", "(Ljava/lang/Class;)Ljava/util/List;", "nonSyntheticMethods", "Ljava/lang/reflect/Method;", "getNonSyntheticMethods", "beanTest", "", "can refer to each other", "duplicates", "empty", "genPerson", "Lkotlin/Pair;", "generate interface", "generate multiple interfaces", "generated toString", "int array", "int array with ints", "integer array", "interface implementing interface", "interfaces", "multiple int arrays", "non nullable parameter integer with non null", "non nullable parameter integer with null", "null parameter small int", "nullable int array throws", "nullable parameter integer", "nullable parameter small int", "nullable sets annotations", "objs", "prims", "string array", "string arrays", "superclasses", "superclasses with double-size primitive constructor parameters", "unimplemented interface method with lenient = false", "unimplemented interface method with lenient = true", "DummyInterface", "serialization"})
public final class ClassCarpenterTest {
    private final ClassCarpenterImpl cc = new ClassCarpenterImpl((ClassWhitelist)AllWhitelist.INSTANCE, null, false, 6, null);

    /*
     * WARNING - void declaration
     */
    private final List<Field> getNonSyntheticFields(@NotNull Class<?> $receiver) {
        void $receiver$iv$iv;
        Field[] $receiver$iv;
        Field[] fieldArray = $receiver.getDeclaredFields();
        Intrinsics.checkExpressionValueIsNotNull((Object)fieldArray, (String)"declaredFields");
        Field[] fieldArray2 = $receiver$iv = fieldArray;
        Collection destination$iv$iv = new ArrayList();
        int n = ((void)$receiver$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            void element$iv$iv;
            void it;
            void v1 = it = (element$iv$iv = $receiver$iv$iv[j]);
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            if (v1.isSynthetic()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Method> getNonSyntheticMethods(@NotNull Class<?> $receiver) {
        void $receiver$iv$iv;
        Method[] $receiver$iv;
        Method[] methodArray = $receiver.getDeclaredMethods();
        Intrinsics.checkExpressionValueIsNotNull((Object)methodArray, (String)"declaredMethods");
        Method[] methodArray2 = $receiver$iv = methodArray;
        Collection destination$iv$iv = new ArrayList();
        int n = ((void)$receiver$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            void element$iv$iv;
            void it;
            void v1 = it = (element$iv$iv = $receiver$iv$iv[j]);
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            if (v1.isSynthetic()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Test(timeout=300000L)
    public final void empty() {
        Class clazz = this.cc.build((Schema)new ClassSchema("gen.EmptyClass", MapsKt.emptyMap(), null, null, 12, null));
        AssertionsKt.assertEquals$default((Object)0, (Object)this.getNonSyntheticFields(clazz).size(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)2, (Object)this.getNonSyntheticMethods(clazz).size(), null, (int)4, null);
        Integer n = 0;
        Constructor<?> constructor = clazz.getDeclaredConstructors()[0];
        Intrinsics.checkExpressionValueIsNotNull(constructor, (String)"clazz.declaredConstructors[0]");
        AssertionsKt.assertEquals$default((Object)n, (Object)constructor.getParameterCount(), null, (int)4, null);
        clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void prims() {
        Map map;
        void $receiver$iv$iv;
        void $receiver$iv;
        ClassSchema classSchema;
        Pair[] pairArray = new Pair[8];
        Class<Integer> clazz = Integer.TYPE;
        if (clazz == null) {
            Intrinsics.throwNpe();
        }
        pairArray[0] = TuplesKt.to((Object)"anIntField", clazz);
        Class<Long> clazz2 = Long.TYPE;
        if (clazz2 == null) {
            Intrinsics.throwNpe();
        }
        pairArray[1] = TuplesKt.to((Object)"aLongField", clazz2);
        Class<Character> clazz3 = Character.TYPE;
        if (clazz3 == null) {
            Intrinsics.throwNpe();
        }
        pairArray[2] = TuplesKt.to((Object)"someCharField", clazz3);
        Class<Short> clazz4 = Short.TYPE;
        if (clazz4 == null) {
            Intrinsics.throwNpe();
        }
        pairArray[3] = TuplesKt.to((Object)"aShortField", clazz4);
        Class<Double> clazz5 = Double.TYPE;
        if (clazz5 == null) {
            Intrinsics.throwNpe();
        }
        pairArray[4] = TuplesKt.to((Object)"doubleTrouble", clazz5);
        Class<Float> clazz6 = Float.TYPE;
        if (clazz6 == null) {
            Intrinsics.throwNpe();
        }
        pairArray[5] = TuplesKt.to((Object)"floatMyBoat", clazz6);
        Class<Byte> clazz7 = Byte.TYPE;
        if (clazz7 == null) {
            Intrinsics.throwNpe();
        }
        pairArray[6] = TuplesKt.to((Object)"byteMe", clazz7);
        Class<Boolean> clazz8 = Boolean.TYPE;
        if (clazz8 == null) {
            Intrinsics.throwNpe();
        }
        pairArray[7] = TuplesKt.to((Object)"booleanField", clazz8);
        Map map2 = MapsKt.mapOf((Pair[])pairArray);
        String string = "gen.Prims";
        ClassSchema classSchema2 = classSchema;
        ClassSchema classSchema3 = classSchema;
        ClassCarpenterImpl classCarpenterImpl = this.cc;
        void var3_6 = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$receiver$iv.size()));
        Iterable $receiver$iv$iv$iv = $receiver$iv$iv.entrySet();
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            Object k = it$iv$iv.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            map = map3;
            NonNullableField nonNullableField = new NonNullableField((Class)it.getValue());
            map.put(k2, nonNullableField);
        }
        map = destination$iv$iv;
        classSchema2(string, map, null, null, 12, null);
        Class clazz9 = classCarpenterImpl.build((Schema)classSchema3);
        AssertionsKt.assertEquals$default((Object)8, (Object)this.getNonSyntheticFields(clazz9).size(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)10, (Object)this.getNonSyntheticMethods(clazz9).size(), null, (int)4, null);
        Integer n = 8;
        Constructor<?> constructor = clazz9.getDeclaredConstructors()[0];
        Intrinsics.checkExpressionValueIsNotNull(constructor, (String)"clazz.declaredConstructors[0]");
        AssertionsKt.assertEquals$default((Object)n, (Object)constructor.getParameterCount(), null, (int)4, null);
        Object i2 = clazz9.getConstructors()[0].newInstance(1, 2L, Character.valueOf('c'), (short)4, 1.23, Float.valueOf(4.56f), (byte)127, true);
        AssertionsKt.assertEquals$default((Object)1, (Object)clazz9.getMethod("getAnIntField", new Class[0]).invoke(i2, new Object[0]), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)2L, (Object)clazz9.getMethod("getALongField", new Class[0]).invoke(i2, new Object[0]), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)Character.valueOf('c'), (Object)clazz9.getMethod("getSomeCharField", new Class[0]).invoke(i2, new Object[0]), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)((short)4), (Object)clazz9.getMethod("getAShortField", new Class[0]).invoke(i2, new Object[0]), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)1.23, (Object)clazz9.getMethod("getDoubleTrouble", new Class[0]).invoke(i2, new Object[0]), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)Float.valueOf(4.56f), (Object)clazz9.getMethod("getFloatMyBoat", new Class[0]).invoke(i2, new Object[0]), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)((byte)127), (Object)clazz9.getMethod("getByteMe", new Class[0]).invoke(i2, new Object[0]), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)true, (Object)clazz9.getMethod("getBooleanField", new Class[0]).invoke(i2, new Object[0]), null, (int)4, null);
        Object obj = i2;
        if (obj == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.corda.serialization.internal.carpenter.SimpleFieldAccess");
        }
        SimpleFieldAccess sfa = (SimpleFieldAccess)obj;
        AssertionsKt.assertEquals$default((Object)1, (Object)sfa.get("anIntField"), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)2L, (Object)sfa.get("aLongField"), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)Character.valueOf('c'), (Object)sfa.get("someCharField"), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)((short)4), (Object)sfa.get("aShortField"), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)1.23, (Object)sfa.get("doubleTrouble"), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)Float.valueOf(4.56f), (Object)sfa.get("floatMyBoat"), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)((byte)127), (Object)sfa.get("byteMe"), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)true, (Object)sfa.get("booleanField"), null, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<Class<?>, Object> genPerson() {
        Map map;
        void $receiver$iv$iv;
        void $receiver$iv;
        ClassSchema classSchema;
        Pair[] pairArray = new Pair[2];
        Class<Integer> clazz = Integer.TYPE;
        if (clazz == null) {
            Intrinsics.throwNpe();
        }
        pairArray[0] = TuplesKt.to((Object)"age", clazz);
        pairArray[1] = TuplesKt.to((Object)"name", String.class);
        Map map2 = MapsKt.mapOf((Pair[])pairArray);
        String string = "gen.Person";
        ClassSchema classSchema2 = classSchema;
        ClassSchema classSchema3 = classSchema;
        ClassCarpenterImpl classCarpenterImpl = this.cc;
        void var3_6 = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$receiver$iv.size()));
        Iterable $receiver$iv$iv$iv = $receiver$iv$iv.entrySet();
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            Object k = it$iv$iv.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            map = map3;
            NonNullableField nonNullableField = new NonNullableField((Class)it.getValue());
            map.put(k2, nonNullableField);
        }
        map = destination$iv$iv;
        classSchema2(string, map, null, null, 12, null);
        Class clazz2 = classCarpenterImpl.build((Schema)classSchema3);
        Object i2 = clazz2.getConstructors()[0].newInstance(32, "Mike");
        return new Pair((Object)clazz2, i2);
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void objs() {
        void clazz;
        Pair<Class<?>, Object> pair = this.genPerson();
        Class clazz2 = (Class)pair.component1();
        Object i2 = pair.component2();
        AssertionsKt.assertEquals$default((Object)"Mike", (Object)clazz.getMethod("getName", new Class[0]).invoke(i2, new Object[0]), null, (int)4, null);
        Object object = i2;
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.corda.serialization.internal.carpenter.SimpleFieldAccess");
        }
        AssertionsKt.assertEquals$default((Object)"Mike", (Object)((SimpleFieldAccess)object).get("name"), null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void generated toString() {
        Pair<Class<?>, Object> pair = this.genPerson();
        Object i2 = pair.component2();
        AssertionsKt.assertEquals$default((Object)"Person{age=32, name=Mike}", (Object)i2.toString(), null, (int)4, null);
    }

    @Test(expected=DuplicateNameException.class, timeout=300000L)
    public final void duplicates() {
        this.cc.build((Schema)new ClassSchema("gen.EmptyClass", MapsKt.emptyMap(), null, null, 12, null));
        this.cc.build((Schema)new ClassSchema("gen.EmptyClass", MapsKt.emptyMap(), null, null, 12, null));
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void can refer to each other() {
        Object i2;
        void clazz1;
        Pair<Class<?>, Object> pair = this.genPerson();
        Class clazz = (Class)pair.component1();
        Object i3 = pair.component2();
        Class clazz2 = this.cc.build((Schema)new ClassSchema("gen.Referee", MapsKt.mapOf((Pair)TuplesKt.to((Object)"ref", (Object)new NonNullableField((Class)clazz1))), null, null, 12, null));
        Object obj = i2 = clazz2.getConstructors()[0].newInstance(i3);
        if (obj == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.corda.serialization.internal.carpenter.SimpleFieldAccess");
        }
        AssertionsKt.assertEquals$default((Object)i3, (Object)((SimpleFieldAccess)obj).get("ref"), null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void superclasses() {
        ClassSchema schema1 = new ClassSchema("gen.A", MapsKt.mapOf((Pair)TuplesKt.to((Object)"a", (Object)new NonNullableField(String.class))), null, null, 12, null);
        ClassSchema schema2 = new ClassSchema("gen.B", MapsKt.mapOf((Pair)TuplesKt.to((Object)"b", (Object)new NonNullableField(String.class))), (Schema)schema1, null, 8, null);
        Class clazz = this.cc.build((Schema)schema2);
        Object obj = clazz.getConstructors()[0].newInstance("xa", "xb");
        if (obj == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.corda.serialization.internal.carpenter.SimpleFieldAccess");
        }
        SimpleFieldAccess i2 = (SimpleFieldAccess)obj;
        AssertionsKt.assertEquals$default((Object)"xa", (Object)i2.get("a"), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)"xb", (Object)i2.get("b"), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)"B{a=xa, b=xb}", (Object)i2.toString(), null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void superclasses with double-size primitive constructor parameters() {
        Class<Long> clazz = Long.TYPE;
        if (clazz == null) {
            Intrinsics.throwNpe();
        }
        ClassSchema schema1 = new ClassSchema("gen.A", MapsKt.mapOf((Pair)TuplesKt.to((Object)"a", (Object)new NonNullableField(clazz))), null, null, 12, null);
        ClassSchema schema2 = new ClassSchema("gen.B", MapsKt.mapOf((Pair)TuplesKt.to((Object)"b", (Object)new NonNullableField(String.class))), (Schema)schema1, null, 8, null);
        Class clazz2 = this.cc.build((Schema)schema2);
        Object obj = clazz2.getConstructors()[0].newInstance(1L, "xb");
        if (obj == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.corda.serialization.internal.carpenter.SimpleFieldAccess");
        }
        SimpleFieldAccess i2 = (SimpleFieldAccess)obj;
        AssertionsKt.assertEquals$default((Object)1L, (Object)i2.get("a"), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)"xb", (Object)i2.get("b"), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)"B{a=1, b=xb}", (Object)i2.toString(), null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void interfaces() {
        ClassSchema schema1 = new ClassSchema("gen.A", MapsKt.mapOf((Pair)TuplesKt.to((Object)"a", (Object)new NonNullableField(String.class))), null, null, 12, null);
        ClassSchema schema2 = new ClassSchema("gen.B", MapsKt.mapOf((Pair)TuplesKt.to((Object)"b", (Object)new NonNullableField(Integer.TYPE))), (Schema)schema1, CollectionsKt.listOf(DummyInterface.class));
        Class clazz = this.cc.build((Schema)schema2);
        Object obj = clazz.getConstructors()[0].newInstance("xa", 1);
        if (obj == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.corda.serialization.internal.carpenter.ClassCarpenterTest.DummyInterface");
        }
        DummyInterface i2 = (DummyInterface)obj;
        AssertionsKt.assertEquals$default((Object)"xa", (Object)i2.getA(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)1, (Object)i2.getB(), null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void unimplemented interface method with lenient = false() {
        ClassSchema schemaA = new ClassSchema("gen.A", MapsKt.mapOf((Pair)TuplesKt.to((Object)"a", (Object)new NonNullableField(String.class))), null, null, 12, null);
        ClassSchema schemaB = new ClassSchema("gen.B", MapsKt.mapOf((Pair)TuplesKt.to((Object)"c", (Object)new NonNullableField(Integer.TYPE))), (Schema)schemaA, CollectionsKt.listOf(DummyInterface.class));
        Assertions.assertThatExceptionOfType(InterfaceMismatchException.class).isThrownBy(new ThrowableAssert.ThrowingCallable(this, schemaB){
            final /* synthetic */ ClassCarpenterTest this$0;
            final /* synthetic */ ClassSchema $schemaB;

            public final void call() {
                ClassCarpenterTest.access$getCc$p(this.this$0).build((Schema)this.$schemaB);
            }
            {
                this.this$0 = classCarpenterTest;
                this.$schemaB = classSchema;
            }
        });
    }

    @Test(timeout=300000L)
    public final void unimplemented interface method with lenient = true() {
        ClassCarpenterImpl cc = new ClassCarpenterImpl((ClassWhitelist)AllWhitelist.INSTANCE, null, true, 2, null);
        ClassSchema schemaA = new ClassSchema("gen.A", MapsKt.mapOf((Pair)TuplesKt.to((Object)"a", (Object)new NonNullableField(String.class))), null, null, 12, null);
        ClassSchema schemaB = new ClassSchema("gen.B", MapsKt.mapOf((Pair)TuplesKt.to((Object)"c", (Object)new NonNullableField(Integer.TYPE))), (Schema)schemaA, CollectionsKt.listOf(DummyInterface.class));
        Class classB = cc.build((Schema)schemaB);
        Object obj = classB.getConstructors()[0].newInstance("xa", 1);
        if (obj == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.corda.serialization.internal.carpenter.ClassCarpenterTest.DummyInterface");
        }
        DummyInterface b = (DummyInterface)obj;
        AssertionsKt.assertEquals$default((Object)"xa", (Object)b.getA(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)1, (Object)classB.getMethod("getC", new Class[0]).invoke((Object)b, new Object[0]), null, (int)4, null);
        Assertions.assertThatExceptionOfType(AbstractMethodError.class).isThrownBy(new ThrowableAssert.ThrowingCallable(b){
            final /* synthetic */ DummyInterface $b;

            public final void call() {
                this.$b.getB();
            }
            {
                this.$b = dummyInterface;
            }
        });
    }

    @Test(timeout=300000L)
    public final void generate interface() {
        boolean bl;
        InterfaceSchema schema1 = new InterfaceSchema("gen.Interface", MapsKt.mapOf((Pair)TuplesKt.to((Object)"a", (Object)new NonNullableField(Integer.TYPE))), null, null, 12, null);
        Class iface = this.cc.build((Schema)schema1);
        boolean bl2 = iface.isInterface();
        if (!bl2) {
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Constructor<?>[] constructorArray = iface.getConstructors();
        Intrinsics.checkExpressionValueIsNotNull(constructorArray, (String)"iface.constructors");
        Constructor<?>[] constructorArray2 = constructorArray;
        boolean bl3 = bl = constructorArray2.length == 0;
        if (!bl) {
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        AssertionsKt.assertEquals$default((Object)iface.getDeclaredMethods().length, (Object)1, null, (int)4, null);
        Method method = iface.getDeclaredMethods()[0];
        Intrinsics.checkExpressionValueIsNotNull((Object)method, (String)"iface.declaredMethods[0]");
        AssertionsKt.assertEquals$default((Object)method.getName(), (Object)"getA", null, (int)4, null);
        ClassSchema schema2 = new ClassSchema("gen.Derived", MapsKt.mapOf((Pair)TuplesKt.to((Object)"a", (Object)new NonNullableField(Integer.TYPE))), null, CollectionsKt.listOf((Object)iface), 4, null);
        Class clazz = this.cc.build((Schema)schema2);
        int testA = 42;
        Object obj = clazz.getConstructors()[0].newInstance(testA);
        if (obj == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.corda.serialization.internal.carpenter.SimpleFieldAccess");
        }
        SimpleFieldAccess i2 = (SimpleFieldAccess)obj;
        AssertionsKt.assertEquals$default((Object)testA, (Object)i2.get("a"), null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void generate multiple interfaces() {
        InterfaceSchema iFace1 = new InterfaceSchema("gen.Interface1", MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"a", (Object)new NonNullableField(Integer.TYPE)), TuplesKt.to((Object)"b", (Object)new NonNullableField(String.class))}), null, null, 12, null);
        InterfaceSchema iFace2 = new InterfaceSchema("gen.Interface2", MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"c", (Object)new NonNullableField(Integer.TYPE)), TuplesKt.to((Object)"d", (Object)new NonNullableField(String.class))}), null, null, 12, null);
        ClassSchema class1 = new ClassSchema("gen.Derived", MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"a", (Object)new NonNullableField(Integer.TYPE)), TuplesKt.to((Object)"b", (Object)new NonNullableField(String.class)), TuplesKt.to((Object)"c", (Object)new NonNullableField(Integer.TYPE)), TuplesKt.to((Object)"d", (Object)new NonNullableField(String.class))}), null, CollectionsKt.listOf((Object[])new Class[]{this.cc.build((Schema)iFace1), this.cc.build((Schema)iFace2)}), 4, null);
        Class clazz = this.cc.build((Schema)class1);
        int testA = 42;
        String testB = "don't touch me, I'm scared";
        int testC = 57005;
        String testD = "wibble";
        Object obj = clazz.getConstructors()[0].newInstance(testA, testB, testC, testD);
        if (obj == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.corda.serialization.internal.carpenter.SimpleFieldAccess");
        }
        SimpleFieldAccess i2 = (SimpleFieldAccess)obj;
        AssertionsKt.assertEquals$default((Object)testA, (Object)i2.get("a"), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)testB, (Object)i2.get("b"), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)testC, (Object)i2.get("c"), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)testD, (Object)i2.get("d"), null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void interface implementing interface() {
        InterfaceSchema iFace1 = new InterfaceSchema("gen.Interface1", MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"a", (Object)new NonNullableField(Integer.TYPE)), TuplesKt.to((Object)"b", (Object)new NonNullableField(String.class))}), null, null, 12, null);
        InterfaceSchema iFace2 = new InterfaceSchema("gen.Interface2", MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"c", (Object)new NonNullableField(Integer.TYPE)), TuplesKt.to((Object)"d", (Object)new NonNullableField(String.class))}), null, CollectionsKt.listOf((Object)this.cc.build((Schema)iFace1)), 4, null);
        ClassSchema class1 = new ClassSchema("gen.Derived", MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"a", (Object)new NonNullableField(Integer.TYPE)), TuplesKt.to((Object)"b", (Object)new NonNullableField(String.class)), TuplesKt.to((Object)"c", (Object)new NonNullableField(Integer.TYPE)), TuplesKt.to((Object)"d", (Object)new NonNullableField(String.class))}), null, CollectionsKt.listOf((Object)this.cc.build((Schema)iFace2)), 4, null);
        Class clazz = this.cc.build((Schema)class1);
        int testA = 99;
        String testB = "green is not a creative colour";
        int testC = 7;
        String testD = "I like jam";
        Object obj = clazz.getConstructors()[0].newInstance(testA, testB, testC, testD);
        if (obj == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.corda.serialization.internal.carpenter.SimpleFieldAccess");
        }
        SimpleFieldAccess i2 = (SimpleFieldAccess)obj;
        AssertionsKt.assertEquals$default((Object)testA, (Object)i2.get("a"), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)testB, (Object)i2.get("b"), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)testC, (Object)i2.get("c"), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)testD, (Object)i2.get("d"), null, (int)4, null);
    }

    @Test(expected=IllegalArgumentException.class, timeout=300000L)
    public final void null parameter small int() {
        String className = "iEnjoySwede";
        ClassSchema schema = new ClassSchema("gen." + className, MapsKt.mapOf((Pair)TuplesKt.to((Object)"a", (Object)new NonNullableField(Integer.TYPE))), null, null, 12, null);
        Class clazz = this.cc.build((Schema)schema);
        Integer a = null;
        clazz.getConstructors()[0].newInstance(a);
    }

    @Test(expected=NullablePrimitiveException.class, timeout=300000L)
    public final void nullable parameter small int() {
        String className = "iEnjoySwede";
        ClassSchema schema = new ClassSchema("gen." + className, MapsKt.mapOf((Pair)TuplesKt.to((Object)"a", (Object)new NullableField(Integer.TYPE))), null, null, 12, null);
        this.cc.build((Schema)schema);
    }

    @Test(timeout=300000L)
    public final void nullable parameter integer() {
        String className = "iEnjoyWibble";
        ClassSchema schema = new ClassSchema("gen." + className, MapsKt.mapOf((Pair)TuplesKt.to((Object)"a", (Object)new NullableField(Integer.class))), null, null, 12, null);
        Class clazz = this.cc.build((Schema)schema);
        Integer a1 = null;
        clazz.getConstructors()[0].newInstance(a1);
        Integer a2 = 10;
        clazz.getConstructors()[0].newInstance(a2);
    }

    @Test(timeout=300000L)
    public final void non nullable parameter integer with non null() {
        String className = "iEnjoyWibble";
        ClassSchema schema = new ClassSchema("gen." + className, MapsKt.mapOf((Pair)TuplesKt.to((Object)"a", (Object)new NonNullableField(Integer.class))), null, null, 12, null);
        Class clazz = this.cc.build((Schema)schema);
        Integer a = 10;
        clazz.getConstructors()[0].newInstance(a);
    }

    @Test(expected=InvocationTargetException.class, timeout=300000L)
    public final void non nullable parameter integer with null() {
        String className = "iEnjoyWibble";
        ClassSchema schema = new ClassSchema("gen." + className, MapsKt.mapOf((Pair)TuplesKt.to((Object)"a", (Object)new NonNullableField(Integer.class))), null, null, 12, null);
        Class clazz = this.cc.build((Schema)schema);
        Integer a = null;
        clazz.getConstructors()[0].newInstance(a);
    }

    @Test(timeout=300000L)
    public final void int array() {
        Object arr;
        String className = "iEnjoyPotato";
        ClassSchema schema = new ClassSchema("gen." + className, MapsKt.mapOf((Pair)TuplesKt.to((Object)"a", (Object)new NonNullableField(int[].class))), null, null, 12, null);
        Class clazz = this.cc.build((Schema)schema);
        Object obj = clazz.getConstructors()[0].newInstance(new Object[]{new int[]{1, 2, 3}});
        if (obj == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.corda.serialization.internal.carpenter.SimpleFieldAccess");
        }
        SimpleFieldAccess i2 = (SimpleFieldAccess)obj;
        Object object = arr = clazz.getMethod("getA", new Class[0]).invoke((Object)i2, new Object[0]);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.IntArray");
        }
        AssertionsKt.assertEquals$default((Object)1, (Object)((int[])object)[0], null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)2, (Object)((int[])arr)[1], null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)3, (Object)((int[])arr)[2], null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)(className + "{a=[1, 2, 3]}"), (Object)i2.toString(), null, (int)4, null);
    }

    @Test(expected=InvocationTargetException.class, timeout=300000L)
    public final void nullable int array throws() {
        String className = "iEnjoySwede";
        ClassSchema schema = new ClassSchema("gen." + className, MapsKt.mapOf((Pair)TuplesKt.to((Object)"a", (Object)new NonNullableField(int[].class))), null, null, 12, null);
        Class clazz = this.cc.build((Schema)schema);
        int[] a = null;
        clazz.getConstructors()[0].newInstance(new Object[]{a});
    }

    @Test(timeout=300000L)
    public final void integer array() {
        String className = "iEnjoyFlan";
        ClassSchema schema = new ClassSchema("gen." + className, MapsKt.mapOf((Pair)TuplesKt.to((Object)"a", (Object)new NonNullableField(Integer[].class))), null, null, 12, null);
        Class clazz = this.cc.build((Schema)schema);
        Object obj = clazz.getConstructors()[0].newInstance(new Object[]{new Integer[]{1, 2, 3}});
        if (obj == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.corda.serialization.internal.carpenter.SimpleFieldAccess");
        }
        SimpleFieldAccess i2 = (SimpleFieldAccess)obj;
        Integer[] arr = (Integer[])InternalUtils.uncheckedCast((Object)clazz.getMethod("getA", new Class[0]).invoke((Object)i2, new Object[0]));
        AssertionsKt.assertEquals$default((Object)1, (Object)arr[0], null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)2, (Object)arr[1], null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)3, (Object)arr[2], null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)(className + "{a=[1, 2, 3]}"), (Object)i2.toString(), null, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void int array with ints() {
        Map map;
        void $receiver$iv$iv;
        void $receiver$iv;
        ClassSchema classSchema;
        String className = "iEnjoyCrumble";
        Map map2 = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"a", Integer.TYPE), TuplesKt.to((Object)"b", int[].class), TuplesKt.to((Object)"c", Integer.TYPE)});
        String string = "gen." + className;
        ClassSchema classSchema2 = classSchema;
        ClassSchema classSchema3 = classSchema;
        void var4_6 = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$receiver$iv.size()));
        Iterable $receiver$iv$iv$iv = $receiver$iv$iv.entrySet();
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            Object k = it$iv$iv.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            map = map3;
            NonNullableField nonNullableField = new NonNullableField((Class)it.getValue());
            map.put(k2, nonNullableField);
        }
        map = destination$iv$iv;
        classSchema2(string, map, null, null, 12, null);
        ClassSchema schema = classSchema3;
        Class clazz = this.cc.build((Schema)schema);
        Object obj = clazz.getConstructors()[0].newInstance(2, new int[]{4, 8}, 16);
        if (obj == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.corda.serialization.internal.carpenter.SimpleFieldAccess");
        }
        SimpleFieldAccess i2 = (SimpleFieldAccess)obj;
        AssertionsKt.assertEquals$default((Object)2, (Object)clazz.getMethod("getA", new Class[0]).invoke((Object)i2, new Object[0]), null, (int)4, null);
        Object object = clazz.getMethod("getB", new Class[0]).invoke((Object)i2, new Object[0]);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.IntArray");
        }
        AssertionsKt.assertEquals$default((Object)4, (Object)((int[])object)[0], null, (int)4, null);
        Object object2 = clazz.getMethod("getB", new Class[0]).invoke((Object)i2, new Object[0]);
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.IntArray");
        }
        AssertionsKt.assertEquals$default((Object)8, (Object)((int[])object2)[1], null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)16, (Object)clazz.getMethod("getC", new Class[0]).invoke((Object)i2, new Object[0]), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)(className + "{a=2, b=[4, 8], c=16}"), (Object)i2.toString(), null, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void multiple int arrays() {
        Map map;
        void $receiver$iv$iv;
        void $receiver$iv;
        ClassSchema classSchema;
        String className = "iEnjoyJam";
        Map map2 = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"a", int[].class), TuplesKt.to((Object)"b", Integer.TYPE), TuplesKt.to((Object)"c", int[].class)});
        String string = "gen." + className;
        ClassSchema classSchema2 = classSchema;
        ClassSchema classSchema3 = classSchema;
        void var4_6 = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$receiver$iv.size()));
        Iterable $receiver$iv$iv$iv = $receiver$iv$iv.entrySet();
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            Object k = it$iv$iv.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            map = map3;
            NonNullableField nonNullableField = new NonNullableField((Class)it.getValue());
            map.put(k2, nonNullableField);
        }
        map = destination$iv$iv;
        classSchema2(string, map, null, null, 12, null);
        ClassSchema schema = classSchema3;
        Class clazz = this.cc.build((Schema)schema);
        Object i2 = clazz.getConstructors()[0].newInstance(new int[]{1, 2}, 3, new int[]{4, 5, 6});
        Object object = clazz.getMethod("getA", new Class[0]).invoke(i2, new Object[0]);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.IntArray");
        }
        AssertionsKt.assertEquals$default((Object)1, (Object)((int[])object)[0], null, (int)4, null);
        Object object2 = clazz.getMethod("getA", new Class[0]).invoke(i2, new Object[0]);
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.IntArray");
        }
        AssertionsKt.assertEquals$default((Object)2, (Object)((int[])object2)[1], null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)3, (Object)clazz.getMethod("getB", new Class[0]).invoke(i2, new Object[0]), null, (int)4, null);
        Object object3 = clazz.getMethod("getC", new Class[0]).invoke(i2, new Object[0]);
        if (object3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.IntArray");
        }
        AssertionsKt.assertEquals$default((Object)4, (Object)((int[])object3)[0], null, (int)4, null);
        Object object4 = clazz.getMethod("getC", new Class[0]).invoke(i2, new Object[0]);
        if (object4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.IntArray");
        }
        AssertionsKt.assertEquals$default((Object)5, (Object)((int[])object4)[1], null, (int)4, null);
        Object object5 = clazz.getMethod("getC", new Class[0]).invoke(i2, new Object[0]);
        if (object5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.IntArray");
        }
        AssertionsKt.assertEquals$default((Object)6, (Object)((int[])object5)[2], null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)(className + "{a=[1, 2], b=3, c=[4, 5, 6]}"), (Object)i2.toString(), null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void string array() {
        String className = "iEnjoyToast";
        ClassSchema schema = new ClassSchema("gen." + className, MapsKt.mapOf((Pair)TuplesKt.to((Object)"a", (Object)new NullableField(String[].class))), null, null, 12, null);
        Class clazz = this.cc.build((Schema)schema);
        Object i2 = clazz.getConstructors()[0].newInstance(new Object[]{new String[]{"toast", "butter", "jam"}});
        String[] arr = (String[])InternalUtils.uncheckedCast((Object)clazz.getMethod("getA", new Class[0]).invoke(i2, new Object[0]));
        AssertionsKt.assertEquals$default((Object)"toast", (Object)arr[0], null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)"butter", (Object)arr[1], null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)"jam", (Object)arr[2], null, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void string arrays() {
        Map map;
        void $receiver$iv$iv;
        void $receiver$iv;
        ClassSchema classSchema;
        String className = "iEnjoyToast";
        Map map2 = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"a", String[].class), TuplesKt.to((Object)"b", String.class), TuplesKt.to((Object)"c", String[].class)});
        String string = "gen." + className;
        ClassSchema classSchema2 = classSchema;
        ClassSchema classSchema3 = classSchema;
        void var4_6 = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$receiver$iv.size()));
        Iterable $receiver$iv$iv$iv = $receiver$iv$iv.entrySet();
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            Object k = it$iv$iv.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            map = map3;
            NullableField nullableField = new NullableField((Class)it.getValue());
            map.put(k2, nullableField);
        }
        map = destination$iv$iv;
        classSchema2(string, map, null, null, 12, null);
        ClassSchema schema = classSchema3;
        Class clazz = this.cc.build((Schema)schema);
        Object i2 = clazz.getConstructors()[0].newInstance(new String[]{"bread", "spread", "cheese"}, "and on the side", new String[]{"some pickles", "some fries"});
        String[] arr1 = (String[])InternalUtils.uncheckedCast((Object)clazz.getMethod("getA", new Class[0]).invoke(i2, new Object[0]));
        String[] arr2 = (String[])InternalUtils.uncheckedCast((Object)clazz.getMethod("getC", new Class[0]).invoke(i2, new Object[0]));
        AssertionsKt.assertEquals$default((Object)"bread", (Object)arr1[0], null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)"spread", (Object)arr1[1], null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)"cheese", (Object)arr1[2], null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)"and on the side", (Object)clazz.getMethod("getB", new Class[0]).invoke(i2, new Object[0]), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)"some pickles", (Object)arr2[0], null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)"some fries", (Object)arr2[1], null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void nullable sets annotations() {
        String className = "iEnjoyJam";
        ClassSchema schema = new ClassSchema("gen." + className, MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"a", (Object)new NullableField(String.class)), TuplesKt.to((Object)"b", (Object)new NonNullableField(String.class))}), null, null, 12, null);
        Class clazz = this.cc.build((Schema)schema);
        AssertionsKt.assertEquals$default((Object)2, (Object)clazz.getDeclaredFields().length, null, (int)4, null);
        Integer n = 1;
        Field field = clazz.getDeclaredField("a");
        Intrinsics.checkExpressionValueIsNotNull((Object)field, (String)"clazz.getDeclaredField(\"a\")");
        AssertionsKt.assertEquals$default((Object)n, (Object)field.getAnnotations().length, null, (int)4, null);
        Field field2 = clazz.getDeclaredField("a");
        Intrinsics.checkExpressionValueIsNotNull((Object)field2, (String)"clazz.getDeclaredField(\"a\")");
        AssertionsKt.assertEquals$default(Nullable.class, (Object)JvmClassMappingKt.getJavaClass((KClass)JvmClassMappingKt.getAnnotationClass((Annotation)field2.getAnnotations()[0])), null, (int)4, null);
        Integer n2 = 1;
        Field field3 = clazz.getDeclaredField("b");
        Intrinsics.checkExpressionValueIsNotNull((Object)field3, (String)"clazz.getDeclaredField(\"b\")");
        AssertionsKt.assertEquals$default((Object)n2, (Object)field3.getAnnotations().length, null, (int)4, null);
        Field field4 = clazz.getDeclaredField("b");
        Intrinsics.checkExpressionValueIsNotNull((Object)field4, (String)"clazz.getDeclaredField(\"b\")");
        AssertionsKt.assertEquals$default(Nonnull.class, (Object)JvmClassMappingKt.getJavaClass((KClass)JvmClassMappingKt.getAnnotationClass((Annotation)field4.getAnnotations()[0])), null, (int)4, null);
        Integer n3 = 1;
        Method method = clazz.getMethod("getA", new Class[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)method, (String)"clazz.getMethod(\"getA\")");
        AssertionsKt.assertEquals$default((Object)n3, (Object)method.getAnnotations().length, null, (int)4, null);
        Method method2 = clazz.getMethod("getA", new Class[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)method2, (String)"clazz.getMethod(\"getA\")");
        AssertionsKt.assertEquals$default(Nullable.class, (Object)JvmClassMappingKt.getJavaClass((KClass)JvmClassMappingKt.getAnnotationClass((Annotation)method2.getAnnotations()[0])), null, (int)4, null);
        Integer n4 = 1;
        Method method3 = clazz.getMethod("getB", new Class[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)method3, (String)"clazz.getMethod(\"getB\")");
        AssertionsKt.assertEquals$default((Object)n4, (Object)method3.getAnnotations().length, null, (int)4, null);
        Method method4 = clazz.getMethod("getB", new Class[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)method4, (String)"clazz.getMethod(\"getB\")");
        AssertionsKt.assertEquals$default(Nonnull.class, (Object)JvmClassMappingKt.getJavaClass((KClass)JvmClassMappingKt.getAnnotationClass((Annotation)method4.getAnnotations()[0])), null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void beanTest() {
        PropertyDescriptor propertyDescriptor;
        PropertyDescriptor propertyDescriptor2;
        Object var11_5;
        block3: {
            PropertyDescriptor propertyDescriptor3;
            PropertyDescriptor propertyDescriptor4;
            PropertyDescriptor it;
            int n;
            int n2;
            PropertyDescriptor[] propertyDescriptorArray;
            PropertyDescriptor[] propertyDescriptorArray2;
            PropertyDescriptor[] descriptors;
            block2: {
                ClassSchema schema = new ClassSchema("pantsPantsPants", MapsKt.mapOf((Pair)TuplesKt.to((Object)"a", (Object)new NonNullableField(Integer.class))), null, null, 12, null);
                Class clazz = this.cc.build((Schema)schema);
                BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
                Intrinsics.checkExpressionValueIsNotNull((Object)beanInfo, (String)"Introspector.getBeanInfo(clazz)");
                descriptors = beanInfo.getPropertyDescriptors();
                AssertionsKt.assertEquals$default((Object)2, (Object)descriptors.length, null, (int)4, null);
                Intrinsics.checkExpressionValueIsNotNull((Object)descriptors, (String)"descriptors");
                propertyDescriptorArray2 = descriptors;
                var11_5 = null;
                propertyDescriptorArray = propertyDescriptorArray2;
                n2 = propertyDescriptorArray.length;
                for (n = 0; n < n2; ++n) {
                    PropertyDescriptor propertyDescriptor5 = it = (propertyDescriptor4 = propertyDescriptorArray[n]);
                    Intrinsics.checkExpressionValueIsNotNull((Object)propertyDescriptor5, (String)"it");
                    if (!Intrinsics.areEqual((Object)propertyDescriptor5.getName(), (Object)"a")) continue;
                    propertyDescriptor3 = propertyDescriptor4;
                    break block2;
                }
                propertyDescriptor3 = null;
            }
            propertyDescriptor2 = propertyDescriptor3;
            AssertionsKt.assertNotEquals$default(var11_5, propertyDescriptor2, null, (int)4, null);
            propertyDescriptorArray2 = descriptors;
            var11_5 = null;
            propertyDescriptorArray = propertyDescriptorArray2;
            n2 = propertyDescriptorArray.length;
            for (n = 0; n < n2; ++n) {
                PropertyDescriptor propertyDescriptor6 = it = (propertyDescriptor4 = propertyDescriptorArray[n]);
                Intrinsics.checkExpressionValueIsNotNull((Object)propertyDescriptor6, (String)"it");
                if (!Intrinsics.areEqual((Object)propertyDescriptor6.getName(), (Object)"class")) continue;
                propertyDescriptor = propertyDescriptor4;
                break block3;
            }
            propertyDescriptor = null;
        }
        propertyDescriptor2 = propertyDescriptor;
        AssertionsKt.assertNotEquals$default(var11_5, (Object)propertyDescriptor2, null, (int)4, null);
    }

    @NotNull
    public static final /* synthetic */ ClassCarpenterImpl access$getCc$p(ClassCarpenterTest $this) {
        return $this.cc;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lnet/corda/serialization/internal/carpenter/ClassCarpenterTest$DummyInterface;", "", "a", "", "getA", "()Ljava/lang/String;", "b", "", "getB", "()I", "serialization"})
    public static interface DummyInterface {
        @NotNull
        public String getA();

        public int getB();
    }
}

