/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp.custom;

import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.corda.serialization.internal.amqp.SerializerFactory;
import net.corda.serialization.internal.amqp.custom.OptionalSerializer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007J\b\u0010\u0006\u001a\u00020\u0004H\u0007J\b\u0010\u0007\u001a\u00020\u0004H\u0007\u00a8\u0006\b"}, d2={"Lnet/corda/serialization/internal/amqp/custom/OptionalSerializerTest;", "", "()V", "should convert optional with item to proxy", "", "should convert optional without item to empty proxy", "should convert proxy with item to empty optional ", "should convert proxy without item to empty optional ", "serialization"})
public final class OptionalSerializerTest {
    @Test(timeout=300000L)
    public final void should convert optional with item to proxy() {
        Optional<String> opt = Optional.of("GenericTestString");
        Object object = Mockito.mock(SerializerFactory.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"Mockito.mock(SerializerFactory::class.java)");
        OptionalSerializer optionalSerializer = new OptionalSerializer((SerializerFactory)object);
        Optional<String> optional = opt;
        Intrinsics.checkExpressionValueIsNotNull(optional, (String)"opt");
        OptionalSerializer.OptionalProxy proxy = optionalSerializer.toProxy(optional);
        Assert.assertThat((Object)proxy.getItem(), (Matcher)CoreMatchers.is((Object)"GenericTestString"));
    }

    @Test(timeout=300000L)
    public final void should convert optional without item to empty proxy() {
        Optional<Object> opt = Optional.ofNullable(null);
        Object object = Mockito.mock(SerializerFactory.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"Mockito.mock(SerializerFactory::class.java)");
        OptionalSerializer optionalSerializer = new OptionalSerializer((SerializerFactory)object);
        Optional<Object> optional = opt;
        Intrinsics.checkExpressionValueIsNotNull(optional, (String)"opt");
        OptionalSerializer.OptionalProxy proxy = optionalSerializer.toProxy(optional);
        Assert.assertThat((Object)proxy.getItem(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test(timeout=300000L)
    public final void should convert proxy without item to empty optional () {
        OptionalSerializer.OptionalProxy proxy = new OptionalSerializer.OptionalProxy(null);
        Object object = Mockito.mock(SerializerFactory.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"Mockito.mock(SerializerFactory::class.java)");
        Optional opt = new OptionalSerializer((SerializerFactory)object).fromProxy(proxy);
        Assert.assertThat((Object)opt.isPresent(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test(timeout=300000L)
    public final void should convert proxy with item to empty optional () {
        OptionalSerializer.OptionalProxy proxy = new OptionalSerializer.OptionalProxy((Object)"GenericTestString");
        Object object = Mockito.mock(SerializerFactory.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"Mockito.mock(SerializerFactory::class.java)");
        Optional opt = new OptionalSerializer((SerializerFactory)object).fromProxy(proxy);
        Assert.assertThat(opt.get(), (Matcher)CoreMatchers.is((Object)"GenericTestString"));
    }
}

