/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp;

import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.test.AssertionsKt;
import net.corda.core.serialization.ClassWhitelist;
import net.corda.serialization.internal.AllWhitelist;
import net.corda.serialization.internal.amqp.CachingCustomSerializerRegistry;
import net.corda.serialization.internal.amqp.CustomSerializerRegistry;
import net.corda.serialization.internal.amqp.DefaultDescriptorBasedSerializerRegistry;
import net.corda.serialization.internal.amqp.DescriptorBasedSerializerRegistry;
import net.corda.serialization.internal.amqp.WhitelistBasedTypeModelConfiguration;
import net.corda.serialization.internal.model.ConfigurableLocalTypeModel;
import net.corda.serialization.internal.model.LocalPropertyInformation;
import net.corda.serialization.internal.model.LocalTypeInformation;
import net.corda.serialization.internal.model.LocalTypeModelConfiguration;
import net.corda.serialization.internal.model.TypeModellingFingerPrinter;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0003\u0012\u0013\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0007J\b\u0010\u0011\u001a\u00020\u0010H\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lnet/corda/serialization/internal/amqp/TypeModellingFingerPrinterTests;", "", "()V", "customRegistry", "Lnet/corda/serialization/internal/amqp/CachingCustomSerializerRegistry;", "getCustomRegistry", "()Lnet/corda/serialization/internal/amqp/CachingCustomSerializerRegistry;", "descriptorBasedSerializerRegistry", "Lnet/corda/serialization/internal/amqp/DefaultDescriptorBasedSerializerRegistry;", "getDescriptorBasedSerializerRegistry", "()Lnet/corda/serialization/internal/amqp/DefaultDescriptorBasedSerializerRegistry;", "fingerprinter", "Lnet/corda/serialization/internal/model/TypeModellingFingerPrinter;", "getFingerprinter", "()Lnet/corda/serialization/internal/model/TypeModellingFingerPrinter;", "Object and wildcard are fingerprinted differently", "", "can fingerprint type with non-serializable type parameter", "HasTypeParameter", "NonSerializable", "SuppliesTypeParameter", "serialization"})
public final class TypeModellingFingerPrinterTests {
    @NotNull
    private final DefaultDescriptorBasedSerializerRegistry descriptorBasedSerializerRegistry = new DefaultDescriptorBasedSerializerRegistry();
    @NotNull
    private final CachingCustomSerializerRegistry customRegistry = new CachingCustomSerializerRegistry((DescriptorBasedSerializerRegistry)this.descriptorBasedSerializerRegistry);
    @NotNull
    private final TypeModellingFingerPrinter fingerprinter;

    @NotNull
    public final DefaultDescriptorBasedSerializerRegistry getDescriptorBasedSerializerRegistry() {
        return this.descriptorBasedSerializerRegistry;
    }

    @NotNull
    public final CachingCustomSerializerRegistry getCustomRegistry() {
        return this.customRegistry;
    }

    @NotNull
    public final TypeModellingFingerPrinter getFingerprinter() {
        return this.fingerprinter;
    }

    @Test(timeout=300000L)
    public final void Object and wildcard are fingerprinted differently() {
        LocalTypeInformation.Top objectType = LocalTypeInformation.Top.INSTANCE;
        LocalTypeInformation.Unknown anyType = LocalTypeInformation.Unknown.INSTANCE;
        AssertionsKt.assertNotEquals$default((Object)this.fingerprinter.fingerprint((LocalTypeInformation)objectType), (Object)this.fingerprinter.fingerprint((LocalTypeInformation)anyType), null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void can fingerprint type with non-serializable type parameter() {
        ConfigurableLocalTypeModel typeModel = new ConfigurableLocalTypeModel((LocalTypeModelConfiguration)new WhitelistBasedTypeModelConfiguration((ClassWhitelist)AllWhitelist.INSTANCE, (CustomSerializerRegistry)this.customRegistry));
        LocalTypeInformation typeInfo = typeModel.inspect((Type)((Object)SuppliesTypeParameter.class));
        Assertions.assertThat((Object)typeInfo).isInstanceOf(LocalTypeInformation.Composable.class);
        LocalPropertyInformation localPropertyInformation = (LocalPropertyInformation)typeInfo.getPropertiesOrEmptyMap().get("value");
        Object object = localPropertyInformation != null ? localPropertyInformation.getType() : null;
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.corda.serialization.internal.model.LocalTypeInformation.Composable");
        }
        LocalTypeInformation.Composable propertyTypeInfo = (LocalTypeInformation.Composable)object;
        Assertions.assertThat(propertyTypeInfo.getTypeParameters().get(0)).isInstanceOf(LocalTypeInformation.NonComposable.class);
        this.fingerprinter.fingerprint(typeInfo);
    }

    public TypeModellingFingerPrinterTests() {
        CustomSerializerRegistry customSerializerRegistry = (CustomSerializerRegistry)this.customRegistry;
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        Intrinsics.checkExpressionValueIsNotNull((Object)classLoader, (String)"ClassLoader.getSystemClassLoader()");
        this.fingerprinter = new TypeModellingFingerPrinter(customSerializerRegistry, classLoader, true);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lnet/corda/serialization/internal/amqp/TypeModellingFingerPrinterTests$NonSerializable;", "", "a", "", "(Ljava/lang/String;)V", "serialization"})
    public static final class NonSerializable {
        public NonSerializable(@NotNull String a) {
            Intrinsics.checkParameterIsNotNull((Object)a, (String)"a");
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lnet/corda/serialization/internal/amqp/TypeModellingFingerPrinterTests$HasTypeParameter;", "T", "", "()V", "serialization"})
    public static final class HasTypeParameter<T> {
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lnet/corda/serialization/internal/amqp/TypeModellingFingerPrinterTests$SuppliesTypeParameter;", "", "value", "Lnet/corda/serialization/internal/amqp/TypeModellingFingerPrinterTests$HasTypeParameter;", "Lnet/corda/serialization/internal/amqp/TypeModellingFingerPrinterTests$NonSerializable;", "(Lnet/corda/serialization/internal/amqp/TypeModellingFingerPrinterTests$HasTypeParameter;)V", "getValue", "()Lnet/corda/serialization/internal/amqp/TypeModellingFingerPrinterTests$HasTypeParameter;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
    public static final class SuppliesTypeParameter {
        @NotNull
        private final HasTypeParameter<NonSerializable> value;

        @NotNull
        public final HasTypeParameter<NonSerializable> getValue() {
            return this.value;
        }

        public SuppliesTypeParameter(@NotNull HasTypeParameter<NonSerializable> value) {
            Intrinsics.checkParameterIsNotNull(value, (String)"value");
            this.value = value;
        }

        @NotNull
        public final HasTypeParameter<NonSerializable> component1() {
            return this.value;
        }

        @NotNull
        public final SuppliesTypeParameter copy(@NotNull HasTypeParameter<NonSerializable> value) {
            Intrinsics.checkParameterIsNotNull(value, (String)"value");
            return new SuppliesTypeParameter(value);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ SuppliesTypeParameter copy$default(SuppliesTypeParameter suppliesTypeParameter, HasTypeParameter hasTypeParameter, int n, Object object) {
            if ((n & 1) != 0) {
                hasTypeParameter = suppliesTypeParameter.value;
            }
            return suppliesTypeParameter.copy(hasTypeParameter);
        }

        @NotNull
        public String toString() {
            return "SuppliesTypeParameter(value=" + this.value + ")";
        }

        public int hashCode() {
            HasTypeParameter<NonSerializable> hasTypeParameter = this.value;
            return hasTypeParameter != null ? hasTypeParameter.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof SuppliesTypeParameter)) break block3;
                    SuppliesTypeParameter suppliesTypeParameter = (SuppliesTypeParameter)object;
                    if (!Intrinsics.areEqual(this.value, suppliesTypeParameter.value)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

