/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp;

import java.io.NotSerializableException;
import java.util.ArrayList;
import java.util.List;
import net.corda.core.serialization.SerializedBytes;
import net.corda.core.utilities.ByteSequence;
import net.corda.serialization.internal.amqp.CompositeType;
import net.corda.serialization.internal.amqp.DeserializationInput;
import net.corda.serialization.internal.amqp.Field;
import net.corda.serialization.internal.amqp.LocalSerializerFactory;
import net.corda.serialization.internal.amqp.Schema;
import net.corda.serialization.internal.amqp.SerializationOutput;
import net.corda.serialization.internal.amqp.SerializerFactory;
import net.corda.serialization.internal.amqp.TypeNotation;
import net.corda.serialization.internal.amqp.testutils.AMQPTestUtilsKt;
import net.corda.serialization.internal.amqp.testutils.TestSerializationContext;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

public class SetterConstructorTests {
    @Test
    public void serialiseC() throws NotSerializableException {
        SerializerFactory factory1 = AMQPTestUtilsKt.testDefaultFactory();
        SerializationOutput ser = new SerializationOutput((LocalSerializerFactory)factory1);
        C c1 = new C();
        c1.setA(1);
        c1.setB(2);
        c1.setC(3);
        Schema schemas = ser.serializeAndReturnSchema((Object)c1, TestSerializationContext.testSerializationContext).component2();
        Assert.assertEquals((long)1L, (long)schemas.component1().size());
        Assert.assertEquals((Object)(this.getClass().getName() + "$C"), (Object)((TypeNotation)schemas.component1().get(0)).getName());
        CompositeType ct = (CompositeType)schemas.component1().get(0);
        Assert.assertEquals((long)3L, (long)ct.getFields().size());
        Assert.assertEquals((Object)"a", (Object)((Field)ct.getFields().get(0)).getName());
        Assert.assertEquals((Object)"b", (Object)((Field)ct.getFields().get(1)).getName());
        Assert.assertEquals((Object)"c", (Object)((Field)ct.getFields().get(2)).getName());
        C2 c2 = new C2();
        c2.setA(1);
        c2.setB(2);
        schemas = ser.serializeAndReturnSchema((Object)c2, TestSerializationContext.testSerializationContext).component2();
        Assert.assertEquals((long)1L, (long)schemas.component1().size());
        Assert.assertEquals((Object)(this.getClass().getName() + "$C2"), (Object)((TypeNotation)schemas.component1().get(0)).getName());
        ct = (CompositeType)schemas.component1().get(0);
        Assert.assertEquals((long)2L, (long)ct.getFields().size());
        Assert.assertEquals((Object)"a", (Object)((Field)ct.getFields().get(0)).getName());
        Assert.assertEquals((Object)"b", (Object)((Field)ct.getFields().get(1)).getName());
        C3 c3 = new C3();
        c3.setA(1);
        c3.setB(2);
        c3.setC(3);
        schemas = ser.serializeAndReturnSchema((Object)c3, TestSerializationContext.testSerializationContext).component2();
        Assert.assertEquals((long)1L, (long)schemas.component1().size());
        Assert.assertEquals((Object)(this.getClass().getName() + "$C3"), (Object)((TypeNotation)schemas.component1().get(0)).getName());
        ct = (CompositeType)schemas.component1().get(0);
        Assert.assertEquals((long)2L, (long)ct.getFields().size());
        Assert.assertEquals((Object)"a", (Object)((Field)ct.getFields().get(0)).getName());
        Assert.assertEquals((Object)"c", (Object)((Field)ct.getFields().get(1)).getName());
        C4 c4 = new C4();
        c4.setA(1);
        c4.setB(2);
        c4.setC(3);
        schemas = ser.serializeAndReturnSchema((Object)c4, TestSerializationContext.testSerializationContext).component2();
        Assert.assertEquals((long)1L, (long)schemas.component1().size());
        Assert.assertEquals((Object)(this.getClass().getName() + "$C4"), (Object)((TypeNotation)schemas.component1().get(0)).getName());
        ct = (CompositeType)schemas.component1().get(0);
        Assert.assertEquals((long)1L, (long)ct.getFields().size());
        Assert.assertEquals((Object)"c", (Object)((Field)ct.getFields().get(0)).getName());
    }

    @Test
    public void deserialiseC() throws NotSerializableException {
        SerializerFactory factory1 = AMQPTestUtilsKt.testDefaultFactory();
        C cPre1 = new C();
        int a = 1;
        int b = 2;
        int c = 3;
        cPre1.setA(a);
        cPre1.setB(b);
        cPre1.setC(c);
        SerializedBytes bytes = new SerializationOutput((LocalSerializerFactory)factory1).serialize((Object)cPre1, TestSerializationContext.testSerializationContext);
        C cPost1 = (C)new DeserializationInput(factory1).deserialize((ByteSequence)bytes, C.class, TestSerializationContext.testSerializationContext);
        Assert.assertEquals((long)a, (long)cPost1.a);
        Assert.assertEquals((long)b, (long)cPost1.b);
        Assert.assertEquals((long)c, (long)cPost1.c);
        C2 cPre2 = new C2();
        cPre2.setA(1);
        cPre2.setB(2);
        C2 cPost2 = (C2)new DeserializationInput(factory1).deserialize((ByteSequence)new SerializationOutput((LocalSerializerFactory)factory1).serialize((Object)cPre2, TestSerializationContext.testSerializationContext), C2.class, TestSerializationContext.testSerializationContext);
        Assert.assertEquals((long)a, (long)cPost2.a);
        Assert.assertEquals((long)b, (long)cPost2.b);
        Assert.assertEquals((long)0L, (long)cPost2.c);
        C3 cPre3 = new C3();
        cPre3.setA(1);
        cPre3.setB(2);
        cPre3.setC(3);
        C3 cPost3 = (C3)new DeserializationInput(factory1).deserialize((ByteSequence)new SerializationOutput((LocalSerializerFactory)factory1).serialize((Object)cPre3, TestSerializationContext.testSerializationContext), C3.class, TestSerializationContext.testSerializationContext);
        Assert.assertEquals((long)a, (long)cPost3.a);
        Assert.assertEquals((long)0L, (long)cPost3.b);
        Assert.assertEquals((long)c, (long)cPost3.c);
        C4 cPre4 = new C4();
        cPre4.setA(1);
        cPre4.setB(2);
        cPre4.setC(3);
        C4 cPost4 = (C4)new DeserializationInput(factory1).deserialize((ByteSequence)new SerializationOutput((LocalSerializerFactory)factory1).serialize((Object)cPre4, TestSerializationContext.testSerializationContext), C4.class, TestSerializationContext.testSerializationContext);
        Assert.assertEquals((long)0L, (long)cPost4.a);
        Assert.assertEquals((long)0L, (long)cPost4.b);
        Assert.assertEquals((long)c, (long)cPost4.c);
    }

    @Test
    public void serialiseOuterAndInner() throws NotSerializableException {
        SerializerFactory factory1 = AMQPTestUtilsKt.testDefaultFactory();
        Inner1 i1 = new Inner1("Hello");
        Inner2 i2 = new Inner2();
        i2.setA(10.5);
        Outer o = new Outer();
        o.setA(i1);
        o.setB("World");
        o.setC(i2);
        Outer post = (Outer)new DeserializationInput(factory1).deserialize((ByteSequence)new SerializationOutput((LocalSerializerFactory)factory1).serialize((Object)o, TestSerializationContext.testSerializationContext), Outer.class, TestSerializationContext.testSerializationContext);
        Assert.assertEquals((Object)"Hello", (Object)post.a.a);
        Assert.assertEquals((Object)"World", (Object)post.b);
        Assert.assertEquals((Object)10.5, (Object)post.c.a);
    }

    @Test
    public void typeMistmatch() {
        SerializerFactory factory1 = AMQPTestUtilsKt.testDefaultFactory();
        TypeMismatch tm = new TypeMismatch();
        tm.setA(10);
        Assert.assertEquals((Object)"10", (Object)tm.getA());
        Assertions.assertThatThrownBy(() -> new SerializationOutput((LocalSerializerFactory)factory1).serialize((Object)tm, TestSerializationContext.testSerializationContext)).isInstanceOf(NotSerializableException.class);
    }

    @Test
    public void typeMistmatch2() {
        SerializerFactory factory1 = AMQPTestUtilsKt.testDefaultFactory();
        TypeMismatch2 tm = new TypeMismatch2();
        tm.setA("10");
        Assert.assertEquals((Object)10, (Object)tm.getA());
        Assertions.assertThatThrownBy(() -> new SerializationOutput((LocalSerializerFactory)factory1).serialize((Object)tm, TestSerializationContext.testSerializationContext)).isInstanceOf(NotSerializableException.class);
    }

    @Test
    public void intList() throws NotSerializableException {
        CIntList cil = new CIntList();
        ArrayList<Integer> l = new ArrayList<Integer>();
        l.add(1);
        l.add(2);
        l.add(3);
        cil.setL(l);
        SerializerFactory factory1 = AMQPTestUtilsKt.testDefaultFactory();
        new DeserializationInput(factory1).deserialize((ByteSequence)new SerializationOutput((LocalSerializerFactory)factory1).serialize((Object)cil, TestSerializationContext.testSerializationContext), CIntList.class, TestSerializationContext.testSerializationContext);
    }

    static class TypeMismatch2 {
        private Integer a;

        TypeMismatch2() {
        }

        public void setA(String a) {
            this.a = Integer.parseInt(a);
        }

        public Integer getA() {
            return this.a;
        }
    }

    static class TypeMismatch {
        private Integer a;

        TypeMismatch() {
        }

        public void setA(Integer a) {
            this.a = a;
        }

        public String getA() {
            return this.a.toString();
        }
    }

    static class Outer {
        private Inner1 a;
        private String b;
        private Inner2 c;

        Outer() {
        }

        public Inner1 getA() {
            return this.a;
        }

        public String getB() {
            return this.b;
        }

        public Inner2 getC() {
            return this.c;
        }

        public void setA(Inner1 a) {
            this.a = a;
        }

        public void setB(String b) {
            this.b = b;
        }

        public void setC(Inner2 c) {
            this.c = c;
        }
    }

    static class Inner2 {
        private Double a;

        Inner2() {
        }

        public Double getA() {
            return this.a;
        }

        public void setA(Double a) {
            this.a = a;
        }
    }

    static class Inner1 {
        private String a;

        public Inner1(String a) {
            this.a = a;
        }

        public String getA() {
            return this.a;
        }
    }

    static class CIntList {
        private List<Integer> l;

        CIntList() {
        }

        public List getL() {
            return this.l;
        }

        public void setL(List<Integer> l) {
            this.l = l;
        }
    }

    static class C4 {
        private int a;
        private int b;
        private int c;

        C4() {
        }

        public int getA() {
            return this.a;
        }

        protected int getB() {
            return this.b;
        }

        public int getC() {
            return this.c;
        }

        private void setA(int a) {
            this.a = a;
        }

        public void setB(int b) {
            this.b = b;
        }

        public void setC(int c) {
            this.c = c;
        }
    }

    static class C3 {
        private int a;
        private int b;
        private int c;

        C3() {
        }

        public int getA() {
            return this.a;
        }

        public int getC() {
            return this.c;
        }

        public void setA(int a) {
            this.a = a;
        }

        public void setB(int b) {
            this.b = b;
        }

        public void setC(int c) {
            this.c = c;
        }
    }

    static class C2 {
        private int a;
        private int b;
        private int c;

        C2() {
        }

        public int getA() {
            return this.a;
        }

        public int getB() {
            return this.b;
        }

        public int getC() {
            return this.c;
        }

        public void setA(int a) {
            this.a = a;
        }

        public void setB(int b) {
            this.b = b;
        }
    }

    static class C {
        private int a;
        private int b;
        private int c;

        C() {
        }

        public int getA() {
            return this.a;
        }

        public int getB() {
            return this.b;
        }

        public int getC() {
            return this.c;
        }

        public void setA(int a) {
            this.a = a;
        }

        public void setB(int b) {
            this.b = b;
        }

        public C setC(int c) {
            this.c = c;
            return this;
        }
    }
}

