/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp;

import java.lang.reflect.Type;
import java.math.BigInteger;
import java.security.PublicKey;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.test.AssertionsKt;
import kotlin.text.StringsKt;
import net.corda.core.contracts.ContractState;
import net.corda.core.contracts.SignatureAttachmentConstraint;
import net.corda.core.contracts.StateAndRef;
import net.corda.core.contracts.StateRef;
import net.corda.core.contracts.TransactionState;
import net.corda.core.crypto.CryptoUtils;
import net.corda.core.crypto.SecureHash;
import net.corda.core.identity.AbstractParty;
import net.corda.core.identity.CordaX500Name;
import net.corda.core.identity.Party;
import net.corda.core.serialization.ConstructorForDeserialization;
import net.corda.core.serialization.SerializableCalculatedProperty;
import net.corda.core.serialization.SerializationContext;
import net.corda.core.serialization.SerializedBytes;
import net.corda.core.utilities.ByteSequence;
import net.corda.serialization.internal.amqp.CustomSerializer;
import net.corda.serialization.internal.amqp.DeserializationInput;
import net.corda.serialization.internal.amqp.LocalSerializerFactory;
import net.corda.serialization.internal.amqp.RoundTripTests;
import net.corda.serialization.internal.amqp.SerializationOutput;
import net.corda.serialization.internal.amqp.SerializerFactory;
import net.corda.serialization.internal.amqp.custom.PublicKeySerializer;
import net.corda.serialization.internal.amqp.testutils.AMQPTestUtilsKt;
import net.corda.serialization.internal.amqp.testutils.TestSerializationContextKt;
import net.corda.serialization.internal.model.LocalTypeInformation;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableAssert;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0011\u0018\u00002\u00020\u0001:\u0005\u0010\u0011\u0012\u0013\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007J\b\u0010\u0006\u001a\u00020\u0004H\u0007J\b\u0010\u0007\u001a\u00020\u0004H\u0007J\b\u0010\b\u001a\u00020\u0004H\u0007J\b\u0010\t\u001a\u00020\u0004H\u0007J\b\u0010\n\u001a\u00020\u0004H\u0007J\b\u0010\u000b\u001a\u00020\u0004H\u0007J\b\u0010\f\u001a\u00020\u0004H\u0007J\b\u0010\r\u001a\u00020\u0004H\u0007J\b\u0010\u000e\u001a\u00020\u0004H\u0007J\b\u0010\u000f\u001a\u00020\u0004H\u0007\u00a8\u0006\u0015"}, d2={"Lnet/corda/serialization/internal/amqp/RoundTripTests;", "", "()V", "calculatedFunction", "", "calculatedValues", "canSerializeClassesWithUntypedProperties", "canSerializeClassesWithUntypedPropertiesWithInternedParty", "inheritedCalculatedFunction", "inheritedCalculatedFunctionIsNotCalculated", "mutableBecomesImmutable", "mutableBecomesImmutable4", "mutableStillMutable", "mutableStillMutable2", "recursiveTypeVariableResolution", "sigConstraintsInterned", "C", "I", "I2", "MembershipState", "OnMembershipChanged", "serialization"})
public final class RoundTripTests {
    @Test(timeout=300000L)
    public final void mutableBecomesImmutable() {
        SerializerFactory factory = AMQPTestUtilsKt.testDefaultFactoryNoEvolution$default(null, 1, null);
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000'\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u001e\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"net/corda/serialization/internal/amqp/RoundTripTests$mutableBecomesImmutable$C", "", "l", "", "", "(Ljava/util/List;)V", "getL", "()Ljava/util/List;", "component1", "copy", "(Ljava/util/List;)Lnet/corda/serialization/internal/amqp/RoundTripTests$mutableBecomesImmutable$C;", "equals", "", "other", "hashCode", "", "toString", "serialization"})
        public final class C {
            @NotNull
            private final List<String> l;

            @NotNull
            public final List<String> getL() {
                return this.l;
            }

            public C(@NotNull List<String> l) {
                Intrinsics.checkParameterIsNotNull(l, (String)"l");
                this.l = l;
            }

            @NotNull
            public final List<String> component1() {
                return this.l;
            }

            @NotNull
            public final C copy(@NotNull List<String> l) {
                Intrinsics.checkParameterIsNotNull(l, (String)"l");
                return new C(l);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ C copy$default(C c, List list, int n, Object object) {
                if ((n & 1) != 0) {
                    list = c.l;
                }
                return c.copy(list);
            }

            @NotNull
            public String toString() {
                return "C(l=" + this.l + ")";
            }

            public int hashCode() {
                List<String> list = this.l;
                return list != null ? ((Object)list).hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof C)) break block3;
                        C c = (C)object;
                        if (!Intrinsics.areEqual(this.l, c.l)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        SerializedBytes bytes = AMQPTestUtilsKt.serialize$default(new SerializationOutput((LocalSerializerFactory)factory), new C(CollectionsKt.mutableListOf((Object[])new String[]{"a", "b", "c"})), null, 2, null);
        DeserializationInput $receiver$iv = new DeserializationInput(factory);
        SerializationContext context$iv = null;
        C newC = (C)$receiver$iv.deserialize((ByteSequence)bytes, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)new ThrowableAssert.ThrowingCallable(newC){
            final /* synthetic */ C $newC;

            public final void call() {
                this.$newC.getL().add("d");
            }
            {
                this.$newC = c;
            }
        }).isInstanceOf(UnsupportedOperationException.class);
    }

    @Test(timeout=300000L)
    public final void mutableStillMutable() {
        SerializerFactory factory = AMQPTestUtilsKt.testDefaultFactoryNoEvolution$default(null, 1, null);
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0017\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0004*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"net/corda/serialization/internal/amqp/RoundTripTests$mutableStillMutable$C", "", "l", "", "", "(Ljava/util/List;)V", "getL", "()Ljava/util/List;", "serialization"})
        public final class C {
            @NotNull
            private final List<String> l;

            @NotNull
            public final List<String> getL() {
                return this.l;
            }

            public C(@NotNull List<String> l) {
                Intrinsics.checkParameterIsNotNull(l, (String)"l");
                this.l = CollectionsKt.toMutableList((Collection)l);
            }
        }
        SerializedBytes bytes = AMQPTestUtilsKt.serialize$default(new SerializationOutput((LocalSerializerFactory)factory), new C(CollectionsKt.mutableListOf((Object[])new String[]{"a", "b", "c"})), null, 2, null);
        DeserializationInput $receiver$iv = new DeserializationInput(factory);
        SerializationContext context$iv = null;
        C newC = (C)$receiver$iv.deserialize((ByteSequence)bytes, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        newC.getL().add("d");
        Assertions.assertThat(newC.getL()).containsExactly((Object[])new String[]{"a", "b", "c", "d"});
    }

    @Test(timeout=300000L)
    public final void mutableStillMutable2() {
        SerializerFactory factory = AMQPTestUtilsKt.testDefaultFactoryNoEvolution$default(null, 1, null);
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000-\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0015\b\u0017\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u00c6\u0003J\u001e\u0010\u000b\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u00c6\u0001\u00a2\u0006\u0002\u0010\fJ\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"net/corda/serialization/internal/amqp/RoundTripTests$mutableStillMutable2$C", "", "l", "", "", "(Ljava/util/Collection;)V", "", "(Ljava/util/List;)V", "getL", "()Ljava/util/List;", "component1", "copy", "(Ljava/util/List;)Lnet/corda/serialization/internal/amqp/RoundTripTests$mutableStillMutable2$C;", "equals", "", "other", "hashCode", "", "toString", "serialization"})
        public final class C {
            @NotNull
            private final List<String> l;

            @NotNull
            public final List<String> getL() {
                return this.l;
            }

            public C(@NotNull List<String> l) {
                Intrinsics.checkParameterIsNotNull(l, (String)"l");
                this.l = l;
            }

            @ConstructorForDeserialization
            public C(@NotNull Collection<String> l) {
                Intrinsics.checkParameterIsNotNull(l, (String)"l");
                this(CollectionsKt.toMutableList(l));
            }

            @NotNull
            public final List<String> component1() {
                return this.l;
            }

            @NotNull
            public final C copy(@NotNull List<String> l) {
                Intrinsics.checkParameterIsNotNull(l, (String)"l");
                return new C(l);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ C copy$default(C c, List list, int n, Object object) {
                if ((n & 1) != 0) {
                    list = c.l;
                }
                return c.copy(list);
            }

            @NotNull
            public String toString() {
                return "C(l=" + this.l + ")";
            }

            public int hashCode() {
                List<String> list = this.l;
                return list != null ? ((Object)list).hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof C)) break block3;
                        C c = (C)object;
                        if (!Intrinsics.areEqual(this.l, c.l)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        SerializedBytes bytes = AMQPTestUtilsKt.serialize$default(new SerializationOutput((LocalSerializerFactory)factory), new C(CollectionsKt.mutableListOf((Object[])new String[]{"a", "b", "c"})), null, 2, null);
        DeserializationInput $receiver$iv = new DeserializationInput(factory);
        SerializationContext context$iv = null;
        C newC = (C)$receiver$iv.deserialize((ByteSequence)bytes, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        newC.getL().add("d");
        Assertions.assertThat(newC.getL()).containsExactly((Object[])new String[]{"a", "b", "c", "d"});
    }

    @Test(timeout=300000L)
    public final void mutableBecomesImmutable4() {
        SerializerFactory factory = AMQPTestUtilsKt.testDefaultFactoryNoEvolution$default(null, 1, null);
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000'\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u001e\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"net/corda/serialization/internal/amqp/RoundTripTests$mutableBecomesImmutable4$C", "", "l", "", "", "(Ljava/util/List;)V", "getL", "()Ljava/util/List;", "component1", "copy", "(Ljava/util/List;)Lnet/corda/serialization/internal/amqp/RoundTripTests$mutableBecomesImmutable4$C;", "equals", "", "other", "hashCode", "", "toString", "serialization"})
        public final class C {
            @NotNull
            private final List<String> l;

            @NotNull
            public final List<String> getL() {
                return this.l;
            }

            public C(@NotNull List<String> l) {
                Intrinsics.checkParameterIsNotNull(l, (String)"l");
                this.l = l;
            }

            @NotNull
            public final List<String> component1() {
                return this.l;
            }

            @NotNull
            public final C copy(@NotNull List<String> l) {
                Intrinsics.checkParameterIsNotNull(l, (String)"l");
                return new C(l);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ C copy$default(C c, List list, int n, Object object) {
                if ((n & 1) != 0) {
                    list = c.l;
                }
                return c.copy(list);
            }

            @NotNull
            public String toString() {
                return "C(l=" + this.l + ")";
            }

            public int hashCode() {
                List<String> list = this.l;
                return list != null ? ((Object)list).hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof C)) break block3;
                        C c = (C)object;
                        if (!Intrinsics.areEqual(this.l, c.l)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        SerializedBytes bytes = AMQPTestUtilsKt.serialize$default(new SerializationOutput((LocalSerializerFactory)factory), new C(CollectionsKt.listOf((Object[])new String[]{"a", "b", "c"})), null, 2, null);
        DeserializationInput $receiver$iv = new DeserializationInput(factory);
        SerializationContext context$iv = null;
        C newC = (C)$receiver$iv.deserialize((ByteSequence)bytes, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        newC.copy(CollectionsKt.plus((Collection)newC.getL(), (Object)"d"));
    }

    @Test(timeout=300000L)
    public final void calculatedValues() {
        SerializerFactory factory = AMQPTestUtilsKt.testDefaultFactoryNoEvolution$default(null, 1, null);
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000!\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\u0018\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0013\u0010\u0007\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0012"}, d2={"net/corda/serialization/internal/amqp/RoundTripTests$calculatedValues$C", "", "i", "", "(I)V", "getI", "()I", "squared", "getSquared", "component1", "copy", "(I)Lnet/corda/serialization/internal/amqp/RoundTripTests$calculatedValues$C;", "equals", "", "other", "hashCode", "toString", "", "serialization"})
        public final class C {
            private final int squared;
            private final int i;

            @SerializableCalculatedProperty
            public final int getSquared() {
                return this.squared;
            }

            public final int getI() {
                return this.i;
            }

            public C(int i2) {
                this.i = i2;
                this.squared = this.i * this.i;
            }

            public final int component1() {
                return this.i;
            }

            @NotNull
            public final C copy(int i2) {
                return new C(i2);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ C copy$default(C c, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = c.i;
                }
                return c.copy(n);
            }

            @NotNull
            public String toString() {
                return "C(i=" + this.i + ")";
            }

            public int hashCode() {
                return Integer.hashCode(this.i);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof C)) break block3;
                        C c = (C)object;
                        if (!(this.i == c.i)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        SerializedBytes bytes = AMQPTestUtilsKt.serialize$default(new SerializationOutput((LocalSerializerFactory)factory), new C(2), null, 2, null);
        DeserializationInput $receiver$iv = new DeserializationInput(factory);
        SerializationContext context$iv = null;
        C deserialized = (C)$receiver$iv.deserialize((ByteSequence)bytes, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        Assertions.assertThat((int)deserialized.getSquared()).isEqualTo(4);
    }

    @Test(timeout=300000L)
    public final void calculatedFunction() {
        C c;
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0015\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\u0004H\u0007R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\n"}, d2={"net/corda/serialization/internal/amqp/RoundTripTests$calculatedFunction$C", "", "()V", "i", "", "getI", "()I", "setI", "(I)V", "getSquared", "serialization"})
        public final class C {
            private int i;

            public final int getI() {
                return this.i;
            }

            public final void setI(int n) {
                this.i = n;
            }

            @SerializableCalculatedProperty
            public final int getSquared() {
                return this.i * this.i;
            }

            public C() {
            }
        }
        C $receiver = c = new C();
        $receiver.setI(2);
        C instance = c;
        SerializerFactory factory = AMQPTestUtilsKt.testDefaultFactoryNoEvolution$default(null, 1, null);
        SerializedBytes bytes = AMQPTestUtilsKt.serialize$default(new SerializationOutput((LocalSerializerFactory)factory), instance, null, 2, null);
        DeserializationInput $receiver$iv = new DeserializationInput(factory);
        SerializationContext context$iv = null;
        C deserialized = (C)$receiver$iv.deserialize((ByteSequence)bytes, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        Assertions.assertThat((int)deserialized.getSquared()).isEqualTo(4);
    }

    @Test(timeout=300000L)
    public final void inheritedCalculatedFunction() {
        C c;
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u000b"}, d2={"net/corda/serialization/internal/amqp/RoundTripTests$inheritedCalculatedFunction$C", "Lnet/corda/serialization/internal/amqp/RoundTripTests$I;", "()V", "i", "", "getI", "()I", "setI", "(I)V", "squared", "getSquared", "serialization"})
        public final class C
        implements I {
            private int i;

            public final int getI() {
                return this.i;
            }

            public final void setI(int n) {
                this.i = n;
            }

            public int getSquared() {
                return this.i * this.i;
            }

            public C() {
            }
        }
        C $receiver = c = new C();
        $receiver.setI(2);
        C instance = c;
        SerializerFactory factory = AMQPTestUtilsKt.testDefaultFactoryNoEvolution$default(null, 1, null);
        SerializedBytes bytes = AMQPTestUtilsKt.serialize$default(new SerializationOutput((LocalSerializerFactory)factory), instance, null, 2, null);
        DeserializationInput $receiver$iv = new DeserializationInput(factory);
        SerializationContext context$iv = null;
        Object object = $receiver$iv.deserialize((ByteSequence)bytes, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.corda.serialization.internal.amqp.RoundTripTests.I");
        }
        I deserialized = (I)object;
        Assertions.assertThat((int)deserialized.getSquared()).isEqualTo(4);
    }

    @Test(timeout=300000L)
    public final void inheritedCalculatedFunctionIsNotCalculated() {
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0013\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"net/corda/serialization/internal/amqp/RoundTripTests$inheritedCalculatedFunctionIsNotCalculated$C", "Lnet/corda/serialization/internal/amqp/RoundTripTests$I;", "squared", "", "(I)V", "getSquared", "()I", "serialization"})
        public final class C
        implements I {
            private final int squared;

            public int getSquared() {
                return this.squared;
            }

            public C(int squared) {
                this.squared = squared;
            }
        }
        C instance = new C(2);
        SerializerFactory factory = AMQPTestUtilsKt.testDefaultFactoryNoEvolution$default(null, 1, null);
        SerializedBytes bytes = AMQPTestUtilsKt.serialize$default(new SerializationOutput((LocalSerializerFactory)factory), instance, null, 2, null);
        DeserializationInput $receiver$iv = new DeserializationInput(factory);
        SerializationContext context$iv = null;
        Object object = $receiver$iv.deserialize((ByteSequence)bytes, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.corda.serialization.internal.amqp.RoundTripTests.I");
        }
        I deserialized = (I)object;
        Assertions.assertThat((int)deserialized.getSquared()).isEqualTo(2);
    }

    @Test(timeout=300000L)
    public final void canSerializeClassesWithUntypedProperties() {
        SerializerFactory serializerFactory;
        MembershipState<Map> data = new MembershipState<Map>(MapsKt.mapOf((Pair)TuplesKt.to((Object)"foo", (Object)"bar")));
        CordaX500Name cordaX500Name = (CordaX500Name)CordaX500Name.Companion.getInterner().intern((Object)new CordaX500Name("Test Corp", "Madrid", "ES"));
        BigInteger bigInteger = BigInteger.valueOf(83L);
        Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger, (String)"BigInteger.valueOf(83)");
        PublicKey publicKey = CryptoUtils.entropyToKeyPair((BigInteger)bigInteger).getPublic();
        Intrinsics.checkExpressionValueIsNotNull((Object)publicKey, (String)"entropyToKeyPair(BigInteger.valueOf(83)).public");
        Party party = new Party(cordaX500Name, publicKey);
        TransactionState transactionState = new TransactionState((ContractState)data, "foo", party, null, null, 24, null);
        StateRef ref = new StateRef((SecureHash)SecureHash.zeroHash, 0);
        OnMembershipChanged instance = new OnMembershipChanged((StateAndRef<? extends MembershipState<? extends Object>>)new StateAndRef(transactionState, ref));
        SerializerFactory $receiver = serializerFactory = AMQPTestUtilsKt.testDefaultFactoryNoEvolution$default(null, 1, null);
        $receiver.register((CustomSerializer)PublicKeySerializer.INSTANCE);
        SerializerFactory factory = serializerFactory;
        SerializedBytes bytes = AMQPTestUtilsKt.serialize$default(new SerializationOutput((LocalSerializerFactory)factory), instance, null, 2, null);
        DeserializationInput $receiver$iv = new DeserializationInput(factory);
        SerializationContext context$iv = null;
        OnMembershipChanged deserialized = (OnMembershipChanged)$receiver$iv.deserialize((ByteSequence)bytes, OnMembershipChanged.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"foo", (Object)"bar")), ((MembershipState)deserialized.getChangedMembership().getState().getData()).getMetadata(), null, (int)4, null);
        AssertionsKt.assertNotSame$default((Object)instance.getChangedMembership().getState().getNotary(), (Object)deserialized.getChangedMembership().getState().getNotary(), null, (int)4, null);
        AssertionsKt.assertSame$default((Object)instance.getChangedMembership().getState().getNotary().getName(), (Object)deserialized.getChangedMembership().getState().getNotary().getName(), null, (int)4, null);
        AssertionsKt.assertSame$default((Object)instance.getChangedMembership().getState().getNotary().getOwningKey(), (Object)deserialized.getChangedMembership().getState().getNotary().getOwningKey(), null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void sigConstraintsInterned() {
        SerializerFactory serializerFactory;
        BigInteger bigInteger = BigInteger.valueOf(83L);
        Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger, (String)"BigInteger.valueOf(83)");
        PublicKey publicKey = CryptoUtils.entropyToKeyPair((BigInteger)bigInteger).getPublic();
        Intrinsics.checkExpressionValueIsNotNull((Object)publicKey, (String)"entropyToKeyPair(BigInteger.valueOf(83)).public");
        SignatureAttachmentConstraint instance = SignatureAttachmentConstraint.Companion.create(publicKey);
        SerializerFactory $receiver = serializerFactory = AMQPTestUtilsKt.testDefaultFactoryNoEvolution$default(null, 1, null);
        $receiver.register((CustomSerializer)PublicKeySerializer.INSTANCE);
        SerializerFactory factory = serializerFactory;
        SerializedBytes bytes = AMQPTestUtilsKt.serialize$default(new SerializationOutput((LocalSerializerFactory)factory), instance, null, 2, null);
        DeserializationInput $receiver$iv = new DeserializationInput(factory);
        SerializationContext context$iv = null;
        SignatureAttachmentConstraint deserialized = (SignatureAttachmentConstraint)$receiver$iv.deserialize((ByteSequence)bytes, SignatureAttachmentConstraint.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertSame$default((Object)instance, (Object)deserialized, null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void canSerializeClassesWithUntypedPropertiesWithInternedParty() {
        SerializerFactory serializerFactory;
        MembershipState<Map> data = new MembershipState<Map>(MapsKt.mapOf((Pair)TuplesKt.to((Object)"foo", (Object)"bar")));
        CordaX500Name cordaX500Name = new CordaX500Name("Test Corp", "Madrid", "ES");
        BigInteger bigInteger = BigInteger.valueOf(83L);
        Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger, (String)"BigInteger.valueOf(83)");
        PublicKey publicKey = CryptoUtils.entropyToKeyPair((BigInteger)bigInteger).getPublic();
        Intrinsics.checkExpressionValueIsNotNull((Object)publicKey, (String)"entropyToKeyPair(BigInteger.valueOf(83)).public");
        Party party = Party.Companion.create(cordaX500Name, publicKey);
        TransactionState transactionState = new TransactionState((ContractState)data, "foo", party, null, null, 24, null);
        StateRef ref = new StateRef((SecureHash)SecureHash.zeroHash, 0);
        OnMembershipChanged instance = new OnMembershipChanged((StateAndRef<? extends MembershipState<? extends Object>>)new StateAndRef(transactionState, ref));
        SerializerFactory $receiver = serializerFactory = AMQPTestUtilsKt.testDefaultFactoryNoEvolution$default(null, 1, null);
        $receiver.register((CustomSerializer)PublicKeySerializer.INSTANCE);
        SerializerFactory factory = serializerFactory;
        SerializedBytes bytes = AMQPTestUtilsKt.serialize$default(new SerializationOutput((LocalSerializerFactory)factory), instance, null, 2, null);
        DeserializationInput $receiver$iv = new DeserializationInput(factory);
        SerializationContext context$iv = null;
        OnMembershipChanged deserialized = (OnMembershipChanged)$receiver$iv.deserialize((ByteSequence)bytes, OnMembershipChanged.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"foo", (Object)"bar")), ((MembershipState)deserialized.getChangedMembership().getState().getData()).getMetadata(), null, (int)4, null);
        AssertionsKt.assertSame$default((Object)instance.getChangedMembership().getState().getNotary(), (Object)deserialized.getChangedMembership().getState().getNotary(), null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void recursiveTypeVariableResolution() {
        SerializerFactory factory = AMQPTestUtilsKt.testDefaultFactoryNoEvolution$default(null, 1, null);
        C instance = new C(CollectionsKt.emptyList());
        SerializedBytes bytes = AMQPTestUtilsKt.serialize$default(new SerializationOutput((LocalSerializerFactory)factory), instance, null, 2, null);
        DeserializationInput $receiver$iv = new DeserializationInput(factory);
        SerializationContext context$iv = null;
        $receiver$iv.deserialize((ByteSequence)bytes, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)StringsKt.trimIndent((String)"\n                C (erased)(t: *): I2<*>\n                  t: *\n                "), (Object)LocalTypeInformation.prettyPrint$default((LocalTypeInformation)factory.getTypeInformation((Type)instance.getClass()), (boolean)false, (int)1, null), null, (int)4, null);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0014\u0010\u0002\u001a\u00020\u00038'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lnet/corda/serialization/internal/amqp/RoundTripTests$I;", "", "squared", "", "getSquared", "()I", "serialization"})
    public static interface I {
        @SerializableCalculatedProperty
        public int getSquared();
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u000e\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0004\u001a\u00028\u0000H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0010J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lnet/corda/serialization/internal/amqp/RoundTripTests$MembershipState;", "T", "", "Lnet/corda/core/contracts/ContractState;", "metadata", "(Ljava/lang/Object;)V", "getMetadata", "()Ljava/lang/Object;", "Ljava/lang/Object;", "participants", "", "Lnet/corda/core/identity/AbstractParty;", "getParticipants", "()Ljava/util/List;", "component1", "copy", "(Ljava/lang/Object;)Lnet/corda/serialization/internal/amqp/RoundTripTests$MembershipState;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
    public static final class MembershipState<T>
    implements ContractState {
        @NotNull
        private final T metadata;

        @NotNull
        public List<AbstractParty> getParticipants() {
            return CollectionsKt.emptyList();
        }

        @NotNull
        public final T getMetadata() {
            return this.metadata;
        }

        public MembershipState(@NotNull T metadata) {
            Intrinsics.checkParameterIsNotNull(metadata, (String)"metadata");
            this.metadata = metadata;
        }

        @NotNull
        public final T component1() {
            return this.metadata;
        }

        @NotNull
        public final MembershipState<T> copy(@NotNull T metadata) {
            Intrinsics.checkParameterIsNotNull(metadata, (String)"metadata");
            return new MembershipState<T>(metadata);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ MembershipState copy$default(MembershipState membershipState, Object object, int n, Object object2) {
            if ((n & 1) != 0) {
                object = membershipState.metadata;
            }
            return membershipState.copy(object);
        }

        @NotNull
        public String toString() {
            return "MembershipState(metadata=" + this.metadata + ")";
        }

        public int hashCode() {
            T t = this.metadata;
            return t != null ? t.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof MembershipState)) break block3;
                    MembershipState membershipState = (MembershipState)object;
                    if (!Intrinsics.areEqual(this.metadata, membershipState.metadata)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0015\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00040\u0003H\u00c6\u0003J\u001f\u0010\t\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lnet/corda/serialization/internal/amqp/RoundTripTests$OnMembershipChanged;", "", "changedMembership", "Lnet/corda/core/contracts/StateAndRef;", "Lnet/corda/serialization/internal/amqp/RoundTripTests$MembershipState;", "(Lnet/corda/core/contracts/StateAndRef;)V", "getChangedMembership", "()Lnet/corda/core/contracts/StateAndRef;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
    public static final class OnMembershipChanged {
        @NotNull
        private final StateAndRef<MembershipState<Object>> changedMembership;

        @NotNull
        public final StateAndRef<MembershipState<Object>> getChangedMembership() {
            return this.changedMembership;
        }

        public OnMembershipChanged(@NotNull StateAndRef<? extends MembershipState<? extends Object>> changedMembership) {
            Intrinsics.checkParameterIsNotNull(changedMembership, (String)"changedMembership");
            this.changedMembership = changedMembership;
        }

        @NotNull
        public final StateAndRef<MembershipState<Object>> component1() {
            return this.changedMembership;
        }

        @NotNull
        public final OnMembershipChanged copy(@NotNull StateAndRef<? extends MembershipState<? extends Object>> changedMembership) {
            Intrinsics.checkParameterIsNotNull(changedMembership, (String)"changedMembership");
            return new OnMembershipChanged(changedMembership);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ OnMembershipChanged copy$default(OnMembershipChanged onMembershipChanged, StateAndRef stateAndRef, int n, Object object) {
            if ((n & 1) != 0) {
                stateAndRef = onMembershipChanged.changedMembership;
            }
            return onMembershipChanged.copy(stateAndRef);
        }

        @NotNull
        public String toString() {
            return "OnMembershipChanged(changedMembership=" + this.changedMembership + ")";
        }

        public int hashCode() {
            StateAndRef<MembershipState<Object>> stateAndRef = this.changedMembership;
            return stateAndRef != null ? stateAndRef.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof OnMembershipChanged)) break block3;
                    OnMembershipChanged onMembershipChanged = (OnMembershipChanged)object;
                    if (!Intrinsics.areEqual(this.changedMembership, onMembershipChanged.changedMembership)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\bf\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002R\u0012\u0010\u0003\u001a\u00028\u0000X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lnet/corda/serialization/internal/amqp/RoundTripTests$I2;", "T", "", "t", "getT", "()Ljava/lang/Object;", "serialization"})
    public static interface I2<T> {
        public T getT();
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0000\u0010\u0001*\b\b\u0001\u0010\u0002*\u0002H\u00012\b\u0012\u0004\u0012\u0002H\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\t\u001a\u00028\u0001H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0007J$\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0004\u001a\u00028\u0001H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0016\u0010\u0004\u001a\u00028\u0001X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lnet/corda/serialization/internal/amqp/RoundTripTests$C;", "A", "B", "Lnet/corda/serialization/internal/amqp/RoundTripTests$I2;", "t", "(Ljava/lang/Object;)V", "getT", "()Ljava/lang/Object;", "Ljava/lang/Object;", "component1", "copy", "(Ljava/lang/Object;)Lnet/corda/serialization/internal/amqp/RoundTripTests$C;", "equals", "", "other", "", "hashCode", "", "toString", "", "serialization"})
    public static final class C<A, B extends A>
    implements I2<B> {
        private final B t;

        @Override
        public B getT() {
            return this.t;
        }

        public C(B t) {
            this.t = t;
        }

        public final B component1() {
            return this.getT();
        }

        @NotNull
        public final C<A, B> copy(B t) {
            return new C<A, B>(t);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ C copy$default(C c, Object object, int n, Object object2) {
            if ((n & 1) != 0) {
                object = c.getT();
            }
            return c.copy(object);
        }

        @NotNull
        public String toString() {
            return "C(t=" + this.getT() + ")";
        }

        public int hashCode() {
            B b = this.getT();
            return b != null ? b.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof C)) break block3;
                    C c = (C)object;
                    if (!Intrinsics.areEqual(this.getT(), c.getT())) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

