/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp;

import java.io.NotSerializableException;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;
import junit.framework.TestCase;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.serialization.ConstructorForDeserialization;
import net.corda.core.serialization.SerializationContext;
import net.corda.core.serialization.SerializedBytes;
import net.corda.core.utilities.ByteSequence;
import net.corda.serialization.internal.amqp.AMQPSerializer;
import net.corda.serialization.internal.amqp.BytesAndSchemas;
import net.corda.serialization.internal.amqp.CustomSerializerRegistry;
import net.corda.serialization.internal.amqp.DeserializationInput;
import net.corda.serialization.internal.amqp.LocalSerializerFactory;
import net.corda.serialization.internal.amqp.PrivatePropertyTests;
import net.corda.serialization.internal.amqp.SerializationOutput;
import net.corda.serialization.internal.amqp.SerializerFactory;
import net.corda.serialization.internal.amqp.WhitelistBasedTypeModelConfiguration;
import net.corda.serialization.internal.amqp.testutils.AMQPTestUtilsKt;
import net.corda.serialization.internal.amqp.testutils.TestDescriptorBasedSerializerRegistry;
import net.corda.serialization.internal.amqp.testutils.TestSerializationContextKt;
import net.corda.serialization.internal.model.ConfigurableLocalTypeModel;
import net.corda.serialization.internal.model.LocalPropertyInformation;
import net.corda.serialization.internal.model.LocalTypeInformation;
import net.corda.serialization.internal.model.LocalTypeModelConfiguration;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableAssert;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0007J\b\u0010\r\u001a\u00020\fH\u0007J\b\u0010\u000e\u001a\u00020\fH\u0007J\b\u0010\u000f\u001a\u00020\fH\u0007J\b\u0010\u0010\u001a\u00020\fH\u0007J\b\u0010\u0011\u001a\u00020\fH\u0007J\b\u0010\u0012\u001a\u00020\fH\u0007J\b\u0010\u0013\u001a\u00020\fH\u0007J\b\u0010\u0014\u001a\u00020\fH\u0007J\b\u0010\u0015\u001a\u00020\fH\u0007J\b\u0010\u0016\u001a\u00020\fH\u0007J\b\u0010\u0017\u001a\u00020\fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Lnet/corda/serialization/internal/amqp/PrivatePropertyTests;", "", "()V", "factory", "Lnet/corda/serialization/internal/amqp/SerializerFactory;", "registry", "Lnet/corda/serialization/internal/amqp/testutils/TestDescriptorBasedSerializerRegistry;", "typeModel", "Lnet/corda/serialization/internal/model/ConfigurableLocalTypeModel;", "getTypeModel", "()Lnet/corda/serialization/internal/model/ConfigurableLocalTypeModel;", "allCapsProprtyNotPrivate", "", "testBadTypeArgSetter", "testGetterMakesAPublicReader", "testMultiArgSetter", "testNested", "testWithInheritance", "testWithOnePrivateProperty", "testWithOnePrivatePropertyBoolean", "testWithOnePrivatePropertyNullableNotNull", "testWithOnePrivatePropertyNullableNull", "testWithOnePublicOnePrivateProperty", "testWithOnePublicOnePrivateProperty2", "serialization"})
public final class PrivatePropertyTests {
    private final TestDescriptorBasedSerializerRegistry registry = new TestDescriptorBasedSerializerRegistry();
    private final SerializerFactory factory = AMQPTestUtilsKt.testDefaultFactoryNoEvolution(this.registry);
    @NotNull
    private final ConfigurableLocalTypeModel typeModel = new ConfigurableLocalTypeModel((LocalTypeModelConfiguration)new WhitelistBasedTypeModelConfiguration(this.factory.getWhitelist(), (CustomSerializerRegistry)this.factory));

    @NotNull
    public final ConfigurableLocalTypeModel getTypeModel() {
        return this.typeModel;
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void testWithOnePrivateProperty() {
        void $receiver$iv;
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000#\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0005\u001a\u00020\u0003H\u00c2\u0003J\u0018\u0010\u0006\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000b\u001a\u00020\fH\u00d6\u0001J\t\u0010\r\u001a\u00020\u0003H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"net/corda/serialization/internal/amqp/PrivatePropertyTests$testWithOnePrivateProperty$C", "", "b", "", "(Ljava/lang/String;)V", "component1", "copy", "(Ljava/lang/String;)Lnet/corda/serialization/internal/amqp/PrivatePropertyTests$testWithOnePrivateProperty$C;", "equals", "", "other", "hashCode", "", "toString", "serialization"})
        public final class C {
            private final String b;

            public C(@NotNull String b) {
                Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
                this.b = b;
            }

            private final String component1() {
                return this.b;
            }

            @NotNull
            public final C copy(@NotNull String b) {
                Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
                return new C(b);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ C copy$default(C c, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = c.b;
                }
                return c.copy(string);
            }

            @NotNull
            public String toString() {
                return "C(b=" + this.b + ")";
            }

            public int hashCode() {
                String string = this.b;
                return string != null ? string.hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof C)) break block3;
                        C c = (C)object;
                        if (!Intrinsics.areEqual((Object)this.b, (Object)c.b)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        C c1 = new C("Pants are comfortable sometimes");
        DeserializationInput deserializationInput = new DeserializationInput(this.factory);
        SerializedBytes bytes$iv = AMQPTestUtilsKt.serialize$default(new SerializationOutput((LocalSerializerFactory)this.factory), c1, null, 2, null);
        SerializationContext context$iv = null;
        C c2 = (C)$receiver$iv.deserialize((ByteSequence)bytes$iv, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        TestCase.assertEquals((Object)c1, (Object)c2);
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void testWithOnePrivatePropertyBoolean() {
        void bytes$iv;
        void $receiver$iv;
        C c;
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001f\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0005\u001a\u00020\u0003H\u00c2\u0003J\u0018\u0010\u0006\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\b\u001a\u00020\u00032\b\u0010\t\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001J\t\u0010\f\u001a\u00020\rH\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"net/corda/serialization/internal/amqp/PrivatePropertyTests$testWithOnePrivatePropertyBoolean$C", "", "b", "", "(Z)V", "component1", "copy", "(Z)Lnet/corda/serialization/internal/amqp/PrivatePropertyTests$testWithOnePrivatePropertyBoolean$C;", "equals", "other", "hashCode", "", "toString", "", "serialization"})
        public final class C {
            private final boolean b;

            public C(boolean b) {
                this.b = b;
            }

            private final boolean component1() {
                return this.b;
            }

            @NotNull
            public final C copy(boolean b) {
                return new C(b);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ C copy$default(C c, boolean bl, int n, Object object) {
                if ((n & 1) != 0) {
                    bl = c.b;
                }
                return c.copy(bl);
            }

            @NotNull
            public String toString() {
                return "C(b=" + this.b + ")";
            }

            public int hashCode() {
                int n = (int)(this.b ? 1 : 0);
                if (n != 0) {
                    n = 1;
                }
                return n;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof C)) break block3;
                        C c = (C)object;
                        if (!(this.b == c.b)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        C $receiver = c = new C(false);
        DeserializationInput deserializationInput = new DeserializationInput(this.factory);
        SerializedBytes serializedBytes = AMQPTestUtilsKt.serialize$default(new SerializationOutput((LocalSerializerFactory)this.factory), $receiver, null, 2, null);
        C c2 = $receiver;
        SerializationContext context$iv = null;
        Object object = $receiver$iv.deserialize((ByteSequence)bytes$iv, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        TestCase.assertEquals((Object)c2, (Object)object);
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void testWithOnePrivatePropertyNullableNotNull() {
        void $receiver$iv;
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000#\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u000b\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u00c2\u0003J\u001a\u0010\u0006\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000b\u001a\u00020\fH\u00d6\u0001J\t\u0010\r\u001a\u00020\u0003H\u00d6\u0001R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"net/corda/serialization/internal/amqp/PrivatePropertyTests$testWithOnePrivatePropertyNullableNotNull$C", "", "b", "", "(Ljava/lang/String;)V", "component1", "copy", "(Ljava/lang/String;)Lnet/corda/serialization/internal/amqp/PrivatePropertyTests$testWithOnePrivatePropertyNullableNotNull$C;", "equals", "", "other", "hashCode", "", "toString", "serialization"})
        public final class C {
            private final String b;

            public C(@Nullable String b) {
                this.b = b;
            }

            private final String component1() {
                return this.b;
            }

            @NotNull
            public final C copy(@Nullable String b) {
                return new C(b);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ C copy$default(C c, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = c.b;
                }
                return c.copy(string);
            }

            @NotNull
            public String toString() {
                return "C(b=" + this.b + ")";
            }

            public int hashCode() {
                String string = this.b;
                return string != null ? string.hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof C)) break block3;
                        C c = (C)object;
                        if (!Intrinsics.areEqual((Object)this.b, (Object)c.b)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        C c1 = new C("Pants are comfortable sometimes");
        DeserializationInput deserializationInput = new DeserializationInput(this.factory);
        SerializedBytes bytes$iv = AMQPTestUtilsKt.serialize$default(new SerializationOutput((LocalSerializerFactory)this.factory), c1, null, 2, null);
        SerializationContext context$iv = null;
        C c2 = (C)$receiver$iv.deserialize((ByteSequence)bytes$iv, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        TestCase.assertEquals((Object)c1, (Object)c2);
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void testWithOnePrivatePropertyNullableNull() {
        void $receiver$iv;
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000#\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u000b\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u00c2\u0003J\u001a\u0010\u0006\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000b\u001a\u00020\fH\u00d6\u0001J\t\u0010\r\u001a\u00020\u0003H\u00d6\u0001R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"net/corda/serialization/internal/amqp/PrivatePropertyTests$testWithOnePrivatePropertyNullableNull$C", "", "b", "", "(Ljava/lang/String;)V", "component1", "copy", "(Ljava/lang/String;)Lnet/corda/serialization/internal/amqp/PrivatePropertyTests$testWithOnePrivatePropertyNullableNull$C;", "equals", "", "other", "hashCode", "", "toString", "serialization"})
        public final class C {
            private final String b;

            public C(@Nullable String b) {
                this.b = b;
            }

            private final String component1() {
                return this.b;
            }

            @NotNull
            public final C copy(@Nullable String b) {
                return new C(b);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ C copy$default(C c, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = c.b;
                }
                return c.copy(string);
            }

            @NotNull
            public String toString() {
                return "C(b=" + this.b + ")";
            }

            public int hashCode() {
                String string = this.b;
                return string != null ? string.hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof C)) break block3;
                        C c = (C)object;
                        if (!Intrinsics.areEqual((Object)this.b, (Object)c.b)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        C c1 = new C(null);
        DeserializationInput deserializationInput = new DeserializationInput(this.factory);
        SerializedBytes bytes$iv = AMQPTestUtilsKt.serialize$default(new SerializationOutput((LocalSerializerFactory)this.factory), c1, null, 2, null);
        SerializationContext context$iv = null;
        C c2 = (C)$receiver$iv.deserialize((ByteSequence)bytes$iv, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        TestCase.assertEquals((Object)c1, (Object)c2);
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void testWithOnePublicOnePrivateProperty() {
        void $receiver$iv;
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000!\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\t\u001a\u00020\u0003H\u00c2\u0003J\"\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"net/corda/serialization/internal/amqp/PrivatePropertyTests$testWithOnePublicOnePrivateProperty$C", "", "a", "", "b", "(II)V", "getA", "()I", "component1", "component2", "copy", "(II)Lnet/corda/serialization/internal/amqp/PrivatePropertyTests$testWithOnePublicOnePrivateProperty$C;", "equals", "", "other", "hashCode", "toString", "", "serialization"})
        public final class C {
            private final int a;
            private final int b;

            public final int getA() {
                return this.a;
            }

            public C(int a, int b) {
                this.a = a;
                this.b = b;
            }

            public final int component1() {
                return this.a;
            }

            private final int component2() {
                return this.b;
            }

            @NotNull
            public final C copy(int a, int b) {
                return new C(a, b);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ C copy$default(C c, int n, int n2, int n3, Object object) {
                if ((n3 & 1) != 0) {
                    n = c.a;
                }
                if ((n3 & 2) != 0) {
                    n2 = c.b;
                }
                return c.copy(n, n2);
            }

            @NotNull
            public String toString() {
                return "C(a=" + this.a + ", b=" + this.b + ")";
            }

            public int hashCode() {
                return Integer.hashCode(this.a) * 31 + Integer.hashCode(this.b);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof C)) break block3;
                        C c = (C)object;
                        if (!(this.a == c.a) || !(this.b == c.b)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        C c1 = new C(1, 2);
        DeserializationInput deserializationInput = new DeserializationInput(this.factory);
        SerializedBytes bytes$iv = AMQPTestUtilsKt.serialize$default(new SerializationOutput((LocalSerializerFactory)this.factory), c1, null, 2, null);
        SerializationContext context$iv = null;
        C c2 = (C)$receiver$iv.deserialize((ByteSequence)bytes$iv, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        TestCase.assertEquals((Object)c1, (Object)c2);
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void testWithInheritance() {
        void $receiver$iv;
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000*\u0002\u0000\u0001\b\n\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0096\u0002J\b\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"net/corda/serialization/internal/amqp/PrivatePropertyTests$testWithInheritance$D", "net/corda/serialization/internal/amqp/PrivatePropertyTests$testWithInheritance$B", "a", "", "b", "(Ljava/lang/String;Ljava/lang/String;)V", "equals", "", "other", "", "hashCode", "", "serialization"})
        public final class D
        extends testWithInheritance.B {
            public boolean equals(@Nullable Object other) {
                Object object = other;
                return object instanceof D ? Intrinsics.areEqual((Object)((D)other).getA(), (Object)this.getA()) && Intrinsics.areEqual((Object)((D)other).getB(), (Object)this.getB()) : false;
            }

            public int hashCode() {
                return Objects.hash(this.getA(), this.getB());
            }

            public D(@NotNull String a, @NotNull String b) {
                Intrinsics.checkParameterIsNotNull((Object)a, (String)"a");
                Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
                @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0013\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006*\u0001\u0000\b\u001a\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0004\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\t"}, d2={"net/corda/serialization/internal/amqp/PrivatePropertyTests$testWithInheritance$B", "", "a", "", "b", "(Ljava/lang/String;Ljava/lang/String;)V", "getA", "()Ljava/lang/String;", "getB", "serialization"})
                public class B {
                    @NotNull
                    private final String a;
                    @NotNull
                    private final String b;

                    @NotNull
                    public final String getA() {
                        return this.a;
                    }

                    @NotNull
                    protected final String getB() {
                        return this.b;
                    }

                    public B(@NotNull String a, @NotNull String b) {
                        Intrinsics.checkParameterIsNotNull((Object)a, (String)"a");
                        Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
                        this.a = a;
                        this.b = b;
                    }
                }
                super(a, b);
            }
        }
        D d1 = new D("clump", "lump");
        DeserializationInput deserializationInput = new DeserializationInput(this.factory);
        SerializedBytes bytes$iv = AMQPTestUtilsKt.serialize$default(new SerializationOutput((LocalSerializerFactory)this.factory), d1, null, 2, null);
        SerializationContext context$iv = null;
        D d2 = (D)$receiver$iv.deserialize((ByteSequence)bytes$iv, D.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        TestCase.assertEquals((Object)d1, (Object)d2);
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void testMultiArgSetter() {
        void $receiver$iv;
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000)\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0007\b\u0017\u00a2\u0006\u0002\u0010\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0004H\u00c2\u0003J\t\u0010\f\u001a\u00020\u0004H\u00c6\u0003J\"\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000eJ\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0006\u0010\u0012\u001a\u00020\u0004J\t\u0010\u0013\u001a\u00020\u0004H\u00d6\u0001J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"net/corda/serialization/internal/amqp/PrivatePropertyTests$testMultiArgSetter$C", "", "()V", "a", "", "b", "(II)V", "getB", "()I", "setB", "(I)V", "component1", "component2", "copy", "(II)Lnet/corda/serialization/internal/amqp/PrivatePropertyTests$testMultiArgSetter$C;", "equals", "", "other", "getA", "hashCode", "setA", "", "toString", "", "serialization"})
        public final class C {
            private int a;
            private int b;

            public final void setA(int a, int b) {
                this.a = a;
            }

            public final int getA() {
                return this.a;
            }

            public final int getB() {
                return this.b;
            }

            public final void setB(int n) {
                this.b = n;
            }

            public C(int a, int b) {
                this.a = a;
                this.b = b;
            }

            @ConstructorForDeserialization
            public C() {
                this(0, 0);
            }

            private final int component1() {
                return this.a;
            }

            public final int component2() {
                return this.b;
            }

            @NotNull
            public final C copy(int a, int b) {
                return new C(a, b);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ C copy$default(C c, int n, int n2, int n3, Object object) {
                if ((n3 & 1) != 0) {
                    n = c.a;
                }
                if ((n3 & 2) != 0) {
                    n2 = c.b;
                }
                return c.copy(n, n2);
            }

            @NotNull
            public String toString() {
                return "C(a=" + this.a + ", b=" + this.b + ")";
            }

            public int hashCode() {
                return Integer.hashCode(this.a) * 31 + Integer.hashCode(this.b);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof C)) break block3;
                        C c = (C)object;
                        if (!(this.a == c.a) || !(this.b == c.b)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        C c1 = new C(33, 44);
        DeserializationInput deserializationInput = new DeserializationInput(this.factory);
        SerializedBytes bytes$iv = AMQPTestUtilsKt.serialize$default(new SerializationOutput((LocalSerializerFactory)this.factory), c1, null, 2, null);
        SerializationContext context$iv = null;
        C c2 = (C)$receiver$iv.deserialize((ByteSequence)bytes$iv, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        TestCase.assertEquals((int)0, (int)c2.getA());
        TestCase.assertEquals((int)44, (int)c2.getB());
    }

    @Test(timeout=300000L)
    public final void testBadTypeArgSetter() {
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000)\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0007\b\u0017\u00a2\u0006\u0002\u0010\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\t\u0010\t\u001a\u00020\u0004H\u00c2\u0003J\t\u0010\n\u001a\u00020\u0004H\u00c6\u0003J\"\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u00c6\u0001\u00a2\u0006\u0002\u0010\fJ\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0006\u0010\u0010\u001a\u00020\u0004J\t\u0010\u0011\u001a\u00020\u0004H\u00d6\u0001J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0003\u001a\u00020\u0014J\t\u0010\u0015\u001a\u00020\u0014H\u00d6\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"net/corda/serialization/internal/amqp/PrivatePropertyTests$testBadTypeArgSetter$C", "", "()V", "a", "", "b", "(II)V", "getB", "()I", "component1", "component2", "copy", "(II)Lnet/corda/serialization/internal/amqp/PrivatePropertyTests$testBadTypeArgSetter$C;", "equals", "", "other", "getA", "hashCode", "setA", "", "", "toString", "serialization"})
        public final class C {
            private int a;
            private final int b;

            public final void setA(@NotNull String a) {
                int n;
                Intrinsics.checkParameterIsNotNull((Object)a, (String)"a");
                String string = a;
                C c = this;
                c.a = n = Integer.parseInt(string);
            }

            public final int getA() {
                return this.a;
            }

            public final int getB() {
                return this.b;
            }

            public C(int a, int b) {
                this.a = a;
                this.b = b;
            }

            @ConstructorForDeserialization
            public C() {
                this(0, 0);
            }

            private final int component1() {
                return this.a;
            }

            public final int component2() {
                return this.b;
            }

            @NotNull
            public final C copy(int a, int b) {
                return new C(a, b);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ C copy$default(C c, int n, int n2, int n3, Object object) {
                if ((n3 & 1) != 0) {
                    n = c.a;
                }
                if ((n3 & 2) != 0) {
                    n2 = c.b;
                }
                return c.copy(n, n2);
            }

            @NotNull
            public String toString() {
                return "C(a=" + this.a + ", b=" + this.b + ")";
            }

            public int hashCode() {
                return Integer.hashCode(this.a) * 31 + Integer.hashCode(this.b);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof C)) break block3;
                        C c = (C)object;
                        if (!(this.a == c.a) || !(this.b == c.b)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        C c1 = new C(33, 44);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)new ThrowableAssert.ThrowingCallable(this, c1){
            final /* synthetic */ PrivatePropertyTests this$0;
            final /* synthetic */ C $c1;

            public final void call() {
                AMQPTestUtilsKt.serialize$default(new SerializationOutput((LocalSerializerFactory)PrivatePropertyTests.access$getFactory$p(this.this$0)), this.$c1, null, 2, null);
            }
            {
                this.this$0 = privatePropertyTests;
                this.$c1 = c;
            }
        }).isInstanceOf(NotSerializableException.class)).hasMessageContaining("Defined setter for parameter a takes parameter of type class java.lang.String yet underlying type is int");
    }

    @Test(timeout=300000L)
    public final void testWithOnePublicOnePrivateProperty2() {
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000!\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\t\u001a\u00020\u0003H\u00c2\u0003J\"\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"net/corda/serialization/internal/amqp/PrivatePropertyTests$testWithOnePublicOnePrivateProperty2$C", "", "a", "", "b", "(II)V", "getA", "()I", "component1", "component2", "copy", "(II)Lnet/corda/serialization/internal/amqp/PrivatePropertyTests$testWithOnePublicOnePrivateProperty2$C;", "equals", "", "other", "hashCode", "toString", "", "serialization"})
        public final class C {
            private final int a;
            private final int b;

            public final int getA() {
                return this.a;
            }

            public C(int a, int b) {
                this.a = a;
                this.b = b;
            }

            public final int component1() {
                return this.a;
            }

            private final int component2() {
                return this.b;
            }

            @NotNull
            public final C copy(int a, int b) {
                return new C(a, b);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ C copy$default(C c, int n, int n2, int n3, Object object) {
                if ((n3 & 1) != 0) {
                    n = c.a;
                }
                if ((n3 & 2) != 0) {
                    n2 = c.b;
                }
                return c.copy(n, n2);
            }

            @NotNull
            public String toString() {
                return "C(a=" + this.a + ", b=" + this.b + ")";
            }

            public int hashCode() {
                return Integer.hashCode(this.a) * 31 + Integer.hashCode(this.b);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof C)) break block3;
                        C c = (C)object;
                        if (!(this.a == c.a) || !(this.b == c.b)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        C c1 = new C(1, 2);
        BytesAndSchemas schemaAndBlob = AMQPTestUtilsKt.serializeAndReturnSchema$default(new SerializationOutput((LocalSerializerFactory)this.factory), c1, null, 2, null);
        TestCase.assertEquals((int)1, (int)schemaAndBlob.getSchema().getTypes().size());
        LocalTypeInformation typeInformation = this.typeModel.inspect((Type)((Object)C.class));
        TestCase.assertTrue((boolean)(typeInformation instanceof LocalTypeInformation.Composable));
        LocalTypeInformation localTypeInformation = typeInformation;
        if (localTypeInformation == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.corda.serialization.internal.model.LocalTypeInformation.Composable");
        }
        LocalTypeInformation.Composable cfr_ignored_0 = (LocalTypeInformation.Composable)localTypeInformation;
        TestCase.assertEquals((int)2, (int)((LocalTypeInformation.Composable)typeInformation).getProperties().size());
        TestCase.assertTrue((boolean)(((LocalTypeInformation.Composable)typeInformation).getProperties().get("a") instanceof LocalPropertyInformation.ConstructorPairedProperty));
        TestCase.assertTrue((boolean)(((LocalTypeInformation.Composable)typeInformation).getProperties().get("b") instanceof LocalPropertyInformation.PrivateConstructorPairedProperty));
    }

    @Test(timeout=300000L)
    public final void testGetterMakesAPublicReader() {
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000!\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\t\u001a\u00020\u0003H\u00c2\u0003J\"\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0006\u0010\u000f\u001a\u00020\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"net/corda/serialization/internal/amqp/PrivatePropertyTests$testGetterMakesAPublicReader$C", "", "a", "", "b", "(II)V", "getA", "()I", "component1", "component2", "copy", "(II)Lnet/corda/serialization/internal/amqp/PrivatePropertyTests$testGetterMakesAPublicReader$C;", "equals", "", "other", "getB", "hashCode", "toString", "", "serialization"})
        public final class C {
            private final int a;
            private final int b;

            public final int getB() {
                return this.b;
            }

            public final int getA() {
                return this.a;
            }

            public C(int a, int b) {
                this.a = a;
                this.b = b;
            }

            public final int component1() {
                return this.a;
            }

            private final int component2() {
                return this.b;
            }

            @NotNull
            public final C copy(int a, int b) {
                return new C(a, b);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ C copy$default(C c, int n, int n2, int n3, Object object) {
                if ((n3 & 1) != 0) {
                    n = c.a;
                }
                if ((n3 & 2) != 0) {
                    n2 = c.b;
                }
                return c.copy(n, n2);
            }

            @NotNull
            public String toString() {
                return "C(a=" + this.a + ", b=" + this.b + ")";
            }

            public int hashCode() {
                return Integer.hashCode(this.a) * 31 + Integer.hashCode(this.b);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof C)) break block3;
                        C c = (C)object;
                        if (!(this.a == c.a) || !(this.b == c.b)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        C c1 = new C(1, 2);
        BytesAndSchemas schemaAndBlob = AMQPTestUtilsKt.serializeAndReturnSchema$default(new SerializationOutput((LocalSerializerFactory)this.factory), c1, null, 2, null);
        TestCase.assertEquals((int)1, (int)schemaAndBlob.getSchema().getTypes().size());
        LocalTypeInformation typeInformation = this.typeModel.inspect((Type)((Object)C.class));
        TestCase.assertTrue((boolean)(typeInformation instanceof LocalTypeInformation.Composable));
        LocalTypeInformation localTypeInformation = typeInformation;
        if (localTypeInformation == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.corda.serialization.internal.model.LocalTypeInformation.Composable");
        }
        LocalTypeInformation.Composable cfr_ignored_0 = (LocalTypeInformation.Composable)localTypeInformation;
        TestCase.assertEquals((int)2, (int)((LocalTypeInformation.Composable)typeInformation).getProperties().size());
        TestCase.assertTrue((boolean)(((LocalTypeInformation.Composable)typeInformation).getProperties().get("a") instanceof LocalPropertyInformation.ConstructorPairedProperty));
        TestCase.assertTrue((boolean)(((LocalTypeInformation.Composable)typeInformation).getProperties().get("b") instanceof LocalPropertyInformation.ConstructorPairedProperty));
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void testNested() {
        void $receiver$iv;
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0002\u0000\u0003\b\u008a\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0006\u001a\u00020\u0003H\u00c2\u0003\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0010\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0005\u00a8\u0006\u0011"}, d2={"net/corda/serialization/internal/amqp/PrivatePropertyTests$testNested$Outer", "", "i", "net/corda/serialization/internal/amqp/PrivatePropertyTests$testNested$Inner", "(Lnet/corda/serialization/internal/amqp/PrivatePropertyTests$testNested$Inner;)V", "Lnet/corda/serialization/internal/amqp/PrivatePropertyTests$testNested$Inner;", "component1", "()Lnet/corda/serialization/internal/amqp/PrivatePropertyTests$testNested$Inner;", "copy", "(Lnet/corda/serialization/internal/amqp/PrivatePropertyTests$testNested$Inner;)Lnet/corda/serialization/internal/amqp/PrivatePropertyTests$testNested$Outer;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
        public final class Outer {
            private final Inner i;

            public Outer(@NotNull Inner i2) {
                @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000!\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0005\u001a\u00020\u0003H\u00c2\u0003J\u0018\u0010\u0006\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\f\u001a\u00020\rH\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"net/corda/serialization/internal/amqp/PrivatePropertyTests$testNested$Inner", "", "a", "", "(I)V", "component1", "copy", "(I)Lnet/corda/serialization/internal/amqp/PrivatePropertyTests$testNested$Inner;", "equals", "", "other", "hashCode", "toString", "", "serialization"})
                public final class Inner {
                    private final int a;

                    public Inner(int a) {
                        this.a = a;
                    }

                    private final int component1() {
                        return this.a;
                    }

                    @NotNull
                    public final Inner copy(int a) {
                        return new Inner(a);
                    }

                    @NotNull
                    public static /* bridge */ /* synthetic */ Inner copy$default(Inner inner, int n, int n2, Object object) {
                        if ((n2 & 1) != 0) {
                            n = inner.a;
                        }
                        return inner.copy(n);
                    }

                    @NotNull
                    public String toString() {
                        return "Inner(a=" + this.a + ")";
                    }

                    public int hashCode() {
                        return Integer.hashCode(this.a);
                    }

                    public boolean equals(@Nullable Object object) {
                        block3: {
                            block2: {
                                if (this == object) break block2;
                                if (!(object instanceof Inner)) break block3;
                                Inner inner = (Inner)object;
                                if (!(this.a == inner.a)) break block3;
                            }
                            return true;
                        }
                        return false;
                    }
                }
                Intrinsics.checkParameterIsNotNull((Object)i2, (String)"i");
                this.i = i2;
            }

            private final Inner component1() {
                return this.i;
            }

            @NotNull
            public final Outer copy(@NotNull Inner i2) {
                Intrinsics.checkParameterIsNotNull((Object)i2, (String)"i");
                return new Outer(i2);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ Outer copy$default(Outer outer2, Inner inner, int n, Object object) {
                if ((n & 1) != 0) {
                    inner = outer2.i;
                }
                return outer2.copy(inner);
            }

            @NotNull
            public String toString() {
                return "Outer(i=" + this.i + ")";
            }

            public int hashCode() {
                Inner inner = this.i;
                return inner != null ? ((Object)inner).hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Outer)) break block3;
                        Outer outer2 = (Outer)object;
                        if (!Intrinsics.areEqual((Object)this.i, (Object)outer2.i)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        Outer c1 = new Outer(new Inner(1010101));
        BytesAndSchemas output = AMQPTestUtilsKt.serializeAndReturnSchema$default(new SerializationOutput((LocalSerializerFactory)this.factory), c1, null, 2, null);
        Map<String, AMQPSerializer<Object>> serializersByDescriptor = this.registry.getContents();
        TestCase.assertEquals((int)2, (int)serializersByDescriptor.size());
        DeserializationInput deserializationInput = new DeserializationInput(this.factory);
        SerializedBytes bytes$iv = output.getObj();
        SerializationContext context$iv = null;
        Outer c2 = (Outer)$receiver$iv.deserialize((ByteSequence)bytes$iv, Outer.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        TestCase.assertEquals((Object)c1, (Object)c2);
    }

    @Test(timeout=300000L)
    public final void allCapsProprtyNotPrivate() {
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000#\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0018\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"net/corda/serialization/internal/amqp/PrivatePropertyTests$allCapsProprtyNotPrivate$C", "", "CCC", "", "(Ljava/lang/String;)V", "getCCC", "()Ljava/lang/String;", "component1", "copy", "(Ljava/lang/String;)Lnet/corda/serialization/internal/amqp/PrivatePropertyTests$allCapsProprtyNotPrivate$C;", "equals", "", "other", "hashCode", "", "toString", "serialization"})
        public final class C {
            @NotNull
            private final String CCC;

            @NotNull
            public final String getCCC() {
                return this.CCC;
            }

            public C(@NotNull String CCC) {
                Intrinsics.checkParameterIsNotNull((Object)CCC, (String)"CCC");
                this.CCC = CCC;
            }

            @NotNull
            public final String component1() {
                return this.CCC;
            }

            @NotNull
            public final C copy(@NotNull String CCC) {
                Intrinsics.checkParameterIsNotNull((Object)CCC, (String)"CCC");
                return new C(CCC);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ C copy$default(C c, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = c.CCC;
                }
                return c.copy(string);
            }

            @NotNull
            public String toString() {
                return "C(CCC=" + this.CCC + ")";
            }

            public int hashCode() {
                String string = this.CCC;
                return string != null ? string.hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof C)) break block3;
                        C c = (C)object;
                        if (!Intrinsics.areEqual((Object)this.CCC, (Object)c.CCC)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        LocalTypeInformation typeInformation = this.typeModel.inspect((Type)((Object)C.class));
        TestCase.assertTrue((boolean)(typeInformation instanceof LocalTypeInformation.Composable));
        LocalTypeInformation localTypeInformation = typeInformation;
        if (localTypeInformation == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.corda.serialization.internal.model.LocalTypeInformation.Composable");
        }
        LocalTypeInformation.Composable cfr_ignored_0 = (LocalTypeInformation.Composable)localTypeInformation;
        TestCase.assertEquals((int)1, (int)((LocalTypeInformation.Composable)typeInformation).getProperties().size());
        TestCase.assertTrue((boolean)(((LocalTypeInformation.Composable)typeInformation).getProperties().get("CCC") instanceof LocalPropertyInformation.ConstructorPairedProperty));
    }

    @NotNull
    public static final /* synthetic */ SerializerFactory access$getFactory$p(PrivatePropertyTests $this) {
        return $this.factory;
    }
}

