/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp;

import java.util.ArrayList;
import java.util.List;
import net.corda.core.serialization.CordaSerializable;
import net.corda.core.serialization.SerializedBytes;
import net.corda.core.utilities.ByteSequence;
import net.corda.serialization.internal.amqp.DeserializationInput;
import net.corda.serialization.internal.amqp.LocalSerializerFactory;
import net.corda.serialization.internal.amqp.SerializationOutput;
import net.corda.serialization.internal.amqp.SerializerFactory;
import net.corda.serialization.internal.amqp.testutils.AMQPTestUtilsKt;
import net.corda.serialization.internal.amqp.testutils.TestSerializationContext;
import org.junit.Assert;
import org.junit.Test;

public class ListsSerializationJavaTest {
    @Test
    public void checkCovariance() throws Exception {
        ArrayList<Child> payload = new ArrayList<Child>();
        payload.add(new Child(1));
        payload.add(new Child(2));
        CovariantContainer container = new CovariantContainer(payload);
        ListsSerializationJavaTest.assertEqualAfterRoundTripSerialization(container, CovariantContainer.class);
    }

    @Test
    public void checkCovariance2() throws Exception {
        ArrayList<Child> payload = new ArrayList<Child>();
        payload.add(new Child(1));
        payload.add(new Child(2));
        CovariantContainer2 container = new CovariantContainer2(payload);
        ListsSerializationJavaTest.assertEqualAfterRoundTripSerialization(container, CovariantContainer2.class);
    }

    private static <T> void assertEqualAfterRoundTripSerialization(T container, Class<T> clazz) throws Exception {
        SerializerFactory factory1 = AMQPTestUtilsKt.testDefaultFactory();
        SerializationOutput ser = new SerializationOutput((LocalSerializerFactory)factory1);
        SerializedBytes bytes = ser.serialize(container, TestSerializationContext.testSerializationContext);
        DeserializationInput des = new DeserializationInput(factory1);
        Object deserialized = des.deserialize((ByteSequence)bytes, clazz, TestSerializationContext.testSerializationContext);
        Assert.assertEquals(container, (Object)deserialized);
    }

    @CordaSerializable
    public static class CovariantContainer2 {
        private final List<? extends Parent> content;

        CovariantContainer2(List<? extends Parent> content) {
            this.content = content;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CovariantContainer2 that = (CovariantContainer2)o;
            return this.content != null ? this.content.equals(that.content) : that.content == null;
        }

        public int hashCode() {
            return this.content != null ? this.content.hashCode() : 0;
        }

        public List<? extends Parent> getContent() {
            return this.content;
        }
    }

    @CordaSerializable
    public static class CovariantContainer<T extends Parent> {
        private final List<T> content;

        CovariantContainer(List<T> content) {
            this.content = content;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CovariantContainer that = (CovariantContainer)o;
            return this.content != null ? this.content.equals(that.content) : that.content == null;
        }

        public int hashCode() {
            return this.content != null ? this.content.hashCode() : 0;
        }

        public List<T> getContent() {
            return this.content;
        }
    }

    public static class Child
    implements Parent {
        private final int value;

        Child(int value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Child child = (Child)o;
            return this.value == child.value;
        }

        public int hashCode() {
            return this.value;
        }

        public int getValue() {
            return this.value;
        }
    }

    @CordaSerializable
    static interface Parent {
    }
}

