/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp;

import java.io.NotSerializableException;
import java.nio.ByteBuffer;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.corda.core.serialization.ConstructorForDeserialization;
import net.corda.core.serialization.SerializedBytes;
import net.corda.core.utilities.ByteSequence;
import net.corda.serialization.internal.amqp.Choice;
import net.corda.serialization.internal.amqp.CompositeType;
import net.corda.serialization.internal.amqp.Descriptor;
import net.corda.serialization.internal.amqp.DeserializationInput;
import net.corda.serialization.internal.amqp.Envelope;
import net.corda.serialization.internal.amqp.Field;
import net.corda.serialization.internal.amqp.LocalSerializerFactory;
import net.corda.serialization.internal.amqp.RestrictedType;
import net.corda.serialization.internal.amqp.Schema;
import net.corda.serialization.internal.amqp.SerializationOutput;
import net.corda.serialization.internal.amqp.SerializerFactory;
import net.corda.serialization.internal.amqp.Transform;
import net.corda.serialization.internal.amqp.TransformsSchema;
import net.corda.serialization.internal.amqp.testutils.AMQPTestUtilsKt;
import net.corda.serialization.internal.amqp.testutils.TestSerializationContext;
import org.apache.qpid.proton.codec.DecoderImpl;
import org.apache.qpid.proton.codec.DescribedTypeConstructor;
import org.apache.qpid.proton.codec.EncoderImpl;
import org.apache.qpid.proton.codec.FastPathDescribedTypeConstructor;
import org.junit.Assert;
import org.junit.Test;

public class JavaSerializationOutputTests {
    private Object serdes(Object obj) throws NotSerializableException {
        SerializerFactory factory1 = AMQPTestUtilsKt.testDefaultFactory();
        SerializerFactory factory2 = AMQPTestUtilsKt.testDefaultFactory();
        SerializationOutput ser = new SerializationOutput((LocalSerializerFactory)factory1);
        SerializedBytes bytes = ser.serialize(obj, TestSerializationContext.testSerializationContext);
        DecoderImpl decoder = new DecoderImpl();
        decoder.register((Object)Envelope.Companion.getDESCRIPTOR(), (FastPathDescribedTypeConstructor)new Envelope.FastPathConstructor(decoder));
        decoder.register((Object)Schema.Companion.getDESCRIPTOR(), (DescribedTypeConstructor)Schema.Companion);
        decoder.register((Object)Descriptor.Companion.getDESCRIPTOR(), (DescribedTypeConstructor)Descriptor.Companion);
        decoder.register((Object)Field.Companion.getDESCRIPTOR(), (DescribedTypeConstructor)Field.Companion);
        decoder.register((Object)CompositeType.Companion.getDESCRIPTOR(), (DescribedTypeConstructor)CompositeType.Companion);
        decoder.register((Object)Choice.Companion.getDESCRIPTOR(), (DescribedTypeConstructor)Choice.Companion);
        decoder.register((Object)RestrictedType.Companion.getDESCRIPTOR(), (DescribedTypeConstructor)RestrictedType.Companion);
        decoder.register((Object)Transform.Companion.getDESCRIPTOR(), (DescribedTypeConstructor)Transform.Companion);
        decoder.register((Object)TransformsSchema.Companion.getDESCRIPTOR(), (DescribedTypeConstructor)TransformsSchema.Companion);
        new EncoderImpl(decoder);
        decoder.setByteBuffer(ByteBuffer.wrap(bytes.getBytes(), 8, bytes.getSize() - 8));
        Envelope result = (Envelope)decoder.readObject();
        Assert.assertTrue((result != null ? 1 : 0) != 0);
        DeserializationInput des = new DeserializationInput(factory2);
        Object desObj = des.deserialize((ByteSequence)bytes, Object.class, TestSerializationContext.testSerializationContext);
        Assert.assertTrue((boolean)Objects.deepEquals(obj, desObj));
        SerializationOutput ser2 = new SerializationOutput((LocalSerializerFactory)factory1);
        DeserializationInput des2 = new DeserializationInput(factory1);
        Object desObj2 = des2.deserialize((ByteSequence)ser2.serialize(obj, TestSerializationContext.testSerializationContext), Object.class, TestSerializationContext.testSerializationContext);
        Assert.assertTrue((boolean)Objects.deepEquals(obj, desObj2));
        return desObj2;
    }

    @Test
    public void testJavaConstructorAnnotations() throws NotSerializableException {
        Foo obj = new Foo("Hello World!", 123);
        this.serdes(obj);
    }

    @Test
    public void testJavaConstructorWithoutAnnotations() throws NotSerializableException {
        UnAnnotatedFoo obj = new UnAnnotatedFoo("Hello World!", 123);
        this.serdes(obj);
    }

    @Test
    public void testBoxedTypes() throws NotSerializableException {
        BoxedFoo obj = new BoxedFoo("Hello World!", 123);
        this.serdes(obj);
    }

    @Test
    public void testBoxedTypesNotNull() throws NotSerializableException {
        BoxedFooNotNull obj = new BoxedFooNotNull("Hello World!", 123);
        this.serdes(obj);
    }

    static class BoxedFooNotNull {
        private final String fred;
        private final Integer count;

        private BoxedFooNotNull(String fred, Integer count) {
            this.fred = fred;
            this.count = count;
        }

        public String getFred() {
            return this.fred;
        }

        @Nonnull
        public Integer getCount() {
            return this.count;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BoxedFooNotNull boxedFoo = (BoxedFooNotNull)o;
            if (this.fred != null ? !this.fred.equals(boxedFoo.fred) : boxedFoo.fred != null) {
                return false;
            }
            return this.count != null ? this.count.equals(boxedFoo.count) : boxedFoo.count == null;
        }

        public int hashCode() {
            int result = this.fred != null ? this.fred.hashCode() : 0;
            result = 31 * result + (this.count != null ? this.count.hashCode() : 0);
            return result;
        }
    }

    static class BoxedFoo {
        private final String fred;
        private final Integer count;

        private BoxedFoo(String fred, Integer count) {
            this.fred = fred;
            this.count = count;
        }

        public String getFred() {
            return this.fred;
        }

        public Integer getCount() {
            return this.count;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BoxedFoo boxedFoo = (BoxedFoo)o;
            if (this.fred != null ? !this.fred.equals(boxedFoo.fred) : boxedFoo.fred != null) {
                return false;
            }
            return this.count != null ? this.count.equals(boxedFoo.count) : boxedFoo.count == null;
        }

        public int hashCode() {
            int result = this.fred != null ? this.fred.hashCode() : 0;
            result = 31 * result + (this.count != null ? this.count.hashCode() : 0);
            return result;
        }
    }

    static class UnAnnotatedFoo {
        private final String bob;
        private final int count;

        private UnAnnotatedFoo(String fred, int count) {
            this.bob = fred;
            this.count = count;
        }

        public String getFred() {
            return this.bob;
        }

        public int getCount() {
            return this.count;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UnAnnotatedFoo foo = (UnAnnotatedFoo)o;
            if (this.count != foo.count) {
                return false;
            }
            return this.bob != null ? this.bob.equals(foo.bob) : foo.bob == null;
        }

        public int hashCode() {
            int result = this.bob != null ? this.bob.hashCode() : 0;
            result = 31 * result + this.count;
            return result;
        }
    }

    static class Foo {
        private final String bob;
        private final int count;

        public Foo(String msg, long count) {
            this.bob = msg;
            this.count = (int)count;
        }

        @ConstructorForDeserialization
        private Foo(String fred, int count) {
            this.bob = fred;
            this.count = count;
        }

        public String getFred() {
            return this.bob;
        }

        public int getCount() {
            return this.count;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Foo foo = (Foo)o;
            if (this.count != foo.count) {
                return false;
            }
            return this.bob != null ? this.bob.equals(foo.bob) : foo.bob == null;
        }

        public int hashCode() {
            int result = this.bob != null ? this.bob.hashCode() : 0;
            result = 31 * result + this.count;
            return result;
        }
    }
}

