/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp;

import java.io.NotSerializableException;
import net.corda.core.utilities.ByteSequence;
import net.corda.serialization.internal.amqp.DeserializationInput;
import net.corda.serialization.internal.amqp.LocalSerializerFactory;
import net.corda.serialization.internal.amqp.SerializationOutput;
import net.corda.serialization.internal.amqp.SerializerFactory;
import net.corda.serialization.internal.amqp.testutils.AMQPTestUtilsKt;
import net.corda.serialization.internal.amqp.testutils.TestDescriptorBasedSerializerRegistry;
import net.corda.serialization.internal.amqp.testutils.TestSerializationContext;
import org.junit.Assert;
import org.junit.Test;

public class JavaPrivatePropertyTests {
    @Test
    public void singlePrivateBooleanWithConstructor() throws NotSerializableException {
        SerializerFactory factory = AMQPTestUtilsKt.testDefaultFactory();
        SerializationOutput ser = new SerializationOutput((LocalSerializerFactory)factory);
        DeserializationInput des = new DeserializationInput(factory);
        B b = new B(true);
        B b2 = (B)des.deserialize((ByteSequence)ser.serialize((Object)b, TestSerializationContext.testSerializationContext), B.class, TestSerializationContext.testSerializationContext);
        Assert.assertEquals((Object)b.b, (Object)b2.b);
    }

    @Test
    public void singlePrivateBooleanWithNoConstructor() throws NotSerializableException {
        SerializerFactory factory = AMQPTestUtilsKt.testDefaultFactory();
        SerializationOutput ser = new SerializationOutput((LocalSerializerFactory)factory);
        DeserializationInput des = new DeserializationInput(factory);
        B2 b = new B2();
        b.setB(false);
        B2 b2 = (B2)des.deserialize((ByteSequence)ser.serialize((Object)b, TestSerializationContext.testSerializationContext), B2.class, TestSerializationContext.testSerializationContext);
        Assert.assertEquals((Object)b.b, (Object)b2.b);
    }

    @Test
    public void testCapitilsationOfIs() throws NotSerializableException {
        SerializerFactory factory = AMQPTestUtilsKt.testDefaultFactory();
        SerializationOutput ser = new SerializationOutput((LocalSerializerFactory)factory);
        DeserializationInput des = new DeserializationInput(factory);
        B3 b = new B3();
        b.setB(false);
        B3 b2 = (B3)des.deserialize((ByteSequence)ser.serialize((Object)b, TestSerializationContext.testSerializationContext), B3.class, TestSerializationContext.testSerializationContext);
        Assert.assertNull((Object)b2.b);
    }

    @Test
    public void singlePrivateIntWithBoolean() throws NotSerializableException {
        SerializerFactory factory = AMQPTestUtilsKt.testDefaultFactory();
        SerializationOutput ser = new SerializationOutput((LocalSerializerFactory)factory);
        DeserializationInput des = new DeserializationInput(factory);
        C3 c = new C3();
        c.setA(12345);
        C3 c2 = (C3)des.deserialize((ByteSequence)ser.serialize((Object)c, TestSerializationContext.testSerializationContext), C3.class, TestSerializationContext.testSerializationContext);
        Assert.assertEquals((Object)c.a, (Object)c2.a);
    }

    @Test
    public void singlePrivateWithConstructor() throws NotSerializableException {
        TestDescriptorBasedSerializerRegistry registry = new TestDescriptorBasedSerializerRegistry();
        SerializerFactory factory = AMQPTestUtilsKt.testDefaultFactory(registry);
        SerializationOutput ser = new SerializationOutput((LocalSerializerFactory)factory);
        DeserializationInput des = new DeserializationInput(factory);
        C c = new C("dripping taps");
        C c2 = (C)des.deserialize((ByteSequence)ser.serialize((Object)c, TestSerializationContext.testSerializationContext), C.class, TestSerializationContext.testSerializationContext);
        Assert.assertEquals((Object)c.a, (Object)c2.a);
        Assert.assertEquals((long)1L, (long)registry.getContents().size());
    }

    @Test
    public void singlePrivateWithConstructorAndGetter() throws NotSerializableException {
        TestDescriptorBasedSerializerRegistry registry = new TestDescriptorBasedSerializerRegistry();
        SerializerFactory factory = AMQPTestUtilsKt.testDefaultFactory(registry);
        SerializationOutput ser = new SerializationOutput((LocalSerializerFactory)factory);
        DeserializationInput des = new DeserializationInput(factory);
        C2 c = new C2("dripping taps");
        C2 c2 = (C2)des.deserialize((ByteSequence)ser.serialize((Object)c, TestSerializationContext.testSerializationContext), C2.class, TestSerializationContext.testSerializationContext);
        Assert.assertEquals((Object)c.a, (Object)c2.a);
        Assert.assertEquals((long)1L, (long)registry.getContents().size());
    }

    static class C3 {
        private Integer a;

        C3() {
        }

        public Integer getA() {
            return this.a;
        }

        public Boolean isA() {
            return this.a > 0;
        }

        public void setA(Integer a) {
            this.a = a;
        }
    }

    static class B3 {
        private Boolean b;

        B3() {
        }

        public Boolean isb() {
            return this.b;
        }

        public void setB(Boolean b) {
            this.b = b;
        }
    }

    static class B2 {
        private Boolean b;

        B2() {
        }

        public Boolean isB() {
            return this.b;
        }

        public void setB(Boolean b) {
            this.b = b;
        }
    }

    static class B {
        private Boolean b;

        B(Boolean b) {
            this.b = b;
        }

        public Boolean isB() {
            return this.b;
        }
    }

    static class C2 {
        private String a;

        C2(String a) {
            this.a = a;
        }

        public String getA() {
            return this.a;
        }
    }

    static class C {
        private String a;

        C(String a) {
            this.a = a;
        }
    }
}

