/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp;

import java.io.NotSerializableException;
import java.math.BigInteger;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.corda.core.serialization.CordaSerializable;
import net.corda.core.serialization.SerializedBytes;
import net.corda.core.utilities.ByteSequence;
import net.corda.serialization.internal.amqp.CustomSerializer;
import net.corda.serialization.internal.amqp.DeserializationInput;
import net.corda.serialization.internal.amqp.LocalSerializerFactory;
import net.corda.serialization.internal.amqp.SerializationOutput;
import net.corda.serialization.internal.amqp.SerializerFactory;
import net.corda.serialization.internal.amqp.custom.BigIntegerSerializer;
import net.corda.serialization.internal.amqp.testutils.AMQPTestUtilsKt;
import net.corda.serialization.internal.amqp.testutils.TestSerializationContext;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class JavaGenericsTest {
    @Test
    public void shouldSupportNestedGenericsFromJavaWithCollections() throws NotSerializableException {
        ConcreteClass concreteClass = new ConcreteClass("How to make concrete, $99/class");
        HolderOfGeneric genericList = new HolderOfGeneric(new GenericClassWithList(Collections.singletonList(concreteClass)));
        SerializerFactory factory = AMQPTestUtilsKt.testDefaultFactoryWithWhitelist();
        SerializationOutput ser = new SerializationOutput((LocalSerializerFactory)factory);
        SerializedBytes bytes = ser.serialize(genericList, TestSerializationContext.testSerializationContext);
        DeserializationInput des = new DeserializationInput(factory);
        HolderOfGeneric genericList2 = (HolderOfGeneric)des.deserialize((ByteSequence)bytes, HolderOfGeneric.class, TestSerializationContext.testSerializationContext);
        Assert.assertThat(genericList, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)genericList2)));
    }

    @Test
    public void shouldSupportNestedGenericsFromJavaWithMaps() throws NotSerializableException {
        ConcreteClass concreteClass = new ConcreteClass("How to make concrete, $99/class");
        GenericClassWithMap genericMap = new GenericClassWithMap(Collections.singletonMap(concreteClass, BigInteger.ONE));
        SerializerFactory factory = AMQPTestUtilsKt.testDefaultFactoryWithWhitelist();
        factory.register((CustomSerializer)BigIntegerSerializer.INSTANCE);
        SerializationOutput ser = new SerializationOutput((LocalSerializerFactory)factory);
        SerializedBytes bytes = ser.serialize(genericMap, TestSerializationContext.testSerializationContext);
        DeserializationInput des = new DeserializationInput(factory);
        GenericClassWithMap genericMap2 = (GenericClassWithMap)des.deserialize((ByteSequence)bytes, GenericClassWithMap.class, TestSerializationContext.testSerializationContext);
        Assert.assertThat((Object)genericMap2, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)genericMap2)));
    }

    @Test
    public void basicGeneric() throws NotSerializableException {
        A a1 = new A(1);
        SerializerFactory factory = AMQPTestUtilsKt.testDefaultFactory();
        SerializationOutput ser = new SerializationOutput((LocalSerializerFactory)factory);
        SerializedBytes bytes = ser.serialize(a1, TestSerializationContext.testSerializationContext);
        DeserializationInput des = new DeserializationInput(factory);
        A a2 = (A)des.deserialize((ByteSequence)bytes, A.class, TestSerializationContext.testSerializationContext);
        Assertions.assertEquals((Object)1, a2.getT());
    }

    private SerializedBytes<?> forceWildcardSerialize(A<?> a) throws NotSerializableException {
        SerializerFactory factory = AMQPTestUtilsKt.testDefaultFactory();
        return new SerializationOutput((LocalSerializerFactory)factory).serialize(a, TestSerializationContext.testSerializationContext);
    }

    private SerializedBytes<?> forceWildcardSerializeFactory(A<?> a, SerializerFactory factory) throws NotSerializableException {
        return new SerializationOutput((LocalSerializerFactory)factory).serialize(a, TestSerializationContext.testSerializationContext);
    }

    private A<?> forceWildcardDeserialize(SerializedBytes<?> bytes) throws NotSerializableException {
        SerializerFactory factory = AMQPTestUtilsKt.testDefaultFactory();
        DeserializationInput des = new DeserializationInput(factory);
        return (A)des.deserialize(bytes, A.class, TestSerializationContext.testSerializationContext);
    }

    private A<?> forceWildcardDeserializeFactory(SerializedBytes<?> bytes, SerializerFactory factory) throws NotSerializableException {
        return (A)new DeserializationInput(factory).deserialize(bytes, A.class, TestSerializationContext.testSerializationContext);
    }

    @Test
    public void forceWildcard() throws NotSerializableException {
        SerializedBytes<?> bytes = this.forceWildcardSerialize(new A(new Inner(29)));
        Inner i2 = (Inner)this.forceWildcardDeserialize(bytes).getT();
        Assertions.assertEquals((int)29, (Integer)i2.getV());
    }

    @Test
    public void forceWildcardSharedFactory() throws NotSerializableException {
        SerializerFactory factory = AMQPTestUtilsKt.testDefaultFactory();
        SerializedBytes<?> bytes = this.forceWildcardSerializeFactory(new A(new Inner(29)), factory);
        Inner i2 = (Inner)this.forceWildcardDeserializeFactory(bytes, factory).getT();
        Assertions.assertEquals((int)29, (Integer)i2.getV());
    }

    @CordaSerializable
    private static class HolderOfGeneric<G> {
        private final G theGeneric;

        private HolderOfGeneric(G theGeneric) {
            this.theGeneric = theGeneric;
        }

        public G getTheGeneric() {
            return this.theGeneric;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HolderOfGeneric that = (HolderOfGeneric)o;
            return Objects.equals(this.theGeneric, that.theGeneric);
        }

        public int hashCode() {
            return Objects.hash(this.theGeneric);
        }
    }

    @CordaSerializable
    private static class GenericClassWithMap<CC, GG> {
        private final Map<CC, GG> theMap;

        private GenericClassWithMap(Map<CC, GG> theMap) {
            this.theMap = new LinkedHashMap<CC, GG>(theMap);
        }

        public Map<CC, GG> getTheMap() {
            return this.theMap;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GenericClassWithMap that = (GenericClassWithMap)o;
            return Objects.equals(this.theMap, that.theMap);
        }

        public int hashCode() {
            return Objects.hash(this.theMap);
        }
    }

    @CordaSerializable
    private static class GenericClassWithList<CC> {
        private final List<CC> items;

        private GenericClassWithList(List<CC> items) {
            this.items = items;
        }

        public List<CC> getItems() {
            return this.items;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GenericClassWithList that = (GenericClassWithList)o;
            return Objects.equals(this.items, that.items);
        }

        public int hashCode() {
            return Objects.hash(this.items);
        }
    }

    @CordaSerializable
    private static class ConcreteClass {
        private final String theItem;

        private ConcreteClass(String theItem) {
            this.theItem = theItem;
        }

        public String getTheItem() {
            return this.theItem;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConcreteClass that = (ConcreteClass)o;
            return Objects.equals(this.theItem, that.theItem);
        }

        public int hashCode() {
            return Objects.hash(this.theItem);
        }
    }

    private static class A<T> {
        private final T t;

        private A(T t) {
            this.t = t;
        }

        public T getT() {
            return this.t;
        }
    }

    private static class Inner {
        private final Integer v;

        private Inner(Integer v) {
            this.v = v;
        }

        Integer getV() {
            return this.v;
        }
    }
}

