/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp;

import java.io.IOException;
import java.io.NotSerializableException;
import net.corda.core.serialization.SerializedBytes;
import net.corda.core.utilities.ByteSequence;
import net.corda.serialization.internal.amqp.DeserializationInput;
import net.corda.serialization.internal.amqp.SerializerFactory;
import net.corda.serialization.internal.amqp.testutils.AMQPTestUtilsKt;
import net.corda.serialization.internal.amqp.testutils.TestSerializationContext;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class JavaEvolutionTests {
    @Rule
    public final ExpectedException exception = ExpectedException.none();
    SerializerFactory factory = AMQPTestUtilsKt.testDefaultFactory();

    @Test
    public void testN1AddsNullableInt() throws IOException {
        N1 n2 = (N1)new DeserializationInput(this.factory).deserialize((ByteSequence)new SerializedBytes(AMQPTestUtilsKt.readTestResource(this)), N1.class, TestSerializationContext.testSerializationContext);
        Assert.assertEquals((Object)n2.getWord(), (Object)"potato");
        Assert.assertNull((Object)n2.getWibble());
    }

    @Test
    public void testN2AddsPrimitive() throws IOException {
        this.exception.expect(NotSerializableException.class);
        new DeserializationInput(this.factory).deserialize((ByteSequence)new SerializedBytes(AMQPTestUtilsKt.readTestResource(this)), N2.class, TestSerializationContext.testSerializationContext);
    }

    @Test
    public void testNullableInteger() throws IOException {
        POJOWithInteger n2 = (POJOWithInteger)new DeserializationInput(this.factory).deserialize((ByteSequence)new SerializedBytes(AMQPTestUtilsKt.readTestResource(this)), POJOWithInteger.class, TestSerializationContext.testSerializationContext);
        Assert.assertEquals((Object)100, (Object)n2.getId());
    }

    static class POJOWithInteger
    implements ForceEvolution {
        private Integer id;

        POJOWithInteger() {
        }

        public Integer getId() {
            return this.id;
        }

        public void setId(Integer id) {
            this.id = id;
        }
    }

    public static interface ForceEvolution {
    }

    static class N2 {
        private String word;
        private float wibble;

        public N2(String word, float wibble) {
            this.word = word;
            this.wibble = wibble;
        }

        public String getWord() {
            return this.word;
        }

        public float getWibble() {
            return this.wibble;
        }
    }

    static class N1 {
        private String word;
        private Integer wibble;

        public N1(String word, Integer wibble) {
            this.word = word;
            this.wibble = wibble;
        }

        public String getWord() {
            return this.word;
        }

        public Integer getWibble() {
            return this.wibble;
        }
    }
}

