/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp;

import java.io.NotSerializableException;
import java.util.ArrayList;
import java.util.List;
import net.corda.core.serialization.SerializationCustomSerializer;
import net.corda.serialization.internal.amqp.CorDappCustomSerializer;
import net.corda.serialization.internal.amqp.LocalSerializerFactory;
import net.corda.serialization.internal.amqp.SerializationOutput;
import net.corda.serialization.internal.amqp.SerializerFactory;
import net.corda.serialization.internal.amqp.testutils.AMQPTestUtilsKt;
import net.corda.serialization.internal.amqp.testutils.TestSerializationContext;
import org.junit.Test;

public class JavaCustomSerializerTests {
    @Test
    public void serializeExample() throws NotSerializableException {
        SerializerFactory factory = AMQPTestUtilsKt.testDefaultFactory();
        SerializationOutput ser = new SerializationOutput((LocalSerializerFactory)factory);
        ArrayList<Integer> l = new ArrayList<Integer>(2);
        l.add(10);
        l.add(20);
        Example e2 = new Example(l);
        CorDappCustomSerializer ccs = new CorDappCustomSerializer((SerializationCustomSerializer)new ExampleSerializer(), factory);
        factory.registerExternal(ccs);
        ser.serialize((Object)e2, TestSerializationContext.testSerializationContext);
    }

    public static class ExampleSerializer
    implements SerializationCustomSerializer<Example, ExampleProxy> {
        public ExampleProxy toProxy(Example obj) {
            return new ExampleProxy(obj.getA(), obj.getB());
        }

        public Example fromProxy(ExampleProxy proxy) {
            ArrayList<Integer> l = new ArrayList<Integer>(2);
            l.add(proxy.getProxiedA());
            l.add(proxy.getProxiedB());
            return new Example(l);
        }
    }

    public static class ExampleProxy {
        private Integer proxiedA;
        private Integer proxiedB;

        public Integer getProxiedA() {
            return this.proxiedA;
        }

        public Integer getProxiedB() {
            return this.proxiedB;
        }

        public ExampleProxy(Integer proxiedA, Integer proxiedB) {
            this.proxiedA = proxiedA;
            this.proxiedB = proxiedB;
        }
    }

    static class Example {
        private Integer a;
        private Integer b;

        Integer getA() {
            return this.a;
        }

        Integer getB() {
            return this.b;
        }

        public Example(List<Integer> l) {
            this.a = l.get(0);
            this.b = l.get(1);
        }
    }
}

