/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp;

import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.security.PublicKey;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.test.AssertionsKt;
import net.corda.core.contracts.AttachmentConstraint;
import net.corda.core.contracts.ContractState;
import net.corda.core.contracts.TransactionState;
import net.corda.core.crypto.Crypto;
import net.corda.core.crypto.SignatureScheme;
import net.corda.core.identity.CordaX500Name;
import net.corda.core.identity.Party;
import net.corda.core.serialization.ClassWhitelist;
import net.corda.core.serialization.SerializationContext;
import net.corda.core.serialization.SerializedBytes;
import net.corda.core.utilities.ByteSequence;
import net.corda.serialization.internal.AllWhitelist;
import net.corda.serialization.internal.amqp.BytesAndSchemas;
import net.corda.serialization.internal.amqp.CustomSerializer;
import net.corda.serialization.internal.amqp.DeserializationInput;
import net.corda.serialization.internal.amqp.GenericsTests;
import net.corda.serialization.internal.amqp.LocalSerializerFactory;
import net.corda.serialization.internal.amqp.ObjectAndEnvelope;
import net.corda.serialization.internal.amqp.SerializationOutput;
import net.corda.serialization.internal.amqp.SerializerFactory;
import net.corda.serialization.internal.amqp.SerializerFactoryBuilder;
import net.corda.serialization.internal.amqp.TestAttachmentConstraint;
import net.corda.serialization.internal.amqp.TestContractState;
import net.corda.serialization.internal.amqp.custom.PublicKeySerializer;
import net.corda.serialization.internal.amqp.testutils.AMQPTestUtilsKt;
import net.corda.serialization.internal.amqp.testutils.ProjectStructure;
import net.corda.serialization.internal.amqp.testutils.TestSerializationContextKt;
import net.corda.serialization.internal.amqp.testutils.TestSerializationOutput;
import net.corda.serialization.internal.carpenter.ClassCarpenter;
import net.corda.serialization.internal.carpenter.ClassCarpenterImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 )2\u00020\u0001:\u0005)*+,-B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007J\b\u0010\u0006\u001a\u00020\u0004H\u0007J\b\u0010\u0007\u001a\u00020\u0004H\u0007J\b\u0010\b\u001a\u00020\u0004H\u0007J\b\u0010\t\u001a\u00020\u0004H\u0007J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0001H\u0002J\b\u0010\f\u001a\u00020\u0004H\u0007J\b\u0010\r\u001a\u00020\u0004H\u0007J\u001e\u0010\r\u001a\u00020\u00042\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0002J\u001e\u0010\u0012\u001a\u00020\u00042\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0013\u001a\u00020\u0004H\u0007J\u001e\u0010\u0014\u001a\u00020\u00042\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0002J\"\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u000f2\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00172\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0018\u001a\u00020\u0004H\u0007J\u0006\u0010\u0019\u001a\u00020\u0004J\b\u0010\u001a\u001a\u00020\u0004H\u0007J\b\u0010\u001b\u001a\u00020\u0004H\u0007J\b\u0010\u001c\u001a\u00020\u0004H\u0007J\b\u0010\u001d\u001a\u00020\u0004H\u0007J\b\u0010\u001e\u001a\u00020\u0004H\u0007J\b\u0010\u001f\u001a\u00020\u0004H\u0007J\b\u0010 \u001a\u00020\u0004H\u0007J\b\u0010!\u001a\u00020\u0004H\u0007J\b\u0010\"\u001a\u00020\u0004H\u0007J\b\u0010#\u001a\u00020\u0004H\u0007J\b\u0010$\u001a\u00020\u0004H\u0002J\b\u0010%\u001a\u00020\u0004H\u0007J\u001c\u0010&\u001a\u00020\u0004\"\b\b\u0000\u0010'*\u00020\u0001*\b\u0012\u0004\u0012\u0002H'0(H\u0002\u00a8\u0006."}, d2={"Lnet/corda/serialization/internal/amqp/GenericsTests;", "", "()V", "baseClassInheritedButNotOverriden", "", "baseClassInheritedButNotOverridenBounded", "doWeIgnoreMultipleParams", "fingerprintingDiffers", "fingerprintingDiffersList", "fingerprintingDiffersListLoaded", "fingerprintingDiffersStrip", "state", "forceWildcard", "forceWildcardDeserialize", "bytes", "Lnet/corda/core/serialization/SerializedBytes;", "factory", "Lnet/corda/serialization/internal/amqp/SerializerFactory;", "forceWildcardDeserializeDouble", "forceWildcardDeserializeSharedFactory", "forceWildcardDeserializeString", "forceWildcardSerialize", "a", "Lnet/corda/serialization/internal/amqp/GenericsTests$ForceWildcard;", "forceWildcardSharedFactory", "implemntsGeneric", "implemntsGenericInterface", "loadGenericFromFile", "nestedGenericsReferencesByteArrayViaSerializedBytes", "nestedGenericsWithBound", "nestedMultiGenericsAtBottomWithBound", "nestedMultiGenericsNoBound", "nestedMultiGenericsWithBound", "nestedSerializationInMultipleContextsDoesntColideGenericTypes", "nestedSerializationOfGenerics", "nestedSerializationWhereGenericDoesntImpactFingerprint", "printSeparator", "twoDifferentTypesSameParameterizedOuter", "printSchema", "T", "Lnet/corda/serialization/internal/amqp/BytesAndSchemas;", "Companion", "ForceWildcard", "GenericStateAndString", "StateAndString", "implementsGenericInterfaceI", "serialization"})
public final class GenericsTests {
    public static final boolean VERBOSE = true;
    @NotNull
    private static URI localPath;
    private static final CordaX500Name MINI_CORP_NAME;
    private static final Party MINI_CORP_PARTY;
    public static final Companion Companion;

    private final void printSeparator() {
        String string = "\n\n-------------------------------------------\n\n";
        System.out.println((Object)string);
    }

    private final <T> void printSchema(@NotNull BytesAndSchemas<T> $receiver) {
        String string = "" + $receiver.getSchema() + '\n';
        System.out.println((Object)string);
    }

    @Test(timeout=300000L)
    public final void twoDifferentTypesSameParameterizedOuter() {
        BytesAndSchemas bytesAndSchemas;
        SerializerFactory factory = AMQPTestUtilsKt.testDefaultFactoryNoEvolution$default(null, 1, null);
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000#\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\b\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u0000H\u00c6\u0001\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"net/corda/serialization/internal/amqp/GenericsTests$twoDifferentTypesSameParameterizedOuter$G", "A", "", "a", "(Ljava/lang/Object;)V", "getA", "()Ljava/lang/Object;", "Ljava/lang/Object;", "component1", "copy", "(Ljava/lang/Object;)Lnet/corda/serialization/internal/amqp/GenericsTests$twoDifferentTypesSameParameterizedOuter$G;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
        public final class G<A> {
            private final A a;

            public final A getA() {
                return this.a;
            }

            public G(A a) {
                this.a = a;
            }

            public final A component1() {
                return this.a;
            }

            @NotNull
            public final G<A> copy(A a) {
                return new G<A>(a);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ G copy$default(G g, Object object, int n, Object object2) {
                if ((n & 1) != 0) {
                    object = g.a;
                }
                return g.copy(object);
            }

            @NotNull
            public String toString() {
                return "G(a=" + this.a + ")";
            }

            public int hashCode() {
                A a = this.a;
                return a != null ? a.hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof G)) break block3;
                        G g = (G)object;
                        if (!Intrinsics.areEqual(this.a, g.a)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        BytesAndSchemas $receiver = bytesAndSchemas = AMQPTestUtilsKt.serializeAndReturnSchema$default(new SerializationOutput((LocalSerializerFactory)factory), new G<String>("hi"), null, 2, null);
        this.printSchema($receiver);
        BytesAndSchemas bytes1 = bytesAndSchemas;
        BytesAndSchemas $receiver2 = $receiver = AMQPTestUtilsKt.serializeAndReturnSchema$default(new SerializationOutput((LocalSerializerFactory)factory), new G<Integer>(121), null, 2, null);
        this.printSchema($receiver2);
        BytesAndSchemas bytes2 = $receiver;
        Iterable $receiver$iv = CollectionsKt.listOf((Object[])new SerializerFactory[]{factory, AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null)});
        for (Object element$iv : $receiver$iv) {
            Object $receiver$iv2;
            SerializerFactory f = (SerializerFactory)element$iv;
            Object object = new DeserializationInput(f);
            SerializedBytes bytes$iv = bytes1.getObj();
            SerializationContext context$iv = null;
            $receiver$iv2 = $receiver$iv2.deserialize((ByteSequence)bytes$iv, G.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
            G $receiver3 = (G)$receiver$iv2;
            AssertionsKt.assertEquals$default((Object)"hi", $receiver3.getA(), null, (int)4, null);
            $receiver$iv2 = new DeserializationInput(f);
            bytes$iv = bytes2.getObj();
            context$iv = null;
            object = $receiver$iv2.deserialize((ByteSequence)bytes$iv, G.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
            $receiver3 = (G)object;
            AssertionsKt.assertEquals$default((Object)121, $receiver3.getA(), null, (int)4, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void doWeIgnoreMultipleParams() {
        void $receiver$iv;
        BytesAndSchemas bytesAndSchemas;
        SerializerFactory factory = AMQPTestUtilsKt.testDefaultFactoryNoEvolution$default(null, 1, null);
        SerializerFactory factory2 = AMQPTestUtilsKt.testDefaultFactoryNoEvolution$default(null, 1, null);
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000+\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\b\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000*\u0003\u0000\u0006\b\b\u008a\b\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002B)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0012\u001a\u00020\u0004H\u00c6\u0003J\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H\u00c6\u0003\u00a2\u0006\u0002\u0010\rJ\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\bH\u00c6\u0003\u00a2\u0006\u0002\u0010\u0010J>\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bH\u00c6\u0001\u00a2\u0006\u0002\u0010\u0016J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u0004H\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u0019\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001d"}, d2={"net/corda/serialization/internal/amqp/GenericsTests$doWeIgnoreMultipleParams$Wrapper", "T", "", "a", "", "b", "net/corda/serialization/internal/amqp/GenericsTests$doWeIgnoreMultipleParams$G1", "c", "net/corda/serialization/internal/amqp/GenericsTests$doWeIgnoreMultipleParams$G2", "(ILnet/corda/serialization/internal/amqp/GenericsTests$doWeIgnoreMultipleParams$G1;Lnet/corda/serialization/internal/amqp/GenericsTests$doWeIgnoreMultipleParams$G2;)V", "getA", "()I", "getB", "()Lnet/corda/serialization/internal/amqp/GenericsTests$doWeIgnoreMultipleParams$G1;", "Lnet/corda/serialization/internal/amqp/GenericsTests$doWeIgnoreMultipleParams$G1;", "getC", "()Lnet/corda/serialization/internal/amqp/GenericsTests$doWeIgnoreMultipleParams$G2;", "Lnet/corda/serialization/internal/amqp/GenericsTests$doWeIgnoreMultipleParams$G2;", "component1", "component2", "component3", "copy", "(ILnet/corda/serialization/internal/amqp/GenericsTests$doWeIgnoreMultipleParams$G1;Lnet/corda/serialization/internal/amqp/GenericsTests$doWeIgnoreMultipleParams$G2;)Lnet/corda/serialization/internal/amqp/GenericsTests$doWeIgnoreMultipleParams$Wrapper;", "equals", "", "other", "hashCode", "toString", "", "serialization"})
        public final class Wrapper<T> {
            private final int a;
            @NotNull
            private final G1<T> b;
            @NotNull
            private final G2<T> c;

            public final int getA() {
                return this.a;
            }

            @NotNull
            public final G1<T> getB() {
                @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000#\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\b\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u0000H\u00c6\u0001\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"net/corda/serialization/internal/amqp/GenericsTests$doWeIgnoreMultipleParams$G1", "T", "", "a", "(Ljava/lang/Object;)V", "getA", "()Ljava/lang/Object;", "Ljava/lang/Object;", "component1", "copy", "(Ljava/lang/Object;)Lnet/corda/serialization/internal/amqp/GenericsTests$doWeIgnoreMultipleParams$G1;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
                public final class G1<T> {
                    private final T a;

                    public final T getA() {
                        return this.a;
                    }

                    public G1(T a) {
                        this.a = a;
                    }

                    public final T component1() {
                        return this.a;
                    }

                    @NotNull
                    public final G1<T> copy(T a) {
                        return new G1<T>(a);
                    }

                    @NotNull
                    public static /* bridge */ /* synthetic */ G1 copy$default(G1 g1, Object object, int n, Object object2) {
                        if ((n & 1) != 0) {
                            object = g1.a;
                        }
                        return g1.copy(object);
                    }

                    @NotNull
                    public String toString() {
                        return "G1(a=" + this.a + ")";
                    }

                    public int hashCode() {
                        T t = this.a;
                        return t != null ? t.hashCode() : 0;
                    }

                    public boolean equals(@Nullable Object object) {
                        block3: {
                            block2: {
                                if (this == object) break block2;
                                if (!(object instanceof G1)) break block3;
                                G1 g1 = (G1)object;
                                if (!Intrinsics.areEqual(this.a, g1.a)) break block3;
                            }
                            return true;
                        }
                        return false;
                    }
                }
                return this.b;
            }

            @NotNull
            public final G2<T> getC() {
                @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000#\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\b\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u0000H\u00c6\u0001\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"net/corda/serialization/internal/amqp/GenericsTests$doWeIgnoreMultipleParams$G2", "T", "", "a", "(Ljava/lang/Object;)V", "getA", "()Ljava/lang/Object;", "Ljava/lang/Object;", "component1", "copy", "(Ljava/lang/Object;)Lnet/corda/serialization/internal/amqp/GenericsTests$doWeIgnoreMultipleParams$G2;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
                public final class G2<T> {
                    private final T a;

                    public final T getA() {
                        return this.a;
                    }

                    public G2(T a) {
                        this.a = a;
                    }

                    public final T component1() {
                        return this.a;
                    }

                    @NotNull
                    public final G2<T> copy(T a) {
                        return new G2<T>(a);
                    }

                    @NotNull
                    public static /* bridge */ /* synthetic */ G2 copy$default(G2 g2, Object object, int n, Object object2) {
                        if ((n & 1) != 0) {
                            object = g2.a;
                        }
                        return g2.copy(object);
                    }

                    @NotNull
                    public String toString() {
                        return "G2(a=" + this.a + ")";
                    }

                    public int hashCode() {
                        T t = this.a;
                        return t != null ? t.hashCode() : 0;
                    }

                    public boolean equals(@Nullable Object object) {
                        block3: {
                            block2: {
                                if (this == object) break block2;
                                if (!(object instanceof G2)) break block3;
                                G2 g2 = (G2)object;
                                if (!Intrinsics.areEqual(this.a, g2.a)) break block3;
                            }
                            return true;
                        }
                        return false;
                    }
                }
                return this.c;
            }

            public Wrapper(int a, @NotNull G1<? extends T> b, @NotNull G2<? extends T> c) {
                Intrinsics.checkParameterIsNotNull(b, (String)"b");
                Intrinsics.checkParameterIsNotNull(c, (String)"c");
                this.a = a;
                this.b = b;
                this.c = c;
            }

            public final int component1() {
                return this.a;
            }

            @NotNull
            public final G1<T> component2() {
                return this.b;
            }

            @NotNull
            public final G2<T> component3() {
                return this.c;
            }

            @NotNull
            public final Wrapper<T> copy(int a, @NotNull G1<? extends T> b, @NotNull G2<? extends T> c) {
                Intrinsics.checkParameterIsNotNull(b, (String)"b");
                Intrinsics.checkParameterIsNotNull(c, (String)"c");
                return new Wrapper<T>(a, b, c);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ Wrapper copy$default(Wrapper wrapper, int n, G1 g1, G2 g2, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = wrapper.a;
                }
                if ((n2 & 2) != 0) {
                    g1 = wrapper.b;
                }
                if ((n2 & 4) != 0) {
                    g2 = wrapper.c;
                }
                return wrapper.copy(n, g1, g2);
            }

            @NotNull
            public String toString() {
                return "Wrapper(a=" + this.a + ", b=" + this.b + ", c=" + this.c + ")";
            }

            public int hashCode() {
                G1<T> g1 = this.b;
                G2<T> g2 = this.c;
                return (Integer.hashCode(this.a) * 31 + (g1 != null ? ((Object)g1).hashCode() : 0)) * 31 + (g2 != null ? ((Object)g2).hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Wrapper)) break block3;
                        Wrapper wrapper = (Wrapper)object;
                        if (!(this.a == wrapper.a) || !Intrinsics.areEqual(this.b, wrapper.b) || !Intrinsics.areEqual(this.c, wrapper.c)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        BytesAndSchemas $receiver = bytesAndSchemas = AMQPTestUtilsKt.serializeAndReturnSchema$default(new SerializationOutput((LocalSerializerFactory)factory), new Wrapper<String>(1, new G1<String>("hi"), new G2<String>("poop")), null, 2, null);
        this.printSchema($receiver);
        BytesAndSchemas bytes = bytesAndSchemas;
        this.printSeparator();
        bytesAndSchemas = new DeserializationInput(factory2);
        SerializedBytes bytes$iv = bytes.getObj();
        SerializationContext context$iv = null;
        $receiver$iv.deserialize((ByteSequence)bytes$iv, Wrapper.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
    }

    @Test(timeout=300000L)
    public final void nestedSerializationOfGenerics() {
        Object $receiver$iv;
        SerializedBytes bytes$iv;
        DeserializationInput $receiver$iv2;
        BytesAndSchemas bytesAndSchemas;
        SerializerFactory factory = AMQPTestUtilsKt.testDefaultFactoryNoEvolution$default(null, 1, null);
        SerializerFactory altContextFactory = AMQPTestUtilsKt.testDefaultFactoryNoEvolution$default(null, 1, null);
        SerializationOutput ser = new SerializationOutput((LocalSerializerFactory)factory);
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000#\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\b\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u0000H\u00c6\u0001\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"net/corda/serialization/internal/amqp/GenericsTests$nestedSerializationOfGenerics$G", "T", "", "a", "(Ljava/lang/Object;)V", "getA", "()Ljava/lang/Object;", "Ljava/lang/Object;", "component1", "copy", "(Ljava/lang/Object;)Lnet/corda/serialization/internal/amqp/GenericsTests$nestedSerializationOfGenerics$G;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
        public final class G<T> {
            private final T a;

            public final T getA() {
                return this.a;
            }

            public G(T a) {
                this.a = a;
            }

            public final T component1() {
                return this.a;
            }

            @NotNull
            public final G<T> copy(T a) {
                return new G<T>(a);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ G copy$default(G g, Object object, int n, Object object2) {
                if ((n & 1) != 0) {
                    object = g.a;
                }
                return g.copy(object);
            }

            @NotNull
            public String toString() {
                return "G(a=" + this.a + ")";
            }

            public int hashCode() {
                T t = this.a;
                return t != null ? t.hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof G)) break block3;
                        G g = (G)object;
                        if (!Intrinsics.areEqual(this.a, g.a)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        BytesAndSchemas $receiver = bytesAndSchemas = AMQPTestUtilsKt.serializeAndReturnSchema$default(ser, new G<String>("hi"), null, 2, null);
        this.printSchema($receiver);
        BytesAndSchemas bytes = bytesAndSchemas;
        bytesAndSchemas = new DeserializationInput(factory);
        $receiver = bytes.getObj();
        String string = "hi";
        SerializationContext context$iv = null;
        Object object = $receiver$iv2.deserialize((ByteSequence)bytes$iv, G.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)string, ((G)object).getA(), null, (int)4, null);
        $receiver$iv2 = new DeserializationInput(altContextFactory);
        bytes$iv = bytes.getObj();
        string = "hi";
        context$iv = null;
        object = $receiver$iv2.deserialize((ByteSequence)bytes$iv, G.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)string, ((G)object).getA(), null, (int)4, null);
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000*\u0002\u0000\u0006\b\u008a\b\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0004H\u00c6\u0003J\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000bJ.\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0010J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0004H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0019\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"net/corda/serialization/internal/amqp/GenericsTests$nestedSerializationOfGenerics$Wrapper", "T", "", "a", "", "b", "net/corda/serialization/internal/amqp/GenericsTests$nestedSerializationOfGenerics$G", "(ILnet/corda/serialization/internal/amqp/GenericsTests$nestedSerializationOfGenerics$G;)V", "getA", "()I", "getB", "()Lnet/corda/serialization/internal/amqp/GenericsTests$nestedSerializationOfGenerics$G;", "Lnet/corda/serialization/internal/amqp/GenericsTests$nestedSerializationOfGenerics$G;", "component1", "component2", "copy", "(ILnet/corda/serialization/internal/amqp/GenericsTests$nestedSerializationOfGenerics$G;)Lnet/corda/serialization/internal/amqp/GenericsTests$nestedSerializationOfGenerics$Wrapper;", "equals", "", "other", "hashCode", "toString", "", "serialization"})
        public final class Wrapper<T> {
            private final int a;
            @NotNull
            private final G<T> b;

            public final int getA() {
                return this.a;
            }

            @NotNull
            public final G<T> getB() {
                return this.b;
            }

            public Wrapper(int a, @NotNull G<? extends T> b) {
                Intrinsics.checkParameterIsNotNull(b, (String)"b");
                this.a = a;
                this.b = b;
            }

            public final int component1() {
                return this.a;
            }

            @NotNull
            public final G<T> component2() {
                return this.b;
            }

            @NotNull
            public final Wrapper<T> copy(int a, @NotNull G<? extends T> b) {
                Intrinsics.checkParameterIsNotNull(b, (String)"b");
                return new Wrapper<T>(a, b);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ Wrapper copy$default(Wrapper wrapper, int n, G g, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = wrapper.a;
                }
                if ((n2 & 2) != 0) {
                    g = wrapper.b;
                }
                return wrapper.copy(n, g);
            }

            @NotNull
            public String toString() {
                return "Wrapper(a=" + this.a + ", b=" + this.b + ")";
            }

            public int hashCode() {
                G<T> g = this.b;
                return Integer.hashCode(this.a) * 31 + (g != null ? ((Object)g).hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Wrapper)) break block3;
                        Wrapper wrapper = (Wrapper)object;
                        if (!(this.a == wrapper.a) || !Intrinsics.areEqual(this.b, wrapper.b)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        bytes$iv = AMQPTestUtilsKt.serializeAndReturnSchema$default(ser, new Wrapper<String>(1, new G<String>("hi")), null, 2, null);
        Object $receiver2 = bytes$iv;
        this.printSchema((BytesAndSchemas)$receiver2);
        SerializedBytes bytes2 = bytes$iv;
        this.printSeparator();
        bytes$iv = new DeserializationInput(factory);
        SerializedBytes bytes$iv2 = bytes2.getObj();
        SerializationContext context$iv2 = null;
        $receiver$iv = $receiver$iv.deserialize((ByteSequence)bytes$iv2, Wrapper.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        $receiver2 = (Wrapper)$receiver$iv;
        AssertionsKt.assertEquals$default((Object)1, (Object)((Wrapper)$receiver2).getA(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)"hi", ((Wrapper)$receiver2).getB().getA(), null, (int)4, null);
        $receiver$iv = new DeserializationInput(altContextFactory);
        bytes$iv2 = bytes2.getObj();
        context$iv2 = null;
        Object object2 = $receiver$iv.deserialize((ByteSequence)bytes$iv2, Wrapper.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        $receiver2 = (Wrapper)object2;
        AssertionsKt.assertEquals$default((Object)1, (Object)((Wrapper)$receiver2).getA(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)"hi", ((Wrapper)$receiver2).getB().getA(), null, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void nestedGenericsReferencesByteArrayViaSerializedBytes() {
        void bytes$iv;
        void $receiver$iv;
        Object $receiver$iv2;
        ClassWhitelist classWhitelist = (ClassWhitelist)AllWhitelist.INSTANCE;
        ClassWhitelist classWhitelist2 = (ClassWhitelist)AllWhitelist.INSTANCE;
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        Intrinsics.checkExpressionValueIsNotNull((Object)classLoader, (String)"ClassLoader.getSystemClassLoader()");
        SerializerFactory factory = SerializerFactoryBuilder.build((ClassWhitelist)classWhitelist, (ClassCarpenter)((ClassCarpenter)new ClassCarpenterImpl(classWhitelist2, classLoader, false, 4, null)));
        ClassWhitelist classWhitelist3 = (ClassWhitelist)AllWhitelist.INSTANCE;
        ClassWhitelist classWhitelist4 = (ClassWhitelist)AllWhitelist.INSTANCE;
        ClassLoader classLoader2 = ClassLoader.getSystemClassLoader();
        Intrinsics.checkExpressionValueIsNotNull((Object)classLoader2, (String)"ClassLoader.getSystemClassLoader()");
        SerializerFactory factory2 = SerializerFactoryBuilder.build((ClassWhitelist)classWhitelist3, (ClassCarpenter)((ClassCarpenter)new ClassCarpenterImpl(classWhitelist4, classLoader2, false, 4, null)));
        SerializationOutput ser = new SerializationOutput((LocalSerializerFactory)factory);
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000!\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0018\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"net/corda/serialization/internal/amqp/GenericsTests$nestedGenericsReferencesByteArrayViaSerializedBytes$G", "", "a", "", "(I)V", "getA", "()I", "component1", "copy", "(I)Lnet/corda/serialization/internal/amqp/GenericsTests$nestedGenericsReferencesByteArrayViaSerializedBytes$G;", "equals", "", "other", "hashCode", "toString", "", "serialization"})
        public final class G {
            private final int a;

            public final int getA() {
                return this.a;
            }

            public G(int a) {
                this.a = a;
            }

            public final int component1() {
                return this.a;
            }

            @NotNull
            public final G copy(int a) {
                return new G(a);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ G copy$default(G g, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = g.a;
                }
                return g.copy(n);
            }

            @NotNull
            public String toString() {
                return "G(a=" + this.a + ")";
            }

            public int hashCode() {
                return Integer.hashCode(this.a);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof G)) break block3;
                        G g = (G)object;
                        if (!(this.a == g.a)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        SerializedBytes gBytes = AMQPTestUtilsKt.serialize$default(ser, new G(1), null, 2, null);
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000)\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0004H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H\u00c6\u0003J.\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0004H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"net/corda/serialization/internal/amqp/GenericsTests$nestedGenericsReferencesByteArrayViaSerializedBytes$Wrapper", "T", "", "a", "", "b", "Lnet/corda/core/serialization/SerializedBytes;", "(ILnet/corda/core/serialization/SerializedBytes;)V", "getA", "()I", "getB", "()Lnet/corda/core/serialization/SerializedBytes;", "component1", "component2", "copy", "(ILnet/corda/core/serialization/SerializedBytes;)Lnet/corda/serialization/internal/amqp/GenericsTests$nestedGenericsReferencesByteArrayViaSerializedBytes$Wrapper;", "equals", "", "other", "hashCode", "toString", "", "serialization"})
        public final class Wrapper<T> {
            private final int a;
            @NotNull
            private final SerializedBytes<T> b;

            public final int getA() {
                return this.a;
            }

            @NotNull
            public final SerializedBytes<T> getB() {
                return this.b;
            }

            public Wrapper(int a, @NotNull SerializedBytes<T> b) {
                Intrinsics.checkParameterIsNotNull(b, (String)"b");
                this.a = a;
                this.b = b;
            }

            public final int component1() {
                return this.a;
            }

            @NotNull
            public final SerializedBytes<T> component2() {
                return this.b;
            }

            @NotNull
            public final Wrapper<T> copy(int a, @NotNull SerializedBytes<T> b) {
                Intrinsics.checkParameterIsNotNull(b, (String)"b");
                return new Wrapper<T>(a, b);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ Wrapper copy$default(Wrapper wrapper, int n, SerializedBytes serializedBytes, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = wrapper.a;
                }
                if ((n2 & 2) != 0) {
                    serializedBytes = wrapper.b;
                }
                return wrapper.copy(n, serializedBytes);
            }

            @NotNull
            public String toString() {
                return "Wrapper(a=" + this.a + ", b=" + this.b + ")";
            }

            public int hashCode() {
                SerializedBytes<T> serializedBytes = this.b;
                return Integer.hashCode(this.a) * 31 + (serializedBytes != null ? serializedBytes.hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Wrapper)) break block3;
                        Wrapper wrapper = (Wrapper)object;
                        if (!(this.a == wrapper.a) || !Intrinsics.areEqual(this.b, wrapper.b)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        BytesAndSchemas bytes2 = AMQPTestUtilsKt.serializeAndReturnSchema$default(ser, new Wrapper(1, gBytes), null, 2, null);
        Object object = new DeserializationInput(factory);
        SerializedBytes bytes$iv2 = bytes2.getObj();
        SerializationContext context$iv = null;
        $receiver$iv2 = $receiver$iv2.deserialize((ByteSequence)bytes$iv2, Wrapper.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        Wrapper $receiver = (Wrapper)$receiver$iv2;
        AssertionsKt.assertEquals$default((Object)1, (Object)$receiver.getA(), null, (int)4, null);
        context$iv = new DeserializationInput(factory);
        SerializedBytes $i$f$deserialize = $receiver.getB();
        Integer n = 1;
        SerializationContext context$iv2 = null;
        Object object2 = $receiver$iv.deserialize((ByteSequence)bytes$iv, G.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)n, (Object)((G)object2).getA(), null, (int)4, null);
        $receiver$iv2 = new DeserializationInput(factory2);
        bytes$iv2 = bytes2.getObj();
        context$iv = null;
        object = $receiver$iv2.deserialize((ByteSequence)bytes$iv2, Wrapper.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        $receiver = (Wrapper)object;
        AssertionsKt.assertEquals$default((Object)1, (Object)$receiver.getA(), null, (int)4, null);
        context$iv = new DeserializationInput(factory);
        $i$f$deserialize = $receiver.getB();
        n = 1;
        context$iv2 = null;
        object2 = $receiver$iv.deserialize((ByteSequence)bytes$iv, G.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)n, (Object)((G)object2).getA(), null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void nestedSerializationInMultipleContextsDoesntColideGenericTypes() {
        Wrapper $receiver;
        Object $receiver$iv;
        SerializationContext context$iv;
        SerializedBytes bytes$iv;
        Object object;
        SerializerFactory it;
        SerializedBytes serializedBytes;
        ClassWhitelist classWhitelist = (ClassWhitelist)AllWhitelist.INSTANCE;
        ClassWhitelist classWhitelist2 = (ClassWhitelist)AllWhitelist.INSTANCE;
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        Intrinsics.checkExpressionValueIsNotNull((Object)classLoader, (String)"ClassLoader.getSystemClassLoader()");
        SerializerFactory factory = SerializerFactoryBuilder.build((ClassWhitelist)classWhitelist, (ClassCarpenter)((ClassCarpenter)new ClassCarpenterImpl(classWhitelist2, classLoader, false, 4, null)));
        Object[] objectArray = new SerializerFactory[2];
        objectArray[0] = factory;
        ClassWhitelist classWhitelist3 = (ClassWhitelist)AllWhitelist.INSTANCE;
        ClassWhitelist classWhitelist4 = (ClassWhitelist)AllWhitelist.INSTANCE;
        ClassLoader classLoader2 = ClassLoader.getSystemClassLoader();
        Intrinsics.checkExpressionValueIsNotNull((Object)classLoader2, (String)"ClassLoader.getSystemClassLoader()");
        objectArray[1] = SerializerFactoryBuilder.build((ClassWhitelist)classWhitelist3, (ClassCarpenter)((ClassCarpenter)new ClassCarpenterImpl(classWhitelist4, classLoader2, false, 4, null)));
        List factories = CollectionsKt.listOf((Object[])objectArray);
        SerializationOutput ser = new SerializationOutput((LocalSerializerFactory)factory);
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0002\u0000\u0004\b\u008a\b\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005J\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0007J$\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"net/corda/serialization/internal/amqp/GenericsTests$nestedSerializationInMultipleContextsDoesntColideGenericTypes$Wrapper", "T", "", "c", "net/corda/serialization/internal/amqp/GenericsTests$nestedSerializationInMultipleContextsDoesntColideGenericTypes$Container", "(Lnet/corda/serialization/internal/amqp/GenericsTests$nestedSerializationInMultipleContextsDoesntColideGenericTypes$Container;)V", "getC", "()Lnet/corda/serialization/internal/amqp/GenericsTests$nestedSerializationInMultipleContextsDoesntColideGenericTypes$Container;", "Lnet/corda/serialization/internal/amqp/GenericsTests$nestedSerializationInMultipleContextsDoesntColideGenericTypes$Container;", "component1", "copy", "(Lnet/corda/serialization/internal/amqp/GenericsTests$nestedSerializationInMultipleContextsDoesntColideGenericTypes$Container;)Lnet/corda/serialization/internal/amqp/GenericsTests$nestedSerializationInMultipleContextsDoesntColideGenericTypes$Wrapper;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
        public final class Wrapper<T> {
            @NotNull
            private final Container<T> c;

            @NotNull
            public final Container<T> getC() {
                @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000#\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\b\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u0000H\u00c6\u0001\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"net/corda/serialization/internal/amqp/GenericsTests$nestedSerializationInMultipleContextsDoesntColideGenericTypes$Container", "T", "", "b", "(Ljava/lang/Object;)V", "getB", "()Ljava/lang/Object;", "Ljava/lang/Object;", "component1", "copy", "(Ljava/lang/Object;)Lnet/corda/serialization/internal/amqp/GenericsTests$nestedSerializationInMultipleContextsDoesntColideGenericTypes$Container;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
                public final class Container<T> {
                    private final T b;

                    public final T getB() {
                        return this.b;
                    }

                    public Container(T b) {
                        this.b = b;
                    }

                    public final T component1() {
                        return this.b;
                    }

                    @NotNull
                    public final Container<T> copy(T b) {
                        return new Container<T>(b);
                    }

                    @NotNull
                    public static /* bridge */ /* synthetic */ Container copy$default(Container container, Object object, int n, Object object2) {
                        if ((n & 1) != 0) {
                            object = container.b;
                        }
                        return container.copy(object);
                    }

                    @NotNull
                    public String toString() {
                        return "Container(b=" + this.b + ")";
                    }

                    public int hashCode() {
                        T t = this.b;
                        return t != null ? t.hashCode() : 0;
                    }

                    public boolean equals(@Nullable Object object) {
                        block3: {
                            block2: {
                                if (this == object) break block2;
                                if (!(object instanceof Container)) break block3;
                                Container container = (Container)object;
                                if (!Intrinsics.areEqual(this.b, container.b)) break block3;
                            }
                            return true;
                        }
                        return false;
                    }
                }
                return this.c;
            }

            public Wrapper(@NotNull Container<T> c) {
                Intrinsics.checkParameterIsNotNull(c, (String)"c");
                this.c = c;
            }

            @NotNull
            public final Container<T> component1() {
                return this.c;
            }

            @NotNull
            public final Wrapper<T> copy(@NotNull Container<T> c) {
                Intrinsics.checkParameterIsNotNull(c, (String)"c");
                return new Wrapper<T>(c);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ Wrapper copy$default(Wrapper wrapper, Container container, int n, Object object) {
                if ((n & 1) != 0) {
                    container = wrapper.c;
                }
                return wrapper.copy(container);
            }

            @NotNull
            public String toString() {
                return "Wrapper(c=" + this.c + ")";
            }

            public int hashCode() {
                Container<T> container = this.c;
                return container != null ? ((Object)container).hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Wrapper)) break block3;
                        Wrapper wrapper = (Wrapper)object;
                        if (!Intrinsics.areEqual(this.c, wrapper.c)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000!\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0018\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"net/corda/serialization/internal/amqp/GenericsTests$nestedSerializationInMultipleContextsDoesntColideGenericTypes$InnerA", "", "a_a", "", "(I)V", "getA_a", "()I", "component1", "copy", "(I)Lnet/corda/serialization/internal/amqp/GenericsTests$nestedSerializationInMultipleContextsDoesntColideGenericTypes$InnerA;", "equals", "", "other", "hashCode", "toString", "", "serialization"})
        public final class InnerA {
            private final int a_a;

            public final int getA_a() {
                return this.a_a;
            }

            public InnerA(int a_a) {
                this.a_a = a_a;
            }

            public final int component1() {
                return this.a_a;
            }

            @NotNull
            public final InnerA copy(int a_a) {
                return new InnerA(a_a);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ InnerA copy$default(InnerA innerA, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = innerA.a_a;
                }
                return innerA.copy(n);
            }

            @NotNull
            public String toString() {
                return "InnerA(a_a=" + this.a_a + ")";
            }

            public int hashCode() {
                return Integer.hashCode(this.a_a);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof InnerA)) break block3;
                        InnerA innerA = (InnerA)object;
                        if (!(this.a_a == innerA.a_a)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        SerializedBytes $receiver2 = serializedBytes = AMQPTestUtilsKt.serialize$default(ser, new Wrapper<InnerA>(new Container<InnerA>(new InnerA(1))), null, 2, null);
        Iterable $receiver$iv2 = factories;
        for (Object element$iv : $receiver$iv2) {
            it = (SerializerFactory)element$iv;
            object = new DeserializationInput(it);
            bytes$iv = $receiver2;
            context$iv = null;
            $receiver$iv = $receiver$iv.deserialize((ByteSequence)bytes$iv, Wrapper.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
            $receiver = (Wrapper)$receiver$iv;
            AssertionsKt.assertEquals$default((Object)1, (Object)((InnerA)$receiver.getC().getB()).getA_a(), null, (int)4, null);
        }
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000!\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0018\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"net/corda/serialization/internal/amqp/GenericsTests$nestedSerializationInMultipleContextsDoesntColideGenericTypes$InnerB", "", "a_b", "", "(I)V", "getA_b", "()I", "component1", "copy", "(I)Lnet/corda/serialization/internal/amqp/GenericsTests$nestedSerializationInMultipleContextsDoesntColideGenericTypes$InnerB;", "equals", "", "other", "hashCode", "toString", "", "serialization"})
        public final class InnerB {
            private final int a_b;

            public final int getA_b() {
                return this.a_b;
            }

            public InnerB(int a_b) {
                this.a_b = a_b;
            }

            public final int component1() {
                return this.a_b;
            }

            @NotNull
            public final InnerB copy(int a_b) {
                return new InnerB(a_b);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ InnerB copy$default(InnerB innerB, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = innerB.a_b;
                }
                return innerB.copy(n);
            }

            @NotNull
            public String toString() {
                return "InnerB(a_b=" + this.a_b + ")";
            }

            public int hashCode() {
                return Integer.hashCode(this.a_b);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof InnerB)) break block3;
                        InnerB innerB = (InnerB)object;
                        if (!(this.a_b == innerB.a_b)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        $receiver2 = serializedBytes = AMQPTestUtilsKt.serialize$default(ser, new Wrapper<InnerB>(new Container<InnerB>(new InnerB(1))), null, 2, null);
        $receiver$iv2 = factories;
        for (Object element$iv : $receiver$iv2) {
            it = (SerializerFactory)element$iv;
            $receiver$iv = new DeserializationInput(it);
            bytes$iv = $receiver2;
            context$iv = null;
            $receiver$iv = $receiver$iv.deserialize((ByteSequence)bytes$iv, Wrapper.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
            $receiver = (Wrapper)$receiver$iv;
            AssertionsKt.assertEquals$default((Object)1, (Object)((InnerB)$receiver.getC().getB()).getA_b(), null, (int)4, null);
        }
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000#\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0018\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"net/corda/serialization/internal/amqp/GenericsTests$nestedSerializationInMultipleContextsDoesntColideGenericTypes$InnerC", "", "a_c", "", "(Ljava/lang/String;)V", "getA_c", "()Ljava/lang/String;", "component1", "copy", "(Ljava/lang/String;)Lnet/corda/serialization/internal/amqp/GenericsTests$nestedSerializationInMultipleContextsDoesntColideGenericTypes$InnerC;", "equals", "", "other", "hashCode", "", "toString", "serialization"})
        public final class InnerC {
            @NotNull
            private final String a_c;

            @NotNull
            public final String getA_c() {
                return this.a_c;
            }

            public InnerC(@NotNull String a_c) {
                Intrinsics.checkParameterIsNotNull((Object)a_c, (String)"a_c");
                this.a_c = a_c;
            }

            @NotNull
            public final String component1() {
                return this.a_c;
            }

            @NotNull
            public final InnerC copy(@NotNull String a_c) {
                Intrinsics.checkParameterIsNotNull((Object)a_c, (String)"a_c");
                return new InnerC(a_c);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ InnerC copy$default(InnerC innerC, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = innerC.a_c;
                }
                return innerC.copy(string);
            }

            @NotNull
            public String toString() {
                return "InnerC(a_c=" + this.a_c + ")";
            }

            public int hashCode() {
                String string = this.a_c;
                return string != null ? string.hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof InnerC)) break block3;
                        InnerC innerC = (InnerC)object;
                        if (!Intrinsics.areEqual((Object)this.a_c, (Object)innerC.a_c)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        $receiver2 = serializedBytes = AMQPTestUtilsKt.serialize$default(ser, new Wrapper<InnerC>(new Container<InnerC>(new InnerC("Ho ho ho"))), null, 2, null);
        $receiver$iv2 = factories;
        for (Object element$iv : $receiver$iv2) {
            it = (SerializerFactory)element$iv;
            $receiver$iv = new DeserializationInput(it);
            bytes$iv = $receiver2;
            context$iv = null;
            object = $receiver$iv.deserialize((ByteSequence)bytes$iv, Wrapper.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
            $receiver = (Wrapper)object;
            AssertionsKt.assertEquals$default((Object)"Ho ho ho", (Object)((InnerC)$receiver.getC().getB()).getA_c(), null, (int)4, null);
        }
    }

    @Test(timeout=300000L)
    public final void nestedSerializationWhereGenericDoesntImpactFingerprint() {
        Object object;
        SerializedBytes bytes$iv;
        DeserializationInput $receiver$iv;
        SerializationContext context$iv;
        Integer n;
        SerializerFactory it;
        SerializedBytes serializedBytes;
        Object[] objectArray = new SerializerFactory[2];
        ClassWhitelist classWhitelist = (ClassWhitelist)AllWhitelist.INSTANCE;
        ClassWhitelist classWhitelist2 = (ClassWhitelist)AllWhitelist.INSTANCE;
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        Intrinsics.checkExpressionValueIsNotNull((Object)classLoader, (String)"ClassLoader.getSystemClassLoader()");
        objectArray[0] = SerializerFactoryBuilder.build((ClassWhitelist)classWhitelist, (ClassCarpenter)((ClassCarpenter)new ClassCarpenterImpl(classWhitelist2, classLoader, false, 4, null)));
        ClassWhitelist classWhitelist3 = (ClassWhitelist)AllWhitelist.INSTANCE;
        ClassWhitelist classWhitelist4 = (ClassWhitelist)AllWhitelist.INSTANCE;
        ClassLoader classLoader2 = ClassLoader.getSystemClassLoader();
        Intrinsics.checkExpressionValueIsNotNull((Object)classLoader2, (String)"ClassLoader.getSystemClassLoader()");
        objectArray[1] = SerializerFactoryBuilder.build((ClassWhitelist)classWhitelist3, (ClassCarpenter)((ClassCarpenter)new ClassCarpenterImpl(classWhitelist4, classLoader2, false, 4, null)));
        List factorys = CollectionsKt.listOf((Object[])objectArray);
        SerializationOutput ser = new SerializationOutput((LocalSerializerFactory)factorys.get(0));
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0002\u0000\u0004\b\u008a\b\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005J\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0007J$\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"net/corda/serialization/internal/amqp/GenericsTests$nestedSerializationWhereGenericDoesntImpactFingerprint$Wrapper", "T", "", "c", "net/corda/serialization/internal/amqp/GenericsTests$nestedSerializationWhereGenericDoesntImpactFingerprint$Container", "(Lnet/corda/serialization/internal/amqp/GenericsTests$nestedSerializationWhereGenericDoesntImpactFingerprint$Container;)V", "getC", "()Lnet/corda/serialization/internal/amqp/GenericsTests$nestedSerializationWhereGenericDoesntImpactFingerprint$Container;", "Lnet/corda/serialization/internal/amqp/GenericsTests$nestedSerializationWhereGenericDoesntImpactFingerprint$Container;", "component1", "copy", "(Lnet/corda/serialization/internal/amqp/GenericsTests$nestedSerializationWhereGenericDoesntImpactFingerprint$Container;)Lnet/corda/serialization/internal/amqp/GenericsTests$nestedSerializationWhereGenericDoesntImpactFingerprint$Wrapper;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
        public final class Wrapper<T> {
            @NotNull
            private final Container<T> c;

            @NotNull
            public final Container<T> getC() {
                @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0002\u0000\u0004\b\u008a\b\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\t\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0013\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"net/corda/serialization/internal/amqp/GenericsTests$nestedSerializationWhereGenericDoesntImpactFingerprint$Container", "T", "", "b", "net/corda/serialization/internal/amqp/GenericsTests$nestedSerializationWhereGenericDoesntImpactFingerprint$Inner", "(Lnet/corda/serialization/internal/amqp/GenericsTests$nestedSerializationWhereGenericDoesntImpactFingerprint$Inner;)V", "getB", "()Lnet/corda/serialization/internal/amqp/GenericsTests$nestedSerializationWhereGenericDoesntImpactFingerprint$Inner;", "Lnet/corda/serialization/internal/amqp/GenericsTests$nestedSerializationWhereGenericDoesntImpactFingerprint$Inner;", "component1", "copy", "(Lnet/corda/serialization/internal/amqp/GenericsTests$nestedSerializationWhereGenericDoesntImpactFingerprint$Inner;)Lnet/corda/serialization/internal/amqp/GenericsTests$nestedSerializationWhereGenericDoesntImpactFingerprint$Container;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
                public final class Container<T> {
                    @NotNull
                    private final Inner b;

                    @NotNull
                    public final Inner getB() {
                        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000!\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0018\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"net/corda/serialization/internal/amqp/GenericsTests$nestedSerializationWhereGenericDoesntImpactFingerprint$Inner", "", "a", "", "(I)V", "getA", "()I", "component1", "copy", "(I)Lnet/corda/serialization/internal/amqp/GenericsTests$nestedSerializationWhereGenericDoesntImpactFingerprint$Inner;", "equals", "", "other", "hashCode", "toString", "", "serialization"})
                        public final class Inner {
                            private final int a;

                            public final int getA() {
                                return this.a;
                            }

                            public Inner(int a) {
                                this.a = a;
                            }

                            public final int component1() {
                                return this.a;
                            }

                            @NotNull
                            public final Inner copy(int a) {
                                return new Inner(a);
                            }

                            @NotNull
                            public static /* bridge */ /* synthetic */ Inner copy$default(Inner inner, int n, int n2, Object object) {
                                if ((n2 & 1) != 0) {
                                    n = inner.a;
                                }
                                return inner.copy(n);
                            }

                            @NotNull
                            public String toString() {
                                return "Inner(a=" + this.a + ")";
                            }

                            public int hashCode() {
                                return Integer.hashCode(this.a);
                            }

                            public boolean equals(@Nullable Object object) {
                                block3: {
                                    block2: {
                                        if (this == object) break block2;
                                        if (!(object instanceof Inner)) break block3;
                                        Inner inner = (Inner)object;
                                        if (!(this.a == inner.a)) break block3;
                                    }
                                    return true;
                                }
                                return false;
                            }
                        }
                        return this.b;
                    }

                    public Container(@NotNull Inner b) {
                        Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
                        this.b = b;
                    }

                    @NotNull
                    public final Inner component1() {
                        return this.b;
                    }

                    @NotNull
                    public final Container<T> copy(@NotNull Inner b) {
                        Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
                        return new Container<T>(b);
                    }

                    @NotNull
                    public static /* bridge */ /* synthetic */ Container copy$default(Container container, Inner inner, int n, Object object) {
                        if ((n & 1) != 0) {
                            inner = container.b;
                        }
                        return container.copy(inner);
                    }

                    @NotNull
                    public String toString() {
                        return "Container(b=" + this.b + ")";
                    }

                    public int hashCode() {
                        Inner inner = this.b;
                        return inner != null ? ((Object)inner).hashCode() : 0;
                    }

                    public boolean equals(@Nullable Object object) {
                        block3: {
                            block2: {
                                if (this == object) break block2;
                                if (!(object instanceof Container)) break block3;
                                Container container = (Container)object;
                                if (!Intrinsics.areEqual((Object)this.b, (Object)container.b)) break block3;
                            }
                            return true;
                        }
                        return false;
                    }
                }
                return this.c;
            }

            public Wrapper(@NotNull Container<T> c) {
                Intrinsics.checkParameterIsNotNull(c, (String)"c");
                this.c = c;
            }

            @NotNull
            public final Container<T> component1() {
                return this.c;
            }

            @NotNull
            public final Wrapper<T> copy(@NotNull Container<T> c) {
                Intrinsics.checkParameterIsNotNull(c, (String)"c");
                return new Wrapper<T>(c);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ Wrapper copy$default(Wrapper wrapper, Container container, int n, Object object) {
                if ((n & 1) != 0) {
                    container = wrapper.c;
                }
                return wrapper.copy(container);
            }

            @NotNull
            public String toString() {
                return "Wrapper(c=" + this.c + ")";
            }

            public int hashCode() {
                Container<T> container = this.c;
                return container != null ? ((Object)container).hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Wrapper)) break block3;
                        Wrapper wrapper = (Wrapper)object;
                        if (!Intrinsics.areEqual(this.c, wrapper.c)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        SerializedBytes $receiver = serializedBytes = AMQPTestUtilsKt.serialize$default(ser, new Wrapper(new Container(new Inner(1))), null, 2, null);
        Iterable $receiver$iv2 = factorys;
        for (Object element$iv : $receiver$iv2) {
            it = (SerializerFactory)element$iv;
            DeserializationInput deserializationInput = new DeserializationInput(it);
            SerializedBytes serializedBytes2 = $receiver;
            n = 1;
            context$iv = null;
            object = $receiver$iv.deserialize((ByteSequence)bytes$iv, Wrapper.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
            AssertionsKt.assertEquals$default((Object)n, (Object)((Wrapper)object).getC().getB().getA(), null, (int)4, null);
        }
        $receiver = serializedBytes = AMQPTestUtilsKt.serialize$default(ser, new Wrapper(new Container(new Inner(1))), null, 2, null);
        $receiver$iv2 = factorys;
        for (Object element$iv : $receiver$iv2) {
            it = (SerializerFactory)element$iv;
            $receiver$iv = new DeserializationInput(it);
            bytes$iv = $receiver;
            n = 1;
            context$iv = null;
            object = $receiver$iv.deserialize((ByteSequence)bytes$iv, Wrapper.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
            AssertionsKt.assertEquals$default((Object)n, (Object)((Wrapper)object).getC().getB().getA(), null, (int)4, null);
        }
    }

    private final SerializedBytes<?> forceWildcardSerialize(ForceWildcard<?> a, SerializerFactory factory) {
        BytesAndSchemas bytes = AMQPTestUtilsKt.serializeAndReturnSchema$default(new SerializationOutput((LocalSerializerFactory)factory), a, null, 2, null);
        this.printSchema(bytes);
        return bytes.getObj();
    }

    static /* bridge */ /* synthetic */ SerializedBytes forceWildcardSerialize$default(GenericsTests genericsTests, ForceWildcard forceWildcard, SerializerFactory serializerFactory, int n, Object object) {
        if ((n & 2) != 0) {
            ClassWhitelist classWhitelist = (ClassWhitelist)AllWhitelist.INSTANCE;
            ClassWhitelist classWhitelist2 = (ClassWhitelist)AllWhitelist.INSTANCE;
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            Intrinsics.checkExpressionValueIsNotNull((Object)classLoader, (String)"ClassLoader.getSystemClassLoader()");
            serializerFactory = SerializerFactoryBuilder.build((ClassWhitelist)classWhitelist, (ClassCarpenter)((ClassCarpenter)new ClassCarpenterImpl(classWhitelist2, classLoader, false, 4, null)));
        }
        return genericsTests.forceWildcardSerialize(forceWildcard, serializerFactory);
    }

    /*
     * WARNING - void declaration
     */
    private final void forceWildcardDeserializeString(SerializedBytes<?> bytes, SerializerFactory factory) {
        void $receiver$iv;
        DeserializationInput deserializationInput = new DeserializationInput(factory);
        SerializedBytes<?> serializedBytes = bytes;
        if (serializedBytes == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.corda.core.serialization.SerializedBytes<net.corda.serialization.internal.amqp.GenericsTests.ForceWildcard<kotlin.String>>");
        }
        SerializedBytes<?> bytes$iv = serializedBytes;
        SerializationContext context$iv = null;
        $receiver$iv.deserialize((ByteSequence)bytes$iv, ForceWildcard.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
    }

    static /* bridge */ /* synthetic */ void forceWildcardDeserializeString$default(GenericsTests genericsTests, SerializedBytes serializedBytes, SerializerFactory serializerFactory, int n, Object object) {
        if ((n & 2) != 0) {
            ClassWhitelist classWhitelist = (ClassWhitelist)AllWhitelist.INSTANCE;
            ClassWhitelist classWhitelist2 = (ClassWhitelist)AllWhitelist.INSTANCE;
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            Intrinsics.checkExpressionValueIsNotNull((Object)classLoader, (String)"ClassLoader.getSystemClassLoader()");
            serializerFactory = SerializerFactoryBuilder.build((ClassWhitelist)classWhitelist, (ClassCarpenter)((ClassCarpenter)new ClassCarpenterImpl(classWhitelist2, classLoader, false, 4, null)));
        }
        genericsTests.forceWildcardDeserializeString(serializedBytes, serializerFactory);
    }

    /*
     * WARNING - void declaration
     */
    private final void forceWildcardDeserializeDouble(SerializedBytes<?> bytes, SerializerFactory factory) {
        void $receiver$iv;
        DeserializationInput deserializationInput = new DeserializationInput(factory);
        SerializedBytes<?> serializedBytes = bytes;
        if (serializedBytes == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.corda.core.serialization.SerializedBytes<net.corda.serialization.internal.amqp.GenericsTests.ForceWildcard<kotlin.Double>>");
        }
        SerializedBytes<?> bytes$iv = serializedBytes;
        SerializationContext context$iv = null;
        $receiver$iv.deserialize((ByteSequence)bytes$iv, ForceWildcard.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
    }

    static /* bridge */ /* synthetic */ void forceWildcardDeserializeDouble$default(GenericsTests genericsTests, SerializedBytes serializedBytes, SerializerFactory serializerFactory, int n, Object object) {
        if ((n & 2) != 0) {
            ClassWhitelist classWhitelist = (ClassWhitelist)AllWhitelist.INSTANCE;
            ClassWhitelist classWhitelist2 = (ClassWhitelist)AllWhitelist.INSTANCE;
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            Intrinsics.checkExpressionValueIsNotNull((Object)classLoader, (String)"ClassLoader.getSystemClassLoader()");
            serializerFactory = SerializerFactoryBuilder.build((ClassWhitelist)classWhitelist, (ClassCarpenter)((ClassCarpenter)new ClassCarpenterImpl(classWhitelist2, classLoader, false, 4, null)));
        }
        genericsTests.forceWildcardDeserializeDouble(serializedBytes, serializerFactory);
    }

    /*
     * WARNING - void declaration
     */
    private final void forceWildcardDeserialize(SerializedBytes<?> bytes, SerializerFactory factory) {
        void $receiver$iv;
        DeserializationInput deserializationInput = new DeserializationInput(factory);
        SerializedBytes<?> serializedBytes = bytes;
        if (serializedBytes == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.corda.core.serialization.SerializedBytes<net.corda.serialization.internal.amqp.GenericsTests.ForceWildcard<*>>");
        }
        SerializedBytes<?> bytes$iv = serializedBytes;
        SerializationContext context$iv = null;
        $receiver$iv.deserialize((ByteSequence)bytes$iv, ForceWildcard.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
    }

    static /* bridge */ /* synthetic */ void forceWildcardDeserialize$default(GenericsTests genericsTests, SerializedBytes serializedBytes, SerializerFactory serializerFactory, int n, Object object) {
        if ((n & 2) != 0) {
            ClassWhitelist classWhitelist = (ClassWhitelist)AllWhitelist.INSTANCE;
            ClassWhitelist classWhitelist2 = (ClassWhitelist)AllWhitelist.INSTANCE;
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            Intrinsics.checkExpressionValueIsNotNull((Object)classLoader, (String)"ClassLoader.getSystemClassLoader()");
            serializerFactory = SerializerFactoryBuilder.build((ClassWhitelist)classWhitelist, (ClassCarpenter)((ClassCarpenter)new ClassCarpenterImpl(classWhitelist2, classLoader, false, 4, null)));
        }
        genericsTests.forceWildcardDeserialize(serializedBytes, serializerFactory);
    }

    @Test(timeout=300000L)
    public final void forceWildcard() {
        GenericsTests.forceWildcardDeserializeString$default(this, GenericsTests.forceWildcardSerialize$default(this, new ForceWildcard<String>("hello"), null, 2, null), null, 2, null);
        GenericsTests.forceWildcardDeserializeDouble$default(this, GenericsTests.forceWildcardSerialize$default(this, new ForceWildcard<Double>(3.0), null, 2, null), null, 2, null);
    }

    @Test(timeout=300000L)
    public final void forceWildcardSharedFactory() {
        ClassWhitelist classWhitelist = (ClassWhitelist)AllWhitelist.INSTANCE;
        ClassWhitelist classWhitelist2 = (ClassWhitelist)AllWhitelist.INSTANCE;
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        Intrinsics.checkExpressionValueIsNotNull((Object)classLoader, (String)"ClassLoader.getSystemClassLoader()");
        SerializerFactory f = SerializerFactoryBuilder.build((ClassWhitelist)classWhitelist, (ClassCarpenter)((ClassCarpenter)new ClassCarpenterImpl(classWhitelist2, classLoader, false, 4, null)));
        this.forceWildcardDeserializeString(this.forceWildcardSerialize(new ForceWildcard<String>("hello"), f), f);
        this.forceWildcardDeserializeDouble(this.forceWildcardSerialize(new ForceWildcard<Double>(3.0), f), f);
    }

    @Test(timeout=300000L)
    public final void forceWildcardDeserialize() {
        GenericsTests.forceWildcardDeserialize$default(this, GenericsTests.forceWildcardSerialize$default(this, new ForceWildcard<String>("hello"), null, 2, null), null, 2, null);
        GenericsTests.forceWildcardDeserialize$default(this, GenericsTests.forceWildcardSerialize$default(this, new ForceWildcard<Integer>(10), null, 2, null), null, 2, null);
        GenericsTests.forceWildcardDeserialize$default(this, GenericsTests.forceWildcardSerialize$default(this, new ForceWildcard<Double>(20.0), null, 2, null), null, 2, null);
    }

    @Test(timeout=300000L)
    public final void forceWildcardDeserializeSharedFactory() {
        ClassWhitelist classWhitelist = (ClassWhitelist)AllWhitelist.INSTANCE;
        ClassWhitelist classWhitelist2 = (ClassWhitelist)AllWhitelist.INSTANCE;
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        Intrinsics.checkExpressionValueIsNotNull((Object)classLoader, (String)"ClassLoader.getSystemClassLoader()");
        SerializerFactory f = SerializerFactoryBuilder.build((ClassWhitelist)classWhitelist, (ClassCarpenter)((ClassCarpenter)new ClassCarpenterImpl(classWhitelist2, classLoader, false, 4, null)));
        this.forceWildcardDeserialize(this.forceWildcardSerialize(new ForceWildcard<String>("hello"), f), f);
        this.forceWildcardDeserialize(this.forceWildcardSerialize(new ForceWildcard<Integer>(10), f), f);
        this.forceWildcardDeserialize(this.forceWildcardSerialize(new ForceWildcard<Double>(20.0), f), f);
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void loadGenericFromFile() {
        void bytes$iv;
        void $receiver$iv;
        String resource = this.getClass().getSimpleName() + '.' + AMQPTestUtilsKt.testName();
        SerializerFactory sf = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        DeserializationInput deserializationInput = new DeserializationInput(sf);
        URL uRL = GenericsTests.class.getResource(resource);
        Intrinsics.checkExpressionValueIsNotNull((Object)uRL, (String)"GenericsTests::class.java.getResource(resource)");
        SerializedBytes serializedBytes = new SerializedBytes(TextStreamsKt.readBytes((URL)uRL));
        String string = "wibble";
        SerializationContext context$iv = null;
        Object object = $receiver$iv.deserialize((ByteSequence)bytes$iv, ForceWildcard.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)string, ((ForceWildcard)object).getT(), null, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void fingerprintingDiffersStrip(Object state) {
        void $receiver$iv;
        void $receiver$iv2;
        Method m;
        Method method = m = ClassLoader.class.getDeclaredMethod("findLoadedClass", String.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)method, (String)"m");
        method.setAccessible(true);
        SerializerFactory factory1 = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        factory1.register((CustomSerializer)PublicKeySerializer.INSTANCE);
        BytesAndSchemas ser1 = AMQPTestUtilsKt.serializeAndReturnSchema$default(new TestSerializationOutput(true, factory1), state, null, 2, null);
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"net/corda/serialization/internal/amqp/GenericsTests$fingerprintingDiffersStrip$cl", "Ljava/lang/ClassLoader;", "()V", "serialization"})
        public final class Cl
        extends ClassLoader {
            public Cl() {
            }
        }
        Cl altClassLoader = new Cl();
        SerializerFactory factory2 = SerializerFactoryBuilder.build((ClassWhitelist)((ClassWhitelist)AllWhitelist.INSTANCE), (ClassCarpenter)((ClassCarpenter)new ClassCarpenterImpl((ClassWhitelist)AllWhitelist.INSTANCE, (ClassLoader)altClassLoader, false, 4, null)));
        factory2.register((CustomSerializer)PublicKeySerializer.INSTANCE);
        BytesAndSchemas ser2 = AMQPTestUtilsKt.serializeAndReturnSchema$default(new TestSerializationOutput(true, factory2), state, null, 2, null);
        SerializerFactory factory3 = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        factory3.register((CustomSerializer)PublicKeySerializer.INSTANCE);
        DeserializationInput deserializationInput = new DeserializationInput(factory3);
        SerializedBytes bytes$iv = ser1.getObj();
        SerializationContext context$iv = null;
        $receiver$iv2.deserializeAndReturnEnvelope(bytes$iv, Object.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        SerializerFactory factory4 = SerializerFactoryBuilder.build((ClassWhitelist)((ClassWhitelist)AllWhitelist.INSTANCE), (ClassCarpenter)((ClassCarpenter)new ClassCarpenterImpl((ClassWhitelist)AllWhitelist.INSTANCE, (ClassLoader)new Cl(), false, 4, null)));
        factory4.register((CustomSerializer)PublicKeySerializer.INSTANCE);
        bytes$iv = new DeserializationInput(factory4);
        SerializedBytes bytes$iv2 = ser2.getObj();
        SerializationContext context$iv2 = null;
        $receiver$iv.deserializeAndReturnEnvelope(bytes$iv2, Object.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
    }

    @Test(timeout=300000L)
    public final void fingerprintingDiffers() {
        TransactionState state = new TransactionState((ContractState)new TestContractState(CollectionsKt.listOf((Object)MINI_CORP_PARTY)), "wibble", MINI_CORP_PARTY, null, (AttachmentConstraint)new TestAttachmentConstraint());
        StateAndString sas = new StateAndString(state, "wibble");
        this.fingerprintingDiffersStrip(sas);
    }

    @Test(timeout=300000L)
    public final void fingerprintingDiffersList() {
        TransactionState state = new TransactionState((ContractState)new TestContractState(CollectionsKt.listOf((Object)MINI_CORP_PARTY)), "wibble", MINI_CORP_PARTY, null, (AttachmentConstraint)new TestAttachmentConstraint());
        StateAndString sas = new StateAndString(state, "wibble");
        List<StateAndString> list = Collections.singletonList(sas);
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"Collections.singletonList(sas)");
        this.fingerprintingDiffersStrip(list);
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void fingerprintingDiffersListLoaded() {
        void $receiver$iv;
        TransactionState state = new TransactionState((ContractState)new TestContractState(CollectionsKt.listOf((Object)MINI_CORP_PARTY)), "wibble", MINI_CORP_PARTY, null, (AttachmentConstraint)new TestAttachmentConstraint());
        GenericStateAndString sas = new GenericStateAndString(state, "wibble");
        SerializerFactory factory1 = AMQPTestUtilsKt.testDefaultFactoryNoEvolution$default(null, 1, null);
        SerializerFactory factory2 = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        factory1.register((CustomSerializer)PublicKeySerializer.INSTANCE);
        factory2.register((CustomSerializer)PublicKeySerializer.INSTANCE);
        SerializationOutput serializationOutput = new TestSerializationOutput(true, factory1);
        List list = Collections.singletonList(sas);
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"Collections.singletonList(sas)");
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0003B\u0019\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u0005H\u00c6\u0003J*\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\fJ\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u001d\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"net/corda/serialization/internal/amqp/GenericsTests$fingerprintingDiffersListLoaded$TransactionStateWrapper", "T", "Lnet/corda/core/contracts/ContractState;", "", "o", "", "Lnet/corda/serialization/internal/amqp/GenericsTests$GenericStateAndString;", "(Ljava/util/List;)V", "getO", "()Ljava/util/List;", "component1", "copy", "(Ljava/util/List;)Lnet/corda/serialization/internal/amqp/GenericsTests$fingerprintingDiffersListLoaded$TransactionStateWrapper;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
        public final class TransactionStateWrapper<T extends ContractState> {
            @NotNull
            private final List<GenericStateAndString<T>> o;

            @NotNull
            public final List<GenericStateAndString<T>> getO() {
                return this.o;
            }

            public TransactionStateWrapper(@NotNull List<? extends GenericStateAndString<? extends T>> o) {
                Intrinsics.checkParameterIsNotNull(o, (String)"o");
                this.o = o;
            }

            @NotNull
            public final List<GenericStateAndString<T>> component1() {
                return this.o;
            }

            @NotNull
            public final TransactionStateWrapper<T> copy(@NotNull List<? extends GenericStateAndString<? extends T>> o) {
                Intrinsics.checkParameterIsNotNull(o, (String)"o");
                return new TransactionStateWrapper<T>(o);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ TransactionStateWrapper copy$default(TransactionStateWrapper transactionStateWrapper, List list, int n, Object object) {
                if ((n & 1) != 0) {
                    list = transactionStateWrapper.o;
                }
                return transactionStateWrapper.copy(list);
            }

            @NotNull
            public String toString() {
                return "TransactionStateWrapper(o=" + this.o + ")";
            }

            public int hashCode() {
                List<GenericStateAndString<T>> list = this.o;
                return list != null ? ((Object)list).hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof TransactionStateWrapper)) break block3;
                        TransactionStateWrapper transactionStateWrapper = (TransactionStateWrapper)object;
                        if (!Intrinsics.areEqual(this.o, transactionStateWrapper.o)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        BytesAndSchemas ser1 = AMQPTestUtilsKt.serializeAndReturnSchema$default(serializationOutput, new TransactionStateWrapper(list), null, 2, null);
        DeserializationInput deserializationInput = new DeserializationInput(factory2);
        SerializedBytes bytes$iv = ser1.getObj();
        SerializationContext context$iv = null;
        ObjectAndEnvelope des1 = $receiver$iv.deserializeAndReturnEnvelope(bytes$iv, TransactionStateWrapper.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        String string = sas.getRef();
        Object object = (GenericStateAndString)CollectionsKt.firstOrNull(((TransactionStateWrapper)des1.getObj()).getO());
        if (object == null || (object = ((GenericStateAndString)object).getRef()) == null) {
            object = "WILL NOT MATCH";
        }
        AssertionsKt.assertEquals$default((Object)string, (Object)object, null, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void nestedGenericsWithBound() {
        void $receiver$iv;
        SerializerFactory factory1 = AMQPTestUtilsKt.testDefaultFactoryNoEvolution$default(null, 1, null);
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0013\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004*\u0001\u0000\b\u001a\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"net/corda/serialization/internal/amqp/GenericsTests$nestedGenericsWithBound$BaseState", "", "a", "", "(I)V", "getA", "()I", "serialization"})
        public class BaseState {
            private final int a;

            public final int getA() {
                return this.a;
            }

            public BaseState(int a) {
                this.a = a;
            }
        }
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\b\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0002\u0000\u0002\b\u008a\b\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\t\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0004\u001a\u00028\u0000H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"net/corda/serialization/internal/amqp/GenericsTests$nestedGenericsWithBound$LTransactionState", "T", "net/corda/serialization/internal/amqp/GenericsTests$nestedGenericsWithBound$BaseState", "", "data", "(Lnet/corda/serialization/internal/amqp/GenericsTests$nestedGenericsWithBound$BaseState;)V", "getData", "()Lnet/corda/serialization/internal/amqp/GenericsTests$nestedGenericsWithBound$BaseState;", "Lnet/corda/serialization/internal/amqp/GenericsTests$nestedGenericsWithBound$BaseState;", "component1", "copy", "(Lnet/corda/serialization/internal/amqp/GenericsTests$nestedGenericsWithBound$BaseState;)Lnet/corda/serialization/internal/amqp/GenericsTests$nestedGenericsWithBound$LTransactionState;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
        public final class LTransactionState<T extends BaseState> {
            @NotNull
            private final T data;

            @NotNull
            public final T getData() {
                return this.data;
            }

            public LTransactionState(@NotNull T data) {
                Intrinsics.checkParameterIsNotNull(data, (String)"data");
                this.data = data;
            }

            @NotNull
            public final T component1() {
                return this.data;
            }

            @NotNull
            public final LTransactionState<T> copy(@NotNull T data) {
                Intrinsics.checkParameterIsNotNull(data, (String)"data");
                return new LTransactionState<T>(data);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ LTransactionState copy$default(LTransactionState lTransactionState, BaseState baseState, int n, Object object) {
                if ((n & 1) != 0) {
                    baseState = lTransactionState.data;
                }
                return lTransactionState.copy(baseState);
            }

            @NotNull
            public String toString() {
                return "LTransactionState(data=" + this.data + ")";
            }

            public int hashCode() {
                T t = this.data;
                return t != null ? t.hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof LTransactionState)) break block3;
                        LTransactionState lTransactionState = (LTransactionState)object;
                        if (!Intrinsics.areEqual(this.data, lTransactionState.data)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002*\u0002\u0000\u0001\b\n\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"net/corda/serialization/internal/amqp/GenericsTests$nestedGenericsWithBound$DState", "net/corda/serialization/internal/amqp/GenericsTests$nestedGenericsWithBound$BaseState", "a", "", "(I)V", "serialization"})
        public final class DState
        extends BaseState {
            public DState(int a) {
                super(a);
            }
        }
        LTransactionState<BaseState> state = new LTransactionState<BaseState>(new DState(1020304));
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000)\n\u0002\b\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0003\u0000\u0002\u0005\b\u008a\b\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0003B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\bJ$\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\fJ\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"net/corda/serialization/internal/amqp/GenericsTests$nestedGenericsWithBound$StateWrapper", "T", "net/corda/serialization/internal/amqp/GenericsTests$nestedGenericsWithBound$BaseState", "", "state", "net/corda/serialization/internal/amqp/GenericsTests$nestedGenericsWithBound$LTransactionState", "(Lnet/corda/serialization/internal/amqp/GenericsTests$nestedGenericsWithBound$LTransactionState;)V", "getState", "()Lnet/corda/serialization/internal/amqp/GenericsTests$nestedGenericsWithBound$LTransactionState;", "Lnet/corda/serialization/internal/amqp/GenericsTests$nestedGenericsWithBound$LTransactionState;", "component1", "copy", "(Lnet/corda/serialization/internal/amqp/GenericsTests$nestedGenericsWithBound$LTransactionState;)Lnet/corda/serialization/internal/amqp/GenericsTests$nestedGenericsWithBound$StateWrapper;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
        public final class StateWrapper<T extends BaseState> {
            @NotNull
            private final LTransactionState<T> state;

            @NotNull
            public final LTransactionState<T> getState() {
                return this.state;
            }

            public StateWrapper(@NotNull LTransactionState<? extends T> state) {
                Intrinsics.checkParameterIsNotNull(state, (String)"state");
                this.state = state;
            }

            @NotNull
            public final LTransactionState<T> component1() {
                return this.state;
            }

            @NotNull
            public final StateWrapper<T> copy(@NotNull LTransactionState<? extends T> state) {
                Intrinsics.checkParameterIsNotNull(state, (String)"state");
                return new StateWrapper<T>(state);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ StateWrapper copy$default(StateWrapper stateWrapper, LTransactionState lTransactionState, int n, Object object) {
                if ((n & 1) != 0) {
                    lTransactionState = stateWrapper.state;
                }
                return stateWrapper.copy(lTransactionState);
            }

            @NotNull
            public String toString() {
                return "StateWrapper(state=" + this.state + ")";
            }

            public int hashCode() {
                LTransactionState<T> lTransactionState = this.state;
                return lTransactionState != null ? ((Object)lTransactionState).hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof StateWrapper)) break block3;
                        StateWrapper stateWrapper = (StateWrapper)object;
                        if (!Intrinsics.areEqual(this.state, stateWrapper.state)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        StateWrapper<BaseState> stateAndString = new StateWrapper<BaseState>(state);
        BytesAndSchemas ser1 = AMQPTestUtilsKt.serializeAndReturnSchema$default(new TestSerializationOutput(true, factory1), stateAndString, null, 2, null);
        SerializerFactory factory2 = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        DeserializationInput deserializationInput = new DeserializationInput(factory2);
        SerializedBytes bytes$iv = ser1.getObj();
        SerializationContext context$iv = null;
        ObjectAndEnvelope des1 = $receiver$iv.deserializeAndReturnEnvelope(bytes$iv, StateWrapper.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)((DState)state.getData()).getA(), (Object)((DState)((StateWrapper)des1.getObj()).getState().getData()).getA(), null, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void nestedMultiGenericsWithBound() {
        void $receiver$iv;
        SerializerFactory factory1 = AMQPTestUtilsKt.testDefaultFactoryNoEvolution$default(null, 1, null);
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0013\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004*\u0001\u0000\b\u001a\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"net/corda/serialization/internal/amqp/GenericsTests$nestedMultiGenericsWithBound$BaseState", "", "a", "", "(I)V", "getA", "()I", "serialization"})
        public class BaseState {
            private final int a;

            public final int getA() {
                return this.a;
            }

            public BaseState(int a) {
                this.a = a;
            }
        }
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\b\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0002\u0000\u0002\b\u008a\b\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u0002*\n\b\u0001\u0010\u0003 \u0001*\u00020\u00022\u00020\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u0012\u0006\u0010\u0006\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\f\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\r\u001a\u00028\u0001H\u00c6\u0003\u00a2\u0006\u0002\u0010\tJ.\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0005\u001a\u00028\u00002\b\b\u0002\u0010\u0006\u001a\u00028\u0001H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0004H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0013\u0010\u0006\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0017"}, d2={"net/corda/serialization/internal/amqp/GenericsTests$nestedMultiGenericsWithBound$LTransactionState", "T1", "net/corda/serialization/internal/amqp/GenericsTests$nestedMultiGenericsWithBound$BaseState", "T2", "", "data", "context", "(Lnet/corda/serialization/internal/amqp/GenericsTests$nestedMultiGenericsWithBound$BaseState;Lnet/corda/serialization/internal/amqp/GenericsTests$nestedMultiGenericsWithBound$BaseState;)V", "getContext", "()Lnet/corda/serialization/internal/amqp/GenericsTests$nestedMultiGenericsWithBound$BaseState;", "Lnet/corda/serialization/internal/amqp/GenericsTests$nestedMultiGenericsWithBound$BaseState;", "getData", "component1", "component2", "copy", "(Lnet/corda/serialization/internal/amqp/GenericsTests$nestedMultiGenericsWithBound$BaseState;Lnet/corda/serialization/internal/amqp/GenericsTests$nestedMultiGenericsWithBound$BaseState;)Lnet/corda/serialization/internal/amqp/GenericsTests$nestedMultiGenericsWithBound$LTransactionState;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
        public final class LTransactionState<T1 extends BaseState, T2 extends BaseState> {
            @NotNull
            private final T1 data;
            @NotNull
            private final T2 context;

            @NotNull
            public final T1 getData() {
                return this.data;
            }

            @NotNull
            public final T2 getContext() {
                return this.context;
            }

            public LTransactionState(@NotNull T1 data, @NotNull T2 context) {
                Intrinsics.checkParameterIsNotNull(data, (String)"data");
                Intrinsics.checkParameterIsNotNull(context, (String)"context");
                this.data = data;
                this.context = context;
            }

            @NotNull
            public final T1 component1() {
                return this.data;
            }

            @NotNull
            public final T2 component2() {
                return this.context;
            }

            @NotNull
            public final LTransactionState<T1, T2> copy(@NotNull T1 data, @NotNull T2 context) {
                Intrinsics.checkParameterIsNotNull(data, (String)"data");
                Intrinsics.checkParameterIsNotNull(context, (String)"context");
                return new LTransactionState<T1, T2>(data, context);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ LTransactionState copy$default(LTransactionState lTransactionState, BaseState baseState, BaseState baseState2, int n, Object object) {
                if ((n & 1) != 0) {
                    baseState = lTransactionState.data;
                }
                if ((n & 2) != 0) {
                    baseState2 = lTransactionState.context;
                }
                return lTransactionState.copy(baseState, baseState2);
            }

            @NotNull
            public String toString() {
                return "LTransactionState(data=" + this.data + ", context=" + this.context + ")";
            }

            public int hashCode() {
                T1 T1 = this.data;
                T2 T2 = this.context;
                return (T1 != null ? T1.hashCode() : 0) * 31 + (T2 != null ? T2.hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof LTransactionState)) break block3;
                        LTransactionState lTransactionState = (LTransactionState)object;
                        if (!Intrinsics.areEqual(this.data, lTransactionState.data) || !Intrinsics.areEqual(this.context, lTransactionState.context)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002*\u0002\u0000\u0001\b\n\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"net/corda/serialization/internal/amqp/GenericsTests$nestedMultiGenericsWithBound$DState", "net/corda/serialization/internal/amqp/GenericsTests$nestedMultiGenericsWithBound$BaseState", "a", "", "(I)V", "serialization"})
        public final class DState
        extends BaseState {
            public DState(int a) {
                super(a);
            }
        }
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004*\u0002\u0000\u0001\b\n\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"net/corda/serialization/internal/amqp/GenericsTests$nestedMultiGenericsWithBound$EState", "net/corda/serialization/internal/amqp/GenericsTests$nestedMultiGenericsWithBound$BaseState", "a", "", "msg", "", "(ILjava/lang/String;)V", "getMsg", "()Ljava/lang/String;", "serialization"})
        public final class EState
        extends BaseState {
            @NotNull
            private final String msg;

            @NotNull
            public final String getMsg() {
                return this.msg;
            }

            public EState(int a, @NotNull String msg) {
                Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
                super(a);
                this.msg = msg;
            }
        }
        LTransactionState<BaseState, BaseState> state = new LTransactionState<BaseState, BaseState>(new DState(1020304), new EState(5060708, "thigns"));
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000+\n\u0002\b\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0003\u0000\u0002\u0006\b\u008a\b\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u0002*\n\b\u0001\u0010\u0003 \u0001*\u00020\u00022\u00020\u0004B\u0019\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006H\u00c6\u0003\u00a2\u0006\u0002\u0010\tJ0\u0010\f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006H\u00c6\u0001\u00a2\u0006\u0002\u0010\rJ\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u001f\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"net/corda/serialization/internal/amqp/GenericsTests$nestedMultiGenericsWithBound$StateWrapper", "T1", "net/corda/serialization/internal/amqp/GenericsTests$nestedMultiGenericsWithBound$BaseState", "T2", "", "state", "net/corda/serialization/internal/amqp/GenericsTests$nestedMultiGenericsWithBound$LTransactionState", "(Lnet/corda/serialization/internal/amqp/GenericsTests$nestedMultiGenericsWithBound$LTransactionState;)V", "getState", "()Lnet/corda/serialization/internal/amqp/GenericsTests$nestedMultiGenericsWithBound$LTransactionState;", "Lnet/corda/serialization/internal/amqp/GenericsTests$nestedMultiGenericsWithBound$LTransactionState;", "component1", "copy", "(Lnet/corda/serialization/internal/amqp/GenericsTests$nestedMultiGenericsWithBound$LTransactionState;)Lnet/corda/serialization/internal/amqp/GenericsTests$nestedMultiGenericsWithBound$StateWrapper;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
        public final class StateWrapper<T1 extends BaseState, T2 extends BaseState> {
            @NotNull
            private final LTransactionState<T1, T2> state;

            @NotNull
            public final LTransactionState<T1, T2> getState() {
                return this.state;
            }

            public StateWrapper(@NotNull LTransactionState<? extends T1, ? extends T2> state) {
                Intrinsics.checkParameterIsNotNull(state, (String)"state");
                this.state = state;
            }

            @NotNull
            public final LTransactionState<T1, T2> component1() {
                return this.state;
            }

            @NotNull
            public final StateWrapper<T1, T2> copy(@NotNull LTransactionState<? extends T1, ? extends T2> state) {
                Intrinsics.checkParameterIsNotNull(state, (String)"state");
                return new StateWrapper<T1, T2>(state);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ StateWrapper copy$default(StateWrapper stateWrapper, LTransactionState lTransactionState, int n, Object object) {
                if ((n & 1) != 0) {
                    lTransactionState = stateWrapper.state;
                }
                return stateWrapper.copy(lTransactionState);
            }

            @NotNull
            public String toString() {
                return "StateWrapper(state=" + this.state + ")";
            }

            public int hashCode() {
                LTransactionState<T1, T2> lTransactionState = this.state;
                return lTransactionState != null ? ((Object)lTransactionState).hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof StateWrapper)) break block3;
                        StateWrapper stateWrapper = (StateWrapper)object;
                        if (!Intrinsics.areEqual(this.state, stateWrapper.state)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        StateWrapper<BaseState, BaseState> stateAndString = new StateWrapper<BaseState, BaseState>(state);
        BytesAndSchemas ser1 = AMQPTestUtilsKt.serializeAndReturnSchema$default(new TestSerializationOutput(true, factory1), stateAndString, null, 2, null);
        SerializerFactory factory2 = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        DeserializationInput deserializationInput = new DeserializationInput(factory2);
        SerializedBytes bytes$iv = ser1.getObj();
        SerializationContext context$iv = null;
        ObjectAndEnvelope des1 = $receiver$iv.deserializeAndReturnEnvelope(bytes$iv, StateWrapper.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)((DState)state.getData()).getA(), (Object)((DState)((StateWrapper)des1.getObj()).getState().getData()).getA(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)((EState)state.getContext()).getA(), (Object)((EState)((StateWrapper)des1.getObj()).getState().getContext()).getA(), null, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void nestedMultiGenericsNoBound() {
        void $receiver$iv;
        SerializerFactory factory1 = AMQPTestUtilsKt.testDefaultFactoryNoEvolution$default(null, 1, null);
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000#\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u0001*\u0006\b\u0001\u0010\u0002 \u00012\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000b\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\f\u001a\u00028\u0001H\u00c6\u0003\u00a2\u0006\u0002\u0010\bJ.\u0010\r\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0004\u001a\u00028\u00002\b\b\u0002\u0010\u0005\u001a\u00028\u0001H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000eJ\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0013\u0010\u0005\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0016"}, d2={"net/corda/serialization/internal/amqp/GenericsTests$nestedMultiGenericsNoBound$LTransactionState", "T1", "T2", "", "data", "context", "(Ljava/lang/Object;Ljava/lang/Object;)V", "getContext", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getData", "component1", "component2", "copy", "(Ljava/lang/Object;Ljava/lang/Object;)Lnet/corda/serialization/internal/amqp/GenericsTests$nestedMultiGenericsNoBound$LTransactionState;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
        public final class LTransactionState<T1, T2> {
            private final T1 data;
            private final T2 context;

            public final T1 getData() {
                return this.data;
            }

            public final T2 getContext() {
                return this.context;
            }

            public LTransactionState(T1 data, T2 context) {
                this.data = data;
                this.context = context;
            }

            public final T1 component1() {
                return this.data;
            }

            public final T2 component2() {
                return this.context;
            }

            @NotNull
            public final LTransactionState<T1, T2> copy(T1 data, T2 context) {
                return new LTransactionState<T1, T2>(data, context);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ LTransactionState copy$default(LTransactionState lTransactionState, Object object, Object object2, int n, Object object3) {
                if ((n & 1) != 0) {
                    object = lTransactionState.data;
                }
                if ((n & 2) != 0) {
                    object2 = lTransactionState.context;
                }
                return lTransactionState.copy(object, object2);
            }

            @NotNull
            public String toString() {
                return "LTransactionState(data=" + this.data + ", context=" + this.context + ")";
            }

            public int hashCode() {
                T1 T1 = this.data;
                T2 T2 = this.context;
                return (T1 != null ? T1.hashCode() : 0) * 31 + (T2 != null ? T2.hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof LTransactionState)) break block3;
                        LTransactionState lTransactionState = (LTransactionState)object;
                        if (!Intrinsics.areEqual(this.data, lTransactionState.data) || !Intrinsics.areEqual(this.context, lTransactionState.context)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002*\u0002\u0000\u0001\b\n\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"net/corda/serialization/internal/amqp/GenericsTests$nestedMultiGenericsNoBound$DState", "net/corda/serialization/internal/amqp/GenericsTests$nestedMultiGenericsNoBound$BaseState", "a", "", "(I)V", "serialization"})
        public final class DState
        extends nestedMultiGenericsNoBound.BaseState {
            public DState(int a) {
                @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0013\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004*\u0001\u0000\b\u001a\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"net/corda/serialization/internal/amqp/GenericsTests$nestedMultiGenericsNoBound$BaseState", "", "a", "", "(I)V", "getA", "()I", "serialization"})
                public class BaseState {
                    private final int a;

                    public final int getA() {
                        return this.a;
                    }

                    public BaseState(int a) {
                        this.a = a;
                    }
                }
                super(a);
            }
        }
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004*\u0002\u0000\u0001\b\n\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"net/corda/serialization/internal/amqp/GenericsTests$nestedMultiGenericsNoBound$EState", "net/corda/serialization/internal/amqp/GenericsTests$nestedMultiGenericsNoBound$BaseState", "a", "", "msg", "", "(ILjava/lang/String;)V", "getMsg", "()Ljava/lang/String;", "serialization"})
        public final class EState
        extends nestedMultiGenericsNoBound.BaseState {
            @NotNull
            private final String msg;

            @NotNull
            public final String getMsg() {
                return this.msg;
            }

            public EState(int a, @NotNull String msg) {
                Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
                super(a);
                this.msg = msg;
            }
        }
        LTransactionState<DState, EState> state = new LTransactionState<DState, EState>(new DState(1020304), new EState(5060708, "things"));
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0002\u0000\u0005\b\u008a\b\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u0001*\u0006\b\u0001\u0010\u0002 \u00012\u00020\u0003B\u0019\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\bJ0\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\fJ\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u001f\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"net/corda/serialization/internal/amqp/GenericsTests$nestedMultiGenericsNoBound$StateWrapper", "T1", "T2", "", "state", "net/corda/serialization/internal/amqp/GenericsTests$nestedMultiGenericsNoBound$LTransactionState", "(Lnet/corda/serialization/internal/amqp/GenericsTests$nestedMultiGenericsNoBound$LTransactionState;)V", "getState", "()Lnet/corda/serialization/internal/amqp/GenericsTests$nestedMultiGenericsNoBound$LTransactionState;", "Lnet/corda/serialization/internal/amqp/GenericsTests$nestedMultiGenericsNoBound$LTransactionState;", "component1", "copy", "(Lnet/corda/serialization/internal/amqp/GenericsTests$nestedMultiGenericsNoBound$LTransactionState;)Lnet/corda/serialization/internal/amqp/GenericsTests$nestedMultiGenericsNoBound$StateWrapper;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
        public final class StateWrapper<T1, T2> {
            @NotNull
            private final LTransactionState<T1, T2> state;

            @NotNull
            public final LTransactionState<T1, T2> getState() {
                return this.state;
            }

            public StateWrapper(@NotNull LTransactionState<? extends T1, ? extends T2> state) {
                Intrinsics.checkParameterIsNotNull(state, (String)"state");
                this.state = state;
            }

            @NotNull
            public final LTransactionState<T1, T2> component1() {
                return this.state;
            }

            @NotNull
            public final StateWrapper<T1, T2> copy(@NotNull LTransactionState<? extends T1, ? extends T2> state) {
                Intrinsics.checkParameterIsNotNull(state, (String)"state");
                return new StateWrapper<T1, T2>(state);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ StateWrapper copy$default(StateWrapper stateWrapper, LTransactionState lTransactionState, int n, Object object) {
                if ((n & 1) != 0) {
                    lTransactionState = stateWrapper.state;
                }
                return stateWrapper.copy(lTransactionState);
            }

            @NotNull
            public String toString() {
                return "StateWrapper(state=" + this.state + ")";
            }

            public int hashCode() {
                LTransactionState<T1, T2> lTransactionState = this.state;
                return lTransactionState != null ? ((Object)lTransactionState).hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof StateWrapper)) break block3;
                        StateWrapper stateWrapper = (StateWrapper)object;
                        if (!Intrinsics.areEqual(this.state, stateWrapper.state)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        StateWrapper<DState, EState> stateAndString = new StateWrapper<DState, EState>(state);
        BytesAndSchemas ser1 = AMQPTestUtilsKt.serializeAndReturnSchema$default(new TestSerializationOutput(true, factory1), stateAndString, null, 2, null);
        SerializerFactory factory2 = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        DeserializationInput deserializationInput = new DeserializationInput(factory2);
        SerializedBytes bytes$iv = ser1.getObj();
        SerializationContext context$iv = null;
        ObjectAndEnvelope des1 = $receiver$iv.deserializeAndReturnEnvelope(bytes$iv, StateWrapper.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)state.getData().getA(), (Object)((DState)((StateWrapper)des1.getObj()).getState().getData()).getA(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)state.getContext().getA(), (Object)((EState)((StateWrapper)des1.getObj()).getState().getContext()).getA(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)state.getContext().getMsg(), (Object)((EState)((StateWrapper)des1.getObj()).getState().getContext()).getMsg(), null, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void baseClassInheritedButNotOverriden() {
        void $receiver$iv;
        void $receiver$iv2;
        SerializerFactory factory1 = AMQPTestUtilsKt.testDefaultFactoryNoEvolution$default(null, 1, null);
        SerializerFactory factory2 = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\b\u0003\n\u0002\b\u0005*\u0002\u0000\u0003\b\n\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"net/corda/serialization/internal/amqp/GenericsTests$baseClassInheritedButNotOverriden$DState", "T1", "T2", "net/corda/serialization/internal/amqp/GenericsTests$baseClassInheritedButNotOverriden$BaseState", "a", "b", "(Ljava/lang/Object;Ljava/lang/Object;)V", "serialization"})
        public final class DState<T1, T2>
        extends baseClassInheritedButNotOverriden.BaseState<T1, T2> {
            public DState(T1 a, T2 b) {
                @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u000f\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\b*\u0001\u0000\b\u001a\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0006R\u0016\u0010\u0004\u001a\u00028\u0000X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\u0005\u001a\u00028\u0001X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000b"}, d2={"net/corda/serialization/internal/amqp/GenericsTests$baseClassInheritedButNotOverriden$BaseState", "T1", "T2", "", "a", "b", "(Ljava/lang/Object;Ljava/lang/Object;)V", "getA", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getB", "serialization"})
                public class BaseState<T1, T2> {
                    private final T1 a;
                    private final T2 b;

                    public T1 getA() {
                        return this.a;
                    }

                    public T2 getB() {
                        return this.b;
                    }

                    public BaseState(T1 a, T2 b) {
                        this.a = a;
                        this.b = b;
                    }
                }
                super(a, b);
            }
        }
        DState<Integer, String> state = new DState<Integer, String>(100, "hello");
        BytesAndSchemas ser1 = AMQPTestUtilsKt.serializeAndReturnSchema$default(new TestSerializationOutput(true, factory1), state, null, 2, null);
        DeserializationInput deserializationInput = new DeserializationInput(factory2);
        SerializedBytes bytes$iv = ser1.getObj();
        SerializationContext context$iv = null;
        ObjectAndEnvelope des1 = $receiver$iv2.deserializeAndReturnEnvelope(bytes$iv, DState.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default(state.getA(), ((DState)des1.getObj()).getA(), null, (int)4, null);
        AssertionsKt.assertEquals$default(state.getB(), ((DState)des1.getObj()).getB(), null, (int)4, null);
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\b\u0004\n\u0002\b\t*\u0002\u0000\u0004\b\n\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u0004\b\u0002\u0010\u00032\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0004B\u001d\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u0012\u0006\u0010\u0006\u001a\u00028\u0001\u0012\u0006\u0010\u0007\u001a\u00028\u0002\u00a2\u0006\u0002\u0010\bR\u0013\u0010\u0007\u001a\u00028\u0002\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"net/corda/serialization/internal/amqp/GenericsTests$baseClassInheritedButNotOverriden$DState2", "T1", "T2", "T3", "net/corda/serialization/internal/amqp/GenericsTests$baseClassInheritedButNotOverriden$BaseState", "a", "b", "c", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", "getC", "()Ljava/lang/Object;", "Ljava/lang/Object;", "serialization"})
        public final class DState2<T1, T2, T3>
        extends baseClassInheritedButNotOverriden.BaseState<T1, T2> {
            private final T3 c;

            public final T3 getC() {
                return this.c;
            }

            public DState2(T1 a, T2 b, T3 c) {
                super(a, b);
                this.c = c;
            }
        }
        DState2<Integer, String, Long> state2 = new DState2<Integer, String, Long>(100, "hello", 100L);
        BytesAndSchemas ser2 = AMQPTestUtilsKt.serializeAndReturnSchema$default(new TestSerializationOutput(true, factory1), state2, null, 2, null);
        DeserializationInput $i$f$deserializeAndReturnEnvelope = new DeserializationInput(factory2);
        SerializedBytes bytes$iv2 = ser2.getObj();
        SerializationContext context$iv2 = null;
        ObjectAndEnvelope des2 = $receiver$iv.deserializeAndReturnEnvelope(bytes$iv2, DState2.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default(state2.getA(), ((DState2)des2.getObj()).getA(), null, (int)4, null);
        AssertionsKt.assertEquals$default(state2.getB(), ((DState2)des2.getObj()).getB(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)state2.getC(), ((DState2)des2.getObj()).getC(), null, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void baseClassInheritedButNotOverridenBounded() {
        void $receiver$iv;
        SerializerFactory factory1 = AMQPTestUtilsKt.testDefaultFactoryNoEvolution$default(null, 1, null);
        SerializerFactory factory2 = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u000f\n\u0002\b\u0002\n\u0000\n\u0002\b\u0004*\u0003\u0000\u0002\u0003\b\n\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"net/corda/serialization/internal/amqp/GenericsTests$baseClassInheritedButNotOverridenBounded$DState", "T1", "net/corda/serialization/internal/amqp/GenericsTests$baseClassInheritedButNotOverridenBounded$Bound", "net/corda/serialization/internal/amqp/GenericsTests$baseClassInheritedButNotOverridenBounded$BaseState", "a", "(Lnet/corda/serialization/internal/amqp/GenericsTests$baseClassInheritedButNotOverridenBounded$Bound;)V", "serialization"})
        public final class DState<T1 extends Bound>
        extends baseClassInheritedButNotOverridenBounded.BaseState<T1> {
            public DState(@NotNull T1 a) {
                Intrinsics.checkParameterIsNotNull(a, (String)"a");
                @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\b\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0006*\u0002\u0000\u0002\b\u001a\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0005R\u0016\u0010\u0004\u001a\u00028\u0000X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"net/corda/serialization/internal/amqp/GenericsTests$baseClassInheritedButNotOverridenBounded$BaseState", "T1", "net/corda/serialization/internal/amqp/GenericsTests$baseClassInheritedButNotOverridenBounded$Bound", "", "a", "(Lnet/corda/serialization/internal/amqp/GenericsTests$baseClassInheritedButNotOverridenBounded$Bound;)V", "getA", "()Lnet/corda/serialization/internal/amqp/GenericsTests$baseClassInheritedButNotOverridenBounded$Bound;", "Lnet/corda/serialization/internal/amqp/GenericsTests$baseClassInheritedButNotOverridenBounded$Bound;", "serialization"})
                public class BaseState<T1 extends Bound> {
                    @NotNull
                    private final T1 a;

                    @NotNull
                    public T1 getA() {
                        return this.a;
                    }

                    public BaseState(@NotNull T1 a) {
                        Intrinsics.checkParameterIsNotNull(a, (String)"a");
                        this.a = a;
                    }
                }
                super(a);
            }
        }
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0013\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004*\u0001\u0000\b\u001a\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"net/corda/serialization/internal/amqp/GenericsTests$baseClassInheritedButNotOverridenBounded$Bound", "", "a", "", "(I)V", "getA", "()I", "serialization"})
        public class Bound {
            private final int a;

            public final int getA() {
                return this.a;
            }

            public Bound(int a) {
                this.a = a;
            }
        }
        DState<Bound> state = new DState<Bound>(new Bound(100));
        BytesAndSchemas ser1 = AMQPTestUtilsKt.serializeAndReturnSchema$default(new TestSerializationOutput(true, factory1), state, null, 2, null);
        DeserializationInput deserializationInput = new DeserializationInput(factory2);
        SerializedBytes bytes$iv = ser1.getObj();
        SerializationContext context$iv = null;
        ObjectAndEnvelope des1 = $receiver$iv.deserializeAndReturnEnvelope(bytes$iv, DState.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)((Bound)state.getA()).getA(), (Object)((Bound)((DState)des1.getObj()).getA()).getA(), null, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void nestedMultiGenericsAtBottomWithBound() {
        void $receiver$iv;
        SerializerFactory factory1 = AMQPTestUtilsKt.testDefaultFactoryNoEvolution$default(null, 1, null);
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u000f\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\b*\u0001\u0000\b\u001a\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0006R\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0005\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000b"}, d2={"net/corda/serialization/internal/amqp/GenericsTests$nestedMultiGenericsAtBottomWithBound$BaseState", "T1", "T2", "", "a", "b", "(Ljava/lang/Object;Ljava/lang/Object;)V", "getA", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getB", "serialization"})
        public class BaseState<T1, T2> {
            private final T1 a;
            private final T2 b;

            public final T1 getA() {
                return this.a;
            }

            public final T2 getB() {
                return this.b;
            }

            public BaseState(T1 a, T2 b) {
                this.a = a;
                this.b = b;
            }
        }
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\b\u0004\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0002\u0000\u0004\b\u008a\b\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u0014\b\u0002\u0010\u0003*\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0004*\u0016\b\u0003\u0010\u0005 \u0001*\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u00042\u00020\u0006B\u0015\u0012\u0006\u0010\u0007\u001a\u00028\u0002\u0012\u0006\u0010\b\u001a\u00028\u0003\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u000e\u001a\u00028\u0002H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u000f\u001a\u00028\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000bJ:\u0010\u0010\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u00002\b\b\u0002\u0010\u0007\u001a\u00028\u00022\b\b\u0002\u0010\b\u001a\u00028\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0011J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0006H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0013\u0010\b\u001a\u00028\u0003\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0007\u001a\u00028\u0002\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u0019"}, d2={"net/corda/serialization/internal/amqp/GenericsTests$nestedMultiGenericsAtBottomWithBound$LTransactionState", "T1", "T2", "T3", "net/corda/serialization/internal/amqp/GenericsTests$nestedMultiGenericsAtBottomWithBound$BaseState", "T4", "", "data", "context", "(Lnet/corda/serialization/internal/amqp/GenericsTests$nestedMultiGenericsAtBottomWithBound$BaseState;Lnet/corda/serialization/internal/amqp/GenericsTests$nestedMultiGenericsAtBottomWithBound$BaseState;)V", "getContext", "()Lnet/corda/serialization/internal/amqp/GenericsTests$nestedMultiGenericsAtBottomWithBound$BaseState;", "Lnet/corda/serialization/internal/amqp/GenericsTests$nestedMultiGenericsAtBottomWithBound$BaseState;", "getData", "component1", "component2", "copy", "(Lnet/corda/serialization/internal/amqp/GenericsTests$nestedMultiGenericsAtBottomWithBound$BaseState;Lnet/corda/serialization/internal/amqp/GenericsTests$nestedMultiGenericsAtBottomWithBound$BaseState;)Lnet/corda/serialization/internal/amqp/GenericsTests$nestedMultiGenericsAtBottomWithBound$LTransactionState;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
        public final class LTransactionState<T1, T2, T3 extends BaseState<T1, T2>, T4 extends BaseState<T1, T2>> {
            @NotNull
            private final T3 data;
            @NotNull
            private final T4 context;

            @NotNull
            public final T3 getData() {
                return this.data;
            }

            @NotNull
            public final T4 getContext() {
                return this.context;
            }

            public LTransactionState(@NotNull T3 data, @NotNull T4 context) {
                Intrinsics.checkParameterIsNotNull(data, (String)"data");
                Intrinsics.checkParameterIsNotNull(context, (String)"context");
                this.data = data;
                this.context = context;
            }

            @NotNull
            public final T3 component1() {
                return this.data;
            }

            @NotNull
            public final T4 component2() {
                return this.context;
            }

            @NotNull
            public final LTransactionState<T1, T2, T3, T4> copy(@NotNull T3 data, @NotNull T4 context) {
                Intrinsics.checkParameterIsNotNull(data, (String)"data");
                Intrinsics.checkParameterIsNotNull(context, (String)"context");
                return new LTransactionState<T1, T2, T3, T4>(data, context);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ LTransactionState copy$default(LTransactionState lTransactionState, BaseState baseState, BaseState baseState2, int n, Object object) {
                if ((n & 1) != 0) {
                    baseState = lTransactionState.data;
                }
                if ((n & 2) != 0) {
                    baseState2 = lTransactionState.context;
                }
                return lTransactionState.copy(baseState, baseState2);
            }

            @NotNull
            public String toString() {
                return "LTransactionState(data=" + this.data + ", context=" + this.context + ")";
            }

            public int hashCode() {
                T3 T3 = this.data;
                T4 T4 = this.context;
                return (T3 != null ? T3.hashCode() : 0) * 31 + (T4 != null ? T4.hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof LTransactionState)) break block3;
                        LTransactionState lTransactionState = (LTransactionState)object;
                        if (!Intrinsics.areEqual(this.data, lTransactionState.data) || !Intrinsics.areEqual(this.context, lTransactionState.context)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\b\u0003\n\u0002\b\u0005*\u0002\u0000\u0003\b\n\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"net/corda/serialization/internal/amqp/GenericsTests$nestedMultiGenericsAtBottomWithBound$DState", "T1", "T2", "net/corda/serialization/internal/amqp/GenericsTests$nestedMultiGenericsAtBottomWithBound$BaseState", "a", "b", "(Ljava/lang/Object;Ljava/lang/Object;)V", "serialization"})
        public final class DState<T1, T2>
        extends BaseState<T1, T2> {
            public DState(T1 a, T2 b) {
                super(a, b);
            }
        }
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\b\u0003\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0004*\u0002\u0000\u0003\b\n\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B\u001d\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00028\u0001\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"net/corda/serialization/internal/amqp/GenericsTests$nestedMultiGenericsAtBottomWithBound$EState", "T1", "T2", "net/corda/serialization/internal/amqp/GenericsTests$nestedMultiGenericsAtBottomWithBound$BaseState", "a", "b", "c", "", "(Ljava/lang/Object;Ljava/lang/Object;J)V", "getC", "()J", "serialization"})
        public final class EState<T1, T2>
        extends BaseState<T1, T2> {
            private final long c;

            public final long getC() {
                return this.c;
            }

            public EState(T1 a, T2 b, long c) {
                super(a, b);
                this.c = c;
            }
        }
        LTransactionState state = new LTransactionState(new DState<Integer, String>(1020304, "Hello"), new EState<Integer, String>(5060708, "thins", 100L));
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000+\n\u0002\b\u0004\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0003\u0000\u0004\b\b\u008a\b\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u0014\b\u0002\u0010\u0003*\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0004*\u0016\b\u0003\u0010\u0005 \u0001*\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u00042\u00020\u0006B%\u0012\u001e\u0010\u0007\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\b\u00a2\u0006\u0002\u0010\tJ&\u0010\r\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\bH\u00c6\u0003\u00a2\u0006\u0002\u0010\u000bJH\u0010\u000e\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u00002 \b\u0002\u0010\u0007\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\bH\u00c6\u0001\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0006H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R+\u0010\u0007\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\b\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"net/corda/serialization/internal/amqp/GenericsTests$nestedMultiGenericsAtBottomWithBound$StateWrapper", "T1", "T2", "T3", "net/corda/serialization/internal/amqp/GenericsTests$nestedMultiGenericsAtBottomWithBound$BaseState", "T4", "", "state", "net/corda/serialization/internal/amqp/GenericsTests$nestedMultiGenericsAtBottomWithBound$LTransactionState", "(Lnet/corda/serialization/internal/amqp/GenericsTests$nestedMultiGenericsAtBottomWithBound$LTransactionState;)V", "getState", "()Lnet/corda/serialization/internal/amqp/GenericsTests$nestedMultiGenericsAtBottomWithBound$LTransactionState;", "Lnet/corda/serialization/internal/amqp/GenericsTests$nestedMultiGenericsAtBottomWithBound$LTransactionState;", "component1", "copy", "(Lnet/corda/serialization/internal/amqp/GenericsTests$nestedMultiGenericsAtBottomWithBound$LTransactionState;)Lnet/corda/serialization/internal/amqp/GenericsTests$nestedMultiGenericsAtBottomWithBound$StateWrapper;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
        public final class StateWrapper<T1, T2, T3 extends BaseState<T1, T2>, T4 extends BaseState<T1, T2>> {
            @NotNull
            private final LTransactionState<T1, T2, T3, T4> state;

            @NotNull
            public final LTransactionState<T1, T2, T3, T4> getState() {
                return this.state;
            }

            public StateWrapper(@NotNull LTransactionState<T1, T2, T3, ? extends T4> state) {
                Intrinsics.checkParameterIsNotNull(state, (String)"state");
                this.state = state;
            }

            @NotNull
            public final LTransactionState<T1, T2, T3, T4> component1() {
                return this.state;
            }

            @NotNull
            public final StateWrapper<T1, T2, T3, T4> copy(@NotNull LTransactionState<T1, T2, T3, ? extends T4> state) {
                Intrinsics.checkParameterIsNotNull(state, (String)"state");
                return new StateWrapper<T1, T2, T3, T4>(state);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ StateWrapper copy$default(StateWrapper stateWrapper, LTransactionState lTransactionState, int n, Object object) {
                if ((n & 1) != 0) {
                    lTransactionState = stateWrapper.state;
                }
                return stateWrapper.copy(lTransactionState);
            }

            @NotNull
            public String toString() {
                return "StateWrapper(state=" + this.state + ")";
            }

            public int hashCode() {
                LTransactionState<T1, T2, T3, T4> lTransactionState = this.state;
                return lTransactionState != null ? ((Object)lTransactionState).hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof StateWrapper)) break block3;
                        StateWrapper stateWrapper = (StateWrapper)object;
                        if (!Intrinsics.areEqual(this.state, stateWrapper.state)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        StateWrapper stateAndString = new StateWrapper(state);
        BytesAndSchemas ser1 = AMQPTestUtilsKt.serializeAndReturnSchema$default(new TestSerializationOutput(true, factory1), stateAndString, null, 2, null);
        SerializerFactory factory2 = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        DeserializationInput deserializationInput = new DeserializationInput(factory2);
        SerializedBytes bytes$iv = ser1.getObj();
        SerializationContext context$iv = null;
        ObjectAndEnvelope des1 = $receiver$iv.deserializeAndReturnEnvelope(bytes$iv, StateWrapper.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default(((DState)state.getData()).getA(), ((DState)((StateWrapper)des1.getObj()).getState().getData()).getA(), null, (int)4, null);
        AssertionsKt.assertEquals$default(((EState)state.getContext()).getA(), ((EState)((StateWrapper)des1.getObj()).getState().getContext()).getA(), null, (int)4, null);
    }

    public final void implemntsGeneric() {
        SerializerFactory factory = AMQPTestUtilsKt.testDefaultFactoryNoEvolution$default(null, 1, null);
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0010\n\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005*\u0002\u0000\u0001\b\n\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0003\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"net/corda/serialization/internal/amqp/GenericsTests$implemntsGeneric$D", "net/corda/serialization/internal/amqp/GenericsTests$implemntsGeneric$B", "", "a", "(Ljava/lang/String;)V", "getA", "()Ljava/lang/String;", "serialization"})
        public final class D
        extends implemntsGeneric.B<String> {
            @NotNull
            private final String a;

            @NotNull
            public String getA() {
                return this.a;
            }

            public D(@NotNull String a) {
                Intrinsics.checkParameterIsNotNull((Object)a, (String)"a");
                @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u000f\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006*\u0001\u0000\b\u001a\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0004R\u0016\u0010\u0003\u001a\u00028\u0000X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\b"}, d2={"net/corda/serialization/internal/amqp/GenericsTests$implemntsGeneric$B", "T", "", "a", "(Ljava/lang/Object;)V", "getA", "()Ljava/lang/Object;", "Ljava/lang/Object;", "serialization"})
                public class B<T> {
                    private final T a;

                    public T getA() {
                        return this.a;
                    }

                    public B(T a) {
                        this.a = a;
                    }
                }
                super(a);
                this.a = a;
            }
        }
        SerializedBytes bytes = AMQPTestUtilsKt.serialize$default(new SerializationOutput((LocalSerializerFactory)factory), new D("Test"), null, 2, null);
        DeserializationInput $receiver$iv = new DeserializationInput(factory);
        SerializationContext context$iv = null;
        Object object = $receiver$iv.deserialize((ByteSequence)bytes, D.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        D $receiver = (D)object;
        AssertionsKt.assertEquals$default((Object)"Test", (Object)$receiver.getA(), null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void implemntsGenericInterface() {
        SerializerFactory factory = AMQPTestUtilsKt.testDefaultFactoryNoEvolution$default(null, 1, null);
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005*\u0001\u0000\b\n\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0003\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"net/corda/serialization/internal/amqp/GenericsTests$implemntsGenericInterface$D", "Lnet/corda/serialization/internal/amqp/GenericsTests$implementsGenericInterfaceI;", "", "a", "(Ljava/lang/String;)V", "getA", "()Ljava/lang/String;", "serialization"})
        public final class D
        implements implementsGenericInterfaceI<String> {
            @NotNull
            private final String a;

            @NotNull
            public String getA() {
                return this.a;
            }

            public D(@NotNull String a) {
                Intrinsics.checkParameterIsNotNull((Object)a, (String)"a");
                this.a = a;
            }
        }
        SerializedBytes bytes = AMQPTestUtilsKt.serialize$default(new SerializationOutput((LocalSerializerFactory)factory), new D("Test"), null, 2, null);
        DeserializationInput $receiver$iv = new DeserializationInput(factory);
        SerializationContext context$iv = null;
        Object object = $receiver$iv.deserialize((ByteSequence)bytes, D.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        D $receiver = (D)object;
        AssertionsKt.assertEquals$default((Object)"Test", (Object)$receiver.getA(), null, (int)4, null);
    }

    static {
        Companion = new Companion(null);
        URI uRI = ProjectStructure.INSTANCE.getProjectRootDir().toUri().resolve("serialization-tests/src/test/resources/net/corda/serialization/internal/amqp");
        Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"projectRootDir.toUri().r\u2026alization/internal/amqp\")");
        localPath = uRI;
        MINI_CORP_NAME = new CordaX500Name("Notary Service", "Zurich", "CH");
        BigInteger bigInteger = BigInteger.valueOf(20L);
        Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger, (String)"BigInteger.valueOf(20)");
        PublicKey publicKey = Crypto.deriveKeyPairFromEntropy((SignatureScheme)Crypto.DEFAULT_SIGNATURE_SCHEME, (BigInteger)bigInteger).getPublic();
        Intrinsics.checkExpressionValueIsNotNull((Object)publicKey, (String)"Crypto.deriveKeyPairFrom\u2026teger.valueOf(20)).public");
        MINI_CORP_PARTY = new Party(MINI_CORP_NAME, publicKey);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\b\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u0000H\u00c6\u0001\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lnet/corda/serialization/internal/amqp/GenericsTests$ForceWildcard;", "T", "", "t", "(Ljava/lang/Object;)V", "getT", "()Ljava/lang/Object;", "Ljava/lang/Object;", "component1", "copy", "(Ljava/lang/Object;)Lnet/corda/serialization/internal/amqp/GenericsTests$ForceWildcard;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
    public static final class ForceWildcard<T> {
        private final T t;

        public final T getT() {
            return this.t;
        }

        public ForceWildcard(T t) {
            this.t = t;
        }

        public final T component1() {
            return this.t;
        }

        @NotNull
        public final ForceWildcard<T> copy(T t) {
            return new ForceWildcard<T>(t);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ ForceWildcard copy$default(ForceWildcard forceWildcard, Object object, int n, Object object2) {
            if ((n & 1) != 0) {
                object = forceWildcard.t;
            }
            return forceWildcard.copy(object);
        }

        @NotNull
        public String toString() {
            return "ForceWildcard(t=" + this.t + ")";
        }

        public int hashCode() {
            T t = this.t;
            return t != null ? t.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ForceWildcard)) break block3;
                    ForceWildcard forceWildcard = (ForceWildcard)object;
                    if (!Intrinsics.areEqual(this.t, forceWildcard.t)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\r\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J!\u0010\r\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lnet/corda/serialization/internal/amqp/GenericsTests$StateAndString;", "", "state", "Lnet/corda/core/contracts/TransactionState;", "ref", "", "(Lnet/corda/core/contracts/TransactionState;Ljava/lang/String;)V", "getRef", "()Ljava/lang/String;", "getState", "()Lnet/corda/core/contracts/TransactionState;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "serialization"})
    public static final class StateAndString {
        @NotNull
        private final TransactionState<?> state;
        @NotNull
        private final String ref;

        @NotNull
        public final TransactionState<?> getState() {
            return this.state;
        }

        @NotNull
        public final String getRef() {
            return this.ref;
        }

        public StateAndString(@NotNull TransactionState<?> state, @NotNull String ref) {
            Intrinsics.checkParameterIsNotNull(state, (String)"state");
            Intrinsics.checkParameterIsNotNull((Object)ref, (String)"ref");
            this.state = state;
            this.ref = ref;
        }

        @NotNull
        public final TransactionState<?> component1() {
            return this.state;
        }

        @NotNull
        public final String component2() {
            return this.ref;
        }

        @NotNull
        public final StateAndString copy(@NotNull TransactionState<?> state, @NotNull String ref) {
            Intrinsics.checkParameterIsNotNull(state, (String)"state");
            Intrinsics.checkParameterIsNotNull((Object)ref, (String)"ref");
            return new StateAndString(state, ref);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ StateAndString copy$default(StateAndString stateAndString, TransactionState transactionState, String string, int n, Object object) {
            if ((n & 1) != 0) {
                transactionState = stateAndString.state;
            }
            if ((n & 2) != 0) {
                string = stateAndString.ref;
            }
            return stateAndString.copy(transactionState, string);
        }

        @NotNull
        public String toString() {
            return "StateAndString(state=" + this.state + ", ref=" + this.ref + ")";
        }

        public int hashCode() {
            TransactionState<?> transactionState = this.state;
            String string = this.ref;
            return (transactionState != null ? transactionState.hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof StateAndString)) break block3;
                    StateAndString stateAndString = (StateAndString)object;
                    if (!Intrinsics.areEqual(this.state, stateAndString.state) || !Intrinsics.areEqual((Object)this.ref, (Object)stateAndString.ref)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0003B\u001b\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0007H\u00c6\u0003J)\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lnet/corda/serialization/internal/amqp/GenericsTests$GenericStateAndString;", "T", "Lnet/corda/core/contracts/ContractState;", "", "state", "Lnet/corda/core/contracts/TransactionState;", "ref", "", "(Lnet/corda/core/contracts/TransactionState;Ljava/lang/String;)V", "getRef", "()Ljava/lang/String;", "getState", "()Lnet/corda/core/contracts/TransactionState;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "serialization"})
    public static final class GenericStateAndString<T extends ContractState> {
        @NotNull
        private final TransactionState<T> state;
        @NotNull
        private final String ref;

        @NotNull
        public final TransactionState<T> getState() {
            return this.state;
        }

        @NotNull
        public final String getRef() {
            return this.ref;
        }

        public GenericStateAndString(@NotNull TransactionState<? extends T> state, @NotNull String ref) {
            Intrinsics.checkParameterIsNotNull(state, (String)"state");
            Intrinsics.checkParameterIsNotNull((Object)ref, (String)"ref");
            this.state = state;
            this.ref = ref;
        }

        @NotNull
        public final TransactionState<T> component1() {
            return this.state;
        }

        @NotNull
        public final String component2() {
            return this.ref;
        }

        @NotNull
        public final GenericStateAndString<T> copy(@NotNull TransactionState<? extends T> state, @NotNull String ref) {
            Intrinsics.checkParameterIsNotNull(state, (String)"state");
            Intrinsics.checkParameterIsNotNull((Object)ref, (String)"ref");
            return new GenericStateAndString<T>(state, ref);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ GenericStateAndString copy$default(GenericStateAndString genericStateAndString, TransactionState transactionState, String string, int n, Object object) {
            if ((n & 1) != 0) {
                transactionState = genericStateAndString.state;
            }
            if ((n & 2) != 0) {
                string = genericStateAndString.ref;
            }
            return genericStateAndString.copy(transactionState, string);
        }

        @NotNull
        public String toString() {
            return "GenericStateAndString(state=" + this.state + ", ref=" + this.ref + ")";
        }

        public int hashCode() {
            TransactionState<T> transactionState = this.state;
            String string = this.ref;
            return (transactionState != null ? transactionState.hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof GenericStateAndString)) break block3;
                    GenericStateAndString genericStateAndString = (GenericStateAndString)object;
                    if (!Intrinsics.areEqual(this.state, genericStateAndString.state) || !Intrinsics.areEqual((Object)this.ref, (Object)genericStateAndString.ref)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\bf\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002R\u0012\u0010\u0003\u001a\u00028\u0000X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lnet/corda/serialization/internal/amqp/GenericsTests$implementsGenericInterfaceI;", "T", "", "a", "getA", "()Ljava/lang/Object;", "serialization"})
    public static interface implementsGenericInterfaceI<T> {
        public T getA();
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R$\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u000b\u0010\u0002\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lnet/corda/serialization/internal/amqp/GenericsTests$Companion;", "", "()V", "MINI_CORP_NAME", "Lnet/corda/core/identity/CordaX500Name;", "MINI_CORP_PARTY", "Lnet/corda/core/identity/Party;", "VERBOSE", "", "localPath", "Ljava/net/URI;", "localPath$annotations", "getLocalPath", "()Ljava/net/URI;", "setLocalPath", "(Ljava/net/URI;)V", "serialization"})
    public static final class Companion {
        public static /* synthetic */ void localPath$annotations() {
        }

        @NotNull
        public final URI getLocalPath() {
            return localPath;
        }

        public final void setLocalPath(@NotNull URI uRI) {
            Intrinsics.checkParameterIsNotNull((Object)uRI, (String)"<set-?>");
            localPath = uRI;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

