/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp;

import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.test.AssertionsKt;
import net.corda.core.serialization.ClassWhitelist;
import net.corda.serialization.internal.AllWhitelist;
import net.corda.serialization.internal.amqp.BytesAndSchemas;
import net.corda.serialization.internal.amqp.CachingCustomSerializerRegistry;
import net.corda.serialization.internal.amqp.CustomSerializerRegistry;
import net.corda.serialization.internal.amqp.DefaultDescriptorBasedSerializerRegistry;
import net.corda.serialization.internal.amqp.DescriptorBasedSerializerRegistry;
import net.corda.serialization.internal.amqp.FingerPrinterTesting;
import net.corda.serialization.internal.amqp.FingerPrinterTestingTests;
import net.corda.serialization.internal.amqp.SerializerFactory;
import net.corda.serialization.internal.amqp.SerializerFactoryBuilder;
import net.corda.serialization.internal.amqp.TypeNotation;
import net.corda.serialization.internal.amqp.WhitelistBasedTypeModelConfiguration;
import net.corda.serialization.internal.amqp.testutils.AMQPTestUtilsKt;
import net.corda.serialization.internal.amqp.testutils.TestSerializationOutput;
import net.corda.serialization.internal.carpenter.ClassCarpenter;
import net.corda.serialization.internal.carpenter.ClassCarpenterImpl;
import net.corda.serialization.internal.model.ConfigurableLocalTypeModel;
import net.corda.serialization.internal.model.FingerPrinter;
import net.corda.serialization.internal.model.LocalTypeModelConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007\u00a8\u0006\u0007"}, d2={"Lnet/corda/serialization/internal/amqp/FingerPrinterTestingTests;", "", "()V", "testingTest", "", "worksAsReplacement", "Companion", "serialization"})
public final class FingerPrinterTestingTests {
    public static final boolean VERBOSE = true;
    public static final Companion Companion = new Companion(null);

    @Test(timeout=300000L)
    public final void testingTest() {
        FingerPrinterTesting fpt = new FingerPrinterTesting();
        DefaultDescriptorBasedSerializerRegistry descriptorBasedSerializerRegistry = new DefaultDescriptorBasedSerializerRegistry();
        CustomSerializerRegistry customSerializerRegistry = (CustomSerializerRegistry)new CachingCustomSerializerRegistry((DescriptorBasedSerializerRegistry)descriptorBasedSerializerRegistry);
        ConfigurableLocalTypeModel typeModel = new ConfigurableLocalTypeModel((LocalTypeModelConfiguration)new WhitelistBasedTypeModelConfiguration((ClassWhitelist)AllWhitelist.INSTANCE, customSerializerRegistry));
        AssertionsKt.assertEquals$default((Object)"0", (Object)fpt.fingerprint(typeModel.inspect((Type)((Object)Integer.class))), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)"1", (Object)fpt.fingerprint(typeModel.inspect((Type)((Object)String.class))), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)"0", (Object)fpt.fingerprint(typeModel.inspect((Type)((Object)Integer.class))), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)"1", (Object)fpt.fingerprint(typeModel.inspect((Type)((Object)String.class))), null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void worksAsReplacement() {
        ClassWhitelist classWhitelist = (ClassWhitelist)AllWhitelist.INSTANCE;
        ClassWhitelist classWhitelist2 = (ClassWhitelist)AllWhitelist.INSTANCE;
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        Intrinsics.checkExpressionValueIsNotNull((Object)classLoader, (String)"ClassLoader.getSystemClassLoader()");
        SerializerFactory factory = SerializerFactoryBuilder.build$default((ClassWhitelist)classWhitelist, (ClassCarpenter)((ClassCarpenter)new ClassCarpenterImpl(classWhitelist2, classLoader, false, 4, null)), null, (boolean)false, (FingerPrinter)new FingerPrinterTesting(), (boolean)false, (boolean)false, (int)108, null);
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000'\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\"\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000eJ\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"net/corda/serialization/internal/amqp/FingerPrinterTestingTests$worksAsReplacement$C", "", "a", "", "b", "", "(IJ)V", "getA", "()I", "getB", "()J", "component1", "component2", "copy", "(IJ)Lnet/corda/serialization/internal/amqp/FingerPrinterTestingTests$worksAsReplacement$C;", "equals", "", "other", "hashCode", "toString", "", "serialization"})
        public final class C {
            private final int a;
            private final long b;

            public final int getA() {
                return this.a;
            }

            public final long getB() {
                return this.b;
            }

            public C(int a, long b) {
                this.a = a;
                this.b = b;
            }

            public final int component1() {
                return this.a;
            }

            public final long component2() {
                return this.b;
            }

            @NotNull
            public final C copy(int a, long b) {
                return new C(a, b);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ C copy$default(C c, int n, long l, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = c.a;
                }
                if ((n2 & 2) != 0) {
                    l = c.b;
                }
                return c.copy(n, l);
            }

            @NotNull
            public String toString() {
                return "C(a=" + this.a + ", b=" + this.b + ")";
            }

            public int hashCode() {
                return Integer.hashCode(this.a) * 31 + Long.hashCode(this.b);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof C)) break block3;
                        C c = (C)object;
                        if (!(this.a == c.a) || !(this.b == c.b)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        BytesAndSchemas blob = AMQPTestUtilsKt.serializeAndReturnSchema$default(new TestSerializationOutput(true, factory), new C(1, 2L), null, 2, null);
        AssertionsKt.assertEquals$default((Object)1, (Object)blob.getSchema().getTypes().size(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)"<descriptor name=\"net.corda:0\"/>", (Object)((TypeNotation)blob.getSchema().getTypes().get(0)).getDescriptor().toString(), null, (int)4, null);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnet/corda/serialization/internal/amqp/FingerPrinterTestingTests$Companion;", "", "()V", "VERBOSE", "", "serialization"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

