/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp;

import java.io.File;
import java.io.NotSerializableException;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.test.AssertionsKt;
import net.corda.core.contracts.StateRef;
import net.corda.core.crypto.Crypto;
import net.corda.core.crypto.CryptoUtils;
import net.corda.core.crypto.DigitalSignature;
import net.corda.core.crypto.SignatureScheme;
import net.corda.core.crypto.SignedData;
import net.corda.core.flows.MaybeSerializedSignedTransaction;
import net.corda.core.flows.NotarisationRequest;
import net.corda.core.identity.CordaX500Name;
import net.corda.core.identity.Party;
import net.corda.core.node.NetworkParameters;
import net.corda.core.node.NotaryInfo;
import net.corda.core.serialization.ConstructorForDeserialization;
import net.corda.core.serialization.DeprecatedConstructorForDeserialization;
import net.corda.core.serialization.SerializableCalculatedProperty;
import net.corda.core.serialization.SerializationContext;
import net.corda.core.serialization.SerializedBytes;
import net.corda.core.utilities.ByteSequence;
import net.corda.serialization.internal.amqp.AMQPRemoteTypeModel;
import net.corda.serialization.internal.amqp.BytesAndSchemas;
import net.corda.serialization.internal.amqp.CustomSerializer;
import net.corda.serialization.internal.amqp.DeserializationInput;
import net.corda.serialization.internal.amqp.EvolvabilityTests;
import net.corda.serialization.internal.amqp.LocalSerializerFactory;
import net.corda.serialization.internal.amqp.SerializationOutput;
import net.corda.serialization.internal.amqp.SerializationSchemas;
import net.corda.serialization.internal.amqp.SerializerFactory;
import net.corda.serialization.internal.amqp.custom.DurationSerializer;
import net.corda.serialization.internal.amqp.custom.InstantSerializer;
import net.corda.serialization.internal.amqp.custom.PublicKeySerializer;
import net.corda.serialization.internal.amqp.testutils.AMQPTestUtilsKt;
import net.corda.serialization.internal.amqp.testutils.ProjectStructure;
import net.corda.serialization.internal.amqp.testutils.TestSerializationContextKt;
import net.corda.serialization.internal.amqp.testutils.TestSerializationOutput;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Ignore;
import org.junit.Test;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b!\u0018\u0000 '2\u00020\u0001:\u0005'()*+B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u000bH\u0007J\b\u0010\f\u001a\u00020\u000bH\u0007J\b\u0010\r\u001a\u00020\u000bH\u0007J\b\u0010\u000e\u001a\u00020\u000bH\u0007J\b\u0010\u000f\u001a\u00020\u000bH\u0007J\b\u0010\u0010\u001a\u00020\u000bH\u0007J\b\u0010\u0011\u001a\u00020\u000bH\u0007J\b\u0010\u0012\u001a\u00020\u000bH\u0007J\b\u0010\u0013\u001a\u00020\u000bH\u0007J\b\u0010\u0014\u001a\u00020\u000bH\u0007J\b\u0010\u0015\u001a\u00020\u000bH\u0007J\b\u0010\u0016\u001a\u00020\u000bH\u0007J\b\u0010\u0017\u001a\u00020\u000bH\u0007J\b\u0010\u0018\u001a\u00020\u000bH\u0007J\b\u0010\u0019\u001a\u00020\u000bH\u0007J\b\u0010\u001a\u001a\u00020\u000bH\u0007J\b\u0010\u001b\u001a\u00020\u000bH\u0007J\b\u0010\u001c\u001a\u00020\u000bH\u0007J\b\u0010\u001d\u001a\u00020\u000bH\u0007J\b\u0010\u001e\u001a\u00020\u000bH\u0007J\b\u0010\u001f\u001a\u00020\u000bH\u0007J\b\u0010 \u001a\u00020\u000bH\u0007J\b\u0010!\u001a\u00020\u000bH\u0007J\b\u0010\"\u001a\u00020\u000bH\u0007J\b\u0010#\u001a\u00020\u000bH\u0007J\b\u0010$\u001a\u00020\u000bH\u0007J\b\u0010%\u001a\u00020\u000bH\u0007J\b\u0010&\u001a\u00020\u000bH\u0007R$\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006,"}, d2={"Lnet/corda/serialization/internal/amqp/EvolvabilityTests;", "", "()V", "localPath", "Ljava/net/URI;", "localPath$annotations", "getLocalPath", "()Ljava/net/URI;", "setLocalPath", "(Ljava/net/URI;)V", "addAdditionalParam", "", "addAdditionalParamNotMandatory", "addAndRemoveParameters", "addMandatoryFieldAndRemoveExistingNullableIntField", "addMandatoryFieldWithAltConstructor", "addMandatoryFieldWithAltConstructorAndMakeExistingIntFieldNullable", "addMandatoryFieldWithAltConstructorAndMakeExistingNullableIntFieldMandatory", "addMandatoryFieldWithAltConstructorForceReorder", "addMandatoryFieldWithAltConstructorUnAnnotated", "addMandatoryFieldWithAltReorderedConstructor", "addMandatoryFieldWithAltReorderedConstructorAndRemoval", "changeSubType", "evolutionWithCarpentry", "evolutionWithPrimitives", "getterSetterEvolver1", "maybeSerializedTransaction", "moreComplexNonNullWithReorder", "multiVersion", "multiVersionWithRemoval", "notarisationRequestStabilityTest", "read corda 4-11 network parameters", "readBrokenNetworkParameters", "regenerate broken network parameters", "removeExistingNullableIntFieldWithAltConstructor", "removeParameterWithCalculatedParameter", "removeParameters", "simpleOrderSwapDifferentType", "simpleOrderSwapSameType", "Companion", "Evolved", "ForceEvolution", "Parameterized", "ParameterizedContainer", "serialization"})
public final class EvolvabilityTests {
    @NotNull
    private URI localPath;
    private static final CordaX500Name DUMMY_NOTARY_NAME;
    private static final Party DUMMY_NOTARY_PARTY;
    public static final Companion Companion;

    public static /* synthetic */ void localPath$annotations() {
    }

    @NotNull
    public final URI getLocalPath() {
        return this.localPath;
    }

    public final void setLocalPath(@NotNull URI uRI) {
        Intrinsics.checkParameterIsNotNull((Object)uRI, (String)"<set-?>");
        this.localPath = uRI;
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void simpleOrderSwapSameType() {
        void $receiver$iv;
        URL url;
        SerializerFactory sf = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        String resource = "EvolvabilityTests.simpleOrderSwapSameType";
        int A2 = 1;
        int B4 = 2;
        URL uRL = url = EvolvabilityTests.class.getResource(resource);
        Intrinsics.checkExpressionValueIsNotNull((Object)uRL, (String)"url");
        byte[] sc2 = TextStreamsKt.readBytes((URL)uRL);
        DeserializationInput deserializationInput = new DeserializationInput(sf);
        SerializedBytes bytes$iv = new SerializedBytes(sc2);
        SerializationContext context$iv = null;
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000!\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\"\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\fJ\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"net/corda/serialization/internal/amqp/EvolvabilityTests$simpleOrderSwapSameType$C", "", "b", "", "a", "(II)V", "getA", "()I", "getB", "component1", "component2", "copy", "(II)Lnet/corda/serialization/internal/amqp/EvolvabilityTests$simpleOrderSwapSameType$C;", "equals", "", "other", "hashCode", "toString", "", "serialization"})
        public final class C {
            private final int b;
            private final int a;

            public final int getB() {
                return this.b;
            }

            public final int getA() {
                return this.a;
            }

            public C(int b, int a) {
                this.b = b;
                this.a = a;
            }

            public final int component1() {
                return this.b;
            }

            public final int component2() {
                return this.a;
            }

            @NotNull
            public final C copy(int b, int a) {
                return new C(b, a);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ C copy$default(C c, int n, int n2, int n3, Object object) {
                if ((n3 & 1) != 0) {
                    n = c.b;
                }
                if ((n3 & 2) != 0) {
                    n2 = c.a;
                }
                return c.copy(n, n2);
            }

            @NotNull
            public String toString() {
                return "C(b=" + this.b + ", a=" + this.a + ")";
            }

            public int hashCode() {
                return Integer.hashCode(this.b) * 31 + Integer.hashCode(this.a);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof C)) break block3;
                        C c = (C)object;
                        if (!(this.b == c.b) || !(this.a == c.a)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        C deserializedC = (C)$receiver$iv.deserialize((ByteSequence)bytes$iv, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)A2, (Object)deserializedC.getA(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)B4, (Object)deserializedC.getB(), null, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void simpleOrderSwapDifferentType() {
        void $receiver$iv;
        URL url;
        SerializerFactory sf = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        int A2 = 1;
        String B4 = "two";
        String resource = "EvolvabilityTests.simpleOrderSwapDifferentType";
        URL uRL = url = EvolvabilityTests.class.getResource(resource);
        Intrinsics.checkExpressionValueIsNotNull((Object)uRL, (String)"url");
        byte[] sc2 = TextStreamsKt.readBytes((URL)uRL);
        DeserializationInput deserializationInput = new DeserializationInput(sf);
        SerializedBytes bytes$iv = new SerializedBytes(sc2);
        SerializationContext context$iv = null;
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000!\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\"\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000eJ\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"net/corda/serialization/internal/amqp/EvolvabilityTests$simpleOrderSwapDifferentType$C", "", "b", "", "a", "", "(Ljava/lang/String;I)V", "getA", "()I", "getB", "()Ljava/lang/String;", "component1", "component2", "copy", "(Ljava/lang/String;I)Lnet/corda/serialization/internal/amqp/EvolvabilityTests$simpleOrderSwapDifferentType$C;", "equals", "", "other", "hashCode", "toString", "serialization"})
        public final class C {
            @NotNull
            private final String b;
            private final int a;

            @NotNull
            public final String getB() {
                return this.b;
            }

            public final int getA() {
                return this.a;
            }

            public C(@NotNull String b, int a) {
                Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
                this.b = b;
                this.a = a;
            }

            @NotNull
            public final String component1() {
                return this.b;
            }

            public final int component2() {
                return this.a;
            }

            @NotNull
            public final C copy(@NotNull String b, int a) {
                Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
                return new C(b, a);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ C copy$default(C c, String string, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    string = c.b;
                }
                if ((n2 & 2) != 0) {
                    n = c.a;
                }
                return c.copy(string, n);
            }

            @NotNull
            public String toString() {
                return "C(b=" + this.b + ", a=" + this.a + ")";
            }

            public int hashCode() {
                String string = this.b;
                return (string != null ? string.hashCode() : 0) * 31 + Integer.hashCode(this.a);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof C)) break block3;
                        C c = (C)object;
                        if (!Intrinsics.areEqual((Object)this.b, (Object)c.b) || !(this.a == c.a)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        C deserializedC = (C)$receiver$iv.deserialize((ByteSequence)bytes$iv, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)A2, (Object)deserializedC.getA(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)B4, (Object)deserializedC.getB(), null, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void addAdditionalParamNotMandatory() {
        void $receiver$iv;
        URL url;
        SerializerFactory sf = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        int A2 = 1;
        String resource = "EvolvabilityTests.addAdditionalParamNotMandatory";
        URL uRL = url = EvolvabilityTests.class.getResource(resource);
        Intrinsics.checkExpressionValueIsNotNull((Object)uRL, (String)"url");
        byte[] sc2 = TextStreamsKt.readBytes((URL)uRL);
        DeserializationInput deserializationInput = new DeserializationInput(sf);
        SerializedBytes bytes$iv = new SerializedBytes(sc2);
        SerializationContext context$iv = null;
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000!\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\tJ$\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000eJ\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"net/corda/serialization/internal/amqp/EvolvabilityTests$addAdditionalParamNotMandatory$C", "", "a", "", "b", "(ILjava/lang/Integer;)V", "getA", "()I", "getB", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "component1", "component2", "copy", "(ILjava/lang/Integer;)Lnet/corda/serialization/internal/amqp/EvolvabilityTests$addAdditionalParamNotMandatory$C;", "equals", "", "other", "hashCode", "toString", "", "serialization"})
        public final class C {
            private final int a;
            @Nullable
            private final Integer b;

            public final int getA() {
                return this.a;
            }

            @Nullable
            public final Integer getB() {
                return this.b;
            }

            public C(int a, @Nullable Integer b) {
                this.a = a;
                this.b = b;
            }

            public final int component1() {
                return this.a;
            }

            @Nullable
            public final Integer component2() {
                return this.b;
            }

            @NotNull
            public final C copy(int a, @Nullable Integer b) {
                return new C(a, b);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ C copy$default(C c, int n, Integer n2, int n3, Object object) {
                if ((n3 & 1) != 0) {
                    n = c.a;
                }
                if ((n3 & 2) != 0) {
                    n2 = c.b;
                }
                return c.copy(n, n2);
            }

            @NotNull
            public String toString() {
                return "C(a=" + this.a + ", b=" + this.b + ")";
            }

            public int hashCode() {
                Integer n = this.b;
                return Integer.hashCode(this.a) * 31 + (n != null ? ((Object)n).hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof C)) break block3;
                        C c = (C)object;
                        if (!(this.a == c.a) || !Intrinsics.areEqual((Object)this.b, (Object)c.b)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        C deserializedC = (C)$receiver$iv.deserialize((ByteSequence)bytes$iv, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)A2, (Object)deserializedC.getA(), null, (int)4, null);
        AssertionsKt.assertEquals$default(null, (Object)deserializedC.getB(), null, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Test(expected=NotSerializableException.class, timeout=300000L)
    public final void addAdditionalParam() {
        void $receiver$iv;
        SerializerFactory sf = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        URL url = EvolvabilityTests.class.getResource("EvolvabilityTests.addAdditionalParam");
        boolean A2 = true;
        URL uRL = url;
        Intrinsics.checkExpressionValueIsNotNull((Object)uRL, (String)"url");
        byte[] sc2 = TextStreamsKt.readBytes((URL)uRL);
        DeserializationInput deserializationInput = new DeserializationInput(sf);
        SerializedBytes bytes$iv = new SerializedBytes(sc2);
        SerializationContext context$iv = null;
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000!\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\"\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\fJ\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"net/corda/serialization/internal/amqp/EvolvabilityTests$addAdditionalParam$C", "", "a", "", "b", "(II)V", "getA", "()I", "getB", "component1", "component2", "copy", "(II)Lnet/corda/serialization/internal/amqp/EvolvabilityTests$addAdditionalParam$C;", "equals", "", "other", "hashCode", "toString", "", "serialization"})
        public final class C {
            private final int a;
            private final int b;

            public final int getA() {
                return this.a;
            }

            public final int getB() {
                return this.b;
            }

            public C(int a, int b) {
                this.a = a;
                this.b = b;
            }

            public final int component1() {
                return this.a;
            }

            public final int component2() {
                return this.b;
            }

            @NotNull
            public final C copy(int a, int b) {
                return new C(a, b);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ C copy$default(C c, int n, int n2, int n3, Object object) {
                if ((n3 & 1) != 0) {
                    n = c.a;
                }
                if ((n3 & 2) != 0) {
                    n2 = c.b;
                }
                return c.copy(n, n2);
            }

            @NotNull
            public String toString() {
                return "C(a=" + this.a + ", b=" + this.b + ")";
            }

            public int hashCode() {
                return Integer.hashCode(this.a) * 31 + Integer.hashCode(this.b);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof C)) break block3;
                        C c = (C)object;
                        if (!(this.a == c.a) || !(this.b == c.b)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        $receiver$iv.deserialize((ByteSequence)bytes$iv, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void removeParameters() {
        void $receiver$iv;
        URL url;
        SerializerFactory sf = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        String resource = "EvolvabilityTests.removeParameters";
        boolean A2 = true;
        String B4 = "two";
        String C5 = "three";
        int D2 = 4;
        URL uRL = url = EvolvabilityTests.class.getResource("EvolvabilityTests.removeParameters");
        Intrinsics.checkExpressionValueIsNotNull((Object)uRL, (String)"url");
        byte[] sc2 = TextStreamsKt.readBytes((URL)uRL);
        DeserializationInput deserializationInput = new DeserializationInput(sf);
        SerializedBytes bytes$iv = new SerializedBytes(sc2);
        SerializationContext context$iv = null;
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000!\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\"\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000eJ\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"net/corda/serialization/internal/amqp/EvolvabilityTests$removeParameters$CC", "", "b", "", "d", "", "(Ljava/lang/String;I)V", "getB", "()Ljava/lang/String;", "getD", "()I", "component1", "component2", "copy", "(Ljava/lang/String;I)Lnet/corda/serialization/internal/amqp/EvolvabilityTests$removeParameters$CC;", "equals", "", "other", "hashCode", "toString", "serialization"})
        public final class CC {
            @NotNull
            private final String b;
            private final int d;

            @NotNull
            public final String getB() {
                return this.b;
            }

            public final int getD() {
                return this.d;
            }

            public CC(@NotNull String b, int d) {
                Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
                this.b = b;
                this.d = d;
            }

            @NotNull
            public final String component1() {
                return this.b;
            }

            public final int component2() {
                return this.d;
            }

            @NotNull
            public final CC copy(@NotNull String b, int d) {
                Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
                return new CC(b, d);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ CC copy$default(CC cC, String string, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    string = cC.b;
                }
                if ((n2 & 2) != 0) {
                    n = cC.d;
                }
                return cC.copy(string, n);
            }

            @NotNull
            public String toString() {
                return "CC(b=" + this.b + ", d=" + this.d + ")";
            }

            public int hashCode() {
                String string = this.b;
                return (string != null ? string.hashCode() : 0) * 31 + Integer.hashCode(this.d);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof CC)) break block3;
                        CC cC = (CC)object;
                        if (!Intrinsics.areEqual((Object)this.b, (Object)cC.b) || !(this.d == cC.d)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        CC deserializedCC = (CC)$receiver$iv.deserialize((ByteSequence)bytes$iv, CC.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)B4, (Object)deserializedCC.getB(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)D2, (Object)deserializedCC.getD(), null, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void removeParameterWithCalculatedParameter() {
        void $receiver$iv;
        URL url;
        SerializerFactory sf = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        String resource = "EvolvabilityTests.removeParameterWithCalculatedParameter";
        URL uRL = url = EvolvabilityTests.class.getResource(resource);
        Intrinsics.checkExpressionValueIsNotNull((Object)uRL, (String)"url");
        byte[] sc2 = TextStreamsKt.readBytes((URL)uRL);
        DeserializationInput deserializationInput = new DeserializationInput(sf);
        SerializedBytes bytes$iv = new SerializedBytes(sc2);
        SerializationContext context$iv = null;
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000!\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0004*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\"\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0010J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u00038G\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\b\u00a8\u0006\u0016"}, d2={"net/corda/serialization/internal/amqp/EvolvabilityTests$removeParameterWithCalculatedParameter$CC", "", "b", "", "d", "", "(Ljava/lang/String;I)V", "getB", "()Ljava/lang/String;", "getD", "()I", "e", "getE", "component1", "component2", "copy", "(Ljava/lang/String;I)Lnet/corda/serialization/internal/amqp/EvolvabilityTests$removeParameterWithCalculatedParameter$CC;", "equals", "", "other", "hashCode", "toString", "serialization"})
        public final class CC {
            @NotNull
            private final String b;
            private final int d;

            @SerializableCalculatedProperty
            @NotNull
            public final String getE() {
                return this.b + " sailor";
            }

            @NotNull
            public final String getB() {
                return this.b;
            }

            public final int getD() {
                return this.d;
            }

            public CC(@NotNull String b, int d) {
                Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
                this.b = b;
                this.d = d;
            }

            @NotNull
            public final String component1() {
                return this.b;
            }

            public final int component2() {
                return this.d;
            }

            @NotNull
            public final CC copy(@NotNull String b, int d) {
                Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
                return new CC(b, d);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ CC copy$default(CC cC, String string, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    string = cC.b;
                }
                if ((n2 & 2) != 0) {
                    n = cC.d;
                }
                return cC.copy(string, n);
            }

            @NotNull
            public String toString() {
                return "CC(b=" + this.b + ", d=" + this.d + ")";
            }

            public int hashCode() {
                String string = this.b;
                return (string != null ? string.hashCode() : 0) * 31 + Integer.hashCode(this.d);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof CC)) break block3;
                        CC cC = (CC)object;
                        if (!Intrinsics.areEqual((Object)this.b, (Object)cC.b) || !(this.d == cC.d)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        CC deserializedCC = (CC)$receiver$iv.deserialize((ByteSequence)bytes$iv, CC.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)"hello", (Object)deserializedCC.getB(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)2, (Object)deserializedCC.getD(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)"hello sailor", (Object)deserializedCC.getE(), null, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void addAndRemoveParameters() {
        void $receiver$iv;
        URL url;
        SerializerFactory sf = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        int A2 = 1;
        String B4 = "two";
        String C5 = "three";
        int D2 = 4;
        Object E = null;
        String resource = "EvolvabilityTests.addAndRemoveParameters";
        URL uRL = url = EvolvabilityTests.class.getResource(resource);
        Intrinsics.checkExpressionValueIsNotNull((Object)uRL, (String)"url");
        byte[] sc2 = TextStreamsKt.readBytes((URL)uRL);
        DeserializationInput deserializationInput = new DeserializationInput(sf);
        SerializedBytes bytes$iv = new SerializedBytes(sc2);
        SerializationContext context$iv = null;
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001f\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J.\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0012J\u0013\u0010\u0013\u001a\u00020\u00052\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"net/corda/serialization/internal/amqp/EvolvabilityTests$addAndRemoveParameters$CC", "", "a", "", "e", "", "d", "(ILjava/lang/Boolean;I)V", "getA", "()I", "getD", "getE", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "component1", "component2", "component3", "copy", "(ILjava/lang/Boolean;I)Lnet/corda/serialization/internal/amqp/EvolvabilityTests$addAndRemoveParameters$CC;", "equals", "other", "hashCode", "toString", "", "serialization"})
        public final class CC {
            private final int a;
            @Nullable
            private final Boolean e;
            private final int d;

            public final int getA() {
                return this.a;
            }

            @Nullable
            public final Boolean getE() {
                return this.e;
            }

            public final int getD() {
                return this.d;
            }

            public CC(int a, @Nullable Boolean e2, int d) {
                this.a = a;
                this.e = e2;
                this.d = d;
            }

            public final int component1() {
                return this.a;
            }

            @Nullable
            public final Boolean component2() {
                return this.e;
            }

            public final int component3() {
                return this.d;
            }

            @NotNull
            public final CC copy(int a, @Nullable Boolean e2, int d) {
                return new CC(a, e2, d);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ CC copy$default(CC cC, int n, Boolean bl, int n2, int n3, Object object) {
                if ((n3 & 1) != 0) {
                    n = cC.a;
                }
                if ((n3 & 2) != 0) {
                    bl = cC.e;
                }
                if ((n3 & 4) != 0) {
                    n2 = cC.d;
                }
                return cC.copy(n, bl, n2);
            }

            @NotNull
            public String toString() {
                return "CC(a=" + this.a + ", e=" + this.e + ", d=" + this.d + ")";
            }

            public int hashCode() {
                Boolean bl = this.e;
                return (Integer.hashCode(this.a) * 31 + (bl != null ? ((Object)bl).hashCode() : 0)) * 31 + Integer.hashCode(this.d);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof CC)) break block3;
                        CC cC = (CC)object;
                        if (!(this.a == cC.a) || !Intrinsics.areEqual((Object)this.e, (Object)cC.e) || !(this.d == cC.d)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        CC deserializedCC = (CC)$receiver$iv.deserialize((ByteSequence)bytes$iv, CC.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)A2, (Object)deserializedCC.getA(), null, (int)4, null);
        AssertionsKt.assertEquals$default(E, (Object)deserializedCC.getE(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)D2, (Object)deserializedCC.getD(), null, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void addMandatoryFieldWithAltConstructor() {
        void $receiver$iv;
        URL url;
        SerializerFactory sf = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        int A2 = 1;
        String resource = "EvolvabilityTests.addMandatoryFieldWithAltConstructor";
        URL uRL = url = EvolvabilityTests.class.getResource(resource);
        Intrinsics.checkExpressionValueIsNotNull((Object)uRL, (String)"url");
        byte[] sc2 = TextStreamsKt.readBytes((URL)uRL);
        DeserializationInput deserializationInput = new DeserializationInput(sf);
        SerializedBytes bytes$iv = new SerializedBytes(sc2);
        SerializationContext context$iv = null;
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000#\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u000f\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0006H\u00c6\u0003J\"\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"net/corda/serialization/internal/amqp/EvolvabilityTests$addMandatoryFieldWithAltConstructor$CC", "", "a", "", "(I)V", "b", "", "(ILjava/lang/String;)V", "getA", "()I", "getB", "()Ljava/lang/String;", "component1", "component2", "copy", "(ILjava/lang/String;)Lnet/corda/serialization/internal/amqp/EvolvabilityTests$addMandatoryFieldWithAltConstructor$CC;", "equals", "", "other", "hashCode", "toString", "serialization"})
        public final class CC {
            private final int a;
            @NotNull
            private final String b;

            public final int getA() {
                return this.a;
            }

            @NotNull
            public final String getB() {
                return this.b;
            }

            public CC(int a, @NotNull String b) {
                Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
                this.a = a;
                this.b = b;
            }

            @DeprecatedConstructorForDeserialization(version=1)
            public CC(int a) {
                this(a, "hello");
            }

            public final int component1() {
                return this.a;
            }

            @NotNull
            public final String component2() {
                return this.b;
            }

            @NotNull
            public final CC copy(int a, @NotNull String b) {
                Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
                return new CC(a, b);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ CC copy$default(CC cC, int n, String string, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = cC.a;
                }
                if ((n2 & 2) != 0) {
                    string = cC.b;
                }
                return cC.copy(n, string);
            }

            @NotNull
            public String toString() {
                return "CC(a=" + this.a + ", b=" + this.b + ")";
            }

            public int hashCode() {
                String string = this.b;
                return Integer.hashCode(this.a) * 31 + (string != null ? string.hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof CC)) break block3;
                        CC cC = (CC)object;
                        if (!(this.a == cC.a) || !Intrinsics.areEqual((Object)this.b, (Object)cC.b)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        CC deserializedCC = (CC)$receiver$iv.deserialize((ByteSequence)bytes$iv, CC.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)A2, (Object)deserializedCC.getA(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)"hello", (Object)deserializedCC.getB(), null, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void addMandatoryFieldWithAltConstructorForceReorder() {
        void $receiver$iv;
        SerializerFactory sf = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        int z = 30;
        int y = 20;
        String resource = "EvolvabilityTests.addMandatoryFieldWithAltConstructorForceReorder";
        URL url = EvolvabilityTests.class.getResource(resource);
        DeserializationInput deserializationInput = new DeserializationInput(sf);
        URL uRL = url;
        Intrinsics.checkExpressionValueIsNotNull((Object)uRL, (String)"url");
        SerializedBytes bytes$iv = new SerializedBytes(TextStreamsKt.readBytes((URL)uRL));
        SerializationContext context$iv = null;
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000#\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0004*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0017\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0007H\u00c6\u0003J,\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0012J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0018"}, d2={"net/corda/serialization/internal/amqp/EvolvabilityTests$addMandatoryFieldWithAltConstructorForceReorder$CC", "", "z", "", "y", "(II)V", "a", "", "(IILjava/lang/String;)V", "getA", "()Ljava/lang/String;", "getY", "()I", "getZ", "component1", "component2", "component3", "copy", "(IILjava/lang/String;)Lnet/corda/serialization/internal/amqp/EvolvabilityTests$addMandatoryFieldWithAltConstructorForceReorder$CC;", "equals", "", "other", "hashCode", "toString", "serialization"})
        public final class CC {
            private final int z;
            private final int y;
            @NotNull
            private final String a;

            public final int getZ() {
                return this.z;
            }

            public final int getY() {
                return this.y;
            }

            @NotNull
            public final String getA() {
                return this.a;
            }

            public CC(int z, int y, @NotNull String a) {
                Intrinsics.checkParameterIsNotNull((Object)a, (String)"a");
                this.z = z;
                this.y = y;
                this.a = a;
            }

            @DeprecatedConstructorForDeserialization(version=1)
            public CC(int z, int y) {
                this(z, y, "10");
            }

            public final int component1() {
                return this.z;
            }

            public final int component2() {
                return this.y;
            }

            @NotNull
            public final String component3() {
                return this.a;
            }

            @NotNull
            public final CC copy(int z, int y, @NotNull String a) {
                Intrinsics.checkParameterIsNotNull((Object)a, (String)"a");
                return new CC(z, y, a);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ CC copy$default(CC cC, int n, int n2, String string, int n3, Object object) {
                if ((n3 & 1) != 0) {
                    n = cC.z;
                }
                if ((n3 & 2) != 0) {
                    n2 = cC.y;
                }
                if ((n3 & 4) != 0) {
                    string = cC.a;
                }
                return cC.copy(n, n2, string);
            }

            @NotNull
            public String toString() {
                return "CC(z=" + this.z + ", y=" + this.y + ", a=" + this.a + ")";
            }

            public int hashCode() {
                String string = this.a;
                return (Integer.hashCode(this.z) * 31 + Integer.hashCode(this.y)) * 31 + (string != null ? string.hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof CC)) break block3;
                        CC cC = (CC)object;
                        if (!(this.z == cC.z) || !(this.y == cC.y) || !Intrinsics.areEqual((Object)this.a, (Object)cC.a)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        CC deserializedCC = (CC)$receiver$iv.deserialize((ByteSequence)bytes$iv, CC.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)"10", (Object)deserializedCC.getA(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)y, (Object)deserializedCC.getY(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)z, (Object)deserializedCC.getZ(), null, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void moreComplexNonNullWithReorder() {
        void $receiver$iv;
        SerializerFactory serializerFactory;
        String resource = this.getClass().getSimpleName() + '.' + AMQPTestUtilsKt.testName();
        SerializerFactory $receiver = serializerFactory = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        $receiver.register((CustomSerializer)new InstantSerializer($receiver));
        SerializerFactory factory = serializerFactory;
        URL url = EvolvabilityTests.class.getResource(resource);
        $receiver = new DeserializationInput(factory);
        URL uRL = url;
        Intrinsics.checkExpressionValueIsNotNull((Object)uRL, (String)"url");
        SerializedBytes bytes$iv = new SerializedBytes(TextStreamsKt.readBytes((URL)uRL));
        SerializationContext context$iv = null;
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00005\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u001a\n\u0002\u0010\u000b\n\u0002\b\u0004*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001BW\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00050\r\u00a2\u0006\u0002\u0010\u000eB]\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00050\r\u0012\u0006\u0010\u000f\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0010J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\nH\u00c6\u0003J\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\u001b\u0010#\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00050\rH\u00c6\u0003J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003Jv\u0010%\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\u00032\u001a\b\u0002\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00050\r2\b\b\u0002\u0010\u000f\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010&J\u0013\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010*\u001a\u00020\u0003H\u00d6\u0001J\t\u0010+\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u000f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR#\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00050\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006,"}, d2={"net/corda/serialization/internal/amqp/EvolvabilityTests$moreComplexNonNullWithReorder$NetworkParametersExample", "", "minimumPlatformVersion", "", "notaries", "", "", "maxMessageSize", "maxTransactionSize", "modifiedTime", "Ljava/time/Instant;", "epoch", "whitelistedContractImplementations", "", "(ILjava/util/List;IILjava/time/Instant;ILjava/util/Map;)V", "eventHorizon", "(ILjava/util/List;IILjava/time/Instant;ILjava/util/Map;I)V", "getEpoch", "()I", "getEventHorizon", "getMaxMessageSize", "getMaxTransactionSize", "getMinimumPlatformVersion", "getModifiedTime", "()Ljava/time/Instant;", "getNotaries", "()Ljava/util/List;", "getWhitelistedContractImplementations", "()Ljava/util/Map;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "(ILjava/util/List;IILjava/time/Instant;ILjava/util/Map;I)Lnet/corda/serialization/internal/amqp/EvolvabilityTests$moreComplexNonNullWithReorder$NetworkParametersExample;", "equals", "", "other", "hashCode", "toString", "serialization"})
        public final class NetworkParametersExample {
            private final int minimumPlatformVersion;
            @NotNull
            private final List<String> notaries;
            private final int maxMessageSize;
            private final int maxTransactionSize;
            @NotNull
            private final Instant modifiedTime;
            private final int epoch;
            @NotNull
            private final Map<String, List<Integer>> whitelistedContractImplementations;
            private final int eventHorizon;

            public final int getMinimumPlatformVersion() {
                return this.minimumPlatformVersion;
            }

            @NotNull
            public final List<String> getNotaries() {
                return this.notaries;
            }

            public final int getMaxMessageSize() {
                return this.maxMessageSize;
            }

            public final int getMaxTransactionSize() {
                return this.maxTransactionSize;
            }

            @NotNull
            public final Instant getModifiedTime() {
                return this.modifiedTime;
            }

            public final int getEpoch() {
                return this.epoch;
            }

            @NotNull
            public final Map<String, List<Integer>> getWhitelistedContractImplementations() {
                return this.whitelistedContractImplementations;
            }

            public final int getEventHorizon() {
                return this.eventHorizon;
            }

            public NetworkParametersExample(int minimumPlatformVersion, @NotNull List<String> notaries, int maxMessageSize, int maxTransactionSize, @NotNull Instant modifiedTime, int epoch, @NotNull Map<String, ? extends List<Integer>> whitelistedContractImplementations, int eventHorizon) {
                Intrinsics.checkParameterIsNotNull(notaries, (String)"notaries");
                Intrinsics.checkParameterIsNotNull((Object)modifiedTime, (String)"modifiedTime");
                Intrinsics.checkParameterIsNotNull(whitelistedContractImplementations, (String)"whitelistedContractImplementations");
                this.minimumPlatformVersion = minimumPlatformVersion;
                this.notaries = notaries;
                this.maxMessageSize = maxMessageSize;
                this.maxTransactionSize = maxTransactionSize;
                this.modifiedTime = modifiedTime;
                this.epoch = epoch;
                this.whitelistedContractImplementations = whitelistedContractImplementations;
                this.eventHorizon = eventHorizon;
            }

            @DeprecatedConstructorForDeserialization(version=1)
            public NetworkParametersExample(int minimumPlatformVersion, @NotNull List<String> notaries, int maxMessageSize, int maxTransactionSize, @NotNull Instant modifiedTime, int epoch, @NotNull Map<String, ? extends List<Integer>> whitelistedContractImplementations) {
                Intrinsics.checkParameterIsNotNull(notaries, (String)"notaries");
                Intrinsics.checkParameterIsNotNull((Object)modifiedTime, (String)"modifiedTime");
                Intrinsics.checkParameterIsNotNull(whitelistedContractImplementations, (String)"whitelistedContractImplementations");
                this(minimumPlatformVersion, notaries, maxMessageSize, maxTransactionSize, modifiedTime, epoch, whitelistedContractImplementations, Integer.MAX_VALUE);
            }

            public final int component1() {
                return this.minimumPlatformVersion;
            }

            @NotNull
            public final List<String> component2() {
                return this.notaries;
            }

            public final int component3() {
                return this.maxMessageSize;
            }

            public final int component4() {
                return this.maxTransactionSize;
            }

            @NotNull
            public final Instant component5() {
                return this.modifiedTime;
            }

            public final int component6() {
                return this.epoch;
            }

            @NotNull
            public final Map<String, List<Integer>> component7() {
                return this.whitelistedContractImplementations;
            }

            public final int component8() {
                return this.eventHorizon;
            }

            @NotNull
            public final NetworkParametersExample copy(int minimumPlatformVersion, @NotNull List<String> notaries, int maxMessageSize, int maxTransactionSize, @NotNull Instant modifiedTime, int epoch, @NotNull Map<String, ? extends List<Integer>> whitelistedContractImplementations, int eventHorizon) {
                Intrinsics.checkParameterIsNotNull(notaries, (String)"notaries");
                Intrinsics.checkParameterIsNotNull((Object)modifiedTime, (String)"modifiedTime");
                Intrinsics.checkParameterIsNotNull(whitelistedContractImplementations, (String)"whitelistedContractImplementations");
                return new NetworkParametersExample(minimumPlatformVersion, notaries, maxMessageSize, maxTransactionSize, modifiedTime, epoch, whitelistedContractImplementations, eventHorizon);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ NetworkParametersExample copy$default(NetworkParametersExample networkParametersExample, int n, List list, int n2, int n3, Instant instant, int n4, Map map, int n5, int n6, Object object) {
                if ((n6 & 1) != 0) {
                    n = networkParametersExample.minimumPlatformVersion;
                }
                if ((n6 & 2) != 0) {
                    list = networkParametersExample.notaries;
                }
                if ((n6 & 4) != 0) {
                    n2 = networkParametersExample.maxMessageSize;
                }
                if ((n6 & 8) != 0) {
                    n3 = networkParametersExample.maxTransactionSize;
                }
                if ((n6 & 0x10) != 0) {
                    instant = networkParametersExample.modifiedTime;
                }
                if ((n6 & 0x20) != 0) {
                    n4 = networkParametersExample.epoch;
                }
                if ((n6 & 0x40) != 0) {
                    map = networkParametersExample.whitelistedContractImplementations;
                }
                if ((n6 & 0x80) != 0) {
                    n5 = networkParametersExample.eventHorizon;
                }
                return networkParametersExample.copy(n, list, n2, n3, instant, n4, map, n5);
            }

            @NotNull
            public String toString() {
                return "NetworkParametersExample(minimumPlatformVersion=" + this.minimumPlatformVersion + ", notaries=" + this.notaries + ", maxMessageSize=" + this.maxMessageSize + ", maxTransactionSize=" + this.maxTransactionSize + ", modifiedTime=" + this.modifiedTime + ", epoch=" + this.epoch + ", whitelistedContractImplementations=" + this.whitelistedContractImplementations + ", eventHorizon=" + this.eventHorizon + ")";
            }

            public int hashCode() {
                List<String> list = this.notaries;
                Instant instant = this.modifiedTime;
                Map<String, List<Integer>> map = this.whitelistedContractImplementations;
                return ((((((Integer.hashCode(this.minimumPlatformVersion) * 31 + (list != null ? ((Object)list).hashCode() : 0)) * 31 + Integer.hashCode(this.maxMessageSize)) * 31 + Integer.hashCode(this.maxTransactionSize)) * 31 + (instant != null ? ((Object)instant).hashCode() : 0)) * 31 + Integer.hashCode(this.epoch)) * 31 + (map != null ? ((Object)map).hashCode() : 0)) * 31 + Integer.hashCode(this.eventHorizon);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof NetworkParametersExample)) break block3;
                        NetworkParametersExample networkParametersExample = (NetworkParametersExample)object;
                        if (!(this.minimumPlatformVersion == networkParametersExample.minimumPlatformVersion) || !Intrinsics.areEqual(this.notaries, networkParametersExample.notaries) || !(this.maxMessageSize == networkParametersExample.maxMessageSize) || !(this.maxTransactionSize == networkParametersExample.maxTransactionSize) || !Intrinsics.areEqual((Object)this.modifiedTime, (Object)networkParametersExample.modifiedTime) || !(this.epoch == networkParametersExample.epoch) || !Intrinsics.areEqual(this.whitelistedContractImplementations, networkParametersExample.whitelistedContractImplementations) || !(this.eventHorizon == networkParametersExample.eventHorizon)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        $receiver$iv.deserialize((ByteSequence)bytes$iv, NetworkParametersExample.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
    }

    /*
     * WARNING - void declaration
     */
    @Test(expected=NotSerializableException.class, timeout=300000L)
    public final void addMandatoryFieldWithAltConstructorUnAnnotated() {
        void $receiver$iv;
        SerializerFactory sf = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        URL url = EvolvabilityTests.class.getResource("EvolvabilityTests.addMandatoryFieldWithAltConstructorUnAnnotated");
        boolean A2 = true;
        DeserializationInput deserializationInput = new DeserializationInput(sf);
        URL uRL = url;
        Intrinsics.checkExpressionValueIsNotNull((Object)uRL, (String)"url");
        SerializedBytes bytes$iv = new SerializedBytes(TextStreamsKt.readBytes((URL)uRL));
        SerializationContext context$iv = null;
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000#\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0006H\u00c6\u0003J\"\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"net/corda/serialization/internal/amqp/EvolvabilityTests$addMandatoryFieldWithAltConstructorUnAnnotated$CC", "", "a", "", "(I)V", "b", "", "(ILjava/lang/String;)V", "getA", "()I", "getB", "()Ljava/lang/String;", "component1", "component2", "copy", "(ILjava/lang/String;)Lnet/corda/serialization/internal/amqp/EvolvabilityTests$addMandatoryFieldWithAltConstructorUnAnnotated$CC;", "equals", "", "other", "hashCode", "toString", "serialization"})
        public final class CC {
            private final int a;
            @NotNull
            private final String b;

            public final int getA() {
                return this.a;
            }

            @NotNull
            public final String getB() {
                return this.b;
            }

            public CC(int a, @NotNull String b) {
                Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
                this.a = a;
                this.b = b;
            }

            public CC(int a) {
                this(a, "hello");
            }

            public final int component1() {
                return this.a;
            }

            @NotNull
            public final String component2() {
                return this.b;
            }

            @NotNull
            public final CC copy(int a, @NotNull String b) {
                Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
                return new CC(a, b);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ CC copy$default(CC cC, int n, String string, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = cC.a;
                }
                if ((n2 & 2) != 0) {
                    string = cC.b;
                }
                return cC.copy(n, string);
            }

            @NotNull
            public String toString() {
                return "CC(a=" + this.a + ", b=" + this.b + ")";
            }

            public int hashCode() {
                String string = this.b;
                return Integer.hashCode(this.a) * 31 + (string != null ? string.hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof CC)) break block3;
                        CC cC = (CC)object;
                        if (!(this.a == cC.a) || !Intrinsics.areEqual((Object)this.b, (Object)cC.b)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        $receiver$iv.deserialize((ByteSequence)bytes$iv, CC.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void addMandatoryFieldWithAltReorderedConstructor() {
        void $receiver$iv;
        URL url;
        SerializerFactory sf = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        String resource = "EvolvabilityTests.addMandatoryFieldWithAltReorderedConstructor";
        int A2 = 1;
        int B4 = 100;
        String C5 = "This is not a banana";
        URL uRL = url = EvolvabilityTests.class.getResource(resource);
        Intrinsics.checkExpressionValueIsNotNull((Object)uRL, (String)"url");
        byte[] sc2 = TextStreamsKt.readBytes((URL)uRL);
        DeserializationInput deserializationInput = new DeserializationInput(sf);
        SerializedBytes bytes$iv = new SerializedBytes(sc2);
        SerializationContext context$iv = null;
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000!\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0004*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u001f\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007B%\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J6\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0015J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000e\u00a8\u0006\u001b"}, d2={"net/corda/serialization/internal/amqp/EvolvabilityTests$addMandatoryFieldWithAltReorderedConstructor$CC", "", "c", "", "a", "", "b", "(Ljava/lang/String;II)V", "d", "(IILjava/lang/String;Ljava/lang/String;)V", "getA", "()I", "getB", "getC", "()Ljava/lang/String;", "getD", "component1", "component2", "component3", "component4", "copy", "(IILjava/lang/String;Ljava/lang/String;)Lnet/corda/serialization/internal/amqp/EvolvabilityTests$addMandatoryFieldWithAltReorderedConstructor$CC;", "equals", "", "other", "hashCode", "toString", "serialization"})
        public final class CC {
            private final int a;
            private final int b;
            @NotNull
            private final String c;
            @NotNull
            private final String d;

            public final int getA() {
                return this.a;
            }

            public final int getB() {
                return this.b;
            }

            @NotNull
            public final String getC() {
                return this.c;
            }

            @NotNull
            public final String getD() {
                return this.d;
            }

            public CC(int a, int b, @NotNull String c, @NotNull String d) {
                Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
                Intrinsics.checkParameterIsNotNull((Object)d, (String)"d");
                this.a = a;
                this.b = b;
                this.c = c;
                this.d = d;
            }

            @DeprecatedConstructorForDeserialization(version=1)
            public CC(@NotNull String c, int a, int b) {
                Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
                this(a, b, c, "wibble");
            }

            public final int component1() {
                return this.a;
            }

            public final int component2() {
                return this.b;
            }

            @NotNull
            public final String component3() {
                return this.c;
            }

            @NotNull
            public final String component4() {
                return this.d;
            }

            @NotNull
            public final CC copy(int a, int b, @NotNull String c, @NotNull String d) {
                Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
                Intrinsics.checkParameterIsNotNull((Object)d, (String)"d");
                return new CC(a, b, c, d);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ CC copy$default(CC cC, int n, int n2, String string, String string2, int n3, Object object) {
                if ((n3 & 1) != 0) {
                    n = cC.a;
                }
                if ((n3 & 2) != 0) {
                    n2 = cC.b;
                }
                if ((n3 & 4) != 0) {
                    string = cC.c;
                }
                if ((n3 & 8) != 0) {
                    string2 = cC.d;
                }
                return cC.copy(n, n2, string, string2);
            }

            @NotNull
            public String toString() {
                return "CC(a=" + this.a + ", b=" + this.b + ", c=" + this.c + ", d=" + this.d + ")";
            }

            public int hashCode() {
                String string = this.c;
                String string2 = this.d;
                return ((Integer.hashCode(this.a) * 31 + Integer.hashCode(this.b)) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof CC)) break block3;
                        CC cC = (CC)object;
                        if (!(this.a == cC.a) || !(this.b == cC.b) || !Intrinsics.areEqual((Object)this.c, (Object)cC.c) || !Intrinsics.areEqual((Object)this.d, (Object)cC.d)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        CC deserializedCC = (CC)$receiver$iv.deserialize((ByteSequence)bytes$iv, CC.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)A2, (Object)deserializedCC.getA(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)B4, (Object)deserializedCC.getB(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)C5, (Object)deserializedCC.getC(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)"wibble", (Object)deserializedCC.getD(), null, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void addMandatoryFieldWithAltReorderedConstructorAndRemoval() {
        void $receiver$iv;
        URL url;
        SerializerFactory sf = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        String resource = "EvolvabilityTests.addMandatoryFieldWithAltReorderedConstructorAndRemoval";
        int A2 = 1;
        int B4 = 100;
        String C5 = "This is not a banana";
        URL uRL = url = EvolvabilityTests.class.getResource(resource);
        Intrinsics.checkExpressionValueIsNotNull((Object)uRL, (String)"url");
        byte[] sc2 = TextStreamsKt.readBytes((URL)uRL);
        DeserializationInput deserializationInput = new DeserializationInput(sf);
        SerializedBytes bytes$iv = new SerializedBytes(sc2);
        SerializationContext context$iv = null;
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000!\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0004*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0017\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J,\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0012J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0018"}, d2={"net/corda/serialization/internal/amqp/EvolvabilityTests$addMandatoryFieldWithAltReorderedConstructorAndRemoval$CC", "", "c", "", "a", "", "(Ljava/lang/String;I)V", "d", "(ILjava/lang/String;Ljava/lang/String;)V", "getA", "()I", "getC", "()Ljava/lang/String;", "getD", "component1", "component2", "component3", "copy", "(ILjava/lang/String;Ljava/lang/String;)Lnet/corda/serialization/internal/amqp/EvolvabilityTests$addMandatoryFieldWithAltReorderedConstructorAndRemoval$CC;", "equals", "", "other", "hashCode", "toString", "serialization"})
        public final class CC {
            private final int a;
            @NotNull
            private final String c;
            @NotNull
            private final String d;

            public final int getA() {
                return this.a;
            }

            @NotNull
            public final String getC() {
                return this.c;
            }

            @NotNull
            public final String getD() {
                return this.d;
            }

            public CC(int a, @NotNull String c, @NotNull String d) {
                Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
                Intrinsics.checkParameterIsNotNull((Object)d, (String)"d");
                this.a = a;
                this.c = c;
                this.d = d;
            }

            @DeprecatedConstructorForDeserialization(version=1)
            public CC(@NotNull String c, int a) {
                Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
                this(a, c, "wibble");
            }

            public final int component1() {
                return this.a;
            }

            @NotNull
            public final String component2() {
                return this.c;
            }

            @NotNull
            public final String component3() {
                return this.d;
            }

            @NotNull
            public final CC copy(int a, @NotNull String c, @NotNull String d) {
                Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
                Intrinsics.checkParameterIsNotNull((Object)d, (String)"d");
                return new CC(a, c, d);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ CC copy$default(CC cC, int n, String string, String string2, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = cC.a;
                }
                if ((n2 & 2) != 0) {
                    string = cC.c;
                }
                if ((n2 & 4) != 0) {
                    string2 = cC.d;
                }
                return cC.copy(n, string, string2);
            }

            @NotNull
            public String toString() {
                return "CC(a=" + this.a + ", c=" + this.c + ", d=" + this.d + ")";
            }

            public int hashCode() {
                String string = this.c;
                String string2 = this.d;
                return (Integer.hashCode(this.a) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof CC)) break block3;
                        CC cC = (CC)object;
                        if (!(this.a == cC.a) || !Intrinsics.areEqual((Object)this.c, (Object)cC.c) || !Intrinsics.areEqual((Object)this.d, (Object)cC.d)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        CC deserializedCC = (CC)$receiver$iv.deserialize((ByteSequence)bytes$iv, CC.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)A2, (Object)deserializedCC.getA(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)C5, (Object)deserializedCC.getC(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)"wibble", (Object)deserializedCC.getD(), null, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void multiVersion() {
        void $receiver$iv;
        void $receiver$iv2;
        void $receiver$iv3;
        SerializerFactory sf = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        String resource1 = "EvolvabilityTests.multiVersion.1";
        String resource2 = "EvolvabilityTests.multiVersion.2";
        String resource3 = "EvolvabilityTests.multiVersion.3";
        int a = 100;
        int b = 200;
        int c = 300;
        int d = 400;
        URL url1 = EvolvabilityTests.class.getResource(resource1);
        URL url2 = EvolvabilityTests.class.getResource(resource2);
        URL url3 = EvolvabilityTests.class.getResource(resource3);
        URL uRL = url1;
        Intrinsics.checkExpressionValueIsNotNull((Object)uRL, (String)"url1");
        byte[] sb1 = TextStreamsKt.readBytes((URL)uRL);
        DeserializationInput deserializationInput = new DeserializationInput(sf);
        SerializedBytes bytes$iv = new SerializedBytes(sb1);
        SerializationContext context$iv = null;
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000!\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0017\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u001f\b\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007B'\b\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tB-\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J@\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\n\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0018J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\r\u00a8\u0006\u001f"}, d2={"net/corda/serialization/internal/amqp/EvolvabilityTests$multiVersion$C", "", "b", "", "a", "(II)V", "c", "(III)V", "d", "(IIII)V", "e", "(IIIII)V", "getA", "()I", "getB", "getC", "getD", "getE", "component1", "component2", "component3", "component4", "component5", "copy", "(IIIII)Lnet/corda/serialization/internal/amqp/EvolvabilityTests$multiVersion$C;", "equals", "", "other", "hashCode", "toString", "", "serialization"})
        public final class C {
            private final int e;
            private final int c;
            private final int b;
            private final int a;
            private final int d;

            public final int getE() {
                return this.e;
            }

            public final int getC() {
                return this.c;
            }

            public final int getB() {
                return this.b;
            }

            public final int getA() {
                return this.a;
            }

            public final int getD() {
                return this.d;
            }

            public C(int e2, int c, int b, int a, int d) {
                this.e = e2;
                this.c = c;
                this.b = b;
                this.a = a;
                this.d = d;
            }

            @DeprecatedConstructorForDeserialization(version=1)
            public C(int b, int a) {
                this(-1, -1, b, a, -1);
            }

            @DeprecatedConstructorForDeserialization(version=2)
            public C(int a, int c, int b) {
                this(-1, c, b, a, -1);
            }

            @DeprecatedConstructorForDeserialization(version=3)
            public C(int a, int b, int c, int d) {
                this(-1, c, b, a, d);
            }

            public final int component1() {
                return this.e;
            }

            public final int component2() {
                return this.c;
            }

            public final int component3() {
                return this.b;
            }

            public final int component4() {
                return this.a;
            }

            public final int component5() {
                return this.d;
            }

            @NotNull
            public final C copy(int e2, int c, int b, int a, int d) {
                return new C(e2, c, b, a, d);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ C copy$default(C c, int n, int n2, int n3, int n4, int n5, int n6, Object object) {
                if ((n6 & 1) != 0) {
                    n = c.e;
                }
                if ((n6 & 2) != 0) {
                    n2 = c.c;
                }
                if ((n6 & 4) != 0) {
                    n3 = c.b;
                }
                if ((n6 & 8) != 0) {
                    n4 = c.a;
                }
                if ((n6 & 0x10) != 0) {
                    n5 = c.d;
                }
                return c.copy(n, n2, n3, n4, n5);
            }

            @NotNull
            public String toString() {
                return "C(e=" + this.e + ", c=" + this.c + ", b=" + this.b + ", a=" + this.a + ", d=" + this.d + ")";
            }

            public int hashCode() {
                return (((Integer.hashCode(this.e) * 31 + Integer.hashCode(this.c)) * 31 + Integer.hashCode(this.b)) * 31 + Integer.hashCode(this.a)) * 31 + Integer.hashCode(this.d);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof C)) break block3;
                        C c = (C)object;
                        if (!(this.e == c.e) || !(this.c == c.c) || !(this.b == c.b) || !(this.a == c.a) || !(this.d == c.d)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        C db1 = (C)$receiver$iv3.deserialize((ByteSequence)bytes$iv, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)a, (Object)db1.getA(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)b, (Object)db1.getB(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)-1, (Object)db1.getC(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)-1, (Object)db1.getD(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)-1, (Object)db1.getE(), null, (int)4, null);
        URL uRL2 = url2;
        Intrinsics.checkExpressionValueIsNotNull((Object)uRL2, (String)"url2");
        byte[] sb2 = TextStreamsKt.readBytes((URL)uRL2);
        context$iv = new DeserializationInput(sf);
        SerializedBytes bytes$iv2 = new SerializedBytes(sb2);
        SerializationContext context$iv2 = null;
        C db2 = (C)$receiver$iv2.deserialize((ByteSequence)bytes$iv2, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)a, (Object)db2.getA(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)b, (Object)db2.getB(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)c, (Object)db2.getC(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)-1, (Object)db2.getD(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)-1, (Object)db2.getE(), null, (int)4, null);
        URL uRL3 = url3;
        Intrinsics.checkExpressionValueIsNotNull((Object)uRL3, (String)"url3");
        byte[] sb3 = TextStreamsKt.readBytes((URL)uRL3);
        context$iv2 = new DeserializationInput(sf);
        SerializedBytes bytes$iv3 = new SerializedBytes(sb3);
        SerializationContext context$iv3 = null;
        C db3 = (C)$receiver$iv.deserialize((ByteSequence)bytes$iv3, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)a, (Object)db3.getA(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)b, (Object)db3.getB(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)c, (Object)db3.getC(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)d, (Object)db3.getD(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)-1, (Object)db3.getE(), null, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void changeSubType() {
        void $receiver$iv;
        void $receiver$iv2;
        URL url;
        SerializerFactory sf = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        String resource = "EvolvabilityTests.changeSubType";
        int oa = 100;
        int ia = 200;
        URL uRL = url = EvolvabilityTests.class.getResource(resource);
        Intrinsics.checkExpressionValueIsNotNull((Object)uRL, (String)"url");
        byte[] sc2 = TextStreamsKt.readBytes((URL)uRL);
        DeserializationInput deserializationInput = new DeserializationInput(sf);
        SerializedBytes bytes$iv = new SerializedBytes(sc2);
        SerializationContext context$iv = null;
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000*\u0002\u0000\u0005\b\u008a\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000e\u0010\r\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\nJ\"\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"net/corda/serialization/internal/amqp/EvolvabilityTests$changeSubType$Outer", "", "a", "", "b", "net/corda/serialization/internal/amqp/EvolvabilityTests$changeSubType$Inner", "(ILnet/corda/serialization/internal/amqp/EvolvabilityTests$changeSubType$Inner;)V", "getA", "()I", "getB", "()Lnet/corda/serialization/internal/amqp/EvolvabilityTests$changeSubType$Inner;", "Lnet/corda/serialization/internal/amqp/EvolvabilityTests$changeSubType$Inner;", "component1", "component2", "copy", "(ILnet/corda/serialization/internal/amqp/EvolvabilityTests$changeSubType$Inner;)Lnet/corda/serialization/internal/amqp/EvolvabilityTests$changeSubType$Outer;", "equals", "", "other", "hashCode", "toString", "", "serialization"})
        public final class Outer {
            private final int a;
            @NotNull
            private final Inner b;

            public final int getA() {
                return this.a;
            }

            @NotNull
            public final Inner getB() {
                @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000!\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J$\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000eJ\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"net/corda/serialization/internal/amqp/EvolvabilityTests$changeSubType$Inner", "", "a", "", "b", "", "(ILjava/lang/String;)V", "getA", "()I", "getB", "()Ljava/lang/String;", "component1", "component2", "copy", "(ILjava/lang/String;)Lnet/corda/serialization/internal/amqp/EvolvabilityTests$changeSubType$Inner;", "equals", "", "other", "hashCode", "toString", "serialization"})
                public final class Inner {
                    private final int a;
                    @Nullable
                    private final String b;

                    public final int getA() {
                        return this.a;
                    }

                    @Nullable
                    public final String getB() {
                        return this.b;
                    }

                    public Inner(int a, @Nullable String b) {
                        this.a = a;
                        this.b = b;
                    }

                    public final int component1() {
                        return this.a;
                    }

                    @Nullable
                    public final String component2() {
                        return this.b;
                    }

                    @NotNull
                    public final Inner copy(int a, @Nullable String b) {
                        return new Inner(a, b);
                    }

                    @NotNull
                    public static /* bridge */ /* synthetic */ Inner copy$default(Inner inner, int n, String string, int n2, Object object) {
                        if ((n2 & 1) != 0) {
                            n = inner.a;
                        }
                        if ((n2 & 2) != 0) {
                            string = inner.b;
                        }
                        return inner.copy(n, string);
                    }

                    @NotNull
                    public String toString() {
                        return "Inner(a=" + this.a + ", b=" + this.b + ")";
                    }

                    public int hashCode() {
                        String string = this.b;
                        return Integer.hashCode(this.a) * 31 + (string != null ? string.hashCode() : 0);
                    }

                    public boolean equals(@Nullable Object object) {
                        block3: {
                            block2: {
                                if (this == object) break block2;
                                if (!(object instanceof Inner)) break block3;
                                Inner inner = (Inner)object;
                                if (!(this.a == inner.a) || !Intrinsics.areEqual((Object)this.b, (Object)inner.b)) break block3;
                            }
                            return true;
                        }
                        return false;
                    }
                }
                return this.b;
            }

            public Outer(int a, @NotNull Inner b) {
                Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
                this.a = a;
                this.b = b;
            }

            public final int component1() {
                return this.a;
            }

            @NotNull
            public final Inner component2() {
                return this.b;
            }

            @NotNull
            public final Outer copy(int a, @NotNull Inner b) {
                Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
                return new Outer(a, b);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ Outer copy$default(Outer outer2, int n, Inner inner, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = outer2.a;
                }
                if ((n2 & 2) != 0) {
                    inner = outer2.b;
                }
                return outer2.copy(n, inner);
            }

            @NotNull
            public String toString() {
                return "Outer(a=" + this.a + ", b=" + this.b + ")";
            }

            public int hashCode() {
                Inner inner = this.b;
                return Integer.hashCode(this.a) * 31 + (inner != null ? ((Object)inner).hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Outer)) break block3;
                        Outer outer2 = (Outer)object;
                        if (!(this.a == outer2.a) || !Intrinsics.areEqual((Object)this.b, (Object)outer2.b)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        Outer outer2 = (Outer)$receiver$iv2.deserialize((ByteSequence)bytes$iv, Outer.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)oa, (Object)outer2.getA(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)ia, (Object)outer2.getB().getA(), null, (int)4, null);
        AssertionsKt.assertEquals$default(null, (Object)outer2.getB().getB(), null, (int)4, null);
        BytesAndSchemas newVersion = AMQPTestUtilsKt.serializeAndReturnSchema$default(new SerializationOutput((LocalSerializerFactory)sf), new Outer(oa, new Inner(ia, "new value")), null, 2, null);
        AMQPRemoteTypeModel model = new AMQPRemoteTypeModel();
        Map remoteTypeInfo = model.interpret(new SerializationSchemas(newVersion.getSchema(), newVersion.getTransformsSchema()));
        System.out.println(remoteTypeInfo);
        DeserializationInput deserializationInput2 = new DeserializationInput(sf);
        SerializedBytes bytes$iv2 = new SerializedBytes(newVersion.getObj().getBytes());
        SerializationContext context$iv2 = null;
        Outer newOuter = (Outer)$receiver$iv.deserialize((ByteSequence)bytes$iv2, Outer.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)oa, (Object)newOuter.getA(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)ia, (Object)newOuter.getB().getA(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)"new value", (Object)newOuter.getB().getB(), null, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void multiVersionWithRemoval() {
        void $receiver$iv;
        void $receiver$iv2;
        void $receiver$iv3;
        SerializerFactory sf = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        String resource1 = "EvolvabilityTests.multiVersionWithRemoval.1";
        String resource2 = "EvolvabilityTests.multiVersionWithRemoval.2";
        String resource3 = "EvolvabilityTests.multiVersionWithRemoval.3";
        int a = 100;
        int b = 200;
        int c = 300;
        int d = 400;
        int e2 = 500;
        int f = 600;
        URL url1 = EvolvabilityTests.class.getResource(resource1);
        URL url2 = EvolvabilityTests.class.getResource(resource2);
        URL url3 = EvolvabilityTests.class.getResource(resource3);
        URL uRL = url1;
        Intrinsics.checkExpressionValueIsNotNull((Object)uRL, (String)"url1");
        byte[] sb1 = TextStreamsKt.readBytes((URL)uRL);
        DeserializationInput deserializationInput = new DeserializationInput(sf);
        SerializedBytes bytes$iv = new SerializedBytes(sb1);
        SerializationContext context$iv = null;
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000!\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u001a\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0017\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u001f\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007B'\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tB/\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000bB5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\f\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\rJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003JJ\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\n\u001a\u00020\u00032\b\b\u0002\u0010\f\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u001cJ\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020\u0003H\u00d6\u0001J\t\u0010!\u001a\u00020\"H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000f\u00a8\u0006#"}, d2={"net/corda/serialization/internal/amqp/EvolvabilityTests$multiVersionWithRemoval$C", "", "b", "", "c", "(II)V", "d", "(III)V", "e", "(IIII)V", "f", "(IIIII)V", "g", "(IIIIII)V", "getB", "()I", "getC", "getD", "getE", "getF", "getG", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "(IIIIII)Lnet/corda/serialization/internal/amqp/EvolvabilityTests$multiVersionWithRemoval$C;", "equals", "", "other", "hashCode", "toString", "", "serialization"})
        public final class C {
            private final int b;
            private final int c;
            private final int d;
            private final int e;
            private final int f;
            private final int g;

            public final int getB() {
                return this.b;
            }

            public final int getC() {
                return this.c;
            }

            public final int getD() {
                return this.d;
            }

            public final int getE() {
                return this.e;
            }

            public final int getF() {
                return this.f;
            }

            public final int getG() {
                return this.g;
            }

            public C(int b, int c, int d, int e2, int f, int g) {
                this.b = b;
                this.c = c;
                this.d = d;
                this.e = e2;
                this.f = f;
                this.g = g;
            }

            @DeprecatedConstructorForDeserialization(version=1)
            public C(int b, int c) {
                this(b, c, -1, -1, -1, -1);
            }

            @DeprecatedConstructorForDeserialization(version=2)
            public C(int b, int c, int d) {
                this(b, c, d, -1, -1, -1);
            }

            @DeprecatedConstructorForDeserialization(version=3)
            public C(int b, int c, int d, int e2) {
                this(b, c, d, e2, -1, -1);
            }

            @DeprecatedConstructorForDeserialization(version=4)
            public C(int b, int c, int d, int e2, int f) {
                this(b, c, d, e2, f, -1);
            }

            public final int component1() {
                return this.b;
            }

            public final int component2() {
                return this.c;
            }

            public final int component3() {
                return this.d;
            }

            public final int component4() {
                return this.e;
            }

            public final int component5() {
                return this.f;
            }

            public final int component6() {
                return this.g;
            }

            @NotNull
            public final C copy(int b, int c, int d, int e2, int f, int g) {
                return new C(b, c, d, e2, f, g);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ C copy$default(C c, int n, int n2, int n3, int n4, int n5, int n6, int n7, Object object) {
                if ((n7 & 1) != 0) {
                    n = c.b;
                }
                if ((n7 & 2) != 0) {
                    n2 = c.c;
                }
                if ((n7 & 4) != 0) {
                    n3 = c.d;
                }
                if ((n7 & 8) != 0) {
                    n4 = c.e;
                }
                if ((n7 & 0x10) != 0) {
                    n5 = c.f;
                }
                if ((n7 & 0x20) != 0) {
                    n6 = c.g;
                }
                return c.copy(n, n2, n3, n4, n5, n6);
            }

            @NotNull
            public String toString() {
                return "C(b=" + this.b + ", c=" + this.c + ", d=" + this.d + ", e=" + this.e + ", f=" + this.f + ", g=" + this.g + ")";
            }

            public int hashCode() {
                return ((((Integer.hashCode(this.b) * 31 + Integer.hashCode(this.c)) * 31 + Integer.hashCode(this.d)) * 31 + Integer.hashCode(this.e)) * 31 + Integer.hashCode(this.f)) * 31 + Integer.hashCode(this.g);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof C)) break block3;
                        C c = (C)object;
                        if (!(this.b == c.b) || !(this.c == c.c) || !(this.d == c.d) || !(this.e == c.e) || !(this.f == c.f) || !(this.g == c.g)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        C db1 = (C)$receiver$iv3.deserialize((ByteSequence)bytes$iv, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)b, (Object)db1.getB(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)c, (Object)db1.getC(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)-1, (Object)db1.getD(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)-1, (Object)db1.getE(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)-1, (Object)db1.getF(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)-1, (Object)db1.getG(), null, (int)4, null);
        URL uRL2 = url2;
        Intrinsics.checkExpressionValueIsNotNull((Object)uRL2, (String)"url2");
        byte[] sb2 = TextStreamsKt.readBytes((URL)uRL2);
        context$iv = new DeserializationInput(sf);
        SerializedBytes bytes$iv2 = new SerializedBytes(sb2);
        SerializationContext context$iv2 = null;
        C db2 = (C)$receiver$iv2.deserialize((ByteSequence)bytes$iv2, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)b, (Object)db2.getB(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)c, (Object)db2.getC(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)d, (Object)db2.getD(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)e2, (Object)db2.getE(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)-1, (Object)db2.getF(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)-1, (Object)db1.getG(), null, (int)4, null);
        URL uRL3 = url3;
        Intrinsics.checkExpressionValueIsNotNull((Object)uRL3, (String)"url3");
        byte[] sb3 = TextStreamsKt.readBytes((URL)uRL3);
        context$iv2 = new DeserializationInput(sf);
        SerializedBytes bytes$iv3 = new SerializedBytes(sb3);
        SerializationContext context$iv3 = null;
        C db3 = (C)$receiver$iv.deserialize((ByteSequence)bytes$iv3, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)b, (Object)db3.getB(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)c, (Object)db3.getC(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)d, (Object)db3.getD(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)e2, (Object)db3.getE(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)f, (Object)db3.getF(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)-1, (Object)db3.getG(), null, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    @Ignore(value="Test fails after moving NetworkParameters and NotaryInfo into core from node-api")
    public final void readBrokenNetworkParameters() {
        void $receiver$iv;
        void $receiver$iv2;
        URL url;
        SerializerFactory sf = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        sf.register((CustomSerializer)new InstantSerializer(sf));
        sf.register((CustomSerializer)PublicKeySerializer.INSTANCE);
        String resource = "networkParams.r3corda.6a6b6f256";
        URL uRL = url = EvolvabilityTests.class.getResource(resource);
        Intrinsics.checkExpressionValueIsNotNull((Object)uRL, (String)"url");
        byte[] sc2 = TextStreamsKt.readBytes((URL)uRL);
        DeserializationInput deserializationInput = new DeserializationInput(sf);
        SerializedBytes bytes$iv = new SerializedBytes(sc2);
        SerializationContext context$iv = null;
        SignedData deserializedC = (SignedData)$receiver$iv2.deserialize((ByteSequence)bytes$iv, SignedData.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        bytes$iv = new DeserializationInput(sf);
        SerializedBytes bytes$iv2 = deserializedC.getRaw();
        SerializationContext context$iv2 = null;
        NetworkParameters networkParams = (NetworkParameters)$receiver$iv.deserialize((ByteSequence)bytes$iv2, NetworkParameters.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)1000, (Object)networkParams.getMaxMessageSize(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)1000, (Object)networkParams.getMaxTransactionSize(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)3, (Object)networkParams.getMinimumPlatformVersion(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)1, (Object)networkParams.getNotaries().size(), null, (int)4, null);
        NotaryInfo notaryInfo = (NotaryInfo)CollectionsKt.firstOrNull((List)networkParams.getNotaries());
        AssertionsKt.assertEquals$default((Object)DUMMY_NOTARY_PARTY, (Object)(notaryInfo != null ? notaryInfo.getIdentity() : null), null, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void read corda 4-11 network parameters() {
        void $receiver$iv;
        void $receiver$iv2;
        URL url;
        SerializerFactory sf = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        sf.register((CustomSerializer)new InstantSerializer(sf));
        sf.register((CustomSerializer)PublicKeySerializer.INSTANCE);
        sf.register((CustomSerializer)new DurationSerializer(sf));
        String resource = "networkParams.4.11.58ecce1";
        URL uRL = url = EvolvabilityTests.class.getResource(resource);
        Intrinsics.checkExpressionValueIsNotNull((Object)uRL, (String)"url");
        byte[] sc2 = TextStreamsKt.readBytes((URL)uRL);
        DeserializationInput deserializationInput = new DeserializationInput(sf);
        SerializedBytes bytes$iv = new SerializedBytes(sc2);
        SerializationContext context$iv = null;
        SignedData deserializedC = (SignedData)$receiver$iv2.deserialize((ByteSequence)bytes$iv, SignedData.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        bytes$iv = new DeserializationInput(sf);
        SerializedBytes bytes$iv2 = deserializedC.getRaw();
        SerializationContext context$iv2 = null;
        NetworkParameters networkParams = (NetworkParameters)$receiver$iv.deserialize((ByteSequence)bytes$iv2, NetworkParameters.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)1000, (Object)networkParams.getMaxMessageSize(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)1000, (Object)networkParams.getMaxTransactionSize(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)3, (Object)networkParams.getMinimumPlatformVersion(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)1, (Object)networkParams.getNotaries().size(), null, (int)4, null);
        NotaryInfo notaryInfo = (NotaryInfo)CollectionsKt.firstOrNull((List)networkParams.getNotaries());
        AssertionsKt.assertEquals$default((Object)DUMMY_NOTARY_PARTY, (Object)(notaryInfo != null ? notaryInfo.getIdentity() : null), null, (int)4, null);
    }

    @Test(timeout=300000L)
    @Ignore(value="This test simply regenerates the test file used for readBrokenNetworkParameters")
    public final void regenerate broken network parameters() {
        String resource = "networkParams.<corda version>.<commit sha>";
        List list = CollectionsKt.listOf((Object)new NotaryInfo(DUMMY_NOTARY_PARTY, false));
        Instant instant = Instant.EPOCH;
        Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"Instant.EPOCH");
        NetworkParameters networkParameters = new NetworkParameters(3, list, 1000, 1000, instant, 1, MapsKt.emptyMap());
        SerializerFactory sf = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        sf.register((CustomSerializer)new InstantSerializer(sf));
        sf.register((CustomSerializer)PublicKeySerializer.INSTANCE);
        TestSerializationOutput testOutput = new TestSerializationOutput(true, sf);
        SerializedBytes<NetworkParameters> serialized = testOutput.serialize(networkParameters);
        KeyPair keyPair = Crypto.generateKeyPair$default(null, (int)1, null);
        PrivateKey privateKey = keyPair.getPrivate();
        Intrinsics.checkExpressionValueIsNotNull((Object)privateKey, (String)"keyPair.private");
        byte[] byArray = serialized.getBytes();
        PublicKey publicKey = keyPair.getPublic();
        Intrinsics.checkExpressionValueIsNotNull((Object)publicKey, (String)"keyPair.public");
        DigitalSignature.WithKey sig = CryptoUtils.sign((PrivateKey)privateKey, (byte[])byArray, (PublicKey)publicKey);
        SignedData signed = new SignedData(serialized, sig);
        SerializedBytes<SignedData> signedAndSerialized = testOutput.serialize(signed);
        FilesKt.writeBytes((File)new File(new URI(this.localPath + '/' + resource)), (byte[])signedAndSerialized.getBytes());
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void getterSetterEvolver1() {
        void $receiver$iv;
        URL url;
        String resource = "EvolvabilityTests.getterSetterEvolver1";
        SerializerFactory sf = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        URL uRL = url = EvolvabilityTests.class.getResource(resource);
        Intrinsics.checkExpressionValueIsNotNull((Object)uRL, (String)"url");
        byte[] sc2 = TextStreamsKt.readBytes((URL)uRL);
        DeserializationInput deserializationInput = new DeserializationInput(sf);
        SerializedBytes bytes$iv = new SerializedBytes(sc2);
        SerializationContext context$iv = null;
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000#\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0007\b\u0017\u00a2\u0006\u0002\u0010\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0013\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0004H\u00c6\u0003J6\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u0004H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0018J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u0004H\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u001a\u0010\u0007\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0005\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\n\"\u0004\b\u000e\u0010\fR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\n\"\u0004\b\u0010\u0010\fR\u001a\u0010\u0006\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\n\"\u0004\b\u0012\u0010\f\u00a8\u0006\u001f"}, d2={"net/corda/serialization/internal/amqp/EvolvabilityTests$getterSetterEvolver1$C", "", "()V", "d", "", "b", "e", "a", "(IIII)V", "getA", "()I", "setA", "(I)V", "getB", "setB", "getD", "setD", "getE", "setE", "component1", "component2", "component3", "component4", "copy", "(IIII)Lnet/corda/serialization/internal/amqp/EvolvabilityTests$getterSetterEvolver1$C;", "equals", "", "other", "hashCode", "toString", "", "serialization"})
        public final class C {
            private int d;
            private int b;
            private int e;
            private int a;

            public final int getD() {
                return this.d;
            }

            public final void setD(int n) {
                this.d = n;
            }

            public final int getB() {
                return this.b;
            }

            public final void setB(int n) {
                this.b = n;
            }

            public final int getE() {
                return this.e;
            }

            public final void setE(int n) {
                this.e = n;
            }

            public final int getA() {
                return this.a;
            }

            public final void setA(int n) {
                this.a = n;
            }

            public C(int d, int b, int e2, int a) {
                this.d = d;
                this.b = b;
                this.e = e2;
                this.a = a;
            }

            @ConstructorForDeserialization
            public C() {
                this(0, 0, 0, 0);
            }

            public final int component1() {
                return this.d;
            }

            public final int component2() {
                return this.b;
            }

            public final int component3() {
                return this.e;
            }

            public final int component4() {
                return this.a;
            }

            @NotNull
            public final C copy(int d, int b, int e2, int a) {
                return new C(d, b, e2, a);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ C copy$default(C c, int n, int n2, int n3, int n4, int n5, Object object) {
                if ((n5 & 1) != 0) {
                    n = c.d;
                }
                if ((n5 & 2) != 0) {
                    n2 = c.b;
                }
                if ((n5 & 4) != 0) {
                    n3 = c.e;
                }
                if ((n5 & 8) != 0) {
                    n4 = c.a;
                }
                return c.copy(n, n2, n3, n4);
            }

            @NotNull
            public String toString() {
                return "C(d=" + this.d + ", b=" + this.b + ", e=" + this.e + ", a=" + this.a + ")";
            }

            public int hashCode() {
                return ((Integer.hashCode(this.d) * 31 + Integer.hashCode(this.b)) * 31 + Integer.hashCode(this.e)) * 31 + Integer.hashCode(this.a);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof C)) break block3;
                        C c = (C)object;
                        if (!(this.d == c.d) || !(this.b == c.b) || !(this.e == c.e) || !(this.a == c.a)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        C deserializedC = (C)$receiver$iv.deserialize((ByteSequence)bytes$iv, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)1, (Object)deserializedC.getA(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)2, (Object)deserializedC.getB(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)4, (Object)deserializedC.getD(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)5, (Object)deserializedC.getE(), null, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void evolutionWithCarpentry() {
        void $receiver$iv;
        URL url;
        String resource = "EvolvabilityTests.evolutionWithCarpentry";
        SerializerFactory sf = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        URL uRL = url = EvolvabilityTests.class.getResource(resource);
        Intrinsics.checkExpressionValueIsNotNull((Object)uRL, (String)"url");
        byte[] sc2 = TextStreamsKt.readBytes((URL)uRL);
        DeserializationInput deserializationInput = new DeserializationInput(sf);
        SerializedBytes bytes$iv = new SerializedBytes(sc2);
        SerializationContext context$iv = null;
        Evolved deserialized = (Evolved)$receiver$iv.deserialize((ByteSequence)bytes$iv, Evolved.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)"dronf", (Object)deserialized.getFnord(), null, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void evolutionWithPrimitives() {
        void $receiver$iv;
        URL url;
        String resource = "EvolvabilityTests.evolutionWithPrimitives";
        SerializerFactory sf = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        URL uRL = url = EvolvabilityTests.class.getResource(resource);
        Intrinsics.checkExpressionValueIsNotNull((Object)uRL, (String)"url");
        byte[] sc2 = TextStreamsKt.readBytes((URL)uRL);
        DeserializationInput deserializationInput = new DeserializationInput(sf);
        SerializedBytes bytes$iv = new SerializedBytes(sc2);
        SerializationContext context$iv = null;
        ParameterizedContainer deserialized = (ParameterizedContainer)$receiver$iv.deserialize((ByteSequence)bytes$iv, ParameterizedContainer.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        Parameterized<Integer, Integer> parameterized = deserialized.getParameterized();
        AssertionsKt.assertEquals$default((Object)10, (Object)(parameterized != null ? parameterized.getA() : null), null, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void addMandatoryFieldWithAltConstructorAndMakeExistingIntFieldNullable() {
        void $receiver$iv;
        SerializerFactory sf = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        String resource = "EvolvabilityTests.addMandatoryFieldWithAltConstructorAndMakeExistingIntFieldNullable";
        URL uRL = EvolvabilityTests.class.getResource(resource);
        if (uRL == null) {
            Void void_ = AssertionsKt.fail((String)"Not found!");
            throw null;
        }
        URL url = uRL;
        byte[] sc2 = TextStreamsKt.readBytes((URL)url);
        DeserializationInput deserializationInput = new DeserializationInput(sf);
        SerializedBytes bytes$iv = new SerializedBytes(sc2);
        SerializationContext context$iv = null;
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000!\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u000f\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J$\u0010\u000e\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0015\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"net/corda/serialization/internal/amqp/EvolvabilityTests$addMandatoryFieldWithAltConstructorAndMakeExistingIntFieldNullable$CC", "", "a", "", "(I)V", "b", "(Ljava/lang/Integer;I)V", "getA", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getB", "()I", "component1", "component2", "copy", "(Ljava/lang/Integer;I)Lnet/corda/serialization/internal/amqp/EvolvabilityTests$addMandatoryFieldWithAltConstructorAndMakeExistingIntFieldNullable$CC;", "equals", "", "other", "hashCode", "toString", "", "serialization"})
        public final class CC {
            @Nullable
            private final Integer a;
            private final int b;

            @Nullable
            public final Integer getA() {
                return this.a;
            }

            public final int getB() {
                return this.b;
            }

            public CC(@Nullable Integer a, int b) {
                this.a = a;
                this.b = b;
            }

            @DeprecatedConstructorForDeserialization(version=1)
            public CC(int a) {
                this(a, 42);
            }

            @Nullable
            public final Integer component1() {
                return this.a;
            }

            public final int component2() {
                return this.b;
            }

            @NotNull
            public final CC copy(@Nullable Integer a, int b) {
                return new CC(a, b);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ CC copy$default(CC cC, Integer n, int n2, int n3, Object object) {
                if ((n3 & 1) != 0) {
                    n = cC.a;
                }
                if ((n3 & 2) != 0) {
                    n2 = cC.b;
                }
                return cC.copy(n, n2);
            }

            @NotNull
            public String toString() {
                return "CC(a=" + this.a + ", b=" + this.b + ")";
            }

            public int hashCode() {
                Integer n = this.a;
                return (n != null ? ((Object)n).hashCode() : 0) * 31 + Integer.hashCode(this.b);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof CC)) break block3;
                        CC cC = (CC)object;
                        if (!Intrinsics.areEqual((Object)this.a, (Object)cC.a) || !(this.b == cC.b)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        CC deserializedCC = (CC)$receiver$iv.deserialize((ByteSequence)bytes$iv, CC.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)1, (Object)deserializedCC.getA(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)42, (Object)deserializedCC.getB(), null, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void addMandatoryFieldWithAltConstructorAndMakeExistingNullableIntFieldMandatory() {
        void $receiver$iv;
        SerializerFactory sf = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        String resource = "EvolvabilityTests.addMandatoryFieldWithAltConstructorAndMakeExistingNullableIntFieldMandatory";
        URL uRL = EvolvabilityTests.class.getResource(resource);
        if (uRL == null) {
            Void void_ = AssertionsKt.fail((String)"Not found!");
            throw null;
        }
        URL url = uRL;
        byte[] sc2 = TextStreamsKt.readBytes((URL)url);
        DeserializationInput deserializationInput = new DeserializationInput(sf);
        SerializedBytes bytes$iv = new SerializedBytes(sc2);
        SerializationContext context$iv = null;
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000!\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0011\b\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\"\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\rJ\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0014"}, d2={"net/corda/serialization/internal/amqp/EvolvabilityTests$addMandatoryFieldWithAltConstructorAndMakeExistingNullableIntFieldMandatory$CC", "", "a", "", "(Ljava/lang/Integer;)V", "b", "(II)V", "getA", "()I", "getB", "component1", "component2", "copy", "(II)Lnet/corda/serialization/internal/amqp/EvolvabilityTests$addMandatoryFieldWithAltConstructorAndMakeExistingNullableIntFieldMandatory$CC;", "equals", "", "other", "hashCode", "toString", "", "serialization"})
        public final class CC {
            private final int a;
            private final int b;

            public final int getA() {
                return this.a;
            }

            public final int getB() {
                return this.b;
            }

            public CC(int a, int b) {
                this.a = a;
                this.b = b;
            }

            @DeprecatedConstructorForDeserialization(version=1)
            public CC(@Nullable Integer a) {
                Integer n = a;
                this(n != null ? n : -1, 42);
            }

            public final int component1() {
                return this.a;
            }

            public final int component2() {
                return this.b;
            }

            @NotNull
            public final CC copy(int a, int b) {
                return new CC(a, b);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ CC copy$default(CC cC, int n, int n2, int n3, Object object) {
                if ((n3 & 1) != 0) {
                    n = cC.a;
                }
                if ((n3 & 2) != 0) {
                    n2 = cC.b;
                }
                return cC.copy(n, n2);
            }

            @NotNull
            public String toString() {
                return "CC(a=" + this.a + ", b=" + this.b + ")";
            }

            public int hashCode() {
                return Integer.hashCode(this.a) * 31 + Integer.hashCode(this.b);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof CC)) break block3;
                        CC cC = (CC)object;
                        if (!(this.a == cC.a) || !(this.b == cC.b)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        CC deserializedCC = (CC)$receiver$iv.deserialize((ByteSequence)bytes$iv, CC.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)-1, (Object)deserializedCC.getA(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)42, (Object)deserializedCC.getB(), null, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void addMandatoryFieldAndRemoveExistingNullableIntField() {
        void $receiver$iv;
        SerializerFactory sf = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        String resource = "EvolvabilityTests.addMandatoryFieldAndRemoveExistingNullableIntField";
        URL uRL = EvolvabilityTests.class.getResource(resource);
        if (uRL == null) {
            Void void_ = AssertionsKt.fail((String)"Not found!");
            throw null;
        }
        URL url = uRL;
        byte[] sc2 = TextStreamsKt.readBytes((URL)url);
        DeserializationInput deserializationInput = new DeserializationInput(sf);
        SerializedBytes bytes$iv = new SerializedBytes(sc2);
        SerializationContext context$iv = null;
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000!\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0004*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0019\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\"\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\n\u00a8\u0006\u0015"}, d2={"net/corda/serialization/internal/amqp/EvolvabilityTests$addMandatoryFieldAndRemoveExistingNullableIntField$CC", "", "data", "", "a", "", "(Ljava/lang/String;Ljava/lang/Integer;)V", "b", "(Ljava/lang/String;Ljava/lang/String;)V", "getB", "()Ljava/lang/String;", "getData", "component1", "component2", "copy", "(Ljava/lang/String;Ljava/lang/String;)Lnet/corda/serialization/internal/amqp/EvolvabilityTests$addMandatoryFieldAndRemoveExistingNullableIntField$CC;", "equals", "", "other", "hashCode", "toString", "serialization"})
        public final class CC {
            @NotNull
            private final String data;
            @NotNull
            private final String b;

            @NotNull
            public final String getData() {
                return this.data;
            }

            @NotNull
            public final String getB() {
                return this.b;
            }

            public CC(@NotNull String data, @NotNull String b) {
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
                this.data = data;
                this.b = b;
            }

            @DeprecatedConstructorForDeserialization(version=1)
            public CC(@NotNull String data, @Nullable Integer a) {
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                Object object = a;
                if (object == null || (object = String.valueOf((Integer)object)) == null) {
                    object = "<not provided>";
                }
                this(data, (String)object);
            }

            @NotNull
            public final String component1() {
                return this.data;
            }

            @NotNull
            public final String component2() {
                return this.b;
            }

            @NotNull
            public final CC copy(@NotNull String data, @NotNull String b) {
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
                return new CC(data, b);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ CC copy$default(CC cC, String string, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string = cC.data;
                }
                if ((n & 2) != 0) {
                    string2 = cC.b;
                }
                return cC.copy(string, string2);
            }

            @NotNull
            public String toString() {
                return "CC(data=" + this.data + ", b=" + this.b + ")";
            }

            public int hashCode() {
                String string = this.data;
                String string2 = this.b;
                return (string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof CC)) break block3;
                        CC cC = (CC)object;
                        if (!Intrinsics.areEqual((Object)this.data, (Object)cC.data) || !Intrinsics.areEqual((Object)this.b, (Object)cC.b)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        CC deserializedCC = (CC)$receiver$iv.deserialize((ByteSequence)bytes$iv, CC.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)"written", (Object)deserializedCC.getData(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)"<not provided>", (Object)deserializedCC.getB(), null, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void removeExistingNullableIntFieldWithAltConstructor() {
        void $receiver$iv;
        SerializerFactory sf = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        String resource = "EvolvabilityTests.removeExistingNullableIntFieldWithAltConstructor";
        URL uRL = EvolvabilityTests.class.getResource(resource);
        if (uRL == null) {
            Void void_ = AssertionsKt.fail((String)"Not found!");
            throw null;
        }
        URL url = uRL;
        byte[] sc2 = TextStreamsKt.readBytes((URL)url);
        DeserializationInput deserializationInput = new DeserializationInput(sf);
        SerializedBytes bytes$iv = new SerializedBytes(sc2);
        SerializationContext context$iv = null;
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000!\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0019\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u0018\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\fJ\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"net/corda/serialization/internal/amqp/EvolvabilityTests$removeExistingNullableIntFieldWithAltConstructor$CC", "", "data", "", "a", "", "(Ljava/lang/String;Ljava/lang/Integer;)V", "(Ljava/lang/String;)V", "getData", "()Ljava/lang/String;", "component1", "copy", "(Ljava/lang/String;)Lnet/corda/serialization/internal/amqp/EvolvabilityTests$removeExistingNullableIntFieldWithAltConstructor$CC;", "equals", "", "other", "hashCode", "toString", "serialization"})
        public final class CC {
            @NotNull
            private final String data;

            @NotNull
            public final String getData() {
                return this.data;
            }

            public CC(@NotNull String data) {
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                this.data = data;
            }

            @DeprecatedConstructorForDeserialization(version=1)
            public CC(@NotNull String data, @Nullable Integer a) {
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                StringBuilder stringBuilder = new StringBuilder().append(data);
                Object object = a;
                if (object == null || (object = String.valueOf((Integer)object)) == null) {
                    object = "<not provided>";
                }
                this(stringBuilder.append(object).toString());
            }

            @NotNull
            public final String component1() {
                return this.data;
            }

            @NotNull
            public final CC copy(@NotNull String data) {
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return new CC(data);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ CC copy$default(CC cC, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = cC.data;
                }
                return cC.copy(string);
            }

            @NotNull
            public String toString() {
                return "CC(data=" + this.data + ")";
            }

            public int hashCode() {
                String string = this.data;
                return string != null ? string.hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof CC)) break block3;
                        CC cC = (CC)object;
                        if (!Intrinsics.areEqual((Object)this.data, (Object)cC.data)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        CC deserializedCC = (CC)$receiver$iv.deserialize((ByteSequence)bytes$iv, CC.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)"written<not provided>", (Object)deserializedCC.getData(), null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void notarisationRequestStabilityTest() {
        URL url;
        SerializerFactory sf = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        String resource = "EvolvabilityTests.notarisationRequest";
        URL uRL = url = EvolvabilityTests.class.getResource(resource);
        Intrinsics.checkExpressionValueIsNotNull((Object)uRL, (String)"url");
        byte[] sc2 = TextStreamsKt.readBytes((URL)uRL);
        SerializedBytes previousForm = new SerializedBytes(sc2);
        DeserializationInput $receiver$iv = new DeserializationInput(sf);
        SerializationContext context$iv = null;
        NotarisationRequest deserialized = (NotarisationRequest)$receiver$iv.deserialize((ByteSequence)previousForm, NotarisationRequest.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)((StateRef)deserialized.getStatesToConsume().get(0)).getTxhash(), (Object)((StateRef)deserialized.getStatesToConsume().get(1)).getTxhash(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)((StateRef)deserialized.getStatesToConsume().get(2)).getTxhash(), (Object)((StateRef)deserialized.getStatesToConsume().get(3)).getTxhash(), null, (int)4, null);
        org.junit.jupiter.api.Assertions.assertNotSame((Object)((StateRef)deserialized.getStatesToConsume().get(0)).getTxhash(), (Object)((StateRef)deserialized.getStatesToConsume().get(1)).getTxhash());
        org.junit.jupiter.api.Assertions.assertNotSame((Object)((StateRef)deserialized.getStatesToConsume().get(2)).getTxhash(), (Object)((StateRef)deserialized.getStatesToConsume().get(3)).getTxhash());
        SerializedBytes serialized = AMQPTestUtilsKt.serialize$default(new SerializationOutput((LocalSerializerFactory)sf), deserialized, null, 2, null);
        AssertionsKt.assertEquals$default((Object)previousForm, (Object)serialized, null, (int)4, null);
        DeserializationInput $receiver$iv2 = new DeserializationInput(sf);
        SerializationContext context$iv2 = null;
        NotarisationRequest deserialized2 = (NotarisationRequest)$receiver$iv2.deserialize((ByteSequence)serialized, NotarisationRequest.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)deserialized.getTransactionId(), (Object)deserialized2.getTransactionId(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)deserialized.getStatesToConsume(), (Object)deserialized2.getStatesToConsume(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)((StateRef)deserialized2.getStatesToConsume().get(0)).getTxhash(), (Object)((StateRef)deserialized2.getStatesToConsume().get(1)).getTxhash(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)((StateRef)deserialized2.getStatesToConsume().get(2)).getTxhash(), (Object)((StateRef)deserialized2.getStatesToConsume().get(3)).getTxhash(), null, (int)4, null);
        org.junit.jupiter.api.Assertions.assertNotSame((Object)((StateRef)deserialized2.getStatesToConsume().get(0)).getTxhash(), (Object)((StateRef)deserialized2.getStatesToConsume().get(1)).getTxhash());
        org.junit.jupiter.api.Assertions.assertNotSame((Object)((StateRef)deserialized2.getStatesToConsume().get(2)).getTxhash(), (Object)((StateRef)deserialized2.getStatesToConsume().get(3)).getTxhash());
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void maybeSerializedTransaction() {
        void $receiver$iv;
        URL url;
        SerializerFactory sf = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        String resource = "EvolvabilityTests.maybeSerializedTransaction";
        URL uRL = url = EvolvabilityTests.class.getResource(resource);
        Intrinsics.checkExpressionValueIsNotNull((Object)uRL, (String)"url");
        byte[] sc2 = TextStreamsKt.readBytes((URL)uRL);
        DeserializationInput deserializationInput = new DeserializationInput(sf);
        SerializedBytes bytes$iv = new SerializedBytes(sc2);
        SerializationContext context$iv = null;
        MaybeSerializedSignedTransaction deserializedA = (MaybeSerializedSignedTransaction)$receiver$iv.deserialize((ByteSequence)bytes$iv, MaybeSerializedSignedTransaction.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        Assertions.assertThat((Object)deserializedA).isInstanceOf(MaybeSerializedSignedTransaction.class);
    }

    public EvolvabilityTests() {
        URI uRI = ProjectStructure.INSTANCE.getProjectRootDir().toUri().resolve("serialization/src/test/resources/net/corda/serialization/internal/amqp");
        Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"projectRootDir.toUri().r\u2026alization/internal/amqp\")");
        this.localPath = uRI;
    }

    static {
        Companion = new Companion(null);
        DUMMY_NOTARY_NAME = new CordaX500Name("Notary Service", "Zurich", "CH");
        BigInteger bigInteger = BigInteger.valueOf(20L);
        Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger, (String)"BigInteger.valueOf(20)");
        PublicKey publicKey = Crypto.deriveKeyPairFromEntropy((SignatureScheme)Crypto.DEFAULT_SIGNATURE_SCHEME, (BigInteger)bigInteger).getPublic();
        Intrinsics.checkExpressionValueIsNotNull((Object)publicKey, (String)"Crypto.deriveKeyPairFrom\u2026teger.valueOf(20)).public");
        DUMMY_NOTARY_PARTY = new Party(DUMMY_NOTARY_NAME, publicKey);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lnet/corda/serialization/internal/amqp/EvolvabilityTests$Evolved;", "", "fnord", "", "(Ljava/lang/String;)V", "getFnord", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "serialization"})
    public static final class Evolved {
        @NotNull
        private final String fnord;

        @NotNull
        public final String getFnord() {
            return this.fnord;
        }

        public Evolved(@NotNull String fnord) {
            Intrinsics.checkParameterIsNotNull((Object)fnord, (String)"fnord");
            this.fnord = fnord;
        }

        @NotNull
        public final String component1() {
            return this.fnord;
        }

        @NotNull
        public final Evolved copy(@NotNull String fnord) {
            Intrinsics.checkParameterIsNotNull((Object)fnord, (String)"fnord");
            return new Evolved(fnord);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Evolved copy$default(Evolved evolved, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = evolved.fnord;
            }
            return evolved.copy(string);
        }

        @NotNull
        public String toString() {
            return "Evolved(fnord=" + this.fnord + ")";
        }

        public int hashCode() {
            String string = this.fnord;
            return string != null ? string.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Evolved)) break block3;
                    Evolved evolved = (Evolved)object;
                    if (!Intrinsics.areEqual((Object)this.fnord, (Object)evolved.fnord)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0014\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u0017\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003H\u00c6\u0003J!\u0010\t\u001a\u00020\u00002\u0016\b\u0002\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u0004H\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u001f\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lnet/corda/serialization/internal/amqp/EvolvabilityTests$ParameterizedContainer;", "", "parameterized", "Lnet/corda/serialization/internal/amqp/EvolvabilityTests$Parameterized;", "", "(Lnet/corda/serialization/internal/amqp/EvolvabilityTests$Parameterized;)V", "getParameterized", "()Lnet/corda/serialization/internal/amqp/EvolvabilityTests$Parameterized;", "component1", "copy", "equals", "", "other", "hashCode", "toString", "", "serialization"})
    public static final class ParameterizedContainer {
        @Nullable
        private final Parameterized<Integer, Integer> parameterized;

        @Nullable
        public final Parameterized<Integer, Integer> getParameterized() {
            return this.parameterized;
        }

        public ParameterizedContainer(@Nullable Parameterized<Integer, Integer> parameterized) {
            this.parameterized = parameterized;
        }

        @Nullable
        public final Parameterized<Integer, Integer> component1() {
            return this.parameterized;
        }

        @NotNull
        public final ParameterizedContainer copy(@Nullable Parameterized<Integer, Integer> parameterized) {
            return new ParameterizedContainer(parameterized);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ ParameterizedContainer copy$default(ParameterizedContainer parameterizedContainer, Parameterized parameterized, int n, Object object) {
            if ((n & 1) != 0) {
                parameterized = parameterizedContainer.parameterized;
            }
            return parameterizedContainer.copy(parameterized);
        }

        @NotNull
        public String toString() {
            return "ParameterizedContainer(parameterized=" + this.parameterized + ")";
        }

        public int hashCode() {
            Parameterized<Integer, Integer> parameterized = this.parameterized;
            return parameterized != null ? ((Object)parameterized).hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ParameterizedContainer)) break block3;
                    ParameterizedContainer parameterizedContainer = (ParameterizedContainer)object;
                    if (!Intrinsics.areEqual(this.parameterized, parameterizedContainer.parameterized)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\bf\u0018\u00002\u00020\u0001\u00a8\u0006\u0002"}, d2={"Lnet/corda/serialization/internal/amqp/EvolvabilityTests$ForceEvolution;", "", "serialization"})
    public static interface ForceEvolution {
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003B\u001b\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\r\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\tJ\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006H\u00c6\u0003J4\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0004\u001a\u00028\u00002\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0010J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"Lnet/corda/serialization/internal/amqp/EvolvabilityTests$Parameterized;", "A", "B", "Lnet/corda/serialization/internal/amqp/EvolvabilityTests$ForceEvolution;", "a", "b", "", "(Ljava/lang/Object;Ljava/util/Set;)V", "getA", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getB", "()Ljava/util/Set;", "component1", "component2", "copy", "(Ljava/lang/Object;Ljava/util/Set;)Lnet/corda/serialization/internal/amqp/EvolvabilityTests$Parameterized;", "equals", "", "other", "", "hashCode", "", "toString", "", "serialization"})
    public static final class Parameterized<A, B>
    implements ForceEvolution {
        private final A a;
        @NotNull
        private final Set<B> b;

        public final A getA() {
            return this.a;
        }

        @NotNull
        public final Set<B> getB() {
            return this.b;
        }

        public Parameterized(A a, @NotNull Set<? extends B> b) {
            Intrinsics.checkParameterIsNotNull(b, (String)"b");
            this.a = a;
            this.b = b;
        }

        public final A component1() {
            return this.a;
        }

        @NotNull
        public final Set<B> component2() {
            return this.b;
        }

        @NotNull
        public final Parameterized<A, B> copy(A a, @NotNull Set<? extends B> b) {
            Intrinsics.checkParameterIsNotNull(b, (String)"b");
            return new Parameterized<A, B>(a, b);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Parameterized copy$default(Parameterized parameterized, Object object, Set set, int n, Object object2) {
            if ((n & 1) != 0) {
                object = parameterized.a;
            }
            if ((n & 2) != 0) {
                set = parameterized.b;
            }
            return parameterized.copy(object, set);
        }

        @NotNull
        public String toString() {
            return "Parameterized(a=" + this.a + ", b=" + this.b + ")";
        }

        public int hashCode() {
            A a = this.a;
            Set<B> set = this.b;
            return (a != null ? a.hashCode() : 0) * 31 + (set != null ? ((Object)set).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Parameterized)) break block3;
                    Parameterized parameterized = (Parameterized)object;
                    if (!Intrinsics.areEqual(this.a, parameterized.a) || !Intrinsics.areEqual(this.b, parameterized.b)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lnet/corda/serialization/internal/amqp/EvolvabilityTests$Companion;", "", "()V", "DUMMY_NOTARY_NAME", "Lnet/corda/core/identity/CordaX500Name;", "DUMMY_NOTARY_PARTY", "Lnet/corda/core/identity/Party;", "serialization"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

