/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp;

import java.net.URL;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.contracts.BelongsToContract;
import net.corda.core.contracts.Contract;
import net.corda.core.contracts.ContractState;
import net.corda.core.identity.AbstractParty;
import net.corda.core.serialization.DeprecatedConstructorForDeserialization;
import net.corda.core.serialization.SerializationContext;
import net.corda.core.serialization.SerializedBytes;
import net.corda.core.transactions.LedgerTransaction;
import net.corda.core.utilities.ByteSequence;
import net.corda.core.utilities.OpaqueBytes;
import net.corda.serialization.internal.amqp.DeserializationInput;
import net.corda.serialization.internal.amqp.LocalSerializerFactory;
import net.corda.serialization.internal.amqp.SerializationOutput;
import net.corda.serialization.internal.amqp.SerializerFactory;
import net.corda.serialization.internal.amqp.testutils.AMQPTestUtilsKt;
import net.corda.serialization.internal.amqp.testutils.TestSerializationContextKt;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0002\u000f\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0007J\u001d\u0010\u000b\u001a\u00020\n\"\b\b\u0000\u0010\f*\u00020\u00012\u0006\u0010\r\u001a\u0002H\f\u00a2\u0006\u0002\u0010\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lnet/corda/serialization/internal/amqp/EvolutionObjectBuilderRenamedPropertyTests;", "", "()V", "cordappVersionTestValue", "", "dataTestValue", "", "xTestValue", "yTestValue", "Step 1 to Step 3", "", "saveSerializedObject", "T", "obj", "(Ljava/lang/Object;)V", "TemplateContract", "TemplateState", "serialization"})
public final class EvolutionObjectBuilderRenamedPropertyTests {
    private final int cordappVersionTestValue = 38854445;
    private final String dataTestValue = "d7af8af0-c10e-45bc-a5f7-92de432be0ef";
    private final int xTestValue = 7568055;
    private final int yTestValue = 4113687;

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void Step 1 to Step 3() {
        void $receiver$iv;
        URL uRL = this.getClass().getResource("EvolutionObjectBuilderRenamedPropertyTests.Step1");
        Intrinsics.checkExpressionValueIsNotNull((Object)uRL, (String)"this::class.java.getReso\u2026amedPropertyTests.Step1\")");
        byte[] bytes = TextStreamsKt.readBytes((URL)uRL);
        SerializerFactory serializerFactory = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        DeserializationInput deserializationInput = new DeserializationInput(serializerFactory);
        SerializedBytes bytes$iv = new SerializedBytes(bytes);
        SerializationContext context$iv = null;
        TemplateState deserializedObject = (TemplateState)$receiver$iv.deserialize((ByteSequence)bytes$iv, TemplateState.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        Assertions.assertThat((int)deserializedObject.getCordappVersion()).isEqualTo(this.cordappVersionTestValue);
        Assertions.assertThat((String)deserializedObject.getData()).isEqualTo(this.dataTestValue, new Object[0]);
        Assertions.assertThat((String)deserializedObject.getY()).isEqualTo(String.valueOf(this.xTestValue), new Object[0]);
        Assertions.assertThat((Object)deserializedObject).isInstanceOf(TemplateState.class);
    }

    public final <T> void saveSerializedObject(@NotNull T obj) {
        Intrinsics.checkParameterIsNotNull(obj, (String)"obj");
        AMQPTestUtilsKt.writeTestResource(this, (OpaqueBytes)AMQPTestUtilsKt.serialize$default(new SerializationOutput((LocalSerializerFactory)AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null)), obj, null, 2, null));
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lnet/corda/serialization/internal/amqp/EvolutionObjectBuilderRenamedPropertyTests$TemplateContract;", "Lnet/corda/core/contracts/Contract;", "()V", "verify", "", "tx", "Lnet/corda/core/transactions/LedgerTransaction;", "serialization"})
    public static final class TemplateContract
    implements Contract {
        public void verify(@NotNull LedgerTransaction tx) {
            Intrinsics.checkParameterIsNotNull((Object)tx, (String)"tx");
        }
    }

    @BelongsToContract(value=TemplateContract.class)
    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0087\b\u0018\u00002\u00020\u0001B/\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0005\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003J9\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010\u00a8\u0006\u001f"}, d2={"Lnet/corda/serialization/internal/amqp/EvolutionObjectBuilderRenamedPropertyTests$TemplateState;", "Lnet/corda/core/contracts/ContractState;", "cordappVersion", "", "data", "", "x", "participants", "", "Lnet/corda/core/identity/AbstractParty;", "(ILjava/lang/String;Ljava/lang/Integer;Ljava/util/List;)V", "y", "(ILjava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "getCordappVersion", "()I", "getData", "()Ljava/lang/String;", "getParticipants", "()Ljava/util/List;", "getY", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "toString", "serialization"})
    public static final class TemplateState
    implements ContractState {
        private final int cordappVersion;
        @NotNull
        private final String data;
        @Nullable
        private final String y;
        @NotNull
        private final List<AbstractParty> participants;

        public final int getCordappVersion() {
            return this.cordappVersion;
        }

        @NotNull
        public final String getData() {
            return this.data;
        }

        @Nullable
        public final String getY() {
            return this.y;
        }

        @NotNull
        public List<AbstractParty> getParticipants() {
            return this.participants;
        }

        public TemplateState(int cordappVersion, @NotNull String data, @Nullable String y, @NotNull List<? extends AbstractParty> participants) {
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            Intrinsics.checkParameterIsNotNull(participants, (String)"participants");
            this.cordappVersion = cordappVersion;
            this.data = data;
            this.y = y;
            this.participants = participants;
        }

        public /* synthetic */ TemplateState(int n, String string, String string2, List list, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 8) != 0) {
                list = CollectionsKt.emptyList();
            }
            this(n, string, string2, (List<? extends AbstractParty>)list);
        }

        @DeprecatedConstructorForDeserialization(version=1)
        public TemplateState(int cordappVersion, @NotNull String data, @Nullable Integer x, @NotNull List<? extends AbstractParty> participants) {
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            Intrinsics.checkParameterIsNotNull(participants, (String)"participants");
            Integer n = x;
            this(cordappVersion, data, n != null ? String.valueOf(n) : null, participants);
        }

        public final int component1() {
            return this.cordappVersion;
        }

        @NotNull
        public final String component2() {
            return this.data;
        }

        @Nullable
        public final String component3() {
            return this.y;
        }

        @NotNull
        public final List<AbstractParty> component4() {
            return this.getParticipants();
        }

        @NotNull
        public final TemplateState copy(int cordappVersion, @NotNull String data, @Nullable String y, @NotNull List<? extends AbstractParty> participants) {
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            Intrinsics.checkParameterIsNotNull(participants, (String)"participants");
            return new TemplateState(cordappVersion, data, y, participants);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ TemplateState copy$default(TemplateState templateState, int n, String string, String string2, List list, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = templateState.cordappVersion;
            }
            if ((n2 & 2) != 0) {
                string = templateState.data;
            }
            if ((n2 & 4) != 0) {
                string2 = templateState.y;
            }
            if ((n2 & 8) != 0) {
                list = templateState.getParticipants();
            }
            return templateState.copy(n, string, string2, list);
        }

        @NotNull
        public String toString() {
            return "TemplateState(cordappVersion=" + this.cordappVersion + ", data=" + this.data + ", y=" + this.y + ", participants=" + this.getParticipants() + ")";
        }

        public int hashCode() {
            String string = this.data;
            String string2 = this.y;
            List<AbstractParty> list = this.getParticipants();
            return ((Integer.hashCode(this.cordappVersion) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (list != null ? ((Object)list).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof TemplateState)) break block3;
                    TemplateState templateState = (TemplateState)object;
                    if (!(this.cordappVersion == templateState.cordappVersion) || !Intrinsics.areEqual((Object)this.data, (Object)templateState.data) || !Intrinsics.areEqual((Object)this.y, (Object)templateState.y) || !Intrinsics.areEqual(this.getParticipants(), templateState.getParticipants())) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

