/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.test.AssertionsKt;
import net.corda.core.serialization.CordaSerializationTransformEnumDefault;
import net.corda.core.serialization.CordaSerializationTransformEnumDefaults;
import net.corda.core.serialization.CordaSerializationTransformRename;
import net.corda.core.serialization.CordaSerializationTransformRenames;
import net.corda.serialization.internal.amqp.EnumTransformationTests;
import net.corda.serialization.internal.amqp.TransformsAnnotationProcessor;
import net.corda.serialization.internal.model.EnumTransforms;
import net.corda.serialization.internal.model.InvalidEnumTransformsException;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Test;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0004\u000f\u0010\u0011\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u000bH\u0007J\b\u0010\f\u001a\u00020\u000bH\u0007J\b\u0010\r\u001a\u00020\u000bH\u0007J\b\u0010\u000e\u001a\u00020\u000bH\u0007R(\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004*\u0006\u0012\u0002\b\u00030\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lnet/corda/serialization/internal/amqp/EnumTransformationTests;", "", "()V", "constants", "", "", "", "Ljava/lang/Class;", "getConstants", "(Ljava/lang/Class;)Ljava/util/Map;", "cycleDetection", "", "defaultAndRename", "renameCycleDoesNotTerminateInConstant", "renamesRenameExistingConstant", "DanglingRenames", "MultiOperations", "RenameCycle", "RenamesExisting", "serialization"})
public final class EnumTransformationTests {
    @Test(timeout=300000L)
    public final void defaultAndRename() {
        EnumTransforms transforms = EnumTransforms.Companion.build(TransformsAnnotationProcessor.INSTANCE.getTransformsSchema(MultiOperations.class), this.getConstants(MultiOperations.class));
        Assert.assertEquals((Object)MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"BOB", (Object)"FRED"), TuplesKt.to((Object)"FRED", (Object)"E")}), (Object)transforms.getRenames());
        Assert.assertEquals((Object)MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"D", (Object)"C"), TuplesKt.to((Object)"E", (Object)"D")}), (Object)transforms.getDefaults());
    }

    @Test(timeout=300000L)
    public final void cycleDetection() {
        Function0 function0 = (Function0)new Function0<Unit>(this){
            final /* synthetic */ EnumTransformationTests this$0;

            public final void invoke() {
                EnumTransforms.Companion.build(TransformsAnnotationProcessor.INSTANCE.getTransformsSchema(RenameCycle.class), EnumTransformationTests.access$getConstants$p(this.this$0, RenameCycle.class));
            }
            {
                this.this$0 = enumTransformationTests;
                super(0);
            }
        };
        String string = null;
        AssertionsKt.assertFailsWith((KClass)Reflection.getOrCreateKotlinClass(InvalidEnumTransformsException.class), (String)string, (Function0)function0);
    }

    @Test(timeout=300000L)
    public final void renameCycleDoesNotTerminateInConstant() {
        Function0 function0 = (Function0)new Function0<Unit>(this){
            final /* synthetic */ EnumTransformationTests this$0;

            public final void invoke() {
                EnumTransforms.Companion.build(TransformsAnnotationProcessor.INSTANCE.getTransformsSchema(DanglingRenames.class), EnumTransformationTests.access$getConstants$p(this.this$0, DanglingRenames.class));
            }
            {
                this.this$0 = enumTransformationTests;
                super(0);
            }
        };
        String string = null;
        AssertionsKt.assertFailsWith((KClass)Reflection.getOrCreateKotlinClass(InvalidEnumTransformsException.class), (String)string, (Function0)function0);
    }

    @Test(timeout=300000L)
    public final void renamesRenameExistingConstant() {
        Function0 function0 = (Function0)new Function0<Unit>(this){
            final /* synthetic */ EnumTransformationTests this$0;

            public final void invoke() {
                EnumTransforms.Companion.build(TransformsAnnotationProcessor.INSTANCE.getTransformsSchema(RenamesExisting.class), EnumTransformationTests.access$getConstants$p(this.this$0, RenamesExisting.class));
            }
            {
                this.this$0 = enumTransformationTests;
                super(0);
            }
        };
        String string = null;
        AssertionsKt.assertFailsWith((KClass)Reflection.getOrCreateKotlinClass(InvalidEnumTransformsException.class), (String)string, (Function0)function0);
    }

    private final Map<String, Integer> getConstants(@NotNull Class<?> $receiver) {
        Object[] objectArray = $receiver.getEnumConstants();
        Intrinsics.checkExpressionValueIsNotNull(objectArray, (String)"enumConstants");
        return MapsKt.toMap((Sequence)SequencesKt.mapIndexed((Sequence)ArraysKt.asSequence((Object[])objectArray), (Function2)constants.1.INSTANCE));
    }

    @NotNull
    public static final /* synthetic */ Map access$getConstants$p(EnumTransformationTests $this, @NotNull Class $receiver) {
        return $this.getConstants($receiver);
    }

    @CordaSerializationTransformEnumDefaults(value={@CordaSerializationTransformEnumDefault(new="D", old="C"), @CordaSerializationTransformEnumDefault(new="E", old="D")})
    @CordaSerializationTransformRenames(value={@CordaSerializationTransformRename(to="BOB", from="FRED"), @CordaSerializationTransformRename(to="FRED", from="E")})
    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0087\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lnet/corda/serialization/internal/amqp/EnumTransformationTests$MultiOperations;", "", "(Ljava/lang/String;I)V", "A", "B", "C", "D", "BOB", "serialization"})
    public static final class MultiOperations
    extends Enum<MultiOperations> {
        public static final /* enum */ MultiOperations A;
        public static final /* enum */ MultiOperations B;
        public static final /* enum */ MultiOperations C;
        public static final /* enum */ MultiOperations D;
        public static final /* enum */ MultiOperations BOB;
        private static final /* synthetic */ MultiOperations[] $VALUES;

        static {
            MultiOperations[] multiOperationsArray = new MultiOperations[5];
            MultiOperations[] multiOperationsArray2 = multiOperationsArray;
            multiOperationsArray[0] = A = new MultiOperations();
            multiOperationsArray[1] = B = new MultiOperations();
            multiOperationsArray[2] = C = new MultiOperations();
            multiOperationsArray[3] = D = new MultiOperations();
            multiOperationsArray[4] = BOB = new MultiOperations();
            $VALUES = multiOperationsArray;
        }

        public static MultiOperations[] values() {
            return (MultiOperations[])$VALUES.clone();
        }

        public static MultiOperations valueOf(String string) {
            return Enum.valueOf(MultiOperations.class, string);
        }
    }

    @CordaSerializationTransformRenames(value={@CordaSerializationTransformRename(from="A", to="C"), @CordaSerializationTransformRename(from="B", to="D"), @CordaSerializationTransformRename(from="C", to="E"), @CordaSerializationTransformRename(from="E", to="B"), @CordaSerializationTransformRename(from="D", to="A")})
    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0087\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lnet/corda/serialization/internal/amqp/EnumTransformationTests$RenameCycle;", "", "(Ljava/lang/String;I)V", "A", "B", "C", "D", "E", "serialization"})
    public static final class RenameCycle
    extends Enum<RenameCycle> {
        public static final /* enum */ RenameCycle A;
        public static final /* enum */ RenameCycle B;
        public static final /* enum */ RenameCycle C;
        public static final /* enum */ RenameCycle D;
        public static final /* enum */ RenameCycle E;
        private static final /* synthetic */ RenameCycle[] $VALUES;

        static {
            RenameCycle[] renameCycleArray = new RenameCycle[5];
            RenameCycle[] renameCycleArray2 = renameCycleArray;
            renameCycleArray[0] = A = new RenameCycle();
            renameCycleArray[1] = B = new RenameCycle();
            renameCycleArray[2] = C = new RenameCycle();
            renameCycleArray[3] = D = new RenameCycle();
            renameCycleArray[4] = E = new RenameCycle();
            $VALUES = renameCycleArray;
        }

        public static RenameCycle[] values() {
            return (RenameCycle[])$VALUES.clone();
        }

        public static RenameCycle valueOf(String string) {
            return Enum.valueOf(RenameCycle.class, string);
        }
    }

    @CordaSerializationTransformRenames(value={@CordaSerializationTransformRename(from="P", to="Q"), @CordaSerializationTransformRename(from="Q", to="R")})
    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0087\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lnet/corda/serialization/internal/amqp/EnumTransformationTests$DanglingRenames;", "", "(Ljava/lang/String;I)V", "A", "B", "C", "serialization"})
    public static final class DanglingRenames
    extends Enum<DanglingRenames> {
        public static final /* enum */ DanglingRenames A;
        public static final /* enum */ DanglingRenames B;
        public static final /* enum */ DanglingRenames C;
        private static final /* synthetic */ DanglingRenames[] $VALUES;

        static {
            DanglingRenames[] danglingRenamesArray = new DanglingRenames[3];
            DanglingRenames[] danglingRenamesArray2 = danglingRenamesArray;
            danglingRenamesArray[0] = A = new DanglingRenames();
            danglingRenamesArray[1] = B = new DanglingRenames();
            danglingRenamesArray[2] = C = new DanglingRenames();
            $VALUES = danglingRenamesArray;
        }

        public static DanglingRenames[] values() {
            return (DanglingRenames[])$VALUES.clone();
        }

        public static DanglingRenames valueOf(String string) {
            return Enum.valueOf(DanglingRenames.class, string);
        }
    }

    @CordaSerializationTransformRenames(value={@CordaSerializationTransformRename(from="P", to="Q"), @CordaSerializationTransformRename(from="Q", to="R")})
    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0087\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lnet/corda/serialization/internal/amqp/EnumTransformationTests$RenamesExisting;", "", "(Ljava/lang/String;I)V", "Q", "R", "S", "serialization"})
    public static final class RenamesExisting
    extends Enum<RenamesExisting> {
        public static final /* enum */ RenamesExisting Q;
        public static final /* enum */ RenamesExisting R;
        public static final /* enum */ RenamesExisting S;
        private static final /* synthetic */ RenamesExisting[] $VALUES;

        static {
            RenamesExisting[] renamesExistingArray = new RenamesExisting[3];
            RenamesExisting[] renamesExistingArray2 = renamesExistingArray;
            renamesExistingArray[0] = Q = new RenamesExisting();
            renamesExistingArray[1] = R = new RenamesExisting();
            renamesExistingArray[2] = S = new RenamesExisting();
            $VALUES = renamesExistingArray;
        }

        public static RenamesExisting[] values() {
            return (RenamesExisting[])$VALUES.clone();
        }

        public static RenamesExisting valueOf(String string) {
            return Enum.valueOf(RenamesExisting.class, string);
        }
    }
}

