/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp;

import java.io.NotSerializableException;
import java.net.URL;
import java.time.DayOfWeek;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.test.AssertionsKt;
import net.corda.core.serialization.ClassWhitelist;
import net.corda.core.serialization.CordaSerializable;
import net.corda.core.serialization.SerializationContext;
import net.corda.core.serialization.SerializedBytes;
import net.corda.core.utilities.ByteSequence;
import net.corda.serialization.internal.EmptyWhitelist;
import net.corda.serialization.internal.amqp.Choice;
import net.corda.serialization.internal.amqp.CompositeType;
import net.corda.serialization.internal.amqp.DeserializationInput;
import net.corda.serialization.internal.amqp.EnumTests;
import net.corda.serialization.internal.amqp.Field;
import net.corda.serialization.internal.amqp.ObjectAndEnvelope;
import net.corda.serialization.internal.amqp.RestrictedType;
import net.corda.serialization.internal.amqp.Schema;
import net.corda.serialization.internal.amqp.SerializerFactory;
import net.corda.serialization.internal.amqp.SerializerFactoryBuilder;
import net.corda.serialization.internal.amqp.TypeNotation;
import net.corda.serialization.internal.amqp.testutils.AMQPTestUtilsKt;
import net.corda.serialization.internal.amqp.testutils.TestSerializationContextKt;
import net.corda.serialization.internal.amqp.testutils.TestSerializationOutput;
import net.corda.serialization.internal.carpenter.ClassCarpenter;
import net.corda.serialization.internal.carpenter.ClassCarpenterImpl;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableAssert;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;
import org.junit.Test;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0015\u0018\u0000 \u00182\u00020\u0001:\b\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0007J\b\u0010\t\u001a\u00020\bH\u0007J\u0011\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004H\u0082\bJ\b\u0010\f\u001a\u00020\bH\u0007J\b\u0010\r\u001a\u00020\bH\u0007J\b\u0010\u000e\u001a\u00020\bH\u0007J\b\u0010\u000f\u001a\u00020\bH\u0007J\b\u0010\u0010\u001a\u00020\bH\u0007J\b\u0010\u0011\u001a\u00020\bH\u0007J\b\u0010\u0012\u001a\u00020\bH\u0007J\b\u0010\u0013\u001a\u00020\bH\u0007J\b\u0010\u0014\u001a\u00020\bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lnet/corda/serialization/internal/amqp/EnumTests;", "", "()V", "brasTestName", "", "sf1", "Lnet/corda/serialization/internal/amqp/SerializerFactory;", "changedEnum1", "", "changedEnum2", "classTestName", "clazz", "deserialiseSimpleTest", "deserializeCustomisedEnum", "deserializeNonWhitlistedEnum", "enumAnnotated", "enumNotWhitelistedFails", "enumWhitelisted", "enumWithInit", "multiEnum", "serialiseSimpleTest", "AnnotatedBras", "Bras", "BrasWithInit", "Companion", "CustomEnum", "CustomEnumWrapper", "OldBras", "OldBras2", "serialization"})
public final class EnumTests {
    private final String brasTestName = this.getClass().getName() + "$Bras";
    private final SerializerFactory sf1 = AMQPTestUtilsKt.testDefaultFactoryNoEvolution$default(null, 1, null);
    private static final boolean VERBOSE = false;
    public static final Companion Companion = new Companion(null);

    private final String classTestName(String clazz) {
        return this.getClass().getName() + '$' + AMQPTestUtilsKt.testName() + '$' + clazz;
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void serialiseSimpleTest() {
        Object object;
        Object it;
        CompositeType schema_c;
        Object object2;
        Object object3;
        block7: {
            Object object4;
            Object it2;
            Object object52;
            Iterable iterable;
            Schema schema;
            block6: {
                Iterable iterable2;
                @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000'\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0018\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"net/corda/serialization/internal/amqp/EnumTests$serialiseSimpleTest$C", "", "c", "Lnet/corda/serialization/internal/amqp/EnumTests$Bras;", "(Lnet/corda/serialization/internal/amqp/EnumTests$Bras;)V", "getC", "()Lnet/corda/serialization/internal/amqp/EnumTests$Bras;", "component1", "copy", "(Lnet/corda/serialization/internal/amqp/EnumTests$Bras;)Lnet/corda/serialization/internal/amqp/EnumTests$serialiseSimpleTest$C;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
                public final class C {
                    @NotNull
                    private final Bras c;

                    @NotNull
                    public final Bras getC() {
                        return this.c;
                    }

                    public C(@NotNull Bras c) {
                        Intrinsics.checkParameterIsNotNull((Object)((Object)c), (String)"c");
                        this.c = c;
                    }

                    @NotNull
                    public final Bras component1() {
                        return this.c;
                    }

                    @NotNull
                    public final C copy(@NotNull Bras c) {
                        Intrinsics.checkParameterIsNotNull((Object)((Object)c), (String)"c");
                        return new C(c);
                    }

                    @NotNull
                    public static /* bridge */ /* synthetic */ C copy$default(C c, Bras bras, int n, Object object) {
                        if ((n & 1) != 0) {
                            bras = c.c;
                        }
                        return c.copy(bras);
                    }

                    @NotNull
                    public String toString() {
                        return "C(c=" + (Object)((Object)this.c) + ")";
                    }

                    public int hashCode() {
                        Bras bras = this.c;
                        return bras != null ? ((Object)((Object)bras)).hashCode() : 0;
                    }

                    public boolean equals(@Nullable Object object) {
                        block3: {
                            block2: {
                                if (this == object) break block2;
                                if (!(object instanceof C)) break block3;
                                C c = (C)object;
                                if (!Intrinsics.areEqual((Object)((Object)this.c), (Object)((Object)c.c))) break block3;
                            }
                            return true;
                        }
                        return false;
                    }
                }
                schema = AMQPTestUtilsKt.serializeAndReturnSchema$default(new TestSerializationOutput(false, this.sf1), new C(Bras.UNDERWIRE), null, 2, null).getSchema();
                AssertionsKt.assertEquals$default((Object)2, (Object)schema.getTypes().size(), null, (int)4, null);
                iterable = iterable2 = (Iterable)schema.getTypes();
                for (Object object52 : iterable) {
                    void clazz$iv;
                    void this_$iv;
                    it2 = (TypeNotation)object52;
                    EnumTests enumTests = this;
                    String string = "C";
                    object3 = it2.getName();
                    if (!Intrinsics.areEqual((Object)object3, (Object)(object2 = this_$iv.getClass().getName() + '$' + AMQPTestUtilsKt.testName() + '$' + (String)clazz$iv))) continue;
                    object4 = object52;
                    break block6;
                }
                object4 = null;
            }
            if (object4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.corda.serialization.internal.amqp.CompositeType");
            }
            schema_c = (CompositeType)object4;
            iterable = schema.getTypes();
            Iterable iterable3 = iterable;
            object52 = iterable3.iterator();
            while (object52.hasNext()) {
                it2 = object52.next();
                it = it2;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)this.brasTestName)) continue;
                object = it2;
                break block7;
            }
            object = null;
        }
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.corda.serialization.internal.amqp.RestrictedType");
        }
        RestrictedType schema_bras = (RestrictedType)object;
        AssertionsKt.assertNotNull$default((Object)schema_c, null, (int)2, null);
        AssertionsKt.assertNotNull$default((Object)schema_bras, null, (int)2, null);
        AssertionsKt.assertEquals$default((Object)1, (Object)schema_c.getFields().size(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)"c", (Object)((Field)CollectionsKt.first((List)schema_c.getFields())).getName(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)this.brasTestName, (Object)((Field)CollectionsKt.first((List)schema_c.getFields())).getType(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)8, (Object)schema_bras.getChoices().size(), null, (int)4, null);
        for (Bras element$iv : Bras.values()) {
            Object v2;
            block8: {
                Object bra = it = element$iv;
                object2 = object3 = (Iterable)schema_bras.getChoices();
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    Object t = iterator.next();
                    Choice it3 = (Choice)t;
                    if (!Intrinsics.areEqual((Object)it3.getName(), (Object)((Enum)bra).name())) continue;
                    v2 = t;
                    break block8;
                }
                v2 = null;
            }
            AssertionsKt.assertNotNull$default(v2, null, (int)2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void deserialiseSimpleTest() {
        Object object;
        Object it;
        CompositeType schema_c;
        Object object2;
        Object object3;
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000'\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0018\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"net/corda/serialization/internal/amqp/EnumTests$deserialiseSimpleTest$C", "", "c", "Lnet/corda/serialization/internal/amqp/EnumTests$Bras;", "(Lnet/corda/serialization/internal/amqp/EnumTests$Bras;)V", "getC", "()Lnet/corda/serialization/internal/amqp/EnumTests$Bras;", "component1", "copy", "(Lnet/corda/serialization/internal/amqp/EnumTests$Bras;)Lnet/corda/serialization/internal/amqp/EnumTests$deserialiseSimpleTest$C;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
        public final class C {
            @NotNull
            private final Bras c;

            @NotNull
            public final Bras getC() {
                return this.c;
            }

            public C(@NotNull Bras c) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)c), (String)"c");
                this.c = c;
            }

            @NotNull
            public final Bras component1() {
                return this.c;
            }

            @NotNull
            public final C copy(@NotNull Bras c) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)c), (String)"c");
                return new C(c);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ C copy$default(C c, Bras bras, int n, Object object) {
                if ((n & 1) != 0) {
                    bras = c.c;
                }
                return c.copy(bras);
            }

            @NotNull
            public String toString() {
                return "C(c=" + (Object)((Object)this.c) + ")";
            }

            public int hashCode() {
                Bras bras = this.c;
                return bras != null ? ((Object)((Object)bras)).hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof C)) break block3;
                        C c = (C)object;
                        if (!Intrinsics.areEqual((Object)((Object)this.c), (Object)((Object)c.c))) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        C obj;
        block7: {
            Object object4;
            Object it2;
            Object object52;
            Iterable iterable;
            Schema schema;
            block6: {
                Iterable $i$f$deserializeAndReturnEnvelope;
                void $receiver$iv;
                DeserializationInput deserializationInput = new DeserializationInput(this.sf1);
                SerializedBytes<C> bytes$iv = new TestSerializationOutput(false, this.sf1).serialize(new C(Bras.UNDERWIRE));
                SerializationContext context$iv = null;
                ObjectAndEnvelope objAndEnvelope = $receiver$iv.deserializeAndReturnEnvelope(bytes$iv, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
                obj = (C)objAndEnvelope.getObj();
                schema = objAndEnvelope.getEnvelope().getSchema();
                AssertionsKt.assertEquals$default((Object)2, (Object)schema.getTypes().size(), null, (int)4, null);
                iterable = $i$f$deserializeAndReturnEnvelope = (Iterable)schema.getTypes();
                for (Object object52 : iterable) {
                    void clazz$iv;
                    void this_$iv;
                    it2 = (TypeNotation)object52;
                    EnumTests enumTests = this;
                    String string = "C";
                    object3 = it2.getName();
                    if (!Intrinsics.areEqual((Object)object3, (Object)(object2 = this_$iv.getClass().getName() + '$' + AMQPTestUtilsKt.testName() + '$' + (String)clazz$iv))) continue;
                    object4 = object52;
                    break block6;
                }
                object4 = null;
            }
            if (object4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.corda.serialization.internal.amqp.CompositeType");
            }
            schema_c = (CompositeType)object4;
            iterable = schema.getTypes();
            Iterable iterable2 = iterable;
            object52 = iterable2.iterator();
            while (object52.hasNext()) {
                it2 = object52.next();
                it = it2;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)this.brasTestName)) continue;
                object = it2;
                break block7;
            }
            object = null;
        }
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.corda.serialization.internal.amqp.RestrictedType");
        }
        RestrictedType schema_bras = (RestrictedType)object;
        AssertionsKt.assertEquals$default((Object)1, (Object)schema_c.getFields().size(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)"c", (Object)((Field)CollectionsKt.first((List)schema_c.getFields())).getName(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)this.brasTestName, (Object)((Field)CollectionsKt.first((List)schema_c.getFields())).getType(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)8, (Object)schema_bras.getChoices().size(), null, (int)4, null);
        for (Bras element$iv : Bras.values()) {
            Object v2;
            block8: {
                Object bra = it = element$iv;
                object2 = object3 = (Iterable)schema_bras.getChoices();
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    Object t = iterator.next();
                    Choice it3 = (Choice)t;
                    if (!Intrinsics.areEqual((Object)it3.getName(), (Object)((Enum)bra).name())) continue;
                    v2 = t;
                    break block8;
                }
                v2 = null;
            }
            AssertionsKt.assertNotNull$default(v2, null, (int)2, null);
        }
        AssertionsKt.assertEquals$default((Object)((Object)obj.getC()), (Object)((Object)Bras.UNDERWIRE), null, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void multiEnum() {
        void $receiver$iv;
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0002\u0000\u0004\b\u008a\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u001e\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"net/corda/serialization/internal/amqp/EnumTests$multiEnum$WeeklySupport", "", "tops", "", "net/corda/serialization/internal/amqp/EnumTests$multiEnum$Support", "(Ljava/util/List;)V", "getTops", "()Ljava/util/List;", "component1", "copy", "(Ljava/util/List;)Lnet/corda/serialization/internal/amqp/EnumTests$multiEnum$WeeklySupport;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
        public final class WeeklySupport {
            @NotNull
            private final List<Support> tops;

            @NotNull
            public final List<Support> getTops() {
                @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000-\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\"\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000eJ\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"net/corda/serialization/internal/amqp/EnumTests$multiEnum$Support", "", "top", "Lnet/corda/serialization/internal/amqp/EnumTests$Bras;", "day", "Ljava/time/DayOfWeek;", "(Lnet/corda/serialization/internal/amqp/EnumTests$Bras;Ljava/time/DayOfWeek;)V", "getDay", "()Ljava/time/DayOfWeek;", "getTop", "()Lnet/corda/serialization/internal/amqp/EnumTests$Bras;", "component1", "component2", "copy", "(Lnet/corda/serialization/internal/amqp/EnumTests$Bras;Ljava/time/DayOfWeek;)Lnet/corda/serialization/internal/amqp/EnumTests$multiEnum$Support;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
                public final class Support {
                    @NotNull
                    private final Bras top;
                    @NotNull
                    private final DayOfWeek day;

                    @NotNull
                    public final Bras getTop() {
                        return this.top;
                    }

                    @NotNull
                    public final DayOfWeek getDay() {
                        return this.day;
                    }

                    public Support(@NotNull Bras top, @NotNull DayOfWeek day) {
                        Intrinsics.checkParameterIsNotNull((Object)((Object)top), (String)"top");
                        Intrinsics.checkParameterIsNotNull((Object)day, (String)"day");
                        this.top = top;
                        this.day = day;
                    }

                    @NotNull
                    public final Bras component1() {
                        return this.top;
                    }

                    @NotNull
                    public final DayOfWeek component2() {
                        return this.day;
                    }

                    @NotNull
                    public final Support copy(@NotNull Bras top, @NotNull DayOfWeek day) {
                        Intrinsics.checkParameterIsNotNull((Object)((Object)top), (String)"top");
                        Intrinsics.checkParameterIsNotNull((Object)day, (String)"day");
                        return new Support(top, day);
                    }

                    @NotNull
                    public static /* bridge */ /* synthetic */ Support copy$default(Support support, Bras bras, DayOfWeek dayOfWeek, int n, Object object) {
                        if ((n & 1) != 0) {
                            bras = support.top;
                        }
                        if ((n & 2) != 0) {
                            dayOfWeek = support.day;
                        }
                        return support.copy(bras, dayOfWeek);
                    }

                    @NotNull
                    public String toString() {
                        return "Support(top=" + (Object)((Object)this.top) + ", day=" + this.day + ")";
                    }

                    public int hashCode() {
                        Bras bras = this.top;
                        DayOfWeek dayOfWeek = this.day;
                        return (bras != null ? ((Object)((Object)bras)).hashCode() : 0) * 31 + (dayOfWeek != null ? dayOfWeek.hashCode() : 0);
                    }

                    public boolean equals(@Nullable Object object) {
                        block3: {
                            block2: {
                                if (this == object) break block2;
                                if (!(object instanceof Support)) break block3;
                                Support support = (Support)object;
                                if (!Intrinsics.areEqual((Object)((Object)this.top), (Object)((Object)support.top)) || !Intrinsics.areEqual((Object)this.day, (Object)support.day)) break block3;
                            }
                            return true;
                        }
                        return false;
                    }
                }
                return this.tops;
            }

            public WeeklySupport(@NotNull List<Support> tops) {
                Intrinsics.checkParameterIsNotNull(tops, (String)"tops");
                this.tops = tops;
            }

            @NotNull
            public final List<Support> component1() {
                return this.tops;
            }

            @NotNull
            public final WeeklySupport copy(@NotNull List<Support> tops) {
                Intrinsics.checkParameterIsNotNull(tops, (String)"tops");
                return new WeeklySupport(tops);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ WeeklySupport copy$default(WeeklySupport weeklySupport, List list, int n, Object object) {
                if ((n & 1) != 0) {
                    list = weeklySupport.tops;
                }
                return weeklySupport.copy(list);
            }

            @NotNull
            public String toString() {
                return "WeeklySupport(tops=" + this.tops + ")";
            }

            public int hashCode() {
                List<Support> list = this.tops;
                return list != null ? ((Object)list).hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof WeeklySupport)) break block3;
                        WeeklySupport weeklySupport = (WeeklySupport)object;
                        if (!Intrinsics.areEqual(this.tops, weeklySupport.tops)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        WeeklySupport week = new WeeklySupport(CollectionsKt.listOf((Object[])new Support[]{new Support(Bras.PUSHUP, DayOfWeek.MONDAY), new Support(Bras.UNDERWIRE, DayOfWeek.WEDNESDAY), new Support(Bras.PADDED, DayOfWeek.SUNDAY)}));
        DeserializationInput deserializationInput = new DeserializationInput(this.sf1);
        SerializedBytes<WeeklySupport> bytes$iv = new TestSerializationOutput(false, this.sf1).serialize(week);
        SerializationContext context$iv = null;
        WeeklySupport obj = (WeeklySupport)$receiver$iv.deserialize((ByteSequence)bytes$iv, WeeklySupport.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)((Object)week.getTops().get(0).getTop()), (Object)((Object)obj.getTops().get(0).getTop()), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)week.getTops().get(0).getDay(), (Object)obj.getTops().get(0).getDay(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)((Object)week.getTops().get(1).getTop()), (Object)((Object)obj.getTops().get(1).getTop()), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)week.getTops().get(1).getDay(), (Object)obj.getTops().get(1).getDay(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)((Object)week.getTops().get(2).getTop()), (Object)((Object)obj.getTops().get(2).getTop()), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)week.getTops().get(2).getDay(), (Object)obj.getTops().get(2).getDay(), null, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void enumWithInit() {
        void $receiver$iv;
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000'\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0018\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"net/corda/serialization/internal/amqp/EnumTests$enumWithInit$C", "", "c", "Lnet/corda/serialization/internal/amqp/EnumTests$BrasWithInit;", "(Lnet/corda/serialization/internal/amqp/EnumTests$BrasWithInit;)V", "getC", "()Lnet/corda/serialization/internal/amqp/EnumTests$BrasWithInit;", "component1", "copy", "(Lnet/corda/serialization/internal/amqp/EnumTests$BrasWithInit;)Lnet/corda/serialization/internal/amqp/EnumTests$enumWithInit$C;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
        public final class C {
            @NotNull
            private final BrasWithInit c;

            @NotNull
            public final BrasWithInit getC() {
                return this.c;
            }

            public C(@NotNull BrasWithInit c) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)c), (String)"c");
                this.c = c;
            }

            @NotNull
            public final BrasWithInit component1() {
                return this.c;
            }

            @NotNull
            public final C copy(@NotNull BrasWithInit c) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)c), (String)"c");
                return new C(c);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ C copy$default(C c, BrasWithInit brasWithInit, int n, Object object) {
                if ((n & 1) != 0) {
                    brasWithInit = c.c;
                }
                return c.copy(brasWithInit);
            }

            @NotNull
            public String toString() {
                return "C(c=" + (Object)((Object)this.c) + ")";
            }

            public int hashCode() {
                BrasWithInit brasWithInit = this.c;
                return brasWithInit != null ? ((Object)((Object)brasWithInit)).hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof C)) break block3;
                        C c = (C)object;
                        if (!Intrinsics.areEqual((Object)((Object)this.c), (Object)((Object)c.c))) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        C c = new C(BrasWithInit.PUSHUP);
        DeserializationInput deserializationInput = new DeserializationInput(this.sf1);
        SerializedBytes<C> bytes$iv = new TestSerializationOutput(false, this.sf1).serialize(c);
        SerializationContext context$iv = null;
        C obj = (C)$receiver$iv.deserialize((ByteSequence)bytes$iv, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)((Object)c.getC()), (Object)((Object)obj.getC()), null, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Test(expected=NotSerializableException.class, timeout=300000L)
    public final void changedEnum1() {
        void $receiver$iv;
        URL url;
        URL uRL = url = EnumTests.class.getResource("EnumTests.changedEnum1");
        Intrinsics.checkExpressionValueIsNotNull((Object)uRL, (String)"url");
        byte[] sc2 = TextStreamsKt.readBytes((URL)uRL);
        DeserializationInput deserializationInput = new DeserializationInput(this.sf1);
        SerializedBytes bytes$iv = new SerializedBytes(sc2);
        SerializationContext context$iv = null;
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000'\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0018\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"net/corda/serialization/internal/amqp/EnumTests$changedEnum1$C", "", "a", "Lnet/corda/serialization/internal/amqp/EnumTests$OldBras;", "(Lnet/corda/serialization/internal/amqp/EnumTests$OldBras;)V", "getA", "()Lnet/corda/serialization/internal/amqp/EnumTests$OldBras;", "component1", "copy", "(Lnet/corda/serialization/internal/amqp/EnumTests$OldBras;)Lnet/corda/serialization/internal/amqp/EnumTests$changedEnum1$C;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
        public final class C {
            @NotNull
            private final OldBras a;

            @NotNull
            public final OldBras getA() {
                return this.a;
            }

            public C(@NotNull OldBras a) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)a), (String)"a");
                this.a = a;
            }

            @NotNull
            public final OldBras component1() {
                return this.a;
            }

            @NotNull
            public final C copy(@NotNull OldBras a) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)a), (String)"a");
                return new C(a);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ C copy$default(C c, OldBras oldBras, int n, Object object) {
                if ((n & 1) != 0) {
                    oldBras = c.a;
                }
                return c.copy(oldBras);
            }

            @NotNull
            public String toString() {
                return "C(a=" + (Object)((Object)this.a) + ")";
            }

            public int hashCode() {
                OldBras oldBras = this.a;
                return oldBras != null ? ((Object)((Object)oldBras)).hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof C)) break block3;
                        C c = (C)object;
                        if (!Intrinsics.areEqual((Object)((Object)this.a), (Object)((Object)c.a))) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        $receiver$iv.deserialize((ByteSequence)bytes$iv, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
    }

    /*
     * WARNING - void declaration
     */
    @Test(expected=NotSerializableException.class, timeout=300000L)
    public final void changedEnum2() {
        void $receiver$iv;
        URL url;
        URL uRL = url = EnumTests.class.getResource("EnumTests.changedEnum2");
        Intrinsics.checkExpressionValueIsNotNull((Object)uRL, (String)"url");
        byte[] sc2 = TextStreamsKt.readBytes((URL)uRL);
        DeserializationInput deserializationInput = new DeserializationInput(this.sf1);
        SerializedBytes bytes$iv = new SerializedBytes(sc2);
        SerializationContext context$iv = null;
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000'\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0018\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"net/corda/serialization/internal/amqp/EnumTests$changedEnum2$C", "", "a", "Lnet/corda/serialization/internal/amqp/EnumTests$OldBras2;", "(Lnet/corda/serialization/internal/amqp/EnumTests$OldBras2;)V", "getA", "()Lnet/corda/serialization/internal/amqp/EnumTests$OldBras2;", "component1", "copy", "(Lnet/corda/serialization/internal/amqp/EnumTests$OldBras2;)Lnet/corda/serialization/internal/amqp/EnumTests$changedEnum2$C;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
        public final class C {
            @NotNull
            private final OldBras2 a;

            @NotNull
            public final OldBras2 getA() {
                return this.a;
            }

            public C(@NotNull OldBras2 a) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)a), (String)"a");
                this.a = a;
            }

            @NotNull
            public final OldBras2 component1() {
                return this.a;
            }

            @NotNull
            public final C copy(@NotNull OldBras2 a) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)a), (String)"a");
                return new C(a);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ C copy$default(C c, OldBras2 oldBras2, int n, Object object) {
                if ((n & 1) != 0) {
                    oldBras2 = c.a;
                }
                return c.copy(oldBras2);
            }

            @NotNull
            public String toString() {
                return "C(a=" + (Object)((Object)this.a) + ")";
            }

            public int hashCode() {
                OldBras2 oldBras2 = this.a;
                return oldBras2 != null ? ((Object)((Object)oldBras2)).hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof C)) break block3;
                        C c = (C)object;
                        if (!Intrinsics.areEqual((Object)((Object)this.a), (Object)((Object)c.a))) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        $receiver$iv.deserialize((ByteSequence)bytes$iv, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void enumNotWhitelistedFails() {
        void clazz$iv;
        void this_$iv;
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"net/corda/serialization/internal/amqp/EnumTests$enumNotWhitelistedFails$WL", "Lnet/corda/core/serialization/ClassWhitelist;", "allowed", "", "(Ljava/lang/String;)V", "getAllowed", "()Ljava/lang/String;", "hasListed", "", "type", "Ljava/lang/Class;", "serialization"})
        public final class WL
        implements ClassWhitelist {
            @NotNull
            private final String allowed;

            public boolean hasListed(@NotNull Class<?> type2) {
                Intrinsics.checkParameterIsNotNull(type2, (String)"type");
                return Intrinsics.areEqual((Object)type2.getName(), (Object)this.allowed);
            }

            @NotNull
            public final String getAllowed() {
                return this.allowed;
            }

            public WL(@NotNull String allowed) {
                Intrinsics.checkParameterIsNotNull((Object)allowed, (String)"allowed");
                this.allowed = allowed;
            }
        }
        WL wL;
        EnumTests enumTests = this;
        String string = "C";
        WL wL2 = wL;
        WL wL3 = wL;
        String string2 = this_$iv.getClass().getName() + '$' + AMQPTestUtilsKt.testName() + '$' + (String)clazz$iv;
        wL2(string2);
        WL whitelist = wL3;
        ClassWhitelist classWhitelist = whitelist;
        ClassWhitelist classWhitelist2 = whitelist;
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        Intrinsics.checkExpressionValueIsNotNull((Object)classLoader, (String)"ClassLoader.getSystemClassLoader()");
        SerializerFactory factory = SerializerFactoryBuilder.build((ClassWhitelist)classWhitelist, (ClassCarpenter)((ClassCarpenter)new ClassCarpenterImpl(classWhitelist2, classLoader, false, 4, null)));
        Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)new ThrowableAssert.ThrowingCallable(factory){
            final /* synthetic */ SerializerFactory $factory;

            public final void call() {
                @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000'\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0018\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"net/corda/serialization/internal/amqp/EnumTests$enumNotWhitelistedFails$C", "", "c", "Lnet/corda/serialization/internal/amqp/EnumTests$Bras;", "(Lnet/corda/serialization/internal/amqp/EnumTests$Bras;)V", "getC", "()Lnet/corda/serialization/internal/amqp/EnumTests$Bras;", "component1", "copy", "(Lnet/corda/serialization/internal/amqp/EnumTests$Bras;)Lnet/corda/serialization/internal/amqp/EnumTests$enumNotWhitelistedFails$C;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
                public final class C {
                    @NotNull
                    private final Bras c;

                    @NotNull
                    public final Bras getC() {
                        return this.c;
                    }

                    public C(@NotNull Bras c) {
                        Intrinsics.checkParameterIsNotNull((Object)((Object)c), (String)"c");
                        this.c = c;
                    }

                    @NotNull
                    public final Bras component1() {
                        return this.c;
                    }

                    @NotNull
                    public final C copy(@NotNull Bras c) {
                        Intrinsics.checkParameterIsNotNull((Object)((Object)c), (String)"c");
                        return new C(c);
                    }

                    @NotNull
                    public static /* bridge */ /* synthetic */ C copy$default(C c, Bras bras, int n, Object object) {
                        if ((n & 1) != 0) {
                            bras = c.c;
                        }
                        return c.copy(bras);
                    }

                    @NotNull
                    public String toString() {
                        return "C(c=" + (Object)((Object)this.c) + ")";
                    }

                    public int hashCode() {
                        Bras bras = this.c;
                        return bras != null ? ((Object)((Object)bras)).hashCode() : 0;
                    }

                    public boolean equals(@Nullable Object object) {
                        block3: {
                            block2: {
                                if (this == object) break block2;
                                if (!(object instanceof C)) break block3;
                                C c = (C)object;
                                if (!Intrinsics.areEqual((Object)((Object)this.c), (Object)((Object)c.c))) break block3;
                            }
                            return true;
                        }
                        return false;
                    }
                }
                new TestSerializationOutput(false, this.$factory).serialize(new C(Bras.UNDERWIRE));
            }
            {
                this.$factory = serializerFactory;
            }
        }).isInstanceOf(NotSerializableException.class);
    }

    @Test(timeout=300000L)
    public final void enumWhitelisted() {
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0019\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0016\u00a8\u0006\u0007"}, d2={"net/corda/serialization/internal/amqp/EnumTests$enumWhitelisted$WL", "Lnet/corda/core/serialization/ClassWhitelist;", "()V", "hasListed", "", "type", "Ljava/lang/Class;", "serialization"})
        public final class WL
        implements ClassWhitelist {
            public boolean hasListed(@NotNull Class<?> type2) {
                Intrinsics.checkParameterIsNotNull(type2, (String)"type");
                return Intrinsics.areEqual((Object)type2.getName(), (Object)"net.corda.serialization.internal.amqp.EnumTests$enumWhitelisted$C") || Intrinsics.areEqual((Object)type2.getName(), (Object)"net.corda.serialization.internal.amqp.EnumTests$Bras");
            }

            public WL() {
            }
        }
        WL whitelist = new WL();
        ClassWhitelist classWhitelist = whitelist;
        ClassWhitelist classWhitelist2 = whitelist;
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        Intrinsics.checkExpressionValueIsNotNull((Object)classLoader, (String)"ClassLoader.getSystemClassLoader()");
        SerializerFactory factory = SerializerFactoryBuilder.build((ClassWhitelist)classWhitelist, (ClassCarpenter)((ClassCarpenter)new ClassCarpenterImpl(classWhitelist2, classLoader, false, 4, null)));
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000'\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0018\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"net/corda/serialization/internal/amqp/EnumTests$enumWhitelisted$C", "", "c", "Lnet/corda/serialization/internal/amqp/EnumTests$Bras;", "(Lnet/corda/serialization/internal/amqp/EnumTests$Bras;)V", "getC", "()Lnet/corda/serialization/internal/amqp/EnumTests$Bras;", "component1", "copy", "(Lnet/corda/serialization/internal/amqp/EnumTests$Bras;)Lnet/corda/serialization/internal/amqp/EnumTests$enumWhitelisted$C;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
        public final class C {
            @NotNull
            private final Bras c;

            @NotNull
            public final Bras getC() {
                return this.c;
            }

            public C(@NotNull Bras c) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)c), (String)"c");
                this.c = c;
            }

            @NotNull
            public final Bras component1() {
                return this.c;
            }

            @NotNull
            public final C copy(@NotNull Bras c) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)c), (String)"c");
                return new C(c);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ C copy$default(C c, Bras bras, int n, Object object) {
                if ((n & 1) != 0) {
                    bras = c.c;
                }
                return c.copy(bras);
            }

            @NotNull
            public String toString() {
                return "C(c=" + (Object)((Object)this.c) + ")";
            }

            public int hashCode() {
                Bras bras = this.c;
                return bras != null ? ((Object)((Object)bras)).hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof C)) break block3;
                        C c = (C)object;
                        if (!Intrinsics.areEqual((Object)((Object)this.c), (Object)((Object)c.c))) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        new TestSerializationOutput(false, factory).serialize(new C(Bras.UNDERWIRE));
    }

    @Test(timeout=300000L)
    public final void enumAnnotated() {
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0019\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0016\u00a8\u0006\u0007"}, d2={"net/corda/serialization/internal/amqp/EnumTests$enumAnnotated$WL", "Lnet/corda/core/serialization/ClassWhitelist;", "()V", "hasListed", "", "type", "Ljava/lang/Class;", "serialization"})
        public final class WL
        implements ClassWhitelist {
            public boolean hasListed(@NotNull Class<?> type2) {
                Intrinsics.checkParameterIsNotNull(type2, (String)"type");
                return false;
            }

            public WL() {
            }
        }
        WL whitelist = new WL();
        ClassWhitelist classWhitelist = whitelist;
        ClassWhitelist classWhitelist2 = whitelist;
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        Intrinsics.checkExpressionValueIsNotNull((Object)classLoader, (String)"ClassLoader.getSystemClassLoader()");
        SerializerFactory factory = SerializerFactoryBuilder.build((ClassWhitelist)classWhitelist, (ClassCarpenter)((ClassCarpenter)new ClassCarpenterImpl(classWhitelist2, classLoader, false, 4, null)));
        @CordaSerializable
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000'\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008b\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0018\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"net/corda/serialization/internal/amqp/EnumTests$enumAnnotated$C", "", "c", "Lnet/corda/serialization/internal/amqp/EnumTests$AnnotatedBras;", "(Lnet/corda/serialization/internal/amqp/EnumTests$AnnotatedBras;)V", "getC", "()Lnet/corda/serialization/internal/amqp/EnumTests$AnnotatedBras;", "component1", "copy", "(Lnet/corda/serialization/internal/amqp/EnumTests$AnnotatedBras;)Lnet/corda/serialization/internal/amqp/EnumTests$enumAnnotated$C;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
        public final class C {
            @NotNull
            private final AnnotatedBras c;

            @NotNull
            public final AnnotatedBras getC() {
                return this.c;
            }

            public C(@NotNull AnnotatedBras c) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)c), (String)"c");
                this.c = c;
            }

            @NotNull
            public final AnnotatedBras component1() {
                return this.c;
            }

            @NotNull
            public final C copy(@NotNull AnnotatedBras c) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)c), (String)"c");
                return new C(c);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ C copy$default(C c, AnnotatedBras annotatedBras, int n, Object object) {
                if ((n & 1) != 0) {
                    annotatedBras = c.c;
                }
                return c.copy(annotatedBras);
            }

            @NotNull
            public String toString() {
                return "C(c=" + (Object)((Object)this.c) + ")";
            }

            public int hashCode() {
                AnnotatedBras annotatedBras = this.c;
                return annotatedBras != null ? ((Object)((Object)annotatedBras)).hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof C)) break block3;
                        C c = (C)object;
                        if (!Intrinsics.areEqual((Object)((Object)this.c), (Object)((Object)c.c))) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        new TestSerializationOutput(false, factory).serialize(new C(AnnotatedBras.UNDERWIRE));
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void deserializeNonWhitlistedEnum() {
        void clazz$iv;
        void this_$iv;
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0014\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"net/corda/serialization/internal/amqp/EnumTests$deserializeNonWhitlistedEnum$WL", "Lnet/corda/core/serialization/ClassWhitelist;", "allowed", "", "", "(Ljava/util/List;)V", "getAllowed", "()Ljava/util/List;", "hasListed", "", "type", "Ljava/lang/Class;", "serialization"})
        public final class WL
        implements ClassWhitelist {
            @NotNull
            private final List<String> allowed;

            public boolean hasListed(@NotNull Class<?> type2) {
                Intrinsics.checkParameterIsNotNull(type2, (String)"type");
                return this.allowed.contains(type2.getName());
            }

            @NotNull
            public final List<String> getAllowed() {
                return this.allowed;
            }

            public WL(@NotNull List<String> allowed) {
                Intrinsics.checkParameterIsNotNull(allowed, (String)"allowed");
                this.allowed = allowed;
            }
        }
        WL wL;
        void clazz$iv2;
        void this_$iv2;
        String string;
        WL wL2;
        Object[] objectArray;
        EnumTests enumTests = this;
        String string2 = "C";
        int n = 0;
        Object object = objectArray = new String[2];
        WL wL3 = wL2;
        WL wL4 = wL2;
        objectArray[n] = string = this_$iv2.getClass().getName() + '$' + AMQPTestUtilsKt.testName() + '$' + (String)clazz$iv2;
        object[1] = "net.corda.serialization.internal.amqp.EnumTests$Bras";
        wL3(CollectionsKt.listOf((Object[])object));
        WL whitelist = wL4;
        ClassWhitelist classWhitelist = whitelist;
        ClassWhitelist classWhitelist2 = whitelist;
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        Intrinsics.checkExpressionValueIsNotNull((Object)classLoader, (String)"ClassLoader.getSystemClassLoader()");
        SerializerFactory factory = SerializerFactoryBuilder.build((ClassWhitelist)classWhitelist, (ClassCarpenter)((ClassCarpenter)new ClassCarpenterImpl(classWhitelist2, classLoader, false, 4, null)));
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000'\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0018\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"net/corda/serialization/internal/amqp/EnumTests$deserializeNonWhitlistedEnum$C", "", "c", "Lnet/corda/serialization/internal/amqp/EnumTests$Bras;", "(Lnet/corda/serialization/internal/amqp/EnumTests$Bras;)V", "getC", "()Lnet/corda/serialization/internal/amqp/EnumTests$Bras;", "component1", "copy", "(Lnet/corda/serialization/internal/amqp/EnumTests$Bras;)Lnet/corda/serialization/internal/amqp/EnumTests$deserializeNonWhitlistedEnum$C;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
        public final class C {
            @NotNull
            private final Bras c;

            @NotNull
            public final Bras getC() {
                return this.c;
            }

            public C(@NotNull Bras c) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)c), (String)"c");
                this.c = c;
            }

            @NotNull
            public final Bras component1() {
                return this.c;
            }

            @NotNull
            public final C copy(@NotNull Bras c) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)c), (String)"c");
                return new C(c);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ C copy$default(C c, Bras bras, int n, Object object) {
                if ((n & 1) != 0) {
                    bras = c.c;
                }
                return c.copy(bras);
            }

            @NotNull
            public String toString() {
                return "C(c=" + (Object)((Object)this.c) + ")";
            }

            public int hashCode() {
                Bras bras = this.c;
                return bras != null ? ((Object)((Object)bras)).hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof C)) break block3;
                        C c = (C)object;
                        if (!Intrinsics.areEqual((Object)((Object)this.c), (Object)((Object)c.c))) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        SerializedBytes<C> bytes = new TestSerializationOutput(false, factory).serialize(new C(Bras.UNDERWIRE));
        EnumTests enumTests2 = this;
        String string3 = "C";
        wL3 = wL;
        wL4 = wL;
        object = this_$iv.getClass().getName() + '$' + AMQPTestUtilsKt.testName() + '$' + (String)clazz$iv;
        wL3(CollectionsKt.listOf((Object)object));
        WL whitelist1 = wL4;
        ClassWhitelist classWhitelist3 = whitelist1;
        ClassWhitelist classWhitelist4 = whitelist1;
        ClassLoader classLoader2 = ClassLoader.getSystemClassLoader();
        Intrinsics.checkExpressionValueIsNotNull((Object)classLoader2, (String)"ClassLoader.getSystemClassLoader()");
        SerializerFactory factory2 = SerializerFactoryBuilder.build((ClassWhitelist)classWhitelist3, (ClassCarpenter)((ClassCarpenter)new ClassCarpenterImpl(classWhitelist4, classLoader2, false, 4, null)));
        Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)new ThrowableAssert.ThrowingCallable(factory2, bytes){
            final /* synthetic */ SerializerFactory $factory2;
            final /* synthetic */ SerializedBytes $bytes;

            /*
             * WARNING - void declaration
             */
            public final void call() {
                void $receiver$iv;
                DeserializationInput deserializationInput = new DeserializationInput(this.$factory2);
                SerializedBytes bytes$iv = this.$bytes;
                SerializationContext context$iv = null;
                $receiver$iv.deserialize((ByteSequence)bytes$iv, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
            }
            {
                this.$factory2 = serializerFactory;
                this.$bytes = serializedBytes;
            }
        }).isInstanceOf(NotSerializableException.class);
    }

    @Test(timeout=300000L)
    public final void deserializeCustomisedEnum() {
        CustomEnumWrapper input = new CustomEnumWrapper(CustomEnum.ONE);
        ClassWhitelist classWhitelist = EmptyWhitelist.INSTANCE;
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        Intrinsics.checkExpressionValueIsNotNull((Object)classLoader, (String)"ClassLoader.getSystemClassLoader()");
        SerializerFactory factory1 = SerializerFactoryBuilder.build$default((ClassWhitelist)classWhitelist, (ClassLoader)classLoader, (boolean)false, null, (boolean)false, null, (boolean)false, (boolean)false, (int)252, null);
        SerializedBytes<CustomEnumWrapper> serialized = new TestSerializationOutput(false, factory1).serialize(input);
        ClassWhitelist classWhitelist2 = EmptyWhitelist.INSTANCE;
        ClassLoader classLoader2 = ClassLoader.getSystemClassLoader();
        Intrinsics.checkExpressionValueIsNotNull((Object)classLoader2, (String)"ClassLoader.getSystemClassLoader()");
        SerializerFactory factory2 = SerializerFactoryBuilder.build$default((ClassWhitelist)classWhitelist2, (ClassLoader)classLoader2, (boolean)false, null, (boolean)false, null, (boolean)false, (boolean)false, (int)252, null);
        DeserializationInput $receiver$iv = new DeserializationInput(factory2);
        SerializationContext context$iv = null;
        CustomEnumWrapper output = (CustomEnumWrapper)$receiver$iv.deserialize((ByteSequence)serialized, CustomEnumWrapper.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)input, (Object)output, null, (int)4, null);
        Assert.assertNotSame((String)"Deserialized object should be brand new.", (Object)input, (Object)output);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lnet/corda/serialization/internal/amqp/EnumTests$Bras;", "", "(Ljava/lang/String;I)V", "TSHIRT", "UNDERWIRE", "PUSHUP", "BRALETTE", "STRAPLESS", "SPORTS", "BACKLESS", "PADDED", "serialization"})
    public static final class Bras
    extends Enum<Bras> {
        public static final /* enum */ Bras TSHIRT;
        public static final /* enum */ Bras UNDERWIRE;
        public static final /* enum */ Bras PUSHUP;
        public static final /* enum */ Bras BRALETTE;
        public static final /* enum */ Bras STRAPLESS;
        public static final /* enum */ Bras SPORTS;
        public static final /* enum */ Bras BACKLESS;
        public static final /* enum */ Bras PADDED;
        private static final /* synthetic */ Bras[] $VALUES;

        static {
            Bras[] brasArray = new Bras[8];
            Bras[] brasArray2 = brasArray;
            brasArray[0] = TSHIRT = new Bras();
            brasArray[1] = UNDERWIRE = new Bras();
            brasArray[2] = PUSHUP = new Bras();
            brasArray[3] = BRALETTE = new Bras();
            brasArray[4] = STRAPLESS = new Bras();
            brasArray[5] = SPORTS = new Bras();
            brasArray[6] = BACKLESS = new Bras();
            brasArray[7] = PADDED = new Bras();
            $VALUES = brasArray;
        }

        public static Bras[] values() {
            return (Bras[])$VALUES.clone();
        }

        public static Bras valueOf(String string) {
            return Enum.valueOf(Bras.class, string);
        }
    }

    @CordaSerializable
    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0087\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lnet/corda/serialization/internal/amqp/EnumTests$AnnotatedBras;", "", "(Ljava/lang/String;I)V", "TSHIRT", "UNDERWIRE", "PUSHUP", "BRALETTE", "STRAPLESS", "SPORTS", "BACKLESS", "PADDED", "serialization"})
    public static final class AnnotatedBras
    extends Enum<AnnotatedBras> {
        public static final /* enum */ AnnotatedBras TSHIRT;
        public static final /* enum */ AnnotatedBras UNDERWIRE;
        public static final /* enum */ AnnotatedBras PUSHUP;
        public static final /* enum */ AnnotatedBras BRALETTE;
        public static final /* enum */ AnnotatedBras STRAPLESS;
        public static final /* enum */ AnnotatedBras SPORTS;
        public static final /* enum */ AnnotatedBras BACKLESS;
        public static final /* enum */ AnnotatedBras PADDED;
        private static final /* synthetic */ AnnotatedBras[] $VALUES;

        static {
            AnnotatedBras[] annotatedBrasArray = new AnnotatedBras[8];
            AnnotatedBras[] annotatedBrasArray2 = annotatedBrasArray;
            annotatedBrasArray[0] = TSHIRT = new AnnotatedBras();
            annotatedBrasArray[1] = UNDERWIRE = new AnnotatedBras();
            annotatedBrasArray[2] = PUSHUP = new AnnotatedBras();
            annotatedBrasArray[3] = BRALETTE = new AnnotatedBras();
            annotatedBrasArray[4] = STRAPLESS = new AnnotatedBras();
            annotatedBrasArray[5] = SPORTS = new AnnotatedBras();
            annotatedBrasArray[6] = BACKLESS = new AnnotatedBras();
            annotatedBrasArray[7] = PADDED = new AnnotatedBras();
            $VALUES = annotatedBrasArray;
        }

        public static AnnotatedBras[] values() {
            return (AnnotatedBras[])$VALUES.clone();
        }

        public static AnnotatedBras valueOf(String string) {
            return Enum.valueOf(AnnotatedBras.class, string);
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lnet/corda/serialization/internal/amqp/EnumTests$OldBras;", "", "(Ljava/lang/String;I)V", "SPACER", "TSHIRT", "UNDERWIRE", "PUSHUP", "BRALETTE", "serialization"})
    public static final class OldBras
    extends Enum<OldBras> {
        public static final /* enum */ OldBras SPACER;
        public static final /* enum */ OldBras TSHIRT;
        public static final /* enum */ OldBras UNDERWIRE;
        public static final /* enum */ OldBras PUSHUP;
        public static final /* enum */ OldBras BRALETTE;
        private static final /* synthetic */ OldBras[] $VALUES;

        static {
            OldBras[] oldBrasArray = new OldBras[5];
            OldBras[] oldBrasArray2 = oldBrasArray;
            oldBrasArray[0] = SPACER = new OldBras();
            oldBrasArray[1] = TSHIRT = new OldBras();
            oldBrasArray[2] = UNDERWIRE = new OldBras();
            oldBrasArray[3] = PUSHUP = new OldBras();
            oldBrasArray[4] = BRALETTE = new OldBras();
            $VALUES = oldBrasArray;
        }

        public static OldBras[] values() {
            return (OldBras[])$VALUES.clone();
        }

        public static OldBras valueOf(String string) {
            return Enum.valueOf(OldBras.class, string);
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lnet/corda/serialization/internal/amqp/EnumTests$OldBras2;", "", "(Ljava/lang/String;I)V", "TSHIRT", "UNDERWIRE", "PUSHUP", "SPACER", "BRALETTE", "SPACER2", "serialization"})
    public static final class OldBras2
    extends Enum<OldBras2> {
        public static final /* enum */ OldBras2 TSHIRT;
        public static final /* enum */ OldBras2 UNDERWIRE;
        public static final /* enum */ OldBras2 PUSHUP;
        public static final /* enum */ OldBras2 SPACER;
        public static final /* enum */ OldBras2 BRALETTE;
        public static final /* enum */ OldBras2 SPACER2;
        private static final /* synthetic */ OldBras2[] $VALUES;

        static {
            OldBras2[] oldBras2Array = new OldBras2[6];
            OldBras2[] oldBras2Array2 = oldBras2Array;
            oldBras2Array[0] = TSHIRT = new OldBras2();
            oldBras2Array[1] = UNDERWIRE = new OldBras2();
            oldBras2Array[2] = PUSHUP = new OldBras2();
            oldBras2Array[3] = SPACER = new OldBras2();
            oldBras2Array[4] = BRALETTE = new OldBras2();
            oldBras2Array[5] = SPACER2 = new OldBras2();
            $VALUES = oldBras2Array;
        }

        public static OldBras2[] values() {
            return (OldBras2[])$VALUES.clone();
        }

        public static OldBras2 valueOf(String string) {
            return Enum.valueOf(OldBras2.class, string);
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0015\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lnet/corda/serialization/internal/amqp/EnumTests$BrasWithInit;", "", "someList", "", "", "(Ljava/lang/String;ILjava/util/List;)V", "getSomeList", "()Ljava/util/List;", "TSHIRT", "UNDERWIRE", "PUSHUP", "BRALETTE", "serialization"})
    public static final class BrasWithInit
    extends Enum<BrasWithInit> {
        public static final /* enum */ BrasWithInit TSHIRT;
        public static final /* enum */ BrasWithInit UNDERWIRE;
        public static final /* enum */ BrasWithInit PUSHUP;
        public static final /* enum */ BrasWithInit BRALETTE;
        private static final /* synthetic */ BrasWithInit[] $VALUES;
        @NotNull
        private final List<Integer> someList;

        static {
            BrasWithInit[] brasWithInitArray = new BrasWithInit[4];
            BrasWithInit[] brasWithInitArray2 = brasWithInitArray;
            brasWithInitArray[0] = TSHIRT = new BrasWithInit(CollectionsKt.emptyList());
            brasWithInitArray[1] = UNDERWIRE = new BrasWithInit(CollectionsKt.listOf((Object[])new Integer[]{1, 2, 3}));
            brasWithInitArray[2] = PUSHUP = new BrasWithInit(CollectionsKt.listOf((Object[])new Integer[]{100, 200}));
            brasWithInitArray[3] = BRALETTE = new BrasWithInit(CollectionsKt.emptyList());
            $VALUES = brasWithInitArray;
        }

        @NotNull
        public final List<Integer> getSomeList() {
            return this.someList;
        }

        protected BrasWithInit(List<Integer> someList) {
            Intrinsics.checkParameterIsNotNull(someList, (String)"someList");
            this.someList = someList;
        }

        public static BrasWithInit[] values() {
            return (BrasWithInit[])$VALUES.clone();
        }

        public static BrasWithInit valueOf(String string) {
            return Enum.valueOf(BrasWithInit.class, string);
        }
    }

    @CordaSerializable
    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0087\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lnet/corda/serialization/internal/amqp/EnumTests$CustomEnum;", "", "(Ljava/lang/String;I)V", "toString", "", "ONE", "TWO", "THREE", "serialization"})
    public static final class CustomEnum
    extends Enum<CustomEnum> {
        public static final /* enum */ CustomEnum ONE;
        public static final /* enum */ CustomEnum TWO;
        public static final /* enum */ CustomEnum THREE;
        private static final /* synthetic */ CustomEnum[] $VALUES;

        static {
            CustomEnum[] customEnumArray = new CustomEnum[3];
            CustomEnum[] customEnumArray2 = customEnumArray;
            customEnumArray[0] = ONE = new CustomEnum();
            customEnumArray[1] = TWO = new CustomEnum();
            customEnumArray[2] = THREE = new CustomEnum();
            $VALUES = customEnumArray;
        }

        @NotNull
        public String toString() {
            String string = this.name();
            StringBuilder stringBuilder = new StringBuilder().append('[');
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
            String string4 = string3;
            return stringBuilder.append(string4).append(']').toString();
        }

        public static CustomEnum[] values() {
            return (CustomEnum[])$VALUES.clone();
        }

        public static CustomEnum valueOf(String string) {
            return Enum.valueOf(CustomEnum.class, string);
        }
    }

    @CordaSerializable
    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lnet/corda/serialization/internal/amqp/EnumTests$CustomEnumWrapper;", "", "data", "Lnet/corda/serialization/internal/amqp/EnumTests$CustomEnum;", "(Lnet/corda/serialization/internal/amqp/EnumTests$CustomEnum;)V", "getData", "()Lnet/corda/serialization/internal/amqp/EnumTests$CustomEnum;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
    public static final class CustomEnumWrapper {
        @NotNull
        private final CustomEnum data;

        @NotNull
        public final CustomEnum getData() {
            return this.data;
        }

        public CustomEnumWrapper(@NotNull CustomEnum data) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)data), (String)"data");
            this.data = data;
        }

        @NotNull
        public final CustomEnum component1() {
            return this.data;
        }

        @NotNull
        public final CustomEnumWrapper copy(@NotNull CustomEnum data) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)data), (String)"data");
            return new CustomEnumWrapper(data);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ CustomEnumWrapper copy$default(CustomEnumWrapper customEnumWrapper, CustomEnum customEnum, int n, Object object) {
            if ((n & 1) != 0) {
                customEnum = customEnumWrapper.data;
            }
            return customEnumWrapper.copy(customEnum);
        }

        @NotNull
        public String toString() {
            return "CustomEnumWrapper(data=" + (Object)((Object)this.data) + ")";
        }

        public int hashCode() {
            CustomEnum customEnum = this.data;
            return customEnum != null ? ((Object)((Object)customEnum)).hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof CustomEnumWrapper)) break block3;
                    CustomEnumWrapper customEnumWrapper = (CustomEnumWrapper)object;
                    if (!Intrinsics.areEqual((Object)((Object)this.data), (Object)((Object)customEnumWrapper.data))) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnet/corda/serialization/internal/amqp/EnumTests$Companion;", "", "()V", "VERBOSE", "", "serialization"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

