/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp;

import java.io.File;
import java.io.NotSerializableException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.test.AssertionsKt;
import net.corda.core.internal.InternalUtils;
import net.corda.core.serialization.CordaSerializationTransformEnumDefault;
import net.corda.core.serialization.CordaSerializationTransformEnumDefaults;
import net.corda.core.serialization.SerializationContext;
import net.corda.core.serialization.SerializedBytes;
import net.corda.core.utilities.ByteSequence;
import net.corda.serialization.internal.amqp.DeserializationInput;
import net.corda.serialization.internal.amqp.EnumEvolveTests;
import net.corda.serialization.internal.amqp.EvolvabilityTests;
import net.corda.serialization.internal.amqp.LocalSerializerFactory;
import net.corda.serialization.internal.amqp.SerializationOutput;
import net.corda.serialization.internal.amqp.SerializerFactory;
import net.corda.serialization.internal.amqp.testutils.AMQPTestUtilsKt;
import net.corda.serialization.internal.amqp.testutils.ProjectStructure;
import net.corda.serialization.internal.amqp.testutils.TestSerializationContextKt;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableAssert;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0012\u0018\u00002\u00020\u0001:\t\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u000bH\u0007J\b\u0010\f\u001a\u00020\u000bH\u0007J\b\u0010\r\u001a\u00020\u000bH\u0007J\b\u0010\u000e\u001a\u00020\u000bH\u0007J\b\u0010\u000f\u001a\u00020\u000bH\u0007J\b\u0010\u0010\u001a\u00020\u000bH\u0007J\b\u0010\u0011\u001a\u00020\u000bH\u0007J\b\u0010\u0012\u001a\u00020\u000bH\u0007J\b\u0010\u0013\u001a\u00020\u000bH\u0007R$\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u001d"}, d2={"Lnet/corda/serialization/internal/amqp/EnumEvolveTests;", "", "()V", "localPath", "Ljava/net/URI;", "localPath$annotations", "getLocalPath", "()Ljava/net/URI;", "setLocalPath", "(Ljava/net/URI;)V", "badNewValue", "", "changedOrdinality", "deserialiseNewerSetToUnknown", "deserialiseNewerSetToUnknown2", "deserialiseNewerWithNoRule", "deserializeWithRename", "extendEnum", "multiOperations", "outOfOrder", "BadNewValue", "ChangedOrdinality", "DeserializeNewerSetToUnknown", "DeserializeNewerSetToUnknown2", "DeserializeNewerWithNoRule", "DeserializeWithRename", "ExtendedEnum", "MultiOperations", "OutOfOrder", "serialization"})
public final class EnumEvolveTests {
    @NotNull
    private URI localPath;

    public static /* synthetic */ void localPath$annotations() {
    }

    @NotNull
    public final URI getLocalPath() {
        return this.localPath;
    }

    public final void setLocalPath(@NotNull URI uRI) {
        Intrinsics.checkParameterIsNotNull((Object)uRI, (String)"<set-?>");
        this.localPath = uRI;
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void deserialiseNewerSetToUnknown() {
        void $receiver$iv;
        String resource = this.getClass().getSimpleName() + '.' + AMQPTestUtilsKt.testName();
        SerializerFactory sf = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        URL url = this.getClass().getResource(resource);
        DeserializationInput deserializationInput = new DeserializationInput(sf);
        URL uRL = url;
        Intrinsics.checkExpressionValueIsNotNull((Object)uRL, (String)"url");
        SerializedBytes bytes$iv = new SerializedBytes(TextStreamsKt.readBytes((URL)uRL));
        SerializationContext context$iv = null;
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000'\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0018\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"net/corda/serialization/internal/amqp/EnumEvolveTests$deserialiseNewerSetToUnknown$C", "", "e", "Lnet/corda/serialization/internal/amqp/EnumEvolveTests$DeserializeNewerSetToUnknown;", "(Lnet/corda/serialization/internal/amqp/EnumEvolveTests$DeserializeNewerSetToUnknown;)V", "getE", "()Lnet/corda/serialization/internal/amqp/EnumEvolveTests$DeserializeNewerSetToUnknown;", "component1", "copy", "(Lnet/corda/serialization/internal/amqp/EnumEvolveTests$DeserializeNewerSetToUnknown;)Lnet/corda/serialization/internal/amqp/EnumEvolveTests$deserialiseNewerSetToUnknown$C;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
        public final class C {
            @NotNull
            private final DeserializeNewerSetToUnknown e;

            @NotNull
            public final DeserializeNewerSetToUnknown getE() {
                return this.e;
            }

            public C(@NotNull DeserializeNewerSetToUnknown e2) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)e2), (String)"e");
                this.e = e2;
            }

            @NotNull
            public final DeserializeNewerSetToUnknown component1() {
                return this.e;
            }

            @NotNull
            public final C copy(@NotNull DeserializeNewerSetToUnknown e2) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)e2), (String)"e");
                return new C(e2);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ C copy$default(C c, DeserializeNewerSetToUnknown deserializeNewerSetToUnknown, int n, Object object) {
                if ((n & 1) != 0) {
                    deserializeNewerSetToUnknown = c.e;
                }
                return c.copy(deserializeNewerSetToUnknown);
            }

            @NotNull
            public String toString() {
                return "C(e=" + (Object)((Object)this.e) + ")";
            }

            public int hashCode() {
                DeserializeNewerSetToUnknown deserializeNewerSetToUnknown = this.e;
                return deserializeNewerSetToUnknown != null ? ((Object)((Object)deserializeNewerSetToUnknown)).hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof C)) break block3;
                        C c = (C)object;
                        if (!Intrinsics.areEqual((Object)((Object)this.e), (Object)((Object)c.e))) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        C obj = (C)$receiver$iv.deserialize((ByteSequence)bytes$iv, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)((Object)DeserializeNewerSetToUnknown.C), (Object)((Object)obj.getE()), null, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void deserialiseNewerSetToUnknown2() {
        void $receiver$iv;
        void $receiver$iv2;
        void $receiver$iv3;
        String resource = this.getClass().getSimpleName() + '.' + AMQPTestUtilsKt.testName();
        SerializerFactory sf = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        URL url1 = this.getClass().getResource(resource + ".C");
        URL url2 = this.getClass().getResource(resource + ".D");
        URL url3 = this.getClass().getResource(resource + ".E");
        DeserializationInput deserializationInput = new DeserializationInput(sf);
        URL uRL = url1;
        Intrinsics.checkExpressionValueIsNotNull((Object)uRL, (String)"url1");
        SerializedBytes bytes$iv = new SerializedBytes(TextStreamsKt.readBytes((URL)uRL));
        SerializationContext context$iv = null;
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000'\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0018\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"net/corda/serialization/internal/amqp/EnumEvolveTests$deserialiseNewerSetToUnknown2$C", "", "e", "Lnet/corda/serialization/internal/amqp/EnumEvolveTests$DeserializeNewerSetToUnknown2;", "(Lnet/corda/serialization/internal/amqp/EnumEvolveTests$DeserializeNewerSetToUnknown2;)V", "getE", "()Lnet/corda/serialization/internal/amqp/EnumEvolveTests$DeserializeNewerSetToUnknown2;", "component1", "copy", "(Lnet/corda/serialization/internal/amqp/EnumEvolveTests$DeserializeNewerSetToUnknown2;)Lnet/corda/serialization/internal/amqp/EnumEvolveTests$deserialiseNewerSetToUnknown2$C;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
        public final class C {
            @NotNull
            private final DeserializeNewerSetToUnknown2 e;

            @NotNull
            public final DeserializeNewerSetToUnknown2 getE() {
                return this.e;
            }

            public C(@NotNull DeserializeNewerSetToUnknown2 e2) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)e2), (String)"e");
                this.e = e2;
            }

            @NotNull
            public final DeserializeNewerSetToUnknown2 component1() {
                return this.e;
            }

            @NotNull
            public final C copy(@NotNull DeserializeNewerSetToUnknown2 e2) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)e2), (String)"e");
                return new C(e2);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ C copy$default(C c, DeserializeNewerSetToUnknown2 deserializeNewerSetToUnknown2, int n, Object object) {
                if ((n & 1) != 0) {
                    deserializeNewerSetToUnknown2 = c.e;
                }
                return c.copy(deserializeNewerSetToUnknown2);
            }

            @NotNull
            public String toString() {
                return "C(e=" + (Object)((Object)this.e) + ")";
            }

            public int hashCode() {
                DeserializeNewerSetToUnknown2 deserializeNewerSetToUnknown2 = this.e;
                return deserializeNewerSetToUnknown2 != null ? ((Object)((Object)deserializeNewerSetToUnknown2)).hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof C)) break block3;
                        C c = (C)object;
                        if (!Intrinsics.areEqual((Object)((Object)this.e), (Object)((Object)c.e))) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        C obj1 = (C)$receiver$iv3.deserialize((ByteSequence)bytes$iv, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        bytes$iv = new DeserializationInput(sf);
        URL uRL2 = url2;
        Intrinsics.checkExpressionValueIsNotNull((Object)uRL2, (String)"url2");
        SerializedBytes bytes$iv2 = new SerializedBytes(TextStreamsKt.readBytes((URL)uRL2));
        SerializationContext context$iv2 = null;
        C obj2 = (C)$receiver$iv2.deserialize((ByteSequence)bytes$iv2, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        bytes$iv2 = new DeserializationInput(sf);
        URL uRL3 = url3;
        Intrinsics.checkExpressionValueIsNotNull((Object)uRL3, (String)"url3");
        SerializedBytes bytes$iv3 = new SerializedBytes(TextStreamsKt.readBytes((URL)uRL3));
        SerializationContext context$iv3 = null;
        C obj3 = (C)$receiver$iv.deserialize((ByteSequence)bytes$iv3, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)((Object)DeserializeNewerSetToUnknown2.C), (Object)((Object)obj1.getE()), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)((Object)DeserializeNewerSetToUnknown2.C), (Object)((Object)obj2.getE()), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)((Object)DeserializeNewerSetToUnknown2.C), (Object)((Object)obj3.getE()), null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void deserialiseNewerWithNoRule() {
        String resource = this.getClass().getSimpleName() + '.' + AMQPTestUtilsKt.testName();
        SerializerFactory sf = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        URL url = EvolvabilityTests.class.getResource(resource);
        Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)new ThrowableAssert.ThrowingCallable(sf, url){
            final /* synthetic */ SerializerFactory $sf;
            final /* synthetic */ URL $url;

            /*
             * WARNING - void declaration
             */
            public final void call() {
                void $receiver$iv;
                DeserializationInput deserializationInput = new DeserializationInput(this.$sf);
                URL uRL = this.$url;
                Intrinsics.checkExpressionValueIsNotNull((Object)uRL, (String)"url");
                SerializedBytes bytes$iv = new SerializedBytes(TextStreamsKt.readBytes((URL)uRL));
                SerializationContext context$iv = null;
                @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000'\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0018\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"net/corda/serialization/internal/amqp/EnumEvolveTests$deserialiseNewerWithNoRule$C", "", "e", "Lnet/corda/serialization/internal/amqp/EnumEvolveTests$DeserializeNewerWithNoRule;", "(Lnet/corda/serialization/internal/amqp/EnumEvolveTests$DeserializeNewerWithNoRule;)V", "getE", "()Lnet/corda/serialization/internal/amqp/EnumEvolveTests$DeserializeNewerWithNoRule;", "component1", "copy", "(Lnet/corda/serialization/internal/amqp/EnumEvolveTests$DeserializeNewerWithNoRule;)Lnet/corda/serialization/internal/amqp/EnumEvolveTests$deserialiseNewerWithNoRule$C;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
                public final class C {
                    @NotNull
                    private final DeserializeNewerWithNoRule e;

                    @NotNull
                    public final DeserializeNewerWithNoRule getE() {
                        return this.e;
                    }

                    public C(@NotNull DeserializeNewerWithNoRule e2) {
                        Intrinsics.checkParameterIsNotNull((Object)((Object)e2), (String)"e");
                        this.e = e2;
                    }

                    @NotNull
                    public final DeserializeNewerWithNoRule component1() {
                        return this.e;
                    }

                    @NotNull
                    public final C copy(@NotNull DeserializeNewerWithNoRule e2) {
                        Intrinsics.checkParameterIsNotNull((Object)((Object)e2), (String)"e");
                        return new C(e2);
                    }

                    @NotNull
                    public static /* bridge */ /* synthetic */ C copy$default(C c, DeserializeNewerWithNoRule deserializeNewerWithNoRule, int n, Object object) {
                        if ((n & 1) != 0) {
                            deserializeNewerWithNoRule = c.e;
                        }
                        return c.copy(deserializeNewerWithNoRule);
                    }

                    @NotNull
                    public String toString() {
                        return "C(e=" + (Object)((Object)this.e) + ")";
                    }

                    public int hashCode() {
                        DeserializeNewerWithNoRule deserializeNewerWithNoRule = this.e;
                        return deserializeNewerWithNoRule != null ? ((Object)((Object)deserializeNewerWithNoRule)).hashCode() : 0;
                    }

                    public boolean equals(@Nullable Object object) {
                        block3: {
                            block2: {
                                if (this == object) break block2;
                                if (!(object instanceof C)) break block3;
                                C c = (C)object;
                                if (!Intrinsics.areEqual((Object)((Object)this.e), (Object)((Object)c.e))) break block3;
                            }
                            return true;
                        }
                        return false;
                    }
                }
                $receiver$iv.deserialize((ByteSequence)bytes$iv, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
            }
            {
                this.$sf = serializerFactory;
                this.$url = uRL;
            }
        }).isInstanceOf(NotSerializableException.class);
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void deserializeWithRename() {
        void $receiver$iv;
        void $receiver$iv2;
        void $receiver$iv3;
        void $receiver$iv4;
        void $receiver$iv5;
        void $receiver$iv6;
        void $receiver$iv7;
        void $receiver$iv8;
        void $receiver$iv9;
        String resource = this.getClass().getSimpleName() + '.' + AMQPTestUtilsKt.testName();
        SerializerFactory sf = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        URL path1_AA = EvolvabilityTests.class.getResource(resource + ".1.AA");
        URL path1_B = EvolvabilityTests.class.getResource(resource + ".1.B");
        URL path1_C = EvolvabilityTests.class.getResource(resource + ".1.C");
        DeserializationInput deserializationInput = new DeserializationInput(sf);
        URL uRL = path1_AA;
        Intrinsics.checkExpressionValueIsNotNull((Object)uRL, (String)"path1_AA");
        SerializedBytes bytes$iv = new SerializedBytes(TextStreamsKt.readBytes((URL)uRL));
        SerializationContext context$iv = null;
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000'\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0018\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"net/corda/serialization/internal/amqp/EnumEvolveTests$deserializeWithRename$C", "", "e", "Lnet/corda/serialization/internal/amqp/EnumEvolveTests$DeserializeWithRename;", "(Lnet/corda/serialization/internal/amqp/EnumEvolveTests$DeserializeWithRename;)V", "getE", "()Lnet/corda/serialization/internal/amqp/EnumEvolveTests$DeserializeWithRename;", "component1", "copy", "(Lnet/corda/serialization/internal/amqp/EnumEvolveTests$DeserializeWithRename;)Lnet/corda/serialization/internal/amqp/EnumEvolveTests$deserializeWithRename$C;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
        public final class C {
            @NotNull
            private final DeserializeWithRename e;

            @NotNull
            public final DeserializeWithRename getE() {
                return this.e;
            }

            public C(@NotNull DeserializeWithRename e2) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)e2), (String)"e");
                this.e = e2;
            }

            @NotNull
            public final DeserializeWithRename component1() {
                return this.e;
            }

            @NotNull
            public final C copy(@NotNull DeserializeWithRename e2) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)e2), (String)"e");
                return new C(e2);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ C copy$default(C c, DeserializeWithRename deserializeWithRename2, int n, Object object) {
                if ((n & 1) != 0) {
                    deserializeWithRename2 = c.e;
                }
                return c.copy(deserializeWithRename2);
            }

            @NotNull
            public String toString() {
                return "C(e=" + (Object)((Object)this.e) + ")";
            }

            public int hashCode() {
                DeserializeWithRename deserializeWithRename2 = this.e;
                return deserializeWithRename2 != null ? ((Object)((Object)deserializeWithRename2)).hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof C)) break block3;
                        C c = (C)object;
                        if (!Intrinsics.areEqual((Object)((Object)this.e), (Object)((Object)c.e))) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        C obj1_AA = (C)$receiver$iv9.deserialize((ByteSequence)bytes$iv, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        bytes$iv = new DeserializationInput(sf);
        URL uRL2 = path1_B;
        Intrinsics.checkExpressionValueIsNotNull((Object)uRL2, (String)"path1_B");
        SerializedBytes bytes$iv2 = new SerializedBytes(TextStreamsKt.readBytes((URL)uRL2));
        SerializationContext context$iv2 = null;
        C obj1_B = (C)$receiver$iv8.deserialize((ByteSequence)bytes$iv2, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        bytes$iv2 = new DeserializationInput(sf);
        URL uRL3 = path1_C;
        Intrinsics.checkExpressionValueIsNotNull((Object)uRL3, (String)"path1_C");
        SerializedBytes bytes$iv3 = new SerializedBytes(TextStreamsKt.readBytes((URL)uRL3));
        SerializationContext context$iv3 = null;
        C obj1_C = (C)$receiver$iv7.deserialize((ByteSequence)bytes$iv3, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)((Object)DeserializeWithRename.A), (Object)((Object)obj1_AA.getE()), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)((Object)DeserializeWithRename.B), (Object)((Object)obj1_B.getE()), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)((Object)DeserializeWithRename.C), (Object)((Object)obj1_C.getE()), null, (int)4, null);
        URL path2_AA = EvolvabilityTests.class.getResource(resource + ".2.AA");
        URL path2_BB = EvolvabilityTests.class.getResource(resource + ".2.BB");
        URL path2_C = EvolvabilityTests.class.getResource(resource + ".2.C");
        DeserializationInput deserializationInput2 = new DeserializationInput(sf);
        URL uRL4 = path2_AA;
        Intrinsics.checkExpressionValueIsNotNull((Object)uRL4, (String)"path2_AA");
        SerializedBytes bytes$iv4 = new SerializedBytes(TextStreamsKt.readBytes((URL)uRL4));
        SerializationContext context$iv4 = null;
        C obj2_AA = (C)$receiver$iv6.deserialize((ByteSequence)bytes$iv4, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        bytes$iv4 = new DeserializationInput(sf);
        URL uRL5 = path2_BB;
        Intrinsics.checkExpressionValueIsNotNull((Object)uRL5, (String)"path2_BB");
        SerializedBytes bytes$iv5 = new SerializedBytes(TextStreamsKt.readBytes((URL)uRL5));
        SerializationContext context$iv5 = null;
        C obj2_BB = (C)$receiver$iv5.deserialize((ByteSequence)bytes$iv5, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        bytes$iv5 = new DeserializationInput(sf);
        URL uRL6 = path2_C;
        Intrinsics.checkExpressionValueIsNotNull((Object)uRL6, (String)"path2_C");
        SerializedBytes bytes$iv6 = new SerializedBytes(TextStreamsKt.readBytes((URL)uRL6));
        SerializationContext context$iv6 = null;
        C obj2_C = (C)$receiver$iv4.deserialize((ByteSequence)bytes$iv6, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)((Object)DeserializeWithRename.A), (Object)((Object)obj2_AA.getE()), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)((Object)DeserializeWithRename.B), (Object)((Object)obj2_BB.getE()), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)((Object)DeserializeWithRename.C), (Object)((Object)obj2_C.getE()), null, (int)4, null);
        URL path3_AA = EvolvabilityTests.class.getResource(resource + ".3.AA");
        URL path3_XX = EvolvabilityTests.class.getResource(resource + ".3.XX");
        URL path3_C = EvolvabilityTests.class.getResource(resource + ".3.C");
        DeserializationInput deserializationInput3 = new DeserializationInput(sf);
        URL uRL7 = path3_AA;
        Intrinsics.checkExpressionValueIsNotNull((Object)uRL7, (String)"path3_AA");
        SerializedBytes bytes$iv7 = new SerializedBytes(TextStreamsKt.readBytes((URL)uRL7));
        SerializationContext context$iv7 = null;
        C obj3_AA = (C)$receiver$iv3.deserialize((ByteSequence)bytes$iv7, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        bytes$iv7 = new DeserializationInput(sf);
        URL uRL8 = path3_XX;
        Intrinsics.checkExpressionValueIsNotNull((Object)uRL8, (String)"path3_XX");
        SerializedBytes bytes$iv8 = new SerializedBytes(TextStreamsKt.readBytes((URL)uRL8));
        SerializationContext context$iv8 = null;
        C obj3_XX = (C)$receiver$iv2.deserialize((ByteSequence)bytes$iv8, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        bytes$iv8 = new DeserializationInput(sf);
        URL uRL9 = path3_C;
        Intrinsics.checkExpressionValueIsNotNull((Object)uRL9, (String)"path3_C");
        SerializedBytes bytes$iv9 = new SerializedBytes(TextStreamsKt.readBytes((URL)uRL9));
        SerializationContext context$iv9 = null;
        C obj3_C = (C)$receiver$iv.deserialize((ByteSequence)bytes$iv9, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)((Object)DeserializeWithRename.A), (Object)((Object)obj3_AA.getE()), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)((Object)DeserializeWithRename.B), (Object)((Object)obj3_XX.getE()), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)((Object)DeserializeWithRename.C), (Object)((Object)obj3_C.getE()), null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void multiOperations() {
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000'\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0018\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"net/corda/serialization/internal/amqp/EnumEvolveTests$multiOperations$C", "", "e", "Lnet/corda/serialization/internal/amqp/EnumEvolveTests$MultiOperations;", "(Lnet/corda/serialization/internal/amqp/EnumEvolveTests$MultiOperations;)V", "getE", "()Lnet/corda/serialization/internal/amqp/EnumEvolveTests$MultiOperations;", "component1", "copy", "(Lnet/corda/serialization/internal/amqp/EnumEvolveTests$MultiOperations;)Lnet/corda/serialization/internal/amqp/EnumEvolveTests$multiOperations$C;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
        public final class C {
            @NotNull
            private final MultiOperations e;

            @NotNull
            public final MultiOperations getE() {
                return this.e;
            }

            public C(@NotNull MultiOperations e2) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)e2), (String)"e");
                this.e = e2;
            }

            @NotNull
            public final MultiOperations component1() {
                return this.e;
            }

            @NotNull
            public final C copy(@NotNull MultiOperations e2) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)e2), (String)"e");
                return new C(e2);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ C copy$default(C c, MultiOperations multiOperations2, int n, Object object) {
                if ((n & 1) != 0) {
                    multiOperations2 = c.e;
                }
                return c.copy(multiOperations2);
            }

            @NotNull
            public String toString() {
                return "C(e=" + (Object)((Object)this.e) + ")";
            }

            public int hashCode() {
                MultiOperations multiOperations2 = this.e;
                return multiOperations2 != null ? ((Object)((Object)multiOperations2)).hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof C)) break block3;
                        C c = (C)object;
                        if (!Intrinsics.areEqual((Object)((Object)this.e), (Object)((Object)c.e))) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        Pair it;
        String resource = this.getClass().getSimpleName() + '.' + AMQPTestUtilsKt.testName();
        SerializerFactory sf = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        List stage1Resources = CollectionsKt.listOf((Object[])new Pair[]{new Pair((Object)(resource + ".1.A"), (Object)MultiOperations.A), new Pair((Object)(resource + ".1.B"), (Object)MultiOperations.B), new Pair((Object)(resource + ".1.C"), (Object)MultiOperations.C), new Pair((Object)(resource + ".1.D"), (Object)MultiOperations.C)});
        List stage2Resources = CollectionsKt.listOf((Object[])new Pair[]{new Pair((Object)(resource + ".2.A"), (Object)MultiOperations.A), new Pair((Object)(resource + ".2.B"), (Object)MultiOperations.B), new Pair((Object)(resource + ".2.C"), (Object)MultiOperations.C), new Pair((Object)(resource + ".2.D"), (Object)MultiOperations.C), new Pair((Object)(resource + ".2.E"), (Object)MultiOperations.C)});
        List stage3Resources = CollectionsKt.listOf((Object[])new Pair[]{new Pair((Object)(resource + ".3.A"), (Object)MultiOperations.A), new Pair((Object)(resource + ".3.B"), (Object)MultiOperations.B), new Pair((Object)(resource + ".3.C"), (Object)MultiOperations.C), new Pair((Object)(resource + ".3.D"), (Object)MultiOperations.C), new Pair((Object)(resource + ".3.BOB"), (Object)MultiOperations.C)});
        List stage4Resources = CollectionsKt.listOf((Object[])new Pair[]{new Pair((Object)(resource + ".4.A"), (Object)MultiOperations.A), new Pair((Object)(resource + ".4.B"), (Object)MultiOperations.B), new Pair((Object)(resource + ".4.CAT"), (Object)MultiOperations.C), new Pair((Object)(resource + ".4.D"), (Object)MultiOperations.C), new Pair((Object)(resource + ".4.BOB"), (Object)MultiOperations.C), new Pair((Object)(resource + ".4.F"), (Object)MultiOperations.C), new Pair((Object)(resource + ".4.G"), (Object)MultiOperations.C)});
        List stage5Resources = CollectionsKt.listOf((Object[])new Pair[]{new Pair((Object)(resource + ".5.APPLE"), (Object)MultiOperations.A), new Pair((Object)(resource + ".5.B"), (Object)MultiOperations.B), new Pair((Object)(resource + ".5.CAT"), (Object)MultiOperations.C), new Pair((Object)(resource + ".5.D"), (Object)MultiOperations.C), new Pair((Object)(resource + ".5.BBB"), (Object)MultiOperations.C), new Pair((Object)(resource + ".5.FLUMP"), (Object)MultiOperations.C), new Pair((Object)(resource + ".5.G"), (Object)MultiOperations.C)});
        Function1<List<? extends Pair<? extends String, ? extends MultiOperations>>, List<? extends Pair<? extends C, ? extends MultiOperations>>> load$ = new Function1<List<? extends Pair<? extends String, ? extends MultiOperations>>, List<? extends Pair<? extends C, ? extends MultiOperations>>>(sf){
            final /* synthetic */ SerializerFactory $sf;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<Pair<C, MultiOperations>> invoke(@NotNull List<? extends Pair<String, ? extends MultiOperations>> l) {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                Intrinsics.checkParameterIsNotNull(l, (String)"l");
                Iterable iterable = $receiver$iv = (Iterable)l;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    void bytes$iv;
                    void $receiver$iv2;
                    Pair pair;
                    void it;
                    Pair pair2 = (Pair)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    AssertionsKt.assertNotNull$default((Object)EvolvabilityTests.class.getResource((String)it.getFirst()), null, (int)2, null);
                    URL uRL = EvolvabilityTests.class.getResource((String)it.getFirst());
                    Intrinsics.checkExpressionValueIsNotNull((Object)uRL, (String)"EvolvabilityTests::class\u2026ava.getResource(it.first)");
                    Assertions.assertThat((Path)InternalUtils.toPath((URL)uRL)).exists();
                    DeserializationInput deserializationInput = new DeserializationInput(this.$sf);
                    URL uRL2 = EvolvabilityTests.class.getResource((String)it.getFirst());
                    Intrinsics.checkExpressionValueIsNotNull((Object)uRL2, (String)"EvolvabilityTests::class\u2026ava.getResource(it.first)");
                    SerializedBytes serializedBytes = new SerializedBytes(TextStreamsKt.readBytes((URL)uRL2));
                    Pair pair3 = pair;
                    Pair pair4 = pair;
                    SerializationContext context$iv = null;
                    Object object = $receiver$iv2.deserialize((ByteSequence)bytes$iv, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
                    pair3(object, it.getSecond());
                    Pair pair5 = pair4;
                    collection.add(pair5);
                }
                return (List)destination$iv$iv;
            }
            {
                this.$sf = serializerFactory;
                super(1);
            }
        };
        Iterable $receiver$iv = load$.invoke((List<? extends Pair<String, ? extends MultiOperations>>)stage1Resources);
        for (Object element$iv : $receiver$iv) {
            it = (Pair)element$iv;
            AssertionsKt.assertEquals$default((Object)it.getSecond(), (Object)((Object)((C)it.getFirst()).getE()), null, (int)4, null);
        }
        $receiver$iv = load$.invoke((List<? extends Pair<String, ? extends MultiOperations>>)stage2Resources);
        for (Object element$iv : $receiver$iv) {
            it = (Pair)element$iv;
            AssertionsKt.assertEquals$default((Object)it.getSecond(), (Object)((Object)((C)it.getFirst()).getE()), null, (int)4, null);
        }
        $receiver$iv = load$.invoke((List<? extends Pair<String, ? extends MultiOperations>>)stage3Resources);
        for (Object element$iv : $receiver$iv) {
            it = (Pair)element$iv;
            AssertionsKt.assertEquals$default((Object)it.getSecond(), (Object)((Object)((C)it.getFirst()).getE()), null, (int)4, null);
        }
        $receiver$iv = load$.invoke((List<? extends Pair<String, ? extends MultiOperations>>)stage4Resources);
        for (Object element$iv : $receiver$iv) {
            it = (Pair)element$iv;
            AssertionsKt.assertEquals$default((Object)it.getSecond(), (Object)((Object)((C)it.getFirst()).getE()), null, (int)4, null);
        }
        $receiver$iv = load$.invoke((List<? extends Pair<String, ? extends MultiOperations>>)stage5Resources);
        for (Object element$iv : $receiver$iv) {
            it = (Pair)element$iv;
            AssertionsKt.assertEquals$default((Object)it.getSecond(), (Object)((Object)((C)it.getFirst()).getE()), null, (int)4, null);
        }
    }

    @Test(timeout=300000L)
    public final void badNewValue() {
        SerializerFactory sf = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)new ThrowableAssert.ThrowingCallable(sf){
            final /* synthetic */ SerializerFactory $sf;

            public final void call() {
                @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000'\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0018\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"net/corda/serialization/internal/amqp/EnumEvolveTests$badNewValue$C", "", "e", "Lnet/corda/serialization/internal/amqp/EnumEvolveTests$BadNewValue;", "(Lnet/corda/serialization/internal/amqp/EnumEvolveTests$BadNewValue;)V", "getE", "()Lnet/corda/serialization/internal/amqp/EnumEvolveTests$BadNewValue;", "component1", "copy", "(Lnet/corda/serialization/internal/amqp/EnumEvolveTests$BadNewValue;)Lnet/corda/serialization/internal/amqp/EnumEvolveTests$badNewValue$C;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
                public final class C {
                    @NotNull
                    private final BadNewValue e;

                    @NotNull
                    public final BadNewValue getE() {
                        return this.e;
                    }

                    public C(@NotNull BadNewValue e2) {
                        Intrinsics.checkParameterIsNotNull((Object)((Object)e2), (String)"e");
                        this.e = e2;
                    }

                    @NotNull
                    public final BadNewValue component1() {
                        return this.e;
                    }

                    @NotNull
                    public final C copy(@NotNull BadNewValue e2) {
                        Intrinsics.checkParameterIsNotNull((Object)((Object)e2), (String)"e");
                        return new C(e2);
                    }

                    @NotNull
                    public static /* bridge */ /* synthetic */ C copy$default(C c, BadNewValue badNewValue2, int n, Object object) {
                        if ((n & 1) != 0) {
                            badNewValue2 = c.e;
                        }
                        return c.copy(badNewValue2);
                    }

                    @NotNull
                    public String toString() {
                        return "C(e=" + (Object)((Object)this.e) + ")";
                    }

                    public int hashCode() {
                        BadNewValue badNewValue2 = this.e;
                        return badNewValue2 != null ? ((Object)((Object)badNewValue2)).hashCode() : 0;
                    }

                    public boolean equals(@Nullable Object object) {
                        block3: {
                            block2: {
                                if (this == object) break block2;
                                if (!(object instanceof C)) break block3;
                                C c = (C)object;
                                if (!Intrinsics.areEqual((Object)((Object)this.e), (Object)((Object)c.e))) break block3;
                            }
                            return true;
                        }
                        return false;
                    }
                }
                AMQPTestUtilsKt.serialize$default(new SerializationOutput((LocalSerializerFactory)this.$sf), new C(BadNewValue.A), null, 2, null);
            }
            {
                this.$sf = serializerFactory;
            }
        }).isInstanceOf(NotSerializableException.class);
    }

    @Test(timeout=300000L)
    public final void outOfOrder() {
        SerializerFactory sf = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)new ThrowableAssert.ThrowingCallable(sf){
            final /* synthetic */ SerializerFactory $sf;

            public final void call() {
                @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000'\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0018\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"net/corda/serialization/internal/amqp/EnumEvolveTests$outOfOrder$C", "", "e", "Lnet/corda/serialization/internal/amqp/EnumEvolveTests$OutOfOrder;", "(Lnet/corda/serialization/internal/amqp/EnumEvolveTests$OutOfOrder;)V", "getE", "()Lnet/corda/serialization/internal/amqp/EnumEvolveTests$OutOfOrder;", "component1", "copy", "(Lnet/corda/serialization/internal/amqp/EnumEvolveTests$OutOfOrder;)Lnet/corda/serialization/internal/amqp/EnumEvolveTests$outOfOrder$C;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
                public final class C {
                    @NotNull
                    private final OutOfOrder e;

                    @NotNull
                    public final OutOfOrder getE() {
                        return this.e;
                    }

                    public C(@NotNull OutOfOrder e2) {
                        Intrinsics.checkParameterIsNotNull((Object)((Object)e2), (String)"e");
                        this.e = e2;
                    }

                    @NotNull
                    public final OutOfOrder component1() {
                        return this.e;
                    }

                    @NotNull
                    public final C copy(@NotNull OutOfOrder e2) {
                        Intrinsics.checkParameterIsNotNull((Object)((Object)e2), (String)"e");
                        return new C(e2);
                    }

                    @NotNull
                    public static /* bridge */ /* synthetic */ C copy$default(C c, OutOfOrder outOfOrder2, int n, Object object) {
                        if ((n & 1) != 0) {
                            outOfOrder2 = c.e;
                        }
                        return c.copy(outOfOrder2);
                    }

                    @NotNull
                    public String toString() {
                        return "C(e=" + (Object)((Object)this.e) + ")";
                    }

                    public int hashCode() {
                        OutOfOrder outOfOrder2 = this.e;
                        return outOfOrder2 != null ? ((Object)((Object)outOfOrder2)).hashCode() : 0;
                    }

                    public boolean equals(@Nullable Object object) {
                        block3: {
                            block2: {
                                if (this == object) break block2;
                                if (!(object instanceof C)) break block3;
                                C c = (C)object;
                                if (!Intrinsics.areEqual((Object)((Object)this.e), (Object)((Object)c.e))) break block3;
                            }
                            return true;
                        }
                        return false;
                    }
                }
                AMQPTestUtilsKt.serialize$default(new SerializationOutput((LocalSerializerFactory)this.$sf), new C(OutOfOrder.A), null, 2, null);
            }
            {
                this.$sf = serializerFactory;
            }
        }).isInstanceOf(NotSerializableException.class);
    }

    @Test(timeout=300000L)
    public final void changedOrdinality() {
        String resource = this.getClass().getSimpleName() + '.' + AMQPTestUtilsKt.testName();
        SerializerFactory sf = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)new ThrowableAssert.ThrowingCallable(sf, resource){
            final /* synthetic */ SerializerFactory $sf;
            final /* synthetic */ String $resource;

            /*
             * WARNING - void declaration
             */
            public final void call() {
                void $receiver$iv;
                DeserializationInput deserializationInput = new DeserializationInput(this.$sf);
                URL uRL = EvolvabilityTests.class.getResource(this.$resource);
                Intrinsics.checkExpressionValueIsNotNull((Object)uRL, (String)"EvolvabilityTests::class\u2026ava.getResource(resource)");
                SerializedBytes bytes$iv = new SerializedBytes(TextStreamsKt.readBytes((URL)uRL));
                SerializationContext context$iv = null;
                @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000'\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0018\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"net/corda/serialization/internal/amqp/EnumEvolveTests$changedOrdinality$C", "", "e", "Lnet/corda/serialization/internal/amqp/EnumEvolveTests$ChangedOrdinality;", "(Lnet/corda/serialization/internal/amqp/EnumEvolveTests$ChangedOrdinality;)V", "getE", "()Lnet/corda/serialization/internal/amqp/EnumEvolveTests$ChangedOrdinality;", "component1", "copy", "(Lnet/corda/serialization/internal/amqp/EnumEvolveTests$ChangedOrdinality;)Lnet/corda/serialization/internal/amqp/EnumEvolveTests$changedOrdinality$C;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
                public final class C {
                    @NotNull
                    private final ChangedOrdinality e;

                    @NotNull
                    public final ChangedOrdinality getE() {
                        return this.e;
                    }

                    public C(@NotNull ChangedOrdinality e2) {
                        Intrinsics.checkParameterIsNotNull((Object)((Object)e2), (String)"e");
                        this.e = e2;
                    }

                    @NotNull
                    public final ChangedOrdinality component1() {
                        return this.e;
                    }

                    @NotNull
                    public final C copy(@NotNull ChangedOrdinality e2) {
                        Intrinsics.checkParameterIsNotNull((Object)((Object)e2), (String)"e");
                        return new C(e2);
                    }

                    @NotNull
                    public static /* bridge */ /* synthetic */ C copy$default(C c, ChangedOrdinality changedOrdinality2, int n, Object object) {
                        if ((n & 1) != 0) {
                            changedOrdinality2 = c.e;
                        }
                        return c.copy(changedOrdinality2);
                    }

                    @NotNull
                    public String toString() {
                        return "C(e=" + (Object)((Object)this.e) + ")";
                    }

                    public int hashCode() {
                        ChangedOrdinality changedOrdinality2 = this.e;
                        return changedOrdinality2 != null ? ((Object)((Object)changedOrdinality2)).hashCode() : 0;
                    }

                    public boolean equals(@Nullable Object object) {
                        block3: {
                            block2: {
                                if (this == object) break block2;
                                if (!(object instanceof C)) break block3;
                                C c = (C)object;
                                if (!Intrinsics.areEqual((Object)((Object)this.e), (Object)((Object)c.e))) break block3;
                            }
                            return true;
                        }
                        return false;
                    }
                }
                $receiver$iv.deserialize((ByteSequence)bytes$iv, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
            }
            {
                this.$sf = serializerFactory;
                this.$resource = string;
            }
        }).isInstanceOf(NotSerializableException.class);
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void extendEnum() {
        void $receiver$iv;
        String resource = this.getClass().getSimpleName() + '.' + AMQPTestUtilsKt.testName();
        SerializerFactory sf = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        URL path1 = EvolvabilityTests.class.getResource(resource + ".A");
        DeserializationInput deserializationInput = new DeserializationInput(sf);
        SerializedBytes bytes$iv = new SerializedBytes(FilesKt.readBytes((File)new File(path1.toURI())));
        SerializationContext context$iv = null;
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000'\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0018\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"net/corda/serialization/internal/amqp/EnumEvolveTests$extendEnum$C", "", "e", "Lnet/corda/serialization/internal/amqp/EnumEvolveTests$ExtendedEnum;", "(Lnet/corda/serialization/internal/amqp/EnumEvolveTests$ExtendedEnum;)V", "getE", "()Lnet/corda/serialization/internal/amqp/EnumEvolveTests$ExtendedEnum;", "component1", "copy", "(Lnet/corda/serialization/internal/amqp/EnumEvolveTests$ExtendedEnum;)Lnet/corda/serialization/internal/amqp/EnumEvolveTests$extendEnum$C;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
        public final class C {
            @NotNull
            private final ExtendedEnum e;

            @NotNull
            public final ExtendedEnum getE() {
                return this.e;
            }

            public C(@NotNull ExtendedEnum e2) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)e2), (String)"e");
                this.e = e2;
            }

            @NotNull
            public final ExtendedEnum component1() {
                return this.e;
            }

            @NotNull
            public final C copy(@NotNull ExtendedEnum e2) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)e2), (String)"e");
                return new C(e2);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ C copy$default(C c, ExtendedEnum extendedEnum, int n, Object object) {
                if ((n & 1) != 0) {
                    extendedEnum = c.e;
                }
                return c.copy(extendedEnum);
            }

            @NotNull
            public String toString() {
                return "C(e=" + (Object)((Object)this.e) + ")";
            }

            public int hashCode() {
                ExtendedEnum extendedEnum = this.e;
                return extendedEnum != null ? ((Object)((Object)extendedEnum)).hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof C)) break block3;
                        C c = (C)object;
                        if (!Intrinsics.areEqual((Object)((Object)this.e), (Object)((Object)c.e))) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        C obj1 = (C)$receiver$iv.deserialize((ByteSequence)bytes$iv, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)((Object)ExtendedEnum.A), (Object)((Object)obj1.getE()), null, (int)4, null);
    }

    public EnumEvolveTests() {
        URI uRI = ProjectStructure.INSTANCE.getProjectRootDir().toUri().resolve("serialization-tests/src/test/resources/net/corda/serialization/internal/amqp");
        Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"projectRootDir.toUri().r\u2026alization/internal/amqp\")");
        this.localPath = uRI;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lnet/corda/serialization/internal/amqp/EnumEvolveTests$DeserializeNewerSetToUnknown;", "", "(Ljava/lang/String;I)V", "A", "B", "C", "serialization"})
    public static final class DeserializeNewerSetToUnknown
    extends Enum<DeserializeNewerSetToUnknown> {
        public static final /* enum */ DeserializeNewerSetToUnknown A;
        public static final /* enum */ DeserializeNewerSetToUnknown B;
        public static final /* enum */ DeserializeNewerSetToUnknown C;
        private static final /* synthetic */ DeserializeNewerSetToUnknown[] $VALUES;

        static {
            DeserializeNewerSetToUnknown[] deserializeNewerSetToUnknownArray = new DeserializeNewerSetToUnknown[3];
            DeserializeNewerSetToUnknown[] deserializeNewerSetToUnknownArray2 = deserializeNewerSetToUnknownArray;
            deserializeNewerSetToUnknownArray[0] = A = new DeserializeNewerSetToUnknown();
            deserializeNewerSetToUnknownArray[1] = B = new DeserializeNewerSetToUnknown();
            deserializeNewerSetToUnknownArray[2] = C = new DeserializeNewerSetToUnknown();
            $VALUES = deserializeNewerSetToUnknownArray;
        }

        public static DeserializeNewerSetToUnknown[] values() {
            return (DeserializeNewerSetToUnknown[])$VALUES.clone();
        }

        public static DeserializeNewerSetToUnknown valueOf(String string) {
            return Enum.valueOf(DeserializeNewerSetToUnknown.class, string);
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lnet/corda/serialization/internal/amqp/EnumEvolveTests$DeserializeNewerSetToUnknown2;", "", "(Ljava/lang/String;I)V", "A", "B", "C", "serialization"})
    public static final class DeserializeNewerSetToUnknown2
    extends Enum<DeserializeNewerSetToUnknown2> {
        public static final /* enum */ DeserializeNewerSetToUnknown2 A;
        public static final /* enum */ DeserializeNewerSetToUnknown2 B;
        public static final /* enum */ DeserializeNewerSetToUnknown2 C;
        private static final /* synthetic */ DeserializeNewerSetToUnknown2[] $VALUES;

        static {
            DeserializeNewerSetToUnknown2[] deserializeNewerSetToUnknown2Array = new DeserializeNewerSetToUnknown2[3];
            DeserializeNewerSetToUnknown2[] deserializeNewerSetToUnknown2Array2 = deserializeNewerSetToUnknown2Array;
            deserializeNewerSetToUnknown2Array[0] = A = new DeserializeNewerSetToUnknown2();
            deserializeNewerSetToUnknown2Array[1] = B = new DeserializeNewerSetToUnknown2();
            deserializeNewerSetToUnknown2Array[2] = C = new DeserializeNewerSetToUnknown2();
            $VALUES = deserializeNewerSetToUnknown2Array;
        }

        public static DeserializeNewerSetToUnknown2[] values() {
            return (DeserializeNewerSetToUnknown2[])$VALUES.clone();
        }

        public static DeserializeNewerSetToUnknown2 valueOf(String string) {
            return Enum.valueOf(DeserializeNewerSetToUnknown2.class, string);
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lnet/corda/serialization/internal/amqp/EnumEvolveTests$DeserializeNewerWithNoRule;", "", "(Ljava/lang/String;I)V", "A", "B", "C", "serialization"})
    public static final class DeserializeNewerWithNoRule
    extends Enum<DeserializeNewerWithNoRule> {
        public static final /* enum */ DeserializeNewerWithNoRule A;
        public static final /* enum */ DeserializeNewerWithNoRule B;
        public static final /* enum */ DeserializeNewerWithNoRule C;
        private static final /* synthetic */ DeserializeNewerWithNoRule[] $VALUES;

        static {
            DeserializeNewerWithNoRule[] deserializeNewerWithNoRuleArray = new DeserializeNewerWithNoRule[3];
            DeserializeNewerWithNoRule[] deserializeNewerWithNoRuleArray2 = deserializeNewerWithNoRuleArray;
            deserializeNewerWithNoRuleArray[0] = A = new DeserializeNewerWithNoRule();
            deserializeNewerWithNoRuleArray[1] = B = new DeserializeNewerWithNoRule();
            deserializeNewerWithNoRuleArray[2] = C = new DeserializeNewerWithNoRule();
            $VALUES = deserializeNewerWithNoRuleArray;
        }

        public static DeserializeNewerWithNoRule[] values() {
            return (DeserializeNewerWithNoRule[])$VALUES.clone();
        }

        public static DeserializeNewerWithNoRule valueOf(String string) {
            return Enum.valueOf(DeserializeNewerWithNoRule.class, string);
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lnet/corda/serialization/internal/amqp/EnumEvolveTests$DeserializeWithRename;", "", "(Ljava/lang/String;I)V", "A", "B", "C", "serialization"})
    public static final class DeserializeWithRename
    extends Enum<DeserializeWithRename> {
        public static final /* enum */ DeserializeWithRename A;
        public static final /* enum */ DeserializeWithRename B;
        public static final /* enum */ DeserializeWithRename C;
        private static final /* synthetic */ DeserializeWithRename[] $VALUES;

        static {
            DeserializeWithRename[] deserializeWithRenameArray = new DeserializeWithRename[3];
            DeserializeWithRename[] deserializeWithRenameArray2 = deserializeWithRenameArray;
            deserializeWithRenameArray[0] = A = new DeserializeWithRename();
            deserializeWithRenameArray[1] = B = new DeserializeWithRename();
            deserializeWithRenameArray[2] = C = new DeserializeWithRename();
            $VALUES = deserializeWithRenameArray;
        }

        public static DeserializeWithRename[] values() {
            return (DeserializeWithRename[])$VALUES.clone();
        }

        public static DeserializeWithRename valueOf(String string) {
            return Enum.valueOf(DeserializeWithRename.class, string);
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lnet/corda/serialization/internal/amqp/EnumEvolveTests$MultiOperations;", "", "(Ljava/lang/String;I)V", "A", "B", "C", "serialization"})
    public static final class MultiOperations
    extends Enum<MultiOperations> {
        public static final /* enum */ MultiOperations A;
        public static final /* enum */ MultiOperations B;
        public static final /* enum */ MultiOperations C;
        private static final /* synthetic */ MultiOperations[] $VALUES;

        static {
            MultiOperations[] multiOperationsArray = new MultiOperations[3];
            MultiOperations[] multiOperationsArray2 = multiOperationsArray;
            multiOperationsArray[0] = A = new MultiOperations();
            multiOperationsArray[1] = B = new MultiOperations();
            multiOperationsArray[2] = C = new MultiOperations();
            $VALUES = multiOperationsArray;
        }

        public static MultiOperations[] values() {
            return (MultiOperations[])$VALUES.clone();
        }

        public static MultiOperations valueOf(String string) {
            return Enum.valueOf(MultiOperations.class, string);
        }
    }

    @CordaSerializationTransformEnumDefault(old="A", new="F")
    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0087\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lnet/corda/serialization/internal/amqp/EnumEvolveTests$BadNewValue;", "", "(Ljava/lang/String;I)V", "A", "B", "C", "D", "serialization"})
    public static final class BadNewValue
    extends Enum<BadNewValue> {
        public static final /* enum */ BadNewValue A;
        public static final /* enum */ BadNewValue B;
        public static final /* enum */ BadNewValue C;
        public static final /* enum */ BadNewValue D;
        private static final /* synthetic */ BadNewValue[] $VALUES;

        static {
            BadNewValue[] badNewValueArray = new BadNewValue[4];
            BadNewValue[] badNewValueArray2 = badNewValueArray;
            badNewValueArray[0] = A = new BadNewValue();
            badNewValueArray[1] = B = new BadNewValue();
            badNewValueArray[2] = C = new BadNewValue();
            badNewValueArray[3] = D = new BadNewValue();
            $VALUES = badNewValueArray;
        }

        public static BadNewValue[] values() {
            return (BadNewValue[])$VALUES.clone();
        }

        public static BadNewValue valueOf(String string) {
            return Enum.valueOf(BadNewValue.class, string);
        }
    }

    @CordaSerializationTransformEnumDefaults(value={@CordaSerializationTransformEnumDefault(new="D", old="E"), @CordaSerializationTransformEnumDefault(new="E", old="A")})
    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0087\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lnet/corda/serialization/internal/amqp/EnumEvolveTests$OutOfOrder;", "", "(Ljava/lang/String;I)V", "A", "B", "C", "D", "E", "serialization"})
    public static final class OutOfOrder
    extends Enum<OutOfOrder> {
        public static final /* enum */ OutOfOrder A;
        public static final /* enum */ OutOfOrder B;
        public static final /* enum */ OutOfOrder C;
        public static final /* enum */ OutOfOrder D;
        public static final /* enum */ OutOfOrder E;
        private static final /* synthetic */ OutOfOrder[] $VALUES;

        static {
            OutOfOrder[] outOfOrderArray = new OutOfOrder[5];
            OutOfOrder[] outOfOrderArray2 = outOfOrderArray;
            outOfOrderArray[0] = A = new OutOfOrder();
            outOfOrderArray[1] = B = new OutOfOrder();
            outOfOrderArray[2] = C = new OutOfOrder();
            outOfOrderArray[3] = D = new OutOfOrder();
            outOfOrderArray[4] = E = new OutOfOrder();
            $VALUES = outOfOrderArray;
        }

        public static OutOfOrder[] values() {
            return (OutOfOrder[])$VALUES.clone();
        }

        public static OutOfOrder valueOf(String string) {
            return Enum.valueOf(OutOfOrder.class, string);
        }
    }

    @CordaSerializationTransformEnumDefault(new="D", old="A")
    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0087\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lnet/corda/serialization/internal/amqp/EnumEvolveTests$ChangedOrdinality;", "", "(Ljava/lang/String;I)V", "A", "B", "D", "C", "serialization"})
    public static final class ChangedOrdinality
    extends Enum<ChangedOrdinality> {
        public static final /* enum */ ChangedOrdinality A;
        public static final /* enum */ ChangedOrdinality B;
        public static final /* enum */ ChangedOrdinality D;
        public static final /* enum */ ChangedOrdinality C;
        private static final /* synthetic */ ChangedOrdinality[] $VALUES;

        static {
            ChangedOrdinality[] changedOrdinalityArray = new ChangedOrdinality[4];
            ChangedOrdinality[] changedOrdinalityArray2 = changedOrdinalityArray;
            changedOrdinalityArray[0] = A = new ChangedOrdinality();
            changedOrdinalityArray[1] = B = new ChangedOrdinality();
            changedOrdinalityArray[2] = D = new ChangedOrdinality();
            changedOrdinalityArray[3] = C = new ChangedOrdinality();
            $VALUES = changedOrdinalityArray;
        }

        public static ChangedOrdinality[] values() {
            return (ChangedOrdinality[])$VALUES.clone();
        }

        public static ChangedOrdinality valueOf(String string) {
            return Enum.valueOf(ChangedOrdinality.class, string);
        }
    }

    @CordaSerializationTransformEnumDefaults(value={@CordaSerializationTransformEnumDefault(new="E", old="C"), @CordaSerializationTransformEnumDefault(new="D", old="C")})
    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0087\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lnet/corda/serialization/internal/amqp/EnumEvolveTests$ExtendedEnum;", "", "(Ljava/lang/String;I)V", "A", "B", "C", "D", "E", "serialization"})
    public static final class ExtendedEnum
    extends Enum<ExtendedEnum> {
        public static final /* enum */ ExtendedEnum A;
        public static final /* enum */ ExtendedEnum B;
        public static final /* enum */ ExtendedEnum C;
        public static final /* enum */ ExtendedEnum D;
        public static final /* enum */ ExtendedEnum E;
        private static final /* synthetic */ ExtendedEnum[] $VALUES;

        static {
            ExtendedEnum[] extendedEnumArray = new ExtendedEnum[5];
            ExtendedEnum[] extendedEnumArray2 = extendedEnumArray;
            extendedEnumArray[0] = A = new ExtendedEnum();
            extendedEnumArray[1] = B = new ExtendedEnum();
            extendedEnumArray[2] = C = new ExtendedEnum();
            extendedEnumArray[3] = D = new ExtendedEnum();
            extendedEnumArray[4] = E = new ExtendedEnum();
            $VALUES = extendedEnumArray;
        }

        public static ExtendedEnum[] values() {
            return (ExtendedEnum[])$VALUES.clone();
        }

        public static ExtendedEnum valueOf(String string) {
            return Enum.valueOf(ExtendedEnum.class, string);
        }
    }
}

