/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp;

import java.io.NotSerializableException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.test.AssertionsKt;
import net.corda.core.serialization.CordaSerializationTransformEnumDefault;
import net.corda.core.serialization.CordaSerializationTransformEnumDefaults;
import net.corda.core.serialization.CordaSerializationTransformRename;
import net.corda.core.serialization.CordaSerializationTransformRenames;
import net.corda.core.serialization.SerializationContext;
import net.corda.core.serialization.SerializedBytes;
import net.corda.serialization.internal.NotSerializableDetailedException;
import net.corda.serialization.internal.amqp.BytesAndSchemas;
import net.corda.serialization.internal.amqp.DeserializationInput;
import net.corda.serialization.internal.amqp.EnumDefaultSchemaTransform;
import net.corda.serialization.internal.amqp.EnumEvolvabilityTests;
import net.corda.serialization.internal.amqp.Envelope;
import net.corda.serialization.internal.amqp.EvolvabilityTests;
import net.corda.serialization.internal.amqp.LocalSerializerFactory;
import net.corda.serialization.internal.amqp.ObjectAndEnvelope;
import net.corda.serialization.internal.amqp.RenameSchemaTransform;
import net.corda.serialization.internal.amqp.SerializationOutput;
import net.corda.serialization.internal.amqp.SerializerFactory;
import net.corda.serialization.internal.amqp.TransformTypes;
import net.corda.serialization.internal.amqp.TypeNotation;
import net.corda.serialization.internal.amqp.testutils.AMQPTestUtilsKt;
import net.corda.serialization.internal.amqp.testutils.ProjectStructure;
import net.corda.serialization.internal.amqp.testutils.TestSerializationContextKt;
import net.corda.serialization.internal.amqp.testutils.TestSerializationOutput;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableAssert;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b+\u0018\u0000 !2\u00020\u0001:\u0016\u001e\u001f !\"#$%&'()*+,-./0123B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0007J\b\u0010\n\u001a\u00020\tH\u0007J\b\u0010\u000b\u001a\u00020\tH\u0007J\b\u0010\f\u001a\u00020\tH\u0007J\b\u0010\r\u001a\u00020\tH\u0007J\b\u0010\u000e\u001a\u00020\tH\u0007J\b\u0010\u000f\u001a\u00020\tH\u0007J\b\u0010\u0010\u001a\u00020\tH\u0007J\b\u0010\u0011\u001a\u00020\tH\u0007J\b\u0010\u0012\u001a\u00020\tH\u0007J\b\u0010\u0013\u001a\u00020\tH\u0007J\b\u0010\u0014\u001a\u00020\tH\u0007J\b\u0010\u0015\u001a\u00020\tH\u0007J\b\u0010\u0016\u001a\u00020\tH\u0007J\b\u0010\u0017\u001a\u00020\tH\u0007J\b\u0010\u0018\u001a\u00020\tH\u0007J\b\u0010\u0019\u001a\u00020\tH\u0007J\b\u0010\u001a\u001a\u00020\tH\u0007J\b\u0010\u001b\u001a\u00020\tH\u0007J\b\u0010\u001c\u001a\u00020\tH\u0007J\b\u0010\u001d\u001a\u00020\tH\u0007R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u00064"}, d2={"Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests;", "", "()V", "localPath", "Ljava/net/URI;", "localPath$annotations", "getLocalPath", "()Ljava/net/URI;", "acceptMultipleRename", "", "bothAnnotationTypes", "defaultAnnotationIsAddedToEnvelope", "defaultAnnotationIsAddedToEnvelopeAndDeserialised", "doubleDefaultAnnotationIsAddedToEnvelope", "doubleDefaultAnnotationIsAddedToEnvelopeAndDeserialised", "doubleRenameAnnotationIsAdded", "missingDefaults", "missingRenames", "multiEnums", "noAnnotation", "rejectBadDefault", "rejectBadDefaultToSelf", "rejectCyclicRename", "rejectCyclicRenameRedux", "rejectMultipleRenameFrom", "rejectMultipleRenameTo", "renameAnnotationIsAdded", "repeatedAnnotation", "testCache", "testUnknownTransform", "AcceptMultipleRename", "AnnotatedEnumOnce", "AnnotatedEnumTwice", "Companion", "E1", "E2", "E3", "MissingDefaults", "MissingRenames", "NotAnnotated", "RejectBadDefault", "RejectBadDefaultToSelf", "RejectCyclicRename", "RejectCyclicRenameRedux", "RejectMultipleRenameFrom", "RejectMultipleRenameTo", "RenameAndExtendEnum", "RenameEnumOnce", "RenameEnumTwice", "RepeatedAnnotation", "WithUnknownTest", "WrapsUnknown", "serialization"})
public final class EnumEvolvabilityTests {
    @NotNull
    private final URI localPath;
    public static final boolean VERBOSE = false;
    public static final Companion Companion = new Companion(null);

    public static /* synthetic */ void localPath$annotations() {
    }

    @NotNull
    public final URI getLocalPath() {
        return this.localPath;
    }

    @Test(timeout=300000L)
    public final void noAnnotation() {
        SerializerFactory sf = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000'\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0018\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"net/corda/serialization/internal/amqp/EnumEvolvabilityTests$noAnnotation$C", "", "n", "Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$NotAnnotated;", "(Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$NotAnnotated;)V", "getN", "()Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$NotAnnotated;", "component1", "copy", "(Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$NotAnnotated;)Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$noAnnotation$C;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
        public final class C {
            @NotNull
            private final NotAnnotated n;

            @NotNull
            public final NotAnnotated getN() {
                return this.n;
            }

            public C(@NotNull NotAnnotated n) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)n), (String)"n");
                this.n = n;
            }

            @NotNull
            public final NotAnnotated component1() {
                return this.n;
            }

            @NotNull
            public final C copy(@NotNull NotAnnotated n) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)n), (String)"n");
                return new C(n);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ C copy$default(C c, NotAnnotated notAnnotated, int n, Object object) {
                if ((n & 1) != 0) {
                    notAnnotated = c.n;
                }
                return c.copy(notAnnotated);
            }

            @NotNull
            public String toString() {
                return "C(n=" + (Object)((Object)this.n) + ")";
            }

            public int hashCode() {
                NotAnnotated notAnnotated = this.n;
                return notAnnotated != null ? ((Object)((Object)notAnnotated)).hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof C)) break block3;
                        C c = (C)object;
                        if (!Intrinsics.areEqual((Object)((Object)this.n), (Object)((Object)c.n))) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        BytesAndSchemas bAndS = AMQPTestUtilsKt.serializeAndReturnSchema$default(new TestSerializationOutput(false, sf), new C(NotAnnotated.A), null, 2, null);
        AssertionsKt.assertEquals$default((Object)2, (Object)bAndS.getSchema().getTypes().size(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)0, (Object)bAndS.getTransformsSchema().getTypes().size(), null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void missingDefaults() {
        SerializerFactory sf = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000'\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0018\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"net/corda/serialization/internal/amqp/EnumEvolvabilityTests$missingDefaults$C", "", "m", "Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$MissingDefaults;", "(Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$MissingDefaults;)V", "getM", "()Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$MissingDefaults;", "component1", "copy", "(Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$MissingDefaults;)Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$missingDefaults$C;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
        public final class C {
            @NotNull
            private final MissingDefaults m;

            @NotNull
            public final MissingDefaults getM() {
                return this.m;
            }

            public C(@NotNull MissingDefaults m) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)m), (String)"m");
                this.m = m;
            }

            @NotNull
            public final MissingDefaults component1() {
                return this.m;
            }

            @NotNull
            public final C copy(@NotNull MissingDefaults m) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)m), (String)"m");
                return new C(m);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ C copy$default(C c, MissingDefaults missingDefaults2, int n, Object object) {
                if ((n & 1) != 0) {
                    missingDefaults2 = c.m;
                }
                return c.copy(missingDefaults2);
            }

            @NotNull
            public String toString() {
                return "C(m=" + (Object)((Object)this.m) + ")";
            }

            public int hashCode() {
                MissingDefaults missingDefaults2 = this.m;
                return missingDefaults2 != null ? ((Object)((Object)missingDefaults2)).hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof C)) break block3;
                        C c = (C)object;
                        if (!Intrinsics.areEqual((Object)((Object)this.m), (Object)((Object)c.m))) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        BytesAndSchemas bAndS = AMQPTestUtilsKt.serializeAndReturnSchema$default(new TestSerializationOutput(false, sf), new C(MissingDefaults.A), null, 2, null);
        AssertionsKt.assertEquals$default((Object)2, (Object)bAndS.getSchema().getTypes().size(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)0, (Object)bAndS.getTransformsSchema().getTypes().size(), null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void missingRenames() {
        SerializerFactory sf = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000'\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0018\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"net/corda/serialization/internal/amqp/EnumEvolvabilityTests$missingRenames$C", "", "m", "Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$MissingRenames;", "(Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$MissingRenames;)V", "getM", "()Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$MissingRenames;", "component1", "copy", "(Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$MissingRenames;)Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$missingRenames$C;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
        public final class C {
            @NotNull
            private final MissingRenames m;

            @NotNull
            public final MissingRenames getM() {
                return this.m;
            }

            public C(@NotNull MissingRenames m) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)m), (String)"m");
                this.m = m;
            }

            @NotNull
            public final MissingRenames component1() {
                return this.m;
            }

            @NotNull
            public final C copy(@NotNull MissingRenames m) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)m), (String)"m");
                return new C(m);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ C copy$default(C c, MissingRenames missingRenames2, int n, Object object) {
                if ((n & 1) != 0) {
                    missingRenames2 = c.m;
                }
                return c.copy(missingRenames2);
            }

            @NotNull
            public String toString() {
                return "C(m=" + (Object)((Object)this.m) + ")";
            }

            public int hashCode() {
                MissingRenames missingRenames2 = this.m;
                return missingRenames2 != null ? ((Object)((Object)missingRenames2)).hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof C)) break block3;
                        C c = (C)object;
                        if (!Intrinsics.areEqual((Object)((Object)this.m), (Object)((Object)c.m))) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        BytesAndSchemas bAndS = AMQPTestUtilsKt.serializeAndReturnSchema$default(new TestSerializationOutput(false, sf), new C(MissingRenames.A), null, 2, null);
        AssertionsKt.assertEquals$default((Object)2, (Object)bAndS.getSchema().getTypes().size(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)0, (Object)bAndS.getTransformsSchema().getTypes().size(), null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void defaultAnnotationIsAddedToEnvelope() {
        SerializerFactory sf = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000'\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0018\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"net/corda/serialization/internal/amqp/EnumEvolvabilityTests$defaultAnnotationIsAddedToEnvelope$C", "", "annotatedEnum", "Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$AnnotatedEnumOnce;", "(Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$AnnotatedEnumOnce;)V", "getAnnotatedEnum", "()Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$AnnotatedEnumOnce;", "component1", "copy", "(Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$AnnotatedEnumOnce;)Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$defaultAnnotationIsAddedToEnvelope$C;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
        public final class C {
            @NotNull
            private final AnnotatedEnumOnce annotatedEnum;

            @NotNull
            public final AnnotatedEnumOnce getAnnotatedEnum() {
                return this.annotatedEnum;
            }

            public C(@NotNull AnnotatedEnumOnce annotatedEnum) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)annotatedEnum), (String)"annotatedEnum");
                this.annotatedEnum = annotatedEnum;
            }

            @NotNull
            public final AnnotatedEnumOnce component1() {
                return this.annotatedEnum;
            }

            @NotNull
            public final C copy(@NotNull AnnotatedEnumOnce annotatedEnum) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)annotatedEnum), (String)"annotatedEnum");
                return new C(annotatedEnum);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ C copy$default(C c, AnnotatedEnumOnce annotatedEnumOnce, int n, Object object) {
                if ((n & 1) != 0) {
                    annotatedEnumOnce = c.annotatedEnum;
                }
                return c.copy(annotatedEnumOnce);
            }

            @NotNull
            public String toString() {
                return "C(annotatedEnum=" + (Object)((Object)this.annotatedEnum) + ")";
            }

            public int hashCode() {
                AnnotatedEnumOnce annotatedEnumOnce = this.annotatedEnum;
                return annotatedEnumOnce != null ? ((Object)((Object)annotatedEnumOnce)).hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof C)) break block3;
                        C c = (C)object;
                        if (!Intrinsics.areEqual((Object)((Object)this.annotatedEnum), (Object)((Object)c.annotatedEnum))) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        BytesAndSchemas bAndS = AMQPTestUtilsKt.serializeAndReturnSchema$default(new TestSerializationOutput(false, sf), new C(AnnotatedEnumOnce.D), null, 2, null);
        AssertionsKt.assertEquals$default((Object)2, (Object)bAndS.getSchema().getTypes().size(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)1, (Object)bAndS.getTransformsSchema().getTypes().size(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)AnnotatedEnumOnce.class.getName(), (Object)CollectionsKt.first((Iterable)bAndS.getTransformsSchema().getTypes().keySet()), null, (int)4, null);
        EnumMap schema = (EnumMap)CollectionsKt.first((Iterable)bAndS.getTransformsSchema().getTypes().values());
        AssertionsKt.assertEquals$default((Object)1, (Object)schema.size(), null, (int)4, null);
        AssertionsKt.assertTrue$default((boolean)schema.keySet().contains(TransformTypes.EnumDefault), null, (int)2, null);
        Integer n = 1;
        Object v = schema.get(TransformTypes.EnumDefault);
        if (v == null) {
            Intrinsics.throwNpe();
        }
        AssertionsKt.assertEquals$default((Object)n, (Object)((List)v).size(), null, (int)4, null);
        Object v2 = schema.get(TransformTypes.EnumDefault);
        if (v2 == null) {
            Intrinsics.throwNpe();
        }
        AssertionsKt.assertTrue$default((boolean)(((List)v2).get(0) instanceof EnumDefaultSchemaTransform), null, (int)2, null);
        Object v3 = schema.get(TransformTypes.EnumDefault);
        if (v3 == null) {
            Intrinsics.throwNpe();
        }
        Object e2 = ((List)v3).get(0);
        if (e2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.corda.serialization.internal.amqp.EnumDefaultSchemaTransform");
        }
        AssertionsKt.assertEquals$default((Object)"D", (Object)((EnumDefaultSchemaTransform)e2).getNew(), null, (int)4, null);
        Object v4 = schema.get(TransformTypes.EnumDefault);
        if (v4 == null) {
            Intrinsics.throwNpe();
        }
        Object e3 = ((List)v4).get(0);
        if (e3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.corda.serialization.internal.amqp.EnumDefaultSchemaTransform");
        }
        AssertionsKt.assertEquals$default((Object)"A", (Object)((EnumDefaultSchemaTransform)e3).getOld(), null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void doubleDefaultAnnotationIsAddedToEnvelope() {
        SerializerFactory sf = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000'\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0018\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"net/corda/serialization/internal/amqp/EnumEvolvabilityTests$doubleDefaultAnnotationIsAddedToEnvelope$C", "", "annotatedEnum", "Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$AnnotatedEnumTwice;", "(Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$AnnotatedEnumTwice;)V", "getAnnotatedEnum", "()Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$AnnotatedEnumTwice;", "component1", "copy", "(Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$AnnotatedEnumTwice;)Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$doubleDefaultAnnotationIsAddedToEnvelope$C;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
        public final class C {
            @NotNull
            private final AnnotatedEnumTwice annotatedEnum;

            @NotNull
            public final AnnotatedEnumTwice getAnnotatedEnum() {
                return this.annotatedEnum;
            }

            public C(@NotNull AnnotatedEnumTwice annotatedEnum) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)annotatedEnum), (String)"annotatedEnum");
                this.annotatedEnum = annotatedEnum;
            }

            @NotNull
            public final AnnotatedEnumTwice component1() {
                return this.annotatedEnum;
            }

            @NotNull
            public final C copy(@NotNull AnnotatedEnumTwice annotatedEnum) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)annotatedEnum), (String)"annotatedEnum");
                return new C(annotatedEnum);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ C copy$default(C c, AnnotatedEnumTwice annotatedEnumTwice, int n, Object object) {
                if ((n & 1) != 0) {
                    annotatedEnumTwice = c.annotatedEnum;
                }
                return c.copy(annotatedEnumTwice);
            }

            @NotNull
            public String toString() {
                return "C(annotatedEnum=" + (Object)((Object)this.annotatedEnum) + ")";
            }

            public int hashCode() {
                AnnotatedEnumTwice annotatedEnumTwice = this.annotatedEnum;
                return annotatedEnumTwice != null ? ((Object)((Object)annotatedEnumTwice)).hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof C)) break block3;
                        C c = (C)object;
                        if (!Intrinsics.areEqual((Object)((Object)this.annotatedEnum), (Object)((Object)c.annotatedEnum))) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        BytesAndSchemas bAndS = AMQPTestUtilsKt.serializeAndReturnSchema$default(new TestSerializationOutput(false, sf), new C(AnnotatedEnumTwice.E), null, 2, null);
        AssertionsKt.assertEquals$default((Object)2, (Object)bAndS.getSchema().getTypes().size(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)1, (Object)bAndS.getTransformsSchema().getTypes().size(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)AnnotatedEnumTwice.class.getName(), (Object)CollectionsKt.first((Iterable)bAndS.getTransformsSchema().getTypes().keySet()), null, (int)4, null);
        EnumMap schema = (EnumMap)CollectionsKt.first((Iterable)bAndS.getTransformsSchema().getTypes().values());
        AssertionsKt.assertEquals$default((Object)1, (Object)schema.size(), null, (int)4, null);
        AssertionsKt.assertTrue$default((boolean)schema.keySet().contains(TransformTypes.EnumDefault), null, (int)2, null);
        Integer n = 2;
        Object v = schema.get(TransformTypes.EnumDefault);
        if (v == null) {
            Intrinsics.throwNpe();
        }
        AssertionsKt.assertEquals$default((Object)n, (Object)((List)v).size(), null, (int)4, null);
        Object v2 = schema.get(TransformTypes.EnumDefault);
        if (v2 == null) {
            Intrinsics.throwNpe();
        }
        AssertionsKt.assertTrue$default((boolean)(((List)v2).get(0) instanceof EnumDefaultSchemaTransform), null, (int)2, null);
        Object v3 = schema.get(TransformTypes.EnumDefault);
        if (v3 == null) {
            Intrinsics.throwNpe();
        }
        Object e2 = ((List)v3).get(0);
        if (e2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.corda.serialization.internal.amqp.EnumDefaultSchemaTransform");
        }
        AssertionsKt.assertEquals$default((Object)"E", (Object)((EnumDefaultSchemaTransform)e2).getNew(), null, (int)4, null);
        Object v4 = schema.get(TransformTypes.EnumDefault);
        if (v4 == null) {
            Intrinsics.throwNpe();
        }
        Object e3 = ((List)v4).get(0);
        if (e3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.corda.serialization.internal.amqp.EnumDefaultSchemaTransform");
        }
        AssertionsKt.assertEquals$default((Object)"D", (Object)((EnumDefaultSchemaTransform)e3).getOld(), null, (int)4, null);
        Object v5 = schema.get(TransformTypes.EnumDefault);
        if (v5 == null) {
            Intrinsics.throwNpe();
        }
        AssertionsKt.assertTrue$default((boolean)(((List)v5).get(1) instanceof EnumDefaultSchemaTransform), null, (int)2, null);
        Object v6 = schema.get(TransformTypes.EnumDefault);
        if (v6 == null) {
            Intrinsics.throwNpe();
        }
        Object e4 = ((List)v6).get(1);
        if (e4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.corda.serialization.internal.amqp.EnumDefaultSchemaTransform");
        }
        AssertionsKt.assertEquals$default((Object)"D", (Object)((EnumDefaultSchemaTransform)e4).getNew(), null, (int)4, null);
        Object v7 = schema.get(TransformTypes.EnumDefault);
        if (v7 == null) {
            Intrinsics.throwNpe();
        }
        Object e5 = ((List)v7).get(1);
        if (e5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.corda.serialization.internal.amqp.EnumDefaultSchemaTransform");
        }
        AssertionsKt.assertEquals$default((Object)"A", (Object)((EnumDefaultSchemaTransform)e5).getOld(), null, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void defaultAnnotationIsAddedToEnvelopeAndDeserialised() {
        EnumMap schema;
        void $receiver$iv$iv;
        Map $receiver$iv;
        SerializerFactory sf = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000'\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0018\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"net/corda/serialization/internal/amqp/EnumEvolvabilityTests$defaultAnnotationIsAddedToEnvelopeAndDeserialised$C", "", "annotatedEnum", "Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$AnnotatedEnumOnce;", "(Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$AnnotatedEnumOnce;)V", "getAnnotatedEnum", "()Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$AnnotatedEnumOnce;", "component1", "copy", "(Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$AnnotatedEnumOnce;)Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$defaultAnnotationIsAddedToEnvelopeAndDeserialised$C;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
        public final class C {
            @NotNull
            private final AnnotatedEnumOnce annotatedEnum;

            @NotNull
            public final AnnotatedEnumOnce getAnnotatedEnum() {
                return this.annotatedEnum;
            }

            public C(@NotNull AnnotatedEnumOnce annotatedEnum) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)annotatedEnum), (String)"annotatedEnum");
                this.annotatedEnum = annotatedEnum;
            }

            @NotNull
            public final AnnotatedEnumOnce component1() {
                return this.annotatedEnum;
            }

            @NotNull
            public final C copy(@NotNull AnnotatedEnumOnce annotatedEnum) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)annotatedEnum), (String)"annotatedEnum");
                return new C(annotatedEnum);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ C copy$default(C c, AnnotatedEnumOnce annotatedEnumOnce, int n, Object object) {
                if ((n & 1) != 0) {
                    annotatedEnumOnce = c.annotatedEnum;
                }
                return c.copy(annotatedEnumOnce);
            }

            @NotNull
            public String toString() {
                return "C(annotatedEnum=" + (Object)((Object)this.annotatedEnum) + ")";
            }

            public int hashCode() {
                AnnotatedEnumOnce annotatedEnumOnce = this.annotatedEnum;
                return annotatedEnumOnce != null ? ((Object)((Object)annotatedEnumOnce)).hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof C)) break block3;
                        C c = (C)object;
                        if (!Intrinsics.areEqual((Object)((Object)this.annotatedEnum), (Object)((Object)c.annotatedEnum))) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        SerializedBytes<C> sb = new TestSerializationOutput(false, sf).serialize(new C(AnnotatedEnumOnce.D));
        DeserializationInput $receiver$iv2 = new DeserializationInput(sf);
        SerializationContext context$iv = null;
        ObjectAndEnvelope db = $receiver$iv2.deserializeAndReturnEnvelope(sb, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)2, (Object)db.getEnvelope().getSchema().getTypes().size(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)1, (Object)db.getEnvelope().getTransformsSchema().getTypes().size(), null, (int)4, null);
        String eName = AnnotatedEnumOnce.class.getName();
        List types = db.getEnvelope().getSchema().getTypes();
        Map transforms = db.getEnvelope().getTransformsSchema().getTypes();
        Iterable iterable = types;
        Integer n = 1;
        Map map = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            TypeNotation it = (TypeNotation)element$iv$iv;
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)eName)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        AssertionsKt.assertEquals$default((Object)n, (Object)list.size(), null, (int)4, null);
        map = $receiver$iv = transforms;
        AssertionsKt.assertTrue$default((boolean)map.containsKey(eName), null, (int)2, null);
        EnumMap enumMap = schema = (EnumMap)transforms.get(eName);
        if (enumMap == null) {
            Intrinsics.throwNpe();
        }
        AssertionsKt.assertTrue$default((boolean)enumMap.keySet().contains(TransformTypes.EnumDefault), null, (int)2, null);
        Integer n2 = 1;
        Object v = schema.get(TransformTypes.EnumDefault);
        if (v == null) {
            Intrinsics.throwNpe();
        }
        AssertionsKt.assertEquals$default((Object)n2, (Object)((List)v).size(), null, (int)4, null);
        Object v2 = schema.get(TransformTypes.EnumDefault);
        if (v2 == null) {
            Intrinsics.throwNpe();
        }
        AssertionsKt.assertTrue$default((boolean)(((List)v2).get(0) instanceof EnumDefaultSchemaTransform), null, (int)2, null);
        Object v3 = schema.get(TransformTypes.EnumDefault);
        if (v3 == null) {
            Intrinsics.throwNpe();
        }
        Object e2 = ((List)v3).get(0);
        if (e2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.corda.serialization.internal.amqp.EnumDefaultSchemaTransform");
        }
        AssertionsKt.assertEquals$default((Object)"D", (Object)((EnumDefaultSchemaTransform)e2).getNew(), null, (int)4, null);
        Object v4 = schema.get(TransformTypes.EnumDefault);
        if (v4 == null) {
            Intrinsics.throwNpe();
        }
        Object e3 = ((List)v4).get(0);
        if (e3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.corda.serialization.internal.amqp.EnumDefaultSchemaTransform");
        }
        AssertionsKt.assertEquals$default((Object)"A", (Object)((EnumDefaultSchemaTransform)e3).getOld(), null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void doubleDefaultAnnotationIsAddedToEnvelopeAndDeserialised() {
        SerializerFactory sf = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000'\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0018\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"net/corda/serialization/internal/amqp/EnumEvolvabilityTests$doubleDefaultAnnotationIsAddedToEnvelopeAndDeserialised$C", "", "annotatedEnum", "Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$AnnotatedEnumTwice;", "(Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$AnnotatedEnumTwice;)V", "getAnnotatedEnum", "()Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$AnnotatedEnumTwice;", "component1", "copy", "(Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$AnnotatedEnumTwice;)Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$doubleDefaultAnnotationIsAddedToEnvelopeAndDeserialised$C;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
        public final class C {
            @NotNull
            private final AnnotatedEnumTwice annotatedEnum;

            @NotNull
            public final AnnotatedEnumTwice getAnnotatedEnum() {
                return this.annotatedEnum;
            }

            public C(@NotNull AnnotatedEnumTwice annotatedEnum) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)annotatedEnum), (String)"annotatedEnum");
                this.annotatedEnum = annotatedEnum;
            }

            @NotNull
            public final AnnotatedEnumTwice component1() {
                return this.annotatedEnum;
            }

            @NotNull
            public final C copy(@NotNull AnnotatedEnumTwice annotatedEnum) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)annotatedEnum), (String)"annotatedEnum");
                return new C(annotatedEnum);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ C copy$default(C c, AnnotatedEnumTwice annotatedEnumTwice, int n, Object object) {
                if ((n & 1) != 0) {
                    annotatedEnumTwice = c.annotatedEnum;
                }
                return c.copy(annotatedEnumTwice);
            }

            @NotNull
            public String toString() {
                return "C(annotatedEnum=" + (Object)((Object)this.annotatedEnum) + ")";
            }

            public int hashCode() {
                AnnotatedEnumTwice annotatedEnumTwice = this.annotatedEnum;
                return annotatedEnumTwice != null ? ((Object)((Object)annotatedEnumTwice)).hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof C)) break block3;
                        C c = (C)object;
                        if (!Intrinsics.areEqual((Object)((Object)this.annotatedEnum), (Object)((Object)c.annotatedEnum))) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        SerializedBytes<C> sb = new TestSerializationOutput(false, sf).serialize(new C(AnnotatedEnumTwice.E));
        DeserializationInput $receiver$iv = new DeserializationInput(sf);
        Object context$iv = null;
        ObjectAndEnvelope db = $receiver$iv.deserializeAndReturnEnvelope(sb, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)2, (Object)db.getEnvelope().getSchema().getTypes().size(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)1, (Object)db.getEnvelope().getTransformsSchema().getTypes().size(), null, (int)4, null);
        Map transforms = db.getEnvelope().getTransformsSchema().getTypes();
        context$iv = transforms;
        String string = AnnotatedEnumTwice.class.getName();
        Object object = context$iv;
        AssertionsKt.assertTrue$default((boolean)object.containsKey(string), null, (int)2, null);
        Object v = transforms.get(AnnotatedEnumTwice.class.getName());
        if (v == null) {
            Intrinsics.throwNpe();
        }
        context$iv = (Map)v;
        string = TransformTypes.EnumDefault;
        object = context$iv;
        AssertionsKt.assertTrue$default((boolean)object.containsKey(string), null, (int)2, null);
        Integer n = 2;
        Object v2 = transforms.get(AnnotatedEnumTwice.class.getName());
        if (v2 == null) {
            Intrinsics.throwNpe();
        }
        Object v3 = ((EnumMap)v2).get(TransformTypes.EnumDefault);
        if (v3 == null) {
            Intrinsics.throwNpe();
        }
        AssertionsKt.assertEquals$default((Object)n, (Object)((List)v3).size(), null, (int)4, null);
        Object v4 = transforms.get(AnnotatedEnumTwice.class.getName());
        if (v4 == null) {
            Intrinsics.throwNpe();
        }
        Object v5 = ((EnumMap)v4).get(TransformTypes.EnumDefault);
        if (v5 == null) {
            Intrinsics.throwNpe();
        }
        List enumDefaults = (List)v5;
        Object e2 = enumDefaults.get(0);
        if (e2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.corda.serialization.internal.amqp.EnumDefaultSchemaTransform");
        }
        AssertionsKt.assertEquals$default((Object)"E", (Object)((EnumDefaultSchemaTransform)e2).getNew(), null, (int)4, null);
        Object e3 = enumDefaults.get(0);
        if (e3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.corda.serialization.internal.amqp.EnumDefaultSchemaTransform");
        }
        AssertionsKt.assertEquals$default((Object)"D", (Object)((EnumDefaultSchemaTransform)e3).getOld(), null, (int)4, null);
        Object e4 = enumDefaults.get(1);
        if (e4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.corda.serialization.internal.amqp.EnumDefaultSchemaTransform");
        }
        AssertionsKt.assertEquals$default((Object)"D", (Object)((EnumDefaultSchemaTransform)e4).getNew(), null, (int)4, null);
        Object e5 = enumDefaults.get(1);
        if (e5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.corda.serialization.internal.amqp.EnumDefaultSchemaTransform");
        }
        AssertionsKt.assertEquals$default((Object)"A", (Object)((EnumDefaultSchemaTransform)e5).getOld(), null, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void renameAnnotationIsAdded() {
        void $receiver$iv;
        SerializerFactory sf = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000'\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0018\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"net/corda/serialization/internal/amqp/EnumEvolvabilityTests$renameAnnotationIsAdded$C", "", "annotatedEnum", "Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$RenameEnumOnce;", "(Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$RenameEnumOnce;)V", "getAnnotatedEnum", "()Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$RenameEnumOnce;", "component1", "copy", "(Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$RenameEnumOnce;)Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$renameAnnotationIsAdded$C;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
        public final class C {
            @NotNull
            private final RenameEnumOnce annotatedEnum;

            @NotNull
            public final RenameEnumOnce getAnnotatedEnum() {
                return this.annotatedEnum;
            }

            public C(@NotNull RenameEnumOnce annotatedEnum) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)annotatedEnum), (String)"annotatedEnum");
                this.annotatedEnum = annotatedEnum;
            }

            @NotNull
            public final RenameEnumOnce component1() {
                return this.annotatedEnum;
            }

            @NotNull
            public final C copy(@NotNull RenameEnumOnce annotatedEnum) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)annotatedEnum), (String)"annotatedEnum");
                return new C(annotatedEnum);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ C copy$default(C c, RenameEnumOnce renameEnumOnce, int n, Object object) {
                if ((n & 1) != 0) {
                    renameEnumOnce = c.annotatedEnum;
                }
                return c.copy(renameEnumOnce);
            }

            @NotNull
            public String toString() {
                return "C(annotatedEnum=" + (Object)((Object)this.annotatedEnum) + ")";
            }

            public int hashCode() {
                RenameEnumOnce renameEnumOnce = this.annotatedEnum;
                return renameEnumOnce != null ? ((Object)((Object)renameEnumOnce)).hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof C)) break block3;
                        C c = (C)object;
                        if (!Intrinsics.areEqual((Object)((Object)this.annotatedEnum), (Object)((Object)c.annotatedEnum))) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        BytesAndSchemas bAndS = AMQPTestUtilsKt.serializeAndReturnSchema$default(new TestSerializationOutput(false, sf), new C(RenameEnumOnce.E), null, 2, null);
        AssertionsKt.assertEquals$default((Object)2, (Object)bAndS.getSchema().getTypes().size(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)1, (Object)bAndS.getTransformsSchema().getTypes().size(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)RenameEnumOnce.class.getName(), (Object)CollectionsKt.first((Iterable)bAndS.getTransformsSchema().getTypes().keySet()), null, (int)4, null);
        Object v = bAndS.getTransformsSchema().getTypes().get(RenameEnumOnce.class.getName());
        if (v == null) {
            Intrinsics.throwNpe();
        }
        EnumMap serialisedSchema = (EnumMap)v;
        AssertionsKt.assertEquals$default((Object)1, (Object)serialisedSchema.size(), null, (int)4, null);
        AssertionsKt.assertTrue$default((boolean)serialisedSchema.containsKey(TransformTypes.Rename), null, (int)2, null);
        Integer n = 1;
        Object v2 = serialisedSchema.get(TransformTypes.Rename);
        if (v2 == null) {
            Intrinsics.throwNpe();
        }
        AssertionsKt.assertEquals$default((Object)n, (Object)((List)v2).size(), null, (int)4, null);
        Object v3 = serialisedSchema.get(TransformTypes.Rename);
        if (v3 == null) {
            Intrinsics.throwNpe();
        }
        Object e2 = ((List)v3).get(0);
        if (e2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.corda.serialization.internal.amqp.RenameSchemaTransform");
        }
        AssertionsKt.assertEquals$default((Object)"D", (Object)((RenameSchemaTransform)e2).getFrom(), null, (int)4, null);
        Object v4 = serialisedSchema.get(TransformTypes.Rename);
        if (v4 == null) {
            Intrinsics.throwNpe();
        }
        Object e3 = ((List)v4).get(0);
        if (e3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.corda.serialization.internal.amqp.RenameSchemaTransform");
        }
        AssertionsKt.assertEquals$default((Object)"E", (Object)((RenameSchemaTransform)e3).getTo(), null, (int)4, null);
        DeserializationInput deserializationInput = new DeserializationInput(sf);
        SerializedBytes bytes$iv = bAndS.getObj();
        SerializationContext context$iv = null;
        ObjectAndEnvelope cAndS = $receiver$iv.deserializeAndReturnEnvelope(bytes$iv, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)2, (Object)cAndS.getEnvelope().getSchema().getTypes().size(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)1, (Object)cAndS.getEnvelope().getTransformsSchema().getTypes().size(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)RenameEnumOnce.class.getName(), (Object)CollectionsKt.first((Iterable)cAndS.getEnvelope().getTransformsSchema().getTypes().keySet()), null, (int)4, null);
        Object v5 = cAndS.getEnvelope().getTransformsSchema().getTypes().get(RenameEnumOnce.class.getName());
        if (v5 == null) {
            Intrinsics.throwNpe();
        }
        EnumMap deserialisedSchema = (EnumMap)v5;
        AssertionsKt.assertEquals$default((Object)1, (Object)deserialisedSchema.size(), null, (int)4, null);
        AssertionsKt.assertTrue$default((boolean)deserialisedSchema.containsKey(TransformTypes.Rename), null, (int)2, null);
        Integer n2 = 1;
        Object v6 = deserialisedSchema.get(TransformTypes.Rename);
        if (v6 == null) {
            Intrinsics.throwNpe();
        }
        AssertionsKt.assertEquals$default((Object)n2, (Object)((List)v6).size(), null, (int)4, null);
        Object v7 = deserialisedSchema.get(TransformTypes.Rename);
        if (v7 == null) {
            Intrinsics.throwNpe();
        }
        Object e4 = ((List)v7).get(0);
        if (e4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.corda.serialization.internal.amqp.RenameSchemaTransform");
        }
        AssertionsKt.assertEquals$default((Object)"D", (Object)((RenameSchemaTransform)e4).getFrom(), null, (int)4, null);
        Object v8 = deserialisedSchema.get(TransformTypes.Rename);
        if (v8 == null) {
            Intrinsics.throwNpe();
        }
        Object e5 = ((List)v8).get(0);
        if (e5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.corda.serialization.internal.amqp.RenameSchemaTransform");
        }
        AssertionsKt.assertEquals$default((Object)"E", (Object)((RenameSchemaTransform)e5).getTo(), null, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void doubleRenameAnnotationIsAdded() {
        void $receiver$iv;
        SerializerFactory sf = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000'\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0018\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"net/corda/serialization/internal/amqp/EnumEvolvabilityTests$doubleRenameAnnotationIsAdded$C", "", "annotatedEnum", "Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$RenameEnumTwice;", "(Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$RenameEnumTwice;)V", "getAnnotatedEnum", "()Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$RenameEnumTwice;", "component1", "copy", "(Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$RenameEnumTwice;)Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$doubleRenameAnnotationIsAdded$C;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
        public final class C {
            @NotNull
            private final RenameEnumTwice annotatedEnum;

            @NotNull
            public final RenameEnumTwice getAnnotatedEnum() {
                return this.annotatedEnum;
            }

            public C(@NotNull RenameEnumTwice annotatedEnum) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)annotatedEnum), (String)"annotatedEnum");
                this.annotatedEnum = annotatedEnum;
            }

            @NotNull
            public final RenameEnumTwice component1() {
                return this.annotatedEnum;
            }

            @NotNull
            public final C copy(@NotNull RenameEnumTwice annotatedEnum) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)annotatedEnum), (String)"annotatedEnum");
                return new C(annotatedEnum);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ C copy$default(C c, RenameEnumTwice renameEnumTwice, int n, Object object) {
                if ((n & 1) != 0) {
                    renameEnumTwice = c.annotatedEnum;
                }
                return c.copy(renameEnumTwice);
            }

            @NotNull
            public String toString() {
                return "C(annotatedEnum=" + (Object)((Object)this.annotatedEnum) + ")";
            }

            public int hashCode() {
                RenameEnumTwice renameEnumTwice = this.annotatedEnum;
                return renameEnumTwice != null ? ((Object)((Object)renameEnumTwice)).hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof C)) break block3;
                        C c = (C)object;
                        if (!Intrinsics.areEqual((Object)((Object)this.annotatedEnum), (Object)((Object)c.annotatedEnum))) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        BytesAndSchemas bAndS = AMQPTestUtilsKt.serializeAndReturnSchema$default(new TestSerializationOutput(false, sf), new C(RenameEnumTwice.F), null, 2, null);
        AssertionsKt.assertEquals$default((Object)2, (Object)bAndS.getSchema().getTypes().size(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)1, (Object)bAndS.getTransformsSchema().getTypes().size(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)RenameEnumTwice.class.getName(), (Object)CollectionsKt.first((Iterable)bAndS.getTransformsSchema().getTypes().keySet()), null, (int)4, null);
        Object v = bAndS.getTransformsSchema().getTypes().get(RenameEnumTwice.class.getName());
        if (v == null) {
            Intrinsics.throwNpe();
        }
        EnumMap serialisedSchema = (EnumMap)v;
        AssertionsKt.assertEquals$default((Object)1, (Object)serialisedSchema.size(), null, (int)4, null);
        AssertionsKt.assertTrue$default((boolean)serialisedSchema.containsKey(TransformTypes.Rename), null, (int)2, null);
        Integer n = 2;
        Object v2 = serialisedSchema.get(TransformTypes.Rename);
        if (v2 == null) {
            Intrinsics.throwNpe();
        }
        AssertionsKt.assertEquals$default((Object)n, (Object)((List)v2).size(), null, (int)4, null);
        Object v3 = serialisedSchema.get(TransformTypes.Rename);
        if (v3 == null) {
            Intrinsics.throwNpe();
        }
        Object e2 = ((List)v3).get(0);
        if (e2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.corda.serialization.internal.amqp.RenameSchemaTransform");
        }
        AssertionsKt.assertEquals$default((Object)"C", (Object)((RenameSchemaTransform)e2).getFrom(), null, (int)4, null);
        Object v4 = serialisedSchema.get(TransformTypes.Rename);
        if (v4 == null) {
            Intrinsics.throwNpe();
        }
        Object e3 = ((List)v4).get(0);
        if (e3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.corda.serialization.internal.amqp.RenameSchemaTransform");
        }
        AssertionsKt.assertEquals$default((Object)"E", (Object)((RenameSchemaTransform)e3).getTo(), null, (int)4, null);
        Object v5 = serialisedSchema.get(TransformTypes.Rename);
        if (v5 == null) {
            Intrinsics.throwNpe();
        }
        Object e4 = ((List)v5).get(1);
        if (e4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.corda.serialization.internal.amqp.RenameSchemaTransform");
        }
        AssertionsKt.assertEquals$default((Object)"D", (Object)((RenameSchemaTransform)e4).getFrom(), null, (int)4, null);
        Object v6 = serialisedSchema.get(TransformTypes.Rename);
        if (v6 == null) {
            Intrinsics.throwNpe();
        }
        Object e5 = ((List)v6).get(1);
        if (e5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.corda.serialization.internal.amqp.RenameSchemaTransform");
        }
        AssertionsKt.assertEquals$default((Object)"F", (Object)((RenameSchemaTransform)e5).getTo(), null, (int)4, null);
        DeserializationInput deserializationInput = new DeserializationInput(sf);
        SerializedBytes bytes$iv = bAndS.getObj();
        SerializationContext context$iv = null;
        ObjectAndEnvelope cAndS = $receiver$iv.deserializeAndReturnEnvelope(bytes$iv, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)2, (Object)cAndS.getEnvelope().getSchema().getTypes().size(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)1, (Object)cAndS.getEnvelope().getTransformsSchema().getTypes().size(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)RenameEnumTwice.class.getName(), (Object)CollectionsKt.first((Iterable)cAndS.getEnvelope().getTransformsSchema().getTypes().keySet()), null, (int)4, null);
        Object v7 = cAndS.getEnvelope().getTransformsSchema().getTypes().get(RenameEnumTwice.class.getName());
        if (v7 == null) {
            Intrinsics.throwNpe();
        }
        EnumMap deserialisedSchema = (EnumMap)v7;
        AssertionsKt.assertEquals$default((Object)1, (Object)deserialisedSchema.size(), null, (int)4, null);
        AssertionsKt.assertTrue$default((boolean)deserialisedSchema.containsKey(TransformTypes.Rename), null, (int)2, null);
        Integer n2 = 2;
        Object v8 = deserialisedSchema.get(TransformTypes.Rename);
        if (v8 == null) {
            Intrinsics.throwNpe();
        }
        AssertionsKt.assertEquals$default((Object)n2, (Object)((List)v8).size(), null, (int)4, null);
        Object v9 = deserialisedSchema.get(TransformTypes.Rename);
        if (v9 == null) {
            Intrinsics.throwNpe();
        }
        Object e6 = ((List)v9).get(0);
        if (e6 == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.corda.serialization.internal.amqp.RenameSchemaTransform");
        }
        AssertionsKt.assertEquals$default((Object)"C", (Object)((RenameSchemaTransform)e6).getFrom(), null, (int)4, null);
        Object v10 = deserialisedSchema.get(TransformTypes.Rename);
        if (v10 == null) {
            Intrinsics.throwNpe();
        }
        Object e7 = ((List)v10).get(0);
        if (e7 == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.corda.serialization.internal.amqp.RenameSchemaTransform");
        }
        AssertionsKt.assertEquals$default((Object)"E", (Object)((RenameSchemaTransform)e7).getTo(), null, (int)4, null);
        Object v11 = deserialisedSchema.get(TransformTypes.Rename);
        if (v11 == null) {
            Intrinsics.throwNpe();
        }
        Object e8 = ((List)v11).get(1);
        if (e8 == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.corda.serialization.internal.amqp.RenameSchemaTransform");
        }
        AssertionsKt.assertEquals$default((Object)"D", (Object)((RenameSchemaTransform)e8).getFrom(), null, (int)4, null);
        Object v12 = deserialisedSchema.get(TransformTypes.Rename);
        if (v12 == null) {
            Intrinsics.throwNpe();
        }
        Object e9 = ((List)v12).get(1);
        if (e9 == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.corda.serialization.internal.amqp.RenameSchemaTransform");
        }
        AssertionsKt.assertEquals$default((Object)"F", (Object)((RenameSchemaTransform)e9).getTo(), null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void bothAnnotationTypes() {
        SerializerFactory sf = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000'\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0018\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"net/corda/serialization/internal/amqp/EnumEvolvabilityTests$bothAnnotationTypes$C", "", "annotatedEnum", "Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$RenameAndExtendEnum;", "(Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$RenameAndExtendEnum;)V", "getAnnotatedEnum", "()Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$RenameAndExtendEnum;", "component1", "copy", "(Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$RenameAndExtendEnum;)Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$bothAnnotationTypes$C;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
        public final class C {
            @NotNull
            private final RenameAndExtendEnum annotatedEnum;

            @NotNull
            public final RenameAndExtendEnum getAnnotatedEnum() {
                return this.annotatedEnum;
            }

            public C(@NotNull RenameAndExtendEnum annotatedEnum) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)annotatedEnum), (String)"annotatedEnum");
                this.annotatedEnum = annotatedEnum;
            }

            @NotNull
            public final RenameAndExtendEnum component1() {
                return this.annotatedEnum;
            }

            @NotNull
            public final C copy(@NotNull RenameAndExtendEnum annotatedEnum) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)annotatedEnum), (String)"annotatedEnum");
                return new C(annotatedEnum);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ C copy$default(C c, RenameAndExtendEnum renameAndExtendEnum, int n, Object object) {
                if ((n & 1) != 0) {
                    renameAndExtendEnum = c.annotatedEnum;
                }
                return c.copy(renameAndExtendEnum);
            }

            @NotNull
            public String toString() {
                return "C(annotatedEnum=" + (Object)((Object)this.annotatedEnum) + ")";
            }

            public int hashCode() {
                RenameAndExtendEnum renameAndExtendEnum = this.annotatedEnum;
                return renameAndExtendEnum != null ? ((Object)((Object)renameAndExtendEnum)).hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof C)) break block3;
                        C c = (C)object;
                        if (!Intrinsics.areEqual((Object)((Object)this.annotatedEnum), (Object)((Object)c.annotatedEnum))) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        BytesAndSchemas bAndS = AMQPTestUtilsKt.serializeAndReturnSchema$default(new TestSerializationOutput(false, sf), new C(RenameAndExtendEnum.X), null, 2, null);
        AssertionsKt.assertEquals$default((Object)2, (Object)bAndS.getSchema().getTypes().size(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)1, (Object)bAndS.getTransformsSchema().getTypes().size(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)RenameAndExtendEnum.class.getName(), (Object)CollectionsKt.first((Iterable)bAndS.getTransformsSchema().getTypes().keySet()), null, (int)4, null);
        Object v = bAndS.getTransformsSchema().getTypes().get(RenameAndExtendEnum.class.getName());
        if (v == null) {
            Intrinsics.throwNpe();
        }
        EnumMap serialisedSchema = (EnumMap)v;
        AssertionsKt.assertEquals$default((Object)2, (Object)serialisedSchema.size(), null, (int)4, null);
        AssertionsKt.assertTrue$default((boolean)serialisedSchema.containsKey(TransformTypes.Rename), null, (int)2, null);
        AssertionsKt.assertTrue$default((boolean)serialisedSchema.containsKey(TransformTypes.EnumDefault), null, (int)2, null);
        Integer n = 1;
        Object v2 = serialisedSchema.get(TransformTypes.Rename);
        if (v2 == null) {
            Intrinsics.throwNpe();
        }
        AssertionsKt.assertEquals$default((Object)n, (Object)((List)v2).size(), null, (int)4, null);
        Object v3 = serialisedSchema.get(TransformTypes.Rename);
        if (v3 == null) {
            Intrinsics.throwNpe();
        }
        Object e2 = ((List)v3).get(0);
        if (e2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.corda.serialization.internal.amqp.RenameSchemaTransform");
        }
        AssertionsKt.assertEquals$default((Object)"A", (Object)((RenameSchemaTransform)e2).getFrom(), null, (int)4, null);
        Object v4 = serialisedSchema.get(TransformTypes.Rename);
        if (v4 == null) {
            Intrinsics.throwNpe();
        }
        Object e3 = ((List)v4).get(0);
        if (e3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.corda.serialization.internal.amqp.RenameSchemaTransform");
        }
        AssertionsKt.assertEquals$default((Object)"X", (Object)((RenameSchemaTransform)e3).getTo(), null, (int)4, null);
        Integer n2 = 1;
        Object v5 = serialisedSchema.get(TransformTypes.EnumDefault);
        if (v5 == null) {
            Intrinsics.throwNpe();
        }
        AssertionsKt.assertEquals$default((Object)n2, (Object)((List)v5).size(), null, (int)4, null);
        Object v6 = serialisedSchema.get(TransformTypes.EnumDefault);
        if (v6 == null) {
            Intrinsics.throwNpe();
        }
        Object e4 = ((List)v6).get(0);
        if (e4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.corda.serialization.internal.amqp.EnumDefaultSchemaTransform");
        }
        AssertionsKt.assertEquals$default((Object)"E", (Object)((EnumDefaultSchemaTransform)e4).getNew(), null, (int)4, null);
        Object v7 = serialisedSchema.get(TransformTypes.EnumDefault);
        if (v7 == null) {
            Intrinsics.throwNpe();
        }
        Object e5 = ((List)v7).get(0);
        if (e5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.corda.serialization.internal.amqp.EnumDefaultSchemaTransform");
        }
        AssertionsKt.assertEquals$default((Object)"X", (Object)((EnumDefaultSchemaTransform)e5).getOld(), null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void repeatedAnnotation() {
        SerializerFactory sf = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)new ThrowableAssert.ThrowingCallable(sf){
            final /* synthetic */ SerializerFactory $sf;

            public final void call() {
                @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000'\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0018\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"net/corda/serialization/internal/amqp/EnumEvolvabilityTests$repeatedAnnotation$C", "", "a", "Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$RepeatedAnnotation;", "(Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$RepeatedAnnotation;)V", "getA", "()Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$RepeatedAnnotation;", "component1", "copy", "(Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$RepeatedAnnotation;)Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$repeatedAnnotation$C;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
                public final class C {
                    @NotNull
                    private final RepeatedAnnotation a;

                    @NotNull
                    public final RepeatedAnnotation getA() {
                        return this.a;
                    }

                    public C(@NotNull RepeatedAnnotation a) {
                        Intrinsics.checkParameterIsNotNull((Object)((Object)a), (String)"a");
                        this.a = a;
                    }

                    @NotNull
                    public final RepeatedAnnotation component1() {
                        return this.a;
                    }

                    @NotNull
                    public final C copy(@NotNull RepeatedAnnotation a) {
                        Intrinsics.checkParameterIsNotNull((Object)((Object)a), (String)"a");
                        return new C(a);
                    }

                    @NotNull
                    public static /* bridge */ /* synthetic */ C copy$default(C c, RepeatedAnnotation repeatedAnnotation2, int n, Object object) {
                        if ((n & 1) != 0) {
                            repeatedAnnotation2 = c.a;
                        }
                        return c.copy(repeatedAnnotation2);
                    }

                    @NotNull
                    public String toString() {
                        return "C(a=" + (Object)((Object)this.a) + ")";
                    }

                    public int hashCode() {
                        RepeatedAnnotation repeatedAnnotation2 = this.a;
                        return repeatedAnnotation2 != null ? ((Object)((Object)repeatedAnnotation2)).hashCode() : 0;
                    }

                    public boolean equals(@Nullable Object object) {
                        block3: {
                            block2: {
                                if (this == object) break block2;
                                if (!(object instanceof C)) break block3;
                                C c = (C)object;
                                if (!Intrinsics.areEqual((Object)((Object)this.a), (Object)((Object)c.a))) break block3;
                            }
                            return true;
                        }
                        return false;
                    }
                }
                AMQPTestUtilsKt.serializeAndReturnSchema$default(new TestSerializationOutput(false, this.$sf), new C(RepeatedAnnotation.A), null, 2, null);
            }
            {
                this.$sf = serializerFactory;
            }
        }).isInstanceOf(NotSerializableException.class);
    }

    @Test(timeout=300000L)
    public final void multiEnums() {
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0002\u0000\u0003\b\u008a\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J,\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0014J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0013\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"net/corda/serialization/internal/amqp/EnumEvolvabilityTests$multiEnums$C", "", "a", "net/corda/serialization/internal/amqp/EnumEvolvabilityTests$multiEnums$B", "b", "Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$E2;", "c", "Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$E3;", "(Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$multiEnums$B;Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$E2;Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$E3;)V", "getA", "()Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$multiEnums$B;", "Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$multiEnums$B;", "getB", "()Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$E2;", "getC", "()Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$E3;", "component1", "component2", "component3", "copy", "(Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$multiEnums$B;Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$E2;Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$E3;)Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$multiEnums$C;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
        public final class C {
            @NotNull
            private final B a;
            @NotNull
            private final E2 b;
            @NotNull
            private final E3 c;

            @NotNull
            public final B getA() {
                @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0002\u0000\u0005\b\u008a\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u000e\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J,\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0014J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"net/corda/serialization/internal/amqp/EnumEvolvabilityTests$multiEnums$B", "", "a", "Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$E3;", "b", "net/corda/serialization/internal/amqp/EnumEvolvabilityTests$multiEnums$A", "c", "Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$E1;", "(Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$E3;Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$multiEnums$A;Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$E1;)V", "getA", "()Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$E3;", "getB", "()Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$multiEnums$A;", "Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$multiEnums$A;", "getC", "()Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$E1;", "component1", "component2", "component3", "copy", "(Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$E3;Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$multiEnums$A;Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$E1;)Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$multiEnums$B;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
                public final class B {
                    @NotNull
                    private final E3 a;
                    @NotNull
                    private final A b;
                    @NotNull
                    private final E1 c;

                    @NotNull
                    public final E3 getA() {
                        return this.a;
                    }

                    @NotNull
                    public final A getB() {
                        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000-\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\"\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000eJ\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"net/corda/serialization/internal/amqp/EnumEvolvabilityTests$multiEnums$A", "", "a", "Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$E1;", "b", "Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$E2;", "(Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$E1;Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$E2;)V", "getA", "()Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$E1;", "getB", "()Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$E2;", "component1", "component2", "copy", "(Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$E1;Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$E2;)Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$multiEnums$A;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
                        public final class A {
                            @NotNull
                            private final E1 a;
                            @NotNull
                            private final E2 b;

                            @NotNull
                            public final E1 getA() {
                                return this.a;
                            }

                            @NotNull
                            public final E2 getB() {
                                return this.b;
                            }

                            public A(@NotNull E1 a, @NotNull E2 b) {
                                Intrinsics.checkParameterIsNotNull((Object)((Object)a), (String)"a");
                                Intrinsics.checkParameterIsNotNull((Object)((Object)b), (String)"b");
                                this.a = a;
                                this.b = b;
                            }

                            @NotNull
                            public final E1 component1() {
                                return this.a;
                            }

                            @NotNull
                            public final E2 component2() {
                                return this.b;
                            }

                            @NotNull
                            public final A copy(@NotNull E1 a, @NotNull E2 b) {
                                Intrinsics.checkParameterIsNotNull((Object)((Object)a), (String)"a");
                                Intrinsics.checkParameterIsNotNull((Object)((Object)b), (String)"b");
                                return new A(a, b);
                            }

                            @NotNull
                            public static /* bridge */ /* synthetic */ A copy$default(A a, E1 e1, E2 e2, int n, Object object) {
                                if ((n & 1) != 0) {
                                    e1 = a.a;
                                }
                                if ((n & 2) != 0) {
                                    e2 = a.b;
                                }
                                return a.copy(e1, e2);
                            }

                            @NotNull
                            public String toString() {
                                return "A(a=" + (Object)((Object)this.a) + ", b=" + (Object)((Object)this.b) + ")";
                            }

                            public int hashCode() {
                                E1 e1 = this.a;
                                E2 e2 = this.b;
                                return (e1 != null ? ((Object)((Object)e1)).hashCode() : 0) * 31 + (e2 != null ? ((Object)((Object)e2)).hashCode() : 0);
                            }

                            public boolean equals(@Nullable Object object) {
                                block3: {
                                    block2: {
                                        if (this == object) break block2;
                                        if (!(object instanceof A)) break block3;
                                        A a = (A)object;
                                        if (!Intrinsics.areEqual((Object)((Object)this.a), (Object)((Object)a.a)) || !Intrinsics.areEqual((Object)((Object)this.b), (Object)((Object)a.b))) break block3;
                                    }
                                    return true;
                                }
                                return false;
                            }
                        }
                        return this.b;
                    }

                    @NotNull
                    public final E1 getC() {
                        return this.c;
                    }

                    public B(@NotNull E3 a, @NotNull A b, @NotNull E1 c) {
                        Intrinsics.checkParameterIsNotNull((Object)((Object)a), (String)"a");
                        Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
                        Intrinsics.checkParameterIsNotNull((Object)((Object)c), (String)"c");
                        this.a = a;
                        this.b = b;
                        this.c = c;
                    }

                    @NotNull
                    public final E3 component1() {
                        return this.a;
                    }

                    @NotNull
                    public final A component2() {
                        return this.b;
                    }

                    @NotNull
                    public final E1 component3() {
                        return this.c;
                    }

                    @NotNull
                    public final B copy(@NotNull E3 a, @NotNull A b, @NotNull E1 c) {
                        Intrinsics.checkParameterIsNotNull((Object)((Object)a), (String)"a");
                        Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
                        Intrinsics.checkParameterIsNotNull((Object)((Object)c), (String)"c");
                        return new B(a, b, c);
                    }

                    @NotNull
                    public static /* bridge */ /* synthetic */ B copy$default(B b, E3 e3, A a, E1 e1, int n, Object object) {
                        if ((n & 1) != 0) {
                            e3 = b.a;
                        }
                        if ((n & 2) != 0) {
                            a = b.b;
                        }
                        if ((n & 4) != 0) {
                            e1 = b.c;
                        }
                        return b.copy(e3, a, e1);
                    }

                    @NotNull
                    public String toString() {
                        return "B(a=" + (Object)((Object)this.a) + ", b=" + this.b + ", c=" + (Object)((Object)this.c) + ")";
                    }

                    public int hashCode() {
                        E3 e3 = this.a;
                        A a = this.b;
                        E1 e1 = this.c;
                        return ((e3 != null ? ((Object)((Object)e3)).hashCode() : 0) * 31 + (a != null ? ((Object)a).hashCode() : 0)) * 31 + (e1 != null ? ((Object)((Object)e1)).hashCode() : 0);
                    }

                    public boolean equals(@Nullable Object object) {
                        block3: {
                            block2: {
                                if (this == object) break block2;
                                if (!(object instanceof B)) break block3;
                                B b = (B)object;
                                if (!Intrinsics.areEqual((Object)((Object)this.a), (Object)((Object)b.a)) || !Intrinsics.areEqual((Object)this.b, (Object)b.b) || !Intrinsics.areEqual((Object)((Object)this.c), (Object)((Object)b.c))) break block3;
                            }
                            return true;
                        }
                        return false;
                    }
                }
                return this.a;
            }

            @NotNull
            public final E2 getB() {
                return this.b;
            }

            @NotNull
            public final E3 getC() {
                return this.c;
            }

            public C(@NotNull B a, @NotNull E2 b, @NotNull E3 c) {
                Intrinsics.checkParameterIsNotNull((Object)a, (String)"a");
                Intrinsics.checkParameterIsNotNull((Object)((Object)b), (String)"b");
                Intrinsics.checkParameterIsNotNull((Object)((Object)c), (String)"c");
                this.a = a;
                this.b = b;
                this.c = c;
            }

            @NotNull
            public final B component1() {
                return this.a;
            }

            @NotNull
            public final E2 component2() {
                return this.b;
            }

            @NotNull
            public final E3 component3() {
                return this.c;
            }

            @NotNull
            public final C copy(@NotNull B a, @NotNull E2 b, @NotNull E3 c) {
                Intrinsics.checkParameterIsNotNull((Object)a, (String)"a");
                Intrinsics.checkParameterIsNotNull((Object)((Object)b), (String)"b");
                Intrinsics.checkParameterIsNotNull((Object)((Object)c), (String)"c");
                return new C(a, b, c);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ C copy$default(C c, B b, E2 e2, E3 e3, int n, Object object) {
                if ((n & 1) != 0) {
                    b = c.a;
                }
                if ((n & 2) != 0) {
                    e2 = c.b;
                }
                if ((n & 4) != 0) {
                    e3 = c.c;
                }
                return c.copy(b, e2, e3);
            }

            @NotNull
            public String toString() {
                return "C(a=" + this.a + ", b=" + (Object)((Object)this.b) + ", c=" + (Object)((Object)this.c) + ")";
            }

            public int hashCode() {
                B b = this.a;
                E2 e2 = this.b;
                E3 e3 = this.c;
                return ((b != null ? ((Object)b).hashCode() : 0) * 31 + (e2 != null ? ((Object)((Object)e2)).hashCode() : 0)) * 31 + (e3 != null ? ((Object)((Object)e3)).hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof C)) break block3;
                        C c = (C)object;
                        if (!Intrinsics.areEqual((Object)this.a, (Object)c.a) || !Intrinsics.areEqual((Object)((Object)this.b), (Object)((Object)c.b)) || !Intrinsics.areEqual((Object)((Object)this.c), (Object)((Object)c.c))) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        C c = new C(new B(E3.A, new A(E1.A, E2.B), E1.C), E2.B, E3.A);
        SerializerFactory sf = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        BytesAndSchemas bAndS = AMQPTestUtilsKt.serializeAndReturnSchema$default(new TestSerializationOutput(false, sf), c, null, 2, null);
        Object object = bAndS.getTransformsSchema();
        System.out.println(object);
        AssertionsKt.assertEquals$default((Object)6, (Object)bAndS.getSchema().getTypes().size(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)3, (Object)bAndS.getTransformsSchema().getTypes().size(), null, (int)4, null);
        object = bAndS.getTransformsSchema().getTypes();
        String string = E1.class.getName();
        Object object2 = object;
        AssertionsKt.assertTrue$default((boolean)object2.containsKey(string), null, (int)2, null);
        object = bAndS.getTransformsSchema().getTypes();
        string = E2.class.getName();
        object2 = object;
        AssertionsKt.assertTrue$default((boolean)object2.containsKey(string), null, (int)2, null);
        object = bAndS.getTransformsSchema().getTypes();
        string = E3.class.getName();
        object2 = object;
        AssertionsKt.assertTrue$default((boolean)object2.containsKey(string), null, (int)2, null);
        Object v = bAndS.getTransformsSchema().getTypes().get(E1.class.getName());
        if (v == null) {
            Intrinsics.throwNpe();
        }
        EnumMap e1S = (EnumMap)v;
        Object v2 = bAndS.getTransformsSchema().getTypes().get(E2.class.getName());
        if (v2 == null) {
            Intrinsics.throwNpe();
        }
        EnumMap e2S = (EnumMap)v2;
        Object v3 = bAndS.getTransformsSchema().getTypes().get(E3.class.getName());
        if (v3 == null) {
            Intrinsics.throwNpe();
        }
        EnumMap e3S = (EnumMap)v3;
        AssertionsKt.assertEquals$default((Object)1, (Object)e1S.size(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)1, (Object)e2S.size(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)1, (Object)e3S.size(), null, (int)4, null);
        Map map = e1S;
        TransformTypes transformTypes = TransformTypes.EnumDefault;
        Map map2 = map;
        AssertionsKt.assertTrue$default((boolean)map2.containsKey(transformTypes), null, (int)2, null);
        map = e2S;
        transformTypes = TransformTypes.EnumDefault;
        map2 = map;
        AssertionsKt.assertTrue$default((boolean)map2.containsKey(transformTypes), null, (int)2, null);
        map = e3S;
        transformTypes = TransformTypes.EnumDefault;
        map2 = map;
        AssertionsKt.assertTrue$default((boolean)map2.containsKey(transformTypes), null, (int)2, null);
        Integer n = 1;
        Object v4 = e1S.get(TransformTypes.EnumDefault);
        if (v4 == null) {
            Intrinsics.throwNpe();
        }
        AssertionsKt.assertEquals$default((Object)n, (Object)((List)v4).size(), null, (int)4, null);
        Integer n2 = 2;
        Object v5 = e2S.get(TransformTypes.EnumDefault);
        if (v5 == null) {
            Intrinsics.throwNpe();
        }
        AssertionsKt.assertEquals$default((Object)n2, (Object)((List)v5).size(), null, (int)4, null);
        Integer n3 = 1;
        Object v6 = e3S.get(TransformTypes.EnumDefault);
        if (v6 == null) {
            Intrinsics.throwNpe();
        }
        AssertionsKt.assertEquals$default((Object)n3, (Object)((List)v6).size(), null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void testCache() {
        SerializerFactory sf = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000'\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0018\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"net/corda/serialization/internal/amqp/EnumEvolvabilityTests$testCache$C1", "", "annotatedEnum", "Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$AnnotatedEnumOnce;", "(Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$AnnotatedEnumOnce;)V", "getAnnotatedEnum", "()Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$AnnotatedEnumOnce;", "component1", "copy", "(Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$AnnotatedEnumOnce;)Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$testCache$C1;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
        public final class C1 {
            @NotNull
            private final AnnotatedEnumOnce annotatedEnum;

            @NotNull
            public final AnnotatedEnumOnce getAnnotatedEnum() {
                return this.annotatedEnum;
            }

            public C1(@NotNull AnnotatedEnumOnce annotatedEnum) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)annotatedEnum), (String)"annotatedEnum");
                this.annotatedEnum = annotatedEnum;
            }

            @NotNull
            public final AnnotatedEnumOnce component1() {
                return this.annotatedEnum;
            }

            @NotNull
            public final C1 copy(@NotNull AnnotatedEnumOnce annotatedEnum) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)annotatedEnum), (String)"annotatedEnum");
                return new C1(annotatedEnum);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ C1 copy$default(C1 c1, AnnotatedEnumOnce annotatedEnumOnce, int n, Object object) {
                if ((n & 1) != 0) {
                    annotatedEnumOnce = c1.annotatedEnum;
                }
                return c1.copy(annotatedEnumOnce);
            }

            @NotNull
            public String toString() {
                return "C1(annotatedEnum=" + (Object)((Object)this.annotatedEnum) + ")";
            }

            public int hashCode() {
                AnnotatedEnumOnce annotatedEnumOnce = this.annotatedEnum;
                return annotatedEnumOnce != null ? ((Object)((Object)annotatedEnumOnce)).hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof C1)) break block3;
                        C1 c1 = (C1)object;
                        if (!Intrinsics.areEqual((Object)((Object)this.annotatedEnum), (Object)((Object)c1.annotatedEnum))) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        BytesAndSchemas sb1 = AMQPTestUtilsKt.serializeAndReturnSchema$default(new TestSerializationOutput(false, sf), new C1(AnnotatedEnumOnce.D), null, 2, null);
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000'\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0018\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"net/corda/serialization/internal/amqp/EnumEvolvabilityTests$testCache$C2", "", "annotatedEnum", "Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$AnnotatedEnumOnce;", "(Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$AnnotatedEnumOnce;)V", "getAnnotatedEnum", "()Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$AnnotatedEnumOnce;", "component1", "copy", "(Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$AnnotatedEnumOnce;)Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$testCache$C2;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
        public final class C2 {
            @NotNull
            private final AnnotatedEnumOnce annotatedEnum;

            @NotNull
            public final AnnotatedEnumOnce getAnnotatedEnum() {
                return this.annotatedEnum;
            }

            public C2(@NotNull AnnotatedEnumOnce annotatedEnum) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)annotatedEnum), (String)"annotatedEnum");
                this.annotatedEnum = annotatedEnum;
            }

            @NotNull
            public final AnnotatedEnumOnce component1() {
                return this.annotatedEnum;
            }

            @NotNull
            public final C2 copy(@NotNull AnnotatedEnumOnce annotatedEnum) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)annotatedEnum), (String)"annotatedEnum");
                return new C2(annotatedEnum);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ C2 copy$default(C2 c2, AnnotatedEnumOnce annotatedEnumOnce, int n, Object object) {
                if ((n & 1) != 0) {
                    annotatedEnumOnce = c2.annotatedEnum;
                }
                return c2.copy(annotatedEnumOnce);
            }

            @NotNull
            public String toString() {
                return "C2(annotatedEnum=" + (Object)((Object)this.annotatedEnum) + ")";
            }

            public int hashCode() {
                AnnotatedEnumOnce annotatedEnumOnce = this.annotatedEnum;
                return annotatedEnumOnce != null ? ((Object)((Object)annotatedEnumOnce)).hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof C2)) break block3;
                        C2 c2 = (C2)object;
                        if (!Intrinsics.areEqual((Object)((Object)this.annotatedEnum), (Object)((Object)c2.annotatedEnum))) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        BytesAndSchemas sb2 = AMQPTestUtilsKt.serializeAndReturnSchema$default(new TestSerializationOutput(false, sf), new C2(AnnotatedEnumOnce.D), null, 2, null);
        AssertionsKt.assertEquals$default(sb1.getTransformsSchema().getTypes().get(AnnotatedEnumOnce.class.getName()), sb2.getTransformsSchema().getTypes().get(AnnotatedEnumOnce.class.getName()), null, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void testUnknownTransform() {
        void $receiver$iv;
        String resource = "EnumEvolvabilityTests.testUnknownTransform";
        SerializerFactory sf = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        URL uRL = EvolvabilityTests.class.getResource(resource);
        Intrinsics.checkExpressionValueIsNotNull((Object)uRL, (String)"EvolvabilityTests::class\u2026ava.getResource(resource)");
        byte[] sb1 = TextStreamsKt.readBytes((URL)uRL);
        DeserializationInput deserializationInput = new DeserializationInput(sf);
        SerializedBytes bytes$iv = new SerializedBytes(sb1);
        SerializationContext context$iv = null;
        Envelope envelope = $receiver$iv.deserializeAndReturnEnvelope(bytes$iv, WrapsUnknown.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext()).getEnvelope();
        AssertionsKt.assertTrue$default((boolean)envelope.getTransformsSchema().getTypes().containsKey(WithUnknownTest.class.getName()), null, (int)2, null);
        Object v = envelope.getTransformsSchema().getTypes().get(WithUnknownTest.class.getName());
        if (v == null) {
            Intrinsics.throwNpe();
        }
        AssertionsKt.assertTrue$default((boolean)((EnumMap)v).containsKey(TransformTypes.Unknown), null, (int)2, null);
    }

    @Test(timeout=300000L)
    public final void acceptMultipleRename() {
        SerializerFactory sf = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000'\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0018\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"net/corda/serialization/internal/amqp/EnumEvolvabilityTests$acceptMultipleRename$C", "", "e", "Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$AcceptMultipleRename;", "(Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$AcceptMultipleRename;)V", "getE", "()Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$AcceptMultipleRename;", "component1", "copy", "(Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$AcceptMultipleRename;)Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$acceptMultipleRename$C;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
        public final class C {
            @NotNull
            private final AcceptMultipleRename e;

            @NotNull
            public final AcceptMultipleRename getE() {
                return this.e;
            }

            public C(@NotNull AcceptMultipleRename e2) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)e2), (String)"e");
                this.e = e2;
            }

            @NotNull
            public final AcceptMultipleRename component1() {
                return this.e;
            }

            @NotNull
            public final C copy(@NotNull AcceptMultipleRename e2) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)e2), (String)"e");
                return new C(e2);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ C copy$default(C c, AcceptMultipleRename acceptMultipleRename2, int n, Object object) {
                if ((n & 1) != 0) {
                    acceptMultipleRename2 = c.e;
                }
                return c.copy(acceptMultipleRename2);
            }

            @NotNull
            public String toString() {
                return "C(e=" + (Object)((Object)this.e) + ")";
            }

            public int hashCode() {
                AcceptMultipleRename acceptMultipleRename2 = this.e;
                return acceptMultipleRename2 != null ? ((Object)((Object)acceptMultipleRename2)).hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof C)) break block3;
                        C c = (C)object;
                        if (!Intrinsics.areEqual((Object)((Object)this.e), (Object)((Object)c.e))) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        AMQPTestUtilsKt.serialize$default(new SerializationOutput((LocalSerializerFactory)sf), new C(AcceptMultipleRename.C), null, 2, null);
    }

    @Test(timeout=300000L)
    public final void rejectMultipleRenameTo() {
        SerializerFactory sf = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)new ThrowableAssert.ThrowingCallable(sf){
            final /* synthetic */ SerializerFactory $sf;

            public final void call() {
                @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000'\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0018\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"net/corda/serialization/internal/amqp/EnumEvolvabilityTests$rejectMultipleRenameTo$C", "", "e", "Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$RejectMultipleRenameTo;", "(Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$RejectMultipleRenameTo;)V", "getE", "()Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$RejectMultipleRenameTo;", "component1", "copy", "(Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$RejectMultipleRenameTo;)Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$rejectMultipleRenameTo$C;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
                public final class C {
                    @NotNull
                    private final RejectMultipleRenameTo e;

                    @NotNull
                    public final RejectMultipleRenameTo getE() {
                        return this.e;
                    }

                    public C(@NotNull RejectMultipleRenameTo e2) {
                        Intrinsics.checkParameterIsNotNull((Object)((Object)e2), (String)"e");
                        this.e = e2;
                    }

                    @NotNull
                    public final RejectMultipleRenameTo component1() {
                        return this.e;
                    }

                    @NotNull
                    public final C copy(@NotNull RejectMultipleRenameTo e2) {
                        Intrinsics.checkParameterIsNotNull((Object)((Object)e2), (String)"e");
                        return new C(e2);
                    }

                    @NotNull
                    public static /* bridge */ /* synthetic */ C copy$default(C c, RejectMultipleRenameTo rejectMultipleRenameTo2, int n, Object object) {
                        if ((n & 1) != 0) {
                            rejectMultipleRenameTo2 = c.e;
                        }
                        return c.copy(rejectMultipleRenameTo2);
                    }

                    @NotNull
                    public String toString() {
                        return "C(e=" + (Object)((Object)this.e) + ")";
                    }

                    public int hashCode() {
                        RejectMultipleRenameTo rejectMultipleRenameTo2 = this.e;
                        return rejectMultipleRenameTo2 != null ? ((Object)((Object)rejectMultipleRenameTo2)).hashCode() : 0;
                    }

                    public boolean equals(@Nullable Object object) {
                        block3: {
                            block2: {
                                if (this == object) break block2;
                                if (!(object instanceof C)) break block3;
                                C c = (C)object;
                                if (!Intrinsics.areEqual((Object)((Object)this.e), (Object)((Object)c.e))) break block3;
                            }
                            return true;
                        }
                        return false;
                    }
                }
                AMQPTestUtilsKt.serialize$default(new SerializationOutput((LocalSerializerFactory)this.$sf), new C(RejectMultipleRenameTo.A), null, 2, null);
            }
            {
                this.$sf = serializerFactory;
            }
        }).isInstanceOfSatisfying(NotSerializableDetailedException.class, (Consumer)rejectMultipleRenameTo.2.INSTANCE);
    }

    @Test(timeout=300000L)
    public final void rejectMultipleRenameFrom() {
        SerializerFactory sf = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)new ThrowableAssert.ThrowingCallable(sf){
            final /* synthetic */ SerializerFactory $sf;

            public final void call() {
                @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000'\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0018\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"net/corda/serialization/internal/amqp/EnumEvolvabilityTests$rejectMultipleRenameFrom$C", "", "e", "Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$RejectMultipleRenameFrom;", "(Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$RejectMultipleRenameFrom;)V", "getE", "()Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$RejectMultipleRenameFrom;", "component1", "copy", "(Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$RejectMultipleRenameFrom;)Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$rejectMultipleRenameFrom$C;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
                public final class C {
                    @NotNull
                    private final RejectMultipleRenameFrom e;

                    @NotNull
                    public final RejectMultipleRenameFrom getE() {
                        return this.e;
                    }

                    public C(@NotNull RejectMultipleRenameFrom e2) {
                        Intrinsics.checkParameterIsNotNull((Object)((Object)e2), (String)"e");
                        this.e = e2;
                    }

                    @NotNull
                    public final RejectMultipleRenameFrom component1() {
                        return this.e;
                    }

                    @NotNull
                    public final C copy(@NotNull RejectMultipleRenameFrom e2) {
                        Intrinsics.checkParameterIsNotNull((Object)((Object)e2), (String)"e");
                        return new C(e2);
                    }

                    @NotNull
                    public static /* bridge */ /* synthetic */ C copy$default(C c, RejectMultipleRenameFrom rejectMultipleRenameFrom2, int n, Object object) {
                        if ((n & 1) != 0) {
                            rejectMultipleRenameFrom2 = c.e;
                        }
                        return c.copy(rejectMultipleRenameFrom2);
                    }

                    @NotNull
                    public String toString() {
                        return "C(e=" + (Object)((Object)this.e) + ")";
                    }

                    public int hashCode() {
                        RejectMultipleRenameFrom rejectMultipleRenameFrom2 = this.e;
                        return rejectMultipleRenameFrom2 != null ? ((Object)((Object)rejectMultipleRenameFrom2)).hashCode() : 0;
                    }

                    public boolean equals(@Nullable Object object) {
                        block3: {
                            block2: {
                                if (this == object) break block2;
                                if (!(object instanceof C)) break block3;
                                C c = (C)object;
                                if (!Intrinsics.areEqual((Object)((Object)this.e), (Object)((Object)c.e))) break block3;
                            }
                            return true;
                        }
                        return false;
                    }
                }
                AMQPTestUtilsKt.serialize$default(new SerializationOutput((LocalSerializerFactory)this.$sf), new C(RejectMultipleRenameFrom.A), null, 2, null);
            }
            {
                this.$sf = serializerFactory;
            }
        }).isInstanceOf(NotSerializableException.class)).hasToString("Unable to serialize/deserialize net.corda.serialization.internal.amqp.EnumEvolvabilityTests$RejectMultipleRenameFrom: There are multiple transformations from D, which is not allowed");
    }

    @Test(timeout=300000L)
    public final void rejectCyclicRename() {
        SerializerFactory sf = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)new ThrowableAssert.ThrowingCallable(sf){
            final /* synthetic */ SerializerFactory $sf;

            public final void call() {
                @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000'\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0018\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"net/corda/serialization/internal/amqp/EnumEvolvabilityTests$rejectCyclicRename$C", "", "e", "Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$RejectCyclicRename;", "(Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$RejectCyclicRename;)V", "getE", "()Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$RejectCyclicRename;", "component1", "copy", "(Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$RejectCyclicRename;)Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$rejectCyclicRename$C;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
                public final class C {
                    @NotNull
                    private final RejectCyclicRename e;

                    @NotNull
                    public final RejectCyclicRename getE() {
                        return this.e;
                    }

                    public C(@NotNull RejectCyclicRename e2) {
                        Intrinsics.checkParameterIsNotNull((Object)((Object)e2), (String)"e");
                        this.e = e2;
                    }

                    @NotNull
                    public final RejectCyclicRename component1() {
                        return this.e;
                    }

                    @NotNull
                    public final C copy(@NotNull RejectCyclicRename e2) {
                        Intrinsics.checkParameterIsNotNull((Object)((Object)e2), (String)"e");
                        return new C(e2);
                    }

                    @NotNull
                    public static /* bridge */ /* synthetic */ C copy$default(C c, RejectCyclicRename rejectCyclicRename2, int n, Object object) {
                        if ((n & 1) != 0) {
                            rejectCyclicRename2 = c.e;
                        }
                        return c.copy(rejectCyclicRename2);
                    }

                    @NotNull
                    public String toString() {
                        return "C(e=" + (Object)((Object)this.e) + ")";
                    }

                    public int hashCode() {
                        RejectCyclicRename rejectCyclicRename2 = this.e;
                        return rejectCyclicRename2 != null ? ((Object)((Object)rejectCyclicRename2)).hashCode() : 0;
                    }

                    public boolean equals(@Nullable Object object) {
                        block3: {
                            block2: {
                                if (this == object) break block2;
                                if (!(object instanceof C)) break block3;
                                C c = (C)object;
                                if (!Intrinsics.areEqual((Object)((Object)this.e), (Object)((Object)c.e))) break block3;
                            }
                            return true;
                        }
                        return false;
                    }
                }
                AMQPTestUtilsKt.serialize$default(new SerializationOutput((LocalSerializerFactory)this.$sf), new C(RejectCyclicRename.A), null, 2, null);
            }
            {
                this.$sf = serializerFactory;
            }
        }).isInstanceOf(NotSerializableException.class);
    }

    @Test(timeout=300000L)
    public final void rejectCyclicRenameRedux() {
        SerializerFactory sf = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)new ThrowableAssert.ThrowingCallable(sf){
            final /* synthetic */ SerializerFactory $sf;

            public final void call() {
                @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000'\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0018\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"net/corda/serialization/internal/amqp/EnumEvolvabilityTests$rejectCyclicRenameRedux$C", "", "e", "Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$RejectCyclicRenameRedux;", "(Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$RejectCyclicRenameRedux;)V", "getE", "()Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$RejectCyclicRenameRedux;", "component1", "copy", "(Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$RejectCyclicRenameRedux;)Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$rejectCyclicRenameRedux$C;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
                public final class C {
                    @NotNull
                    private final RejectCyclicRenameRedux e;

                    @NotNull
                    public final RejectCyclicRenameRedux getE() {
                        return this.e;
                    }

                    public C(@NotNull RejectCyclicRenameRedux e2) {
                        Intrinsics.checkParameterIsNotNull((Object)((Object)e2), (String)"e");
                        this.e = e2;
                    }

                    @NotNull
                    public final RejectCyclicRenameRedux component1() {
                        return this.e;
                    }

                    @NotNull
                    public final C copy(@NotNull RejectCyclicRenameRedux e2) {
                        Intrinsics.checkParameterIsNotNull((Object)((Object)e2), (String)"e");
                        return new C(e2);
                    }

                    @NotNull
                    public static /* bridge */ /* synthetic */ C copy$default(C c, RejectCyclicRenameRedux rejectCyclicRenameRedux2, int n, Object object) {
                        if ((n & 1) != 0) {
                            rejectCyclicRenameRedux2 = c.e;
                        }
                        return c.copy(rejectCyclicRenameRedux2);
                    }

                    @NotNull
                    public String toString() {
                        return "C(e=" + (Object)((Object)this.e) + ")";
                    }

                    public int hashCode() {
                        RejectCyclicRenameRedux rejectCyclicRenameRedux2 = this.e;
                        return rejectCyclicRenameRedux2 != null ? ((Object)((Object)rejectCyclicRenameRedux2)).hashCode() : 0;
                    }

                    public boolean equals(@Nullable Object object) {
                        block3: {
                            block2: {
                                if (this == object) break block2;
                                if (!(object instanceof C)) break block3;
                                C c = (C)object;
                                if (!Intrinsics.areEqual((Object)((Object)this.e), (Object)((Object)c.e))) break block3;
                            }
                            return true;
                        }
                        return false;
                    }
                }
                AMQPTestUtilsKt.serialize$default(new SerializationOutput((LocalSerializerFactory)this.$sf), new C(RejectCyclicRenameRedux.A), null, 2, null);
            }
            {
                this.$sf = serializerFactory;
            }
        }).isInstanceOf(NotSerializableException.class);
    }

    @Test(timeout=300000L)
    public final void rejectBadDefault() {
        SerializerFactory sf = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)new ThrowableAssert.ThrowingCallable(sf){
            final /* synthetic */ SerializerFactory $sf;

            public final void call() {
                @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000'\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0018\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"net/corda/serialization/internal/amqp/EnumEvolvabilityTests$rejectBadDefault$C", "", "e", "Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$RejectBadDefault;", "(Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$RejectBadDefault;)V", "getE", "()Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$RejectBadDefault;", "component1", "copy", "(Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$RejectBadDefault;)Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$rejectBadDefault$C;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
                public final class C {
                    @NotNull
                    private final RejectBadDefault e;

                    @NotNull
                    public final RejectBadDefault getE() {
                        return this.e;
                    }

                    public C(@NotNull RejectBadDefault e2) {
                        Intrinsics.checkParameterIsNotNull((Object)((Object)e2), (String)"e");
                        this.e = e2;
                    }

                    @NotNull
                    public final RejectBadDefault component1() {
                        return this.e;
                    }

                    @NotNull
                    public final C copy(@NotNull RejectBadDefault e2) {
                        Intrinsics.checkParameterIsNotNull((Object)((Object)e2), (String)"e");
                        return new C(e2);
                    }

                    @NotNull
                    public static /* bridge */ /* synthetic */ C copy$default(C c, RejectBadDefault rejectBadDefault2, int n, Object object) {
                        if ((n & 1) != 0) {
                            rejectBadDefault2 = c.e;
                        }
                        return c.copy(rejectBadDefault2);
                    }

                    @NotNull
                    public String toString() {
                        return "C(e=" + (Object)((Object)this.e) + ")";
                    }

                    public int hashCode() {
                        RejectBadDefault rejectBadDefault2 = this.e;
                        return rejectBadDefault2 != null ? ((Object)((Object)rejectBadDefault2)).hashCode() : 0;
                    }

                    public boolean equals(@Nullable Object object) {
                        block3: {
                            block2: {
                                if (this == object) break block2;
                                if (!(object instanceof C)) break block3;
                                C c = (C)object;
                                if (!Intrinsics.areEqual((Object)((Object)this.e), (Object)((Object)c.e))) break block3;
                            }
                            return true;
                        }
                        return false;
                    }
                }
                AMQPTestUtilsKt.serialize$default(new SerializationOutput((LocalSerializerFactory)this.$sf), new C(RejectBadDefault.D), null, 2, null);
            }
            {
                this.$sf = serializerFactory;
            }
        }).isInstanceOf(NotSerializableException.class);
    }

    @Test(timeout=300000L)
    public final void rejectBadDefaultToSelf() {
        SerializerFactory sf = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)new ThrowableAssert.ThrowingCallable(sf){
            final /* synthetic */ SerializerFactory $sf;

            public final void call() {
                @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000'\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0018\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"net/corda/serialization/internal/amqp/EnumEvolvabilityTests$rejectBadDefaultToSelf$C", "", "e", "Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$RejectBadDefaultToSelf;", "(Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$RejectBadDefaultToSelf;)V", "getE", "()Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$RejectBadDefaultToSelf;", "component1", "copy", "(Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$RejectBadDefaultToSelf;)Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$rejectBadDefaultToSelf$C;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
                public final class C {
                    @NotNull
                    private final RejectBadDefaultToSelf e;

                    @NotNull
                    public final RejectBadDefaultToSelf getE() {
                        return this.e;
                    }

                    public C(@NotNull RejectBadDefaultToSelf e2) {
                        Intrinsics.checkParameterIsNotNull((Object)((Object)e2), (String)"e");
                        this.e = e2;
                    }

                    @NotNull
                    public final RejectBadDefaultToSelf component1() {
                        return this.e;
                    }

                    @NotNull
                    public final C copy(@NotNull RejectBadDefaultToSelf e2) {
                        Intrinsics.checkParameterIsNotNull((Object)((Object)e2), (String)"e");
                        return new C(e2);
                    }

                    @NotNull
                    public static /* bridge */ /* synthetic */ C copy$default(C c, RejectBadDefaultToSelf rejectBadDefaultToSelf2, int n, Object object) {
                        if ((n & 1) != 0) {
                            rejectBadDefaultToSelf2 = c.e;
                        }
                        return c.copy(rejectBadDefaultToSelf2);
                    }

                    @NotNull
                    public String toString() {
                        return "C(e=" + (Object)((Object)this.e) + ")";
                    }

                    public int hashCode() {
                        RejectBadDefaultToSelf rejectBadDefaultToSelf2 = this.e;
                        return rejectBadDefaultToSelf2 != null ? ((Object)((Object)rejectBadDefaultToSelf2)).hashCode() : 0;
                    }

                    public boolean equals(@Nullable Object object) {
                        block3: {
                            block2: {
                                if (this == object) break block2;
                                if (!(object instanceof C)) break block3;
                                C c = (C)object;
                                if (!Intrinsics.areEqual((Object)((Object)this.e), (Object)((Object)c.e))) break block3;
                            }
                            return true;
                        }
                        return false;
                    }
                }
                AMQPTestUtilsKt.serialize$default(new SerializationOutput((LocalSerializerFactory)this.$sf), new C(RejectBadDefaultToSelf.D), null, 2, null);
            }
            {
                this.$sf = serializerFactory;
            }
        }).isInstanceOf(NotSerializableException.class);
    }

    public EnumEvolvabilityTests() {
        URI uRI = ProjectStructure.INSTANCE.getProjectRootDir().toUri().resolve("serialization-tests/src/test/resources/net/corda/serialization/internal/amqp");
        Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"projectRootDir.toUri().r\u2026alization/internal/amqp\")");
        this.localPath = uRI;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$NotAnnotated;", "", "(Ljava/lang/String;I)V", "A", "B", "C", "D", "serialization"})
    public static final class NotAnnotated
    extends Enum<NotAnnotated> {
        public static final /* enum */ NotAnnotated A;
        public static final /* enum */ NotAnnotated B;
        public static final /* enum */ NotAnnotated C;
        public static final /* enum */ NotAnnotated D;
        private static final /* synthetic */ NotAnnotated[] $VALUES;

        static {
            NotAnnotated[] notAnnotatedArray = new NotAnnotated[4];
            NotAnnotated[] notAnnotatedArray2 = notAnnotatedArray;
            notAnnotatedArray[0] = A = new NotAnnotated();
            notAnnotatedArray[1] = B = new NotAnnotated();
            notAnnotatedArray[2] = C = new NotAnnotated();
            notAnnotatedArray[3] = D = new NotAnnotated();
            $VALUES = notAnnotatedArray;
        }

        public static NotAnnotated[] values() {
            return (NotAnnotated[])$VALUES.clone();
        }

        public static NotAnnotated valueOf(String string) {
            return Enum.valueOf(NotAnnotated.class, string);
        }
    }

    @CordaSerializationTransformRenames(value={})
    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0087\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$MissingRenames;", "", "(Ljava/lang/String;I)V", "A", "B", "C", "D", "serialization"})
    public static final class MissingRenames
    extends Enum<MissingRenames> {
        public static final /* enum */ MissingRenames A;
        public static final /* enum */ MissingRenames B;
        public static final /* enum */ MissingRenames C;
        public static final /* enum */ MissingRenames D;
        private static final /* synthetic */ MissingRenames[] $VALUES;

        static {
            MissingRenames[] missingRenamesArray = new MissingRenames[4];
            MissingRenames[] missingRenamesArray2 = missingRenamesArray;
            missingRenamesArray[0] = A = new MissingRenames();
            missingRenamesArray[1] = B = new MissingRenames();
            missingRenamesArray[2] = C = new MissingRenames();
            missingRenamesArray[3] = D = new MissingRenames();
            $VALUES = missingRenamesArray;
        }

        public static MissingRenames[] values() {
            return (MissingRenames[])$VALUES.clone();
        }

        public static MissingRenames valueOf(String string) {
            return Enum.valueOf(MissingRenames.class, string);
        }
    }

    @CordaSerializationTransformEnumDefault(new="D", old="A")
    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0087\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$AnnotatedEnumOnce;", "", "(Ljava/lang/String;I)V", "A", "B", "C", "D", "serialization"})
    public static final class AnnotatedEnumOnce
    extends Enum<AnnotatedEnumOnce> {
        public static final /* enum */ AnnotatedEnumOnce A;
        public static final /* enum */ AnnotatedEnumOnce B;
        public static final /* enum */ AnnotatedEnumOnce C;
        public static final /* enum */ AnnotatedEnumOnce D;
        private static final /* synthetic */ AnnotatedEnumOnce[] $VALUES;

        static {
            AnnotatedEnumOnce[] annotatedEnumOnceArray = new AnnotatedEnumOnce[4];
            AnnotatedEnumOnce[] annotatedEnumOnceArray2 = annotatedEnumOnceArray;
            annotatedEnumOnceArray[0] = A = new AnnotatedEnumOnce();
            annotatedEnumOnceArray[1] = B = new AnnotatedEnumOnce();
            annotatedEnumOnceArray[2] = C = new AnnotatedEnumOnce();
            annotatedEnumOnceArray[3] = D = new AnnotatedEnumOnce();
            $VALUES = annotatedEnumOnceArray;
        }

        public static AnnotatedEnumOnce[] values() {
            return (AnnotatedEnumOnce[])$VALUES.clone();
        }

        public static AnnotatedEnumOnce valueOf(String string) {
            return Enum.valueOf(AnnotatedEnumOnce.class, string);
        }
    }

    @CordaSerializationTransformEnumDefaults(value={@CordaSerializationTransformEnumDefault(new="E", old="D"), @CordaSerializationTransformEnumDefault(new="D", old="A")})
    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0087\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$AnnotatedEnumTwice;", "", "(Ljava/lang/String;I)V", "A", "B", "C", "D", "E", "serialization"})
    public static final class AnnotatedEnumTwice
    extends Enum<AnnotatedEnumTwice> {
        public static final /* enum */ AnnotatedEnumTwice A;
        public static final /* enum */ AnnotatedEnumTwice B;
        public static final /* enum */ AnnotatedEnumTwice C;
        public static final /* enum */ AnnotatedEnumTwice D;
        public static final /* enum */ AnnotatedEnumTwice E;
        private static final /* synthetic */ AnnotatedEnumTwice[] $VALUES;

        static {
            AnnotatedEnumTwice[] annotatedEnumTwiceArray = new AnnotatedEnumTwice[5];
            AnnotatedEnumTwice[] annotatedEnumTwiceArray2 = annotatedEnumTwiceArray;
            annotatedEnumTwiceArray[0] = A = new AnnotatedEnumTwice();
            annotatedEnumTwiceArray[1] = B = new AnnotatedEnumTwice();
            annotatedEnumTwiceArray[2] = C = new AnnotatedEnumTwice();
            annotatedEnumTwiceArray[3] = D = new AnnotatedEnumTwice();
            annotatedEnumTwiceArray[4] = E = new AnnotatedEnumTwice();
            $VALUES = annotatedEnumTwiceArray;
        }

        public static AnnotatedEnumTwice[] values() {
            return (AnnotatedEnumTwice[])$VALUES.clone();
        }

        public static AnnotatedEnumTwice valueOf(String string) {
            return Enum.valueOf(AnnotatedEnumTwice.class, string);
        }
    }

    @CordaSerializationTransformRename(to="E", from="D")
    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0087\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$RenameEnumOnce;", "", "(Ljava/lang/String;I)V", "A", "B", "C", "E", "serialization"})
    public static final class RenameEnumOnce
    extends Enum<RenameEnumOnce> {
        public static final /* enum */ RenameEnumOnce A;
        public static final /* enum */ RenameEnumOnce B;
        public static final /* enum */ RenameEnumOnce C;
        public static final /* enum */ RenameEnumOnce E;
        private static final /* synthetic */ RenameEnumOnce[] $VALUES;

        static {
            RenameEnumOnce[] renameEnumOnceArray = new RenameEnumOnce[4];
            RenameEnumOnce[] renameEnumOnceArray2 = renameEnumOnceArray;
            renameEnumOnceArray[0] = A = new RenameEnumOnce();
            renameEnumOnceArray[1] = B = new RenameEnumOnce();
            renameEnumOnceArray[2] = C = new RenameEnumOnce();
            renameEnumOnceArray[3] = E = new RenameEnumOnce();
            $VALUES = renameEnumOnceArray;
        }

        public static RenameEnumOnce[] values() {
            return (RenameEnumOnce[])$VALUES.clone();
        }

        public static RenameEnumOnce valueOf(String string) {
            return Enum.valueOf(RenameEnumOnce.class, string);
        }
    }

    @CordaSerializationTransformEnumDefaults(value={})
    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0087\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$MissingDefaults;", "", "(Ljava/lang/String;I)V", "A", "B", "C", "D", "serialization"})
    public static final class MissingDefaults
    extends Enum<MissingDefaults> {
        public static final /* enum */ MissingDefaults A;
        public static final /* enum */ MissingDefaults B;
        public static final /* enum */ MissingDefaults C;
        public static final /* enum */ MissingDefaults D;
        private static final /* synthetic */ MissingDefaults[] $VALUES;

        static {
            MissingDefaults[] missingDefaultsArray = new MissingDefaults[4];
            MissingDefaults[] missingDefaultsArray2 = missingDefaultsArray;
            missingDefaultsArray[0] = A = new MissingDefaults();
            missingDefaultsArray[1] = B = new MissingDefaults();
            missingDefaultsArray[2] = C = new MissingDefaults();
            missingDefaultsArray[3] = D = new MissingDefaults();
            $VALUES = missingDefaultsArray;
        }

        public static MissingDefaults[] values() {
            return (MissingDefaults[])$VALUES.clone();
        }

        public static MissingDefaults valueOf(String string) {
            return Enum.valueOf(MissingDefaults.class, string);
        }
    }

    @CordaSerializationTransformRenames(value={@CordaSerializationTransformRename(to="E", from="C"), @CordaSerializationTransformRename(to="F", from="D")})
    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0087\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$RenameEnumTwice;", "", "(Ljava/lang/String;I)V", "A", "B", "E", "F", "serialization"})
    public static final class RenameEnumTwice
    extends Enum<RenameEnumTwice> {
        public static final /* enum */ RenameEnumTwice A;
        public static final /* enum */ RenameEnumTwice B;
        public static final /* enum */ RenameEnumTwice E;
        public static final /* enum */ RenameEnumTwice F;
        private static final /* synthetic */ RenameEnumTwice[] $VALUES;

        static {
            RenameEnumTwice[] renameEnumTwiceArray = new RenameEnumTwice[4];
            RenameEnumTwice[] renameEnumTwiceArray2 = renameEnumTwiceArray;
            renameEnumTwiceArray[0] = A = new RenameEnumTwice();
            renameEnumTwiceArray[1] = B = new RenameEnumTwice();
            renameEnumTwiceArray[2] = E = new RenameEnumTwice();
            renameEnumTwiceArray[3] = F = new RenameEnumTwice();
            $VALUES = renameEnumTwiceArray;
        }

        public static RenameEnumTwice[] values() {
            return (RenameEnumTwice[])$VALUES.clone();
        }

        public static RenameEnumTwice valueOf(String string) {
            return Enum.valueOf(RenameEnumTwice.class, string);
        }
    }

    @CordaSerializationTransformRename(from="A", to="X")
    @CordaSerializationTransformEnumDefault(old="X", new="E")
    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0087\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$RenameAndExtendEnum;", "", "(Ljava/lang/String;I)V", "X", "B", "C", "D", "E", "serialization"})
    public static final class RenameAndExtendEnum
    extends Enum<RenameAndExtendEnum> {
        public static final /* enum */ RenameAndExtendEnum X;
        public static final /* enum */ RenameAndExtendEnum B;
        public static final /* enum */ RenameAndExtendEnum C;
        public static final /* enum */ RenameAndExtendEnum D;
        public static final /* enum */ RenameAndExtendEnum E;
        private static final /* synthetic */ RenameAndExtendEnum[] $VALUES;

        static {
            RenameAndExtendEnum[] renameAndExtendEnumArray = new RenameAndExtendEnum[5];
            RenameAndExtendEnum[] renameAndExtendEnumArray2 = renameAndExtendEnumArray;
            renameAndExtendEnumArray[0] = X = new RenameAndExtendEnum();
            renameAndExtendEnumArray[1] = B = new RenameAndExtendEnum();
            renameAndExtendEnumArray[2] = C = new RenameAndExtendEnum();
            renameAndExtendEnumArray[3] = D = new RenameAndExtendEnum();
            renameAndExtendEnumArray[4] = E = new RenameAndExtendEnum();
            $VALUES = renameAndExtendEnumArray;
        }

        public static RenameAndExtendEnum[] values() {
            return (RenameAndExtendEnum[])$VALUES.clone();
        }

        public static RenameAndExtendEnum valueOf(String string) {
            return Enum.valueOf(RenameAndExtendEnum.class, string);
        }
    }

    @CordaSerializationTransformEnumDefaults(value={@CordaSerializationTransformEnumDefault(new="D", old="A"), @CordaSerializationTransformEnumDefault(new="D", old="A")})
    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0087\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$RepeatedAnnotation;", "", "(Ljava/lang/String;I)V", "A", "B", "C", "D", "E", "serialization"})
    public static final class RepeatedAnnotation
    extends Enum<RepeatedAnnotation> {
        public static final /* enum */ RepeatedAnnotation A;
        public static final /* enum */ RepeatedAnnotation B;
        public static final /* enum */ RepeatedAnnotation C;
        public static final /* enum */ RepeatedAnnotation D;
        public static final /* enum */ RepeatedAnnotation E;
        private static final /* synthetic */ RepeatedAnnotation[] $VALUES;

        static {
            RepeatedAnnotation[] repeatedAnnotationArray = new RepeatedAnnotation[5];
            RepeatedAnnotation[] repeatedAnnotationArray2 = repeatedAnnotationArray;
            repeatedAnnotationArray[0] = A = new RepeatedAnnotation();
            repeatedAnnotationArray[1] = B = new RepeatedAnnotation();
            repeatedAnnotationArray[2] = C = new RepeatedAnnotation();
            repeatedAnnotationArray[3] = D = new RepeatedAnnotation();
            repeatedAnnotationArray[4] = E = new RepeatedAnnotation();
            $VALUES = repeatedAnnotationArray;
        }

        public static RepeatedAnnotation[] values() {
            return (RepeatedAnnotation[])$VALUES.clone();
        }

        public static RepeatedAnnotation valueOf(String string) {
            return Enum.valueOf(RepeatedAnnotation.class, string);
        }
    }

    @CordaSerializationTransformEnumDefault(new="D", old="A")
    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0087\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$E1;", "", "(Ljava/lang/String;I)V", "A", "B", "C", "D", "serialization"})
    public static final class E1
    extends Enum<E1> {
        public static final /* enum */ E1 A;
        public static final /* enum */ E1 B;
        public static final /* enum */ E1 C;
        public static final /* enum */ E1 D;
        private static final /* synthetic */ E1[] $VALUES;

        static {
            E1[] e1Array = new E1[4];
            E1[] e1Array2 = e1Array;
            e1Array[0] = A = new E1();
            e1Array[1] = B = new E1();
            e1Array[2] = C = new E1();
            e1Array[3] = D = new E1();
            $VALUES = e1Array;
        }

        public static E1[] values() {
            return (E1[])$VALUES.clone();
        }

        public static E1 valueOf(String string) {
            return Enum.valueOf(E1.class, string);
        }
    }

    @CordaSerializationTransformEnumDefaults(value={@CordaSerializationTransformEnumDefault(new="D", old="A"), @CordaSerializationTransformEnumDefault(new="E", old="A")})
    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0087\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$E2;", "", "(Ljava/lang/String;I)V", "A", "B", "C", "D", "E", "serialization"})
    public static final class E2
    extends Enum<E2> {
        public static final /* enum */ E2 A;
        public static final /* enum */ E2 B;
        public static final /* enum */ E2 C;
        public static final /* enum */ E2 D;
        public static final /* enum */ E2 E;
        private static final /* synthetic */ E2[] $VALUES;

        static {
            E2[] e2Array = new E2[5];
            E2[] e2Array2 = e2Array;
            e2Array[0] = A = new E2();
            e2Array[1] = B = new E2();
            e2Array[2] = C = new E2();
            e2Array[3] = D = new E2();
            e2Array[4] = E = new E2();
            $VALUES = e2Array;
        }

        public static E2[] values() {
            return (E2[])$VALUES.clone();
        }

        public static E2 valueOf(String string) {
            return Enum.valueOf(E2.class, string);
        }
    }

    @CordaSerializationTransformEnumDefaults(value={@CordaSerializationTransformEnumDefault(new="D", old="A")})
    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0087\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$E3;", "", "(Ljava/lang/String;I)V", "A", "B", "C", "D", "serialization"})
    public static final class E3
    extends Enum<E3> {
        public static final /* enum */ E3 A;
        public static final /* enum */ E3 B;
        public static final /* enum */ E3 C;
        public static final /* enum */ E3 D;
        private static final /* synthetic */ E3[] $VALUES;

        static {
            E3[] e3Array = new E3[4];
            E3[] e3Array2 = e3Array;
            e3Array[0] = A = new E3();
            e3Array[1] = B = new E3();
            e3Array[2] = C = new E3();
            e3Array[3] = D = new E3();
            $VALUES = e3Array;
        }

        public static E3[] values() {
            return (E3[])$VALUES.clone();
        }

        public static E3 valueOf(String string) {
            return Enum.valueOf(E3.class, string);
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$WithUnknownTest;", "", "(Ljava/lang/String;I)V", "A", "B", "C", "D", "serialization"})
    public static final class WithUnknownTest
    extends Enum<WithUnknownTest> {
        public static final /* enum */ WithUnknownTest A;
        public static final /* enum */ WithUnknownTest B;
        public static final /* enum */ WithUnknownTest C;
        public static final /* enum */ WithUnknownTest D;
        private static final /* synthetic */ WithUnknownTest[] $VALUES;

        static {
            WithUnknownTest[] withUnknownTestArray = new WithUnknownTest[4];
            WithUnknownTest[] withUnknownTestArray2 = withUnknownTestArray;
            withUnknownTestArray[0] = A = new WithUnknownTest();
            withUnknownTestArray[1] = B = new WithUnknownTest();
            withUnknownTestArray[2] = C = new WithUnknownTest();
            withUnknownTestArray[3] = D = new WithUnknownTest();
            $VALUES = withUnknownTestArray;
        }

        public static WithUnknownTest[] values() {
            return (WithUnknownTest[])$VALUES.clone();
        }

        public static WithUnknownTest valueOf(String string) {
            return Enum.valueOf(WithUnknownTest.class, string);
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$WrapsUnknown;", "", "unknown", "Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$WithUnknownTest;", "(Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$WithUnknownTest;)V", "getUnknown", "()Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$WithUnknownTest;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
    public static final class WrapsUnknown {
        @NotNull
        private final WithUnknownTest unknown;

        @NotNull
        public final WithUnknownTest getUnknown() {
            return this.unknown;
        }

        public WrapsUnknown(@NotNull WithUnknownTest unknown) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)unknown), (String)"unknown");
            this.unknown = unknown;
        }

        @NotNull
        public final WithUnknownTest component1() {
            return this.unknown;
        }

        @NotNull
        public final WrapsUnknown copy(@NotNull WithUnknownTest unknown) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)unknown), (String)"unknown");
            return new WrapsUnknown(unknown);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ WrapsUnknown copy$default(WrapsUnknown wrapsUnknown, WithUnknownTest withUnknownTest, int n, Object object) {
            if ((n & 1) != 0) {
                withUnknownTest = wrapsUnknown.unknown;
            }
            return wrapsUnknown.copy(withUnknownTest);
        }

        @NotNull
        public String toString() {
            return "WrapsUnknown(unknown=" + (Object)((Object)this.unknown) + ")";
        }

        public int hashCode() {
            WithUnknownTest withUnknownTest = this.unknown;
            return withUnknownTest != null ? ((Object)((Object)withUnknownTest)).hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof WrapsUnknown)) break block3;
                    WrapsUnknown wrapsUnknown = (WrapsUnknown)object;
                    if (!Intrinsics.areEqual((Object)((Object)this.unknown), (Object)((Object)wrapsUnknown.unknown))) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @CordaSerializationTransformRenames(value={@CordaSerializationTransformRename(from="A", to="B"), @CordaSerializationTransformRename(from="B", to="C")})
    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0003\b\u0087\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003\u00a8\u0006\u0004"}, d2={"Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$AcceptMultipleRename;", "", "(Ljava/lang/String;I)V", "C", "serialization"})
    public static final class AcceptMultipleRename
    extends Enum<AcceptMultipleRename> {
        public static final /* enum */ AcceptMultipleRename C;
        private static final /* synthetic */ AcceptMultipleRename[] $VALUES;

        static {
            AcceptMultipleRename[] acceptMultipleRenameArray = new AcceptMultipleRename[1];
            AcceptMultipleRename[] acceptMultipleRenameArray2 = acceptMultipleRenameArray;
            acceptMultipleRenameArray[0] = C = new AcceptMultipleRename();
            $VALUES = acceptMultipleRenameArray;
        }

        public static AcceptMultipleRename[] values() {
            return (AcceptMultipleRename[])$VALUES.clone();
        }

        public static AcceptMultipleRename valueOf(String string) {
            return Enum.valueOf(AcceptMultipleRename.class, string);
        }
    }

    @CordaSerializationTransformRenames(value={@CordaSerializationTransformRename(from="D", to="C"), @CordaSerializationTransformRename(from="E", to="C")})
    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0087\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$RejectMultipleRenameTo;", "", "(Ljava/lang/String;I)V", "A", "B", "C", "serialization"})
    public static final class RejectMultipleRenameTo
    extends Enum<RejectMultipleRenameTo> {
        public static final /* enum */ RejectMultipleRenameTo A;
        public static final /* enum */ RejectMultipleRenameTo B;
        public static final /* enum */ RejectMultipleRenameTo C;
        private static final /* synthetic */ RejectMultipleRenameTo[] $VALUES;

        static {
            RejectMultipleRenameTo[] rejectMultipleRenameToArray = new RejectMultipleRenameTo[3];
            RejectMultipleRenameTo[] rejectMultipleRenameToArray2 = rejectMultipleRenameToArray;
            rejectMultipleRenameToArray[0] = A = new RejectMultipleRenameTo();
            rejectMultipleRenameToArray[1] = B = new RejectMultipleRenameTo();
            rejectMultipleRenameToArray[2] = C = new RejectMultipleRenameTo();
            $VALUES = rejectMultipleRenameToArray;
        }

        public static RejectMultipleRenameTo[] values() {
            return (RejectMultipleRenameTo[])$VALUES.clone();
        }

        public static RejectMultipleRenameTo valueOf(String string) {
            return Enum.valueOf(RejectMultipleRenameTo.class, string);
        }
    }

    @CordaSerializationTransformRenames(value={@CordaSerializationTransformRename(from="D", to="C"), @CordaSerializationTransformRename(from="D", to="B")})
    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0087\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$RejectMultipleRenameFrom;", "", "(Ljava/lang/String;I)V", "A", "B", "C", "serialization"})
    public static final class RejectMultipleRenameFrom
    extends Enum<RejectMultipleRenameFrom> {
        public static final /* enum */ RejectMultipleRenameFrom A;
        public static final /* enum */ RejectMultipleRenameFrom B;
        public static final /* enum */ RejectMultipleRenameFrom C;
        private static final /* synthetic */ RejectMultipleRenameFrom[] $VALUES;

        static {
            RejectMultipleRenameFrom[] rejectMultipleRenameFromArray = new RejectMultipleRenameFrom[3];
            RejectMultipleRenameFrom[] rejectMultipleRenameFromArray2 = rejectMultipleRenameFromArray;
            rejectMultipleRenameFromArray[0] = A = new RejectMultipleRenameFrom();
            rejectMultipleRenameFromArray[1] = B = new RejectMultipleRenameFrom();
            rejectMultipleRenameFromArray[2] = C = new RejectMultipleRenameFrom();
            $VALUES = rejectMultipleRenameFromArray;
        }

        public static RejectMultipleRenameFrom[] values() {
            return (RejectMultipleRenameFrom[])$VALUES.clone();
        }

        public static RejectMultipleRenameFrom valueOf(String string) {
            return Enum.valueOf(RejectMultipleRenameFrom.class, string);
        }
    }

    @CordaSerializationTransformRenames(value={@CordaSerializationTransformRename(to="D", from="C"), @CordaSerializationTransformRename(to="C", from="D")})
    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0087\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$RejectCyclicRename;", "", "(Ljava/lang/String;I)V", "A", "B", "C", "serialization"})
    public static final class RejectCyclicRename
    extends Enum<RejectCyclicRename> {
        public static final /* enum */ RejectCyclicRename A;
        public static final /* enum */ RejectCyclicRename B;
        public static final /* enum */ RejectCyclicRename C;
        private static final /* synthetic */ RejectCyclicRename[] $VALUES;

        static {
            RejectCyclicRename[] rejectCyclicRenameArray = new RejectCyclicRename[3];
            RejectCyclicRename[] rejectCyclicRenameArray2 = rejectCyclicRenameArray;
            rejectCyclicRenameArray[0] = A = new RejectCyclicRename();
            rejectCyclicRenameArray[1] = B = new RejectCyclicRename();
            rejectCyclicRenameArray[2] = C = new RejectCyclicRename();
            $VALUES = rejectCyclicRenameArray;
        }

        public static RejectCyclicRename[] values() {
            return (RejectCyclicRename[])$VALUES.clone();
        }

        public static RejectCyclicRename valueOf(String string) {
            return Enum.valueOf(RejectCyclicRename.class, string);
        }
    }

    @CordaSerializationTransformRenames(value={@CordaSerializationTransformRename(to="G", from="C"), @CordaSerializationTransformRename(to="F", from="G"), @CordaSerializationTransformRename(to="E", from="F"), @CordaSerializationTransformRename(to="D", from="E"), @CordaSerializationTransformRename(to="C", from="D")})
    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0087\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$RejectCyclicRenameRedux;", "", "(Ljava/lang/String;I)V", "A", "B", "C", "serialization"})
    public static final class RejectCyclicRenameRedux
    extends Enum<RejectCyclicRenameRedux> {
        public static final /* enum */ RejectCyclicRenameRedux A;
        public static final /* enum */ RejectCyclicRenameRedux B;
        public static final /* enum */ RejectCyclicRenameRedux C;
        private static final /* synthetic */ RejectCyclicRenameRedux[] $VALUES;

        static {
            RejectCyclicRenameRedux[] rejectCyclicRenameReduxArray = new RejectCyclicRenameRedux[3];
            RejectCyclicRenameRedux[] rejectCyclicRenameReduxArray2 = rejectCyclicRenameReduxArray;
            rejectCyclicRenameReduxArray[0] = A = new RejectCyclicRenameRedux();
            rejectCyclicRenameReduxArray[1] = B = new RejectCyclicRenameRedux();
            rejectCyclicRenameReduxArray[2] = C = new RejectCyclicRenameRedux();
            $VALUES = rejectCyclicRenameReduxArray;
        }

        public static RejectCyclicRenameRedux[] values() {
            return (RejectCyclicRenameRedux[])$VALUES.clone();
        }

        public static RejectCyclicRenameRedux valueOf(String string) {
            return Enum.valueOf(RejectCyclicRenameRedux.class, string);
        }
    }

    @CordaSerializationTransformEnumDefault(new="D", old="X")
    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0087\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$RejectBadDefault;", "", "(Ljava/lang/String;I)V", "A", "B", "C", "D", "serialization"})
    public static final class RejectBadDefault
    extends Enum<RejectBadDefault> {
        public static final /* enum */ RejectBadDefault A;
        public static final /* enum */ RejectBadDefault B;
        public static final /* enum */ RejectBadDefault C;
        public static final /* enum */ RejectBadDefault D;
        private static final /* synthetic */ RejectBadDefault[] $VALUES;

        static {
            RejectBadDefault[] rejectBadDefaultArray = new RejectBadDefault[4];
            RejectBadDefault[] rejectBadDefaultArray2 = rejectBadDefaultArray;
            rejectBadDefaultArray[0] = A = new RejectBadDefault();
            rejectBadDefaultArray[1] = B = new RejectBadDefault();
            rejectBadDefaultArray[2] = C = new RejectBadDefault();
            rejectBadDefaultArray[3] = D = new RejectBadDefault();
            $VALUES = rejectBadDefaultArray;
        }

        public static RejectBadDefault[] values() {
            return (RejectBadDefault[])$VALUES.clone();
        }

        public static RejectBadDefault valueOf(String string) {
            return Enum.valueOf(RejectBadDefault.class, string);
        }
    }

    @CordaSerializationTransformEnumDefault(new="D", old="D")
    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0087\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$RejectBadDefaultToSelf;", "", "(Ljava/lang/String;I)V", "A", "B", "C", "D", "serialization"})
    public static final class RejectBadDefaultToSelf
    extends Enum<RejectBadDefaultToSelf> {
        public static final /* enum */ RejectBadDefaultToSelf A;
        public static final /* enum */ RejectBadDefaultToSelf B;
        public static final /* enum */ RejectBadDefaultToSelf C;
        public static final /* enum */ RejectBadDefaultToSelf D;
        private static final /* synthetic */ RejectBadDefaultToSelf[] $VALUES;

        static {
            RejectBadDefaultToSelf[] rejectBadDefaultToSelfArray = new RejectBadDefaultToSelf[4];
            RejectBadDefaultToSelf[] rejectBadDefaultToSelfArray2 = rejectBadDefaultToSelfArray;
            rejectBadDefaultToSelfArray[0] = A = new RejectBadDefaultToSelf();
            rejectBadDefaultToSelfArray[1] = B = new RejectBadDefaultToSelf();
            rejectBadDefaultToSelfArray[2] = C = new RejectBadDefaultToSelf();
            rejectBadDefaultToSelfArray[3] = D = new RejectBadDefaultToSelf();
            $VALUES = rejectBadDefaultToSelfArray;
        }

        public static RejectBadDefaultToSelf[] values() {
            return (RejectBadDefaultToSelf[])$VALUES.clone();
        }

        public static RejectBadDefaultToSelf valueOf(String string) {
            return Enum.valueOf(RejectBadDefaultToSelf.class, string);
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnet/corda/serialization/internal/amqp/EnumEvolvabilityTests$Companion;", "", "()V", "VERBOSE", "", "serialization"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

