/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp;

import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.test.AssertionsKt;
import net.corda.core.serialization.CordaSerializable;
import net.corda.core.serialization.SerializationContext;
import net.corda.core.serialization.SerializedBytes;
import net.corda.core.utilities.ByteSequence;
import net.corda.serialization.internal.amqp.AMQPTypeIdentifiers;
import net.corda.serialization.internal.amqp.BytesAndSchemas;
import net.corda.serialization.internal.amqp.DeserializationInput;
import net.corda.serialization.internal.amqp.DeserializeSimpleTypesTests;
import net.corda.serialization.internal.amqp.LocalSerializerFactory;
import net.corda.serialization.internal.amqp.SerializationOutput;
import net.corda.serialization.internal.amqp.SerializerFactory;
import net.corda.serialization.internal.amqp.TypeNotation;
import net.corda.serialization.internal.amqp.testutils.AMQPTestUtilsKt;
import net.corda.serialization.internal.amqp.testutils.TestSerializationContextKt;
import net.corda.serialization.internal.amqp.testutils.TestSerializationOutput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b \u0018\u0000 -2\u00020\u0001:\u0005-./01B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0007J\b\u0010\u000b\u001a\u00020\nH\u0007J\b\u0010\f\u001a\u00020\nH\u0007J\b\u0010\r\u001a\u00020\nH\u0007J\u001e\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u0012H\u0002J\b\u0010\u0013\u001a\u00020\nH\u0007J\b\u0010\u0014\u001a\u00020\nH\u0007J\b\u0010\u0015\u001a\u00020\nH\u0007J\b\u0010\u0016\u001a\u00020\nH\u0007J\b\u0010\u0017\u001a\u00020\nH\u0007J\b\u0010\u0018\u001a\u00020\nH\u0007J\b\u0010\u0019\u001a\u00020\nH\u0007J\b\u0010\u001a\u001a\u00020\nH\u0007J\b\u0010\u001b\u001a\u00020\nH\u0007J\b\u0010\u001c\u001a\u00020\nH\u0007J\b\u0010\u001d\u001a\u00020\nH\u0007J\b\u0010\u001e\u001a\u00020\nH\u0007J\b\u0010\u001f\u001a\u00020\nH\u0007J\b\u0010 \u001a\u00020\nH\u0007J\b\u0010!\u001a\u00020\nH\u0007J\b\u0010\"\u001a\u00020\nH\u0007J\b\u0010#\u001a\u00020\nH\u0007J\b\u0010$\u001a\u00020\nH\u0007J\b\u0010%\u001a\u00020\nH\u0007J\b\u0010&\u001a\u00020\nH\u0007J\b\u0010'\u001a\u00020\nH\u0007J\b\u0010(\u001a\u00020\nH\u0007J\b\u0010)\u001a\u00020\nH\u0007J\b\u0010*\u001a\u00020\nH\u0007J\b\u0010+\u001a\u00020\nH\u0007J\b\u0010,\u001a\u00020\nH\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u00062"}, d2={"Lnet/corda/serialization/internal/amqp/DeserializeSimpleTypesTests;", "", "()V", "sf1", "Lnet/corda/serialization/internal/amqp/SerializerFactory;", "getSf1", "()Lnet/corda/serialization/internal/amqp/SerializerFactory;", "sf2", "getSf2", "arrayOfArrayOfInt", "", "arrayOfArrayOfIntArray", "arrayOfByteArray", "arrayOfIntArray", "assertFailsWithMessage", "expectedMessage", "", "block", "Lkotlin/Function0;", "classHasNoPublicConstructor", "comparableNotWhitelistedOk", "nestedRepeatedTypes", "notWhitelistedError", "propertyClassHasNoPublicConstructor", "propertyClassNotWhitelistedError", "testArrayOfBoolean", "testArrayOfByte", "testArrayOfChars", "testArrayOfDouble", "testArrayOfFloat", "testArrayOfInt", "testArrayOfInteger", "testArrayOfLong", "testArrayOfShort", "testBooleanArray", "testByteArray", "testChar", "testCharArray", "testCharacter", "testDoubleArray", "testFloatArray", "testIntArray", "testLongArray", "testNullCharacter", "testShortArray", "Companion", "Garbo", "Greta", "Owner", "PropertyWithoutCordaSerializable", "serialization"})
public final class DeserializeSimpleTypesTests {
    @NotNull
    private final SerializerFactory sf1 = AMQPTestUtilsKt.testDefaultFactoryNoEvolution$default(null, 1, null);
    @NotNull
    private final SerializerFactory sf2 = AMQPTestUtilsKt.testDefaultFactoryNoEvolution$default(null, 1, null);
    private static final boolean VERBOSE = false;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final SerializerFactory getSf1() {
        return this.sf1;
    }

    @NotNull
    public final SerializerFactory getSf2() {
        return this.sf2;
    }

    @Test(timeout=300000L)
    public final void testChar() {
        DeserializationInput $receiver$iv;
        DeserializationInput deserializationInput = new DeserializationInput(this.sf1);
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000'\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\f\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0018\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"net/corda/serialization/internal/amqp/DeserializeSimpleTypesTests$testChar$C", "", "c", "", "(C)V", "getC", "()C", "component1", "copy", "(C)Lnet/corda/serialization/internal/amqp/DeserializeSimpleTypesTests$testChar$C;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
        public final class C {
            private final char c;

            public final char getC() {
                return this.c;
            }

            public C(char c) {
                this.c = c;
            }

            public final char component1() {
                return this.c;
            }

            @NotNull
            public final C copy(char c) {
                return new C(c);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ C copy$default(C c, char c2, int n, Object object) {
                if ((n & 1) != 0) {
                    c2 = c.c;
                }
                return c.copy(c2);
            }

            @NotNull
            public String toString() {
                return "C(c=" + this.c + ")";
            }

            public int hashCode() {
                return Character.hashCode(this.c);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof C)) break block3;
                        C c = (C)object;
                        if (!(this.c == c.c)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        SerializedBytes bytes$iv = AMQPTestUtilsKt.serialize$default(new SerializationOutput((LocalSerializerFactory)this.sf1), new C('c'), null, 2, null);
        SerializationContext context$iv = null;
        C deserializedC = (C)$receiver$iv.deserialize((ByteSequence)bytes$iv, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)Character.valueOf('c'), (Object)Character.valueOf(deserializedC.getC()), null, (int)4, null);
        $receiver$iv = new DeserializationInput(this.sf1);
        bytes$iv = AMQPTestUtilsKt.serialize$default(new SerializationOutput((LocalSerializerFactory)this.sf1), new C('\u042e'), null, 2, null);
        context$iv = null;
        deserializedC = (C)$receiver$iv.deserialize((ByteSequence)bytes$iv, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)Character.valueOf('\u042e'), (Object)Character.valueOf(deserializedC.getC()), null, (int)4, null);
        $receiver$iv = new DeserializationInput(this.sf1);
        bytes$iv = AMQPTestUtilsKt.serialize$default(new SerializationOutput((LocalSerializerFactory)this.sf1), new C('\u06a3'), null, 2, null);
        context$iv = null;
        deserializedC = (C)$receiver$iv.deserialize((ByteSequence)bytes$iv, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)Character.valueOf('\u06a3'), (Object)Character.valueOf(deserializedC.getC()), null, (int)4, null);
        $receiver$iv = new DeserializationInput(this.sf1);
        bytes$iv = AMQPTestUtilsKt.serialize$default(new SerializationOutput((LocalSerializerFactory)this.sf1), new C('\u06fb'), null, 2, null);
        context$iv = null;
        deserializedC = (C)$receiver$iv.deserialize((ByteSequence)bytes$iv, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)Character.valueOf('\u06fb'), (Object)Character.valueOf(deserializedC.getC()), null, (int)4, null);
        $receiver$iv = new DeserializationInput(this.sf1);
        bytes$iv = AMQPTestUtilsKt.serialize$default(new SerializationOutput((LocalSerializerFactory)this.sf1), new C('\u0986'), null, 2, null);
        context$iv = null;
        deserializedC = (C)$receiver$iv.deserialize((ByteSequence)bytes$iv, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)Character.valueOf('\u0986'), (Object)Character.valueOf(deserializedC.getC()), null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void testCharacter() {
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000'\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\f\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0018\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"net/corda/serialization/internal/amqp/DeserializeSimpleTypesTests$testCharacter$C", "", "c", "", "(C)V", "getC", "()C", "component1", "copy", "(C)Lnet/corda/serialization/internal/amqp/DeserializeSimpleTypesTests$testCharacter$C;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
        public final class C {
            private final char c;

            public final char getC() {
                return this.c;
            }

            public C(char c) {
                this.c = c;
            }

            public final char component1() {
                return this.c;
            }

            @NotNull
            public final C copy(char c) {
                return new C(c);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ C copy$default(C c, char c2, int n, Object object) {
                if ((n & 1) != 0) {
                    c2 = c.c;
                }
                return c.copy(c2);
            }

            @NotNull
            public String toString() {
                return "C(c=" + this.c + ")";
            }

            public int hashCode() {
                return Character.hashCode(this.c);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof C)) break block3;
                        C c = (C)object;
                        if (!(this.c == c.c)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        C c = new C('c');
        SerializedBytes serialisedC = AMQPTestUtilsKt.serialize$default(new SerializationOutput((LocalSerializerFactory)this.sf1), c, null, 2, null);
        DeserializationInput $receiver$iv = new DeserializationInput(this.sf1);
        SerializationContext context$iv = null;
        C deserializedC = (C)$receiver$iv.deserialize((ByteSequence)serialisedC, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)Character.valueOf(c.getC()), (Object)Character.valueOf(deserializedC.getC()), null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void testNullCharacter() {
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000'\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\f\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\t\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0015\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"net/corda/serialization/internal/amqp/DeserializeSimpleTypesTests$testNullCharacter$C", "", "c", "", "(Ljava/lang/Character;)V", "getC", "()Ljava/lang/Character;", "Ljava/lang/Character;", "component1", "copy", "(Ljava/lang/Character;)Lnet/corda/serialization/internal/amqp/DeserializeSimpleTypesTests$testNullCharacter$C;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
        public final class C {
            @Nullable
            private final Character c;

            @Nullable
            public final Character getC() {
                return this.c;
            }

            public C(@Nullable Character c) {
                this.c = c;
            }

            @Nullable
            public final Character component1() {
                return this.c;
            }

            @NotNull
            public final C copy(@Nullable Character c) {
                return new C(c);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ C copy$default(C c, Character c2, int n, Object object) {
                if ((n & 1) != 0) {
                    c2 = c.c;
                }
                return c.copy(c2);
            }

            @NotNull
            public String toString() {
                return "C(c=" + this.c + ")";
            }

            public int hashCode() {
                Character c = this.c;
                return c != null ? ((Object)c).hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof C)) break block3;
                        C c = (C)object;
                        if (!Intrinsics.areEqual((Object)this.c, (Object)c.c)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        C c = new C(null);
        SerializedBytes serialisedC = AMQPTestUtilsKt.serialize$default(new SerializationOutput((LocalSerializerFactory)this.sf1), c, null, 2, null);
        DeserializationInput $receiver$iv = new DeserializationInput(this.sf1);
        SerializationContext context$iv = null;
        C deserializedC = (C)$receiver$iv.deserialize((ByteSequence)serialisedC, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)c.getC(), (Object)deserializedC.getC(), null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void testArrayOfInt() {
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0017\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\b\n\u0002\b\u0005*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0019\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"net/corda/serialization/internal/amqp/DeserializeSimpleTypesTests$testArrayOfInt$IA", "", "ia", "", "", "([Ljava/lang/Integer;)V", "getIa", "()[Ljava/lang/Integer;", "[Ljava/lang/Integer;", "serialization"})
        public final class IA {
            @NotNull
            private final Integer[] ia;

            @NotNull
            public final Integer[] getIa() {
                return this.ia;
            }

            public IA(@NotNull Integer[] ia) {
                Intrinsics.checkParameterIsNotNull((Object)ia, (String)"ia");
                this.ia = ia;
            }
        }
        IA ia = new IA(new Integer[]{1, 2, 3});
        String string = ia.getIa().getClass().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ia.ia::class.java.toString()");
        AssertionsKt.assertEquals$default((Object)"class [Ljava.lang.Integer;", (Object)string, null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)AMQPTypeIdentifiers.INSTANCE.nameForType((Type)ia.getIa().getClass()), (Object)"int[]", null, (int)4, null);
        SerializedBytes<IA> serialisedIA = new TestSerializationOutput(false, this.sf1).serialize(ia);
        DeserializationInput $receiver$iv = new DeserializationInput(this.sf1);
        SerializationContext context$iv = null;
        IA deserializedIA = (IA)$receiver$iv.deserialize((ByteSequence)serialisedIA, IA.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)ia.getIa().length, (Object)deserializedIA.getIa().length, null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)ia.getIa()[0], (Object)deserializedIA.getIa()[0], null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)ia.getIa()[1], (Object)deserializedIA.getIa()[1], null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)ia.getIa()[2], (Object)deserializedIA.getIa()[2], null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void testArrayOfInteger() {
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0017\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\b\n\u0002\b\u0005*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0019\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"net/corda/serialization/internal/amqp/DeserializeSimpleTypesTests$testArrayOfInteger$IA", "", "ia", "", "", "([Ljava/lang/Integer;)V", "getIa", "()[Ljava/lang/Integer;", "[Ljava/lang/Integer;", "serialization"})
        public final class IA {
            @NotNull
            private final Integer[] ia;

            @NotNull
            public final Integer[] getIa() {
                return this.ia;
            }

            public IA(@NotNull Integer[] ia) {
                Intrinsics.checkParameterIsNotNull((Object)ia, (String)"ia");
                this.ia = ia;
            }
        }
        IA ia = new IA(new Integer[]{1, 2, 3});
        String string = ia.getIa().getClass().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ia.ia::class.java.toString()");
        AssertionsKt.assertEquals$default((Object)"class [Ljava.lang.Integer;", (Object)string, null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)AMQPTypeIdentifiers.INSTANCE.nameForType((Type)ia.getIa().getClass()), (Object)"int[]", null, (int)4, null);
        SerializedBytes<IA> serialisedIA = new TestSerializationOutput(false, this.sf1).serialize(ia);
        DeserializationInput $receiver$iv = new DeserializationInput(this.sf1);
        SerializationContext context$iv = null;
        IA deserializedIA = (IA)$receiver$iv.deserialize((ByteSequence)serialisedIA, IA.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)ia.getIa().length, (Object)deserializedIA.getIa().length, null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)ia.getIa()[0], (Object)deserializedIA.getIa()[0], null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)ia.getIa()[1], (Object)deserializedIA.getIa()[1], null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)ia.getIa()[2], (Object)deserializedIA.getIa()[2], null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void testIntArray() {
        int[] v = new int[]{1, 2, 3};
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0013\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0004*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"net/corda/serialization/internal/amqp/DeserializeSimpleTypesTests$testIntArray$IA", "", "ia", "", "([I)V", "getIa", "()[I", "serialization"})
        public final class IA {
            @NotNull
            private final int[] ia;

            @NotNull
            public final int[] getIa() {
                return this.ia;
            }

            public IA(@NotNull int[] ia) {
                Intrinsics.checkParameterIsNotNull((Object)ia, (String)"ia");
                this.ia = ia;
            }
        }
        IA ia = new IA(v);
        String string = ia.getIa().getClass().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ia.ia::class.java.toString()");
        AssertionsKt.assertEquals$default((Object)"class [I", (Object)string, null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)AMQPTypeIdentifiers.INSTANCE.nameForType((Type)ia.getIa().getClass()), (Object)"int[p]", null, (int)4, null);
        SerializedBytes<IA> serialisedIA = new TestSerializationOutput(false, this.sf1).serialize(ia);
        DeserializationInput $receiver$iv = new DeserializationInput(this.sf1);
        SerializationContext context$iv = null;
        IA deserializedIA = (IA)$receiver$iv.deserialize((ByteSequence)serialisedIA, IA.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)ia.getIa().length, (Object)deserializedIA.getIa().length, null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)ia.getIa()[0], (Object)deserializedIA.getIa()[0], null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)ia.getIa()[1], (Object)deserializedIA.getIa()[1], null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)ia.getIa()[2], (Object)deserializedIA.getIa()[2], null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void testArrayOfChars() {
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0017\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\f\n\u0002\b\u0005*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0019\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"net/corda/serialization/internal/amqp/DeserializeSimpleTypesTests$testArrayOfChars$C", "", "c", "", "", "([Ljava/lang/Character;)V", "getC", "()[Ljava/lang/Character;", "[Ljava/lang/Character;", "serialization"})
        public final class C {
            @NotNull
            private final Character[] c;

            @NotNull
            public final Character[] getC() {
                return this.c;
            }

            public C(@NotNull Character[] c) {
                Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
                this.c = c;
            }
        }
        C c = new C(new Character[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c')});
        String string = c.getC().getClass().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"c.c::class.java.toString()");
        AssertionsKt.assertEquals$default((Object)"class [Ljava.lang.Character;", (Object)string, null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)AMQPTypeIdentifiers.INSTANCE.nameForType((Type)c.getC().getClass()), (Object)"char[]", null, (int)4, null);
        SerializedBytes<C> serialisedC = new TestSerializationOutput(false, this.sf1).serialize(c);
        DeserializationInput $receiver$iv = new DeserializationInput(this.sf1);
        SerializationContext context$iv = null;
        C deserializedC = (C)$receiver$iv.deserialize((ByteSequence)serialisedC, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)c.getC().length, (Object)deserializedC.getC().length, null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)c.getC()[0], (Object)deserializedC.getC()[0], null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)c.getC()[1], (Object)deserializedC.getC()[1], null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)c.getC()[2], (Object)deserializedC.getC()[2], null, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void testCharArray() {
        void $receiver$iv;
        char[] v = new char[]{'a', 'b', 'c'};
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0013\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0004*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"net/corda/serialization/internal/amqp/DeserializeSimpleTypesTests$testCharArray$C", "", "c", "", "([C)V", "getC", "()[C", "serialization"})
        public final class C {
            @NotNull
            private final char[] c;

            @NotNull
            public final char[] getC() {
                return this.c;
            }

            public C(@NotNull char[] c) {
                Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
                this.c = c;
            }
        }
        C c = new C(v);
        String string = c.getC().getClass().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"c.c::class.java.toString()");
        AssertionsKt.assertEquals$default((Object)"class [C", (Object)string, null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)AMQPTypeIdentifiers.INSTANCE.nameForType((Type)c.getC().getClass()), (Object)"char[p]", null, (int)4, null);
        SerializedBytes<C> serialisedC = new TestSerializationOutput(false, this.sf1).serialize(c);
        DeserializationInput $receiver$iv2 = new DeserializationInput(this.sf1);
        SerializationContext context$iv = null;
        C deserializedC = (C)$receiver$iv2.deserialize((ByteSequence)serialisedC, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)c.getC().length, (Object)deserializedC.getC().length, null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)Character.valueOf(c.getC()[0]), (Object)Character.valueOf(deserializedC.getC()[0]), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)Character.valueOf(c.getC()[1]), (Object)Character.valueOf(deserializedC.getC()[1]), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)Character.valueOf(c.getC()[2]), (Object)Character.valueOf(deserializedC.getC()[2]), null, (int)4, null);
        v[0] = 2439;
        v[1] = 32;
        v[2] = 2580;
        C c2 = new C(v);
        context$iv = new DeserializationInput(this.sf1);
        SerializedBytes<C> bytes$iv = new TestSerializationOutput(false, this.sf1).serialize(c2);
        SerializationContext context$iv2 = null;
        deserializedC = (C)$receiver$iv.deserialize((ByteSequence)bytes$iv, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)c2.getC().length, (Object)deserializedC.getC().length, null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)Character.valueOf(c2.getC()[0]), (Object)Character.valueOf(deserializedC.getC()[0]), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)Character.valueOf(c2.getC()[1]), (Object)Character.valueOf(deserializedC.getC()[1]), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)Character.valueOf(c2.getC()[2]), (Object)Character.valueOf(deserializedC.getC()[2]), null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void testArrayOfBoolean() {
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0017\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000b\n\u0002\b\u0005*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0019\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"net/corda/serialization/internal/amqp/DeserializeSimpleTypesTests$testArrayOfBoolean$C", "", "c", "", "", "([Ljava/lang/Boolean;)V", "getC", "()[Ljava/lang/Boolean;", "[Ljava/lang/Boolean;", "serialization"})
        public final class C {
            @NotNull
            private final Boolean[] c;

            @NotNull
            public final Boolean[] getC() {
                return this.c;
            }

            public C(@NotNull Boolean[] c) {
                Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
                this.c = c;
            }
        }
        C c = new C(new Boolean[]{true, false, false, true});
        String string = c.getC().getClass().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"c.c::class.java.toString()");
        AssertionsKt.assertEquals$default((Object)"class [Ljava.lang.Boolean;", (Object)string, null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)AMQPTypeIdentifiers.INSTANCE.nameForType((Type)c.getC().getClass()), (Object)"boolean[]", null, (int)4, null);
        SerializedBytes<C> serialisedC = new TestSerializationOutput(false, this.sf1).serialize(c);
        DeserializationInput $receiver$iv = new DeserializationInput(this.sf1);
        SerializationContext context$iv = null;
        C deserializedC = (C)$receiver$iv.deserialize((ByteSequence)serialisedC, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)c.getC().length, (Object)deserializedC.getC().length, null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)c.getC()[0], (Object)deserializedC.getC()[0], null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)c.getC()[1], (Object)deserializedC.getC()[1], null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)c.getC()[2], (Object)deserializedC.getC()[2], null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)c.getC()[3], (Object)deserializedC.getC()[3], null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void testBooleanArray() {
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0013\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0018\n\u0002\b\u0004*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"net/corda/serialization/internal/amqp/DeserializeSimpleTypesTests$testBooleanArray$C", "", "c", "", "([Z)V", "getC", "()[Z", "serialization"})
        public final class C {
            @NotNull
            private final boolean[] c;

            @NotNull
            public final boolean[] getC() {
                return this.c;
            }

            public C(@NotNull boolean[] c) {
                Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
                this.c = c;
            }
        }
        C c = new C(new boolean[4]);
        c.getC()[0] = true;
        c.getC()[1] = false;
        c.getC()[2] = false;
        c.getC()[3] = true;
        String string = c.getC().getClass().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"c.c::class.java.toString()");
        AssertionsKt.assertEquals$default((Object)"class [Z", (Object)string, null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)AMQPTypeIdentifiers.INSTANCE.nameForType((Type)c.getC().getClass()), (Object)"boolean[p]", null, (int)4, null);
        SerializedBytes<C> serialisedC = new TestSerializationOutput(false, this.sf1).serialize(c);
        DeserializationInput $receiver$iv = new DeserializationInput(this.sf1);
        SerializationContext context$iv = null;
        C deserializedC = (C)$receiver$iv.deserialize((ByteSequence)serialisedC, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)c.getC().length, (Object)deserializedC.getC().length, null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)c.getC()[0], (Object)deserializedC.getC()[0], null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)c.getC()[1], (Object)deserializedC.getC()[1], null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)c.getC()[2], (Object)deserializedC.getC()[2], null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)c.getC()[3], (Object)deserializedC.getC()[3], null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void testArrayOfByte() {
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0017\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0005\n\u0002\b\u0005*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0019\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"net/corda/serialization/internal/amqp/DeserializeSimpleTypesTests$testArrayOfByte$C", "", "c", "", "", "([Ljava/lang/Byte;)V", "getC", "()[Ljava/lang/Byte;", "[Ljava/lang/Byte;", "serialization"})
        public final class C {
            @NotNull
            private final Byte[] c;

            @NotNull
            public final Byte[] getC() {
                return this.c;
            }

            public C(@NotNull Byte[] c) {
                Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
                this.c = c;
            }
        }
        C c = new C(new Byte[]{(byte)1, (byte)5, (byte)15});
        String string = c.getC().getClass().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"c.c::class.java.toString()");
        AssertionsKt.assertEquals$default((Object)"class [Ljava.lang.Byte;", (Object)string, null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)AMQPTypeIdentifiers.INSTANCE.nameForType((Type)c.getC().getClass()), (Object)"byte[]", null, (int)4, null);
        SerializedBytes<C> serialisedC = new TestSerializationOutput(false, this.sf1).serialize(c);
        DeserializationInput $receiver$iv = new DeserializationInput(this.sf1);
        SerializationContext context$iv = null;
        C deserializedC = (C)$receiver$iv.deserialize((ByteSequence)serialisedC, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)c.getC().length, (Object)deserializedC.getC().length, null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)c.getC()[0], (Object)deserializedC.getC()[0], null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)c.getC()[1], (Object)deserializedC.getC()[1], null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)c.getC()[2], (Object)deserializedC.getC()[2], null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void testByteArray() {
        DeserializationInput di;
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0013\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"net/corda/serialization/internal/amqp/DeserializeSimpleTypesTests$testByteArray$C", "", "c", "", "([B)V", "getC", "()[B", "serialization"})
        public final class C {
            @NotNull
            private final byte[] c;

            @NotNull
            public final byte[] getC() {
                return this.c;
            }

            public C(@NotNull byte[] c) {
                Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
                this.c = c;
            }
        }
        C c = new C(new byte[3]);
        c.getC()[0] = 1;
        c.getC()[1] = 5;
        c.getC()[2] = 15;
        String string = c.getC().getClass().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"c.c::class.java.toString()");
        AssertionsKt.assertEquals$default((Object)"class [B", (Object)string, null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)"binary", (Object)AMQPTypeIdentifiers.INSTANCE.nameForType((Type)c.getC().getClass()), null, (int)4, null);
        SerializedBytes<C> serialisedC = new TestSerializationOutput(false, this.sf1).serialize(c);
        DeserializationInput $receiver$iv = new DeserializationInput(this.sf1);
        SerializationContext context$iv = null;
        C deserializedC = (C)$receiver$iv.deserialize((ByteSequence)serialisedC, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)c.getC().length, (Object)deserializedC.getC().length, null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)c.getC()[0], (Object)deserializedC.getC()[0], null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)c.getC()[1], (Object)deserializedC.getC()[1], null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)c.getC()[2], (Object)deserializedC.getC()[2], null, (int)4, null);
        DeserializationInput $receiver$iv2 = di = new DeserializationInput(this.sf2);
        SerializationContext context$iv2 = null;
        C deserializedC2 = (C)$receiver$iv2.deserialize((ByteSequence)serialisedC, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)c.getC().length, (Object)deserializedC2.getC().length, null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)c.getC()[0], (Object)deserializedC2.getC()[0], null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)c.getC()[1], (Object)deserializedC2.getC()[1], null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)c.getC()[2], (Object)deserializedC2.getC()[2], null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void testArrayOfShort() {
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0017\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\n\n\u0002\b\u0005*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0019\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"net/corda/serialization/internal/amqp/DeserializeSimpleTypesTests$testArrayOfShort$C", "", "c", "", "", "([Ljava/lang/Short;)V", "getC", "()[Ljava/lang/Short;", "[Ljava/lang/Short;", "serialization"})
        public final class C {
            @NotNull
            private final Short[] c;

            @NotNull
            public final Short[] getC() {
                return this.c;
            }

            public C(@NotNull Short[] c) {
                Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
                this.c = c;
            }
        }
        C c = new C(new Short[]{(short)1, (short)2, (short)3});
        String string = c.getC().getClass().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"c.c::class.java.toString()");
        AssertionsKt.assertEquals$default((Object)"class [Ljava.lang.Short;", (Object)string, null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)AMQPTypeIdentifiers.INSTANCE.nameForType((Type)c.getC().getClass()), (Object)"short[]", null, (int)4, null);
        SerializedBytes<C> serialisedC = new TestSerializationOutput(false, this.sf1).serialize(c);
        DeserializationInput $receiver$iv = new DeserializationInput(this.sf1);
        SerializationContext context$iv = null;
        C deserializedC = (C)$receiver$iv.deserialize((ByteSequence)serialisedC, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)c.getC().length, (Object)deserializedC.getC().length, null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)c.getC()[0], (Object)deserializedC.getC()[0], null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)c.getC()[1], (Object)deserializedC.getC()[1], null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)c.getC()[2], (Object)deserializedC.getC()[2], null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void testShortArray() {
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0013\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0017\n\u0002\b\u0004*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"net/corda/serialization/internal/amqp/DeserializeSimpleTypesTests$testShortArray$C", "", "c", "", "([S)V", "getC", "()[S", "serialization"})
        public final class C {
            @NotNull
            private final short[] c;

            @NotNull
            public final short[] getC() {
                return this.c;
            }

            public C(@NotNull short[] c) {
                Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
                this.c = c;
            }
        }
        C c = new C(new short[3]);
        c.getC()[0] = 1;
        c.getC()[1] = 2;
        c.getC()[2] = 5;
        String string = c.getC().getClass().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"c.c::class.java.toString()");
        AssertionsKt.assertEquals$default((Object)"class [S", (Object)string, null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)AMQPTypeIdentifiers.INSTANCE.nameForType((Type)c.getC().getClass()), (Object)"short[p]", null, (int)4, null);
        SerializedBytes<C> serialisedC = new TestSerializationOutput(false, this.sf1).serialize(c);
        DeserializationInput $receiver$iv = new DeserializationInput(this.sf1);
        SerializationContext context$iv = null;
        C deserializedC = (C)$receiver$iv.deserialize((ByteSequence)serialisedC, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)c.getC().length, (Object)deserializedC.getC().length, null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)c.getC()[0], (Object)deserializedC.getC()[0], null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)c.getC()[1], (Object)deserializedC.getC()[1], null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)c.getC()[2], (Object)deserializedC.getC()[2], null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void testArrayOfLong() {
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0017\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\t\n\u0002\b\u0005*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0019\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"net/corda/serialization/internal/amqp/DeserializeSimpleTypesTests$testArrayOfLong$C", "", "c", "", "", "([Ljava/lang/Long;)V", "getC", "()[Ljava/lang/Long;", "[Ljava/lang/Long;", "serialization"})
        public final class C {
            @NotNull
            private final Long[] c;

            @NotNull
            public final Long[] getC() {
                return this.c;
            }

            public C(@NotNull Long[] c) {
                Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
                this.c = c;
            }
        }
        C c = new C(new Long[]{0x80000002L, -2147483800L, 10L});
        String string = c.getC().getClass().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"c.c::class.java.toString()");
        AssertionsKt.assertEquals$default((Object)"class [Ljava.lang.Long;", (Object)string, null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)AMQPTypeIdentifiers.INSTANCE.nameForType((Type)c.getC().getClass()), (Object)"long[]", null, (int)4, null);
        SerializedBytes<C> serialisedC = new TestSerializationOutput(false, this.sf1).serialize(c);
        DeserializationInput $receiver$iv = new DeserializationInput(this.sf1);
        SerializationContext context$iv = null;
        C deserializedC = (C)$receiver$iv.deserialize((ByteSequence)serialisedC, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)c.getC().length, (Object)deserializedC.getC().length, null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)c.getC()[0], (Object)deserializedC.getC()[0], null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)c.getC()[1], (Object)deserializedC.getC()[1], null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)c.getC()[2], (Object)deserializedC.getC()[2], null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void testLongArray() {
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0013\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0004*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"net/corda/serialization/internal/amqp/DeserializeSimpleTypesTests$testLongArray$C", "", "c", "", "([J)V", "getC", "()[J", "serialization"})
        public final class C {
            @NotNull
            private final long[] c;

            @NotNull
            public final long[] getC() {
                return this.c;
            }

            public C(@NotNull long[] c) {
                Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
                this.c = c;
            }
        }
        C c = new C(new long[3]);
        c.getC()[0] = 0x80000002L;
        c.getC()[1] = -2147483800L;
        c.getC()[2] = 10L;
        String string = c.getC().getClass().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"c.c::class.java.toString()");
        AssertionsKt.assertEquals$default((Object)"class [J", (Object)string, null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)AMQPTypeIdentifiers.INSTANCE.nameForType((Type)c.getC().getClass()), (Object)"long[p]", null, (int)4, null);
        SerializedBytes<C> serialisedC = new TestSerializationOutput(false, this.sf1).serialize(c);
        DeserializationInput $receiver$iv = new DeserializationInput(this.sf1);
        SerializationContext context$iv = null;
        C deserializedC = (C)$receiver$iv.deserialize((ByteSequence)serialisedC, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)c.getC().length, (Object)deserializedC.getC().length, null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)c.getC()[0], (Object)deserializedC.getC()[0], null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)c.getC()[1], (Object)deserializedC.getC()[1], null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)c.getC()[2], (Object)deserializedC.getC()[2], null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void testArrayOfFloat() {
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0017\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0007\n\u0002\b\u0005*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0019\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"net/corda/serialization/internal/amqp/DeserializeSimpleTypesTests$testArrayOfFloat$C", "", "c", "", "", "([Ljava/lang/Float;)V", "getC", "()[Ljava/lang/Float;", "[Ljava/lang/Float;", "serialization"})
        public final class C {
            @NotNull
            private final Float[] c;

            @NotNull
            public final Float[] getC() {
                return this.c;
            }

            public C(@NotNull Float[] c) {
                Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
                this.c = c;
            }
        }
        C c = new C(new Float[]{Float.valueOf(10.0f), Float.valueOf(100.02323f), Float.valueOf(-1455.4333f)});
        String string = c.getC().getClass().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"c.c::class.java.toString()");
        AssertionsKt.assertEquals$default((Object)"class [Ljava.lang.Float;", (Object)string, null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)"float[]", (Object)AMQPTypeIdentifiers.INSTANCE.nameForType((Type)c.getC().getClass()), null, (int)4, null);
        SerializedBytes<C> serialisedC = new TestSerializationOutput(false, this.sf1).serialize(c);
        DeserializationInput $receiver$iv = new DeserializationInput(this.sf1);
        SerializationContext context$iv = null;
        C deserializedC = (C)$receiver$iv.deserialize((ByteSequence)serialisedC, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)c.getC().length, (Object)deserializedC.getC().length, null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)c.getC()[0], (Object)deserializedC.getC()[0], null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)c.getC()[1], (Object)deserializedC.getC()[1], null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)c.getC()[2], (Object)deserializedC.getC()[2], null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void testFloatArray() {
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0013\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0004*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"net/corda/serialization/internal/amqp/DeserializeSimpleTypesTests$testFloatArray$C", "", "c", "", "([F)V", "getC", "()[F", "serialization"})
        public final class C {
            @NotNull
            private final float[] c;

            @NotNull
            public final float[] getC() {
                return this.c;
            }

            public C(@NotNull float[] c) {
                Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
                this.c = c;
            }
        }
        C c = new C(new float[3]);
        c.getC()[0] = 10.0f;
        c.getC()[1] = 100.02323f;
        c.getC()[2] = -1455.4333f;
        String string = c.getC().getClass().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"c.c::class.java.toString()");
        AssertionsKt.assertEquals$default((Object)"class [F", (Object)string, null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)AMQPTypeIdentifiers.INSTANCE.nameForType((Type)c.getC().getClass()), (Object)"float[p]", null, (int)4, null);
        SerializedBytes<C> serialisedC = new TestSerializationOutput(false, this.sf1).serialize(c);
        DeserializationInput $receiver$iv = new DeserializationInput(this.sf1);
        SerializationContext context$iv = null;
        C deserializedC = (C)$receiver$iv.deserialize((ByteSequence)serialisedC, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)c.getC().length, (Object)deserializedC.getC().length, null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)Float.valueOf(c.getC()[0]), (Object)Float.valueOf(deserializedC.getC()[0]), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)Float.valueOf(c.getC()[1]), (Object)Float.valueOf(deserializedC.getC()[1]), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)Float.valueOf(c.getC()[2]), (Object)Float.valueOf(deserializedC.getC()[2]), null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void testArrayOfDouble() {
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0017\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0006\n\u0002\b\u0005*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0019\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"net/corda/serialization/internal/amqp/DeserializeSimpleTypesTests$testArrayOfDouble$C", "", "c", "", "", "([Ljava/lang/Double;)V", "getC", "()[Ljava/lang/Double;", "[Ljava/lang/Double;", "serialization"})
        public final class C {
            @NotNull
            private final Double[] c;

            @NotNull
            public final Double[] getC() {
                return this.c;
            }

            public C(@NotNull Double[] c) {
                Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
                this.c = c;
            }
        }
        C c = new C(new Double[]{10.0, 100.2, -1455.2});
        String string = c.getC().getClass().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"c.c::class.java.toString()");
        AssertionsKt.assertEquals$default((Object)"class [Ljava.lang.Double;", (Object)string, null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)AMQPTypeIdentifiers.INSTANCE.nameForType((Type)c.getC().getClass()), (Object)"double[]", null, (int)4, null);
        SerializedBytes<C> serialisedC = new TestSerializationOutput(false, this.sf1).serialize(c);
        DeserializationInput $receiver$iv = new DeserializationInput(this.sf1);
        SerializationContext context$iv = null;
        C deserializedC = (C)$receiver$iv.deserialize((ByteSequence)serialisedC, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)c.getC().length, (Object)deserializedC.getC().length, null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)c.getC()[0], (Object)deserializedC.getC()[0], null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)c.getC()[1], (Object)deserializedC.getC()[1], null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)c.getC()[2], (Object)deserializedC.getC()[2], null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void testDoubleArray() {
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0013\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u0004*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"net/corda/serialization/internal/amqp/DeserializeSimpleTypesTests$testDoubleArray$C", "", "c", "", "([D)V", "getC", "()[D", "serialization"})
        public final class C {
            @NotNull
            private final double[] c;

            @NotNull
            public final double[] getC() {
                return this.c;
            }

            public C(@NotNull double[] c) {
                Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
                this.c = c;
            }
        }
        C c = new C(new double[3]);
        c.getC()[0] = 10.0;
        c.getC()[1] = 100.2;
        c.getC()[2] = -1455.2;
        String string = c.getC().getClass().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"c.c::class.java.toString()");
        AssertionsKt.assertEquals$default((Object)"class [D", (Object)string, null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)AMQPTypeIdentifiers.INSTANCE.nameForType((Type)c.getC().getClass()), (Object)"double[p]", null, (int)4, null);
        SerializedBytes<C> serialisedC = new TestSerializationOutput(false, this.sf1).serialize(c);
        DeserializationInput $receiver$iv = new DeserializationInput(this.sf1);
        SerializationContext context$iv = null;
        C deserializedC = (C)$receiver$iv.deserialize((ByteSequence)serialisedC, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)c.getC().length, (Object)deserializedC.getC().length, null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)c.getC()[0], (Object)deserializedC.getC()[0], null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)c.getC()[1], (Object)deserializedC.getC()[1], null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)c.getC()[2], (Object)deserializedC.getC()[2], null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void arrayOfArrayOfInt() {
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0017\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\b\n\u0002\b\u0005*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0003\u00a2\u0006\u0002\u0010\u0005R\u001f\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0003\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"net/corda/serialization/internal/amqp/DeserializeSimpleTypesTests$arrayOfArrayOfInt$C", "", "c", "", "", "([[Ljava/lang/Integer;)V", "getC", "()[[Ljava/lang/Integer;", "[[Ljava/lang/Integer;", "serialization"})
        public final class C {
            @NotNull
            private final Integer[][] c;

            @NotNull
            public final Integer[][] getC() {
                return this.c;
            }

            public C(@NotNull Integer[][] c) {
                Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
                this.c = c;
            }
        }
        C c = new C(new Integer[][]{{1, 2, 3}, {4, 5, 6}});
        SerializedBytes<C> serialisedC = new TestSerializationOutput(false, this.sf1).serialize(c);
        DeserializationInput $receiver$iv = new DeserializationInput(this.sf1);
        SerializationContext context$iv = null;
        C deserializedC = (C)$receiver$iv.deserialize((ByteSequence)serialisedC, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)((Object[])c.getC()).length, (Object)((Object[])deserializedC.getC()).length, null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)c.getC()[0].length, (Object)deserializedC.getC()[0].length, null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)c.getC()[0][0], (Object)deserializedC.getC()[0][0], null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)c.getC()[0][1], (Object)deserializedC.getC()[0][1], null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)c.getC()[0][2], (Object)deserializedC.getC()[0][2], null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)c.getC()[1].length, (Object)deserializedC.getC()[1].length, null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)c.getC()[1][0], (Object)deserializedC.getC()[1][0], null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)c.getC()[1][1], (Object)deserializedC.getC()[1][1], null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)c.getC()[1][2], (Object)deserializedC.getC()[1][2], null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void arrayOfIntArray() {
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0017\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0015\n\u0002\b\u0005*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0019\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"net/corda/serialization/internal/amqp/DeserializeSimpleTypesTests$arrayOfIntArray$C", "", "c", "", "", "([[I)V", "getC", "()[[I", "[[I", "serialization"})
        public final class C {
            @NotNull
            private final int[][] c;

            @NotNull
            public final int[][] getC() {
                return this.c;
            }

            public C(@NotNull int[][] c) {
                Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
                this.c = c;
            }
        }
        C c = new C(new int[][]{new int[3], new int[3]});
        c.getC()[0][0] = 1;
        c.getC()[0][1] = 2;
        c.getC()[0][2] = 3;
        c.getC()[1][0] = 4;
        c.getC()[1][1] = 5;
        c.getC()[1][2] = 6;
        SerializedBytes<C> serialisedC = new TestSerializationOutput(false, this.sf1).serialize(c);
        DeserializationInput $receiver$iv = new DeserializationInput(this.sf1);
        SerializationContext context$iv = null;
        C deserializedC = (C)$receiver$iv.deserialize((ByteSequence)serialisedC, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)((Object[])c.getC()).length, (Object)((Object[])deserializedC.getC()).length, null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)c.getC()[0].length, (Object)deserializedC.getC()[0].length, null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)c.getC()[0][0], (Object)deserializedC.getC()[0][0], null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)c.getC()[0][1], (Object)deserializedC.getC()[0][1], null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)c.getC()[0][2], (Object)deserializedC.getC()[0][2], null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)c.getC()[1].length, (Object)deserializedC.getC()[1].length, null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)c.getC()[1][0], (Object)deserializedC.getC()[1][0], null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)c.getC()[1][1], (Object)deserializedC.getC()[1][1], null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)c.getC()[1][2], (Object)deserializedC.getC()[1][2], null, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void arrayOfArrayOfIntArray() {
        int n;
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0017\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0015\n\u0002\b\u0005*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0003\u00a2\u0006\u0002\u0010\u0005R\u001f\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0003\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"net/corda/serialization/internal/amqp/DeserializeSimpleTypesTests$arrayOfArrayOfIntArray$C", "", "c", "", "", "([[[I)V", "getC", "()[[[I", "[[[I", "serialization"})
        public final class C {
            @NotNull
            private final int[][][] c;

            @NotNull
            public final int[][][] getC() {
                return this.c;
            }

            public C(@NotNull int[][][] c) {
                Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
                this.c = c;
            }
        }
        C c = new C(new int[][][]{new int[][]{new int[3], new int[3], new int[3]}, new int[][]{new int[3], new int[3], new int[3]}, new int[][]{new int[3], new int[3], new int[3]}});
        int n2 = 0;
        int n3 = 2;
        while (n2 <= n3) {
            void i2;
            int n4 = 0;
            int n5 = 2;
            while (n4 <= n5) {
                void j;
                int n6 = 0;
                n = 2;
                while (n6 <= n) {
                    void k;
                    c.getC()[i2][j][k] = i2 + j + k;
                    ++k;
                }
                ++j;
            }
            ++i2;
        }
        SerializedBytes<C> serialisedC = new TestSerializationOutput(false, this.sf1).serialize(c);
        DeserializationInput $receiver$iv22 = new DeserializationInput(this.sf1);
        SerializationContext context$iv = null;
        C deserializedC = (C)$receiver$iv22.deserialize((ByteSequence)serialisedC, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        int $receiver$iv22 = 0;
        int n7 = 2;
        while ($receiver$iv22 <= n7) {
            void i3;
            int $i$f$deserialize = 0;
            n = 2;
            while ($i$f$deserialize <= n) {
                void j;
                int n8 = 0;
                int n9 = 2;
                while (n8 <= n9) {
                    void k;
                    AssertionsKt.assertEquals$default((Object)c.getC()[i3][j][k], (Object)deserializedC.getC()[i3][j][k], null, (int)4, null);
                    ++k;
                }
                ++j;
            }
            ++i3;
        }
    }

    @Test(timeout=300000L)
    public final void nestedRepeatedTypes() {
        A a;
        A a2;
        A a3;
        A a4;
        A a5;
        A a6;
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0015\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005R\u0015\u0010\u0002\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"net/corda/serialization/internal/amqp/DeserializeSimpleTypesTests$nestedRepeatedTypes$A", "", "a", "b", "", "(Lnet/corda/serialization/internal/amqp/DeserializeSimpleTypesTests$nestedRepeatedTypes$A;I)V", "getA", "()Lnet/corda/serialization/internal/amqp/DeserializeSimpleTypesTests$nestedRepeatedTypes$A;", "Lnet/corda/serialization/internal/amqp/DeserializeSimpleTypesTests$nestedRepeatedTypes$A;", "getB", "()I", "serialization"})
        public final class A {
            @Nullable
            private final A a;
            private final int b;

            @Nullable
            public final A getA() {
                return this.a;
            }

            public final int getB() {
                return this.b;
            }

            public A(@Nullable A a, int b) {
                this.a = a;
                this.b = b;
            }
        }
        A a7 = new A(new A(new A(new A(new A(null, 1), 2), 3), 4), 5);
        SerializedBytes<A> sa = new TestSerializationOutput(false, this.sf1).serialize(a7);
        DeserializationInput $receiver$iv = new DeserializationInput(this.sf1);
        SerializationContext context$iv = null;
        A da1 = (A)$receiver$iv.deserialize((ByteSequence)sa, A.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        DeserializationInput $receiver$iv2 = new DeserializationInput(this.sf2);
        SerializationContext context$iv2 = null;
        A da2 = (A)$receiver$iv2.deserialize((ByteSequence)sa, A.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)5, (Object)da1.getB(), null, (int)4, null);
        A a8 = da1.getA();
        AssertionsKt.assertEquals$default((Object)4, (Object)(a8 != null ? Integer.valueOf(a8.getB()) : null), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)3, (Object)((a6 = da1.getA()) != null && (a6 = a6.getA()) != null ? Integer.valueOf(a6.getB()) : null), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)2, (a5 = da1.getA()) != null && (a5 = a5.getA()) != null && (a5 = a5.getA()) != null ? Integer.valueOf(a5.getB()) : null, null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)1, (a4 = da1.getA()) != null && (a4 = a4.getA()) != null && (a4 = a4.getA()) != null && (a4 = a4.getA()) != null ? Integer.valueOf(a4.getB()) : null, null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)5, (Object)da2.getB(), null, (int)4, null);
        A a9 = da2.getA();
        AssertionsKt.assertEquals$default((Object)4, (Object)(a9 != null ? Integer.valueOf(a9.getB()) : null), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)3, (Object)((a3 = da2.getA()) != null && (a3 = a3.getA()) != null ? Integer.valueOf(a3.getB()) : null), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)2, (a2 = da2.getA()) != null && (a2 = a2.getA()) != null && (a2 = a2.getA()) != null ? Integer.valueOf(a2.getB()) : null, null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)1, (a = da2.getA()) != null && (a = a.getA()) != null && (a = a.getA()) != null && (a = a.getA()) != null ? Integer.valueOf(a.getB()) : null, null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void arrayOfByteArray() {
        byte[] ba1 = new byte[]{1, 5, 15};
        byte[] ba2 = new byte[]{8, 12, 14};
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0017\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0012\n\u0002\b\u0005*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0019\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"net/corda/serialization/internal/amqp/DeserializeSimpleTypesTests$arrayOfByteArray$A", "", "a", "", "", "([[B)V", "getA", "()[[B", "[[B", "serialization"})
        public final class A {
            @NotNull
            private final byte[][] a;

            @NotNull
            public final byte[][] getA() {
                return this.a;
            }

            public A(@NotNull byte[][] a) {
                Intrinsics.checkParameterIsNotNull((Object)a, (String)"a");
                this.a = a;
            }
        }
        A a = new A(new byte[][]{ba1, ba2});
        BytesAndSchemas serializedA = AMQPTestUtilsKt.serializeAndReturnSchema$default(new TestSerializationOutput(false, this.sf1), a, null, 2, null);
        Iterable $receiver$iv = serializedA.getSchema().getTypes();
        for (Object element$iv : $receiver$iv) {
            TypeNotation it = (TypeNotation)element$iv;
            System.out.println(it);
        }
        $receiver$iv = new DeserializationInput(this.sf1);
        SerializedBytes bytes$iv = serializedA.getObj();
        SerializationContext context$iv = null;
        $receiver$iv.deserialize((ByteSequence)bytes$iv, A.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        $receiver$iv = new DeserializationInput(this.sf2);
        bytes$iv = serializedA.getObj();
        context$iv = null;
        $receiver$iv.deserialize((ByteSequence)bytes$iv, A.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
    }

    @Test(timeout=300000L)
    public final void classHasNoPublicConstructor() {
        this.assertFailsWithMessage("Unable to create an object serializer for type class " + Garbo.class.getName() + ":\nMandatory constructor parameters [value] are missing from the readable properties []\n\nEither provide getters or readable fields for [value], or provide a custom serializer for this type\n\nNo custom serializers registered.\n", (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ DeserializeSimpleTypesTests this$0;

            public final void invoke() {
                AMQPTestUtilsKt.serializeAndReturnSchema$default(new TestSerializationOutput(false, this.this$0.getSf1()), Garbo.Companion.make(1), null, 2, null);
            }
            {
                this.this$0 = deserializeSimpleTypesTests;
                super(0);
            }
        }));
    }

    @Test(timeout=300000L)
    public final void propertyClassHasNoPublicConstructor() {
        this.assertFailsWithMessage("Unable to create an object serializer for type class " + Greta.class.getName() + ":\nHas properties [garbo] of types that are not serializable:\ngarbo [class " + Garbo.class.getName() + "]: Mandatory constructor parameters [value] are missing from the readable properties []\n\nEither ensure that the properties [garbo] are serializable, or provide a custom serializer for this type\n\nNo custom serializers registered.\n", (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ DeserializeSimpleTypesTests this$0;

            public final void invoke() {
                AMQPTestUtilsKt.serializeAndReturnSchema$default(new TestSerializationOutput(false, this.this$0.getSf1()), new Greta(Garbo.Companion.make(1)), null, 2, null);
            }
            {
                this.this$0 = deserializeSimpleTypesTests;
                super(0);
            }
        }));
    }

    @Test(timeout=300000L)
    public final void notWhitelistedError() {
        SerializerFactory factory = AMQPTestUtilsKt.testDefaultFactoryWithWhitelist$default(null, 1, null);
        this.assertFailsWithMessage("Class \"class " + PropertyWithoutCordaSerializable.class.getName() + "\" " + "is not on the whitelist or annotated with @CordaSerializable.", (Function0<Unit>)((Function0)new Function0<Unit>(factory){
            final /* synthetic */ SerializerFactory $factory;

            public final void invoke() {
                new TestSerializationOutput(false, this.$factory).serialize(new PropertyWithoutCordaSerializable(1));
            }
            {
                this.$factory = serializerFactory;
                super(0);
            }
        }));
    }

    @Test(timeout=300000L)
    public final void propertyClassNotWhitelistedError() {
        SerializerFactory factory = AMQPTestUtilsKt.testDefaultFactoryWithWhitelist$default(null, 1, null);
        this.assertFailsWithMessage("Class \"class " + PropertyWithoutCordaSerializable.class.getName() + "\" " + "is not on the whitelist or annotated with @CordaSerializable.", (Function0<Unit>)((Function0)new Function0<Unit>(factory){
            final /* synthetic */ SerializerFactory $factory;

            public final void invoke() {
                new TestSerializationOutput(false, this.$factory).serialize(new Owner(new PropertyWithoutCordaSerializable(1)));
            }
            {
                this.$factory = serializerFactory;
                super(0);
            }
        }));
    }

    @Test(timeout=300000L)
    public final void comparableNotWhitelistedOk() {
        SerializerFactory factory = AMQPTestUtilsKt.testDefaultFactoryWithWhitelist$default(null, 1, null);
        @CordaSerializable
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005*\u0002\u0000\u0004\b\u000b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"net/corda/serialization/internal/amqp/DeserializeSimpleTypesTests$comparableNotWhitelistedOk$OkComparable", "", "value", "Ljava/lang/Comparable;", "net/corda/serialization/internal/amqp/DeserializeSimpleTypesTests$comparableNotWhitelistedOk$Ok", "(Ljava/lang/Comparable;)V", "getValue", "()Ljava/lang/Comparable;", "serialization"})
        public final class OkComparable {
            @NotNull
            private final Comparable<Ok> value;

            @NotNull
            public final Comparable<Ok> getValue() {
                @CordaSerializable
                @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003*\u0001\u0000\b\u000b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"net/corda/serialization/internal/amqp/DeserializeSimpleTypesTests$comparableNotWhitelistedOk$Ok", "Ljava/lang/Comparable;", "value", "", "(Ljava/lang/String;)V", "getValue", "()Ljava/lang/String;", "compareTo", "", "o", "(Lnet/corda/serialization/internal/amqp/DeserializeSimpleTypesTests$comparableNotWhitelistedOk$Ok;)I", "serialization"})
                public final class Ok
                implements Comparable<Ok> {
                    @NotNull
                    private final String value;

                    public int compareTo(@Nullable Ok o) {
                        Object object = o;
                        if (object == null || (object = ((Ok)object).value) == null) {
                            object = "";
                        }
                        return this.value.compareTo((String)object);
                    }

                    @NotNull
                    public final String getValue() {
                        return this.value;
                    }

                    public Ok(@NotNull String value) {
                        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                        this.value = value;
                    }
                }
                return this.value;
            }

            public OkComparable(@NotNull Comparable<Ok> value) {
                Intrinsics.checkParameterIsNotNull(value, (String)"value");
                this.value = value;
            }
        }
        new TestSerializationOutput(false, factory).serialize(new OkComparable(new Ok("value")));
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003*\u0001\u0000\b\n\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"net/corda/serialization/internal/amqp/DeserializeSimpleTypesTests$comparableNotWhitelistedOk$NotOk", "Ljava/lang/Comparable;", "value", "", "(Ljava/lang/String;)V", "getValue", "()Ljava/lang/String;", "compareTo", "", "o", "(Lnet/corda/serialization/internal/amqp/DeserializeSimpleTypesTests$comparableNotWhitelistedOk$NotOk;)I", "serialization"})
        public final class NotOk
        implements Comparable<NotOk> {
            @NotNull
            private final String value;

            public int compareTo(@Nullable NotOk o) {
                Object object = o;
                if (object == null || (object = ((NotOk)object).value) == null) {
                    object = "";
                }
                return this.value.compareTo((String)object);
            }

            @NotNull
            public final String getValue() {
                return this.value;
            }

            public NotOk(@NotNull String value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                this.value = value;
            }
        }
        this.assertFailsWithMessage("Class \"class " + NotOk.class.getName() + "\" " + "is not on the whitelist or annotated with @CordaSerializable.", (Function0<Unit>)((Function0)new Function0<Unit>(factory){
            final /* synthetic */ SerializerFactory $factory;

            public final void invoke() {
                @CordaSerializable
                @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005*\u0002\u0000\u0004\b\u000b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"net/corda/serialization/internal/amqp/DeserializeSimpleTypesTests$comparableNotWhitelistedOk$NotOkComparable", "", "value", "Ljava/lang/Comparable;", "net/corda/serialization/internal/amqp/DeserializeSimpleTypesTests$comparableNotWhitelistedOk$NotOk", "(Ljava/lang/Comparable;)V", "getValue", "()Ljava/lang/Comparable;", "serialization"})
                public final class NotOkComparable {
                    @NotNull
                    private final Comparable<NotOk> value;

                    @NotNull
                    public final Comparable<NotOk> getValue() {
                        return this.value;
                    }

                    public NotOkComparable(@NotNull Comparable<NotOk> value) {
                        Intrinsics.checkParameterIsNotNull(value, (String)"value");
                        this.value = value;
                    }
                }
                new TestSerializationOutput(false, this.$factory).serialize(new NotOkComparable(new NotOk("value")));
            }
            {
                this.$factory = serializerFactory;
                super(0);
            }
        }));
    }

    private final void assertFailsWithMessage(String expectedMessage, Function0<Unit> block) {
        try {
            block.invoke();
            Void void_ = AssertionsKt.fail((String)"Expected an exception, but none was thrown");
            throw null;
        }
        catch (Exception e2) {
            AssertionsKt.assertEquals$default((Object)expectedMessage, (Object)e2.getMessage(), null, (int)4, null);
            return;
        }
    }

    @CordaSerializable
    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00052\u00020\u0001:\u0001\u0005B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0006"}, d2={"Lnet/corda/serialization/internal/amqp/DeserializeSimpleTypesTests$Garbo;", "", "value", "", "(I)V", "Companion", "serialization"})
    public static final class Garbo {
        public static final Companion Companion = new Companion(null);

        private Garbo(int value) {
        }

        public /* synthetic */ Garbo(int value, DefaultConstructorMarker $constructor_marker) {
            this(value);
        }

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lnet/corda/serialization/internal/amqp/DeserializeSimpleTypesTests$Garbo$Companion;", "", "()V", "make", "Lnet/corda/serialization/internal/amqp/DeserializeSimpleTypesTests$Garbo;", "value", "", "serialization"})
        public static final class Companion {
            @NotNull
            public final Garbo make(int value) {
                return new Garbo(value, null);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @CordaSerializable
    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lnet/corda/serialization/internal/amqp/DeserializeSimpleTypesTests$Greta;", "", "garbo", "Lnet/corda/serialization/internal/amqp/DeserializeSimpleTypesTests$Garbo;", "(Lnet/corda/serialization/internal/amqp/DeserializeSimpleTypesTests$Garbo;)V", "getGarbo", "()Lnet/corda/serialization/internal/amqp/DeserializeSimpleTypesTests$Garbo;", "serialization"})
    public static final class Greta {
        @NotNull
        private final Garbo garbo;

        @NotNull
        public final Garbo getGarbo() {
            return this.garbo;
        }

        public Greta(@NotNull Garbo garbo) {
            Intrinsics.checkParameterIsNotNull((Object)garbo, (String)"garbo");
            this.garbo = garbo;
        }
    }

    @CordaSerializable
    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lnet/corda/serialization/internal/amqp/DeserializeSimpleTypesTests$Owner;", "", "value", "Lnet/corda/serialization/internal/amqp/DeserializeSimpleTypesTests$PropertyWithoutCordaSerializable;", "(Lnet/corda/serialization/internal/amqp/DeserializeSimpleTypesTests$PropertyWithoutCordaSerializable;)V", "getValue", "()Lnet/corda/serialization/internal/amqp/DeserializeSimpleTypesTests$PropertyWithoutCordaSerializable;", "serialization"})
    public static final class Owner {
        @NotNull
        private final PropertyWithoutCordaSerializable value;

        @NotNull
        public final PropertyWithoutCordaSerializable getValue() {
            return this.value;
        }

        public Owner(@NotNull PropertyWithoutCordaSerializable value) {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            this.value = value;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lnet/corda/serialization/internal/amqp/DeserializeSimpleTypesTests$PropertyWithoutCordaSerializable;", "", "value", "", "(I)V", "getValue", "()I", "serialization"})
    public static final class PropertyWithoutCordaSerializable {
        private final int value;

        public final int getValue() {
            return this.value;
        }

        public PropertyWithoutCordaSerializable(int value) {
            this.value = value;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnet/corda/serialization/internal/amqp/DeserializeSimpleTypesTests$Companion;", "", "()V", "VERBOSE", "", "serialization"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

