/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp;

import java.io.NotSerializableException;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.test.AssertionsKt;
import net.corda.core.serialization.ClassWhitelist;
import net.corda.core.serialization.CordaSerializable;
import net.corda.core.serialization.SerializationContext;
import net.corda.core.serialization.SerializedBytes;
import net.corda.core.utilities.ByteSequence;
import net.corda.serialization.internal.AllWhitelist;
import net.corda.serialization.internal.amqp.DeserializationInput;
import net.corda.serialization.internal.amqp.DeserializeNeedingCarpentryTests;
import net.corda.serialization.internal.amqp.I;
import net.corda.serialization.internal.amqp.SerializerFactory;
import net.corda.serialization.internal.amqp.SerializerFactoryBuilder;
import net.corda.serialization.internal.amqp.testutils.AMQPTestUtilsKt;
import net.corda.serialization.internal.amqp.testutils.TestSerializationContextKt;
import net.corda.serialization.internal.amqp.testutils.TestSerializationOutput;
import net.corda.serialization.internal.carpenter.AmqpCarpenterBase;
import net.corda.serialization.internal.carpenter.ClassCarpenter;
import net.corda.serialization.internal.carpenter.ClassCarpenterImpl;
import net.corda.serialization.internal.carpenter.ClassSchema;
import net.corda.serialization.internal.carpenter.InterfaceSchema;
import net.corda.serialization.internal.carpenter.NonNullableField;
import net.corda.serialization.internal.carpenter.Schema;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0007J\b\u0010\b\u001a\u00020\u0007H\u0007J\b\u0010\t\u001a\u00020\u0007H\u0007J\b\u0010\n\u001a\u00020\u0007H\u0007J\b\u0010\u000b\u001a\u00020\u0007H\u0007J\b\u0010\f\u001a\u00020\u0007H\u0007J\b\u0010\r\u001a\u00020\u0007H\u0007J\b\u0010\u000e\u001a\u00020\u0007H\u0007J\b\u0010\u000f\u001a\u00020\u0007H\u0007J8\u0010\u0010\u001a\u0002H\u0011\"\n\b\u0000\u0010\u0011\u0018\u0001*\u00020\u0012*\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00110\u00152\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0082\b\u00a2\u0006\u0002\u0010\u0018R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lnet/corda/serialization/internal/amqp/DeserializeNeedingCarpentryTests;", "Lnet/corda/serialization/internal/carpenter/AmqpCarpenterBase;", "()V", "sf1", "Lnet/corda/serialization/internal/amqp/SerializerFactory;", "sf2", "arrayOfTypes", "", "listOfType", "nestedTypes", "repeatedNestedTypes", "repeatedTypesAreRecognised", "reusedClasses", "simpleTypeKnownInterface", "unknownInterface", "verySimpleType", "deserializeWithoutAndWithCarpenter", "T", "", "Lnet/corda/serialization/internal/amqp/DeserializationInput;", "bytes", "Lnet/corda/core/serialization/SerializedBytes;", "context", "Lnet/corda/core/serialization/SerializationContext;", "(Lnet/corda/serialization/internal/amqp/DeserializationInput;Lnet/corda/core/serialization/SerializedBytes;Lnet/corda/core/serialization/SerializationContext;)Ljava/lang/Object;", "Companion", "serialization"})
public final class DeserializeNeedingCarpentryTests
extends AmqpCarpenterBase {
    private final SerializerFactory sf1 = AMQPTestUtilsKt.testDefaultFactoryNoEvolution$default(null, 1, null);
    private final SerializerFactory sf2 = AMQPTestUtilsKt.testDefaultFactoryWithWhitelist$default(null, 1, null);
    private static final boolean VERBOSE = false;
    public static final Companion Companion = new Companion(null);

    private final <T> T deserializeWithoutAndWithCarpenter(@NotNull DeserializationInput $receiver, SerializedBytes<T> bytes, SerializationContext context) {
        KClass kClass = Reflection.getOrCreateKotlinClass(NotSerializableException.class);
        Intrinsics.needClassReification();
        AssertionsKt.assertFailsWith((KClass)kClass, (Function0)((Function0)new Function0<Unit>($receiver, bytes, context){
            final /* synthetic */ DeserializationInput receiver$0;
            final /* synthetic */ SerializedBytes $bytes;
            final /* synthetic */ SerializationContext $context;

            public final void invoke() {
                ByteSequence byteSequence = (ByteSequence)this.$bytes;
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                SerializationContext serializationContext = this.$context;
                if (serializationContext == null) {
                    serializationContext = (SerializationContext)TestSerializationContextKt.getTestSerializationContext();
                }
                this.receiver$0.deserialize(byteSequence, Object.class, serializationContext.withoutCarpenter());
            }
            {
                this.receiver$0 = deserializationInput;
                this.$bytes = serializedBytes;
                this.$context = serializationContext;
                super(0);
            }
        }));
        ByteSequence byteSequence = (ByteSequence)bytes;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        SerializationContext serializationContext = context;
        if (serializationContext == null) {
            serializationContext = (SerializationContext)TestSerializationContextKt.getTestSerializationContext();
        }
        return (T)$receiver.deserialize(byteSequence, Object.class, serializationContext);
    }

    static /* bridge */ /* synthetic */ Object deserializeWithoutAndWithCarpenter$default(DeserializeNeedingCarpentryTests this_, DeserializationInput $receiver, SerializedBytes bytes, SerializationContext context, int n, Object object) {
        if ((n & 2) != 0) {
            context = null;
        }
        KClass kClass = Reflection.getOrCreateKotlinClass(NotSerializableException.class);
        Intrinsics.needClassReification();
        AssertionsKt.assertFailsWith((KClass)kClass, (Function0)((Function0)new /* invalid duplicate definition of identical inner class */));
        ByteSequence byteSequence = (ByteSequence)bytes;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        SerializationContext serializationContext = context;
        if (serializationContext == null) {
            serializationContext = (SerializationContext)TestSerializationContextKt.getTestSerializationContext();
        }
        return $receiver.deserialize(byteSequence, Object.class, serializationContext);
    }

    @Test(timeout=300000L)
    public final void verySimpleType() {
        DeserializationInput $receiver$iv;
        int testVal = 10;
        Class clazz = new ClassCarpenterImpl((ClassWhitelist)AllWhitelist.INSTANCE, null, false, 6, null).build((Schema)new ClassSchema(AMQPTestUtilsKt.testName(), MapsKt.mapOf((Pair)TuplesKt.to((Object)"a", (Object)new NonNullableField(Integer.TYPE))), null, null, 12, null));
        Object classInstance = clazz.getConstructors()[0].newInstance(testVal);
        SerializedBytes<?> serialisedBytes = new TestSerializationOutput(false, this.sf1).serialize(classInstance);
        DeserializationInput $receiver$iv2 = new DeserializationInput(this.sf1);
        SerializationContext context$iv = null;
        Object deserializedObj1 = $receiver$iv2.deserialize((ByteSequence)serialisedBytes, Object.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)clazz, deserializedObj1.getClass(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)testVal, (Object)deserializedObj1.getClass().getMethod("getA", new Class[0]).invoke(deserializedObj1, new Object[0]), null, (int)4, null);
        DeserializationInput $receiver$iv3 = new DeserializationInput(this.sf1);
        SerializationContext context$iv2 = null;
        Object deserializedObj2 = $receiver$iv3.deserialize((ByteSequence)serialisedBytes, Object.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)clazz, deserializedObj2.getClass(), null, (int)4, null);
        AssertionsKt.assertEquals$default(deserializedObj1.getClass(), deserializedObj2.getClass(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)testVal, (Object)deserializedObj2.getClass().getMethod("getA", new Class[0]).invoke(deserializedObj2, new Object[0]), null, (int)4, null);
        DeserializationInput $i$f$deserialize = new DeserializationInput(this.sf2);
        DeserializeNeedingCarpentryTests this_$iv = this;
        SerializationContext context$iv3 = null;
        AssertionsKt.assertFailsWith((KClass)Reflection.getOrCreateKotlinClass(NotSerializableException.class), (Function0)((Function0)new Function0<Unit>($receiver$iv, serialisedBytes, context$iv3){
            final /* synthetic */ DeserializationInput receiver$0;
            final /* synthetic */ SerializedBytes $bytes;
            final /* synthetic */ SerializationContext $context;
            {
                this.receiver$0 = deserializationInput;
                this.$bytes = serializedBytes;
                this.$context = serializationContext;
                super(0);
            }

            public final void invoke() {
                ByteSequence byteSequence = (ByteSequence)this.$bytes;
                SerializationContext serializationContext = this.$context;
                if (serializationContext == null) {
                    serializationContext = (SerializationContext)TestSerializationContextKt.getTestSerializationContext();
                }
                this.receiver$0.deserialize(byteSequence, Object.class, serializationContext.withoutCarpenter());
            }
        }));
        Object deserializedObj3 = $receiver$iv.deserialize((ByteSequence)serialisedBytes, Object.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertNotEquals$default((Object)clazz, deserializedObj3.getClass(), null, (int)4, null);
        AssertionsKt.assertNotEquals$default(deserializedObj1.getClass(), deserializedObj3.getClass(), null, (int)4, null);
        AssertionsKt.assertNotEquals$default(deserializedObj2.getClass(), deserializedObj3.getClass(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)testVal, (Object)deserializedObj3.getClass().getMethod("getA", new Class[0]).invoke(deserializedObj3, new Object[0]), null, (int)4, null);
        $receiver$iv = new DeserializationInput(this.sf2);
        context$iv3 = null;
        Object deserializedObj4 = $receiver$iv.deserialize((ByteSequence)serialisedBytes, Object.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertNotEquals$default((Object)clazz, deserializedObj4.getClass(), null, (int)4, null);
        AssertionsKt.assertNotEquals$default(deserializedObj1.getClass(), deserializedObj4.getClass(), null, (int)4, null);
        AssertionsKt.assertNotEquals$default(deserializedObj2.getClass(), deserializedObj4.getClass(), null, (int)4, null);
        AssertionsKt.assertEquals$default(deserializedObj3.getClass(), deserializedObj4.getClass(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)testVal, (Object)deserializedObj4.getClass().getMethod("getA", new Class[0]).invoke(deserializedObj4, new Object[0]), null, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void repeatedTypesAreRecognised() {
        void bytes$iv;
        void $receiver$iv;
        SerializedBytes<?> bytes$iv2;
        DeserializationInput $receiver$iv2;
        int testValA = 10;
        int testValB = 20;
        int testValC = 20;
        Class clazz = new ClassCarpenterImpl((ClassWhitelist)AllWhitelist.INSTANCE, null, false, 6, null).build((Schema)new ClassSchema(AMQPTestUtilsKt.testName() + "_clazz", MapsKt.mapOf((Pair)TuplesKt.to((Object)"a", (Object)new NonNullableField(Integer.TYPE))), null, null, 12, null));
        Object concreteA = clazz.getConstructors()[0].newInstance(testValA);
        Object concreteB = clazz.getConstructors()[0].newInstance(testValB);
        Object concreteC = clazz.getConstructors()[0].newInstance(testValC);
        DeserializationInput deserializationInput = new DeserializationInput(this.sf2);
        DeserializeNeedingCarpentryTests deserializeNeedingCarpentryTests = this;
        SerializedBytes<?> serializedBytes = new TestSerializationOutput(false, this.sf1).serialize(concreteA);
        SerializationContext context$iv = null;
        AssertionsKt.assertFailsWith((KClass)Reflection.getOrCreateKotlinClass(NotSerializableException.class), (Function0)((Function0)new Function0<Unit>($receiver$iv2, (SerializedBytes)bytes$iv2, context$iv){
            final /* synthetic */ DeserializationInput receiver$0;
            final /* synthetic */ SerializedBytes $bytes;
            final /* synthetic */ SerializationContext $context;
            {
                this.receiver$0 = deserializationInput;
                this.$bytes = serializedBytes;
                this.$context = serializationContext;
                super(0);
            }

            public final void invoke() {
                ByteSequence byteSequence = (ByteSequence)this.$bytes;
                SerializationContext serializationContext = this.$context;
                if (serializationContext == null) {
                    serializationContext = (SerializationContext)TestSerializationContextKt.getTestSerializationContext();
                }
                this.receiver$0.deserialize(byteSequence, Object.class, serializationContext.withoutCarpenter());
            }
        }));
        Object deserialisedA = $receiver$iv2.deserialize((ByteSequence)bytes$iv2, Object.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)testValA, (Object)deserialisedA.getClass().getMethod("getA", new Class[0]).invoke(deserialisedA, new Object[0]), null, (int)4, null);
        $receiver$iv2 = new DeserializationInput(this.sf2);
        bytes$iv2 = new TestSerializationOutput(false, this.sf1).serialize(concreteB);
        context$iv = null;
        Object deserialisedB = $receiver$iv2.deserialize((ByteSequence)bytes$iv2, Object.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)testValB, (Object)deserialisedA.getClass().getMethod("getA", new Class[0]).invoke(deserialisedB, new Object[0]), null, (int)4, null);
        AssertionsKt.assertEquals$default(deserialisedA.getClass(), deserialisedB.getClass(), null, (int)4, null);
        ClassWhitelist classWhitelist = (ClassWhitelist)AllWhitelist.INSTANCE;
        ClassWhitelist classWhitelist2 = (ClassWhitelist)AllWhitelist.INSTANCE;
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        Intrinsics.checkExpressionValueIsNotNull((Object)classLoader, (String)"ClassLoader.getSystemClassLoader()");
        SerializerFactory lfactory = SerializerFactoryBuilder.build((ClassWhitelist)classWhitelist, (ClassCarpenter)((ClassCarpenter)new ClassCarpenterImpl(classWhitelist2, classLoader, false, 4, null)));
        context$iv = new DeserializationInput(lfactory);
        SerializedBytes<?> $i$f$deserialize = new TestSerializationOutput(false, lfactory).serialize(concreteC);
        SerializationContext context$iv2 = null;
        Object deserialisedC = $receiver$iv.deserialize((ByteSequence)bytes$iv, Object.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)testValC, (Object)deserialisedC.getClass().getMethod("getA", new Class[0]).invoke(deserialisedC, new Object[0]), null, (int)4, null);
        AssertionsKt.assertNotEquals$default(deserialisedA.getClass(), deserialisedC.getClass(), null, (int)4, null);
        AssertionsKt.assertNotEquals$default(deserialisedB.getClass(), deserialisedC.getClass(), null, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void simpleTypeKnownInterface() {
        void $receiver$iv;
        Class clazz = new ClassCarpenterImpl((ClassWhitelist)AllWhitelist.INSTANCE, null, false, 6, null).build((Schema)new ClassSchema(AMQPTestUtilsKt.testName(), MapsKt.mapOf((Pair)TuplesKt.to((Object)"name", (Object)new NonNullableField(String.class))), null, CollectionsKt.listOf(I.class), 4, null));
        String testVal = "Some Person";
        Object classInstance = clazz.getConstructors()[0].newInstance(testVal);
        SerializedBytes<?> serialisedBytes = new TestSerializationOutput(false, this.sf1).serialize(classInstance);
        DeserializationInput deserializationInput = new DeserializationInput(this.sf2);
        DeserializeNeedingCarpentryTests this_$iv = this;
        SerializationContext context$iv = null;
        AssertionsKt.assertFailsWith((KClass)Reflection.getOrCreateKotlinClass(NotSerializableException.class), (Function0)((Function0)new Function0<Unit>((DeserializationInput)$receiver$iv, serialisedBytes, context$iv){
            final /* synthetic */ DeserializationInput receiver$0;
            final /* synthetic */ SerializedBytes $bytes;
            final /* synthetic */ SerializationContext $context;
            {
                this.receiver$0 = deserializationInput;
                this.$bytes = serializedBytes;
                this.$context = serializationContext;
                super(0);
            }

            public final void invoke() {
                ByteSequence byteSequence = (ByteSequence)this.$bytes;
                SerializationContext serializationContext = this.$context;
                if (serializationContext == null) {
                    serializationContext = (SerializationContext)TestSerializationContextKt.getTestSerializationContext();
                }
                this.receiver$0.deserialize(byteSequence, Object.class, serializationContext.withoutCarpenter());
            }
        }));
        Object deserializedObj = $receiver$iv.deserialize((ByteSequence)serialisedBytes, Object.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertTrue$default((boolean)(deserializedObj instanceof I), null, (int)2, null);
        Object object = deserializedObj;
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.corda.serialization.internal.amqp.I");
        }
        AssertionsKt.assertEquals$default((Object)testVal, (Object)((I)object).getName(), null, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void arrayOfTypes() {
        void bytes$iv;
        void $receiver$iv;
        Class clazz = new ClassCarpenterImpl((ClassWhitelist)AllWhitelist.INSTANCE, null, false, 6, null).build((Schema)new ClassSchema(AMQPTestUtilsKt.testName(), MapsKt.mapOf((Pair)TuplesKt.to((Object)"a", (Object)new NonNullableField(Integer.TYPE))), null, null, 12, null));
        Object[] objectArray = new Object[3];
        Object obj = clazz.getConstructors()[0].newInstance(1);
        Intrinsics.checkExpressionValueIsNotNull(obj, (String)"clazz.constructors[0].newInstance(1)");
        objectArray[0] = obj;
        Object obj2 = clazz.getConstructors()[0].newInstance(2);
        Intrinsics.checkExpressionValueIsNotNull(obj2, (String)"clazz.constructors[0].newInstance(2)");
        objectArray[1] = obj2;
        Object obj3 = clazz.getConstructors()[0].newInstance(3);
        Intrinsics.checkExpressionValueIsNotNull(obj3, (String)"clazz.constructors[0].newInstance(3)");
        objectArray[2] = obj3;
        @CordaSerializable
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000'\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008b\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0019\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"net/corda/serialization/internal/amqp/DeserializeNeedingCarpentryTests$arrayOfTypes$Outer", "", "a", "", "([Ljava/lang/Object;)V", "getA", "()[Ljava/lang/Object;", "[Ljava/lang/Object;", "component1", "copy", "([Ljava/lang/Object;)Lnet/corda/serialization/internal/amqp/DeserializeNeedingCarpentryTests$arrayOfTypes$Outer;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
        public final class Outer {
            @NotNull
            private final Object[] a;

            @NotNull
            public final Object[] getA() {
                return this.a;
            }

            public Outer(@NotNull Object[] a) {
                Intrinsics.checkParameterIsNotNull((Object)a, (String)"a");
                this.a = a;
            }

            @NotNull
            public final Object[] component1() {
                return this.a;
            }

            @NotNull
            public final Outer copy(@NotNull Object[] a) {
                Intrinsics.checkParameterIsNotNull((Object)a, (String)"a");
                return new Outer(a);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ Outer copy$default(Outer outer2, Object[] objectArray, int n, Object object) {
                if ((n & 1) != 0) {
                    objectArray = outer2.a;
                }
                return outer2.copy(objectArray);
            }

            @NotNull
            public String toString() {
                return "Outer(a=" + Arrays.toString(this.a) + ")";
            }

            public int hashCode() {
                return this.a != null ? Arrays.hashCode(this.a) : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Outer)) break block3;
                        Outer outer2 = (Outer)object;
                        if (!Intrinsics.areEqual((Object)this.a, (Object)outer2.a)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        Outer outer2 = new Outer(objectArray);
        DeserializationInput deserializationInput = new DeserializationInput(this.sf2);
        DeserializeNeedingCarpentryTests deserializeNeedingCarpentryTests = this;
        SerializedBytes<Outer> serializedBytes = new TestSerializationOutput(false, this.sf1).serialize(outer2);
        SerializationContext context$iv = null;
        AssertionsKt.assertFailsWith((KClass)Reflection.getOrCreateKotlinClass(NotSerializableException.class), (Function0)((Function0)new Function0<Unit>((DeserializationInput)$receiver$iv, (SerializedBytes)bytes$iv, context$iv){
            final /* synthetic */ DeserializationInput receiver$0;
            final /* synthetic */ SerializedBytes $bytes;
            final /* synthetic */ SerializationContext $context;
            {
                this.receiver$0 = deserializationInput;
                this.$bytes = serializedBytes;
                this.$context = serializationContext;
                super(0);
            }

            public final void invoke() {
                ByteSequence byteSequence = (ByteSequence)this.$bytes;
                SerializationContext serializationContext = this.$context;
                if (serializationContext == null) {
                    serializationContext = (SerializationContext)TestSerializationContextKt.getTestSerializationContext();
                }
                this.receiver$0.deserialize(byteSequence, Outer.class, serializationContext.withoutCarpenter());
            }
        }));
        Outer deserializedObj = (Outer)$receiver$iv.deserialize((ByteSequence)bytes$iv, Outer.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertNotEquals$default(deserializedObj.getA()[0].getClass(), outer2.getA()[0].getClass(), null, (int)4, null);
        AssertionsKt.assertNotEquals$default(deserializedObj.getA()[1].getClass(), outer2.getA()[1].getClass(), null, (int)4, null);
        AssertionsKt.assertNotEquals$default(deserializedObj.getA()[2].getClass(), outer2.getA()[2].getClass(), null, (int)4, null);
        AssertionsKt.assertEquals$default(deserializedObj.getA()[0].getClass(), deserializedObj.getA()[1].getClass(), null, (int)4, null);
        AssertionsKt.assertEquals$default(deserializedObj.getA()[0].getClass(), deserializedObj.getA()[2].getClass(), null, (int)4, null);
        AssertionsKt.assertEquals$default(deserializedObj.getA()[1].getClass(), deserializedObj.getA()[2].getClass(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)outer2.getA()[0].getClass().getMethod("getA", new Class[0]).invoke(outer2.getA()[0], new Object[0]), (Object)deserializedObj.getA()[0].getClass().getMethod("getA", new Class[0]).invoke(deserializedObj.getA()[0], new Object[0]), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)outer2.getA()[1].getClass().getMethod("getA", new Class[0]).invoke(outer2.getA()[1], new Object[0]), (Object)deserializedObj.getA()[1].getClass().getMethod("getA", new Class[0]).invoke(deserializedObj.getA()[1], new Object[0]), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)outer2.getA()[2].getClass().getMethod("getA", new Class[0]).invoke(outer2.getA()[2], new Object[0]), (Object)deserializedObj.getA()[2].getClass().getMethod("getA", new Class[0]).invoke(deserializedObj.getA()[2], new Object[0]), null, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void reusedClasses() {
        void $receiver$iv;
        void $receiver$iv2;
        ClassCarpenterImpl cc = new ClassCarpenterImpl((ClassWhitelist)AllWhitelist.INSTANCE, null, false, 6, null);
        Class innerType = cc.build((Schema)new ClassSchema(AMQPTestUtilsKt.testName() + ".inner", MapsKt.mapOf((Pair)TuplesKt.to((Object)"a", (Object)new NonNullableField(Integer.TYPE))), null, null, 12, null));
        Class outerType = cc.build((Schema)new ClassSchema(AMQPTestUtilsKt.testName() + ".outer", MapsKt.mapOf((Pair)TuplesKt.to((Object)"a", (Object)new NonNullableField(innerType))), null, null, 12, null));
        Object inner = innerType.getConstructors()[0].newInstance(1);
        Object outer2 = outerType.getConstructors()[0].newInstance(innerType.getConstructors()[0].newInstance(2));
        SerializedBytes<?> serializedI = new TestSerializationOutput(false, this.sf1).serialize(inner);
        DeserializationInput deserializationInput = new DeserializationInput(this.sf2);
        DeserializeNeedingCarpentryTests this_$iv = this;
        SerializationContext context$iv = null;
        AssertionsKt.assertFailsWith((KClass)Reflection.getOrCreateKotlinClass(NotSerializableException.class), (Function0)((Function0)new Function0<Unit>((DeserializationInput)$receiver$iv2, serializedI, context$iv){
            final /* synthetic */ DeserializationInput receiver$0;
            final /* synthetic */ SerializedBytes $bytes;
            final /* synthetic */ SerializationContext $context;
            {
                this.receiver$0 = deserializationInput;
                this.$bytes = serializedBytes;
                this.$context = serializationContext;
                super(0);
            }

            public final void invoke() {
                ByteSequence byteSequence = (ByteSequence)this.$bytes;
                SerializationContext serializationContext = this.$context;
                if (serializationContext == null) {
                    serializationContext = (SerializationContext)TestSerializationContextKt.getTestSerializationContext();
                }
                this.receiver$0.deserialize(byteSequence, Object.class, serializationContext.withoutCarpenter());
            }
        }));
        Object deserialisedI = $receiver$iv2.deserialize((ByteSequence)serializedI, Object.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        SerializedBytes<?> serialisedO = new TestSerializationOutput(false, this.sf1).serialize(outer2);
        DeserializationInput $i$f$deserializeWithoutAndWithCarpenter = new DeserializationInput(this.sf2);
        DeserializeNeedingCarpentryTests this_$iv2 = this;
        SerializationContext context$iv2 = null;
        AssertionsKt.assertFailsWith((KClass)Reflection.getOrCreateKotlinClass(NotSerializableException.class), (Function0)((Function0)new Function0<Unit>((DeserializationInput)$receiver$iv, serialisedO, context$iv2){
            final /* synthetic */ DeserializationInput receiver$0;
            final /* synthetic */ SerializedBytes $bytes;
            final /* synthetic */ SerializationContext $context;
            {
                this.receiver$0 = deserializationInput;
                this.$bytes = serializedBytes;
                this.$context = serializationContext;
                super(0);
            }

            public final void invoke() {
                ByteSequence byteSequence = (ByteSequence)this.$bytes;
                SerializationContext serializationContext = this.$context;
                if (serializationContext == null) {
                    serializationContext = (SerializationContext)TestSerializationContextKt.getTestSerializationContext();
                }
                this.receiver$0.deserialize(byteSequence, Object.class, serializationContext.withoutCarpenter());
            }
        }));
        Object deserialisedO = $receiver$iv.deserialize((ByteSequence)serialisedO, Object.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default(deserialisedI.getClass(), deserialisedO.getClass().getMethod("getA", new Class[0]).invoke(deserialisedO, new Object[0]).getClass(), null, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void nestedTypes() {
        void $receiver$iv;
        ClassCarpenterImpl cc = new ClassCarpenterImpl((ClassWhitelist)AllWhitelist.INSTANCE, null, false, 6, null);
        Class nestedClass = cc.build((Schema)new ClassSchema("nestedType", MapsKt.mapOf((Pair)TuplesKt.to((Object)"name", (Object)new NonNullableField(String.class))), null, null, 12, null));
        Class outerClass = cc.build((Schema)new ClassSchema("outerType", MapsKt.mapOf((Pair)TuplesKt.to((Object)"inner", (Object)new NonNullableField(nestedClass))), null, null, 12, null));
        Object[] objectArray = outerClass.getConstructors();
        Intrinsics.checkExpressionValueIsNotNull(objectArray, (String)"outerClass.constructors");
        Constructor constructor = (Constructor)ArraysKt.first((Object[])objectArray);
        Object[] objectArray2 = new Object[1];
        Object[] objectArray3 = nestedClass.getConstructors();
        Intrinsics.checkExpressionValueIsNotNull(objectArray3, (String)"nestedClass.constructors");
        objectArray2[0] = ((Constructor)ArraysKt.first((Object[])objectArray3)).newInstance("name");
        Object classInstance = constructor.newInstance(objectArray2);
        SerializedBytes serialisedBytes = new TestSerializationOutput(false, this.sf1).serialize(classInstance);
        DeserializationInput deserializationInput = new DeserializationInput(this.sf2);
        DeserializeNeedingCarpentryTests this_$iv = this;
        SerializationContext context$iv = null;
        AssertionsKt.assertFailsWith((KClass)Reflection.getOrCreateKotlinClass(NotSerializableException.class), (Function0)((Function0)new Function0<Unit>((DeserializationInput)$receiver$iv, serialisedBytes, context$iv){
            final /* synthetic */ DeserializationInput receiver$0;
            final /* synthetic */ SerializedBytes $bytes;
            final /* synthetic */ SerializationContext $context;
            {
                this.receiver$0 = deserializationInput;
                this.$bytes = serializedBytes;
                this.$context = serializationContext;
                super(0);
            }

            public final void invoke() {
                ByteSequence byteSequence = (ByteSequence)this.$bytes;
                SerializationContext serializationContext = this.$context;
                if (serializationContext == null) {
                    serializationContext = (SerializationContext)TestSerializationContextKt.getTestSerializationContext();
                }
                this.receiver$0.deserialize(byteSequence, Object.class, serializationContext.withoutCarpenter());
            }
        }));
        Object deserializedObj = $receiver$iv.deserialize((ByteSequence)serialisedBytes, Object.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        Object inner = deserializedObj.getClass().getMethod("getInner", new Class[0]).invoke(deserializedObj, new Object[0]);
        AssertionsKt.assertEquals$default((Object)"name", (Object)inner.getClass().getMethod("getName", new Class[0]).invoke(inner, new Object[0]), null, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void repeatedNestedTypes() {
        void $receiver$iv;
        ClassCarpenterImpl cc = new ClassCarpenterImpl((ClassWhitelist)AllWhitelist.INSTANCE, null, false, 6, null);
        Class nestedClass = cc.build((Schema)new ClassSchema("nestedType", MapsKt.mapOf((Pair)TuplesKt.to((Object)"name", (Object)new NonNullableField(String.class))), null, null, 12, null));
        Object[] objectArray = nestedClass.getConstructors();
        Intrinsics.checkExpressionValueIsNotNull(objectArray, (String)"nestedClass.constructors");
        Object t = ((Constructor)ArraysKt.first((Object[])objectArray)).newInstance("foo");
        Intrinsics.checkExpressionValueIsNotNull(t, (String)"nestedClass.constructors\u2026irst().newInstance(\"foo\")");
        Object[] objectArray2 = nestedClass.getConstructors();
        Intrinsics.checkExpressionValueIsNotNull(objectArray2, (String)"nestedClass.constructors");
        Object t2 = ((Constructor)ArraysKt.first((Object[])objectArray2)).newInstance("bar");
        Intrinsics.checkExpressionValueIsNotNull(t2, (String)"nestedClass.constructors\u2026irst().newInstance(\"bar\")");
        @CordaSerializable
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000!\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008b\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0004J\t\u0010\b\u001a\u00020\u0001H\u00c6\u0003J\t\u0010\t\u001a\u00020\u0001H\u00c6\u0003J\"\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00012\b\b\u0002\u0010\u0003\u001a\u00020\u0001H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0006\u00a8\u0006\u0013"}, d2={"net/corda/serialization/internal/amqp/DeserializeNeedingCarpentryTests$repeatedNestedTypes$outer", "", "a", "b", "(Ljava/lang/Object;Ljava/lang/Object;)V", "getA", "()Ljava/lang/Object;", "getB", "component1", "component2", "copy", "(Ljava/lang/Object;Ljava/lang/Object;)Lnet/corda/serialization/internal/amqp/DeserializeNeedingCarpentryTests$repeatedNestedTypes$outer;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
        public final class Outer {
            @NotNull
            private final Object a;
            @NotNull
            private final Object b;

            @NotNull
            public final Object getA() {
                return this.a;
            }

            @NotNull
            public final Object getB() {
                return this.b;
            }

            public Outer(@NotNull Object a, @NotNull Object b) {
                Intrinsics.checkParameterIsNotNull((Object)a, (String)"a");
                Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
                this.a = a;
                this.b = b;
            }

            @NotNull
            public final Object component1() {
                return this.a;
            }

            @NotNull
            public final Object component2() {
                return this.b;
            }

            @NotNull
            public final Outer copy(@NotNull Object a, @NotNull Object b) {
                Intrinsics.checkParameterIsNotNull((Object)a, (String)"a");
                Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
                return new Outer(a, b);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ Outer copy$default(Outer outer2, Object object, Object object2, int n, Object object3) {
                if ((n & 1) != 0) {
                    object = outer2.a;
                }
                if ((n & 2) != 0) {
                    object2 = outer2.b;
                }
                return outer2.copy(object, object2);
            }

            @NotNull
            public String toString() {
                return "outer(a=" + this.a + ", b=" + this.b + ")";
            }

            public int hashCode() {
                Object object = this.a;
                Object object2 = this.b;
                return (object != null ? object.hashCode() : 0) * 31 + (object2 != null ? object2.hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Outer)) break block3;
                        Outer outer2 = (Outer)object;
                        if (!Intrinsics.areEqual((Object)this.a, (Object)outer2.a) || !Intrinsics.areEqual((Object)this.b, (Object)outer2.b)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        Outer classInstance = new Outer(t, t2);
        SerializedBytes<Outer> serialisedBytes = new TestSerializationOutput(false, this.sf1).serialize(classInstance);
        DeserializationInput deserializationInput = new DeserializationInput(this.sf2);
        DeserializeNeedingCarpentryTests this_$iv = this;
        SerializationContext context$iv = null;
        AssertionsKt.assertFailsWith((KClass)Reflection.getOrCreateKotlinClass(NotSerializableException.class), (Function0)((Function0)new Function0<Unit>((DeserializationInput)$receiver$iv, serialisedBytes, context$iv){
            final /* synthetic */ DeserializationInput receiver$0;
            final /* synthetic */ SerializedBytes $bytes;
            final /* synthetic */ SerializationContext $context;
            {
                this.receiver$0 = deserializationInput;
                this.$bytes = serializedBytes;
                this.$context = serializationContext;
                super(0);
            }

            public final void invoke() {
                ByteSequence byteSequence = (ByteSequence)this.$bytes;
                SerializationContext serializationContext = this.$context;
                if (serializationContext == null) {
                    serializationContext = (SerializationContext)TestSerializationContextKt.getTestSerializationContext();
                }
                this.receiver$0.deserialize(byteSequence, Outer.class, serializationContext.withoutCarpenter());
            }
        }));
        Outer deserializedObj = (Outer)$receiver$iv.deserialize((ByteSequence)serialisedBytes, Outer.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)"foo", (Object)deserializedObj.getA().getClass().getMethod("getName", new Class[0]).invoke(deserializedObj.getA(), new Object[0]), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)"bar", (Object)deserializedObj.getB().getClass().getMethod("getName", new Class[0]).invoke(deserializedObj.getB(), new Object[0]), null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void listOfType() {
        Iterable $receiver$iv;
        Class unknownClass = new ClassCarpenterImpl((ClassWhitelist)AllWhitelist.INSTANCE, null, false, 6, null).build((Schema)new ClassSchema(AMQPTestUtilsKt.testName(), MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"v1", (Object)new NonNullableField(Integer.TYPE)), TuplesKt.to((Object)"v2", (Object)new NonNullableField(Integer.TYPE))}), null, null, 12, null));
        Object[] objectArray = new Object[4];
        Object[] objectArray2 = unknownClass.getConstructors();
        Intrinsics.checkExpressionValueIsNotNull(objectArray2, (String)"unknownClass.constructors");
        objectArray[0] = ((Constructor)ArraysKt.first((Object[])objectArray2)).newInstance(1, 2);
        Object[] objectArray3 = unknownClass.getConstructors();
        Intrinsics.checkExpressionValueIsNotNull(objectArray3, (String)"unknownClass.constructors");
        objectArray[1] = ((Constructor)ArraysKt.first((Object[])objectArray3)).newInstance(3, 4);
        Object[] objectArray4 = unknownClass.getConstructors();
        Intrinsics.checkExpressionValueIsNotNull(objectArray4, (String)"unknownClass.constructors");
        objectArray[2] = ((Constructor)ArraysKt.first((Object[])objectArray4)).newInstance(5, 6);
        Object[] objectArray5 = unknownClass.getConstructors();
        Intrinsics.checkExpressionValueIsNotNull(objectArray5, (String)"unknownClass.constructors");
        objectArray[3] = ((Constructor)ArraysKt.first((Object[])objectArray5)).newInstance(7, 8);
        @CordaSerializable
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000'\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008b\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u000f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003H\u00c6\u0003J\u001e\u0010\b\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"net/corda/serialization/internal/amqp/DeserializeNeedingCarpentryTests$listOfType$outer", "", "l", "", "(Ljava/util/List;)V", "getL", "()Ljava/util/List;", "component1", "copy", "(Ljava/util/List;)Lnet/corda/serialization/internal/amqp/DeserializeNeedingCarpentryTests$listOfType$outer;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
        public final class Outer {
            @NotNull
            private final List<Object> l;

            @NotNull
            public final List<Object> getL() {
                return this.l;
            }

            public Outer(@NotNull List<? extends Object> l) {
                Intrinsics.checkParameterIsNotNull(l, (String)"l");
                this.l = l;
            }

            @NotNull
            public final List<Object> component1() {
                return this.l;
            }

            @NotNull
            public final Outer copy(@NotNull List<? extends Object> l) {
                Intrinsics.checkParameterIsNotNull(l, (String)"l");
                return new Outer(l);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ Outer copy$default(Outer outer2, List list, int n, Object object) {
                if ((n & 1) != 0) {
                    list = outer2.l;
                }
                return outer2.copy(list);
            }

            @NotNull
            public String toString() {
                return "outer(l=" + this.l + ")";
            }

            public int hashCode() {
                List<Object> list = this.l;
                return list != null ? ((Object)list).hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Outer)) break block3;
                        Outer outer2 = (Outer)object;
                        if (!Intrinsics.areEqual(this.l, outer2.l)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        Outer toSerialise = new Outer(CollectionsKt.listOf((Object[])objectArray));
        SerializedBytes<Outer> serialisedBytes = new TestSerializationOutput(false, this.sf1).serialize(toSerialise);
        DeserializationInput deserializationInput = new DeserializationInput(this.sf2);
        DeserializeNeedingCarpentryTests this_$iv = this;
        SerializationContext context$iv = null;
        AssertionsKt.assertFailsWith((KClass)Reflection.getOrCreateKotlinClass(NotSerializableException.class), (Function0)((Function0)new Function0<Unit>((DeserializationInput)$receiver$iv, serialisedBytes, context$iv){
            final /* synthetic */ DeserializationInput receiver$0;
            final /* synthetic */ SerializedBytes $bytes;
            final /* synthetic */ SerializationContext $context;
            {
                this.receiver$0 = deserializationInput;
                this.$bytes = serializedBytes;
                this.$context = serializationContext;
                super(0);
            }

            public final void invoke() {
                ByteSequence byteSequence = (ByteSequence)this.$bytes;
                SerializationContext serializationContext = this.$context;
                if (serializationContext == null) {
                    serializationContext = (SerializationContext)TestSerializationContextKt.getTestSerializationContext();
                }
                this.receiver$0.deserialize(byteSequence, Outer.class, serializationContext.withoutCarpenter());
            }
        }));
        Outer deserializedObj = (Outer)$receiver$iv.deserialize((ByteSequence)serialisedBytes, Outer.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        int sentinel = 1;
        $receiver$iv = deserializedObj.getL();
        Iterator iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object it = element$iv = iterator.next();
            int n = sentinel;
            sentinel = n + 1;
            AssertionsKt.assertEquals$default((Object)n, (Object)it.getClass().getMethod("getV1", new Class[0]).invoke(it, new Object[0]), null, (int)4, null);
            n = sentinel;
            sentinel = n + 1;
            AssertionsKt.assertEquals$default((Object)n, (Object)it.getClass().getMethod("getV2", new Class[0]).invoke(it, new Object[0]), null, (int)4, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void unknownInterface() {
        void $receiver$iv;
        ClassCarpenterImpl cc = new ClassCarpenterImpl((ClassWhitelist)AllWhitelist.INSTANCE, null, false, 6, null);
        Class interfaceClass = cc.build((Schema)new InterfaceSchema("gen.Interface", MapsKt.mapOf((Pair)TuplesKt.to((Object)"age", (Object)new NonNullableField(Integer.TYPE))), null, null, 12, null));
        Class concreteClass = cc.build((Schema)new ClassSchema(AMQPTestUtilsKt.testName(), MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"age", (Object)new NonNullableField(Integer.TYPE)), TuplesKt.to((Object)"name", (Object)new NonNullableField(String.class))}), null, CollectionsKt.listOf((Object[])new Class[]{I.class, interfaceClass}), 4, null));
        TestSerializationOutput testSerializationOutput = new TestSerializationOutput(false, this.sf1);
        Object[] objectArray = concreteClass.getConstructors();
        Intrinsics.checkExpressionValueIsNotNull(objectArray, (String)"concreteClass.constructors");
        SerializedBytes serialisedBytes = testSerializationOutput.serialize(((Constructor)ArraysKt.first((Object[])objectArray)).newInstance(12, "timmy"));
        DeserializationInput deserializationInput = new DeserializationInput(this.sf2);
        DeserializeNeedingCarpentryTests this_$iv = this;
        SerializationContext context$iv = null;
        AssertionsKt.assertFailsWith((KClass)Reflection.getOrCreateKotlinClass(NotSerializableException.class), (Function0)((Function0)new Function0<Unit>((DeserializationInput)$receiver$iv, serialisedBytes, context$iv){
            final /* synthetic */ DeserializationInput receiver$0;
            final /* synthetic */ SerializedBytes $bytes;
            final /* synthetic */ SerializationContext $context;
            {
                this.receiver$0 = deserializationInput;
                this.$bytes = serializedBytes;
                this.$context = serializationContext;
                super(0);
            }

            public final void invoke() {
                ByteSequence byteSequence = (ByteSequence)this.$bytes;
                SerializationContext serializationContext = this.$context;
                if (serializationContext == null) {
                    serializationContext = (SerializationContext)TestSerializationContextKt.getTestSerializationContext();
                }
                this.receiver$0.deserialize(byteSequence, Object.class, serializationContext.withoutCarpenter());
            }
        }));
        Object deserializedObj = $receiver$iv.deserialize((ByteSequence)serialisedBytes, Object.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertTrue$default((boolean)(deserializedObj instanceof I), null, (int)2, null);
        Object object = deserializedObj;
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.corda.serialization.internal.amqp.I");
        }
        AssertionsKt.assertEquals$default((Object)"timmy", (Object)((I)object).getName(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)"timmy", (Object)deserializedObj.getClass().getMethod("getName", new Class[0]).invoke(deserializedObj, new Object[0]), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)12, (Object)deserializedObj.getClass().getMethod("getAge", new Class[0]).invoke(deserializedObj, new Object[0]), null, (int)4, null);
    }

    public DeserializeNeedingCarpentryTests() {
        super((ClassWhitelist)AllWhitelist.INSTANCE);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnet/corda/serialization/internal/amqp/DeserializeNeedingCarpentryTests$Companion;", "", "()V", "VERBOSE", "", "serialization"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

