/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp;

import java.lang.reflect.Constructor;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.test.AssertionsKt;
import net.corda.core.serialization.ClassWhitelist;
import net.corda.core.serialization.SerializationContext;
import net.corda.core.serialization.SerializedBytes;
import net.corda.core.utilities.ByteSequence;
import net.corda.serialization.internal.AllWhitelist;
import net.corda.serialization.internal.amqp.DeserializationInput;
import net.corda.serialization.internal.amqp.I;
import net.corda.serialization.internal.amqp.SerializerFactory;
import net.corda.serialization.internal.amqp.testutils.AMQPTestUtilsKt;
import net.corda.serialization.internal.amqp.testutils.TestSerializationContextKt;
import net.corda.serialization.internal.amqp.testutils.TestSerializationOutput;
import net.corda.serialization.internal.carpenter.AmqpCarpenterBase;
import net.corda.serialization.internal.carpenter.ClassCarpenterImpl;
import net.corda.serialization.internal.carpenter.ClassSchema;
import net.corda.serialization.internal.carpenter.NonNullableField;
import net.corda.serialization.internal.carpenter.NullableField;
import net.corda.serialization.internal.carpenter.Schema;
import org.junit.Test;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u001b\u0018\u0000 !2\u00020\u0001:\u0001!B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0007J\b\u0010\b\u001a\u00020\u0007H\u0007J\b\u0010\t\u001a\u00020\u0007H\u0007J\b\u0010\n\u001a\u00020\u0007H\u0007J\b\u0010\u000b\u001a\u00020\u0007H\u0007J\b\u0010\f\u001a\u00020\u0007H\u0007J\b\u0010\r\u001a\u00020\u0007H\u0007J\b\u0010\u000e\u001a\u00020\u0007H\u0007J\b\u0010\u000f\u001a\u00020\u0007H\u0007J\b\u0010\u0010\u001a\u00020\u0007H\u0007J\b\u0010\u0011\u001a\u00020\u0007H\u0007J\b\u0010\u0012\u001a\u00020\u0007H\u0007J\b\u0010\u0013\u001a\u00020\u0007H\u0007J\b\u0010\u0014\u001a\u00020\u0007H\u0007J\b\u0010\u0015\u001a\u00020\u0007H\u0007J\b\u0010\u0016\u001a\u00020\u0007H\u0007J\b\u0010\u0017\u001a\u00020\u0007H\u0007J\b\u0010\u0018\u001a\u00020\u0007H\u0007J\b\u0010\u0019\u001a\u00020\u0007H\u0007J\b\u0010\u001a\u001a\u00020\u0007H\u0007J\b\u0010\u001b\u001a\u00020\u0007H\u0007J\b\u0010\u001c\u001a\u00020\u0007H\u0007J\b\u0010\u001d\u001a\u00020\u0007H\u0007J\b\u0010\u001e\u001a\u00020\u0007H\u0007J\b\u0010\u001f\u001a\u00020\u0007H\u0007J\b\u0010 \u001a\u00020\u0007H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lnet/corda/serialization/internal/amqp/DeserializeNeedingCarpentrySimpleTypesTest;", "Lnet/corda/serialization/internal/carpenter/AmqpCarpenterBase;", "()V", "sf", "Lnet/corda/serialization/internal/amqp/SerializerFactory;", "sf2", "manyTypes", "", "simpleTypeKnownInterface", "singleBoolean", "singleBooleanNullable", "singleBooleanNullableNull", "singleByte", "singleByteNullable", "singleByteNullableNull", "singleChar", "singleCharNullable", "singleCharNullableNull", "singleDouble", "singleDoubleNullable", "singleDoubleNullableNull", "singleFloat", "singleFloatNullable", "singleFloatNullableNull", "singleInt", "singleIntNullable", "singleIntNullableNull", "singleLong", "singleLongNullable", "singleLongNullableNull", "singleShort", "singleShortNullable", "singleShortNullableNull", "Companion", "serialization"})
public final class DeserializeNeedingCarpentrySimpleTypesTest
extends AmqpCarpenterBase {
    private final SerializerFactory sf = AMQPTestUtilsKt.testDefaultFactoryNoEvolution$default(null, 1, null);
    private final SerializerFactory sf2 = AMQPTestUtilsKt.testDefaultFactoryNoEvolution$default(null, 1, null);
    private static final boolean VERBOSE = false;
    public static final Companion Companion = new Companion(null);

    @Test(timeout=300000L)
    public final void singleInt() {
        ClassCarpenterImpl classCarpenterImpl = new ClassCarpenterImpl((ClassWhitelist)AllWhitelist.INSTANCE, null, false, 6, null);
        String string = AMQPTestUtilsKt.testName();
        Class<Integer> clazz = Integer.TYPE;
        if (clazz == null) {
            Intrinsics.throwNpe();
        }
        Class clazz2 = classCarpenterImpl.build((Schema)new ClassSchema(string, MapsKt.mapOf((Pair)TuplesKt.to((Object)"int", (Object)new NonNullableField(clazz))), null, null, 12, null));
        TestSerializationOutput testSerializationOutput = new TestSerializationOutput(false, this.sf);
        Object[] objectArray = clazz2.getConstructors();
        Intrinsics.checkExpressionValueIsNotNull(objectArray, (String)"clazz.constructors");
        SerializedBytes sb = testSerializationOutput.serialize(((Constructor)ArraysKt.first((Object[])objectArray)).newInstance(1));
        DeserializationInput $receiver$iv = new DeserializationInput(this.sf);
        SerializationContext context$iv = null;
        Object db = $receiver$iv.deserialize((ByteSequence)sb, Object.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        DeserializationInput $receiver$iv2 = new DeserializationInput(this.sf2);
        SerializationContext context$iv2 = null;
        Object db2 = $receiver$iv2.deserialize((ByteSequence)sb, Object.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default(db.getClass(), (Object)clazz2, null, (int)4, null);
        AssertionsKt.assertNotEquals$default(db2.getClass(), (Object)clazz2, null, (int)4, null);
        AssertionsKt.assertNotEquals$default(db.getClass(), db2.getClass(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)1, (Object)db.getClass().getMethod("getInt", new Class[0]).invoke(db, new Object[0]), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)1, (Object)db2.getClass().getMethod("getInt", new Class[0]).invoke(db2, new Object[0]), null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void singleIntNullable() {
        Class clazz = new ClassCarpenterImpl((ClassWhitelist)AllWhitelist.INSTANCE, null, false, 6, null).build((Schema)new ClassSchema(AMQPTestUtilsKt.testName(), MapsKt.mapOf((Pair)TuplesKt.to((Object)"int", (Object)new NullableField(Integer.class))), null, null, 12, null));
        TestSerializationOutput testSerializationOutput = new TestSerializationOutput(false, this.sf);
        Object[] objectArray = clazz.getConstructors();
        Intrinsics.checkExpressionValueIsNotNull(objectArray, (String)"clazz.constructors");
        SerializedBytes sb = testSerializationOutput.serialize(((Constructor)ArraysKt.first((Object[])objectArray)).newInstance(1));
        DeserializationInput $receiver$iv = new DeserializationInput(this.sf);
        SerializationContext context$iv = null;
        Object db1 = $receiver$iv.deserialize((ByteSequence)sb, Object.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        DeserializationInput $receiver$iv2 = new DeserializationInput(this.sf2);
        SerializationContext context$iv2 = null;
        Object db2 = $receiver$iv2.deserialize((ByteSequence)sb, Object.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)clazz, db1.getClass(), null, (int)4, null);
        AssertionsKt.assertNotEquals$default((Object)clazz, db2.getClass(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)1, (Object)db1.getClass().getMethod("getInt", new Class[0]).invoke(db1, new Object[0]), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)1, (Object)db2.getClass().getMethod("getInt", new Class[0]).invoke(db2, new Object[0]), null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void singleIntNullableNull() {
        Class clazz = new ClassCarpenterImpl((ClassWhitelist)AllWhitelist.INSTANCE, null, false, 6, null).build((Schema)new ClassSchema(AMQPTestUtilsKt.testName(), MapsKt.mapOf((Pair)TuplesKt.to((Object)"int", (Object)new NullableField(Integer.class))), null, null, 12, null));
        TestSerializationOutput testSerializationOutput = new TestSerializationOutput(false, this.sf);
        Object[] objectArray = clazz.getConstructors();
        Intrinsics.checkExpressionValueIsNotNull(objectArray, (String)"clazz.constructors");
        SerializedBytes sb = testSerializationOutput.serialize(((Constructor)ArraysKt.first((Object[])objectArray)).newInstance(new Object[]{null}));
        DeserializationInput $receiver$iv = new DeserializationInput(this.sf);
        SerializationContext context$iv = null;
        Object db1 = $receiver$iv.deserialize((ByteSequence)sb, Object.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        DeserializationInput $receiver$iv2 = new DeserializationInput(this.sf2);
        SerializationContext context$iv2 = null;
        Object db2 = $receiver$iv2.deserialize((ByteSequence)sb, Object.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)clazz, db1.getClass(), null, (int)4, null);
        AssertionsKt.assertNotEquals$default((Object)clazz, db2.getClass(), null, (int)4, null);
        AssertionsKt.assertEquals$default(null, (Object)db1.getClass().getMethod("getInt", new Class[0]).invoke(db1, new Object[0]), null, (int)4, null);
        AssertionsKt.assertEquals$default(null, (Object)db2.getClass().getMethod("getInt", new Class[0]).invoke(db2, new Object[0]), null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void singleChar() {
        ClassCarpenterImpl classCarpenterImpl = new ClassCarpenterImpl((ClassWhitelist)AllWhitelist.INSTANCE, null, false, 6, null);
        String string = AMQPTestUtilsKt.testName();
        Class<Character> clazz = Character.TYPE;
        if (clazz == null) {
            Intrinsics.throwNpe();
        }
        Class clazz2 = classCarpenterImpl.build((Schema)new ClassSchema(string, MapsKt.mapOf((Pair)TuplesKt.to((Object)"char", (Object)new NonNullableField(clazz))), null, null, 12, null));
        TestSerializationOutput testSerializationOutput = new TestSerializationOutput(false, this.sf);
        Object[] objectArray = clazz2.getConstructors();
        Intrinsics.checkExpressionValueIsNotNull(objectArray, (String)"clazz.constructors");
        SerializedBytes sb = testSerializationOutput.serialize(((Constructor)ArraysKt.first((Object[])objectArray)).newInstance(Character.valueOf('a')));
        DeserializationInput $receiver$iv = new DeserializationInput(this.sf2);
        SerializationContext context$iv = null;
        Object db = $receiver$iv.deserialize((ByteSequence)sb, Object.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertNotEquals$default((Object)clazz2, db.getClass(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)Character.valueOf('a'), (Object)db.getClass().getMethod("getChar", new Class[0]).invoke(db, new Object[0]), null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void singleCharNullable() {
        Class clazz = new ClassCarpenterImpl((ClassWhitelist)AllWhitelist.INSTANCE, null, false, 6, null).build((Schema)new ClassSchema(AMQPTestUtilsKt.testName(), MapsKt.mapOf((Pair)TuplesKt.to((Object)"char", (Object)new NullableField(Character.class))), null, null, 12, null));
        TestSerializationOutput testSerializationOutput = new TestSerializationOutput(false, this.sf);
        Object[] objectArray = clazz.getConstructors();
        Intrinsics.checkExpressionValueIsNotNull(objectArray, (String)"clazz.constructors");
        SerializedBytes sb = testSerializationOutput.serialize(((Constructor)ArraysKt.first((Object[])objectArray)).newInstance(Character.valueOf('a')));
        DeserializationInput $receiver$iv = new DeserializationInput(this.sf2);
        SerializationContext context$iv = null;
        Object db = $receiver$iv.deserialize((ByteSequence)sb, Object.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertNotEquals$default((Object)clazz, db.getClass(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)Character.valueOf('a'), (Object)db.getClass().getMethod("getChar", new Class[0]).invoke(db, new Object[0]), null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void singleCharNullableNull() {
        Class clazz = new ClassCarpenterImpl((ClassWhitelist)AllWhitelist.INSTANCE, null, false, 6, null).build((Schema)new ClassSchema(AMQPTestUtilsKt.testName(), MapsKt.mapOf((Pair)TuplesKt.to((Object)"char", (Object)new NullableField(Character.class))), null, null, 12, null));
        TestSerializationOutput testSerializationOutput = new TestSerializationOutput(false, this.sf);
        Object[] objectArray = clazz.getConstructors();
        Intrinsics.checkExpressionValueIsNotNull(objectArray, (String)"clazz.constructors");
        SerializedBytes sb = testSerializationOutput.serialize(((Constructor)ArraysKt.first((Object[])objectArray)).newInstance(new Object[]{null}));
        DeserializationInput $receiver$iv = new DeserializationInput(this.sf2);
        SerializationContext context$iv = null;
        Object db = $receiver$iv.deserialize((ByteSequence)sb, Object.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertNotEquals$default((Object)clazz, db.getClass(), null, (int)4, null);
        AssertionsKt.assertEquals$default(null, (Object)db.getClass().getMethod("getChar", new Class[0]).invoke(db, new Object[0]), null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void singleLong() {
        ClassCarpenterImpl classCarpenterImpl = new ClassCarpenterImpl((ClassWhitelist)AllWhitelist.INSTANCE, null, false, 6, null);
        String string = AMQPTestUtilsKt.testName();
        Class<Long> clazz = Long.TYPE;
        if (clazz == null) {
            Intrinsics.throwNpe();
        }
        Class clazz2 = classCarpenterImpl.build((Schema)new ClassSchema(string, MapsKt.mapOf((Pair)TuplesKt.to((Object)"long", (Object)new NonNullableField(clazz))), null, null, 12, null));
        long l = 1L;
        TestSerializationOutput testSerializationOutput = new TestSerializationOutput(false, this.sf);
        Object[] objectArray = clazz2.getConstructors();
        Intrinsics.checkExpressionValueIsNotNull(objectArray, (String)"clazz.constructors");
        SerializedBytes sb = testSerializationOutput.serialize(((Constructor)ArraysKt.first((Object[])objectArray)).newInstance(l));
        DeserializationInput $receiver$iv = new DeserializationInput(this.sf2);
        SerializationContext context$iv = null;
        Object db = $receiver$iv.deserialize((ByteSequence)sb, Object.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertNotEquals$default((Object)clazz2, db.getClass(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)l, (Object)db.getClass().getMethod("getLong", new Class[0]).invoke(db, new Object[0]), null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void singleLongNullable() {
        Class clazz = new ClassCarpenterImpl((ClassWhitelist)AllWhitelist.INSTANCE, null, false, 6, null).build((Schema)new ClassSchema(AMQPTestUtilsKt.testName(), MapsKt.mapOf((Pair)TuplesKt.to((Object)"long", (Object)new NullableField(Long.class))), null, null, 12, null));
        long l = 1L;
        TestSerializationOutput testSerializationOutput = new TestSerializationOutput(false, this.sf);
        Object[] objectArray = clazz.getConstructors();
        Intrinsics.checkExpressionValueIsNotNull(objectArray, (String)"clazz.constructors");
        SerializedBytes sb = testSerializationOutput.serialize(((Constructor)ArraysKt.first((Object[])objectArray)).newInstance(l));
        DeserializationInput $receiver$iv = new DeserializationInput(this.sf2);
        SerializationContext context$iv = null;
        Object db = $receiver$iv.deserialize((ByteSequence)sb, Object.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertNotEquals$default((Object)clazz, db.getClass(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)l, (Object)db.getClass().getMethod("getLong", new Class[0]).invoke(db, new Object[0]), null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void singleLongNullableNull() {
        Class clazz = new ClassCarpenterImpl((ClassWhitelist)AllWhitelist.INSTANCE, null, false, 6, null).build((Schema)new ClassSchema(AMQPTestUtilsKt.testName(), MapsKt.mapOf((Pair)TuplesKt.to((Object)"long", (Object)new NullableField(Long.class))), null, null, 12, null));
        TestSerializationOutput testSerializationOutput = new TestSerializationOutput(false, this.sf);
        Object[] objectArray = clazz.getConstructors();
        Intrinsics.checkExpressionValueIsNotNull(objectArray, (String)"clazz.constructors");
        SerializedBytes sb = testSerializationOutput.serialize(((Constructor)ArraysKt.first((Object[])objectArray)).newInstance(new Object[]{null}));
        DeserializationInput $receiver$iv = new DeserializationInput(this.sf2);
        SerializationContext context$iv = null;
        Object db = $receiver$iv.deserialize((ByteSequence)sb, Object.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertNotEquals$default((Object)clazz, db.getClass(), null, (int)4, null);
        AssertionsKt.assertEquals$default(null, (Object)db.getClass().getMethod("getLong", new Class[0]).invoke(db, new Object[0]), null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void singleBoolean() {
        ClassCarpenterImpl classCarpenterImpl = new ClassCarpenterImpl((ClassWhitelist)AllWhitelist.INSTANCE, null, false, 6, null);
        String string = AMQPTestUtilsKt.testName();
        Class<Boolean> clazz = Boolean.TYPE;
        if (clazz == null) {
            Intrinsics.throwNpe();
        }
        Class clazz2 = classCarpenterImpl.build((Schema)new ClassSchema(string, MapsKt.mapOf((Pair)TuplesKt.to((Object)"boolean", (Object)new NonNullableField(clazz))), null, null, 12, null));
        TestSerializationOutput testSerializationOutput = new TestSerializationOutput(false, this.sf);
        Object[] objectArray = clazz2.getConstructors();
        Intrinsics.checkExpressionValueIsNotNull(objectArray, (String)"clazz.constructors");
        SerializedBytes sb = testSerializationOutput.serialize(((Constructor)ArraysKt.first((Object[])objectArray)).newInstance(true));
        DeserializationInput $receiver$iv = new DeserializationInput(this.sf2);
        SerializationContext context$iv = null;
        Object db = $receiver$iv.deserialize((ByteSequence)sb, Object.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertNotEquals$default((Object)clazz2, db.getClass(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)true, (Object)db.getClass().getMethod("getBoolean", new Class[0]).invoke(db, new Object[0]), null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void singleBooleanNullable() {
        Class clazz = new ClassCarpenterImpl((ClassWhitelist)AllWhitelist.INSTANCE, null, false, 6, null).build((Schema)new ClassSchema(AMQPTestUtilsKt.testName(), MapsKt.mapOf((Pair)TuplesKt.to((Object)"boolean", (Object)new NullableField(Boolean.class))), null, null, 12, null));
        TestSerializationOutput testSerializationOutput = new TestSerializationOutput(false, this.sf);
        Object[] objectArray = clazz.getConstructors();
        Intrinsics.checkExpressionValueIsNotNull(objectArray, (String)"clazz.constructors");
        SerializedBytes sb = testSerializationOutput.serialize(((Constructor)ArraysKt.first((Object[])objectArray)).newInstance(true));
        DeserializationInput $receiver$iv = new DeserializationInput(this.sf2);
        SerializationContext context$iv = null;
        Object db = $receiver$iv.deserialize((ByteSequence)sb, Object.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertNotEquals$default((Object)clazz, db.getClass(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)true, (Object)db.getClass().getMethod("getBoolean", new Class[0]).invoke(db, new Object[0]), null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void singleBooleanNullableNull() {
        Class clazz = new ClassCarpenterImpl((ClassWhitelist)AllWhitelist.INSTANCE, null, false, 6, null).build((Schema)new ClassSchema(AMQPTestUtilsKt.testName(), MapsKt.mapOf((Pair)TuplesKt.to((Object)"boolean", (Object)new NullableField(Boolean.class))), null, null, 12, null));
        TestSerializationOutput testSerializationOutput = new TestSerializationOutput(false, this.sf);
        Object[] objectArray = clazz.getConstructors();
        Intrinsics.checkExpressionValueIsNotNull(objectArray, (String)"clazz.constructors");
        SerializedBytes sb = testSerializationOutput.serialize(((Constructor)ArraysKt.first((Object[])objectArray)).newInstance(new Object[]{null}));
        DeserializationInput $receiver$iv = new DeserializationInput(this.sf2);
        SerializationContext context$iv = null;
        Object db = $receiver$iv.deserialize((ByteSequence)sb, Object.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertNotEquals$default((Object)clazz, db.getClass(), null, (int)4, null);
        AssertionsKt.assertEquals$default(null, (Object)db.getClass().getMethod("getBoolean", new Class[0]).invoke(db, new Object[0]), null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void singleDouble() {
        ClassCarpenterImpl classCarpenterImpl = new ClassCarpenterImpl((ClassWhitelist)AllWhitelist.INSTANCE, null, false, 6, null);
        String string = AMQPTestUtilsKt.testName();
        Class<Double> clazz = Double.TYPE;
        if (clazz == null) {
            Intrinsics.throwNpe();
        }
        Class clazz2 = classCarpenterImpl.build((Schema)new ClassSchema(string, MapsKt.mapOf((Pair)TuplesKt.to((Object)"double", (Object)new NonNullableField(clazz))), null, null, 12, null));
        TestSerializationOutput testSerializationOutput = new TestSerializationOutput(false, this.sf);
        Object[] objectArray = clazz2.getConstructors();
        Intrinsics.checkExpressionValueIsNotNull(objectArray, (String)"clazz.constructors");
        SerializedBytes sb = testSerializationOutput.serialize(((Constructor)ArraysKt.first((Object[])objectArray)).newInstance(10.0));
        DeserializationInput $receiver$iv = new DeserializationInput(this.sf2);
        SerializationContext context$iv = null;
        Object db = $receiver$iv.deserialize((ByteSequence)sb, Object.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertNotEquals$default((Object)clazz2, db.getClass(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)10.0, (Object)db.getClass().getMethod("getDouble", new Class[0]).invoke(db, new Object[0]), null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void singleDoubleNullable() {
        Class clazz = new ClassCarpenterImpl((ClassWhitelist)AllWhitelist.INSTANCE, null, false, 6, null).build((Schema)new ClassSchema(AMQPTestUtilsKt.testName(), MapsKt.mapOf((Pair)TuplesKt.to((Object)"double", (Object)new NullableField(Double.class))), null, null, 12, null));
        TestSerializationOutput testSerializationOutput = new TestSerializationOutput(false, this.sf);
        Object[] objectArray = clazz.getConstructors();
        Intrinsics.checkExpressionValueIsNotNull(objectArray, (String)"clazz.constructors");
        SerializedBytes sb = testSerializationOutput.serialize(((Constructor)ArraysKt.first((Object[])objectArray)).newInstance(10.0));
        DeserializationInput $receiver$iv = new DeserializationInput(this.sf2);
        SerializationContext context$iv = null;
        Object db = $receiver$iv.deserialize((ByteSequence)sb, Object.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertNotEquals$default((Object)clazz, db.getClass(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)10.0, (Object)db.getClass().getMethod("getDouble", new Class[0]).invoke(db, new Object[0]), null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void singleDoubleNullableNull() {
        Class clazz = new ClassCarpenterImpl((ClassWhitelist)AllWhitelist.INSTANCE, null, false, 6, null).build((Schema)new ClassSchema(AMQPTestUtilsKt.testName(), MapsKt.mapOf((Pair)TuplesKt.to((Object)"double", (Object)new NullableField(Double.class))), null, null, 12, null));
        TestSerializationOutput testSerializationOutput = new TestSerializationOutput(false, this.sf);
        Object[] objectArray = clazz.getConstructors();
        Intrinsics.checkExpressionValueIsNotNull(objectArray, (String)"clazz.constructors");
        SerializedBytes sb = testSerializationOutput.serialize(((Constructor)ArraysKt.first((Object[])objectArray)).newInstance(new Object[]{null}));
        DeserializationInput $receiver$iv = new DeserializationInput(this.sf2);
        SerializationContext context$iv = null;
        Object db = $receiver$iv.deserialize((ByteSequence)sb, Object.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertNotEquals$default((Object)clazz, db.getClass(), null, (int)4, null);
        AssertionsKt.assertEquals$default(null, (Object)db.getClass().getMethod("getDouble", new Class[0]).invoke(db, new Object[0]), null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void singleShort() {
        ClassCarpenterImpl classCarpenterImpl = new ClassCarpenterImpl((ClassWhitelist)AllWhitelist.INSTANCE, null, false, 6, null);
        String string = AMQPTestUtilsKt.testName();
        Class<Short> clazz = Short.TYPE;
        if (clazz == null) {
            Intrinsics.throwNpe();
        }
        Class clazz2 = classCarpenterImpl.build((Schema)new ClassSchema(string, MapsKt.mapOf((Pair)TuplesKt.to((Object)"short", (Object)new NonNullableField(clazz))), null, null, 12, null));
        TestSerializationOutput testSerializationOutput = new TestSerializationOutput(false, this.sf);
        Object[] objectArray = clazz2.getConstructors();
        Intrinsics.checkExpressionValueIsNotNull(objectArray, (String)"clazz.constructors");
        SerializedBytes sb = testSerializationOutput.serialize(((Constructor)ArraysKt.first((Object[])objectArray)).newInstance((short)3));
        DeserializationInput $receiver$iv = new DeserializationInput(this.sf2);
        SerializationContext context$iv = null;
        Object db = $receiver$iv.deserialize((ByteSequence)sb, Object.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertNotEquals$default((Object)clazz2, db.getClass(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)((short)3), (Object)db.getClass().getMethod("getShort", new Class[0]).invoke(db, new Object[0]), null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void singleShortNullable() {
        Class clazz = new ClassCarpenterImpl((ClassWhitelist)AllWhitelist.INSTANCE, null, false, 6, null).build((Schema)new ClassSchema(AMQPTestUtilsKt.testName(), MapsKt.mapOf((Pair)TuplesKt.to((Object)"short", (Object)new NullableField(Short.class))), null, null, 12, null));
        TestSerializationOutput testSerializationOutput = new TestSerializationOutput(false, this.sf);
        Object[] objectArray = clazz.getConstructors();
        Intrinsics.checkExpressionValueIsNotNull(objectArray, (String)"clazz.constructors");
        SerializedBytes sb = testSerializationOutput.serialize(((Constructor)ArraysKt.first((Object[])objectArray)).newInstance((short)3));
        DeserializationInput $receiver$iv = new DeserializationInput(this.sf2);
        SerializationContext context$iv = null;
        Object db = $receiver$iv.deserialize((ByteSequence)sb, Object.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertNotEquals$default((Object)clazz, db.getClass(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)((short)3), (Object)db.getClass().getMethod("getShort", new Class[0]).invoke(db, new Object[0]), null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void singleShortNullableNull() {
        Class clazz = new ClassCarpenterImpl((ClassWhitelist)AllWhitelist.INSTANCE, null, false, 6, null).build((Schema)new ClassSchema(AMQPTestUtilsKt.testName(), MapsKt.mapOf((Pair)TuplesKt.to((Object)"short", (Object)new NullableField(Short.class))), null, null, 12, null));
        TestSerializationOutput testSerializationOutput = new TestSerializationOutput(false, this.sf);
        Object[] objectArray = clazz.getConstructors();
        Intrinsics.checkExpressionValueIsNotNull(objectArray, (String)"clazz.constructors");
        SerializedBytes sb = testSerializationOutput.serialize(((Constructor)ArraysKt.first((Object[])objectArray)).newInstance(new Object[]{null}));
        DeserializationInput $receiver$iv = new DeserializationInput(this.sf2);
        SerializationContext context$iv = null;
        Object db = $receiver$iv.deserialize((ByteSequence)sb, Object.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertNotEquals$default((Object)clazz, db.getClass(), null, (int)4, null);
        AssertionsKt.assertEquals$default(null, (Object)db.getClass().getMethod("getShort", new Class[0]).invoke(db, new Object[0]), null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void singleFloat() {
        ClassCarpenterImpl classCarpenterImpl = new ClassCarpenterImpl((ClassWhitelist)AllWhitelist.INSTANCE, null, false, 6, null);
        String string = AMQPTestUtilsKt.testName();
        Class<Float> clazz = Float.TYPE;
        if (clazz == null) {
            Intrinsics.throwNpe();
        }
        Class clazz2 = classCarpenterImpl.build((Schema)new ClassSchema(string, MapsKt.mapOf((Pair)TuplesKt.to((Object)"float", (Object)new NonNullableField(clazz))), null, null, 12, null));
        TestSerializationOutput testSerializationOutput = new TestSerializationOutput(false, this.sf);
        Object[] objectArray = clazz2.getConstructors();
        Intrinsics.checkExpressionValueIsNotNull(objectArray, (String)"clazz.constructors");
        SerializedBytes sb = testSerializationOutput.serialize(((Constructor)ArraysKt.first((Object[])objectArray)).newInstance(Float.valueOf(10.0f)));
        DeserializationInput $receiver$iv = new DeserializationInput(this.sf2);
        SerializationContext context$iv = null;
        Object db = $receiver$iv.deserialize((ByteSequence)sb, Object.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertNotEquals$default((Object)clazz2, db.getClass(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)Float.valueOf(10.0f), (Object)db.getClass().getMethod("getFloat", new Class[0]).invoke(db, new Object[0]), null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void singleFloatNullable() {
        Class clazz = new ClassCarpenterImpl((ClassWhitelist)AllWhitelist.INSTANCE, null, false, 6, null).build((Schema)new ClassSchema(AMQPTestUtilsKt.testName(), MapsKt.mapOf((Pair)TuplesKt.to((Object)"float", (Object)new NullableField(Float.class))), null, null, 12, null));
        TestSerializationOutput testSerializationOutput = new TestSerializationOutput(false, this.sf);
        Object[] objectArray = clazz.getConstructors();
        Intrinsics.checkExpressionValueIsNotNull(objectArray, (String)"clazz.constructors");
        SerializedBytes sb = testSerializationOutput.serialize(((Constructor)ArraysKt.first((Object[])objectArray)).newInstance(Float.valueOf(10.0f)));
        DeserializationInput $receiver$iv = new DeserializationInput(this.sf2);
        SerializationContext context$iv = null;
        Object db = $receiver$iv.deserialize((ByteSequence)sb, Object.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertNotEquals$default((Object)clazz, db.getClass(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)Float.valueOf(10.0f), (Object)db.getClass().getMethod("getFloat", new Class[0]).invoke(db, new Object[0]), null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void singleFloatNullableNull() {
        Class clazz = new ClassCarpenterImpl((ClassWhitelist)AllWhitelist.INSTANCE, null, false, 6, null).build((Schema)new ClassSchema(AMQPTestUtilsKt.testName(), MapsKt.mapOf((Pair)TuplesKt.to((Object)"float", (Object)new NullableField(Float.class))), null, null, 12, null));
        TestSerializationOutput testSerializationOutput = new TestSerializationOutput(false, this.sf);
        Object[] objectArray = clazz.getConstructors();
        Intrinsics.checkExpressionValueIsNotNull(objectArray, (String)"clazz.constructors");
        SerializedBytes sb = testSerializationOutput.serialize(((Constructor)ArraysKt.first((Object[])objectArray)).newInstance(new Object[]{null}));
        DeserializationInput $receiver$iv = new DeserializationInput(this.sf2);
        SerializationContext context$iv = null;
        Object db = $receiver$iv.deserialize((ByteSequence)sb, Object.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertNotEquals$default((Object)clazz, db.getClass(), null, (int)4, null);
        AssertionsKt.assertEquals$default(null, (Object)db.getClass().getMethod("getFloat", new Class[0]).invoke(db, new Object[0]), null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void singleByte() {
        ClassCarpenterImpl classCarpenterImpl = new ClassCarpenterImpl((ClassWhitelist)AllWhitelist.INSTANCE, null, false, 6, null);
        String string = AMQPTestUtilsKt.testName();
        Class<Byte> clazz = Byte.TYPE;
        if (clazz == null) {
            Intrinsics.throwNpe();
        }
        Class clazz2 = classCarpenterImpl.build((Schema)new ClassSchema(string, MapsKt.mapOf((Pair)TuplesKt.to((Object)"byte", (Object)new NonNullableField(clazz))), null, null, 12, null));
        byte b = 5;
        TestSerializationOutput testSerializationOutput = new TestSerializationOutput(false, this.sf);
        Object[] objectArray = clazz2.getConstructors();
        Intrinsics.checkExpressionValueIsNotNull(objectArray, (String)"clazz.constructors");
        SerializedBytes sb = testSerializationOutput.serialize(((Constructor)ArraysKt.first((Object[])objectArray)).newInstance(b));
        DeserializationInput $receiver$iv = new DeserializationInput(this.sf2);
        SerializationContext context$iv = null;
        Object db = $receiver$iv.deserialize((ByteSequence)sb, Object.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertNotEquals$default((Object)clazz2, db.getClass(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)b, (Object)db.getClass().getMethod("getByte", new Class[0]).invoke(db, new Object[0]), null, (int)4, null);
        Object object = db.getClass().getMethod("getByte", new Class[0]).invoke(db, new Object[0]);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Byte");
        }
        AssertionsKt.assertEquals$default((Object)5, (Object)((Byte)object), null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void singleByteNullable() {
        Class clazz = new ClassCarpenterImpl((ClassWhitelist)AllWhitelist.INSTANCE, null, false, 6, null).build((Schema)new ClassSchema(AMQPTestUtilsKt.testName(), MapsKt.mapOf((Pair)TuplesKt.to((Object)"byte", (Object)new NullableField(Byte.class))), null, null, 12, null));
        byte b = 5;
        TestSerializationOutput testSerializationOutput = new TestSerializationOutput(false, this.sf);
        Object[] objectArray = clazz.getConstructors();
        Intrinsics.checkExpressionValueIsNotNull(objectArray, (String)"clazz.constructors");
        SerializedBytes sb = testSerializationOutput.serialize(((Constructor)ArraysKt.first((Object[])objectArray)).newInstance(b));
        DeserializationInput $receiver$iv = new DeserializationInput(this.sf2);
        SerializationContext context$iv = null;
        Object db = $receiver$iv.deserialize((ByteSequence)sb, Object.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertNotEquals$default((Object)clazz, db.getClass(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)b, (Object)db.getClass().getMethod("getByte", new Class[0]).invoke(db, new Object[0]), null, (int)4, null);
        Object object = db.getClass().getMethod("getByte", new Class[0]).invoke(db, new Object[0]);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Byte");
        }
        AssertionsKt.assertEquals$default((Object)5, (Object)((Byte)object), null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void singleByteNullableNull() {
        Class clazz = new ClassCarpenterImpl((ClassWhitelist)AllWhitelist.INSTANCE, null, false, 6, null).build((Schema)new ClassSchema(AMQPTestUtilsKt.testName(), MapsKt.mapOf((Pair)TuplesKt.to((Object)"byte", (Object)new NullableField(Byte.class))), null, null, 12, null));
        TestSerializationOutput testSerializationOutput = new TestSerializationOutput(false, this.sf);
        Object[] objectArray = clazz.getConstructors();
        Intrinsics.checkExpressionValueIsNotNull(objectArray, (String)"clazz.constructors");
        SerializedBytes sb = testSerializationOutput.serialize(((Constructor)ArraysKt.first((Object[])objectArray)).newInstance(new Object[]{null}));
        DeserializationInput $receiver$iv = new DeserializationInput(this.sf2);
        SerializationContext context$iv = null;
        Object db = $receiver$iv.deserialize((ByteSequence)sb, Object.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertNotEquals$default((Object)clazz, db.getClass(), null, (int)4, null);
        AssertionsKt.assertEquals$default(null, (Object)db.getClass().getMethod("getByte", new Class[0]).invoke(db, new Object[0]), null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void simpleTypeKnownInterface() {
        Class clazz = new ClassCarpenterImpl((ClassWhitelist)AllWhitelist.INSTANCE, null, false, 6, null).build((Schema)new ClassSchema(AMQPTestUtilsKt.testName(), MapsKt.mapOf((Pair)TuplesKt.to((Object)"name", (Object)new NonNullableField(String.class))), null, CollectionsKt.listOf(I.class), 4, null));
        String testVal = "Some Person";
        Object classInstance = clazz.getConstructors()[0].newInstance(testVal);
        SerializedBytes<?> serialisedBytes = new TestSerializationOutput(false, this.sf).serialize(classInstance);
        DeserializationInput $receiver$iv = new DeserializationInput(this.sf2);
        SerializationContext context$iv = null;
        Object deserializedObj = $receiver$iv.deserialize((ByteSequence)serialisedBytes, Object.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertNotEquals$default((Object)clazz, deserializedObj.getClass(), null, (int)4, null);
        AssertionsKt.assertTrue$default((boolean)(deserializedObj instanceof I), null, (int)2, null);
        Object object = deserializedObj;
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.corda.serialization.internal.amqp.I");
        }
        AssertionsKt.assertEquals$default((Object)testVal, (Object)((I)object).getName(), null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void manyTypes() {
        ClassCarpenterImpl classCarpenterImpl = new ClassCarpenterImpl((ClassWhitelist)AllWhitelist.INSTANCE, null, false, 6, null);
        String string = AMQPTestUtilsKt.testName();
        Pair[] pairArray = new Pair[27];
        pairArray[0] = TuplesKt.to((Object)"intA", (Object)new NonNullableField(Integer.TYPE));
        pairArray[1] = TuplesKt.to((Object)"intB", (Object)new NullableField(Integer.class));
        pairArray[2] = TuplesKt.to((Object)"intC", (Object)new NullableField(Integer.class));
        pairArray[3] = TuplesKt.to((Object)"strA", (Object)new NonNullableField(String.class));
        pairArray[4] = TuplesKt.to((Object)"strB", (Object)new NullableField(String.class));
        pairArray[5] = TuplesKt.to((Object)"strC", (Object)new NullableField(String.class));
        pairArray[6] = TuplesKt.to((Object)"charA", (Object)new NonNullableField(Character.TYPE));
        pairArray[7] = TuplesKt.to((Object)"charB", (Object)new NullableField(Character.class));
        pairArray[8] = TuplesKt.to((Object)"charC", (Object)new NullableField(Character.class));
        Class<Short> clazz = Short.TYPE;
        if (clazz == null) {
            Intrinsics.throwNpe();
        }
        pairArray[9] = TuplesKt.to((Object)"shortA", (Object)new NonNullableField(clazz));
        pairArray[10] = TuplesKt.to((Object)"shortB", (Object)new NullableField(Short.class));
        pairArray[11] = TuplesKt.to((Object)"shortC", (Object)new NullableField(Short.class));
        Class<Long> clazz2 = Long.TYPE;
        if (clazz2 == null) {
            Intrinsics.throwNpe();
        }
        pairArray[12] = TuplesKt.to((Object)"longA", (Object)new NonNullableField(clazz2));
        pairArray[13] = TuplesKt.to((Object)"longB", (Object)new NullableField(Long.class));
        pairArray[14] = TuplesKt.to((Object)"longC", (Object)new NullableField(Long.class));
        Class<Boolean> clazz3 = Boolean.TYPE;
        if (clazz3 == null) {
            Intrinsics.throwNpe();
        }
        pairArray[15] = TuplesKt.to((Object)"booleanA", (Object)new NonNullableField(clazz3));
        pairArray[16] = TuplesKt.to((Object)"booleanB", (Object)new NullableField(Boolean.class));
        pairArray[17] = TuplesKt.to((Object)"booleanC", (Object)new NullableField(Boolean.class));
        Class<Double> clazz4 = Double.TYPE;
        if (clazz4 == null) {
            Intrinsics.throwNpe();
        }
        pairArray[18] = TuplesKt.to((Object)"doubleA", (Object)new NonNullableField(clazz4));
        pairArray[19] = TuplesKt.to((Object)"doubleB", (Object)new NullableField(Double.class));
        pairArray[20] = TuplesKt.to((Object)"doubleC", (Object)new NullableField(Double.class));
        Class<Float> clazz5 = Float.TYPE;
        if (clazz5 == null) {
            Intrinsics.throwNpe();
        }
        pairArray[21] = TuplesKt.to((Object)"floatA", (Object)new NonNullableField(clazz5));
        pairArray[22] = TuplesKt.to((Object)"floatB", (Object)new NullableField(Float.class));
        pairArray[23] = TuplesKt.to((Object)"floatC", (Object)new NullableField(Float.class));
        Class<Byte> clazz6 = Byte.TYPE;
        if (clazz6 == null) {
            Intrinsics.throwNpe();
        }
        pairArray[24] = TuplesKt.to((Object)"byteA", (Object)new NonNullableField(clazz6));
        pairArray[25] = TuplesKt.to((Object)"byteB", (Object)new NullableField(Byte.class));
        pairArray[26] = TuplesKt.to((Object)"byteC", (Object)new NullableField(Byte.class));
        Class manyClass = classCarpenterImpl.build((Schema)new ClassSchema(string, MapsKt.mapOf((Pair[])pairArray), null, null, 12, null));
        TestSerializationOutput testSerializationOutput = new TestSerializationOutput(false, this.getFactory());
        Object[] objectArray = manyClass.getConstructors();
        Intrinsics.checkExpressionValueIsNotNull(objectArray, (String)"manyClass.constructors");
        SerializedBytes serialisedBytes = testSerializationOutput.serialize(((Constructor)ArraysKt.first((Object[])objectArray)).newInstance(1, 2, null, "a", "b", null, Character.valueOf('c'), Character.valueOf('d'), null, (short)3, (short)4, null, 100, 200, null, true, false, null, 10.0, 20.0, null, Float.valueOf(10.0f), Float.valueOf(20.0f), null, (byte)5, (byte)10, null));
        DeserializationInput $receiver$iv = new DeserializationInput(this.sf2);
        SerializationContext context$iv = null;
        Object deserializedObj = $receiver$iv.deserialize((ByteSequence)serialisedBytes, Object.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertNotEquals$default((Object)manyClass, deserializedObj.getClass(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)1, (Object)deserializedObj.getClass().getMethod("getIntA", new Class[0]).invoke(deserializedObj, new Object[0]), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)2, (Object)deserializedObj.getClass().getMethod("getIntB", new Class[0]).invoke(deserializedObj, new Object[0]), null, (int)4, null);
        AssertionsKt.assertEquals$default(null, (Object)deserializedObj.getClass().getMethod("getIntC", new Class[0]).invoke(deserializedObj, new Object[0]), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)"a", (Object)deserializedObj.getClass().getMethod("getStrA", new Class[0]).invoke(deserializedObj, new Object[0]), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)"b", (Object)deserializedObj.getClass().getMethod("getStrB", new Class[0]).invoke(deserializedObj, new Object[0]), null, (int)4, null);
        AssertionsKt.assertEquals$default(null, (Object)deserializedObj.getClass().getMethod("getStrC", new Class[0]).invoke(deserializedObj, new Object[0]), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)Character.valueOf('c'), (Object)deserializedObj.getClass().getMethod("getCharA", new Class[0]).invoke(deserializedObj, new Object[0]), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)Character.valueOf('d'), (Object)deserializedObj.getClass().getMethod("getCharB", new Class[0]).invoke(deserializedObj, new Object[0]), null, (int)4, null);
        AssertionsKt.assertEquals$default(null, (Object)deserializedObj.getClass().getMethod("getCharC", new Class[0]).invoke(deserializedObj, new Object[0]), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)((short)3), (Object)deserializedObj.getClass().getMethod("getShortA", new Class[0]).invoke(deserializedObj, new Object[0]), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)((short)4), (Object)deserializedObj.getClass().getMethod("getShortB", new Class[0]).invoke(deserializedObj, new Object[0]), null, (int)4, null);
        AssertionsKt.assertEquals$default(null, (Object)deserializedObj.getClass().getMethod("getShortC", new Class[0]).invoke(deserializedObj, new Object[0]), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)100, (Object)deserializedObj.getClass().getMethod("getLongA", new Class[0]).invoke(deserializedObj, new Object[0]), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)200, (Object)deserializedObj.getClass().getMethod("getLongB", new Class[0]).invoke(deserializedObj, new Object[0]), null, (int)4, null);
        AssertionsKt.assertEquals$default(null, (Object)deserializedObj.getClass().getMethod("getLongC", new Class[0]).invoke(deserializedObj, new Object[0]), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)true, (Object)deserializedObj.getClass().getMethod("getBooleanA", new Class[0]).invoke(deserializedObj, new Object[0]), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)false, (Object)deserializedObj.getClass().getMethod("getBooleanB", new Class[0]).invoke(deserializedObj, new Object[0]), null, (int)4, null);
        AssertionsKt.assertEquals$default(null, (Object)deserializedObj.getClass().getMethod("getBooleanC", new Class[0]).invoke(deserializedObj, new Object[0]), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)10.0, (Object)deserializedObj.getClass().getMethod("getDoubleA", new Class[0]).invoke(deserializedObj, new Object[0]), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)20.0, (Object)deserializedObj.getClass().getMethod("getDoubleB", new Class[0]).invoke(deserializedObj, new Object[0]), null, (int)4, null);
        AssertionsKt.assertEquals$default(null, (Object)deserializedObj.getClass().getMethod("getDoubleC", new Class[0]).invoke(deserializedObj, new Object[0]), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)Float.valueOf(10.0f), (Object)deserializedObj.getClass().getMethod("getFloatA", new Class[0]).invoke(deserializedObj, new Object[0]), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)Float.valueOf(20.0f), (Object)deserializedObj.getClass().getMethod("getFloatB", new Class[0]).invoke(deserializedObj, new Object[0]), null, (int)4, null);
        AssertionsKt.assertEquals$default(null, (Object)deserializedObj.getClass().getMethod("getFloatC", new Class[0]).invoke(deserializedObj, new Object[0]), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)((byte)5), (Object)deserializedObj.getClass().getMethod("getByteA", new Class[0]).invoke(deserializedObj, new Object[0]), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)((byte)10), (Object)deserializedObj.getClass().getMethod("getByteB", new Class[0]).invoke(deserializedObj, new Object[0]), null, (int)4, null);
        AssertionsKt.assertEquals$default(null, (Object)deserializedObj.getClass().getMethod("getByteC", new Class[0]).invoke(deserializedObj, new Object[0]), null, (int)4, null);
    }

    public DeserializeNeedingCarpentrySimpleTypesTest() {
        super((ClassWhitelist)AllWhitelist.INSTANCE);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnet/corda/serialization/internal/amqp/DeserializeNeedingCarpentrySimpleTypesTest$Companion;", "", "()V", "VERBOSE", "", "serialization"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

