/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp;

import java.io.NotSerializableException;
import java.util.AbstractMap;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.serialization.SerializationContext;
import net.corda.core.serialization.SerializedBytes;
import net.corda.core.utilities.ByteSequence;
import net.corda.serialization.internal.amqp.DeserializationInput;
import net.corda.serialization.internal.amqp.DeserializeMapTests;
import net.corda.serialization.internal.amqp.SerializerFactory;
import net.corda.serialization.internal.amqp.testutils.AMQPTestUtilsKt;
import net.corda.serialization.internal.amqp.testutils.TestSerializationContextKt;
import net.corda.serialization.internal.amqp.testutils.TestSerializationOutput;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableAssert;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0007J\b\u0010\u0007\u001a\u00020\u0006H\u0007J\b\u0010\b\u001a\u00020\u0006H\u0007J\b\u0010\t\u001a\u00020\u0006H\u0007J\b\u0010\n\u001a\u00020\u0006H\u0007J\b\u0010\u000b\u001a\u00020\u0006H\u0007J\b\u0010\f\u001a\u00020\u0006H\u0007J\b\u0010\r\u001a\u00020\u0006H\u0007J\b\u0010\u000e\u001a\u00020\u0006H\u0007J\b\u0010\u000f\u001a\u00020\u0006H\u0007J\b\u0010\u0010\u001a\u00020\u0006H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lnet/corda/serialization/internal/amqp/DeserializeMapTests;", "", "()V", "sf", "Lnet/corda/serialization/internal/amqp/SerializerFactory;", "abstractMapFromMapOf", "", "abstractMapFromTreeMap", "concreteLinkedHashMapTest", "concreteTreeMapTest", "dictionaryTest", "hashMapTest", "hashtableTest", "mapTest", "navigableMapTest", "sortedMapTest", "weakHashMapTest", "Companion", "serialization"})
public final class DeserializeMapTests {
    private final SerializerFactory sf = AMQPTestUtilsKt.testDefaultFactoryNoEvolution$default(null, 1, null);
    private static final boolean VERBOSE = false;
    public static final Companion Companion = new Companion(null);

    @Test(timeout=300000L)
    public final void mapTest() {
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000#\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J$\u0010\n\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0004H\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"net/corda/serialization/internal/amqp/DeserializeMapTests$mapTest$C", "", "c", "", "", "", "(Ljava/util/Map;)V", "getC", "()Ljava/util/Map;", "component1", "copy", "(Ljava/util/Map;)Lnet/corda/serialization/internal/amqp/DeserializeMapTests$mapTest$C;", "equals", "", "other", "hashCode", "toString", "serialization"})
        public final class C {
            @NotNull
            private final Map<String, Integer> c;

            @NotNull
            public final Map<String, Integer> getC() {
                return this.c;
            }

            public C(@NotNull Map<String, Integer> c) {
                Intrinsics.checkParameterIsNotNull(c, (String)"c");
                this.c = c;
            }

            @NotNull
            public final Map<String, Integer> component1() {
                return this.c;
            }

            @NotNull
            public final C copy(@NotNull Map<String, Integer> c) {
                Intrinsics.checkParameterIsNotNull(c, (String)"c");
                return new C(c);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ C copy$default(C c, Map map, int n, Object object) {
                if ((n & 1) != 0) {
                    map = c.c;
                }
                return c.copy(map);
            }

            @NotNull
            public String toString() {
                return "C(c=" + this.c + ")";
            }

            public int hashCode() {
                Map<String, Integer> map = this.c;
                return map != null ? ((Object)map).hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof C)) break block3;
                        C c = (C)object;
                        if (!Intrinsics.areEqual(this.c, c.c)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        C c = new C(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"A", (Object)1), TuplesKt.to((Object)"B", (Object)2)}));
        SerializedBytes<C> serialisedBytes = new TestSerializationOutput(false, this.sf).serialize(c);
        DeserializationInput $receiver$iv = new DeserializationInput(this.sf);
        SerializationContext context$iv = null;
        $receiver$iv.deserialize((ByteSequence)serialisedBytes, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
    }

    @Test(expected=NotSerializableException.class, timeout=300000L)
    public final void abstractMapFromMapOf() {
        Map map = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"A", (Object)1), TuplesKt.to((Object)"B", (Object)2)});
        if (map == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.AbstractMap<kotlin.String, kotlin.Int>");
        }
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000#\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J$\u0010\n\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0004H\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"net/corda/serialization/internal/amqp/DeserializeMapTests$abstractMapFromMapOf$C", "", "c", "Ljava/util/AbstractMap;", "", "", "(Ljava/util/AbstractMap;)V", "getC", "()Ljava/util/AbstractMap;", "component1", "copy", "(Ljava/util/AbstractMap;)Lnet/corda/serialization/internal/amqp/DeserializeMapTests$abstractMapFromMapOf$C;", "equals", "", "other", "hashCode", "toString", "serialization"})
        public final class C {
            @NotNull
            private final AbstractMap<String, Integer> c;

            @NotNull
            public final AbstractMap<String, Integer> getC() {
                return this.c;
            }

            public C(@NotNull AbstractMap<String, Integer> c) {
                Intrinsics.checkParameterIsNotNull(c, (String)"c");
                this.c = c;
            }

            @NotNull
            public final AbstractMap<String, Integer> component1() {
                return this.c;
            }

            @NotNull
            public final C copy(@NotNull AbstractMap<String, Integer> c) {
                Intrinsics.checkParameterIsNotNull(c, (String)"c");
                return new C(c);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ C copy$default(C c, AbstractMap abstractMap, int n, Object object) {
                if ((n & 1) != 0) {
                    abstractMap = c.c;
                }
                return c.copy(abstractMap);
            }

            @NotNull
            public String toString() {
                return "C(c=" + this.c + ")";
            }

            public int hashCode() {
                AbstractMap<String, Integer> abstractMap = this.c;
                return abstractMap != null ? ((Object)abstractMap).hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof C)) break block3;
                        C c = (C)object;
                        if (!Intrinsics.areEqual(this.c, c.c)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        C c = new C((AbstractMap)map);
        SerializedBytes<C> serialisedBytes = new TestSerializationOutput(false, this.sf).serialize(c);
        DeserializationInput $receiver$iv = new DeserializationInput(this.sf);
        SerializationContext context$iv = null;
        $receiver$iv.deserialize((ByteSequence)serialisedBytes, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
    }

    @Test(expected=NotSerializableException.class, timeout=300000L)
    public final void abstractMapFromTreeMap() {
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000#\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J$\u0010\n\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0004H\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"net/corda/serialization/internal/amqp/DeserializeMapTests$abstractMapFromTreeMap$C", "", "c", "Ljava/util/AbstractMap;", "", "", "(Ljava/util/AbstractMap;)V", "getC", "()Ljava/util/AbstractMap;", "component1", "copy", "(Ljava/util/AbstractMap;)Lnet/corda/serialization/internal/amqp/DeserializeMapTests$abstractMapFromTreeMap$C;", "equals", "", "other", "hashCode", "toString", "serialization"})
        public final class C {
            @NotNull
            private final AbstractMap<String, Integer> c;

            @NotNull
            public final AbstractMap<String, Integer> getC() {
                return this.c;
            }

            public C(@NotNull AbstractMap<String, Integer> c) {
                Intrinsics.checkParameterIsNotNull(c, (String)"c");
                this.c = c;
            }

            @NotNull
            public final AbstractMap<String, Integer> component1() {
                return this.c;
            }

            @NotNull
            public final C copy(@NotNull AbstractMap<String, Integer> c) {
                Intrinsics.checkParameterIsNotNull(c, (String)"c");
                return new C(c);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ C copy$default(C c, AbstractMap abstractMap, int n, Object object) {
                if ((n & 1) != 0) {
                    abstractMap = c.c;
                }
                return c.copy(abstractMap);
            }

            @NotNull
            public String toString() {
                return "C(c=" + this.c + ")";
            }

            public int hashCode() {
                AbstractMap<String, Integer> abstractMap = this.c;
                return abstractMap != null ? ((Object)abstractMap).hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof C)) break block3;
                        C c = (C)object;
                        if (!Intrinsics.areEqual(this.c, c.c)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        C c = new C(new TreeMap(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"A", (Object)1), TuplesKt.to((Object)"B", (Object)2)})));
        SerializedBytes<C> serialisedBytes = new TestSerializationOutput(false, this.sf).serialize(c);
        DeserializationInput $receiver$iv = new DeserializationInput(this.sf);
        SerializationContext context$iv = null;
        $receiver$iv.deserialize((ByteSequence)serialisedBytes, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
    }

    @Test(timeout=300000L)
    public final void sortedMapTest() {
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000#\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J$\u0010\n\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0004H\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"net/corda/serialization/internal/amqp/DeserializeMapTests$sortedMapTest$C", "", "c", "Ljava/util/SortedMap;", "", "", "(Ljava/util/SortedMap;)V", "getC", "()Ljava/util/SortedMap;", "component1", "copy", "(Ljava/util/SortedMap;)Lnet/corda/serialization/internal/amqp/DeserializeMapTests$sortedMapTest$C;", "equals", "", "other", "hashCode", "toString", "serialization"})
        public final class C {
            @NotNull
            private final SortedMap<String, Integer> c;

            @NotNull
            public final SortedMap<String, Integer> getC() {
                return this.c;
            }

            public C(@NotNull SortedMap<String, Integer> c) {
                Intrinsics.checkParameterIsNotNull(c, (String)"c");
                this.c = c;
            }

            @NotNull
            public final SortedMap<String, Integer> component1() {
                return this.c;
            }

            @NotNull
            public final C copy(@NotNull SortedMap<String, Integer> c) {
                Intrinsics.checkParameterIsNotNull(c, (String)"c");
                return new C(c);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ C copy$default(C c, SortedMap sortedMap, int n, Object object) {
                if ((n & 1) != 0) {
                    sortedMap = c.c;
                }
                return c.copy(sortedMap);
            }

            @NotNull
            public String toString() {
                return "C(c=" + this.c + ")";
            }

            public int hashCode() {
                SortedMap<String, Integer> sortedMap = this.c;
                return sortedMap != null ? sortedMap.hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof C)) break block3;
                        C c = (C)object;
                        if (!Intrinsics.areEqual(this.c, c.c)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        C c = new C(MapsKt.sortedMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"A", (Object)1), TuplesKt.to((Object)"B", (Object)2)}));
        SerializedBytes<C> serialisedBytes = new TestSerializationOutput(false, this.sf).serialize(c);
        DeserializationInput $receiver$iv = new DeserializationInput(this.sf);
        SerializationContext context$iv = null;
        $receiver$iv.deserialize((ByteSequence)serialisedBytes, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
    }

    @Test(timeout=300000L)
    public final void navigableMapTest() {
        NavigableMap<String, Integer> navigableMap = new TreeMap(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"A", (Object)1), TuplesKt.to((Object)"B", (Object)2)})).descendingMap();
        Intrinsics.checkExpressionValueIsNotNull(navigableMap, (String)"TreeMap(mapOf(\"A\" to 1, \"B\" to 2)).descendingMap()");
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000#\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J$\u0010\n\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0004H\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"net/corda/serialization/internal/amqp/DeserializeMapTests$navigableMapTest$C", "", "c", "Ljava/util/NavigableMap;", "", "", "(Ljava/util/NavigableMap;)V", "getC", "()Ljava/util/NavigableMap;", "component1", "copy", "(Ljava/util/NavigableMap;)Lnet/corda/serialization/internal/amqp/DeserializeMapTests$navigableMapTest$C;", "equals", "", "other", "hashCode", "toString", "serialization"})
        public final class C {
            @NotNull
            private final NavigableMap<String, Integer> c;

            @NotNull
            public final NavigableMap<String, Integer> getC() {
                return this.c;
            }

            public C(@NotNull NavigableMap<String, Integer> c) {
                Intrinsics.checkParameterIsNotNull(c, (String)"c");
                this.c = c;
            }

            @NotNull
            public final NavigableMap<String, Integer> component1() {
                return this.c;
            }

            @NotNull
            public final C copy(@NotNull NavigableMap<String, Integer> c) {
                Intrinsics.checkParameterIsNotNull(c, (String)"c");
                return new C(c);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ C copy$default(C c, NavigableMap navigableMap, int n, Object object) {
                if ((n & 1) != 0) {
                    navigableMap = c.c;
                }
                return c.copy(navigableMap);
            }

            @NotNull
            public String toString() {
                return "C(c=" + this.c + ")";
            }

            public int hashCode() {
                NavigableMap<String, Integer> navigableMap = this.c;
                return navigableMap != null ? navigableMap.hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof C)) break block3;
                        C c = (C)object;
                        if (!Intrinsics.areEqual(this.c, c.c)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        C c = new C(navigableMap);
        SerializedBytes<C> serialisedBytes = new TestSerializationOutput(false, this.sf).serialize(c);
        DeserializationInput $receiver$iv = new DeserializationInput(this.sf);
        SerializationContext context$iv = null;
        $receiver$iv.deserialize((ByteSequence)serialisedBytes, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
    }

    @Test(timeout=300000L)
    public final void dictionaryTest() {
        Hashtable v = new Hashtable();
        Map map = v;
        String string = "a";
        Integer n = 1;
        map.put(string, n);
        map = v;
        string = "b";
        n = 2;
        map.put(string, n);
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000#\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J$\u0010\n\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0004H\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"net/corda/serialization/internal/amqp/DeserializeMapTests$dictionaryTest$C", "", "c", "Ljava/util/Dictionary;", "", "", "(Ljava/util/Dictionary;)V", "getC", "()Ljava/util/Dictionary;", "component1", "copy", "(Ljava/util/Dictionary;)Lnet/corda/serialization/internal/amqp/DeserializeMapTests$dictionaryTest$C;", "equals", "", "other", "hashCode", "toString", "serialization"})
        public final class C {
            @NotNull
            private final Dictionary<String, Integer> c;

            @NotNull
            public final Dictionary<String, Integer> getC() {
                return this.c;
            }

            public C(@NotNull Dictionary<String, Integer> c) {
                Intrinsics.checkParameterIsNotNull(c, (String)"c");
                this.c = c;
            }

            @NotNull
            public final Dictionary<String, Integer> component1() {
                return this.c;
            }

            @NotNull
            public final C copy(@NotNull Dictionary<String, Integer> c) {
                Intrinsics.checkParameterIsNotNull(c, (String)"c");
                return new C(c);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ C copy$default(C c, Dictionary dictionary, int n, Object object) {
                if ((n & 1) != 0) {
                    dictionary = c.c;
                }
                return c.copy(dictionary);
            }

            @NotNull
            public String toString() {
                return "C(c=" + this.c + ")";
            }

            public int hashCode() {
                Dictionary<String, Integer> dictionary = this.c;
                return dictionary != null ? dictionary.hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof C)) break block3;
                        C c = (C)object;
                        if (!Intrinsics.areEqual(this.c, c.c)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        C c = new C(v);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)new ThrowableAssert.ThrowingCallable(this, c){
            final /* synthetic */ DeserializeMapTests this$0;
            final /* synthetic */ C $c;

            public final void call() {
                new TestSerializationOutput(false, DeserializeMapTests.access$getSf$p(this.this$0)).serialize(this.$c);
            }
            {
                this.this$0 = deserializeMapTests;
                this.$c = c;
            }
        }).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Unable to serialise deprecated type class java.util.Dictionary.");
    }

    @Test(timeout=300000L)
    public final void hashtableTest() {
        Hashtable<String, Integer> v = new Hashtable<String, Integer>();
        Map map = v;
        String string = "a";
        Integer n = 1;
        map.put(string, n);
        map = v;
        string = "b";
        n = 2;
        map.put(string, n);
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000#\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J$\u0010\n\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0004H\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"net/corda/serialization/internal/amqp/DeserializeMapTests$hashtableTest$C", "", "c", "Ljava/util/Hashtable;", "", "", "(Ljava/util/Hashtable;)V", "getC", "()Ljava/util/Hashtable;", "component1", "copy", "(Ljava/util/Hashtable;)Lnet/corda/serialization/internal/amqp/DeserializeMapTests$hashtableTest$C;", "equals", "", "other", "hashCode", "toString", "serialization"})
        public final class C {
            @NotNull
            private final Hashtable<String, Integer> c;

            @NotNull
            public final Hashtable<String, Integer> getC() {
                return this.c;
            }

            public C(@NotNull Hashtable<String, Integer> c) {
                Intrinsics.checkParameterIsNotNull(c, (String)"c");
                this.c = c;
            }

            @NotNull
            public final Hashtable<String, Integer> component1() {
                return this.c;
            }

            @NotNull
            public final C copy(@NotNull Hashtable<String, Integer> c) {
                Intrinsics.checkParameterIsNotNull(c, (String)"c");
                return new C(c);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ C copy$default(C c, Hashtable hashtable, int n, Object object) {
                if ((n & 1) != 0) {
                    hashtable = c.c;
                }
                return c.copy(hashtable);
            }

            @NotNull
            public String toString() {
                return "C(c=" + this.c + ")";
            }

            public int hashCode() {
                Hashtable<String, Integer> hashtable = this.c;
                return hashtable != null ? ((Object)hashtable).hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof C)) break block3;
                        C c = (C)object;
                        if (!Intrinsics.areEqual(this.c, c.c)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        C c = new C(v);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)new ThrowableAssert.ThrowingCallable(this, c){
            final /* synthetic */ DeserializeMapTests this$0;
            final /* synthetic */ C $c;

            public final void call() {
                new TestSerializationOutput(false, DeserializeMapTests.access$getSf$p(this.this$0)).serialize(this.$c);
            }
            {
                this.this$0 = deserializeMapTests;
                this.$c = c;
            }
        }).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Unable to serialise deprecated type class java.util.Hashtable. Suggested fix: prefer java.util.map implementations");
    }

    @Test(timeout=300000L)
    public final void hashMapTest() {
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000#\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J$\u0010\n\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0004H\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"net/corda/serialization/internal/amqp/DeserializeMapTests$hashMapTest$C", "", "c", "Ljava/util/HashMap;", "", "", "(Ljava/util/HashMap;)V", "getC", "()Ljava/util/HashMap;", "component1", "copy", "(Ljava/util/HashMap;)Lnet/corda/serialization/internal/amqp/DeserializeMapTests$hashMapTest$C;", "equals", "", "other", "hashCode", "toString", "serialization"})
        public final class C {
            @NotNull
            private final HashMap<String, Integer> c;

            @NotNull
            public final HashMap<String, Integer> getC() {
                return this.c;
            }

            public C(@NotNull HashMap<String, Integer> c) {
                Intrinsics.checkParameterIsNotNull(c, (String)"c");
                this.c = c;
            }

            @NotNull
            public final HashMap<String, Integer> component1() {
                return this.c;
            }

            @NotNull
            public final C copy(@NotNull HashMap<String, Integer> c) {
                Intrinsics.checkParameterIsNotNull(c, (String)"c");
                return new C(c);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ C copy$default(C c, HashMap hashMap, int n, Object object) {
                if ((n & 1) != 0) {
                    hashMap = c.c;
                }
                return c.copy(hashMap);
            }

            @NotNull
            public String toString() {
                return "C(c=" + this.c + ")";
            }

            public int hashCode() {
                HashMap<String, Integer> hashMap = this.c;
                return hashMap != null ? ((Object)hashMap).hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof C)) break block3;
                        C c = (C)object;
                        if (!Intrinsics.areEqual(this.c, c.c)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        C c = new C(new HashMap<String, Integer>(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"A", (Object)1), TuplesKt.to((Object)"B", (Object)2)})));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)new ThrowableAssert.ThrowingCallable(this, c){
            final /* synthetic */ DeserializeMapTests this$0;
            final /* synthetic */ C $c;

            public final void call() {
                new TestSerializationOutput(false, DeserializeMapTests.access$getSf$p(this.this$0)).serialize(this.$c);
            }
            {
                this.this$0 = deserializeMapTests;
                this.$c = c;
            }
        }).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Map type class java.util.HashMap is unstable under iteration. Suggested fix: use java.util.LinkedHashMap instead.");
    }

    @Test(timeout=300000L)
    public final void weakHashMapTest() {
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000#\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J$\u0010\n\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0004H\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"net/corda/serialization/internal/amqp/DeserializeMapTests$weakHashMapTest$C", "", "c", "Ljava/util/WeakHashMap;", "", "", "(Ljava/util/WeakHashMap;)V", "getC", "()Ljava/util/WeakHashMap;", "component1", "copy", "(Ljava/util/WeakHashMap;)Lnet/corda/serialization/internal/amqp/DeserializeMapTests$weakHashMapTest$C;", "equals", "", "other", "hashCode", "toString", "serialization"})
        public final class C {
            @NotNull
            private final WeakHashMap<String, Integer> c;

            @NotNull
            public final WeakHashMap<String, Integer> getC() {
                return this.c;
            }

            public C(@NotNull WeakHashMap<String, Integer> c) {
                Intrinsics.checkParameterIsNotNull(c, (String)"c");
                this.c = c;
            }

            @NotNull
            public final WeakHashMap<String, Integer> component1() {
                return this.c;
            }

            @NotNull
            public final C copy(@NotNull WeakHashMap<String, Integer> c) {
                Intrinsics.checkParameterIsNotNull(c, (String)"c");
                return new C(c);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ C copy$default(C c, WeakHashMap weakHashMap, int n, Object object) {
                if ((n & 1) != 0) {
                    weakHashMap = c.c;
                }
                return c.copy(weakHashMap);
            }

            @NotNull
            public String toString() {
                return "C(c=" + this.c + ")";
            }

            public int hashCode() {
                WeakHashMap<String, Integer> weakHashMap = this.c;
                return weakHashMap != null ? ((Object)weakHashMap).hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof C)) break block3;
                        C c = (C)object;
                        if (!Intrinsics.areEqual(this.c, c.c)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        C c = new C(new WeakHashMap<String, Integer>(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"A", (Object)1), TuplesKt.to((Object)"B", (Object)2)})));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)new ThrowableAssert.ThrowingCallable(this, c){
            final /* synthetic */ DeserializeMapTests this$0;
            final /* synthetic */ C $c;

            public final void call() {
                new TestSerializationOutput(false, DeserializeMapTests.access$getSf$p(this.this$0)).serialize(this.$c);
            }
            {
                this.this$0 = deserializeMapTests;
                this.$c = c;
            }
        }).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Weak references with map types not supported. Suggested fix: use java.util.LinkedHashMap instead.");
    }

    @Test(timeout=300000L)
    public final void concreteTreeMapTest() {
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000#\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J$\u0010\n\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0004H\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"net/corda/serialization/internal/amqp/DeserializeMapTests$concreteTreeMapTest$C", "", "c", "Ljava/util/TreeMap;", "", "", "(Ljava/util/TreeMap;)V", "getC", "()Ljava/util/TreeMap;", "component1", "copy", "(Ljava/util/TreeMap;)Lnet/corda/serialization/internal/amqp/DeserializeMapTests$concreteTreeMapTest$C;", "equals", "", "other", "hashCode", "toString", "serialization"})
        public final class C {
            @NotNull
            private final TreeMap<String, Integer> c;

            @NotNull
            public final TreeMap<String, Integer> getC() {
                return this.c;
            }

            public C(@NotNull TreeMap<String, Integer> c) {
                Intrinsics.checkParameterIsNotNull(c, (String)"c");
                this.c = c;
            }

            @NotNull
            public final TreeMap<String, Integer> component1() {
                return this.c;
            }

            @NotNull
            public final C copy(@NotNull TreeMap<String, Integer> c) {
                Intrinsics.checkParameterIsNotNull(c, (String)"c");
                return new C(c);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ C copy$default(C c, TreeMap treeMap, int n, Object object) {
                if ((n & 1) != 0) {
                    treeMap = c.c;
                }
                return c.copy(treeMap);
            }

            @NotNull
            public String toString() {
                return "C(c=" + this.c + ")";
            }

            public int hashCode() {
                TreeMap<String, Integer> treeMap = this.c;
                return treeMap != null ? ((Object)treeMap).hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof C)) break block3;
                        C c = (C)object;
                        if (!Intrinsics.areEqual(this.c, c.c)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        C c = new C(new TreeMap<String, Integer>(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"A", (Object)1), TuplesKt.to((Object)"B", (Object)3)})));
        SerializedBytes<C> serialisedBytes = new TestSerializationOutput(false, this.sf).serialize(c);
        DeserializationInput $receiver$iv = new DeserializationInput(this.sf);
        SerializationContext context$iv = null;
        $receiver$iv.deserialize((ByteSequence)serialisedBytes, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
    }

    @Test(timeout=300000L)
    public final void concreteLinkedHashMapTest() {
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000#\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J$\u0010\n\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0004H\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"net/corda/serialization/internal/amqp/DeserializeMapTests$concreteLinkedHashMapTest$C", "", "c", "Ljava/util/LinkedHashMap;", "", "", "(Ljava/util/LinkedHashMap;)V", "getC", "()Ljava/util/LinkedHashMap;", "component1", "copy", "(Ljava/util/LinkedHashMap;)Lnet/corda/serialization/internal/amqp/DeserializeMapTests$concreteLinkedHashMapTest$C;", "equals", "", "other", "hashCode", "toString", "serialization"})
        public final class C {
            @NotNull
            private final LinkedHashMap<String, Integer> c;

            @NotNull
            public final LinkedHashMap<String, Integer> getC() {
                return this.c;
            }

            public C(@NotNull LinkedHashMap<String, Integer> c) {
                Intrinsics.checkParameterIsNotNull(c, (String)"c");
                this.c = c;
            }

            @NotNull
            public final LinkedHashMap<String, Integer> component1() {
                return this.c;
            }

            @NotNull
            public final C copy(@NotNull LinkedHashMap<String, Integer> c) {
                Intrinsics.checkParameterIsNotNull(c, (String)"c");
                return new C(c);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ C copy$default(C c, LinkedHashMap linkedHashMap, int n, Object object) {
                if ((n & 1) != 0) {
                    linkedHashMap = c.c;
                }
                return c.copy(linkedHashMap);
            }

            @NotNull
            public String toString() {
                return "C(c=" + this.c + ")";
            }

            public int hashCode() {
                LinkedHashMap<String, Integer> linkedHashMap = this.c;
                return linkedHashMap != null ? ((Object)linkedHashMap).hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof C)) break block3;
                        C c = (C)object;
                        if (!Intrinsics.areEqual(this.c, c.c)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        C c = new C(new LinkedHashMap<String, Integer>(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"A", (Object)1), TuplesKt.to((Object)"B", (Object)2)})));
        SerializedBytes<C> serialisedBytes = new TestSerializationOutput(false, this.sf).serialize(c);
        DeserializationInput $receiver$iv = new DeserializationInput(this.sf);
        SerializationContext context$iv = null;
        $receiver$iv.deserialize((ByteSequence)serialisedBytes, C.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
    }

    @NotNull
    public static final /* synthetic */ SerializerFactory access$getSf$p(DeserializeMapTests $this) {
        return $this.sf;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnet/corda/serialization/internal/amqp/DeserializeMapTests$Companion;", "", "()V", "VERBOSE", "", "serialization"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

