/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp;

import java.io.NotSerializableException;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.test.AssertionsKt;
import net.corda.core.serialization.ClassWhitelist;
import net.corda.core.serialization.SerializationContext;
import net.corda.core.serialization.SerializationCustomSerializer;
import net.corda.core.serialization.SerializedBytes;
import net.corda.core.utilities.ByteSequence;
import net.corda.serialization.internal.AllWhitelist;
import net.corda.serialization.internal.amqp.BytesAndSchemas;
import net.corda.serialization.internal.amqp.CorDappCustomSerializer;
import net.corda.serialization.internal.amqp.CorDappSerializerTests;
import net.corda.serialization.internal.amqp.CustomSerializer;
import net.corda.serialization.internal.amqp.DeserializationInput;
import net.corda.serialization.internal.amqp.LocalSerializerFactory;
import net.corda.serialization.internal.amqp.ObjectAndEnvelope;
import net.corda.serialization.internal.amqp.SerializationOutput;
import net.corda.serialization.internal.amqp.SerializerFactory;
import net.corda.serialization.internal.amqp.SerializerFactoryBuilder;
import net.corda.serialization.internal.amqp.testutils.AMQPTestUtilsKt;
import net.corda.serialization.internal.amqp.testutils.TestSerializationContextKt;
import net.corda.serialization.internal.carpenter.ClassCarpenter;
import net.corda.serialization.internal.carpenter.ClassCarpenterImpl;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableAssert;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0015\u0018\u00002\u00020\u0001:\u0010\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f !B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007J\b\u0010\u0006\u001a\u00020\u0004H\u0007J\b\u0010\u0007\u001a\u00020\u0004H\u0007J\b\u0010\b\u001a\u00020\u0004H\u0007J\u001e\u0010\t\u001a\u00020\n2\u0014\u0010\u000b\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\r0\fH\u0002J\b\u0010\u000e\u001a\u00020\u0004H\u0007J\b\u0010\u000f\u001a\u00020\u0004H\u0007J\b\u0010\u0010\u001a\u00020\u0004H\u0007J\b\u0010\u0011\u001a\u00020\u0004H\u0007\u00a8\u0006\""}, d2={"Lnet/corda/serialization/internal/amqp/CorDappSerializerTests;", "", "()V", "proxiedBoundedGeneric", "", "proxiedGeneric", "proxiedGenericContainer", "proxiedInheritableGenerics", "proxiedTypeIsNested", "proxyFactory", "Lnet/corda/serialization/internal/amqp/SerializerFactory;", "serializers", "", "Lnet/corda/core/serialization/SerializationCustomSerializer;", "testWithWhitelistAllowed", "testWithWhitelistAllowedOuterOnly", "testWithWhitelistNotAllowed", "type uses proxy", "Base", "BaseProxy", "Bound", "Derived", "DerivedProxy", "HasWibble", "HasWibbleProxy", "InternalProxySerializer", "NeedsProxy", "NeedsProxyGen", "NeedsProxyGenBounded", "NeedsProxyGenBoundedProxySerializer", "NeedsProxyGenContainer", "NeedsProxyGenContainerProxySerializer", "NeedsProxyGenProxySerializer", "NeedsProxyProxySerializer", "serialization"})
public final class CorDappSerializerTests {
    private final SerializerFactory proxyFactory(List<? extends SerializationCustomSerializer<?, ?>> serializers) {
        SerializerFactory serializerFactory;
        ClassWhitelist classWhitelist = (ClassWhitelist)AllWhitelist.INSTANCE;
        ClassWhitelist classWhitelist2 = (ClassWhitelist)AllWhitelist.INSTANCE;
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        Intrinsics.checkExpressionValueIsNotNull((Object)classLoader, (String)"ClassLoader.getSystemClassLoader()");
        SerializerFactory $receiver = serializerFactory = SerializerFactoryBuilder.build((ClassWhitelist)classWhitelist, (ClassCarpenter)((ClassCarpenter)new ClassCarpenterImpl(classWhitelist2, classLoader, false, 4, null)));
        Iterable $receiver$iv = serializers;
        for (Object element$iv : $receiver$iv) {
            SerializationCustomSerializer it = (SerializationCustomSerializer)element$iv;
            $receiver.registerExternal(new CorDappCustomSerializer(it, $receiver));
        }
        return serializerFactory;
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void type uses proxy() {
        void $receiver$iv;
        void $receiver$iv2;
        void $receiver$iv3;
        SerializerFactory internalProxyFactory = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        SerializerFactory proxyFactory = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        SerializerFactory defaultFactory = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        String msg = "help";
        proxyFactory.registerExternal(new CorDappCustomSerializer((SerializationCustomSerializer)new NeedsProxyProxySerializer(), proxyFactory));
        internalProxyFactory.register((CustomSerializer)new InternalProxySerializer(internalProxyFactory));
        NeedsProxy needsProxy = new NeedsProxy(msg);
        BytesAndSchemas bAndSProxy = AMQPTestUtilsKt.serializeAndReturnSchema$default(new SerializationOutput((LocalSerializerFactory)proxyFactory), needsProxy, null, 2, null);
        BytesAndSchemas bAndSInternal = AMQPTestUtilsKt.serializeAndReturnSchema$default(new SerializationOutput((LocalSerializerFactory)internalProxyFactory), needsProxy, null, 2, null);
        BytesAndSchemas bAndSDefault = AMQPTestUtilsKt.serializeAndReturnSchema$default(new SerializationOutput((LocalSerializerFactory)defaultFactory), needsProxy, null, 2, null);
        DeserializationInput deserializationInput = new DeserializationInput(defaultFactory);
        SerializedBytes bytes$iv = bAndSDefault.getObj();
        SerializationContext context$iv = null;
        ObjectAndEnvelope objFromDefault = $receiver$iv3.deserializeAndReturnEnvelope(bytes$iv, NeedsProxy.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        bytes$iv = new DeserializationInput(internalProxyFactory);
        SerializedBytes bytes$iv2 = bAndSInternal.getObj();
        SerializationContext context$iv2 = null;
        ObjectAndEnvelope objFromInternal = $receiver$iv2.deserializeAndReturnEnvelope(bytes$iv2, NeedsProxy.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        bytes$iv2 = new DeserializationInput(proxyFactory);
        SerializedBytes bytes$iv3 = bAndSProxy.getObj();
        SerializationContext context$iv3 = null;
        ObjectAndEnvelope objFromProxy = $receiver$iv.deserializeAndReturnEnvelope(bytes$iv3, NeedsProxy.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)msg, (Object)((NeedsProxy)objFromDefault.getObj()).getA(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)msg, (Object)((NeedsProxy)objFromInternal.getObj()).getA(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)msg, (Object)((NeedsProxy)objFromProxy.getObj()).getA(), null, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void proxiedTypeIsNested() {
        void $receiver$iv;
        SerializerFactory factory = AMQPTestUtilsKt.testDefaultFactory$default(null, 1, null);
        factory.registerExternal(new CorDappCustomSerializer((SerializationCustomSerializer)new NeedsProxyProxySerializer(), factory));
        int tv1 = 100;
        String tv2 = "pants schmants";
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000'\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\"\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000eJ\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"net/corda/serialization/internal/amqp/CorDappSerializerTests$proxiedTypeIsNested$A", "", "a", "", "b", "Lnet/corda/serialization/internal/amqp/CorDappSerializerTests$NeedsProxy;", "(ILnet/corda/serialization/internal/amqp/CorDappSerializerTests$NeedsProxy;)V", "getA", "()I", "getB", "()Lnet/corda/serialization/internal/amqp/CorDappSerializerTests$NeedsProxy;", "component1", "component2", "copy", "(ILnet/corda/serialization/internal/amqp/CorDappSerializerTests$NeedsProxy;)Lnet/corda/serialization/internal/amqp/CorDappSerializerTests$proxiedTypeIsNested$A;", "equals", "", "other", "hashCode", "toString", "", "serialization"})
        public final class A {
            private final int a;
            @NotNull
            private final NeedsProxy b;

            public final int getA() {
                return this.a;
            }

            @NotNull
            public final NeedsProxy getB() {
                return this.b;
            }

            public A(int a, @NotNull NeedsProxy b) {
                Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
                this.a = a;
                this.b = b;
            }

            public final int component1() {
                return this.a;
            }

            @NotNull
            public final NeedsProxy component2() {
                return this.b;
            }

            @NotNull
            public final A copy(int a, @NotNull NeedsProxy b) {
                Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
                return new A(a, b);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ A copy$default(A a, int n, NeedsProxy needsProxy, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = a.a;
                }
                if ((n2 & 2) != 0) {
                    needsProxy = a.b;
                }
                return a.copy(n, needsProxy);
            }

            @NotNull
            public String toString() {
                return "A(a=" + this.a + ", b=" + this.b + ")";
            }

            public int hashCode() {
                NeedsProxy needsProxy = this.b;
                return Integer.hashCode(this.a) * 31 + (needsProxy != null ? ((Object)needsProxy).hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof A)) break block3;
                        A a = (A)object;
                        if (!(this.a == a.a) || !Intrinsics.areEqual((Object)this.b, (Object)a.b)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        BytesAndSchemas bAndS = AMQPTestUtilsKt.serializeAndReturnSchema$default(new SerializationOutput((LocalSerializerFactory)factory), new A(tv1, new NeedsProxy(tv2)), null, 2, null);
        DeserializationInput deserializationInput = new DeserializationInput(factory);
        SerializedBytes bytes$iv = bAndS.getObj();
        SerializationContext context$iv = null;
        ObjectAndEnvelope objFromDefault = $receiver$iv.deserializeAndReturnEnvelope(bytes$iv, A.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)tv1, (Object)((A)objFromDefault.getObj()).getA(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)tv2, (Object)((A)objFromDefault.getObj()).getB().getA(), null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void testWithWhitelistNotAllowed() {
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"net/corda/serialization/internal/amqp/CorDappSerializerTests$testWithWhitelistNotAllowed$WL", "Lnet/corda/core/serialization/ClassWhitelist;", "()V", "allowedClasses", "", "", "hasListed", "", "type", "Ljava/lang/Class;", "serialization"})
        public final class WL
        implements ClassWhitelist {
            private final Set<String> allowedClasses;

            public boolean hasListed(@NotNull Class<?> type2) {
                Intrinsics.checkParameterIsNotNull(type2, (String)"type");
                return this.allowedClasses.contains(type2.getName());
            }

            public WL() {
                this.allowedClasses = SetsKt.emptySet();
            }
        }
        WL whitelist = new WL();
        ClassWhitelist classWhitelist = whitelist;
        ClassWhitelist classWhitelist2 = whitelist;
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        Intrinsics.checkExpressionValueIsNotNull((Object)classLoader, (String)"ClassLoader.getSystemClassLoader()");
        SerializerFactory factory = SerializerFactoryBuilder.build((ClassWhitelist)classWhitelist, (ClassCarpenter)((ClassCarpenter)new ClassCarpenterImpl(classWhitelist2, classLoader, false, 4, null)));
        factory.registerExternal(new CorDappCustomSerializer((SerializationCustomSerializer)new NeedsProxyProxySerializer(), factory));
        int tv1 = 100;
        String tv2 = "pants schmants";
        Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)new ThrowableAssert.ThrowingCallable(factory, tv1, tv2){
            final /* synthetic */ SerializerFactory $factory;
            final /* synthetic */ int $tv1;
            final /* synthetic */ String $tv2;

            public final void call() {
                @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000'\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\"\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000eJ\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"net/corda/serialization/internal/amqp/CorDappSerializerTests$testWithWhitelistNotAllowed$A", "", "a", "", "b", "Lnet/corda/serialization/internal/amqp/CorDappSerializerTests$NeedsProxy;", "(ILnet/corda/serialization/internal/amqp/CorDappSerializerTests$NeedsProxy;)V", "getA", "()I", "getB", "()Lnet/corda/serialization/internal/amqp/CorDappSerializerTests$NeedsProxy;", "component1", "component2", "copy", "(ILnet/corda/serialization/internal/amqp/CorDappSerializerTests$NeedsProxy;)Lnet/corda/serialization/internal/amqp/CorDappSerializerTests$testWithWhitelistNotAllowed$A;", "equals", "", "other", "hashCode", "toString", "", "serialization"})
                public final class A {
                    private final int a;
                    @NotNull
                    private final NeedsProxy b;

                    public final int getA() {
                        return this.a;
                    }

                    @NotNull
                    public final NeedsProxy getB() {
                        return this.b;
                    }

                    public A(int a, @NotNull NeedsProxy b) {
                        Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
                        this.a = a;
                        this.b = b;
                    }

                    public final int component1() {
                        return this.a;
                    }

                    @NotNull
                    public final NeedsProxy component2() {
                        return this.b;
                    }

                    @NotNull
                    public final A copy(int a, @NotNull NeedsProxy b) {
                        Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
                        return new A(a, b);
                    }

                    @NotNull
                    public static /* bridge */ /* synthetic */ A copy$default(A a, int n, NeedsProxy needsProxy, int n2, Object object) {
                        if ((n2 & 1) != 0) {
                            n = a.a;
                        }
                        if ((n2 & 2) != 0) {
                            needsProxy = a.b;
                        }
                        return a.copy(n, needsProxy);
                    }

                    @NotNull
                    public String toString() {
                        return "A(a=" + this.a + ", b=" + this.b + ")";
                    }

                    public int hashCode() {
                        NeedsProxy needsProxy = this.b;
                        return Integer.hashCode(this.a) * 31 + (needsProxy != null ? ((Object)needsProxy).hashCode() : 0);
                    }

                    public boolean equals(@Nullable Object object) {
                        block3: {
                            block2: {
                                if (this == object) break block2;
                                if (!(object instanceof A)) break block3;
                                A a = (A)object;
                                if (!(this.a == a.a) || !Intrinsics.areEqual((Object)this.b, (Object)a.b)) break block3;
                            }
                            return true;
                        }
                        return false;
                    }
                }
                AMQPTestUtilsKt.serialize$default(new SerializationOutput((LocalSerializerFactory)this.$factory), new A(this.$tv1, new NeedsProxy(this.$tv2)), null, 2, null);
            }
            {
                this.$factory = serializerFactory;
                this.$tv1 = n;
                this.$tv2 = string;
            }
        }).isInstanceOf(NotSerializableException.class);
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void testWithWhitelistAllowed() {
        void bytes$iv;
        void $receiver$iv;
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"net/corda/serialization/internal/amqp/CorDappSerializerTests$testWithWhitelistAllowed$WL", "Lnet/corda/core/serialization/ClassWhitelist;", "()V", "allowedClasses", "", "", "hasListed", "", "type", "Ljava/lang/Class;", "serialization"})
        public final class WL
        implements ClassWhitelist {
            private final Set<String> allowedClasses;

            public boolean hasListed(@NotNull Class<?> type2) {
                Intrinsics.checkParameterIsNotNull(type2, (String)"type");
                return this.allowedClasses.contains(type2.getName());
            }

            public WL() {
                Object[] objectArray = new String[2];
                @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000'\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\"\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000eJ\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"net/corda/serialization/internal/amqp/CorDappSerializerTests$testWithWhitelistAllowed$A", "", "a", "", "b", "Lnet/corda/serialization/internal/amqp/CorDappSerializerTests$NeedsProxy;", "(ILnet/corda/serialization/internal/amqp/CorDappSerializerTests$NeedsProxy;)V", "getA", "()I", "getB", "()Lnet/corda/serialization/internal/amqp/CorDappSerializerTests$NeedsProxy;", "component1", "component2", "copy", "(ILnet/corda/serialization/internal/amqp/CorDappSerializerTests$NeedsProxy;)Lnet/corda/serialization/internal/amqp/CorDappSerializerTests$testWithWhitelistAllowed$A;", "equals", "", "other", "hashCode", "toString", "", "serialization"})
                public final class A {
                    private final int a;
                    @NotNull
                    private final NeedsProxy b;

                    public final int getA() {
                        return this.a;
                    }

                    @NotNull
                    public final NeedsProxy getB() {
                        return this.b;
                    }

                    public A(int a, @NotNull NeedsProxy b) {
                        Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
                        this.a = a;
                        this.b = b;
                    }

                    public final int component1() {
                        return this.a;
                    }

                    @NotNull
                    public final NeedsProxy component2() {
                        return this.b;
                    }

                    @NotNull
                    public final A copy(int a, @NotNull NeedsProxy b) {
                        Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
                        return new A(a, b);
                    }

                    @NotNull
                    public static /* bridge */ /* synthetic */ A copy$default(A a, int n, NeedsProxy needsProxy, int n2, Object object) {
                        if ((n2 & 1) != 0) {
                            n = a.a;
                        }
                        if ((n2 & 2) != 0) {
                            needsProxy = a.b;
                        }
                        return a.copy(n, needsProxy);
                    }

                    @NotNull
                    public String toString() {
                        return "A(a=" + this.a + ", b=" + this.b + ")";
                    }

                    public int hashCode() {
                        NeedsProxy needsProxy = this.b;
                        return Integer.hashCode(this.a) * 31 + (needsProxy != null ? ((Object)needsProxy).hashCode() : 0);
                    }

                    public boolean equals(@Nullable Object object) {
                        block3: {
                            block2: {
                                if (this == object) break block2;
                                if (!(object instanceof A)) break block3;
                                A a = (A)object;
                                if (!(this.a == a.a) || !Intrinsics.areEqual((Object)this.b, (Object)a.b)) break block3;
                            }
                            return true;
                        }
                        return false;
                    }
                }
                String string = A.class.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"A::class.java.name");
                objectArray[0] = string;
                String string2 = NeedsProxy.class.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"NeedsProxy::class.java.name");
                objectArray[1] = string2;
                this.allowedClasses = SetsKt.setOf((Object[])objectArray);
            }
        }
        WL whitelist = new WL();
        ClassWhitelist classWhitelist = whitelist;
        ClassWhitelist classWhitelist2 = whitelist;
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        Intrinsics.checkExpressionValueIsNotNull((Object)classLoader, (String)"ClassLoader.getSystemClassLoader()");
        SerializerFactory factory = SerializerFactoryBuilder.build((ClassWhitelist)classWhitelist, (ClassCarpenter)((ClassCarpenter)new ClassCarpenterImpl(classWhitelist2, classLoader, false, 4, null)));
        factory.registerExternal(new CorDappCustomSerializer((SerializationCustomSerializer)new NeedsProxyProxySerializer(), factory));
        int tv1 = 100;
        String tv2 = "pants schmants";
        DeserializationInput deserializationInput = new DeserializationInput(factory);
        SerializedBytes serializedBytes = AMQPTestUtilsKt.serialize$default(new SerializationOutput((LocalSerializerFactory)factory), new A(tv1, new NeedsProxy(tv2)), null, 2, null);
        SerializationContext context$iv = null;
        A obj = (A)$receiver$iv.deserialize((ByteSequence)bytes$iv, A.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)tv1, (Object)obj.getA(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)tv2, (Object)obj.getB().getA(), null, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void testWithWhitelistAllowedOuterOnly() {
        void bytes$iv;
        void $receiver$iv;
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"net/corda/serialization/internal/amqp/CorDappSerializerTests$testWithWhitelistAllowedOuterOnly$WL", "Lnet/corda/core/serialization/ClassWhitelist;", "()V", "allowedClasses", "", "", "hasListed", "", "type", "Ljava/lang/Class;", "serialization"})
        public final class WL
        implements ClassWhitelist {
            private final Set<String> allowedClasses;

            public boolean hasListed(@NotNull Class<?> type2) {
                Intrinsics.checkParameterIsNotNull(type2, (String)"type");
                return this.allowedClasses.contains(type2.getName());
            }

            public WL() {
                @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000'\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\"\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000eJ\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"net/corda/serialization/internal/amqp/CorDappSerializerTests$testWithWhitelistAllowedOuterOnly$A", "", "a", "", "b", "Lnet/corda/serialization/internal/amqp/CorDappSerializerTests$NeedsProxy;", "(ILnet/corda/serialization/internal/amqp/CorDappSerializerTests$NeedsProxy;)V", "getA", "()I", "getB", "()Lnet/corda/serialization/internal/amqp/CorDappSerializerTests$NeedsProxy;", "component1", "component2", "copy", "(ILnet/corda/serialization/internal/amqp/CorDappSerializerTests$NeedsProxy;)Lnet/corda/serialization/internal/amqp/CorDappSerializerTests$testWithWhitelistAllowedOuterOnly$A;", "equals", "", "other", "hashCode", "toString", "", "serialization"})
                public final class A {
                    private final int a;
                    @NotNull
                    private final NeedsProxy b;

                    public final int getA() {
                        return this.a;
                    }

                    @NotNull
                    public final NeedsProxy getB() {
                        return this.b;
                    }

                    public A(int a, @NotNull NeedsProxy b) {
                        Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
                        this.a = a;
                        this.b = b;
                    }

                    public final int component1() {
                        return this.a;
                    }

                    @NotNull
                    public final NeedsProxy component2() {
                        return this.b;
                    }

                    @NotNull
                    public final A copy(int a, @NotNull NeedsProxy b) {
                        Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
                        return new A(a, b);
                    }

                    @NotNull
                    public static /* bridge */ /* synthetic */ A copy$default(A a, int n, NeedsProxy needsProxy, int n2, Object object) {
                        if ((n2 & 1) != 0) {
                            n = a.a;
                        }
                        if ((n2 & 2) != 0) {
                            needsProxy = a.b;
                        }
                        return a.copy(n, needsProxy);
                    }

                    @NotNull
                    public String toString() {
                        return "A(a=" + this.a + ", b=" + this.b + ")";
                    }

                    public int hashCode() {
                        NeedsProxy needsProxy = this.b;
                        return Integer.hashCode(this.a) * 31 + (needsProxy != null ? ((Object)needsProxy).hashCode() : 0);
                    }

                    public boolean equals(@Nullable Object object) {
                        block3: {
                            block2: {
                                if (this == object) break block2;
                                if (!(object instanceof A)) break block3;
                                A a = (A)object;
                                if (!(this.a == a.a) || !Intrinsics.areEqual((Object)this.b, (Object)a.b)) break block3;
                            }
                            return true;
                        }
                        return false;
                    }
                }
                String string = A.class.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"A::class.java.name");
                this.allowedClasses = SetsKt.setOf((Object)string);
            }
        }
        WL whitelist = new WL();
        ClassWhitelist classWhitelist = whitelist;
        ClassWhitelist classWhitelist2 = whitelist;
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        Intrinsics.checkExpressionValueIsNotNull((Object)classLoader, (String)"ClassLoader.getSystemClassLoader()");
        SerializerFactory factory = SerializerFactoryBuilder.build((ClassWhitelist)classWhitelist, (ClassCarpenter)((ClassCarpenter)new ClassCarpenterImpl(classWhitelist2, classLoader, false, 4, null)));
        factory.registerExternal(new CorDappCustomSerializer((SerializationCustomSerializer)new NeedsProxyProxySerializer(), factory));
        int tv1 = 100;
        String tv2 = "pants schmants";
        DeserializationInput deserializationInput = new DeserializationInput(factory);
        SerializedBytes serializedBytes = AMQPTestUtilsKt.serialize$default(new SerializationOutput((LocalSerializerFactory)factory), new A(tv1, new NeedsProxy(tv2)), null, 2, null);
        SerializationContext context$iv = null;
        A obj = (A)$receiver$iv.deserialize((ByteSequence)bytes$iv, A.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)tv1, (Object)obj.getA(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)tv2, (Object)obj.getB().getA(), null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void proxiedGeneric() {
        SerializerFactory proxyFactory = this.proxyFactory(CollectionsKt.listOf((Object)new NeedsProxyGenProxySerializer()));
        String msg = "help";
        SerializedBytes blob = AMQPTestUtilsKt.serialize$default(new SerializationOutput((LocalSerializerFactory)proxyFactory), new NeedsProxyGen<String>(msg), null, 2, null);
        DeserializationInput $receiver$iv = new DeserializationInput(proxyFactory);
        SerializationContext context$iv = null;
        NeedsProxyGen objFromProxy = (NeedsProxyGen)$receiver$iv.deserialize((ByteSequence)blob, NeedsProxyGen.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)msg, objFromProxy.getA(), null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void proxiedBoundedGeneric() {
        SerializerFactory proxyFactory = this.proxyFactory(CollectionsKt.listOf((Object[])new SerializationCustomSerializer[]{new NeedsProxyGenBoundedProxySerializer(), new HasWibbleProxy()}));
        SerializedBytes blob = AMQPTestUtilsKt.serialize$default(new SerializationOutput((LocalSerializerFactory)proxyFactory), new NeedsProxyGenBounded<Bound>(new HasWibble("A")), null, 2, null);
        DeserializationInput $receiver$iv = new DeserializationInput(proxyFactory);
        SerializationContext context$iv = null;
        NeedsProxyGenBounded objFromProxy = (NeedsProxyGenBounded)$receiver$iv.deserialize((ByteSequence)blob, NeedsProxyGenBounded.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)"A", (Object)((HasWibble)objFromProxy.getA()).getA(), null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void proxiedGenericContainer() {
        SerializerFactory proxyFactory = this.proxyFactory(CollectionsKt.listOf((Object)new NeedsProxyGenContainerProxySerializer()));
        SerializedBytes blob1 = AMQPTestUtilsKt.serialize$default(new SerializationOutput((LocalSerializerFactory)proxyFactory), new NeedsProxyGenContainer(CollectionsKt.listOf((Object[])new Integer[]{1, 2, 3})), null, 2, null);
        DeserializationInput $receiver$iv = new DeserializationInput(proxyFactory);
        SerializationContext context$iv = null;
        NeedsProxyGenContainer obj1 = (NeedsProxyGenContainer)$receiver$iv.deserialize((ByteSequence)blob1, NeedsProxyGenContainer.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)CollectionsKt.listOf((Object[])new Integer[]{1, 2, 3}), obj1.getA(), null, (int)4, null);
        SerializedBytes blob2 = AMQPTestUtilsKt.serialize$default(new SerializationOutput((LocalSerializerFactory)proxyFactory), new NeedsProxyGenContainer(CollectionsKt.listOf((Object[])new String[]{"1", "2", "3"})), null, 2, null);
        DeserializationInput $receiver$iv2 = new DeserializationInput(proxyFactory);
        SerializationContext context$iv2 = null;
        NeedsProxyGenContainer obj2 = (NeedsProxyGenContainer)$receiver$iv2.deserialize((ByteSequence)blob2, NeedsProxyGenContainer.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)CollectionsKt.listOf((Object[])new String[]{"1", "2", "3"}), obj2.getA(), null, (int)4, null);
        SerializedBytes blob3 = AMQPTestUtilsKt.serialize$default(new SerializationOutput((LocalSerializerFactory)proxyFactory), new NeedsProxyGenContainer(CollectionsKt.listOf((Object[])new Object[]{"1", 2, "3"})), null, 2, null);
        DeserializationInput $receiver$iv3 = new DeserializationInput(proxyFactory);
        SerializationContext context$iv3 = null;
        NeedsProxyGenContainer obj3 = (NeedsProxyGenContainer)$receiver$iv3.deserialize((ByteSequence)blob3, NeedsProxyGenContainer.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        AssertionsKt.assertEquals$default((Object)CollectionsKt.listOf((Object[])new Object[]{"1", 2, "3"}), obj3.getA(), null, (int)4, null);
    }

    @Test(timeout=300000L)
    public final void proxiedInheritableGenerics() {
        SerializerFactory proxyFactory = this.proxyFactory(CollectionsKt.listOf((Object[])new SerializationCustomSerializer[]{new BaseProxy(), new DerivedProxy()}));
        SerializedBytes blob1 = AMQPTestUtilsKt.serialize$default(new SerializationOutput((LocalSerializerFactory)proxyFactory), new Base<Long>(100L), null, 2, null);
        DeserializationInput $receiver$iv = new DeserializationInput(proxyFactory);
        SerializationContext context$iv = null;
        $receiver$iv.deserialize((ByteSequence)blob1, Base.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
        SerializedBytes blob2 = AMQPTestUtilsKt.serialize$default(new SerializationOutput((LocalSerializerFactory)proxyFactory), new Derived<Long>(100L, "Hey pants"), null, 2, null);
        DeserializationInput $receiver$iv2 = new DeserializationInput(proxyFactory);
        SerializationContext context$iv2 = null;
        $receiver$iv2.deserialize((ByteSequence)blob2, Derived.class, (SerializationContext)TestSerializationContextKt.getTestSerializationContext());
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lnet/corda/serialization/internal/amqp/CorDappSerializerTests$NeedsProxy;", "", "a", "", "(Ljava/lang/String;)V", "getA", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "serialization"})
    public static final class NeedsProxy {
        @NotNull
        private final String a;

        @NotNull
        public final String getA() {
            return this.a;
        }

        public NeedsProxy(@NotNull String a) {
            Intrinsics.checkParameterIsNotNull((Object)a, (String)"a");
            this.a = a;
        }

        @NotNull
        public final String component1() {
            return this.a;
        }

        @NotNull
        public final NeedsProxy copy(@NotNull String a) {
            Intrinsics.checkParameterIsNotNull((Object)a, (String)"a");
            return new NeedsProxy(a);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ NeedsProxy copy$default(NeedsProxy needsProxy, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = needsProxy.a;
            }
            return needsProxy.copy(string);
        }

        @NotNull
        public String toString() {
            return "NeedsProxy(a=" + this.a + ")";
        }

        public int hashCode() {
            String string = this.a;
            return string != null ? string.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof NeedsProxy)) break block3;
                    NeedsProxy needsProxy = (NeedsProxy)object;
                    if (!Intrinsics.areEqual((Object)this.a, (Object)needsProxy.a)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0003H\u0016J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\n"}, d2={"Lnet/corda/serialization/internal/amqp/CorDappSerializerTests$NeedsProxyProxySerializer;", "Lnet/corda/core/serialization/SerializationCustomSerializer;", "Lnet/corda/serialization/internal/amqp/CorDappSerializerTests$NeedsProxy;", "Lnet/corda/serialization/internal/amqp/CorDappSerializerTests$NeedsProxyProxySerializer$Proxy;", "()V", "fromProxy", "proxy", "toProxy", "obj", "Proxy", "serialization"})
    public static final class NeedsProxyProxySerializer
    implements SerializationCustomSerializer<NeedsProxy, Proxy> {
        @NotNull
        public NeedsProxy fromProxy(@NotNull Proxy proxy) {
            Intrinsics.checkParameterIsNotNull((Object)proxy, (String)"proxy");
            return new NeedsProxy(proxy.getProxy_a_());
        }

        @NotNull
        public Proxy toProxy(@NotNull NeedsProxy obj) {
            Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
            return new Proxy(obj.getA());
        }

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lnet/corda/serialization/internal/amqp/CorDappSerializerTests$NeedsProxyProxySerializer$Proxy;", "", "proxy_a_", "", "(Ljava/lang/String;)V", "getProxy_a_", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "serialization"})
        public static final class Proxy {
            @NotNull
            private final String proxy_a_;

            @NotNull
            public final String getProxy_a_() {
                return this.proxy_a_;
            }

            public Proxy(@NotNull String proxy_a_) {
                Intrinsics.checkParameterIsNotNull((Object)proxy_a_, (String)"proxy_a_");
                this.proxy_a_ = proxy_a_;
            }

            @NotNull
            public final String component1() {
                return this.proxy_a_;
            }

            @NotNull
            public final Proxy copy(@NotNull String proxy_a_) {
                Intrinsics.checkParameterIsNotNull((Object)proxy_a_, (String)"proxy_a_");
                return new Proxy(proxy_a_);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ Proxy copy$default(Proxy proxy, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = proxy.proxy_a_;
                }
                return proxy.copy(string);
            }

            @NotNull
            public String toString() {
                return "Proxy(proxy_a_=" + this.proxy_a_ + ")";
            }

            public int hashCode() {
                String string = this.proxy_a_;
                return string != null ? string.hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Proxy)) break block3;
                        Proxy proxy = (Proxy)object;
                        if (!Intrinsics.areEqual((Object)this.proxy_a_, (Object)proxy.proxy_a_)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0003H\u0014J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0002H\u0014\u00a8\u0006\f"}, d2={"Lnet/corda/serialization/internal/amqp/CorDappSerializerTests$InternalProxySerializer;", "Lnet/corda/serialization/internal/amqp/CustomSerializer$Proxy;", "Lnet/corda/serialization/internal/amqp/CorDappSerializerTests$NeedsProxy;", "Lnet/corda/serialization/internal/amqp/CorDappSerializerTests$InternalProxySerializer$Proxy;", "factory", "Lnet/corda/serialization/internal/amqp/SerializerFactory;", "(Lnet/corda/serialization/internal/amqp/SerializerFactory;)V", "fromProxy", "proxy", "toProxy", "obj", "Proxy", "serialization"})
    public static final class InternalProxySerializer
    extends CustomSerializer.Proxy<NeedsProxy, Proxy> {
        @NotNull
        protected Proxy toProxy(@NotNull NeedsProxy obj) {
            Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
            return new Proxy(obj.getA());
        }

        @NotNull
        protected NeedsProxy fromProxy(@NotNull Proxy proxy) {
            Intrinsics.checkParameterIsNotNull((Object)proxy, (String)"proxy");
            return new NeedsProxy(proxy.getProxy_a_());
        }

        public InternalProxySerializer(@NotNull SerializerFactory factory) {
            Intrinsics.checkParameterIsNotNull((Object)factory, (String)"factory");
            super(NeedsProxy.class, Proxy.class, (LocalSerializerFactory)factory, false, 8, null);
        }

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lnet/corda/serialization/internal/amqp/CorDappSerializerTests$InternalProxySerializer$Proxy;", "", "proxy_a_", "", "(Ljava/lang/String;)V", "getProxy_a_", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "serialization"})
        public static final class Proxy {
            @NotNull
            private final String proxy_a_;

            @NotNull
            public final String getProxy_a_() {
                return this.proxy_a_;
            }

            public Proxy(@NotNull String proxy_a_) {
                Intrinsics.checkParameterIsNotNull((Object)proxy_a_, (String)"proxy_a_");
                this.proxy_a_ = proxy_a_;
            }

            @NotNull
            public final String component1() {
                return this.proxy_a_;
            }

            @NotNull
            public final Proxy copy(@NotNull String proxy_a_) {
                Intrinsics.checkParameterIsNotNull((Object)proxy_a_, (String)"proxy_a_");
                return new Proxy(proxy_a_);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ Proxy copy$default(Proxy proxy, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = proxy.proxy_a_;
                }
                return proxy.copy(string);
            }

            @NotNull
            public String toString() {
                return "Proxy(proxy_a_=" + this.proxy_a_ + ")";
            }

            public int hashCode() {
                String string = this.proxy_a_;
                return string != null ? string.hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Proxy)) break block3;
                        Proxy proxy = (Proxy)object;
                        if (!Intrinsics.areEqual((Object)this.proxy_a_, (Object)proxy.proxy_a_)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\b\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u0000H\u00c6\u0001\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lnet/corda/serialization/internal/amqp/CorDappSerializerTests$NeedsProxyGen;", "T", "", "a", "(Ljava/lang/Object;)V", "getA", "()Ljava/lang/Object;", "Ljava/lang/Object;", "component1", "copy", "(Ljava/lang/Object;)Lnet/corda/serialization/internal/amqp/CorDappSerializerTests$NeedsProxyGen;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
    public static final class NeedsProxyGen<T> {
        private final T a;

        public final T getA() {
            return this.a;
        }

        public NeedsProxyGen(T a) {
            this.a = a;
        }

        public final T component1() {
            return this.a;
        }

        @NotNull
        public final NeedsProxyGen<T> copy(T a) {
            return new NeedsProxyGen<T>(a);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ NeedsProxyGen copy$default(NeedsProxyGen needsProxyGen, Object object, int n, Object object2) {
            if ((n & 1) != 0) {
                object = needsProxyGen.a;
            }
            return needsProxyGen.copy(object);
        }

        @NotNull
        public String toString() {
            return "NeedsProxyGen(a=" + this.a + ")";
        }

        public int hashCode() {
            T t = this.a;
            return t != null ? t.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof NeedsProxyGen)) break block3;
                    NeedsProxyGen needsProxyGen = (NeedsProxyGen)object;
                    if (!Intrinsics.areEqual(this.a, needsProxyGen.a)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\u0018\u00002\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00022\u0006\u0010\u0007\u001a\u00020\u0003H\u0016J\u0014\u0010\b\u001a\u00020\u00032\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Lnet/corda/serialization/internal/amqp/CorDappSerializerTests$NeedsProxyGenProxySerializer;", "Lnet/corda/core/serialization/SerializationCustomSerializer;", "Lnet/corda/serialization/internal/amqp/CorDappSerializerTests$NeedsProxyGen;", "Lnet/corda/serialization/internal/amqp/CorDappSerializerTests$NeedsProxyGenProxySerializer$Proxy;", "()V", "fromProxy", "", "proxy", "toProxy", "obj", "Proxy", "serialization"})
    public static final class NeedsProxyGenProxySerializer
    implements SerializationCustomSerializer<NeedsProxyGen<?>, Proxy> {
        @NotNull
        public NeedsProxyGen<Object> fromProxy(@NotNull Proxy proxy) {
            Intrinsics.checkParameterIsNotNull((Object)proxy, (String)"proxy");
            return new NeedsProxyGen<Object>(proxy.getProxy_a_());
        }

        @NotNull
        public Proxy toProxy(@NotNull NeedsProxyGen<?> obj) {
            Intrinsics.checkParameterIsNotNull(obj, (String)"obj");
            return new Proxy(obj.getA());
        }

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0003J\u000b\u0010\u0006\u001a\u0004\u0018\u00010\u0001H\u00c6\u0003J\u0015\u0010\u0007\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0001H\u00c6\u0001J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000b\u001a\u00020\fH\u00d6\u0001J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u000f"}, d2={"Lnet/corda/serialization/internal/amqp/CorDappSerializerTests$NeedsProxyGenProxySerializer$Proxy;", "", "proxy_a_", "(Ljava/lang/Object;)V", "getProxy_a_", "()Ljava/lang/Object;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
        public static final class Proxy {
            @Nullable
            private final Object proxy_a_;

            @Nullable
            public final Object getProxy_a_() {
                return this.proxy_a_;
            }

            public Proxy(@Nullable Object proxy_a_) {
                this.proxy_a_ = proxy_a_;
            }

            @Nullable
            public final Object component1() {
                return this.proxy_a_;
            }

            @NotNull
            public final Proxy copy(@Nullable Object proxy_a_) {
                return new Proxy(proxy_a_);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ Proxy copy$default(Proxy proxy, Object object, int n, Object object2) {
                if ((n & 1) != 0) {
                    object = proxy.proxy_a_;
                }
                return proxy.copy(object);
            }

            @NotNull
            public String toString() {
                return "Proxy(proxy_a_=" + this.proxy_a_ + ")";
            }

            public int hashCode() {
                Object object = this.proxy_a_;
                return object != null ? object.hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Proxy)) break block3;
                        Proxy proxy = (Proxy)object;
                        if (!Intrinsics.areEqual((Object)this.proxy_a_, (Object)proxy.proxy_a_)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lnet/corda/serialization/internal/amqp/CorDappSerializerTests$Bound;", "", "wibbleIt", "", "serialization"})
    public static interface Bound {
        @NotNull
        public String wibbleIt();
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\t\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0004\u001a\u00028\u0000H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lnet/corda/serialization/internal/amqp/CorDappSerializerTests$NeedsProxyGenBounded;", "T", "Lnet/corda/serialization/internal/amqp/CorDappSerializerTests$Bound;", "", "a", "(Lnet/corda/serialization/internal/amqp/CorDappSerializerTests$Bound;)V", "getA", "()Lnet/corda/serialization/internal/amqp/CorDappSerializerTests$Bound;", "Lnet/corda/serialization/internal/amqp/CorDappSerializerTests$Bound;", "component1", "copy", "(Lnet/corda/serialization/internal/amqp/CorDappSerializerTests$Bound;)Lnet/corda/serialization/internal/amqp/CorDappSerializerTests$NeedsProxyGenBounded;", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
    public static final class NeedsProxyGenBounded<T extends Bound> {
        @NotNull
        private final T a;

        @NotNull
        public final T getA() {
            return this.a;
        }

        public NeedsProxyGenBounded(@NotNull T a) {
            Intrinsics.checkParameterIsNotNull(a, (String)"a");
            this.a = a;
        }

        @NotNull
        public final T component1() {
            return this.a;
        }

        @NotNull
        public final NeedsProxyGenBounded<T> copy(@NotNull T a) {
            Intrinsics.checkParameterIsNotNull(a, (String)"a");
            return new NeedsProxyGenBounded<T>(a);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ NeedsProxyGenBounded copy$default(NeedsProxyGenBounded needsProxyGenBounded, Bound bound, int n, Object object) {
            if ((n & 1) != 0) {
                bound = needsProxyGenBounded.a;
            }
            return needsProxyGenBounded.copy(bound);
        }

        @NotNull
        public String toString() {
            return "NeedsProxyGenBounded(a=" + this.a + ")";
        }

        public int hashCode() {
            T t = this.a;
            return t != null ? t.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof NeedsProxyGenBounded)) break block3;
                    NeedsProxyGenBounded needsProxyGenBounded = (NeedsProxyGenBounded)object;
                    if (!Intrinsics.areEqual(this.a, needsProxyGenBounded.a)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00022\u0006\u0010\u0007\u001a\u00020\u0003H\u0016J\u0014\u0010\b\u001a\u00020\u00032\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Lnet/corda/serialization/internal/amqp/CorDappSerializerTests$NeedsProxyGenBoundedProxySerializer;", "Lnet/corda/core/serialization/SerializationCustomSerializer;", "Lnet/corda/serialization/internal/amqp/CorDappSerializerTests$NeedsProxyGenBounded;", "Lnet/corda/serialization/internal/amqp/CorDappSerializerTests$NeedsProxyGenBoundedProxySerializer$Proxy;", "()V", "fromProxy", "Lnet/corda/serialization/internal/amqp/CorDappSerializerTests$Bound;", "proxy", "toProxy", "obj", "Proxy", "serialization"})
    public static final class NeedsProxyGenBoundedProxySerializer
    implements SerializationCustomSerializer<NeedsProxyGenBounded<?>, Proxy> {
        @NotNull
        public NeedsProxyGenBounded<Bound> fromProxy(@NotNull Proxy proxy) {
            Intrinsics.checkParameterIsNotNull((Object)proxy, (String)"proxy");
            return new NeedsProxyGenBounded<Bound>(proxy.getProxy_a_());
        }

        @NotNull
        public Proxy toProxy(@NotNull NeedsProxyGenBounded<?> obj) {
            Intrinsics.checkParameterIsNotNull(obj, (String)"obj");
            return new Proxy((Bound)obj.getA());
        }

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lnet/corda/serialization/internal/amqp/CorDappSerializerTests$NeedsProxyGenBoundedProxySerializer$Proxy;", "", "proxy_a_", "Lnet/corda/serialization/internal/amqp/CorDappSerializerTests$Bound;", "(Lnet/corda/serialization/internal/amqp/CorDappSerializerTests$Bound;)V", "getProxy_a_", "()Lnet/corda/serialization/internal/amqp/CorDappSerializerTests$Bound;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
        public static final class Proxy {
            @NotNull
            private final Bound proxy_a_;

            @NotNull
            public final Bound getProxy_a_() {
                return this.proxy_a_;
            }

            public Proxy(@NotNull Bound proxy_a_) {
                Intrinsics.checkParameterIsNotNull((Object)proxy_a_, (String)"proxy_a_");
                this.proxy_a_ = proxy_a_;
            }

            @NotNull
            public final Bound component1() {
                return this.proxy_a_;
            }

            @NotNull
            public final Proxy copy(@NotNull Bound proxy_a_) {
                Intrinsics.checkParameterIsNotNull((Object)proxy_a_, (String)"proxy_a_");
                return new Proxy(proxy_a_);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ Proxy copy$default(Proxy proxy, Bound bound, int n, Object object) {
                if ((n & 1) != 0) {
                    bound = proxy.proxy_a_;
                }
                return proxy.copy(bound);
            }

            @NotNull
            public String toString() {
                return "Proxy(proxy_a_=" + this.proxy_a_ + ")";
            }

            public int hashCode() {
                Bound bound = this.proxy_a_;
                return bound != null ? bound.hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Proxy)) break block3;
                        Proxy proxy = (Proxy)object;
                        if (!Intrinsics.areEqual((Object)this.proxy_a_, (Object)proxy.proxy_a_)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001J\b\u0010\u0010\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lnet/corda/serialization/internal/amqp/CorDappSerializerTests$HasWibble;", "Lnet/corda/serialization/internal/amqp/CorDappSerializerTests$Bound;", "a", "", "(Ljava/lang/String;)V", "getA", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "wibbleIt", "serialization"})
    public static final class HasWibble
    implements Bound {
        @NotNull
        private final String a;

        @Override
        @NotNull
        public String wibbleIt() {
            return "wibble it, just a little bit!.";
        }

        @NotNull
        public final String getA() {
            return this.a;
        }

        public HasWibble(@NotNull String a) {
            Intrinsics.checkParameterIsNotNull((Object)a, (String)"a");
            this.a = a;
        }

        @NotNull
        public final String component1() {
            return this.a;
        }

        @NotNull
        public final HasWibble copy(@NotNull String a) {
            Intrinsics.checkParameterIsNotNull((Object)a, (String)"a");
            return new HasWibble(a);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ HasWibble copy$default(HasWibble hasWibble, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = hasWibble.a;
            }
            return hasWibble.copy(string);
        }

        @NotNull
        public String toString() {
            return "HasWibble(a=" + this.a + ")";
        }

        public int hashCode() {
            String string = this.a;
            return string != null ? string.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof HasWibble)) break block3;
                    HasWibble hasWibble = (HasWibble)object;
                    if (!Intrinsics.areEqual((Object)this.a, (Object)hasWibble.a)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0003H\u0016J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\n"}, d2={"Lnet/corda/serialization/internal/amqp/CorDappSerializerTests$HasWibbleProxy;", "Lnet/corda/core/serialization/SerializationCustomSerializer;", "Lnet/corda/serialization/internal/amqp/CorDappSerializerTests$HasWibble;", "Lnet/corda/serialization/internal/amqp/CorDappSerializerTests$HasWibbleProxy$Proxy;", "()V", "fromProxy", "proxy", "toProxy", "obj", "Proxy", "serialization"})
    public static final class HasWibbleProxy
    implements SerializationCustomSerializer<HasWibble, Proxy> {
        @NotNull
        public HasWibble fromProxy(@NotNull Proxy proxy) {
            Intrinsics.checkParameterIsNotNull((Object)proxy, (String)"proxy");
            return new HasWibble(proxy.getProxy_a_());
        }

        @NotNull
        public Proxy toProxy(@NotNull HasWibble obj) {
            Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
            return new Proxy(obj.getA());
        }

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lnet/corda/serialization/internal/amqp/CorDappSerializerTests$HasWibbleProxy$Proxy;", "", "proxy_a_", "", "(Ljava/lang/String;)V", "getProxy_a_", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "serialization"})
        public static final class Proxy {
            @NotNull
            private final String proxy_a_;

            @NotNull
            public final String getProxy_a_() {
                return this.proxy_a_;
            }

            public Proxy(@NotNull String proxy_a_) {
                Intrinsics.checkParameterIsNotNull((Object)proxy_a_, (String)"proxy_a_");
                this.proxy_a_ = proxy_a_;
            }

            @NotNull
            public final String component1() {
                return this.proxy_a_;
            }

            @NotNull
            public final Proxy copy(@NotNull String proxy_a_) {
                Intrinsics.checkParameterIsNotNull((Object)proxy_a_, (String)"proxy_a_");
                return new Proxy(proxy_a_);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ Proxy copy$default(Proxy proxy, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = proxy.proxy_a_;
                }
                return proxy.copy(string);
            }

            @NotNull
            public String toString() {
                return "Proxy(proxy_a_=" + this.proxy_a_ + ")";
            }

            public int hashCode() {
                String string = this.proxy_a_;
                return string != null ? string.hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Proxy)) break block3;
                        Proxy proxy = (Proxy)object;
                        if (!Intrinsics.areEqual((Object)this.proxy_a_, (Object)proxy.proxy_a_)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u00c6\u0003J\u001f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lnet/corda/serialization/internal/amqp/CorDappSerializerTests$NeedsProxyGenContainer;", "T", "", "a", "", "(Ljava/util/List;)V", "getA", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
    public static final class NeedsProxyGenContainer<T> {
        @NotNull
        private final List<T> a;

        @NotNull
        public final List<T> getA() {
            return this.a;
        }

        public NeedsProxyGenContainer(@NotNull List<? extends T> a) {
            Intrinsics.checkParameterIsNotNull(a, (String)"a");
            this.a = a;
        }

        @NotNull
        public final List<T> component1() {
            return this.a;
        }

        @NotNull
        public final NeedsProxyGenContainer<T> copy(@NotNull List<? extends T> a) {
            Intrinsics.checkParameterIsNotNull(a, (String)"a");
            return new NeedsProxyGenContainer<T>(a);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ NeedsProxyGenContainer copy$default(NeedsProxyGenContainer needsProxyGenContainer, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = needsProxyGenContainer.a;
            }
            return needsProxyGenContainer.copy(list);
        }

        @NotNull
        public String toString() {
            return "NeedsProxyGenContainer(a=" + this.a + ")";
        }

        public int hashCode() {
            List<T> list = this.a;
            return list != null ? ((Object)list).hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof NeedsProxyGenContainer)) break block3;
                    NeedsProxyGenContainer needsProxyGenContainer = (NeedsProxyGenContainer)object;
                    if (!Intrinsics.areEqual(this.a, needsProxyGenContainer.a)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\u0018\u00002\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00022\u0006\u0010\u0007\u001a\u00020\u0003H\u0016J\u0014\u0010\b\u001a\u00020\u00032\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Lnet/corda/serialization/internal/amqp/CorDappSerializerTests$NeedsProxyGenContainerProxySerializer;", "Lnet/corda/core/serialization/SerializationCustomSerializer;", "Lnet/corda/serialization/internal/amqp/CorDappSerializerTests$NeedsProxyGenContainer;", "Lnet/corda/serialization/internal/amqp/CorDappSerializerTests$NeedsProxyGenContainerProxySerializer$Proxy;", "()V", "fromProxy", "", "proxy", "toProxy", "obj", "Proxy", "serialization"})
    public static final class NeedsProxyGenContainerProxySerializer
    implements SerializationCustomSerializer<NeedsProxyGenContainer<?>, Proxy> {
        @NotNull
        public NeedsProxyGenContainer<Object> fromProxy(@NotNull Proxy proxy) {
            Intrinsics.checkParameterIsNotNull((Object)proxy, (String)"proxy");
            return new NeedsProxyGenContainer<Object>(proxy.getProxy_a_());
        }

        @NotNull
        public Proxy toProxy(@NotNull NeedsProxyGenContainer<?> obj) {
            Intrinsics.checkParameterIsNotNull(obj, (String)"obj");
            return new Proxy(obj.getA());
        }

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\u0017\u0010\b\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lnet/corda/serialization/internal/amqp/CorDappSerializerTests$NeedsProxyGenContainerProxySerializer$Proxy;", "", "proxy_a_", "", "(Ljava/util/List;)V", "getProxy_a_", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
        public static final class Proxy {
            @NotNull
            private final List<?> proxy_a_;

            @NotNull
            public final List<?> getProxy_a_() {
                return this.proxy_a_;
            }

            public Proxy(@NotNull List<?> proxy_a_) {
                Intrinsics.checkParameterIsNotNull(proxy_a_, (String)"proxy_a_");
                this.proxy_a_ = proxy_a_;
            }

            @NotNull
            public final List<?> component1() {
                return this.proxy_a_;
            }

            @NotNull
            public final Proxy copy(@NotNull List<?> proxy_a_) {
                Intrinsics.checkParameterIsNotNull(proxy_a_, (String)"proxy_a_");
                return new Proxy(proxy_a_);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ Proxy copy$default(Proxy proxy, List list, int n, Object object) {
                if ((n & 1) != 0) {
                    list = proxy.proxy_a_;
                }
                return proxy.copy(list);
            }

            @NotNull
            public String toString() {
                return "Proxy(proxy_a_=" + this.proxy_a_ + ")";
            }

            public int hashCode() {
                List<?> list = this.proxy_a_;
                return list != null ? ((Object)list).hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Proxy)) break block3;
                        Proxy proxy = (Proxy)object;
                        if (!Intrinsics.areEqual(this.proxy_a_, proxy.proxy_a_)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0004R\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\b"}, d2={"Lnet/corda/serialization/internal/amqp/CorDappSerializerTests$Base;", "T", "", "a", "(Ljava/lang/Object;)V", "getA", "()Ljava/lang/Object;", "Ljava/lang/Object;", "serialization"})
    public static class Base<T> {
        private final T a;

        public final T getA() {
            return this.a;
        }

        public Base(T a) {
            this.a = a;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lnet/corda/serialization/internal/amqp/CorDappSerializerTests$Derived;", "T", "Lnet/corda/serialization/internal/amqp/CorDappSerializerTests$Base;", "a", "b", "", "(Ljava/lang/Object;Ljava/lang/String;)V", "getB", "()Ljava/lang/String;", "serialization"})
    public static final class Derived<T>
    extends Base<T> {
        @NotNull
        private final String b;

        @NotNull
        public final String getB() {
            return this.b;
        }

        public Derived(T a, @NotNull String b) {
            Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
            super(a);
            this.b = b;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\u0018\u00002\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00022\u0006\u0010\u0007\u001a\u00020\u0003H\u0016J\u0014\u0010\b\u001a\u00020\u00032\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Lnet/corda/serialization/internal/amqp/CorDappSerializerTests$BaseProxy;", "Lnet/corda/core/serialization/SerializationCustomSerializer;", "Lnet/corda/serialization/internal/amqp/CorDappSerializerTests$Base;", "Lnet/corda/serialization/internal/amqp/CorDappSerializerTests$BaseProxy$Proxy;", "()V", "fromProxy", "", "proxy", "toProxy", "obj", "Proxy", "serialization"})
    public static final class BaseProxy
    implements SerializationCustomSerializer<Base<?>, Proxy> {
        @NotNull
        public Base<Object> fromProxy(@NotNull Proxy proxy) {
            Intrinsics.checkParameterIsNotNull((Object)proxy, (String)"proxy");
            return new Base<Object>(proxy.getProxy_a_());
        }

        @NotNull
        public Proxy toProxy(@NotNull Base<?> obj) {
            Intrinsics.checkParameterIsNotNull(obj, (String)"obj");
            return new Proxy(obj.getA());
        }

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0003J\u000b\u0010\u0006\u001a\u0004\u0018\u00010\u0001H\u00c6\u0003J\u0015\u0010\u0007\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0001H\u00c6\u0001J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000b\u001a\u00020\fH\u00d6\u0001J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u000f"}, d2={"Lnet/corda/serialization/internal/amqp/CorDappSerializerTests$BaseProxy$Proxy;", "", "proxy_a_", "(Ljava/lang/Object;)V", "getProxy_a_", "()Ljava/lang/Object;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
        public static final class Proxy {
            @Nullable
            private final Object proxy_a_;

            @Nullable
            public final Object getProxy_a_() {
                return this.proxy_a_;
            }

            public Proxy(@Nullable Object proxy_a_) {
                this.proxy_a_ = proxy_a_;
            }

            @Nullable
            public final Object component1() {
                return this.proxy_a_;
            }

            @NotNull
            public final Proxy copy(@Nullable Object proxy_a_) {
                return new Proxy(proxy_a_);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ Proxy copy$default(Proxy proxy, Object object, int n, Object object2) {
                if ((n & 1) != 0) {
                    object = proxy.proxy_a_;
                }
                return proxy.copy(object);
            }

            @NotNull
            public String toString() {
                return "Proxy(proxy_a_=" + this.proxy_a_ + ")";
            }

            public int hashCode() {
                Object object = this.proxy_a_;
                return object != null ? object.hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Proxy)) break block3;
                        Proxy proxy = (Proxy)object;
                        if (!Intrinsics.areEqual((Object)this.proxy_a_, (Object)proxy.proxy_a_)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\u0018\u00002\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00022\u0006\u0010\u0007\u001a\u00020\u0003H\u0016J\u0014\u0010\b\u001a\u00020\u00032\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Lnet/corda/serialization/internal/amqp/CorDappSerializerTests$DerivedProxy;", "Lnet/corda/core/serialization/SerializationCustomSerializer;", "Lnet/corda/serialization/internal/amqp/CorDappSerializerTests$Derived;", "Lnet/corda/serialization/internal/amqp/CorDappSerializerTests$DerivedProxy$Proxy;", "()V", "fromProxy", "", "proxy", "toProxy", "obj", "Proxy", "serialization"})
    public static final class DerivedProxy
    implements SerializationCustomSerializer<Derived<?>, Proxy> {
        @NotNull
        public Derived<Object> fromProxy(@NotNull Proxy proxy) {
            Intrinsics.checkParameterIsNotNull((Object)proxy, (String)"proxy");
            return new Derived<Object>(proxy.getProxy_a_(), proxy.getProxy_b_());
        }

        @NotNull
        public Proxy toProxy(@NotNull Derived<?> obj) {
            Intrinsics.checkParameterIsNotNull(obj, (String)"obj");
            return new Proxy(obj.getA(), obj.getB());
        }

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0004H\u00c6\u0003J\u001f\u0010\f\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0004H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lnet/corda/serialization/internal/amqp/CorDappSerializerTests$DerivedProxy$Proxy;", "", "proxy_a_", "proxy_b_", "", "(Ljava/lang/Object;Ljava/lang/String;)V", "getProxy_a_", "()Ljava/lang/Object;", "getProxy_b_", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "serialization"})
        public static final class Proxy {
            @Nullable
            private final Object proxy_a_;
            @NotNull
            private final String proxy_b_;

            @Nullable
            public final Object getProxy_a_() {
                return this.proxy_a_;
            }

            @NotNull
            public final String getProxy_b_() {
                return this.proxy_b_;
            }

            public Proxy(@Nullable Object proxy_a_, @NotNull String proxy_b_) {
                Intrinsics.checkParameterIsNotNull((Object)proxy_b_, (String)"proxy_b_");
                this.proxy_a_ = proxy_a_;
                this.proxy_b_ = proxy_b_;
            }

            @Nullable
            public final Object component1() {
                return this.proxy_a_;
            }

            @NotNull
            public final String component2() {
                return this.proxy_b_;
            }

            @NotNull
            public final Proxy copy(@Nullable Object proxy_a_, @NotNull String proxy_b_) {
                Intrinsics.checkParameterIsNotNull((Object)proxy_b_, (String)"proxy_b_");
                return new Proxy(proxy_a_, proxy_b_);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ Proxy copy$default(Proxy proxy, Object object, String string, int n, Object object2) {
                if ((n & 1) != 0) {
                    object = proxy.proxy_a_;
                }
                if ((n & 2) != 0) {
                    string = proxy.proxy_b_;
                }
                return proxy.copy(object, string);
            }

            @NotNull
            public String toString() {
                return "Proxy(proxy_a_=" + this.proxy_a_ + ", proxy_b_=" + this.proxy_b_ + ")";
            }

            public int hashCode() {
                Object object = this.proxy_a_;
                String string = this.proxy_b_;
                return (object != null ? object.hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Proxy)) break block3;
                        Proxy proxy = (Proxy)object;
                        if (!Intrinsics.areEqual((Object)this.proxy_a_, (Object)proxy.proxy_a_) || !Intrinsics.areEqual((Object)this.proxy_b_, (Object)proxy.proxy_b_)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

