/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp;

import com.google.common.reflect.TypeToken;
import java.io.NotSerializableException;
import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.test.AssertionsKt;
import kotlin.text.StringsKt;
import net.corda.serialization.internal.amqp.AMQPTypeIdentifierParser;
import net.corda.serialization.internal.amqp.AMQPTypeIdentifierParserTests;
import net.corda.serialization.internal.amqp.AMQPTypeIdentifiers;
import net.corda.serialization.internal.amqp.IllegalTypeNameParserStateException;
import net.corda.serialization.internal.model.TypeIdentifier;
import org.apache.qpid.proton.amqp.UnsignedShort;
import org.jetbrains.annotations.NotNull;
import org.junit.Test;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b \u0018\u00002\u00020\u0001:\u0002()B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u00020\u0004\"\u0006\b\u0000\u0010\u0005\u0018\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0082\bJ\u0011\u0010\b\u001a\u00020\u0004\"\u0006\b\u0000\u0010\u0005\u0018\u0001H\u0082\bJ\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0007H\u0002J\u0019\u0010\u000b\u001a\u00020\u0004\"\u0006\b\u0000\u0010\u0005\u0018\u00012\u0006\u0010\f\u001a\u00020\u0007H\u0082\bJ\b\u0010\r\u001a\u00020\u0004H\u0007J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007H\u0002J\b\u0010\u0010\u001a\u00020\u0004H\u0007J\b\u0010\u0011\u001a\u00020\u0004H\u0007J\b\u0010\u0012\u001a\u00020\u0004H\u0007J\b\u0010\u0013\u001a\u00020\u0004H\u0007J\b\u0010\u0014\u001a\u00020\u0004H\u0007J\b\u0010\u0015\u001a\u00020\u0004H\u0007J\b\u0010\u0016\u001a\u00020\u0004H\u0007J\b\u0010\u0017\u001a\u00020\u0004H\u0007J\b\u0010\u0018\u001a\u00020\u0004H\u0007J\b\u0010\u0019\u001a\u00020\u0004H\u0007J\b\u0010\u001a\u001a\u00020\u0004H\u0007J\b\u0010\u001b\u001a\u00020\u0004H\u0007J\b\u0010\u001c\u001a\u00020\u0004H\u0007J\b\u0010\u001d\u001a\u00020\u0004H\u0007J\b\u0010\u001e\u001a\u00020\u0004H\u0007J\b\u0010\u001f\u001a\u00020\u0004H\u0007J\b\u0010 \u001a\u00020\u0004H\u0007J\b\u0010!\u001a\u00020\u0004H\u0007J\b\u0010\"\u001a\u00020\u0004H\u0007J\u0019\u0010#\u001a\n $*\u0004\u0018\u00010\n0\n\"\u0006\b\u0000\u0010\u0005\u0018\u0001H\u0082\bJ\b\u0010%\u001a\u00020\u0004H\u0007J\u0010\u0010&\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\u0007H\u0002\u00a8\u0006*"}, d2={"Lnet/corda/serialization/internal/amqp/AMQPTypeIdentifierParserTests;", "", "()V", "assertParseResult", "", "T", "typeString", "", "assertParsesCompatibly", "type", "Ljava/lang/reflect/Type;", "assertParsesTo", "expectedIdentifierPrettyPrint", "compatibility test", "normalise", "string", "parameterised types, nested, with arrays", "primitives and arrays", "test empty params", "test excessive nesting", "test leading comma", "test list of commands", "test mid whitespace", "test mid whitespace2", "test middle comma", "test multiple args", "test nested", "test no parameters", "test parameters on non-generic type", "test simple", "test trailing close", "test trailing comma", "test trailing text", "test trailing whitespace", "test wrong number of parameters", "typeOf", "kotlin.jvm.PlatformType", "unparameterised types", "verify", "typeName", "WithParameter", "WithParameters", "serialization"})
public final class AMQPTypeIdentifierParserTests {
    @Test(timeout=300000L)
    public final void primitives and arrays() {
        Type type2;
        AMQPTypeIdentifierParserTests this_$iv;
        Object object = this;
        String typeString$iv = "int";
        void var3_3 = this_$iv;
        TypeIdentifier.Companion companion = TypeIdentifier.Companion;
        Type type3 = type2 = new TypeToken<Integer>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"typeOf<T>()");
        AssertionsKt.assertEquals$default((Object)TypeIdentifier.Companion.forGenericType$default((TypeIdentifier.Companion)companion, (Type)type3, null, (int)2, null), (Object)AMQPTypeIdentifierParser.INSTANCE.parse(typeString$iv), null, (int)4, null);
        this_$iv = this;
        typeString$iv = "int[p]";
        AMQPTypeIdentifierParserTests this_$iv$iv = this_$iv;
        companion = TypeIdentifier.Companion;
        Type type4 = type2 = new TypeToken<int[]>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type4, (String)"typeOf<T>()");
        AssertionsKt.assertEquals$default((Object)TypeIdentifier.Companion.forGenericType$default((TypeIdentifier.Companion)companion, (Type)type4, null, (int)2, null), (Object)AMQPTypeIdentifierParser.INSTANCE.parse(typeString$iv), null, (int)4, null);
        this_$iv = this;
        typeString$iv = "int[]";
        this_$iv$iv = this_$iv;
        companion = TypeIdentifier.Companion;
        Type type5 = type2 = new TypeToken<Integer[]>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type5, (String)"typeOf<T>()");
        AssertionsKt.assertEquals$default((Object)TypeIdentifier.Companion.forGenericType$default((TypeIdentifier.Companion)companion, (Type)type5, null, (int)2, null), (Object)AMQPTypeIdentifierParser.INSTANCE.parse(typeString$iv), null, (int)4, null);
        this_$iv = this;
        typeString$iv = "int[p][]";
        this_$iv$iv = this_$iv;
        companion = TypeIdentifier.Companion;
        Type type6 = type2 = new TypeToken<int[][]>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type6, (String)"typeOf<T>()");
        AssertionsKt.assertEquals$default((Object)TypeIdentifier.Companion.forGenericType$default((TypeIdentifier.Companion)companion, (Type)type6, null, (int)2, null), (Object)AMQPTypeIdentifierParser.INSTANCE.parse(typeString$iv), null, (int)4, null);
        this_$iv = this;
        typeString$iv = "int[][]";
        this_$iv$iv = this_$iv;
        companion = TypeIdentifier.Companion;
        Type type7 = type2 = new TypeToken<Integer[][]>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type7, (String)"typeOf<T>()");
        AssertionsKt.assertEquals$default((Object)TypeIdentifier.Companion.forGenericType$default((TypeIdentifier.Companion)companion, (Type)type7, null, (int)2, null), (Object)AMQPTypeIdentifierParser.INSTANCE.parse(typeString$iv), null, (int)4, null);
        this_$iv = this;
        typeString$iv = "binary";
        this_$iv$iv = this_$iv;
        companion = TypeIdentifier.Companion;
        Type type8 = type2 = new TypeToken<byte[]>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type8, (String)"typeOf<T>()");
        AssertionsKt.assertEquals$default((Object)TypeIdentifier.Companion.forGenericType$default((TypeIdentifier.Companion)companion, (Type)type8, null, (int)2, null), (Object)AMQPTypeIdentifierParser.INSTANCE.parse(typeString$iv), null, (int)4, null);
        this_$iv = this;
        typeString$iv = "binary[]";
        this_$iv$iv = this_$iv;
        companion = TypeIdentifier.Companion;
        Type type9 = type2 = new TypeToken<byte[][]>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type9, (String)"typeOf<T>()");
        AssertionsKt.assertEquals$default((Object)TypeIdentifier.Companion.forGenericType$default((TypeIdentifier.Companion)companion, (Type)type9, null, (int)2, null), (Object)AMQPTypeIdentifierParser.INSTANCE.parse(typeString$iv), null, (int)4, null);
        this_$iv = this;
        typeString$iv = "ushort[]";
        this_$iv$iv = this_$iv;
        companion = TypeIdentifier.Companion;
        Type type10 = type2 = new TypeToken<UnsignedShort[]>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type10, (String)"typeOf<T>()");
        AssertionsKt.assertEquals$default((Object)TypeIdentifier.Companion.forGenericType$default((TypeIdentifier.Companion)companion, (Type)type10, null, (int)2, null), (Object)AMQPTypeIdentifierParser.INSTANCE.parse(typeString$iv), null, (int)4, null);
        this_$iv = this;
        typeString$iv = "string[][]";
        this_$iv$iv = this_$iv;
        companion = TypeIdentifier.Companion;
        Type type11 = type2 = new TypeToken<String[][]>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type11, (String)"typeOf<T>()");
        AssertionsKt.assertEquals$default((Object)TypeIdentifier.Companion.forGenericType$default((TypeIdentifier.Companion)companion, (Type)type11, null, (int)2, null), (Object)AMQPTypeIdentifierParser.INSTANCE.parse(typeString$iv), null, (int)4, null);
        this_$iv = this;
        typeString$iv = "uuid";
        this_$iv$iv = this_$iv;
        companion = TypeIdentifier.Companion;
        Type type12 = type2 = new TypeToken<UUID>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type12, (String)"typeOf<T>()");
        AssertionsKt.assertEquals$default((Object)TypeIdentifier.Companion.forGenericType$default((TypeIdentifier.Companion)companion, (Type)type12, null, (int)2, null), (Object)AMQPTypeIdentifierParser.INSTANCE.parse(typeString$iv), null, (int)4, null);
        this_$iv = this;
        typeString$iv = "timestamp";
        this_$iv$iv = this_$iv;
        companion = TypeIdentifier.Companion;
        Type type13 = type2 = new TypeToken<Date>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type13, (String)"typeOf<T>()");
        AssertionsKt.assertEquals$default((Object)TypeIdentifier.Companion.forGenericType$default((TypeIdentifier.Companion)companion, (Type)type13, null, (int)2, null), (Object)AMQPTypeIdentifierParser.INSTANCE.parse(typeString$iv), null, (int)4, null);
        Function0 function0 = primitives and arrays.1.INSTANCE;
        object = null;
        AssertionsKt.assertFailsWith((KClass)Reflection.getOrCreateKotlinClass(IllegalTypeNameParserStateException.class), (String)object, (Function0)function0);
    }

    @Test(timeout=300000L)
    public final void unparameterised types() {
        Type type2;
        AMQPTypeIdentifierParserTests this_$iv;
        AMQPTypeIdentifierParserTests aMQPTypeIdentifierParserTests = this;
        String typeString$iv = "java.time.LocalDateTime";
        void var3_3 = this_$iv;
        TypeIdentifier.Companion companion = TypeIdentifier.Companion;
        Type type3 = type2 = new TypeToken<LocalDateTime>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"typeOf<T>()");
        AssertionsKt.assertEquals$default((Object)TypeIdentifier.Companion.forGenericType$default((TypeIdentifier.Companion)companion, (Type)type3, null, (int)2, null), (Object)AMQPTypeIdentifierParser.INSTANCE.parse(typeString$iv), null, (int)4, null);
        this_$iv = this;
        typeString$iv = "java.time.LocalDateTime[]";
        AMQPTypeIdentifierParserTests this_$iv$iv = this_$iv;
        companion = TypeIdentifier.Companion;
        Type type4 = type2 = new TypeToken<LocalDateTime[]>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type4, (String)"typeOf<T>()");
        AssertionsKt.assertEquals$default((Object)TypeIdentifier.Companion.forGenericType$default((TypeIdentifier.Companion)companion, (Type)type4, null, (int)2, null), (Object)AMQPTypeIdentifierParser.INSTANCE.parse(typeString$iv), null, (int)4, null);
        this_$iv = this;
        typeString$iv = "java.time.LocalDateTime[][]";
        this_$iv$iv = this_$iv;
        companion = TypeIdentifier.Companion;
        Type type5 = type2 = new TypeToken<LocalDateTime[][]>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type5, (String)"typeOf<T>()");
        AssertionsKt.assertEquals$default((Object)TypeIdentifier.Companion.forGenericType$default((TypeIdentifier.Companion)companion, (Type)type5, null, (int)2, null), (Object)AMQPTypeIdentifierParser.INSTANCE.parse(typeString$iv), null, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=300000L)
    public final void parameterised types, nested, with arrays() {
        Type type2;
        void this_$iv;
        Object object = this;
        String expectedIdentifierPrettyPrint$iv = "WithParameters<int[], WithParameter<WithParameters<Date[][], UUID>[]>>";
        void var3_3 = this_$iv;
        void var4_4 = this_$iv;
        Type type3 = type2 = new TypeToken<WithParameters<int[], WithParameter<WithParameters<Date[][], UUID>[]>>>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"typeOf<T>()");
        ((AMQPTypeIdentifierParserTests)var4_4).assertParsesTo(type3, expectedIdentifierPrettyPrint$iv);
        Function0 function0 = parameterised types, nested, with arrays.1.INSTANCE;
        object = null;
        AssertionsKt.assertFailsWith((KClass)Reflection.getOrCreateKotlinClass(IllegalTypeNameParserStateException.class), (String)object, (Function0)function0);
    }

    @Test(timeout=300000L)
    public final void compatibility test() {
        Type $i$f$typeOf;
        AMQPTypeIdentifierParserTests this_$iv;
        AMQPTypeIdentifierParserTests this_$iv$iv = this_$iv = this;
        AMQPTypeIdentifierParserTests aMQPTypeIdentifierParserTests = this_$iv;
        Object object = new TypeToken<Integer>(){}.getType();
        Type type2 = object;
        Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"typeOf<T>()");
        aMQPTypeIdentifierParserTests.assertParsesCompatibly(type2);
        this_$iv$iv = this_$iv = this;
        aMQPTypeIdentifierParserTests = this_$iv;
        object = new TypeToken<int[]>(){}.getType();
        Type type3 = object;
        Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"typeOf<T>()");
        aMQPTypeIdentifierParserTests.assertParsesCompatibly(type3);
        this_$iv$iv = this_$iv = this;
        aMQPTypeIdentifierParserTests = this_$iv;
        object = new TypeToken<Integer[]>(){}.getType();
        Type type4 = object;
        Intrinsics.checkExpressionValueIsNotNull((Object)type4, (String)"typeOf<T>()");
        aMQPTypeIdentifierParserTests.assertParsesCompatibly(type4);
        this_$iv$iv = this_$iv = this;
        aMQPTypeIdentifierParserTests = this_$iv;
        object = new TypeToken<List<? extends Integer>>(){}.getType();
        Type type5 = object;
        Intrinsics.checkExpressionValueIsNotNull((Object)type5, (String)"typeOf<T>()");
        aMQPTypeIdentifierParserTests.assertParsesCompatibly(type5);
        this_$iv = this;
        String expectedIdentifierPrettyPrint$iv = "WithParameter<Object>";
        aMQPTypeIdentifierParserTests = this_$iv;
        object = this_$iv;
        Type type6 = $i$f$typeOf = new TypeToken<WithParameter<? extends Object>>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type6, (String)"typeOf<T>()");
        ((AMQPTypeIdentifierParserTests)object).assertParsesTo(type6, expectedIdentifierPrettyPrint$iv);
        this_$iv$iv = this_$iv = this;
        aMQPTypeIdentifierParserTests = this_$iv;
        Object object2 = object = new TypeToken<WithParameter<Integer>>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"typeOf<T>()");
        aMQPTypeIdentifierParserTests.assertParsesCompatibly((Type)object2);
        this_$iv$iv = this_$iv = this;
        aMQPTypeIdentifierParserTests = this_$iv;
        Object object3 = object = new TypeToken<WithParameter<Integer>[]>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"typeOf<T>()");
        aMQPTypeIdentifierParserTests.assertParsesCompatibly((Type)object3);
        this_$iv$iv = this_$iv = this;
        aMQPTypeIdentifierParserTests = this_$iv;
        Object object4 = object = new TypeToken<WithParameters<int[], WithParameter<WithParameters<Date[][], UUID>[]>>>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"typeOf<T>()");
        aMQPTypeIdentifierParserTests.assertParsesCompatibly((Type)object4);
    }

    @Test(timeout=300000L)
    public final void test nested() {
        this.verify(" java.util.Map < java.util.Map< java.lang.String, java.lang.Integer >, java.util.Map < java.lang.Long , java.lang.String > >");
    }

    @Test(timeout=300000L)
    public final void test simple() {
        this.verify("java.util.List<java.lang.String>");
    }

    @Test(timeout=300000L)
    public final void test multiple args() {
        this.verify("java.util.Map<java.lang.String,java.lang.Integer>");
    }

    @Test(timeout=300000L)
    public final void test trailing whitespace() {
        this.verify("java.util.Map<java.lang.String, java.lang.Integer> ");
    }

    @Test(timeout=300000L)
    public final void test list of commands() {
        this.verify("java.util.List<net.corda.core.contracts.Command<net.corda.core.contracts.Command<net.corda.core.contracts.CommandData>>>");
    }

    @Test(expected=NotSerializableException.class, timeout=300000L)
    public final void test trailing text() {
        this.verify("java.util.Map<java.lang.String, java.lang.Integer>foo");
    }

    @Test(expected=NotSerializableException.class, timeout=300000L)
    public final void test trailing comma() {
        this.verify("java.util.Map<java.lang.String, java.lang.Integer,>");
    }

    @Test(expected=NotSerializableException.class, timeout=300000L)
    public final void test leading comma() {
        this.verify("java.util.Map<,java.lang.String, java.lang.Integer>");
    }

    @Test(expected=NotSerializableException.class, timeout=300000L)
    public final void test middle comma() {
        this.verify("java.util.Map<,java.lang.String,, java.lang.Integer>");
    }

    @Test(expected=NotSerializableException.class, timeout=300000L)
    public final void test trailing close() {
        this.verify("java.util.Map<java.lang.String, java.lang.Integer>>");
    }

    @Test(expected=NotSerializableException.class, timeout=300000L)
    public final void test empty params() {
        this.verify("java.util.Map<>");
    }

    @Test(expected=NotSerializableException.class, timeout=300000L)
    public final void test mid whitespace() {
        this.verify("java.u til.List<java.lang.String>");
    }

    @Test(expected=NotSerializableException.class, timeout=300000L)
    public final void test mid whitespace2() {
        this.verify("java.util.List<java.l ng.String>");
    }

    @Test(expected=NotSerializableException.class, timeout=300000L)
    public final void test wrong number of parameters() {
        this.verify("java.util.List<java.lang.String, java.lang.Integer>");
    }

    @Test(timeout=300000L)
    public final void test no parameters() {
        this.verify("java.lang.String");
    }

    @Test(expected=NotSerializableException.class, timeout=300000L)
    public final void test parameters on non-generic type() {
        this.verify("java.lang.String<java.lang.Integer>");
    }

    /*
     * WARNING - void declaration
     */
    @Test(expected=NotSerializableException.class, timeout=300000L)
    public final void test excessive nesting() {
        String nested = "java.lang.Integer";
        int n = 1;
        int n2 = 32;
        while (n <= n2) {
            void i2;
            nested = "java.util.List<" + nested + '>';
            ++i2;
        }
        this.verify(nested);
    }

    private final <T> void assertParseResult(String typeString) {
        Type type2;
        AMQPTypeIdentifierParserTests aMQPTypeIdentifierParserTests = this;
        TypeIdentifier.Companion companion = TypeIdentifier.Companion;
        Intrinsics.needClassReification();
        Type type3 = type2 = new TypeToken<T>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"typeOf<T>()");
        AssertionsKt.assertEquals$default((Object)TypeIdentifier.Companion.forGenericType$default((TypeIdentifier.Companion)companion, (Type)type3, null, (int)2, null), (Object)AMQPTypeIdentifierParser.INSTANCE.parse(typeString), null, (int)4, null);
    }

    private final <T> Type typeOf() {
        Intrinsics.needClassReification();
        return new TypeToken<T>(){}.getType();
    }

    private final <T> void assertParsesCompatibly() {
        Type type2;
        AMQPTypeIdentifierParserTests aMQPTypeIdentifierParserTests = this;
        AMQPTypeIdentifierParserTests aMQPTypeIdentifierParserTests2 = this;
        Intrinsics.needClassReification();
        Type type3 = type2 = new TypeToken<T>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"typeOf<T>()");
        aMQPTypeIdentifierParserTests2.assertParsesCompatibly(type3);
    }

    private final void assertParsesCompatibly(Type type2) {
        this.assertParsesTo(type2, TypeIdentifier.prettyPrint$default((TypeIdentifier)TypeIdentifier.Companion.forGenericType$default((TypeIdentifier.Companion)TypeIdentifier.Companion, (Type)type2, null, (int)2, null), (boolean)false, (int)1, null));
    }

    private final <T> void assertParsesTo(String expectedIdentifierPrettyPrint) {
        Type type2;
        AMQPTypeIdentifierParserTests aMQPTypeIdentifierParserTests = this;
        AMQPTypeIdentifierParserTests aMQPTypeIdentifierParserTests2 = this;
        Intrinsics.needClassReification();
        Type type3 = type2 = new TypeToken<T>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"typeOf<T>()");
        aMQPTypeIdentifierParserTests2.assertParsesTo(type3, expectedIdentifierPrettyPrint);
    }

    private final void assertParsesTo(Type type2, String expectedIdentifierPrettyPrint) {
        String nameForType = AMQPTypeIdentifiers.INSTANCE.nameForType(type2);
        TypeIdentifier parsedIdentifier = AMQPTypeIdentifierParser.INSTANCE.parse(nameForType);
        AssertionsKt.assertEquals$default((Object)expectedIdentifierPrettyPrint, (Object)TypeIdentifier.prettyPrint$default((TypeIdentifier)parsedIdentifier, (boolean)false, (int)1, null), null, (int)4, null);
    }

    private final String normalise(String string) {
        return StringsKt.replace$default((String)string, (String)" ", (String)"", (boolean)false, (int)4, null);
    }

    private final void verify(String typeName) {
        Type type2 = TypeIdentifier.getLocalType$default((TypeIdentifier)AMQPTypeIdentifierParser.INSTANCE.parse(typeName), null, (int)1, null);
        String string = this.normalise(typeName);
        String string2 = type2.getTypeName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"type.typeName");
        AssertionsKt.assertEquals$default((Object)string, (Object)this.normalise(string2), null, (int)4, null);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\bf\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002R\u0012\u0010\u0003\u001a\u00028\u0000X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lnet/corda/serialization/internal/amqp/AMQPTypeIdentifierParserTests$WithParameter;", "T", "", "value", "getValue", "()Ljava/lang/Object;", "serialization"})
    public static interface WithParameter<T> {
        public T getValue();
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003R\u001a\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00050\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lnet/corda/serialization/internal/amqp/AMQPTypeIdentifierParserTests$WithParameters;", "P", "Q", "", "p", "", "getP", "()[Ljava/lang/Object;", "q", "Lnet/corda/serialization/internal/amqp/AMQPTypeIdentifierParserTests$WithParameter;", "getQ", "()Lnet/corda/serialization/internal/amqp/AMQPTypeIdentifierParserTests$WithParameter;", "serialization"})
    public static interface WithParameters<P, Q> {
        @NotNull
        public P[] getP();

        @NotNull
        public WithParameter<Q[]> getQ();
    }
}

