/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.routes;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.codestory.http.Context;
import net.codestory.http.compilers.CacheEntry;
import net.codestory.http.compilers.Compilers;
import net.codestory.http.io.Resources;
import net.codestory.http.io.Strings;
import net.codestory.http.payload.Payload;
import net.codestory.http.routes.Route;
import net.codestory.http.types.ContentTypes;

class SourceMapRoute
implements Route {
    SourceMapRoute() {
    }

    @Override
    public boolean matchUri(String uri) {
        return uri.endsWith(".map") && Resources.isPublic(SourceMapRoute.pathSource(uri));
    }

    @Override
    public boolean matchMethod(String method) {
        return "GET".equalsIgnoreCase(method) || "HEAD".equalsIgnoreCase(method);
    }

    @Override
    public Payload body(Context context) throws IOException {
        String uri = context.uri();
        Path sourcePath = SourceMapRoute.pathSource(uri);
        Path mapPath = Paths.get(uri, new String[0]);
        String contentType = ContentTypes.get(mapPath);
        String source = Resources.read(sourcePath, StandardCharsets.UTF_8);
        CacheEntry map = Compilers.INSTANCE.compile(mapPath, source);
        return new Payload(contentType, map);
    }

    private static Path pathSource(String uri) {
        return Paths.get(Strings.substringBeforeLast(uri, ".map"), new String[0]);
    }
}

