/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.compilers;

import com.github.sommeri.less4j.Less4jException;
import com.github.sommeri.less4j.LessCompiler;
import com.github.sommeri.less4j.LessSource;
import com.github.sommeri.less4j.core.ThreadUnsafeLessCompiler;
import java.nio.file.Path;
import net.codestory.http.compilers.Compiler;
import net.codestory.http.compilers.CompilerException;
import net.codestory.http.compilers.PathSource;
import net.codestory.http.misc.Env;

public class LessCompiler
implements Compiler {
    @Override
    public String compile(Path path, String source) {
        try {
            LessCompiler.Configuration configuration = new LessCompiler.Configuration();
            configuration.setLinkSourceMap(false);
            String css = new ThreadUnsafeLessCompiler().compile((LessSource)new PathSource(path, source), configuration).getCss();
            if (new Env().prodMode()) {
                return css;
            }
            return LessCompiler.addSourceMapping(css, path);
        }
        catch (Less4jException e) {
            String message = LessCompiler.cleanMessage(path, e.getMessage());
            throw new CompilerException(message);
        }
    }

    private static String addSourceMapping(String css, Path path) {
        return css + "/*# sourceMappingURL=" + path.getFileName() + ".map */";
    }

    private static String cleanMessage(Path path, String message) {
        return "Unable to compile less " + path + ": " + message.replace("Could not compile less. ", "");
    }
}

