/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.compilers;

import java.nio.file.Path;
import net.codestory.http.compilers.Compiler;
import net.codestory.http.compilers.NashornCompiler;
import net.codestory.http.misc.Env;

public class CoffeeCompiler
implements Compiler {
    private final NashornCompiler nashornCompiler = new NashornCompiler("META-INF/resources/webjars/coffee-script/1.7.1/coffee-script.min.js", "coffee-script/toJs.js");

    @Override
    public String compile(Path path, String source) {
        String javascript = this.nashornCompiler.compile(path, source);
        if (new Env().prodMode()) {
            return javascript;
        }
        return CoffeeCompiler.addSourceMapping(javascript, path);
    }

    private static String addSourceMapping(String javascript, Path path) {
        return javascript + "\n//# sourceMappingURL=" + path.getFileName() + ".map";
    }
}

