/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.compilers;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;

public interface CacheEntry
extends Serializable {
    public String content();

    public byte[] toBytes();

    public static CacheEntry fromFile(File file) throws IOException {
        final byte[] data = Files.readAllBytes(file.toPath());
        return new CacheEntry(){

            @Override
            public String content() {
                return new String(data, StandardCharsets.UTF_8);
            }

            @Override
            public byte[] toBytes() {
                return data;
            }
        };
    }

    public static CacheEntry fromString(final String content) {
        return new CacheEntry(){

            @Override
            public String content() {
                return content;
            }

            @Override
            public byte[] toBytes() {
                return content.getBytes(StandardCharsets.UTF_8);
            }
        };
    }

    public static CacheEntry noCache(final String content) {
        return new CacheEntry(){

            @Override
            public String content() {
                return content;
            }

            @Override
            public byte[] toBytes() {
                return content.getBytes(StandardCharsets.UTF_8);
            }
        };
    }
}

