/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.security;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.codestory.http.security.User;
import net.codestory.http.security.Users;

public class UsersList
implements Users {
    private final Map<String, User> usersByLogin;
    private final Map<String, String> passwordsByLogin;

    private UsersList(Map<String, User> usersByLogin, Map<String, String> passwordsByLogin) {
        this.usersByLogin = usersByLogin;
        this.passwordsByLogin = passwordsByLogin;
    }

    @Override
    public User find(String login, String password) {
        if (Objects.equals(password, this.passwordsByLogin.get(login))) {
            return this.usersByLogin.get(login);
        }
        return null;
    }

    @Override
    public User find(String login) {
        return this.usersByLogin.get(login);
    }

    public static class Builder {
        private final Map<String, User> usersByLogin = new HashMap<String, User>();
        private final Map<String, String> passwordsByLogin = new HashMap<String, String>();

        public Builder addUser(String login, String password, String ... roles) {
            this.usersByLogin.put(login, User.forLoginAndRoles(login, roles));
            this.passwordsByLogin.put(login, password);
            return this;
        }

        public UsersList build() {
            return new UsersList(this.usersByLogin, this.passwordsByLogin);
        }
    }
}

