/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.routes;

import java.nio.file.Path;
import java.nio.file.Paths;
import net.codestory.http.Context;
import net.codestory.http.io.Resources;
import net.codestory.http.io.Strings;
import net.codestory.http.routes.Route;

class SourceRoute
implements Route {
    private final Resources resources;

    SourceRoute(Resources resources) {
        this.resources = resources;
    }

    @Override
    public boolean matchUri(String uri) {
        return uri.endsWith(".source") && this.resources.isPublic(SourceRoute.getSourcePath(uri));
    }

    @Override
    public boolean matchMethod(String method) {
        return "GET".equalsIgnoreCase(method) || "HEAD".equalsIgnoreCase(method);
    }

    @Override
    public Path body(Context context) {
        return SourceRoute.getSourcePath(context.uri());
    }

    private static Path getSourcePath(String uri) {
        return Paths.get(Strings.substringBeforeLast(uri, ".source"), new String[0]);
    }
}

