/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.reload;

import java.util.concurrent.atomic.AtomicBoolean;
import net.codestory.http.Configuration;
import net.codestory.http.logs.Logs;
import net.codestory.http.misc.Env;
import net.codestory.http.reload.MultiFolderWatcher;
import net.codestory.http.reload.RoutesProvider;
import net.codestory.http.routes.RouteCollection;

class ReloadingRoutesProvider
implements RoutesProvider {
    private final Env env;
    private final Configuration configuration;
    private final AtomicBoolean dirty;
    private MultiFolderWatcher fileWatcher;
    private RouteCollection routes;

    ReloadingRoutesProvider(Env env, Configuration configuration) {
        this.env = env;
        this.configuration = configuration;
        this.dirty = new AtomicBoolean(true);
    }

    @Override
    public synchronized RouteCollection get() {
        if (this.dirty.get()) {
            Logs.reloadingConfiguration();
            this.routes = new RouteCollection(this.env);
            try {
                this.routes.configure(this.configuration);
                if (this.fileWatcher == null) {
                    this.fileWatcher = new MultiFolderWatcher(this.env.foldersToWatch(), () -> this.dirty.set(true));
                }
                this.fileWatcher.ensureStarted();
            }
            catch (Exception e) {
                Logs.unableToConfigureRoutes(e);
            }
            this.dirty.set(false);
        }
        return this.routes;
    }
}

