/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.io;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import net.codestory.http.io.ClassPaths;

public class ClasspathScanner {
    public Set<String> getResources(Path root) {
        String prefix = root.toString();
        LinkedHashSet<String> resources = new LinkedHashSet<String>();
        for (URL url : ClasspathScanner.urls(prefix)) {
            for (String rawPath : ClassPaths.fromURL(url)) {
                String path = rawPath.replace('\\', '/');
                if (!path.startsWith(prefix) || path.endsWith(".class")) continue;
                resources.add(path);
            }
        }
        return resources;
    }

    private static Set<URL> urls(String name) {
        LinkedHashSet<URL> result = new LinkedHashSet<URL>();
        try {
            Enumeration<URL> urls = ClasspathScanner.class.getClassLoader().getResources(name);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                String externalForm = url.toExternalForm().replace('\\', '/');
                int index = externalForm.lastIndexOf(name);
                if (index != -1) {
                    result.add(new URL(externalForm.substring(0, index)));
                    continue;
                }
                result.add(url);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }
}

