/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.compilers;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.codestory.http.compilers.CacheEntry;
import net.codestory.http.compilers.CoffeeCompiler;
import net.codestory.http.compilers.CoffeeSourceMapCompiler;
import net.codestory.http.compilers.Compiler;
import net.codestory.http.compilers.DiskCache;
import net.codestory.http.compilers.LessCompiler;
import net.codestory.http.compilers.SourceFile;
import net.codestory.http.io.Resources;
import net.codestory.http.misc.Env;
import net.codestory.http.misc.MemoizingSupplier;
import net.codestory.http.misc.Sha1;

public class Compilers {
    private final DiskCache diskCache;
    private final Map<String, Supplier<Compiler>> compilerByExtension = new HashMap<String, Supplier<Compiler>>();
    private final Map<String, Set<String>> extensionsThatCompileTo = new HashMap<String, Set<String>>();
    private final Map<String, String> compiledExtensions = new HashMap<String, String>();
    private final Map<String, CacheEntry> cache = new ConcurrentHashMap<String, CacheEntry>();

    public Compilers(Env env, Resources resources) {
        boolean prodMode = env.prodMode();
        this.diskCache = new DiskCache("V6", prodMode);
        this.register(() -> new LessCompiler(resources, prodMode), ".css", ".less");
        this.register(() -> new CoffeeCompiler(prodMode), ".js", ".coffee");
        this.register(() -> new CoffeeCompiler(prodMode), ".js", ".litcoffee");
        if (!prodMode) {
            this.register(() -> new CoffeeSourceMapCompiler(), ".coffee.map", ".coffee.map");
            this.register(() -> new CoffeeSourceMapCompiler(), ".litcoffee.map", ".litcoffee.map");
        }
    }

    public void register(Supplier<Compiler> compilerFactory, String compiledExtension, String sourceExtension) {
        Supplier<Compiler> compilerLazyFactory = MemoizingSupplier.memoize(compilerFactory);
        this.compilerByExtension.put(sourceExtension, compilerLazyFactory);
        this.compiledExtensions.put(sourceExtension, compiledExtension);
        this.extensionsThatCompileTo.computeIfAbsent(compiledExtension, k -> new HashSet()).add(sourceExtension);
    }

    public boolean canCompile(String extension) {
        return this.compilerByExtension.containsKey(extension);
    }

    public Set<String> extensionsThatCompileTo(String extension) {
        return this.extensionsThatCompileTo.getOrDefault(extension, Collections.emptySet());
    }

    public String compiledExtension(String extension) {
        return this.compiledExtensions.get(extension);
    }

    public CacheEntry compile(SourceFile sourceFile) {
        String key = sourceFile.getFileName() + ';' + sourceFile.getSource();
        return this.cache.computeIfAbsent(key, ignore -> {
            for (Map.Entry<String, Supplier<Compiler>> entry : this.compilerByExtension.entrySet()) {
                String extension = entry.getKey();
                if (!sourceFile.hasExtension(extension)) continue;
                Supplier<Compiler> compiler = entry.getValue();
                if (".less".equals(extension) && sourceFile.getSource().contains("@import")) {
                    return CacheEntry.noCache(compiler.get().compile(sourceFile));
                }
                String sha1 = Sha1.of(key);
                return this.diskCache.computeIfAbsent(sha1, extension, () -> ((Compiler)compiler.get()).compile(sourceFile));
            }
            throw new IllegalArgumentException("Unable to compile " + sourceFile.getFileName() + ". Unknown extension");
        });
    }
}

