/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http;

import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import net.codestory.http.Cookies;
import net.codestory.http.Part;
import net.codestory.http.Query;
import net.codestory.http.Request;
import net.codestory.http.Response;
import net.codestory.http.injection.IocAdapter;
import net.codestory.http.misc.Env;
import net.codestory.http.security.User;
import net.codestory.http.templating.Site;

public class Context {
    private final Request request;
    private final Response response;
    private final IocAdapter iocAdapter;
    private final Env env;
    private final Site site;
    private User currentUser;

    public Context(Request request, Response response, IocAdapter iocAdapter, Env env, Site site) {
        this.request = request;
        this.response = response;
        this.iocAdapter = iocAdapter;
        this.env = env;
        this.site = site;
    }

    public Request request() {
        return this.request;
    }

    public Response response() {
        return this.response;
    }

    public Env env() {
        return this.env;
    }

    public Site site() {
        return this.site;
    }

    public String uri() {
        return this.request.uri();
    }

    public Cookies cookies() {
        return this.request.cookies();
    }

    public List<Part> parts() {
        return this.request.parts();
    }

    public Query query() {
        return this.request.query();
    }

    public String get(String key) {
        return this.request.query().get(key);
    }

    public String header(String name) {
        return this.request.header(name);
    }

    public List<String> headers(String name) {
        return this.request.headers(name);
    }

    public String method() {
        return this.request.method();
    }

    public <T> T getBean(Class<T> type) {
        return this.iocAdapter.get(type);
    }

    public void setCurrentUser(User user) {
        this.currentUser = user;
    }

    public User currentUser() {
        return this.currentUser;
    }

    public <T> T extract(Class<T> type) throws IOException {
        return (T)this.extract((Type)type);
    }

    public Object extract(Type type) throws IOException {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz.isAssignableFrom(Context.class)) {
                return this;
            }
            if (clazz.isAssignableFrom(Request.class)) {
                return this.request;
            }
            if (clazz.isAssignableFrom(Response.class)) {
                return this.response;
            }
            if (clazz.isAssignableFrom(Cookies.class)) {
                return this.cookies();
            }
            if (clazz.isAssignableFrom(Query.class)) {
                return this.query();
            }
            if (clazz.isAssignableFrom(User.class)) {
                return this.currentUser;
            }
            if (clazz.isAssignableFrom(byte[].class)) {
                return this.request.contentAsBytes();
            }
            if (clazz.isAssignableFrom(String.class)) {
                return this.request.content();
            }
            if (clazz.isAssignableFrom(Site.class)) {
                return this.site;
            }
        }
        if (type instanceof ParameterizedType) {
            if (Context.isListOfParts((ParameterizedType)type)) {
                return this.parts();
            }
            if (Context.isGenericMap((ParameterizedType)type)) {
                return this.query().keyValues();
            }
        }
        return this.request().contentAs(type);
    }

    private static boolean isListOfParts(ParameterizedType type) {
        Type rawType = type.getRawType();
        if (!(rawType instanceof Class) || !List.class.isAssignableFrom((Class)rawType)) {
            return false;
        }
        Type[] actualTypeArguments = type.getActualTypeArguments();
        if (actualTypeArguments.length != 1) {
            return false;
        }
        Type argument = actualTypeArguments[0];
        return argument instanceof Class && Part.class.isAssignableFrom((Class)argument);
    }

    private static boolean isGenericMap(ParameterizedType type) {
        Type rawType = type.getRawType();
        return rawType instanceof Class && Map.class.isAssignableFrom((Class)rawType);
    }
}

