/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.routes;

import java.net.URL;
import java.nio.file.Paths;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.stream.Collectors;
import net.codestory.http.Context;
import net.codestory.http.io.ClassPaths;
import net.codestory.http.io.ClasspathScanner;
import net.codestory.http.io.Strings;
import net.codestory.http.logs.Logs;
import net.codestory.http.misc.WebJarUrlFinder;
import net.codestory.http.payload.Payload;
import net.codestory.http.routes.Route;

class WebJarsRoute
implements Route {
    private final boolean prodMode;
    private final WebJarUrlFinder webJarUrlFinder;

    public WebJarsRoute(boolean prodMode) {
        this.prodMode = prodMode;
        this.webJarUrlFinder = new WebJarUrlFinder(prodMode);
    }

    @Override
    public boolean matchUri(String uri) {
        if (!uri.startsWith("/webjars/")) {
            return false;
        }
        if (!uri.endsWith("/") && WebJarsRoute.getResource(uri) != null) {
            return true;
        }
        if (!this.prodMode && uri.endsWith("/")) {
            String wantedUri = Strings.substringBeforeLast(uri, "/");
            this.printKnownWebjars(wantedUri);
        }
        return false;
    }

    private void printKnownWebjars(String wantedUri) {
        String extension = Strings.extension(wantedUri);
        List<String> filteredUris = new ClasspathScanner().getResources(Paths.get("META-INF/resources/webjars", new String[0])).stream().filter(uri -> uri.endsWith(extension)).collect(Collectors.toList());
        if (!filteredUris.isEmpty()) {
            Logs.printKnownWebjars(filteredUris, extension);
        } else {
            Logs.printUnknownWebjar(wantedUri, extension);
        }
    }

    @Override
    public boolean matchMethod(String method) {
        return "GET".equalsIgnoreCase(method) || "HEAD".equalsIgnoreCase(method);
    }

    @Override
    public Payload body(Context context) {
        String uri = context.uri();
        URL url = this.webJarUrlFinder.url(uri);
        return new Payload(url).withHeader("Cache-Control", "public, max-age=31536000").withHeader("Last-Modified", DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.now().minusMonths(1L))).withHeader("Expires", DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.now().plusWeeks(1L)));
    }

    private static URL getResource(String uri) {
        return ClassPaths.getResource("META-INF/resources" + uri);
    }
}

