/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.livereload;

import java.io.IOException;
import java.util.Arrays;
import net.codestory.http.livereload.IncomingHelloMessage;
import net.codestory.http.livereload.OutgoingHelloMessage;
import net.codestory.http.livereload.OutgoingReloadMessage;
import net.codestory.http.misc.Env;
import net.codestory.http.reload.MultiFolderWatcher;
import net.codestory.http.websockets.Frame;
import net.codestory.http.websockets.WebSocketListener;
import net.codestory.http.websockets.WebSocketSession;

public class LiveReloadListener
implements WebSocketListener {
    public static final String VERSION_7 = "http://livereload.com/protocols/official-7";
    private final WebSocketSession session;
    private final MultiFolderWatcher watcher;

    public LiveReloadListener(WebSocketSession session, Env env) {
        this.session = session;
        this.watcher = new MultiFolderWatcher(env.foldersToWatch(), () -> {
            try {
                session.send("TEXT", new OutgoingReloadMessage("path", true));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        this.watcher.ensureStarted();
    }

    @Override
    public void onFrame(Frame frame) throws IOException {
        if (frame.type().equals("TEXT")) {
            IncomingHelloMessage message = frame.as(IncomingHelloMessage.class);
            if (message.command.equals("hello")) {
                if (!message.protocols.contains(VERSION_7)) {
                    this.close();
                    return;
                }
                this.sendHello();
            }
        }
    }

    private void close() throws IOException {
        this.watcher.stop();
        this.session.close();
    }

    private void sendHello() throws IOException {
        this.session.send("TEXT", new OutgoingHelloMessage("Fluent-http", Arrays.asList(VERSION_7)));
    }
}

