/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.templating;

import com.github.jknack.handlebars.ValueResolver;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Supplier;
import net.codestory.http.convert.TypeConvert;
import net.codestory.http.io.ClasspathScanner;
import net.codestory.http.io.FileVisitor;
import net.codestory.http.io.Resources;
import net.codestory.http.io.Strings;
import net.codestory.http.misc.Env;
import net.codestory.http.misc.Fluent;
import net.codestory.http.misc.MemoizingSupplier;
import net.codestory.http.templating.YamlFrontMatter;
import net.codestory.http.templating.YamlParser;

public class Site {
    private final Supplier<Set<String>> resourceList = MemoizingSupplier.memoize(() -> Site.list(new Env()));
    private final Supplier<Map<String, Object>> yaml = MemoizingSupplier.memoize(() -> this.loadYamlConfig("_config.yml"));
    private final Supplier<Map<String, Object>> data = MemoizingSupplier.memoize(() -> Fluent.of((Iterable)this.resourceList.get()).filter(path -> path.startsWith("_data/")).toMap(path -> Site.nameWithoutExtension(path), path -> Site.readYaml(path)));
    private final Supplier<List<Map<String, Object>>> pages = MemoizingSupplier.memoize(() -> Fluent.of((Iterable)this.resourceList.get()).filter(path -> !path.startsWith("_")).map(path -> Site.pathToMap(path)).toList());
    private final Supplier<Map<String, List<Map<String, Object>>>> tags = MemoizingSupplier.memoize(() -> {
        TreeMap<String, List> tags = new TreeMap<String, List>();
        for (Map<String, Object> page : this.getPages()) {
            for (String tag : Site.tags(page)) {
                tags.computeIfAbsent(tag, key -> new ArrayList()).add(page);
            }
        }
        return tags;
    });
    private final Supplier<Map<String, List<Map<String, Object>>>> categories = MemoizingSupplier.memoize(() -> Fluent.of(this.getPages()).groupBy(page -> Site.category(page), TreeMap::new));

    private static Set<String> list(Env env) {
        TreeSet<String> paths = new TreeSet<String>();
        Path rootPath = Resources.appPath();
        try {
            if (Resources.classesOutputPath().toFile().exists() && !env.disableClassPath()) {
                new ClasspathScanner().getResources(Resources.appPath()).forEach(resource -> paths.add(Resources.relativePath(rootPath, Paths.get(resource, new String[0]))));
            }
            if (!env.disableFilesystem()) {
                Files.walkFileTree(rootPath, FileVisitor.onFile(path2 -> paths.add(Resources.relativePath(rootPath, path2))));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        paths.remove("");
        return paths;
    }

    private Map<String, Object> configYaml() {
        return this.yaml.get();
    }

    public Object get(String key) {
        return this.yaml.get().get(key);
    }

    public <T> T getAs(String key, Class<T> type) {
        return TypeConvert.convertValue(this.get(key), type);
    }

    public Map<String, Object> getData() {
        return this.data.get();
    }

    public List<Map<String, Object>> getPages() {
        return this.pages.get();
    }

    public Map<String, List<Map<String, Object>>> getTags() {
        return this.tags.get();
    }

    public Map<String, List<Map<String, Object>>> getCategories() {
        return this.categories.get();
    }

    private static Map<String, Object> pathToMap(String path) {
        try {
            return YamlFrontMatter.parse(Paths.get(path, new String[0])).getVariables();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read file: " + path, e);
        }
    }

    private static Object readYaml(String path) {
        try {
            return YamlParser.INSTANCE.parse(Resources.read(Paths.get(path, new String[0]), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read file: " + path, e);
        }
    }

    private static String category(Map<String, Object> page) {
        return page.getOrDefault("category", "").toString().trim();
    }

    private static String[] tags(Map<String, Object> page) {
        Object tags = page.getOrDefault("tags", "");
        if (tags instanceof List) {
            return ((List)tags).toArray(new String[0]);
        }
        return tags.toString().trim().split("\\s*,\\s*");
    }

    private Map<String, Object> loadYamlConfig(String configFile) {
        Path configPath = Paths.get(configFile, new String[0]);
        if (!Resources.exists(configPath)) {
            return new HashMap<String, Object>();
        }
        try {
            return YamlParser.INSTANCE.parseMap(Resources.read(configPath, StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read " + configFile, e);
        }
    }

    private static String nameWithoutExtension(String path) {
        return Strings.substringBeforeLast(Paths.get(path, new String[0]).getFileName().toString(), ".");
    }

    static enum SiteValueResolver implements ValueResolver
    {
        INSTANCE;


        public Object resolve(Object context, String name) {
            if (context instanceof Site) {
                return ((Site)context).configYaml().getOrDefault(name, UNRESOLVED);
            }
            return UNRESOLVED;
        }

        public Set<Map.Entry<String, Object>> propertySet(Object context) {
            if (context instanceof Site) {
                return ((Site)context).configYaml().entrySet();
            }
            return Collections.emptySet();
        }
    }
}

